unit QMObj;
{$N+}

interface

uses qmath, Objects, Strings;

const
 SignatureQM = $50414D51;
 qmDescription = 0;
 qmCarte       = 1;
 qmPatchQC     = 2;
 qmBSP0        = 3;
 qmTextureDef  = 4;
 qmFileDef     = 5;
 qmTextureLnk  = 6;
 qmFileLnk     = 7;

 mapEntity     = 0;
 mapBrush      = 1;
 mapPoly       = 2;
 mapGroup      = 3;
 mapDuplicator = 4;

 MaxNomEntreeQM = 52;

 VersionCarte  = 1;

 NomWadTmp     = 'gfx/QuakeMap.wad';
 NomMapDefaut  = 'NoName';

type
 TIntroQM = record
             Signature : LongInt;
             PositionRep, TailleRep: LongInt;
            end;
 PEntreeRepQM = ^TEntreeRepQM;
 TEntreeRepQM = record
                 Nom: array[0..MaxNomEntreeQM-1] of Byte;
                 InfoType, Version: Word;
                 Position, Taille: LongInt;
                end;
 PRepertoireQM = ^TRepertoireQM;
 TRepertoireQM = array[0..0] of TEntreeRepQM;

 TNomFichCarte = array[0..7] of Byte;
 PEnteteCarte = ^TEnteteCarte;
 TEnteteCarte = record
                 NomFichMap: TNomFichCarte;
                 Modeles: Boolean;
                end;

type
 TNomTex  = String[23];
 PSurface = ^TSurface;
 TSurface = record
             Normale: TVect;
             Dist: Reel;
             Params: array[1..5] of Reel;
             NomTex: TNomTex;
            end;

const
 TailleSurfDef = SizeOf(TVect)+6*SizeOf(Reel);

var
 SourceFile: PStream;
 TexturesUtilisees: PStringCollection;

function CharToPas(C: array of Byte) : String;
procedure PasToChar(var C: array of Byte; const S: String);
procedure ExtraireMap(var Entree: TEntreeRepQM; const NomFich: String);
function NomFichierCarte(var Entree: TEntreeRepQM; pEntete: PEnteteCarte) : String;

 (************************************************************)

implementation

uses QMUI, QMPak;

function NomFichierCarte(var Entree: TEntreeRepQM; pEntete: PEnteteCarte) : String;
var
 T: LongInt;
 Entete: TEnteteCarte;
 S: String;
begin
 SourceFile^.Seek(Entree.Position);
 SourceFile^.Read(T, SizeOf(T));
 Dec(T, SizeOf(T));
 if T >= SizeOf(Entete) then
  T:=SizeOf(Entete)
 else
  FillChar(Entete, SizeOf(Entete), 0);
 SourceFile^.Read(Entete, T);
 S:=CharToPas(Entete.NomFichMap);
 if S='' then
  NomFichierCarte:=NomMapDefaut
 else
  NomFichierCarte:=S;
 if pEntete<>Nil then
  pEntete^:=Entete;
end;

 (************************************************************)

procedure TreeMapEntity(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapGroup(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapBrush(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapPolyhedron(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapDuplicator(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

 {----------------------}

const
 TreeMapObj : array[mapEntity..mapDuplicator] of
               procedure(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation) =
  (TreeMapEntity, TreeMapBrush, TreeMapPolyhedron, TreeMapGroup, TreeMapDuplicator);

 {----------------------}

var
 RemplaceWad: Boolean;

procedure SauverSpec(var Source: TStream; Dest: PStream; Transf: PTransformation);
var
 Taille: Word;
 Tampon, P: PChar;
 Chaine: String;
 J: Integer;
 F: PTransformation;
 Origin: TVect;
begin
 Source.Read(Taille, SizeOf(Taille));
 GetMem(Tampon, Taille);
 Source.Read(Tampon^, Taille);
 if Dest<>Nil then
  begin
   Chaine:='{'#13#10;
   Dest^.Write(Chaine[1], 3);
   P:=Tampon;
   Chaine:=' "';
   J:=Taille;
   repeat
    while J>0 do
     begin
      case P^ of
       #13, #10 : Chaine:=' "';
       '='      : Break;
       else Chaine:=Chaine+P^;
      end;
      Dec(J);
      Inc(P);
     end;
    if J=0 then Break;
    Chaine:=Chaine+'" "';
    Dec(J);
    Inc(P);
    while (J>0) and not (P^ in [#13, #10]) do
     begin
      Chaine:=Chaine+P^;
      Dec(J);
      Inc(P);
     end;
    if (Transf<>Nil)
    and (CompareText(Copy(Chaine, 2, 8), '"origin"') = 0)
    and LireVecteur(Copy(Chaine, 12, 255), Origin) then
     begin
      F:=Transf;
      while F<>Nil do
       begin
        if F^.ModeDeplacement<>mdDeplacement then
         begin
          Origin.X:=Origin.X-F^.Clic.X;
          Origin.Y:=Origin.Y-F^.Clic.Y;
          Origin.Z:=Origin.Z-F^.Clic.Z;
          AppliqueVecteur(Origin, F);
         end;
        Origin.X:=Origin.X+F^.Clic.X;
        Origin.Y:=Origin.Y+F^.Clic.Y;
        Origin.Z:=Origin.Z+F^.Clic.Z;
        F:=F^.Suivant;
       end;
      Chaine:=' "origin" "' + ftos(Origin.X) + ' ' + ftos(Origin.Y) + ' ' + ftos(Origin.Z);
     end;
    if RemplaceWad and (Copy(Chaine,2,7) = '"wad" "') then
     begin
      Chaine:=' "wad" "'+NomWadTmp;
      RemplaceWad:=False;
     end;
    Chaine:=Chaine+'"'#13#10;
    Dest^.Write(Chaine[1], Length(Chaine));
   until False;
   if RemplaceWad then
    begin
     Chaine:=' "wad" "'+NomWadTmp+'"'#13#10;
     Dest^.Write(Chaine[1], Length(Chaine));
     RemplaceWad:=False;
    end;
  end;
 FreeMem(Tampon, Taille);
end;

procedure TreeMapEntity(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 Chaine: String[5];
begin
 SauverSpec(Source, Dest, Transf);
 Chaine:='}'#13#10;
 Dest^.Write(Chaine[1], 3);
end;

procedure SauverGroupe(var Source: TStream; Dest, Brush: PStream; Transf: PTransformation);
var
 Nombre, I: Word;
 InfoTypes, P: PChar;
 ParentPos: LongInt;
begin
 ParentPos:=Source.GetPos;
 Source.Read(Nombre, SizeOf(Nombre));
 if Nombre>0 then
  begin
   GetMem(InfoTypes, Nombre);
   Source.Read(InfoTypes^, Nombre);
   P:=InfoTypes;
   for I:=1 to Nombre do
    begin
     if Ord(P^) > High(TreeMapObj) then
      Erreur('Invalid datas');
     TreeMapObj[Ord(P^)] (Source, Dest, Brush, ParentPos, Transf);
     Inc(P);
    end;
   FreeMem(InfoTypes, Nombre);
  end;
end;

procedure TreeMapGroup(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
begin
 SauverSpec(Source, Nil, Transf);
 SauverGroupe(Source, Dest, Brush, Transf);
end;

procedure TreeMapBrush(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 D: TMemoryStream;
 Chaine: String[5];
 SizeOfD: LongInt;
begin
 SauverSpec(Source, Dest, Transf);
 D.Init(256,256);
 SauverGroupe(Source, @D, Dest, Transf);
 Chaine:='}'#13#10;
 Dest^.Write(Chaine[1], 3);
 SizeOfD:=D.GetPos;
 D.Position:=0;
 Dest^.CopyFrom(D, SizeOfD);
 D.Done;
end;

procedure TroisPointsDansFace(const S: TSurface; var Pt, Pt2, Pt3: TVect);
const
 EchellePrecision = 512;
var
 V: TVect;
begin
 with S do
  begin
   Pt.X:=Normale.X*Dist;
   Pt.Y:=Normale.Y*Dist;
   Pt.Z:=Normale.Z*Dist;
   if Abs(Normale.Z) > 0.5 then
    begin
     V.X:=0;
     V.Y:=-Normale.Z*EchellePrecision;
     V.Z:=Normale.Y*EchellePrecision;
    end
   else
    begin
     V.X:=-Normale.Y*EchellePrecision;
     V.Y:=Normale.X*EchellePrecision;
     V.Z:=0;
    end;
   Pt2.X:=Pt.X+V.X;
   Pt2.Y:=Pt.Y+V.Y;
   Pt2.Z:=Pt.Z+V.Z;
   Cross(V, Normale, Pt3);
   Pt3.X:=Pt.X+Pt3.X;
   Pt3.Y:=Pt.Y+Pt3.Y;
   Pt3.Z:=Pt.Z+Pt3.Z;
  end;
end;


procedure TreeMapPolyhedron(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 S: String;
 I, J, K: Integer;
 Pts: array[1..3] of TVect;

  function ftos(const X: Reel) : String;
  var
   R: Integer;
   S: String[15];
  begin
   R:=Round(X);
   if Abs(X-R) < rien then
    Str(R, S)
   else
    Str(X:7:5, S);
   ftos:=S;
  end;

var
 NbFaces: Word;
 Face: TSurface;
 Tailles, P: PChar;
 F: PTransformation;
begin
 S:=' {'#13#10;
 Brush^.Write(S[1], 4);
 Source.Read(NbFaces, SizeOf(NbFaces));
 GetMem(Tailles, NbFaces);
 Source.Read(Tailles^, NbFaces);
 P:=Tailles;
 for J:=1 to NbFaces do
  begin
   Source.Read(Face, TailleSurfDef);
   Face.NomTex[0]:=P^;
   Source.Read(Face.NomTex[1], Ord(P^));
   LowerCase(Face.NomTex);
   if not TexturesUtilisees^.Search(@Face.NomTex, K) then
    TexturesUtilisees^.AtInsert(K, NewStr(Face.NomTex));
   F:=Transf;
   while F<>Nil do
    begin
     if F^.ModeDeplacement<>mdDeplacement then
      begin
       Face.Dist:=Face.Dist-Dot(Face.Normale, F^.Clic);
       AppliqueVecteur(Face.Normale, F);
      end;
     Face.Dist:=Face.Dist + Dot(Face.Normale, F^.Clic);
     F:=F^.Suivant;
    end;
   S:='  ';
   TroisPointsDansFace(Face, Pts[1], Pts[2], Pts[3]);
   for I:=1 to 3 do
    with Pts[I] do
     S:=S+'( '+ftos(X)+' '+ftos(Y)+' '+ftos(Z)+' ) ';
   S:=S+Face.NomTex;
   for I:=1 to 5 do
    S:=S+' '+ftos(Face.Params[I]);
   S:=S+#13#10;
   Brush^.Write(S[1], Length(S));
   Inc(P);
  end;
 FreeMem(Tailles, NbFaces);
 S:=' }'#13#10;
 Brush^.Write(S[1], 4);
end;

procedure TreeMapDuplicator(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 Tampon, P, Egal, Fin, InfoTypes: PChar;
 Taille, SousEl, Bidon: Word;
 Angle: Reel;
 Offset, Centre: TVect;
 Code, Count, I, J: Integer;
 CurPos: LongInt;
 F: ^PTransformation;
 Rotation, Deplacement, Sym: PTransformation;
 Symetries: String[7];
begin
 Source.Read(Taille, SizeOf(Taille));
 GetMem(Tampon, Taille+1);
 Source.Read(Tampon^, Taille);
 Tampon[Taille]:=#0;
 P:=Tampon;
 Angle:=0;
 Offset:=Origine;
 Centre:=Origine;
 Count:=1;
 F:=@Transf;
 while F^<>Nil do
  F:=@F^^.Suivant;
 while P^<>#0 do
  begin
   Egal:=StrScan(P, '=');
   if Egal=Nil then Break;
   Fin:=StrScan(Egal+1, #13);
   if Fin=Nil then Fin:=StrEnd(Egal+1);
   Egal^:=#0;
   Fin^:=#0;
   if StrIComp(P, 'angle') = 0 then
    begin
     Val(StrPas(Egal+1), Angle, Code);
     if Code<>0 then
      Angle:=0;
    end
   else
    if StrIComp(P, 'origin') = 0 then
     begin
      if not LireVecteur(StrPas(Egal+1), Centre) then
       Centre:=Origine;
     end
    else
     if StrIComp(P, 'offset') = 0 then
      begin
       if not LireVecteur(StrPas(Egal+1), Offset) then
        Offset:=Origine;
      end
     else
      if StrIComp(P, 'count')=0 then
       begin
        Val(StrPas(Egal+1), Count, Code);
        if Code<>0 then
         Count:=1;
       end
      else
       if StrIComp(P, 'sym')=0 then
        Symetries:=StrPas(Egal+1);
   P:=Fin+1;
   if P^=#10 then
    Inc(P);
  end;
 FreeMem(Tampon, Taille+1);
 if (Offset.X<>0) or (Offset.Y<>0) or (Offset.Z<>0) then
  begin
   New(Deplacement);
   Deplacement^.Suivant:=F^;
   F^:=Deplacement;
   Deplacement^.ModeDeplacement:=mdDeplacement;
  end
 else
  Deplacement:=Nil;
 if Angle<>0 then
  begin
   New(Rotation);
   Rotation^.Suivant:=F^;
   F^:=Rotation;
   Rotation^.ModeDeplacement:=mdRotZ;
   Rotation^.Clic:=Centre;
   Angle:=Angle * (pi/180);
  end
 else
  Rotation:=Nil;
 CurPos:=Source.GetPos;
 Source.Seek(ParentPos);
 Source.Read(SousEl, SizeOf(SousEl));
 if SousEl>0 then
  begin
   GetMem(InfoTypes, SousEl);
   Source.Read(InfoTypes^, SousEl);
   for J:=1 to Count do
    begin
     if Rotation<>Nil then
      begin
       Rotation^.Facteur:=Cos(Angle*J);
       Rotation^.Facteur2:=Sin(Angle*J);
      end;
     if Deplacement<>Nil then
      begin
       Deplacement^.Clic.X:=Offset.X*J;
       Deplacement^.Clic.Y:=Offset.Y*J;
       Deplacement^.Clic.Z:=Offset.Z*J;
      end;
     Sym:=Nil;
     for I:=Length(Symetries) downto 1 do
      if J and (1 shl Pred(I)) <> 0 then
       case Upcase(Symetries[I]) of
        'X': begin
              New(Sym);
              Sym^.Suivant:=F^;
              F^:=Sym;
              Sym^.ModeDeplacement:=mdSymYZ;
              Sym^.Clic:=Centre;
             end;
        'Y': begin
              New(Sym);
              Sym^.Suivant:=F^;
              F^:=Sym;
              Sym^.ModeDeplacement:=mdSymXZ;
              Sym^.Clic:=Centre;
             end;
        'Z': begin
              New(Sym);
              Sym^.Suivant:=F^;
              F^:=Sym;
              Sym^.ModeDeplacement:=mdSymXY;
              Sym^.Clic:=Centre;
             end;
       end;
     Source.Seek(ParentPos + SizeOf(SousEl) + SousEl);
     P:=InfoTypes;
     for I:=1 to SousEl do
      begin
       if Ord(P^) > High(TreeMapObj) then
        Erreur('Invalid datas');
       if Ord(P^) = mapDuplicator then
        begin
         Source.Read(Bidon, SizeOf(Bidon));
         Source.Seek(Source.GetPos + Bidon);
        end
       else
        TreeMapObj[Ord(P^)] (Source, Dest, Brush, -1, Transf);
       Inc(P);
      end;
     while (F^<>Nil) and (F^^.ModeDeplacement in [mdSymXY, mdSymXZ, mdSymYZ]) do
      begin
       Sym:=F^^.Suivant;
       Dispose(F^);
       F^:=Sym;
      end;
    end;
   FreeMem(InfoTypes, SousEl);
  end;
 Source.Seek(CurPos);
 if Deplacement<>Nil then
  Dispose(Deplacement);
 if Rotation<>Nil then
  Dispose(Rotation);
 F^:=Nil;
end;

 (************************************************************)

procedure ExtraireMap(var Entree: TEntreeRepQM; const NomFich: String);
var
 Donnees: LongInt;
 Fich: PBufStream;
begin
 SourceFile^.Seek(Entree.Position);
 SourceFile^.Read(Donnees, SizeOf(Donnees));
 SourceFile^.Seek(Entree.Position+Donnees);
 New(Fich, Init(NomFich, stCreate, 1024));
 RemplaceWad:=True;
 TreeMapBrush(SourceFile^, Fich, Nil, 0, Nil);
 Dispose(Fich, Done);
end;

 (************************************************************)

function CharToPas(C: array of Byte) : String;
var
 I: Integer;
 S: String;
begin
 I:=0;
 while (I<=High(C)) and (C[I]<>0) do
  Inc(I);
 S[0]:=Chr(I);
 Move(C, S[1], I);
 CharToPas:=S;
end;

procedure PasToChar(var C: array of Byte; const S: String);
begin
 if Length(S) <= High(C) then
  begin
   Move(S[1], C, Length(S));
   FillChar(C[Length(S)], High(C)+1-Length(S), 0);
  end
 else
  Move(S[1], C, High(C)+1);
end;

end.