#!/usr/local/bin/python
import os, string, regex, sys

def movebefore(list, a, b):
	l=list[:]
	if not a in l or not b in l: return l
	ap = l.index(a)
	bp = l.index(b)
	if ap<bp: return l
	del l[ap]
	l[bp:bp]=[a]
	return l
	
# Builtin quakec files, always present
builtin_qc = (
	"builtin/defs.qc", "builtin/subs.qc", "builtin/fight.qc",
	"builtin/ai.qc", "builtin/combat.qc", "builtin/items.qc",
	"builtin/weapons.qc", "builtin/world.qc", "builtin/client.qc",
	"builtin/player.qc", "builtin/monsters.qc", "builtin/doors.qc",
	"builtin/buttons.qc", "builtin/triggers.qc", "builtin/plats.qc",
	"builtin/misc.qc", "builtin/ogre.qc", "builtin/demon.qc",
	"builtin/shambler.qc", "builtin/knight.qc", "builtin/soldier.qc",
	"builtin/wizard.qc", "builtin/dog.qc", "builtin/zombie.qc",
	"builtin/boss.qc", "builtin/tarbaby.qc", "builtin/hknight.qc",
	"builtin/fish.qc", "builtin/shalrath.qc", "builtin/enforcer.qc",
	"builtin/oldone.qc", "builtin/morph.qc"
)

#builtin_qc = (
#	"builtin/defs.qc", "builtin/subs.qc", "builtin/fight.qc",
#	"builtin/ai.qc", "builtin/combat.qc", "builtin/items.qc",
#	"builtin/weapons.qc", "builtin/world.qc", "builtin/client.qc",
#	"builtin/player.qc", "builtin/monsters.qc", "builtin/doors.qc",
#	"builtin/buttons.qc", "builtin/triggers.qc", "builtin/plats.qc",
#	"builtin/misc.qc", "builtin/boss.qc", "builtin/oldone.qc",
#	"builtin/morph.qc"
#)

#ignore these files
ignore_qc = (
	"_qcustom.qc", "builtin/sprites.qc", "builtin/models.qc"
)

our_re = regex.compile(
	"^[\t ]*//+[\t ]*\(flag\|think\|start\|require\|file\|precache\|impulse[0-9]*\|object\)[\t ]+"+
	"\([-.a-zA-Z0-9_/]+\)"+
	"\([\t ]*\(.+\)\)?"
)

extra_qc = []
impulses = []
precaches = []
requires = []
objects = []
needfiles = []
items = []
starts = []
flags = []

def listdir(where='.', all=0):
	names = os.listdir(where)
	files = []
	dirs = []
	for l in names:
		if l[0]=='.' and not all: continue
		if (where!='.'): l=os.path.join(where, l)
		if os.path.isdir(l): dirs.append(l)
		else: files.append(l)
	return files, dirs

def getallfiles(args, recursive=0):
	if args == []: return []
	allfiles = []
	for dir in args:
		f, d=listdir(dir)
		if recursive:
			f=f+getallfiles(d)
		for name in f:
			if not name in allfiles: allfiles.append(name)
	return allfiles

recursive=0
args=sys.argv[1:]
if len(args) and args[0] == '-r':
	recursive = 1
	del args[0]
if not len(args): files=getallfiles('.', recursive)
else: files = getallfiles(args, recursive)

for file in files:
	if (file[-3:] == '.qc') and not (
		(file in builtin_qc) or
		(file in ignore_qc) or
		(file[-7:] == 'test.qc')) :
			extra_qc.append(file)

extra_qc.sort();

for n in range(len(extra_qc)):
	file = extra_qc[n]
	f=open(file, "r")
	filecontents = f.readlines()
	f.close()
	for line in filecontents:
		while line and line[-1] in "\r\n": line=line[:-1]
		if line == "// exclude":
			print "exclude", file
			extra_qc[n]=""
			break
		match = our_re.match(line)
		if match == -1: continue
		if our_re.group(1)=='require':
			r=our_re.group(2)
			if r[-3:] != '.qc': r=r+".qc"
			for name in extra_qc:
				if os.path.basename(name)==r:
					r=name
					continue
			for name in builtin_qc:
				if os.path.basename(name)==r:
					r=name
					continue
			print file+" needs "+r+"."
			requires.append((file, r))
		elif our_re.group(1)=='flag':
			flags.append(our_re.group(2))
		elif our_re.group(1)=='start':
			starts.append(our_re.group(2))
		elif our_re.group(1)=='object':
			objects.append((our_re.group(2), our_re.group(4)))
		elif our_re.group(1)=='file':
			needfiles.append((file, our_re.group(2), our_re.group(4)))
		elif our_re.group(1)=='precache':
			precaches.append(our_re.group(2))
		elif our_re.group(1)=='impulse':
			impulses.append((our_re.group(2), 0, our_re.group(4)))
		else:
			impulses.append((our_re.group(2),
				string.atoi(our_re.group(1)[7:]), our_re.group(4)))

temp=extra_qc[:]
while 1:		# Repeat till 'requires' don't change order again
	for a, b in requires:
#		if not a in extra_qc: continue
		if b in builtin_qc: continue
		if b in extra_qc:
			extra_qc=movebefore(extra_qc, b, a)
			continue
		print a+" needs '"+b+"', but I don't have it."
#		del extra_qc[extra_qc.index(a)] # it's not so simple as that
		sys.exit(1)
	if temp == extra_qc: break
	temp=extra_qc[:]

f=open("progs.src", "w")
f.write("progs.dat\n\n")
for l in builtin_qc:
	f.write(l+"\n")
f.write("\n_qcustom.qc\n\n")
for l in extra_qc:
	if l=="": continue
	f.write(l+"\n")
f.close()

for h, i, j in needfiles:
	if not os.path.exists(i):
		print h, "needs", i, "(not found)"
		sys.exit(1)
	
if len(flags)>6*23:
	print len(flags), "flags needed, only", 6*23, "available."
	sys.exit(1)

g=open("needed.txt", "w")
for h, i, j in needfiles:
	g.write(i);
	if j:
		g.write("\t")
		g.write(j)
	g.write("\n")
g.close()
	
g=open("objects.txt", "w")
for i, j in items:
	g.write(i)
	if j:
		g.write("\t")
		g.write(j)
	g.write("\n")
g.close()

f=open("_qcustom.qc", "w")
g=open("impulses.txt", "w")

for name in precaches:
	f.write("void() %s;\n" % name)
f.write("\n");

for name in starts:
	f.write("void() %s;\n" % name)
f.write("\n");

for i in range(0, len(flags)):
	f.write("float %s=%d;" % (flags[i], i))
f.write("\n");

for name, count, text in impulses:
	if count==0: f.write("void() %s;\n" % name)
	else: f.write("void(float num) %s;\n" % name)

f.write("""
void() ImpulseCommands =
{
	if (self.impulse>=1 && self.impulse < 9) {
		if (self._impulse != SUB_Null) self._impulse();
		else W_ChangeWeapon();
	}
	else if (self.impulse==9)
		CheatCommand();
	else if (self.impulse==10)
		CycleWeaponCommand();
	else if (self.impulse == 11)
		ServerflagsCommand();
	else if (self.impulse==12)
		CycleWeaponReverseCommand();
	else if (self.impulse == 255)
		QuadCheat();
""")

g.write("""
Impulse\t\tEffect
1..8\t\tChange to builtin weapon
9\t\tGet all weapons (cheat)
10\t\tCycle weapons
11\t\tGet a rune (cheat)
12\t\tCycle weapons in reverse
""")

impulse=13

for name, count, text in impulses:
	if count==0:
		g.write("%d\t\t%s\n" % (impulse, text or name))
		f.write(
			"\telse if (self.impulse==%d) %s();\n" %
			(impulse, name))
		impulse = impulse + 1
	else:
		g.write("%d..%d\t\t%s\n" % (impulse, impulse+count-1, text or name))
		f.write(
			("\telse if (self.impulse>=%d && self.impulse<%d)\n"+
			"\t\t%s(self.impulse - %d);\n") %
			(impulse, impulse+count, name, impulse))
		impulse = impulse + count

f.write("\telse if(self.impulse) self._impulse();\n\tself.impulse=0;\n};\n\n")

f.write("void() EW_Precache = {\n");
for name in precaches:
	f.write("\t%s();\n" % name)
f.write("};\n\n")

f.write("void() EW_PlayerStart = {\n");
for name in starts:
	f.write("\t%s();\n" % name)
f.write("};\n\n");

f.close()
g.close()

print

try:
	e=os.system("qcc")
except:
	print "Run your QuakeC compiler now..."
	sys.exit(0)
sys.exit(e)
