diff -ur --new-file src/ai.qc kal-ctf/ai.qc
--- src/ai.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/ai.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,747 @@
+void() movetarget_f;
+void() t_movetarget;
+void() knight_walk1;
+void() knight_bow6;
+void() knight_bow1;
+void(entity etemp, entity stemp, entity stemp, float dmg) T_Damage;
+/*
+
+.enemy
+Will be world if not currently angry at anyone.
+
+.movetarget
+The next path spot to walk toward.  If .enemy, ignore .movetarget.
+When an enemy is killed, the monster will try to return to it's path.
+
+.huntt_ime
+Set to time + something when the player is in sight, but movement straight for
+him is blocked.  This causes the monster to use wall following code for
+movement direction instead of sighting on the player.
+
+.ideal_yaw
+A yaw angle of the intended direction, which will be turned towards at up
+to 45 deg / state.  If the enemy is in view and hunt_time is not active,
+this will be the exact line towards the enemy.
+
+.pausetime
+A monster will leave it's stand state and head towards it's .movetarget when
+time > .pausetime.
+
+walkmove(angle, speed) primitive is all or nothing
+*/
+
+
+//
+// globals
+//
+float	current_yaw;
+
+//
+// when a monster becomes angry at a player, that monster will be used
+// as the sight target the next frame so that monsters near that one
+// will wake up even if they wouldn't have noticed the player
+//
+entity	sight_entity;
+float	sight_entity_time;
+
+float(float v) anglemod =
+{
+	while (v >= 360)
+		v = v - 360;
+	while (v < 0)
+		v = v + 360;
+	return v;
+};
+
+/*
+==============================================================================
+
+MOVETARGET CODE
+
+The angle of the movetarget effects standing and bowing direction, but has no effect on movement, which allways heads to the next target.
+
+targetname
+must be present.  The name of this movetarget.
+
+target
+the next spot to move to.  If not present, stop here for good.
+
+pausetime
+The number of seconds to spend standing or bowing for path_stand or path_bow
+
+==============================================================================
+*/
+
+
+void() movetarget_f =
+{
+	if (!self.targetname)
+		objerror ("monster_movetarget: no targetname");
+		
+	self.solid = SOLID_TRIGGER;
+	self.touch = t_movetarget;
+	setsize (self, '-8 -8 -8', '8 8 8');
+	
+};
+
+/*QUAKED path_corner (0.5 0.3 0) (-8 -8 -8) (8 8 8)
+Monsters will continue walking towards the next target corner.
+*/
+void() path_corner =
+{
+	movetarget_f ();
+};
+
+
+/*
+=============
+t_movetarget
+
+Something has bumped into a movetarget.  If it is a monster
+moving towards it, change the next destination and continue.
+==============
+*/
+void() t_movetarget =
+{
+local entity	temp;
+
+	if (other.movetarget != self)
+		return;
+	
+	if (other.enemy)
+		return;		// fighting, not following a path
+
+	temp = self;
+	self = other;
+	other = temp;
+
+	if (self.classname == "monster_ogre")
+		sound (self, CHAN_VOICE, "ogre/ogdrag.wav", 1, ATTN_IDLE);// play chainsaw drag sound
+
+//dprint ("t_movetarget\n");
+	self.goalentity = self.movetarget = find (world, targetname, other.target);
+	self.ideal_yaw = vectoyaw(self.goalentity.origin - self.origin);
+	if (!self.movetarget)
+	{
+		self.pausetime = time + 999999;
+		self.th_stand ();
+		return;
+	}
+};
+
+
+
+//============================================================================
+
+/*
+=============
+range
+
+returns the range catagorization of an entity reletive to self
+0	melee range, will become hostile even if back is turned
+1	visibility and infront, or visibility and show hostile
+2	infront and show hostile
+3	only triggered by damage
+=============
+*/
+float(entity targ) range =
+{
+local vector	spot1, spot2;
+local float		r;	
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+	
+	r = vlen (spot1 - spot2);
+	if (r < 120)
+		return RANGE_MELEE;
+	if (r < 500)
+		return RANGE_NEAR;
+	if (r < 1000)
+		return RANGE_MID;
+	return RANGE_FAR;
+};
+
+/*
+=============
+visible
+
+returns 1 if the entity is visible to self, even if not infront ()
+=============
+*/
+float (entity targ) visible =
+{
+	local vector	spot1, spot2;
+	
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+	traceline (spot1, spot2, TRUE, self);	// see through other monsters
+	
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_fraction == 1)
+		return TRUE;
+	return FALSE;
+};
+
+
+/*
+=============
+infront
+
+returns 1 if the entity is in front (in sight) of self
+=============
+*/
+float(entity targ) infront =
+{
+	local vector	vec;
+	local float		dot;
+	
+	makevectors (self.angles);
+	vec = normalize (targ.origin - self.origin);
+	dot = vec * v_forward;
+	
+	if ( dot > 0.3)
+	{
+		return TRUE;
+	}
+	return FALSE;
+};
+
+
+//============================================================================
+
+/*
+===========
+ChangeYaw
+
+Turns towards self.ideal_yaw at self.yaw_speed
+Sets the global variable current_yaw
+Called every 0.1 sec by monsters
+============
+*/
+/*
+
+void() ChangeYaw =
+{
+	local float		ideal, move;
+
+//current_yaw = self.ideal_yaw;
+// mod down the current angle
+	current_yaw = anglemod( self.angles_y );
+	ideal = self.ideal_yaw;
+	
+	if (current_yaw == ideal)
+		return;
+	
+	move = ideal - current_yaw;
+	if (ideal > current_yaw)
+	{
+		if (move > 180)
+			move = move - 360;
+	}
+	else
+	{
+		if (move < -180)
+			move = move + 360;
+	}
+		
+	if (move > 0)
+	{
+		if (move > self.yaw_speed)
+			move = self.yaw_speed;
+	}
+	else
+	{
+		if (move < 0-self.yaw_speed )
+			move = 0-self.yaw_speed;
+	}
+
+	current_yaw = anglemod (current_yaw + move);
+
+	self.angles_y = current_yaw;
+};
+
+*/
+
+
+//============================================================================
+
+void() HuntTarget =
+{
+	self.goalentity = self.enemy;
+	self.think = self.th_run;
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+	self.nextthink = time + 0.1;
+	SUB_AttackFinished (1);	// wait a while before first attack
+};
+
+void() SightSound =
+{
+local float	rsnd;
+
+	if (self.classname == "monster_ogre")	
+		sound (self, CHAN_VOICE, "ogre/ogwake.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_knight")
+		sound (self, CHAN_VOICE, "knight/ksight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_shambler")
+		sound (self, CHAN_VOICE, "shambler/ssight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_demon1")
+		sound (self, CHAN_VOICE, "demon/sight2.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_wizard")
+		sound (self, CHAN_VOICE, "wizard/wsight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_zombie")
+		sound (self, CHAN_VOICE, "zombie/z_idle.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_dog")
+		sound (self, CHAN_VOICE, "dog/dsight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_hell_knight")
+		sound (self, CHAN_VOICE, "hknight/sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_tarbaby")
+		sound (self, CHAN_VOICE, "blob/sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_vomit")
+		sound (self, CHAN_VOICE, "vomitus/v_sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_enforcer")
+	{
+		rsnd = rint(random() * 3);			
+		if (rsnd == 1)
+			sound (self, CHAN_VOICE, "enforcer/sight1.wav", 1, ATTN_NORM);
+		else if (rsnd == 2)
+			sound (self, CHAN_VOICE, "enforcer/sight2.wav", 1, ATTN_NORM);
+		else if (rsnd == 0)
+			sound (self, CHAN_VOICE, "enforcer/sight3.wav", 1, ATTN_NORM);
+		else
+			sound (self, CHAN_VOICE, "enforcer/sight4.wav", 1, ATTN_NORM);
+	}
+	else if (self.classname == "monster_army")
+		sound (self, CHAN_VOICE, "soldier/sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_shalrath")
+		sound (self, CHAN_VOICE, "shalrath/sight.wav", 1, ATTN_NORM);
+};
+
+void() FoundTarget =
+{
+	if (self.enemy.classname == "player")
+	{	// let other monsters see this monster for a while
+		sight_entity = self;
+		sight_entity_time = time;
+	}
+	
+	self.show_hostile = time + 1;		// wake up other monsters
+
+	SightSound ();
+	HuntTarget ();
+};
+
+/*
+===========
+FindTarget
+
+Self is currently not attacking anything, so try to find a target
+
+Returns TRUE if an enemy was sighted
+
+When a player fires a missile, the point of impact becomes a fakeplayer so
+that monsters that see the impact will respond as if they had seen the
+player.
+
+To avoid spending too much time, only a single client (or fakeclient) is
+checked each frame.  This means multi player games will have slightly
+slower noticing monsters.
+============
+*/
+float() FindTarget =
+{
+	local entity	client;
+	local float		r;
+
+// if the first spawnflag bit is set, the monster will only wake up on
+// really seeing the player, not another monster getting angry
+
+// spawnflags & 3 is a big hack, because zombie crucified used the first
+// spawn flag prior to the ambush flag, and I forgot about it, so the second
+// spawn flag works as well
+	if (sight_entity_time >= time - 0.1 && !(self.spawnflags & 3) )
+	{
+		client = sight_entity;
+		if (client.enemy == self.enemy)
+			return;
+	}
+	else
+	{
+		client = checkclient ();
+		if (!client)
+			return FALSE;	// current check entity isn't in PVS
+	}
+
+	if (client == self.enemy)
+		return FALSE;
+
+	if (client.flags & FL_NOTARGET)
+		return FALSE;
+	if (client.items & IT_INVISIBILITY)
+		return FALSE;
+
+	r = range (client);
+	if (r == RANGE_FAR)
+		return FALSE;
+		
+	if (!visible (client))
+		return FALSE;
+
+	if (r == RANGE_NEAR)
+	{
+		if (client.show_hostile < time && !infront (client))
+			return FALSE;
+	}
+	else if (r == RANGE_MID)
+	{
+		if ( /* client.show_hostile < time || */ !infront (client))
+			return FALSE;
+	}
+	
+//
+// got one
+//
+	self.enemy = client;
+	if (self.enemy.classname != "player")
+	{
+		self.enemy = self.enemy.enemy;
+		if (self.enemy.classname != "player")
+		{
+			self.enemy = world;
+			return FALSE;
+		}
+	}
+	
+	FoundTarget ();
+
+	return TRUE;
+};
+
+
+//=============================================================================
+
+void(float dist) ai_forward =
+{
+	walkmove (self.angles_y, dist);
+};
+
+void(float dist) ai_back =
+{
+	walkmove ( (self.angles_y+180), dist);
+};
+
+
+/*
+=============
+ai_pain
+
+stagger back a bit
+=============
+*/
+void(float dist) ai_pain =
+{
+	ai_back (dist);
+/*
+	local float	away;
+	
+	away = anglemod (vectoyaw (self.origin - self.enemy.origin) 
+	+ 180*(random()- 0.5) );
+	
+	walkmove (away, dist);
+*/
+};
+
+/*
+=============
+ai_painforward
+
+stagger back a bit
+=============
+*/
+void(float dist) ai_painforward =
+{
+	walkmove (self.ideal_yaw, dist);
+};
+
+/*
+=============
+ai_walk
+
+The monster is walking it's beat
+=============
+*/
+void(float dist) ai_walk =
+{
+	local vector		mtemp;
+	
+	movedist = dist;
+	
+	if (self.classname == "monster_dragon")
+	{
+		movetogoal (dist);
+		return;
+	}
+	// check for noticing a player
+	if (FindTarget ())
+		return;
+
+	movetogoal (dist);
+};
+
+
+/*
+=============
+ai_stand
+
+The monster is staying in one place for a while, with slight angle turns
+=============
+*/
+void() ai_stand =
+{
+	if (FindTarget ())
+		return;
+	
+	if (time > self.pausetime)
+	{
+		self.th_walk ();
+		return;
+	}
+	
+// change angle slightly
+
+};
+
+/*
+=============
+ai_turn
+
+don't move, but turn towards ideal_yaw
+=============
+*/
+void() ai_turn =
+{
+	if (FindTarget ())
+		return;
+	
+	ChangeYaw ();
+};
+
+//=============================================================================
+
+/*
+=============
+ChooseTurn
+=============
+*/
+void(vector dest3) ChooseTurn =
+{
+	local vector	dir, newdir;
+	
+	dir = self.origin - dest3;
+
+	newdir_x = trace_plane_normal_y;
+	newdir_y = 0 - trace_plane_normal_x;
+	newdir_z = 0;
+	
+	if (dir * newdir > 0)
+	{
+		dir_x = 0 - trace_plane_normal_y;
+		dir_y = trace_plane_normal_x;
+	}
+	else
+	{
+		dir_x = trace_plane_normal_y;
+		dir_y = 0 - trace_plane_normal_x;
+	}
+
+	dir_z = 0;
+	self.ideal_yaw = vectoyaw(dir);	
+};
+
+/*
+============
+FacingIdeal
+
+============
+*/
+float() FacingIdeal =
+{
+	local	float	delta;
+	
+	delta = anglemod(self.angles_y - self.ideal_yaw);
+	if (delta > 45 && delta < 315)
+		return FALSE;
+	return TRUE;
+};
+
+
+//=============================================================================
+
+float()	WizardCheckAttack;
+float()	DogCheckAttack;
+
+float() CheckAnyAttack =
+{
+	if (!enemy_vis)
+		return;
+	if (self.classname == "monster_army")
+		return SoldierCheckAttack ();
+	if (self.classname == "monster_ogre")
+		return OgreCheckAttack ();
+	if (self.classname == "monster_shambler")
+		return ShamCheckAttack ();
+	if (self.classname == "monster_demon1")
+		return DemonCheckAttack ();
+	if (self.classname == "monster_dog")
+		return DogCheckAttack ();
+	if (self.classname == "monster_wizard")
+		return WizardCheckAttack ();
+	return CheckAttack ();
+};
+
+
+/*
+=============
+ai_run_melee
+
+Turn and close until within an angle to launch a melee attack
+=============
+*/
+void() ai_run_melee =
+{
+	self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+
+	if (FacingIdeal())
+	{
+		self.th_melee ();
+		self.attack_state = AS_STRAIGHT;
+	}
+};
+
+
+/*
+=============
+ai_run_missile
+
+Turn in place until within an angle to launch a missile attack
+=============
+*/
+void() ai_run_missile =
+{
+	self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+	if (FacingIdeal())
+	{
+		self.th_missile ();
+		self.attack_state = AS_STRAIGHT;
+	}
+};
+
+
+/*
+=============
+ai_run_slide
+
+Strafe sideways, but stay at aproximately the same range
+=============
+*/
+void() ai_run_slide =
+{
+	local float	ofs;
+	
+	self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+	if (self.lefty)
+		ofs = 90;
+	else
+		ofs = -90;
+	
+	if (walkmove (self.ideal_yaw + ofs, movedist))
+		return;
+		
+	self.lefty = 1 - self.lefty;
+	
+	walkmove (self.ideal_yaw - ofs, movedist);
+};
+
+
+/*
+=============
+ai_run
+
+The monster has an enemy it is trying to kill
+=============
+*/
+void(float dist) ai_run =
+{
+	local	vector	delta;
+	local	float	axis;
+	local	float	direct, ang_rint, ang_floor, ang_ceil;
+	
+	movedist = dist;
+// see if the enemy is dead
+	if (self.enemy.health <= 0)
+	{
+		self.enemy = world;
+	// FIXME: look all around for other targets
+		if (self.oldenemy.health > 0)
+		{
+			self.enemy = self.oldenemy;
+			HuntTarget ();
+		}
+		else
+		{
+			if (self.movetarget)
+				self.th_walk ();
+			else
+				self.th_stand ();
+			return;
+		}
+	}
+
+	self.show_hostile = time + 1;		// wake up other monsters
+
+// check knowledge of enemy
+	enemy_vis = visible(self.enemy);
+	if (enemy_vis)
+		self.search_time = time + 5;
+
+// look for other coop players
+	if (coop && self.search_time < time)
+	{
+		if (FindTarget ())
+			return;
+	}
+
+	enemy_infront = infront(self.enemy);
+	enemy_range = range(self.enemy);
+	enemy_yaw = vectoyaw(self.enemy.origin - self.origin);
+	
+	if (self.attack_state == AS_MISSILE)
+	{
+//dprint ("ai_run_missile\n");
+		ai_run_missile ();
+		return;
+	}
+	if (self.attack_state == AS_MELEE)
+	{
+//dprint ("ai_run_melee\n");
+		ai_run_melee ();
+		return;
+	}
+
+	if (CheckAnyAttack ())
+		return;					// beginning an attack
+		
+	if (self.attack_state == AS_SLIDING)
+	{
+		ai_run_slide ();
+		return;
+	}
+		
+// head straight in
+	movetogoal (dist);		// done in C code...
+};
+
diff -ur --new-file src/amtest.qc kal-ctf/amtest.qc
--- src/amtest.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/amtest.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,85 @@
+/*~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>
+~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~*/
+
+void() test_teleport_touch;
+void() tele_done;
+
+/*QUAKED test_teleport (0 .5 .8) ?
+Teleporter testing
+*/
+void() test_teleport =
+{
+	precache_model ("sprites/s_aball.spr");
+	setsize (self, self.mins, self.maxs);	
+	self.touch = test_teleport_touch;
+	self.solid = 1;
+	
+	if (!self.target)
+		objerror ("no target\n");
+};
+
+void() test_teleport_touch =
+{
+local entity oldself;
+	other.movetype = MOVETYPE_TOSS;
+//	other.solid = SOLID_NOT;
+	other.dest = '256 -128 -128';
+	oldself = self;
+	self = other;
+//	SUB_CalcMove (self.dest, 200, tele_done);
+	self.velocity = '1000 0 0 ';
+	self = oldself;
+};
+
+void() tele_done =
+{
+	self.movetype = MOVETYPE_WALK;
+	self.solid = SOLID_SLIDEBOX;	
+};
+
+/*~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>
+~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~*/
+
+void() test_goaway;
+void() test_spawn;
+
+/*QUAKED test_fodder (0 .5 .8) ?
+beating guy
+*/
+void() test_fodder =
+{
+	self.nextthink = time + 3;
+	self.think = test_spawn;
+};
+
+void() test_spawn =
+{
+local entity	body;
+	makevectors (self.angles);
+
+	body = spawn();
+	setmodel (body, "progs/soldier.mdl");
+	setorigin (body, self.origin);
+	body.classname = "player";
+	body.health = 1000;
+	body.frags = 0;
+	body.takedamage = DAMAGE_AIM;
+	body.solid = SOLID_SLIDEBOX;
+	body.movetype = MOVETYPE_WALK;
+	body.show_hostile = 0;
+	body.weapon = 1;
+	body.velocity = v_forward * 200;
+
+	body.nextthink = time + 5;
+	body.think = test_goaway;
+
+self.nextthink = time + 3;
+self.think = test_spawn;
+
+};
+
+void() test_goaway =
+{
+	remove (self);
+};
+
diff -ur --new-file src/boss.qc kal-ctf/boss.qc
--- src/boss.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/boss.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,385 @@
+/*
+==============================================================================
+
+BOSS-ONE
+
+==============================================================================
+*/
+$cd id1/models/boss1
+$origin 0 0 -15
+$base base
+$skin skin
+$scale 5
+
+$frame rise1 rise2 rise3 rise4 rise5 rise6 rise7 rise8 rise9 rise10
+$frame rise11 rise12 rise13 rise14 rise15 rise16 rise17 
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8
+$frame walk9 walk10 walk11 walk12 walk13 walk14 walk15
+$frame walk16 walk17 walk18 walk19 walk20 walk21 walk22
+$frame walk23 walk24 walk25 walk26 walk27 walk28 walk29 walk30 walk31
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8 death9
+
+$frame attack1 attack2 attack3 attack4 attack5 attack6 attack7 attack8
+$frame attack9 attack10 attack11 attack12 attack13 attack14 attack15
+$frame attack16 attack17 attack18 attack19 attack20 attack21 attack22
+$frame attack23
+
+$frame shocka1 shocka2 shocka3 shocka4 shocka5 shocka6 shocka7 shocka8
+$frame shocka9 shocka10 
+
+$frame shockb1 shockb2 shockb3 shockb4 shockb5 shockb6
+
+$frame shockc1 shockc2 shockc3 shockc4 shockc5 shockc6 shockc7 shockc8 
+$frame shockc9 shockc10
+
+
+void(vector p) boss_missile;
+
+void() boss_face =
+{
+	
+// go for another player if multi player
+	if (self.enemy.health <= 0 || random() < 0.02)
+	{
+		self.enemy = find(self.enemy, classname, "player");
+		if (!self.enemy)
+			self.enemy = find(self.enemy, classname, "player");
+	}
+	ai_face();
+};
+
+void() boss_rise1	=[	$rise1, boss_rise2 ] {
+sound (self, CHAN_WEAPON, "boss1/out1.wav", 1, ATTN_NORM);
+};
+void() boss_rise2	=[	$rise2, boss_rise3 ] {
+sound (self, CHAN_VOICE, "boss1/sight1.wav", 1, ATTN_NORM);
+};
+void() boss_rise3	=[	$rise3, boss_rise4 ] {};
+void() boss_rise4	=[	$rise4, boss_rise5 ] {};
+void() boss_rise5	=[	$rise5, boss_rise6 ] {};
+void() boss_rise6	=[	$rise6, boss_rise7 ] {};
+void() boss_rise7	=[	$rise7, boss_rise8 ] {};
+void() boss_rise8	=[	$rise8, boss_rise9 ] {};
+void() boss_rise9	=[	$rise9, boss_rise10 ] {};
+void() boss_rise10	=[	$rise10, boss_rise11 ] {};
+void() boss_rise11	=[	$rise11, boss_rise12 ] {};
+void() boss_rise12	=[	$rise12, boss_rise13 ] {};
+void() boss_rise13	=[	$rise13, boss_rise14 ] {};
+void() boss_rise14	=[	$rise14, boss_rise15 ] {};
+void() boss_rise15	=[	$rise15, boss_rise16 ] {};
+void() boss_rise16	=[	$rise16, boss_rise17 ] {};
+void() boss_rise17	=[	$rise17, boss_missile1 ] {};
+
+void() boss_idle1	=[	$walk1, boss_idle2 ]
+{
+// look for other players
+};
+void() boss_idle2	=[	$walk2, boss_idle3 ] {boss_face();};
+void() boss_idle3	=[	$walk3, boss_idle4 ] {boss_face();};
+void() boss_idle4	=[	$walk4, boss_idle5 ] {boss_face();};
+void() boss_idle5	=[	$walk5, boss_idle6 ] {boss_face();};
+void() boss_idle6	=[	$walk6, boss_idle7 ] {boss_face();};
+void() boss_idle7	=[	$walk7, boss_idle8 ] {boss_face();};
+void() boss_idle8	=[	$walk8, boss_idle9 ] {boss_face();};
+void() boss_idle9	=[	$walk9, boss_idle10 ] {boss_face();};
+void() boss_idle10	=[	$walk10, boss_idle11 ] {boss_face();};
+void() boss_idle11	=[	$walk11, boss_idle12 ] {boss_face();};
+void() boss_idle12	=[	$walk12, boss_idle13 ] {boss_face();};
+void() boss_idle13	=[	$walk13, boss_idle14 ] {boss_face();};
+void() boss_idle14	=[	$walk14, boss_idle15 ] {boss_face();};
+void() boss_idle15	=[	$walk15, boss_idle16 ] {boss_face();};
+void() boss_idle16	=[	$walk16, boss_idle17 ] {boss_face();};
+void() boss_idle17	=[	$walk17, boss_idle18 ] {boss_face();};
+void() boss_idle18	=[	$walk18, boss_idle19 ] {boss_face();};
+void() boss_idle19	=[	$walk19, boss_idle20 ] {boss_face();};
+void() boss_idle20	=[	$walk20, boss_idle21 ] {boss_face();};
+void() boss_idle21	=[	$walk21, boss_idle22 ] {boss_face();};
+void() boss_idle22	=[	$walk22, boss_idle23 ] {boss_face();};
+void() boss_idle23	=[	$walk23, boss_idle24 ] {boss_face();};
+void() boss_idle24	=[	$walk24, boss_idle25 ] {boss_face();};
+void() boss_idle25	=[	$walk25, boss_idle26 ] {boss_face();};
+void() boss_idle26	=[	$walk26, boss_idle27 ] {boss_face();};
+void() boss_idle27	=[	$walk27, boss_idle28 ] {boss_face();};
+void() boss_idle28	=[	$walk28, boss_idle29 ] {boss_face();};
+void() boss_idle29	=[	$walk29, boss_idle30 ] {boss_face();};
+void() boss_idle30	=[	$walk30, boss_idle31 ] {boss_face();};
+void() boss_idle31	=[	$walk31, boss_idle1 ] {boss_face();};
+
+void() boss_missile1	=[	$attack1, boss_missile2 ] {boss_face();};
+void() boss_missile2	=[	$attack2, boss_missile3 ] {boss_face();};
+void() boss_missile3	=[	$attack3, boss_missile4 ] {boss_face();};
+void() boss_missile4	=[	$attack4, boss_missile5 ] {boss_face();};
+void() boss_missile5	=[	$attack5, boss_missile6 ] {boss_face();};
+void() boss_missile6	=[	$attack6, boss_missile7 ] {boss_face();};
+void() boss_missile7	=[	$attack7, boss_missile8 ] {boss_face();};
+void() boss_missile8	=[	$attack8, boss_missile9 ] {boss_face();};
+void() boss_missile9	=[	$attack9, boss_missile10 ] {boss_missile('100 100 200');};
+void() boss_missile10	=[	$attack10, boss_missile11 ] {boss_face();};
+void() boss_missile11	=[	$attack11, boss_missile12 ] {boss_face();};
+void() boss_missile12	=[	$attack12, boss_missile13 ] {boss_face();};
+void() boss_missile13	=[	$attack13, boss_missile14 ] {boss_face();};
+void() boss_missile14	=[	$attack14, boss_missile15 ] {boss_face();};
+void() boss_missile15	=[	$attack15, boss_missile16 ] {boss_face();};
+void() boss_missile16	=[	$attack16, boss_missile17 ] {boss_face();};
+void() boss_missile17	=[	$attack17, boss_missile18 ] {boss_face();};
+void() boss_missile18	=[	$attack18, boss_missile19 ] {boss_face();};
+void() boss_missile19	=[	$attack19, boss_missile20 ] {boss_face();};
+void() boss_missile20	=[	$attack20, boss_missile21 ] {boss_missile('100 -100 200');};
+void() boss_missile21	=[	$attack21, boss_missile22 ] {boss_face();};
+void() boss_missile22	=[	$attack22, boss_missile23 ] {boss_face();};
+void() boss_missile23	=[	$attack23, boss_missile1 ] {boss_face();};
+
+void() boss_shocka1 =[	$shocka1, boss_shocka2 ] {};
+void() boss_shocka2 =[	$shocka2, boss_shocka3 ] {};
+void() boss_shocka3 =[	$shocka3, boss_shocka4 ] {};
+void() boss_shocka4 =[	$shocka4, boss_shocka5 ] {};
+void() boss_shocka5 =[	$shocka5, boss_shocka6 ] {};
+void() boss_shocka6 =[	$shocka6, boss_shocka7 ] {};
+void() boss_shocka7 =[	$shocka7, boss_shocka8 ] {};
+void() boss_shocka8 =[	$shocka8, boss_shocka9 ] {};
+void() boss_shocka9 =[	$shocka9, boss_shocka10 ] {};
+void() boss_shocka10 =[	$shocka10, boss_missile1 ] {};
+
+void() boss_shockb1 =[	$shockb1, boss_shockb2 ] {};
+void() boss_shockb2 =[	$shockb2, boss_shockb3 ] {};
+void() boss_shockb3 =[	$shockb3, boss_shockb4 ] {};
+void() boss_shockb4 =[	$shockb4, boss_shockb5 ] {};
+void() boss_shockb5 =[	$shockb5, boss_shockb6 ] {};
+void() boss_shockb6 =[	$shockb6, boss_shockb7 ] {};
+void() boss_shockb7 =[	$shockb1, boss_shockb8 ] {};
+void() boss_shockb8 =[	$shockb2, boss_shockb9 ] {};
+void() boss_shockb9 =[	$shockb3, boss_shockb10 ] {};
+void() boss_shockb10 =[	$shockb4, boss_missile1 ] {};
+
+void() boss_shockc1 =[	$shockc1, boss_shockc2 ] {};
+void() boss_shockc2 =[	$shockc2, boss_shockc3 ] {};
+void() boss_shockc3 =[	$shockc3, boss_shockc4 ] {};
+void() boss_shockc4 =[	$shockc4, boss_shockc5 ] {};
+void() boss_shockc5 =[	$shockc5, boss_shockc6 ] {};
+void() boss_shockc6 =[	$shockc6, boss_shockc7 ] {};
+void() boss_shockc7 =[	$shockc7, boss_shockc8 ] {};
+void() boss_shockc8 =[	$shockc8, boss_shockc9 ] {};
+void() boss_shockc9 =[	$shockc9, boss_shockc10 ] {};
+void() boss_shockc10 =[	$shockc10, boss_death1 ] {};
+
+void() boss_death1 = [$death1, boss_death2] {
+sound (self, CHAN_VOICE, "boss1/death.wav", 1, ATTN_NORM);
+};
+void() boss_death2 = [$death2, boss_death3] {};
+void() boss_death3 = [$death3, boss_death4] {};
+void() boss_death4 = [$death4, boss_death5] {};
+void() boss_death5 = [$death5, boss_death6] {};
+void() boss_death6 = [$death6, boss_death7] {};
+void() boss_death7 = [$death7, boss_death8] {};
+void() boss_death8 = [$death8, boss_death9] {};
+void() boss_death9 = [$death9, boss_death10]
+{
+	sound (self, CHAN_BODY, "boss1/out1.wav", 1, ATTN_NORM);
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LAVASPLASH);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+};
+
+void() boss_death10 = [$death9, boss_death10]
+{
+	killed_monsters = killed_monsters + 1;
+	WriteByte (MSG_ALL, SVC_KILLEDMONSTER);	// FIXME: reliable broadcast
+	SUB_UseTargets ();
+	remove (self);
+};
+
+void(vector p) boss_missile =
+{
+	local	vector	offang;
+	local	vector	org, vec, d;
+	local	float	t;
+
+	offang = vectoangles (self.enemy.origin - self.origin);	
+	makevectors (offang);
+
+	org = self.origin + p_x*v_forward + p_y*v_right + p_z*'0 0 1';
+	
+// lead the player on hard mode
+	if (skill > 1)
+	{
+		t = vlen(self.enemy.origin - org) / 300;
+		vec = self.enemy.velocity;
+		vec_z = 0;
+		d = self.enemy.origin + t * vec;		
+	}
+	else
+	{
+		d = self.enemy.origin;
+	}
+	
+	vec = normalize (d - org);
+
+	launch_spike (org, vec);
+	setmodel (newmis, "progs/lavaball.mdl");
+	newmis.avelocity = '200 100 300';
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	newmis.velocity = vec*300;
+	newmis.touch = T_MissileTouch; // rocket explosion
+	sound (self, CHAN_WEAPON, "boss1/throw.wav", 1, ATTN_NORM);
+
+// check for dead enemy
+	if (self.enemy.health <= 0)
+		boss_idle1 ();
+};
+
+
+void() boss_awake =
+{
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+	self.takedamage = DAMAGE_NO;
+	
+	setmodel (self, "progs/boss.mdl");
+	setsize (self, '-128 -128 -24', '128 128 256');
+	
+	if (skill == 0)
+		self.health = 1;
+	else
+		self.health = 3;
+
+	self.enemy = activator;
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LAVASPLASH);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	self.yaw_speed = 20;
+	boss_rise1 ();
+};
+
+
+/*QUAKED monster_boss (1 0 0) (-128 -128 -24) (128 128 256)
+*/
+void() monster_boss =
+{
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model ("progs/boss.mdl");
+	precache_model ("progs/lavaball.mdl");
+
+	precache_sound ("weapons/rocket1i.wav");
+	precache_sound ("boss1/out1.wav");
+	precache_sound ("boss1/sight1.wav");
+	precache_sound ("misc/power.wav");
+	precache_sound ("boss1/throw.wav");
+	precache_sound ("boss1/pain.wav");
+	precache_sound ("boss1/death.wav");
+
+	total_monsters = total_monsters + 1;
+
+	self.use = boss_awake;
+};
+
+//===========================================================================
+
+entity	le1, le2;
+float	lightning_end;
+
+void() lightning_fire =
+{
+	local vector p1, p2;
+	
+	if (time >= lightning_end)
+	{	// done here, put the terminals back up
+		self = le1;
+		door_go_down ();
+		self = le2;
+		door_go_down ();
+		return;
+	}
+	
+	p1 = (le1.mins + le1.maxs) * 0.5;
+	p1_z = le1.absmin_z - 16;
+	
+	p2 = (le2.mins + le2.maxs) * 0.5;
+	p2_z = le2.absmin_z - 16;
+	
+	// compensate for length of bolt
+	p2 = p2 - normalize(p2-p1)*100;
+
+	self.nextthink = time + 0.1;
+	self.think = lightning_fire;
+
+	WriteByte (MSG_ALL, SVC_TEMPENTITY);
+	WriteByte (MSG_ALL, TE_LIGHTNING3);
+	WriteEntity (MSG_ALL, world);
+	WriteCoord (MSG_ALL, p1_x);
+	WriteCoord (MSG_ALL, p1_y);
+	WriteCoord (MSG_ALL, p1_z);
+	WriteCoord (MSG_ALL, p2_x);
+	WriteCoord (MSG_ALL, p2_y);
+	WriteCoord (MSG_ALL, p2_z);
+};
+
+void() lightning_use =
+{
+	if (lightning_end >= time + 1)
+		return;
+
+	le1 = find( world, target, "lightning");
+	le2 = find( le1, target, "lightning");
+	if (!le1 || !le2)
+	{
+		dprint ("missing lightning targets\n");
+		return;
+	}
+	
+	if (
+	 (le1.state != STATE_TOP && le1.state != STATE_BOTTOM)
+	|| (le2.state != STATE_TOP && le2.state != STATE_BOTTOM)
+	|| (le1.state != le2.state) )
+	{
+//		dprint ("not aligned\n");
+		return;
+	}
+
+// don't let the electrodes go back up until the bolt is done
+	le1.nextthink = -1;
+	le2.nextthink = -1;
+	lightning_end = time + 1;
+
+	sound (self, CHAN_VOICE, "misc/power.wav", 1, ATTN_NORM);
+	lightning_fire ();		
+
+// advance the boss pain if down
+	self = find (world, classname, "monster_boss");
+	if (!self)
+		return;
+	self.enemy = activator;
+	if (le1.state == STATE_TOP && self.health > 0)
+	{
+		sound (self, CHAN_VOICE, "boss1/pain.wav", 1, ATTN_NORM);
+		self.health = self.health - 1;
+		if (self.health >= 2)
+			boss_shocka1();
+		else if (self.health == 1)
+			boss_shockb1();
+		else if (self.health == 0)
+			boss_shockc1();
+	}	
+};
+
+
+/*QUAKED event_lightning (0 1 1) (-16 -16 -16) (16 16 16)
+Just for boss level.
+*/
+void() event_lightning =
+{
+	self.use = lightning_use;
+};
+
+
diff -ur --new-file src/enforcer.qc kal-ctf/enforcer.qc
--- src/enforcer.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/enforcer.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,351 @@
+/*
+==============================================================================
+
+SOLDIER / PLAYER
+
+==============================================================================
+*/
+
+$cd id1/models/enforcer
+$origin 0 -6 24
+$base base		
+$skin skin
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8 walk9 walk10
+$frame walk11 walk12 walk13 walk14 walk15 walk16
+
+$frame run1 run2 run3 run4 run5 run6 run7 run8
+
+$frame attack1 attack2 attack3 attack4 attack5 attack6
+$frame attack7 attack8 attack9 attack10
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8
+$frame death9 death10 death11 death12 death13 death14
+
+$frame fdeath1 fdeath2 fdeath3 fdeath4 fdeath5 fdeath6 fdeath7 fdeath8
+$frame fdeath9 fdeath10 fdeath11
+
+$frame paina1 paina2 paina3 paina4
+
+$frame painb1 painb2 painb3 painb4 painb5
+
+$frame painc1 painc2 painc3 painc4 painc5 painc6 painc7 painc8
+
+$frame paind1 paind2 paind3 paind4 paind5 paind6 paind7 paind8
+$frame paind9 paind10 paind11 paind12 paind13 paind14 paind15 paind16
+$frame paind17 paind18 paind19
+
+
+void() Laser_Touch =
+{
+	local vector org;
+	
+	if (other == self.owner)
+		return;		// don't explode on owner
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	
+	sound (self, CHAN_WEAPON, "enforcer/enfstop.wav", 1, ATTN_STATIC);
+	org = self.origin - 8*normalize(self.velocity);
+
+	if (other.health)
+	{
+		SpawnBlood (org, self.velocity*0.2, 15);
+		T_Damage (other, self, self.owner, 15);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
+		WriteCoord (MSG_BROADCAST, org_x);
+		WriteCoord (MSG_BROADCAST, org_y);
+		WriteCoord (MSG_BROADCAST, org_z);
+	}
+	
+	remove(self);	
+};
+
+void(vector org, vector vec) LaunchLaser =
+{
+	local	vector	vec;
+		
+	if (self.classname == "monster_enforcer")
+		sound (self, CHAN_WEAPON, "enforcer/enfire.wav", 1, ATTN_NORM);
+
+	vec = normalize(vec);
+	
+	newmis = spawn();
+	newmis.owner = self;
+	newmis.movetype = MOVETYPE_FLY;
+	newmis.solid = SOLID_BBOX;
+	newmis.effects = EF_DIMLIGHT;
+
+	setmodel (newmis, "progs/laser.mdl");
+	setsize (newmis, '0 0 0', '0 0 0');		
+
+	setorigin (newmis, org);
+
+	newmis.velocity = vec * 600;
+	newmis.angles = vectoangles(newmis.velocity);
+
+	newmis.nextthink = time + 5;
+	newmis.think = SUB_Remove;
+	newmis.touch = Laser_Touch;
+};
+
+
+
+void() enforcer_fire =
+{
+	local vector org;
+
+	self.effects = self.effects | EF_MUZZLEFLASH;
+	makevectors (self.angles);
+	
+	org = self.origin + v_forward * 30 + v_right * 8.5 + '0 0 16';
+
+	LaunchLaser(org, self.enemy.origin - self.origin);
+};
+
+//============================================================================
+
+void()	enf_stand1	=[	$stand1,	enf_stand2	] {ai_stand();};
+void()	enf_stand2	=[	$stand2,	enf_stand3	] {ai_stand();};
+void()	enf_stand3	=[	$stand3,	enf_stand4	] {ai_stand();};
+void()	enf_stand4	=[	$stand4,	enf_stand5	] {ai_stand();};
+void()	enf_stand5	=[	$stand5,	enf_stand6	] {ai_stand();};
+void()	enf_stand6	=[	$stand6,	enf_stand7	] {ai_stand();};
+void()	enf_stand7	=[	$stand7,	enf_stand1	] {ai_stand();};
+
+void()	enf_walk1	=[	$walk1 ,	enf_walk2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "enforcer/idle1.wav", 1, ATTN_IDLE);
+ai_walk(2);};
+void()	enf_walk2	=[	$walk2 ,	enf_walk3	] {ai_walk(4);};
+void()	enf_walk3	=[	$walk3 ,	enf_walk4	] {ai_walk(4);};
+void()	enf_walk4	=[	$walk4 ,	enf_walk5	] {ai_walk(3);};
+void()	enf_walk5	=[	$walk5 ,	enf_walk6	] {ai_walk(1);};
+void()	enf_walk6	=[	$walk6 ,	enf_walk7	] {ai_walk(2);};
+void()	enf_walk7	=[	$walk7 ,	enf_walk8	] {ai_walk(2);};
+void()	enf_walk8	=[	$walk8 ,	enf_walk9	] {ai_walk(1);};
+void()	enf_walk9	=[	$walk9 ,	enf_walk10	] {ai_walk(2);};
+void()	enf_walk10	=[	$walk10,	enf_walk11	] {ai_walk(4);};
+void()	enf_walk11	=[	$walk11,	enf_walk12	] {ai_walk(4);};
+void()	enf_walk12	=[	$walk12,	enf_walk13	] {ai_walk(1);};
+void()	enf_walk13	=[	$walk13,	enf_walk14	] {ai_walk(2);};
+void()	enf_walk14	=[	$walk14,	enf_walk15	] {ai_walk(3);};
+void()	enf_walk15	=[	$walk15,	enf_walk16	] {ai_walk(4);};
+void()	enf_walk16	=[	$walk16,	enf_walk1	] {ai_walk(2);};
+
+void()	enf_run1	=[	$run1  ,	enf_run2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "enforcer/idle1.wav", 1, ATTN_IDLE);
+ai_run(18);};
+void()	enf_run2	=[	$run2  ,	enf_run3	] {ai_run(14);};
+void()	enf_run3	=[	$run3  ,	enf_run4	] {ai_run(7);};
+void()	enf_run4	=[	$run4  ,	enf_run5	] {ai_run(12);};
+void()	enf_run5	=[	$run5  ,	enf_run6	] {ai_run(14);};
+void()	enf_run6	=[	$run6  ,	enf_run7	] {ai_run(14);};
+void()	enf_run7	=[	$run7  ,	enf_run8	] {ai_run(7);};
+void()	enf_run8	=[	$run8  ,	enf_run1	] {ai_run(11);};
+
+void()	enf_atk1	=[	$attack1,	enf_atk2	] {ai_face();};
+void()	enf_atk2	=[	$attack2,	enf_atk3	] {ai_face();};
+void()	enf_atk3	=[	$attack3,	enf_atk4	] {ai_face();};
+void()	enf_atk4	=[	$attack4,	enf_atk5	] {ai_face();};
+void()	enf_atk5	=[	$attack5,	enf_atk6	] {ai_face();};
+void()	enf_atk6	=[	$attack6,	enf_atk7	] {enforcer_fire();};
+void()	enf_atk7	=[	$attack7,	enf_atk8	] {ai_face();};
+void()	enf_atk8	=[	$attack8,	enf_atk9	] {ai_face();};
+void()	enf_atk9	=[	$attack5,	enf_atk10	] {ai_face();};
+void()	enf_atk10	=[	$attack6,	enf_atk11	] {enforcer_fire();};
+void()	enf_atk11	=[	$attack7,	enf_atk12	] {ai_face();};
+void()	enf_atk12	=[	$attack8,	enf_atk13	] {ai_face();};
+void()	enf_atk13	=[	$attack9,	enf_atk14	] {ai_face();};
+void()	enf_atk14	=[	$attack10,	enf_run1	] {ai_face();
+SUB_CheckRefire (enf_atk1);
+};
+
+void()	enf_paina1	=[	$paina1,	enf_paina2	] {};
+void()	enf_paina2	=[	$paina2,	enf_paina3	] {};
+void()	enf_paina3	=[	$paina3,	enf_paina4	] {};
+void()	enf_paina4	=[	$paina4,	enf_run1	] {};
+
+void()	enf_painb1	=[	$painb1,	enf_painb2	] {};
+void()	enf_painb2	=[	$painb2,	enf_painb3	] {};
+void()	enf_painb3	=[	$painb3,	enf_painb4	] {};
+void()	enf_painb4	=[	$painb4,	enf_painb5	] {};
+void()	enf_painb5	=[	$painb5,	enf_run1	] {};
+
+void()	enf_painc1	=[	$painc1,	enf_painc2	] {};
+void()	enf_painc2	=[	$painc2,	enf_painc3	] {};
+void()	enf_painc3	=[	$painc3,	enf_painc4	] {};
+void()	enf_painc4	=[	$painc4,	enf_painc5	] {};
+void()	enf_painc5	=[	$painc5,	enf_painc6	] {};
+void()	enf_painc6	=[	$painc6,	enf_painc7	] {};
+void()	enf_painc7	=[	$painc7,	enf_painc8	] {};
+void()	enf_painc8	=[	$painc8,	enf_run1	] {};
+
+void()	enf_paind1	=[	$paind1,	enf_paind2	] {};
+void()	enf_paind2	=[	$paind2,	enf_paind3	] {};
+void()	enf_paind3	=[	$paind3,	enf_paind4	] {};
+void()	enf_paind4	=[	$paind4,	enf_paind5	] {ai_painforward(2);};
+void()	enf_paind5	=[	$paind5,	enf_paind6	] {ai_painforward(1);};
+void()	enf_paind6	=[	$paind6,	enf_paind7	] {};
+void()	enf_paind7	=[	$paind7,	enf_paind8	] {};
+void()	enf_paind8	=[	$paind8,	enf_paind9	] {};
+void()	enf_paind9	=[	$paind9,	enf_paind10	] {};
+void()	enf_paind10	=[	$paind10,	enf_paind11	] {};
+void()	enf_paind11	=[	$paind11,	enf_paind12	] {ai_painforward(1);};
+void()	enf_paind12	=[	$paind12,	enf_paind13	] {ai_painforward(1);};
+void()	enf_paind13	=[	$paind13,	enf_paind14	] {ai_painforward(1);};
+void()	enf_paind14	=[	$paind14,	enf_paind15	] {};
+void()	enf_paind15	=[	$paind15,	enf_paind16	] {};
+void()	enf_paind16	=[	$paind16,	enf_paind17	] {ai_pain(1);};
+void()	enf_paind17	=[	$paind17,	enf_paind18	] {ai_pain(1);};
+void()	enf_paind18	=[	$paind18,	enf_paind19	] {};
+void()	enf_paind19	=[	$paind19,	enf_run1	] {};
+
+void(entity attacker, float damage)	enf_pain =
+{
+	local float r;
+
+	r = random ();
+	if (self.pain_finished > time)
+		return;
+
+	
+	if (r < 0.5)
+		sound (self, CHAN_VOICE, "enforcer/pain1.wav", 1, ATTN_NORM);
+	else
+		sound (self, CHAN_VOICE, "enforcer/pain2.wav", 1, ATTN_NORM);
+
+	if (r < 0.2)
+	{
+		self.pain_finished = time + 1;
+		enf_paina1 ();
+	}
+	else if (r < 0.4)
+	{
+		self.pain_finished = time + 1;
+		enf_painb1 ();
+	}
+	else if (r < 0.7)
+	{
+		self.pain_finished = time + 1;
+		enf_painc1 ();
+	}
+	else
+	{
+		self.pain_finished = time + 2;
+		enf_paind1 ();
+	}
+};
+
+//============================================================================
+
+
+
+
+void()	enf_die1	=[	$death1,	enf_die2	] {};
+void()	enf_die2	=[	$death2,	enf_die3	] {};
+void()	enf_die3	=[	$death3,	enf_die4	]
+{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+void()	enf_die4	=[	$death4,	enf_die5	] {ai_forward(14);};
+void()	enf_die5	=[	$death5,	enf_die6	] {ai_forward(2);};
+void()	enf_die6	=[	$death6,	enf_die7	] {};
+void()	enf_die7	=[	$death7,	enf_die8	] {};
+void()	enf_die8	=[	$death8,	enf_die9	] {};
+void()	enf_die9	=[	$death9,	enf_die10	] {ai_forward(3);};
+void()	enf_die10	=[	$death10,	enf_die11	] {ai_forward(5);};
+void()	enf_die11	=[	$death11,	enf_die12	] {ai_forward(5);};
+void()	enf_die12	=[	$death12,	enf_die13	] {ai_forward(5);};
+void()	enf_die13	=[	$death13,	enf_die14	] {};
+void()	enf_die14	=[	$death14,	enf_die14	] {};
+
+void()	enf_fdie1	=[	$fdeath1,	enf_fdie2	] {
+
+};
+void()	enf_fdie2	=[	$fdeath2,	enf_fdie3	] {};
+void()	enf_fdie3	=[	$fdeath3,	enf_fdie4	] 
+{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+void()	enf_fdie4	=[	$fdeath4,	enf_fdie5	] {};
+void()	enf_fdie5	=[	$fdeath5,	enf_fdie6	] {};
+void()	enf_fdie6	=[	$fdeath6,	enf_fdie7	] {};
+void()	enf_fdie7	=[	$fdeath7,	enf_fdie8	] {};
+void()	enf_fdie8	=[	$fdeath8,	enf_fdie9	] {};
+void()	enf_fdie9	=[	$fdeath9,	enf_fdie10	] {};
+void()	enf_fdie10	=[	$fdeath10,	enf_fdie11	] {};
+void()	enf_fdie11	=[	$fdeath11,	enf_fdie11	] {};
+
+
+void() enf_die =
+{
+// check for gib
+	if (self.health < -35)
+	{
+		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		ThrowHead ("progs/h_mega.mdl", self.health);
+		ThrowGib ("progs/gib1.mdl", self.health);
+		ThrowGib ("progs/gib2.mdl", self.health);
+		ThrowGib ("progs/gib3.mdl", self.health);
+		return;
+	}
+
+// regular death
+	sound (self, CHAN_VOICE, "enforcer/death1.wav", 1, ATTN_NORM);
+	if (random() > 0.5)
+		enf_die1 ();
+	else
+		enf_fdie1 ();
+};
+
+
+/*QUAKED monster_enforcer (1 0 0) (-16 -16 -24) (16 16 40) Ambush
+
+*/
+void() monster_enforcer =
+{
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model2 ("progs/enforcer.mdl");
+	precache_model2 ("progs/h_mega.mdl");
+	precache_model2 ("progs/laser.mdl");
+
+	precache_sound2 ("enforcer/death1.wav");
+	precache_sound2 ("enforcer/enfire.wav");
+	precache_sound2 ("enforcer/enfstop.wav");
+	precache_sound2 ("enforcer/idle1.wav");
+	precache_sound2 ("enforcer/pain1.wav");
+	precache_sound2 ("enforcer/pain2.wav");
+	precache_sound2 ("enforcer/sight1.wav");
+	precache_sound2 ("enforcer/sight2.wav");
+	precache_sound2 ("enforcer/sight3.wav");
+	precache_sound2 ("enforcer/sight4.wav");
+	
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+
+	setmodel (self, "progs/enforcer.mdl");
+
+	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = 80;
+
+	self.th_stand = enf_stand1;
+	self.th_walk = enf_walk1;
+	self.th_run = enf_run1;
+	self.th_pain = enf_pain;
+	self.th_die = enf_die;
+	self.th_missile = enf_atk1;
+
+	walkmonster_start();
+};
diff -ur --new-file src/fight.qc kal-ctf/fight.qc
--- src/fight.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/fight.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,409 @@
+
+/*
+
+A monster is in fight mode if it thinks it can effectively attack its
+enemy.
+
+When it decides it can't attack, it goes into hunt mode.
+
+*/
+
+float(float v) anglemod;
+
+void() knight_atk1;
+void() knight_runatk1;
+void() ogre_smash1;
+void() ogre_swing1;
+
+void() sham_smash1;
+void() sham_swingr1;
+void() sham_swingl1;
+
+float()	DemonCheckAttack;
+void(float side)	Demon_Melee;
+
+void(vector dest) ChooseTurn;
+
+void() ai_face;
+
+
+float	enemy_vis, enemy_infront, enemy_range;
+float	enemy_yaw;
+
+
+void() knight_attack =
+{
+	local float		len;
+	
+// decide if now is a good swing time
+	len = vlen(self.enemy.origin+self.enemy.view_ofs - (self.origin+self.view_ofs));
+	
+	if (len<80)
+		knight_atk1 ();
+	else
+		knight_runatk1 ();
+};
+
+//=============================================================================
+
+/*
+===========
+CheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() CheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_ent != targ)
+		return FALSE;		// don't have a clear shot
+			
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (enemy_range == RANGE_MELEE)
+	{	// melee attack
+		if (self.th_melee)
+		{
+			if (self.classname == "monster_knight")
+				knight_attack ();
+			else
+				self.th_melee ();
+			return TRUE;
+		}
+	}
+	
+// missile attack
+	if (!self.th_missile)
+		return FALSE;
+		
+	if (time < self.attack_finished)
+		return FALSE;
+		
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	if (enemy_range == RANGE_MELEE)
+	{
+		chance = 0.9;
+		self.attack_finished = 0;
+	}
+	else if (enemy_range == RANGE_NEAR)
+	{
+		if (self.th_melee)
+			chance = 0.2;
+		else
+			chance = 0.4;
+	}
+	else if (enemy_range == RANGE_MID)
+	{
+		if (self.th_melee)
+			chance = 0.05;
+		else
+			chance = 0.1;
+	}
+	else
+		chance = 0;
+
+	if (random () < chance)
+	{
+		self.th_missile ();
+		SUB_AttackFinished (2*random());
+		return TRUE;
+	}
+
+	return FALSE;
+};
+
+
+/*
+=============
+ai_face
+
+Stay facing the enemy
+=============
+*/
+void() ai_face =
+{
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+	ChangeYaw ();
+};
+
+/*
+=============
+ai_charge
+
+The monster is in a melee attack, so get as close as possible to .enemy
+=============
+*/
+float (entity targ) visible;
+float(entity targ) infront;
+float(entity targ) range;
+
+void(float d) ai_charge =
+{
+	ai_face ();	
+	movetogoal (d);		// done in C code...
+};
+
+void() ai_charge_side =
+{
+	local	vector	dtemp;
+	local	float	heading;
+	
+// aim to the left of the enemy for a flyby
+
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+	ChangeYaw ();
+
+	makevectors (self.angles);
+	dtemp = self.enemy.origin - 30*v_right;
+	heading = vectoyaw(dtemp - self.origin);
+	
+	walkmove(heading, 20);
+};
+
+
+/*
+=============
+ai_melee
+
+=============
+*/
+void() ai_melee =
+{
+	local vector	delta;
+	local float 	ldmg;
+
+	if (!self.enemy)
+		return;		// removed before stroke
+		
+	delta = self.enemy.origin - self.origin;
+
+	if (vlen(delta) > 60)
+		return;
+		
+	ldmg = (random() + random() + random()) * 3;
+	T_Damage (self.enemy, self, self, ldmg);
+};
+
+
+void() ai_melee_side =
+{
+	local vector	delta;
+	local float 	ldmg;
+
+	if (!self.enemy)
+		return;		// removed before stroke
+		
+	ai_charge_side();
+	
+	delta = self.enemy.origin - self.origin;
+
+	if (vlen(delta) > 60)
+		return;
+	if (!CanDamage (self.enemy, self))
+		return;
+	ldmg = (random() + random() + random()) * 3;
+	T_Damage (self.enemy, self, self, ldmg);
+};
+
+
+//=============================================================================
+
+/*
+===========
+SoldierCheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() SoldierCheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_ent != targ)
+		return FALSE;	// don't have a clear shot
+			
+	
+// missile attack
+	if (time < self.attack_finished)
+		return FALSE;
+		
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	if (enemy_range == RANGE_MELEE)
+		chance = 0.9;
+	else if (enemy_range == RANGE_NEAR)
+		chance = 0.4;
+	else if (enemy_range == RANGE_MID)
+		chance = 0.05;
+	else
+		chance = 0;
+
+	if (random () < chance)
+	{
+		self.th_missile ();
+		SUB_AttackFinished (1 + random());
+		if (random() < 0.3)
+			self.lefty = !self.lefty;
+
+		return TRUE;
+	}
+
+	return FALSE;
+};
+//=============================================================================
+
+/*
+===========
+ShamCheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() ShamCheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+	local float		enemy_yaw;
+
+	if (enemy_range == RANGE_MELEE)
+	{
+		if (CanDamage (self.enemy, self))
+		{
+			self.attack_state = AS_MELEE;
+			return TRUE;
+		}
+	}
+
+	if (time < self.attack_finished)
+		return FALSE;
+	
+	if (!enemy_vis)
+		return FALSE;
+		
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	if (vlen(spot1 - spot2) > 600)
+		return FALSE;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_ent != targ)
+	{
+		return FALSE;	// don't have a clear shot
+	}
+			
+// missile attack
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	self.attack_state = AS_MISSILE;
+	SUB_AttackFinished (2 + 2*random());
+	return TRUE;
+};
+
+//============================================================================
+
+/*
+===========
+OgreCheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() OgreCheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+
+	if (enemy_range == RANGE_MELEE)
+	{
+		if (CanDamage (self.enemy, self))
+		{
+			self.attack_state = AS_MELEE;
+			return TRUE;
+		}
+	}
+
+	if (time < self.attack_finished)
+		return FALSE;
+	
+	if (!enemy_vis)
+		return FALSE;
+		
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_ent != targ)
+	{
+		return FALSE;	// don't have a clear shot
+	}
+			
+// missile attack
+	if (time < self.attack_finished)
+		return FALSE;
+		
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	else if (enemy_range == RANGE_NEAR)
+		chance = 0.10;
+	else if (enemy_range == RANGE_MID)
+		chance = 0.05;
+	else
+		chance = 0;
+
+	self.attack_state = AS_MISSILE;
+	SUB_AttackFinished (1 + 2*random());
+	return TRUE;
+};
+
diff -ur --new-file src/ident.qc kal-ctf/ident.qc
--- src/ident.qc	Wed Apr  2 19:33:38 1997
+++ kal-ctf/ident.qc	Fri May  2 20:43:58 1997
@@ -9,6 +9,9 @@
 // of him as "self."  I call it with an impulse in weapons.qc 
 entity(float disp) identify_player =
 {
+        // IdentPlayerRune is a string variable, trust me...
+        local string IdentPlayerRune;
+
 	// e is a temp entity; guy is our current best guess
 	// as to at whom the player is pointing
 	local entity e, guy;
@@ -65,6 +68,9 @@
 		return world;
 	}
 	TeamPlayerUpdate2(self, "You are looking at ", guy.netname);
-	return guy;
+        IdentPlayerRune = RuneName(guy);
+        if (IdentPlayerRune)
+                TeamPlayerUpdate2(self, "They are carrying the rune of ", IdentPlayerRune);
+        return guy;
 };	 
 
diff -ur --new-file src/items.qc kal-ctf/items.qc
--- src/items.qc	Wed Apr  9 18:01:16 1997
+++ kal-ctf/items.qc	Fri May  2 22:25:32 1997
@@ -1449,9 +1449,11 @@
 void() RuneTouch =
 {
 	local string	s;
-	local	float	best;
-	local		entity	stemp;
+        local float   best;
+        local entity  stemp;
 	
+        if (other == self.owner)
+                return;
 	if (other.classname != "player")
 		return;
 	if (other.health <= 0)
@@ -1504,6 +1506,7 @@
 };
 
 void (float flag) Do_DropRune;
+void (float flag) Do_TossRune;
 
 void() RuneRespawn =
 {
@@ -1523,6 +1526,7 @@
 	local entity	item;
 
 	item = spawn();
+        item.owner = item;
 	item.origin = self.origin - '0 0 24';
 	
 	item.player_flag = flag;
@@ -1558,7 +1562,7 @@
 */
 void() DropRune =
 {
-	if (self.player_flag & ITEM_RUNE1_FLAG)
+        if (self.player_flag & ITEM_RUNE1_FLAG)
 		Do_DropRune(ITEM_RUNE1_FLAG);
 	if (self.player_flag & ITEM_RUNE2_FLAG)
 		Do_DropRune(ITEM_RUNE2_FLAG);
@@ -1568,6 +1572,102 @@
 		Do_DropRune(ITEM_RUNE4_FLAG);
 	self.player_flag = self.player_flag - (self.player_flag & ITEM_RUNE_MASK);
 };
+
+/* -=CT=-KALWeb : Begin of TossRune code ... */
+void (float flag) Do_TossRune =
+{
+/* -=CT=-KALWeb : Use original Drop Rune code here ... */
+        if (teamplay & TEAM_DROP_RUNE1) {
+                local entity    item;
+        
+                item = spawn();
+                item.origin = self.origin - '0 0 48';
+         
+                item.owner = self.owner;
+                item.player_flag = flag;
+        
+                item.velocity_z = 400;
+                item.velocity_x = -500 + (random() * 1000);
+                item.velocity_y = -500 + (random() * 1000);
+         
+                item.flags = FL_ITEM;
+                item.solid = SOLID_TRIGGER;
+                item.movetype = MOVETYPE_TOSS;
+        
+        
+                if (flag & ITEM_RUNE1_FLAG)
+                        setmodel (item, "progs/end1.mdl");
+                else if (flag & ITEM_RUNE2_FLAG)
+                        setmodel (item, "progs/end2.mdl");
+                else if (flag & ITEM_RUNE3_FLAG)
+                        setmodel (item, "progs/end3.mdl");
+                else if (flag & ITEM_RUNE4_FLAG)
+                        setmodel (item, "progs/end4.mdl");
+                setsize (item, '-16 -16 0', '16 16 56');
+        
+                item.touch = RuneTouch;
+         
+                item.nextthink = time + 120;
+                item.think = RuneRespawn;
+        }
+/* -=CT=-KALWeb : Use *NEW* Drop Rune code here ... */
+        else if(teamplay & TEAM_DROP_RUNE2) {
+                local entity    item;
+        
+                item = spawn();
+                item.origin = self.origin - '0 0 48';
+         
+//              item.owner = self.owner;
+                item.player_flag = flag;
+/*        
+                item.velocity_z = 400;
+                item.velocity_x = -500 + (random() * 1000);
+                item.velocity_y = -500 + (random() * 1000);
+*/
+
+                item.flags = FL_ITEM;
+//              item.solid = SOLID_TRIGGER;
+                item.movetype = MOVETYPE_TOSS;
+        
+        
+/*
+                if (flag & ITEM_RUNE1_FLAG)
+                        setmodel (item, "progs/end1.mdl");
+                else if (flag & ITEM_RUNE2_FLAG)
+                        setmodel (item, "progs/end2.mdl");
+                else if (flag & ITEM_RUNE3_FLAG)
+                        setmodel (item, "progs/end3.mdl");
+                else if (flag & ITEM_RUNE4_FLAG)
+                        setmodel (item, "progs/end4.mdl");
+                setsize (item, '-16 -16 0', '16 16 56');
+*/
+        
+//              item.touch = RuneTouch;
+         
+                item.nextthink = time + 1;
+                item.think = RuneRespawn;
+        }
+};
+
+/*
+===============
+TossRune
+self is player
+===============
+*/
+void() TossRune =
+{
+        if ((self.player_flag & ITEM_RUNE1_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE1_FLAG);
+        if ((self.player_flag & ITEM_RUNE2_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE2_FLAG);
+        if ((self.player_flag & ITEM_RUNE3_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE3_FLAG);
+        if ((self.player_flag & ITEM_RUNE4_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE4_FLAG);
+	self.player_flag = self.player_flag - (self.player_flag & ITEM_RUNE_MASK);
+};
+/* End -=CT=-KALWeb */
 
 /*
 ================
diff -ur --new-file src/jctest.qc kal-ctf/jctest.qc
--- src/jctest.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/jctest.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,15 @@
+
+void() jctrig =
+{
+dprint ("here\n\n");
+	lightstyle(0, "az");
+};
+
+/*QUAKED trigger_jctest (.5 .5 .5) ?
+*/
+void() trigger_jctest =
+{
+	setsize (self, self.mins, self.maxs);
+	self.solid = SOLID_EDGE;
+	self.touch = jctrig;
+};
diff -ur --new-file src/models.qc kal-ctf/models.qc
--- src/models.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/models.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,585 @@
+
+/*
+===============================================================================
+
+WORLD WEAPONS
+
+===============================================================================
+*/
+
+$modelname g_shot
+$cd id1/models/g_shot
+$origin 0 0 -24
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame shot1
+
+
+$modelname g_nail
+$cd id1/models/g_nail
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+
+$modelname g_nail2
+$cd id1/models/g_nail2
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot2
+
+
+$modelname g_rock
+$cd id1/models/g_rock
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+
+$modelname g_rock2
+$cd id1/models/g_rock2
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+$modelname g_light
+$cd id1/models/g_light
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+/*
+===============================================================================
+
+VIEW WEAPONS
+
+===============================================================================
+*/
+
+$modelname v_axe
+$cd id1/models/v_axe
+$origin 0 5 54
+$base base
+$skin skin
+$frame frame1 frame2 frame3 frame4 frame5 frame6 frame7 frame8 frame9
+
+
+$modelname v_shot
+$cd id1/models/v_shot
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7
+
+
+$modelname v_shot2
+$cd id1/models/v_shot2
+$origin 0 0 56
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7
+
+
+$modelname v_rock2
+$cd id1/models/v_rock2
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot6
+
+
+$modelname v_rock
+$cd id1/models/v_rock
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7
+
+
+$modelname v_nail2
+$cd id1/models/v_nail2
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7 shot8 shot9
+
+
+$modelname v_nail
+$cd id1/models/v_nail
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7 shot8 shot9
+
+$modelname v_light
+$cd id1/models/v_light
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5
+
+
+/*
+===============================================================================
+
+ITEMS
+
+===============================================================================
+*/
+
+$modelname w_g_key
+$cd id1/models/w_g_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname w_s_key
+$cd id1/models/w_s_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname m_g_key
+$cd id1/models/m_g_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname m_s_key
+$cd id1/models/m_s_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname b_g_key
+$cd id1/models/b_g_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname b_s_key
+$cd id1/models/b_s_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+
+$modelname quaddama
+$cd id1/models/quaddama
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname invisibl
+$cd id1/models/invisibl
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname invulner
+$flags 8		// client side rotate
+$cd id1/models/invulner
+$base base
+$skin skin
+$frame frame1
+
+//modelname jetpack
+//cd id1/models/jetpack
+//flags 8		// client side rotate
+//base base
+//skin skin
+//frame frame1
+
+$modelname cube
+$cd id1/models/cube
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname suit
+$cd id1/models/suit
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname boots
+$cd id1/models/boots
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end1
+$cd id1/models/end1
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end2
+$cd id1/models/end2
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end3
+$cd id1/models/end3
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end4
+$cd id1/models/end4
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+
+/*
+===============================================================================
+
+GIBS
+
+===============================================================================
+*/
+
+$modelname gib1
+$cd id1/models/gib1
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+
+// torso
+$modelname gib2
+$cd id1/models/gib2
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname gib3
+$cd id1/models/gib3
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+
+// heads
+
+$modelname h_player
+$cd id1/models/h_player
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_dog
+$cd id1/models/h_dog
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_mega
+$cd id1/models/h_mega
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_guard
+$cd id1/models/h_guard
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_wizard
+$cd id1/models/h_wizard
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_knight
+$cd id1/models/h_knight
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_hellkn
+$cd id1/models/h_hellkn
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_zombie
+$cd id1/models/h_zombie
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_shams
+$cd id1/models/h_shams
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_shal
+$cd id1/models/h_shal
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_ogre
+$cd id1/models/h_ogre
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_demon
+$cd id1/models/h_demon
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+/*
+===============================================================================
+
+MISC
+
+===============================================================================
+*/
+
+$modelname armor
+$cd id1/models/armor
+$flags 8		// client side rotate
+$origin 0 0 -8
+$base base
+$skin skin
+$skin skin2
+$skin skin3
+$frame armor
+
+$modelname s_light			// shambler lightning ready
+$cd id1/models/s_light
+$origin 0 0 24
+$base base
+$skin skin
+$frame	frame1 frame2 frame3
+
+$modelname bolt3			// lightning towar bolts
+$cd id1/models/bolt2
+$origin 0 0 0
+$base base
+$scale 4
+$skin skin
+$frame	light
+
+$modelname bolt2
+$cd id1/models/bolt2
+$origin 0 0 0
+$base base
+$skin skin
+$frame	light
+
+$modelname bolt
+$cd id1/models/bolt
+$origin 0 0 0
+$base light
+$skin light
+$frame	light
+
+$modelname laser
+$cd id1/models/laser
+$base base
+$skin skin
+$scale 2
+$frame frame1
+
+$modelname flame		// with torch
+$cd id1/models/flame
+$origin 0 0 12
+$base base
+$skin skin
+$framegroupstart
+$frame flame1	0.1
+$frame flame2	0.1
+$frame flame3	0.1
+$frame flame4	0.1
+$frame flame5	0.1
+$frame flame6	0.1
+$framegroupend
+
+$modelname flame2		// standing flame, no torch
+$cd id1/models/flame2
+$origin 0 0 12
+$base base
+$skin skin
+$framegroupstart
+$frame flame1	0.1
+$frame flame2	0.1
+$frame flame3	0.1
+$frame flame4	0.1
+$frame flame5	0.1
+$frame flame6	0.1
+$framegroupend
+$framegroupstart
+$frame flameb1
+$frame flameb2
+$frame flameb3
+$frame flameb4
+$frame flameb5
+$frame flameb6
+$frame flameb7
+$frame flameb8
+$frame flameb9
+$frame flameb10
+$frame flameb11
+$framegroupend
+
+$modelname zom_gib
+$cd id1/models/zom_gib
+$flags 32		// EF_ZOMGIB
+$base base
+$skin skin
+$frame frame1
+
+$modelname eyes
+$cd id1/models/eyes
+$origin 0 0 -24
+$base base
+$skin skin
+$frame frame1
+
+$modelname spike
+$cd id1/models/spike
+$origin 0 0 0
+$base spike
+$skin skin
+$frame spike
+
+$modelname s_spike
+$cd id1/models/s_spike
+$origin 0 0 0
+$base spike
+$skin skin
+$frame spike
+
+$modelname v_spike
+$cd id1/models/v_spike
+$flags 128		// EF_TRACER3
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname w_spike
+$cd id1/models/w_spike
+$flags 16		// EF_TRACER
+$origin 0 0 0
+$base base
+$skin skin
+$framegroupstart
+$frame frame1	0.1
+$frame frame2	0.1
+$frame frame3	0.1
+$frame frame4	0.1
+$framegroupend
+
+$modelname k_spike
+$cd id1/models/k_spike
+$flags 64		// EF_TRACER2
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname backpack
+$cd id1/models/backpack
+$flags 8		// EF_ROTATE
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname grenade
+$cd id1/models/grenade2
+$flags 2		// EF_GRENADE
+$origin 0 0 0
+$base base
+$skin skin
+$frame grenade
+
+$modelname missile
+$cd id1/models/missile
+$flags	1			// EF_ROCKET
+$origin 0 0 0
+$base base
+$skin skin
+$frame missile
+
+$modelname lavaball
+$cd id1/models/lavaball
+$flags	1			// EF_ROCKET
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname teleport
+$cd id1/models/teleport
+$origin 0 0 24
+$base base
+$skin skin
+$frame frame1
+
diff -ur --new-file src/progs.src kal-ctf/progs.src
--- src/progs.src	Wed Apr  2 19:25:12 1997
+++ kal-ctf/progs.src	Fri May  2 17:50:08 1997
@@ -1,10 +1,12 @@
 ../progs.dat
 
 defs.qc
+
 log.qc			// Console logging of game actions
 teamplay.qc     // Compile the teamplay file
 ctfgame.qc		// vote exit stuff
 status.qc		// team status stuff
+
 ident.qc
 subs.qc
 combat.qc
@@ -12,7 +14,9 @@
 camera.qc
 observ.qc
 weapons.qc
+
 telefrag.qc		// from server modules
+
 world.qc
 client.qc
 player.qc
@@ -23,4 +27,5 @@
 misc.qc
 hook.qc
 server.qc
+
 admin.qc		// Remote admin functions
diff -ur --new-file src/qcfile.all kal-ctf/qcfile.all
--- src/qcfile.all	Thu Jan  1 00:00:00 1970
+++ kal-ctf/qcfile.all	Fri May  2 18:09:06 1997
@@ -0,0 +1,16609 @@
+void() movetarget_f;
+void() t_movetarget;
+void() knight_walk1;
+void() knight_bow6;
+void() knight_bow1;
+void(entity etemp, entity stemp, entity stemp, float dmg) T_Damage;
+/*
+
+.enemy
+Will be world if not currently angry at anyone.
+
+.movetarget
+The next path spot to walk toward.  If .enemy, ignore .movetarget.
+When an enemy is killed, the monster will try to return to it's path.
+
+.huntt_ime
+Set to time + something when the player is in sight, but movement straight for
+him is blocked.  This causes the monster to use wall following code for
+movement direction instead of sighting on the player.
+
+.ideal_yaw
+A yaw angle of the intended direction, which will be turned towards at up
+to 45 deg / state.  If the enemy is in view and hunt_time is not active,
+this will be the exact line towards the enemy.
+
+.pausetime
+A monster will leave it's stand state and head towards it's .movetarget when
+time > .pausetime.
+
+walkmove(angle, speed) primitive is all or nothing
+*/
+
+
+//
+// globals
+//
+float	current_yaw;
+
+//
+// when a monster becomes angry at a player, that monster will be used
+// as the sight target the next frame so that monsters near that one
+// will wake up even if they wouldn't have noticed the player
+//
+entity	sight_entity;
+float	sight_entity_time;
+
+float(float v) anglemod =
+{
+	while (v >= 360)
+		v = v - 360;
+	while (v < 0)
+		v = v + 360;
+	return v;
+};
+
+/*
+==============================================================================
+
+MOVETARGET CODE
+
+The angle of the movetarget effects standing and bowing direction, but has no effect on movement, which allways heads to the next target.
+
+targetname
+must be present.  The name of this movetarget.
+
+target
+the next spot to move to.  If not present, stop here for good.
+
+pausetime
+The number of seconds to spend standing or bowing for path_stand or path_bow
+
+==============================================================================
+*/
+
+
+void() movetarget_f =
+{
+	if (!self.targetname)
+		objerror ("monster_movetarget: no targetname");
+		
+	self.solid = SOLID_TRIGGER;
+	self.touch = t_movetarget;
+	setsize (self, '-8 -8 -8', '8 8 8');
+	
+};
+
+/*QUAKED path_corner (0.5 0.3 0) (-8 -8 -8) (8 8 8)
+Monsters will continue walking towards the next target corner.
+*/
+void() path_corner =
+{
+	movetarget_f ();
+};
+
+
+/*
+=============
+t_movetarget
+
+Something has bumped into a movetarget.  If it is a monster
+moving towards it, change the next destination and continue.
+==============
+*/
+void() t_movetarget =
+{
+local entity	temp;
+
+	if (other.movetarget != self)
+		return;
+	
+	if (other.enemy)
+		return;		// fighting, not following a path
+
+	temp = self;
+	self = other;
+	other = temp;
+
+	if (self.classname == "monster_ogre")
+		sound (self, CHAN_VOICE, "ogre/ogdrag.wav", 1, ATTN_IDLE);// play chainsaw drag sound
+
+//dprint ("t_movetarget\n");
+	self.goalentity = self.movetarget = find (world, targetname, other.target);
+	self.ideal_yaw = vectoyaw(self.goalentity.origin - self.origin);
+	if (!self.movetarget)
+	{
+		self.pausetime = time + 999999;
+		self.th_stand ();
+		return;
+	}
+};
+
+
+
+//============================================================================
+
+/*
+=============
+range
+
+returns the range catagorization of an entity reletive to self
+0	melee range, will become hostile even if back is turned
+1	visibility and infront, or visibility and show hostile
+2	infront and show hostile
+3	only triggered by damage
+=============
+*/
+float(entity targ) range =
+{
+local vector	spot1, spot2;
+local float		r;	
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+	
+	r = vlen (spot1 - spot2);
+	if (r < 120)
+		return RANGE_MELEE;
+	if (r < 500)
+		return RANGE_NEAR;
+	if (r < 1000)
+		return RANGE_MID;
+	return RANGE_FAR;
+};
+
+/*
+=============
+visible
+
+returns 1 if the entity is visible to self, even if not infront ()
+=============
+*/
+float (entity targ) visible =
+{
+	local vector	spot1, spot2;
+	
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+	traceline (spot1, spot2, TRUE, self);	// see through other monsters
+	
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_fraction == 1)
+		return TRUE;
+	return FALSE;
+};
+
+
+/*
+=============
+infront
+
+returns 1 if the entity is in front (in sight) of self
+=============
+*/
+float(entity targ) infront =
+{
+	local vector	vec;
+	local float		dot;
+	
+	makevectors (self.angles);
+	vec = normalize (targ.origin - self.origin);
+	dot = vec * v_forward;
+	
+	if ( dot > 0.3)
+	{
+		return TRUE;
+	}
+	return FALSE;
+};
+
+
+//============================================================================
+
+/*
+===========
+ChangeYaw
+
+Turns towards self.ideal_yaw at self.yaw_speed
+Sets the global variable current_yaw
+Called every 0.1 sec by monsters
+============
+*/
+/*
+
+void() ChangeYaw =
+{
+	local float		ideal, move;
+
+//current_yaw = self.ideal_yaw;
+// mod down the current angle
+	current_yaw = anglemod( self.angles_y );
+	ideal = self.ideal_yaw;
+	
+	if (current_yaw == ideal)
+		return;
+	
+	move = ideal - current_yaw;
+	if (ideal > current_yaw)
+	{
+		if (move > 180)
+			move = move - 360;
+	}
+	else
+	{
+		if (move < -180)
+			move = move + 360;
+	}
+		
+	if (move > 0)
+	{
+		if (move > self.yaw_speed)
+			move = self.yaw_speed;
+	}
+	else
+	{
+		if (move < 0-self.yaw_speed )
+			move = 0-self.yaw_speed;
+	}
+
+	current_yaw = anglemod (current_yaw + move);
+
+	self.angles_y = current_yaw;
+};
+
+*/
+
+
+//============================================================================
+
+void() HuntTarget =
+{
+	self.goalentity = self.enemy;
+	self.think = self.th_run;
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+	self.nextthink = time + 0.1;
+	SUB_AttackFinished (1);	// wait a while before first attack
+};
+
+void() SightSound =
+{
+local float	rsnd;
+
+	if (self.classname == "monster_ogre")	
+		sound (self, CHAN_VOICE, "ogre/ogwake.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_knight")
+		sound (self, CHAN_VOICE, "knight/ksight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_shambler")
+		sound (self, CHAN_VOICE, "shambler/ssight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_demon1")
+		sound (self, CHAN_VOICE, "demon/sight2.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_wizard")
+		sound (self, CHAN_VOICE, "wizard/wsight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_zombie")
+		sound (self, CHAN_VOICE, "zombie/z_idle.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_dog")
+		sound (self, CHAN_VOICE, "dog/dsight.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_hell_knight")
+		sound (self, CHAN_VOICE, "hknight/sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_tarbaby")
+		sound (self, CHAN_VOICE, "blob/sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_vomit")
+		sound (self, CHAN_VOICE, "vomitus/v_sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_enforcer")
+	{
+		rsnd = rint(random() * 3);			
+		if (rsnd == 1)
+			sound (self, CHAN_VOICE, "enforcer/sight1.wav", 1, ATTN_NORM);
+		else if (rsnd == 2)
+			sound (self, CHAN_VOICE, "enforcer/sight2.wav", 1, ATTN_NORM);
+		else if (rsnd == 0)
+			sound (self, CHAN_VOICE, "enforcer/sight3.wav", 1, ATTN_NORM);
+		else
+			sound (self, CHAN_VOICE, "enforcer/sight4.wav", 1, ATTN_NORM);
+	}
+	else if (self.classname == "monster_army")
+		sound (self, CHAN_VOICE, "soldier/sight1.wav", 1, ATTN_NORM);
+	else if (self.classname == "monster_shalrath")
+		sound (self, CHAN_VOICE, "shalrath/sight.wav", 1, ATTN_NORM);
+};
+
+void() FoundTarget =
+{
+	if (self.enemy.classname == "player")
+	{	// let other monsters see this monster for a while
+		sight_entity = self;
+		sight_entity_time = time;
+	}
+	
+	self.show_hostile = time + 1;		// wake up other monsters
+
+	SightSound ();
+	HuntTarget ();
+};
+
+/*
+===========
+FindTarget
+
+Self is currently not attacking anything, so try to find a target
+
+Returns TRUE if an enemy was sighted
+
+When a player fires a missile, the point of impact becomes a fakeplayer so
+that monsters that see the impact will respond as if they had seen the
+player.
+
+To avoid spending too much time, only a single client (or fakeclient) is
+checked each frame.  This means multi player games will have slightly
+slower noticing monsters.
+============
+*/
+float() FindTarget =
+{
+	local entity	client;
+	local float		r;
+
+// if the first spawnflag bit is set, the monster will only wake up on
+// really seeing the player, not another monster getting angry
+
+// spawnflags & 3 is a big hack, because zombie crucified used the first
+// spawn flag prior to the ambush flag, and I forgot about it, so the second
+// spawn flag works as well
+	if (sight_entity_time >= time - 0.1 && !(self.spawnflags & 3) )
+	{
+		client = sight_entity;
+		if (client.enemy == self.enemy)
+			return;
+	}
+	else
+	{
+		client = checkclient ();
+		if (!client)
+			return FALSE;	// current check entity isn't in PVS
+	}
+
+	if (client == self.enemy)
+		return FALSE;
+
+	if (client.flags & FL_NOTARGET)
+		return FALSE;
+	if (client.items & IT_INVISIBILITY)
+		return FALSE;
+
+	r = range (client);
+	if (r == RANGE_FAR)
+		return FALSE;
+		
+	if (!visible (client))
+		return FALSE;
+
+	if (r == RANGE_NEAR)
+	{
+		if (client.show_hostile < time && !infront (client))
+			return FALSE;
+	}
+	else if (r == RANGE_MID)
+	{
+		if ( /* client.show_hostile < time || */ !infront (client))
+			return FALSE;
+	}
+	
+//
+// got one
+//
+	self.enemy = client;
+	if (self.enemy.classname != "player")
+	{
+		self.enemy = self.enemy.enemy;
+		if (self.enemy.classname != "player")
+		{
+			self.enemy = world;
+			return FALSE;
+		}
+	}
+	
+	FoundTarget ();
+
+	return TRUE;
+};
+
+
+//=============================================================================
+
+void(float dist) ai_forward =
+{
+	walkmove (self.angles_y, dist);
+};
+
+void(float dist) ai_back =
+{
+	walkmove ( (self.angles_y+180), dist);
+};
+
+
+/*
+=============
+ai_pain
+
+stagger back a bit
+=============
+*/
+void(float dist) ai_pain =
+{
+	ai_back (dist);
+/*
+	local float	away;
+	
+	away = anglemod (vectoyaw (self.origin - self.enemy.origin) 
+	+ 180*(random()- 0.5) );
+	
+	walkmove (away, dist);
+*/
+};
+
+/*
+=============
+ai_painforward
+
+stagger back a bit
+=============
+*/
+void(float dist) ai_painforward =
+{
+	walkmove (self.ideal_yaw, dist);
+};
+
+/*
+=============
+ai_walk
+
+The monster is walking it's beat
+=============
+*/
+void(float dist) ai_walk =
+{
+	local vector		mtemp;
+	
+	movedist = dist;
+	
+	if (self.classname == "monster_dragon")
+	{
+		movetogoal (dist);
+		return;
+	}
+	// check for noticing a player
+	if (FindTarget ())
+		return;
+
+	movetogoal (dist);
+};
+
+
+/*
+=============
+ai_stand
+
+The monster is staying in one place for a while, with slight angle turns
+=============
+*/
+void() ai_stand =
+{
+	if (FindTarget ())
+		return;
+	
+	if (time > self.pausetime)
+	{
+		self.th_walk ();
+		return;
+	}
+	
+// change angle slightly
+
+};
+
+/*
+=============
+ai_turn
+
+don't move, but turn towards ideal_yaw
+=============
+*/
+void() ai_turn =
+{
+	if (FindTarget ())
+		return;
+	
+	ChangeYaw ();
+};
+
+//=============================================================================
+
+/*
+=============
+ChooseTurn
+=============
+*/
+void(vector dest3) ChooseTurn =
+{
+	local vector	dir, newdir;
+	
+	dir = self.origin - dest3;
+
+	newdir_x = trace_plane_normal_y;
+	newdir_y = 0 - trace_plane_normal_x;
+	newdir_z = 0;
+	
+	if (dir * newdir > 0)
+	{
+		dir_x = 0 - trace_plane_normal_y;
+		dir_y = trace_plane_normal_x;
+	}
+	else
+	{
+		dir_x = trace_plane_normal_y;
+		dir_y = 0 - trace_plane_normal_x;
+	}
+
+	dir_z = 0;
+	self.ideal_yaw = vectoyaw(dir);	
+};
+
+/*
+============
+FacingIdeal
+
+============
+*/
+float() FacingIdeal =
+{
+	local	float	delta;
+	
+	delta = anglemod(self.angles_y - self.ideal_yaw);
+	if (delta > 45 && delta < 315)
+		return FALSE;
+	return TRUE;
+};
+
+
+//=============================================================================
+
+float()	WizardCheckAttack;
+float()	DogCheckAttack;
+
+float() CheckAnyAttack =
+{
+	if (!enemy_vis)
+		return;
+	if (self.classname == "monster_army")
+		return SoldierCheckAttack ();
+	if (self.classname == "monster_ogre")
+		return OgreCheckAttack ();
+	if (self.classname == "monster_shambler")
+		return ShamCheckAttack ();
+	if (self.classname == "monster_demon1")
+		return DemonCheckAttack ();
+	if (self.classname == "monster_dog")
+		return DogCheckAttack ();
+	if (self.classname == "monster_wizard")
+		return WizardCheckAttack ();
+	return CheckAttack ();
+};
+
+
+/*
+=============
+ai_run_melee
+
+Turn and close until within an angle to launch a melee attack
+=============
+*/
+void() ai_run_melee =
+{
+	self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+
+	if (FacingIdeal())
+	{
+		self.th_melee ();
+		self.attack_state = AS_STRAIGHT;
+	}
+};
+
+
+/*
+=============
+ai_run_missile
+
+Turn in place until within an angle to launch a missile attack
+=============
+*/
+void() ai_run_missile =
+{
+	self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+	if (FacingIdeal())
+	{
+		self.th_missile ();
+		self.attack_state = AS_STRAIGHT;
+	}
+};
+
+
+/*
+=============
+ai_run_slide
+
+Strafe sideways, but stay at aproximately the same range
+=============
+*/
+void() ai_run_slide =
+{
+	local float	ofs;
+	
+	self.ideal_yaw = enemy_yaw;
+	ChangeYaw ();
+	if (self.lefty)
+		ofs = 90;
+	else
+		ofs = -90;
+	
+	if (walkmove (self.ideal_yaw + ofs, movedist))
+		return;
+		
+	self.lefty = 1 - self.lefty;
+	
+	walkmove (self.ideal_yaw - ofs, movedist);
+};
+
+
+/*
+=============
+ai_run
+
+The monster has an enemy it is trying to kill
+=============
+*/
+void(float dist) ai_run =
+{
+	local	vector	delta;
+	local	float	axis;
+	local	float	direct, ang_rint, ang_floor, ang_ceil;
+	
+	movedist = dist;
+// see if the enemy is dead
+	if (self.enemy.health <= 0)
+	{
+		self.enemy = world;
+	// FIXME: look all around for other targets
+		if (self.oldenemy.health > 0)
+		{
+			self.enemy = self.oldenemy;
+			HuntTarget ();
+		}
+		else
+		{
+			if (self.movetarget)
+				self.th_walk ();
+			else
+				self.th_stand ();
+			return;
+		}
+	}
+
+	self.show_hostile = time + 1;		// wake up other monsters
+
+// check knowledge of enemy
+	enemy_vis = visible(self.enemy);
+	if (enemy_vis)
+		self.search_time = time + 5;
+
+// look for other coop players
+	if (coop && self.search_time < time)
+	{
+		if (FindTarget ())
+			return;
+	}
+
+	enemy_infront = infront(self.enemy);
+	enemy_range = range(self.enemy);
+	enemy_yaw = vectoyaw(self.enemy.origin - self.origin);
+	
+	if (self.attack_state == AS_MISSILE)
+	{
+//dprint ("ai_run_missile\n");
+		ai_run_missile ();
+		return;
+	}
+	if (self.attack_state == AS_MELEE)
+	{
+//dprint ("ai_run_melee\n");
+		ai_run_melee ();
+		return;
+	}
+
+	if (CheckAnyAttack ())
+		return;					// beginning an attack
+		
+	if (self.attack_state == AS_SLIDING)
+	{
+		ai_run_slide ();
+		return;
+	}
+		
+// head straight in
+	movetogoal (dist);		// done in C code...
+};
+
+/*~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>
+~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~*/
+
+void() test_teleport_touch;
+void() tele_done;
+
+/*QUAKED test_teleport (0 .5 .8) ?
+Teleporter testing
+*/
+void() test_teleport =
+{
+	precache_model ("sprites/s_aball.spr");
+	setsize (self, self.mins, self.maxs);	
+	self.touch = test_teleport_touch;
+	self.solid = 1;
+	
+	if (!self.target)
+		objerror ("no target\n");
+};
+
+void() test_teleport_touch =
+{
+local entity oldself;
+	other.movetype = MOVETYPE_TOSS;
+//	other.solid = SOLID_NOT;
+	other.dest = '256 -128 -128';
+	oldself = self;
+	self = other;
+//	SUB_CalcMove (self.dest, 200, tele_done);
+	self.velocity = '1000 0 0 ';
+	self = oldself;
+};
+
+void() tele_done =
+{
+	self.movetype = MOVETYPE_WALK;
+	self.solid = SOLID_SLIDEBOX;	
+};
+
+/*~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>
+~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~*/
+
+void() test_goaway;
+void() test_spawn;
+
+/*QUAKED test_fodder (0 .5 .8) ?
+beating guy
+*/
+void() test_fodder =
+{
+	self.nextthink = time + 3;
+	self.think = test_spawn;
+};
+
+void() test_spawn =
+{
+local entity	body;
+	makevectors (self.angles);
+
+	body = spawn();
+	setmodel (body, "progs/soldier.mdl");
+	setorigin (body, self.origin);
+	body.classname = "player";
+	body.health = 1000;
+	body.frags = 0;
+	body.takedamage = DAMAGE_AIM;
+	body.solid = SOLID_SLIDEBOX;
+	body.movetype = MOVETYPE_WALK;
+	body.show_hostile = 0;
+	body.weapon = 1;
+	body.velocity = v_forward * 200;
+
+	body.nextthink = time + 5;
+	body.think = test_goaway;
+
+self.nextthink = time + 3;
+self.think = test_spawn;
+
+};
+
+void() test_goaway =
+{
+	remove (self);
+};
+
+/*
+==============================================================================
+
+BOSS-ONE
+
+==============================================================================
+*/
+$cd id1/models/boss1
+$origin 0 0 -15
+$base base
+$skin skin
+$scale 5
+
+$frame rise1 rise2 rise3 rise4 rise5 rise6 rise7 rise8 rise9 rise10
+$frame rise11 rise12 rise13 rise14 rise15 rise16 rise17 
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8
+$frame walk9 walk10 walk11 walk12 walk13 walk14 walk15
+$frame walk16 walk17 walk18 walk19 walk20 walk21 walk22
+$frame walk23 walk24 walk25 walk26 walk27 walk28 walk29 walk30 walk31
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8 death9
+
+$frame attack1 attack2 attack3 attack4 attack5 attack6 attack7 attack8
+$frame attack9 attack10 attack11 attack12 attack13 attack14 attack15
+$frame attack16 attack17 attack18 attack19 attack20 attack21 attack22
+$frame attack23
+
+$frame shocka1 shocka2 shocka3 shocka4 shocka5 shocka6 shocka7 shocka8
+$frame shocka9 shocka10 
+
+$frame shockb1 shockb2 shockb3 shockb4 shockb5 shockb6
+
+$frame shockc1 shockc2 shockc3 shockc4 shockc5 shockc6 shockc7 shockc8 
+$frame shockc9 shockc10
+
+
+void(vector p) boss_missile;
+
+void() boss_face =
+{
+	
+// go for another player if multi player
+	if (self.enemy.health <= 0 || random() < 0.02)
+	{
+		self.enemy = find(self.enemy, classname, "player");
+		if (!self.enemy)
+			self.enemy = find(self.enemy, classname, "player");
+	}
+	ai_face();
+};
+
+void() boss_rise1	=[	$rise1, boss_rise2 ] {
+sound (self, CHAN_WEAPON, "boss1/out1.wav", 1, ATTN_NORM);
+};
+void() boss_rise2	=[	$rise2, boss_rise3 ] {
+sound (self, CHAN_VOICE, "boss1/sight1.wav", 1, ATTN_NORM);
+};
+void() boss_rise3	=[	$rise3, boss_rise4 ] {};
+void() boss_rise4	=[	$rise4, boss_rise5 ] {};
+void() boss_rise5	=[	$rise5, boss_rise6 ] {};
+void() boss_rise6	=[	$rise6, boss_rise7 ] {};
+void() boss_rise7	=[	$rise7, boss_rise8 ] {};
+void() boss_rise8	=[	$rise8, boss_rise9 ] {};
+void() boss_rise9	=[	$rise9, boss_rise10 ] {};
+void() boss_rise10	=[	$rise10, boss_rise11 ] {};
+void() boss_rise11	=[	$rise11, boss_rise12 ] {};
+void() boss_rise12	=[	$rise12, boss_rise13 ] {};
+void() boss_rise13	=[	$rise13, boss_rise14 ] {};
+void() boss_rise14	=[	$rise14, boss_rise15 ] {};
+void() boss_rise15	=[	$rise15, boss_rise16 ] {};
+void() boss_rise16	=[	$rise16, boss_rise17 ] {};
+void() boss_rise17	=[	$rise17, boss_missile1 ] {};
+
+void() boss_idle1	=[	$walk1, boss_idle2 ]
+{
+// look for other players
+};
+void() boss_idle2	=[	$walk2, boss_idle3 ] {boss_face();};
+void() boss_idle3	=[	$walk3, boss_idle4 ] {boss_face();};
+void() boss_idle4	=[	$walk4, boss_idle5 ] {boss_face();};
+void() boss_idle5	=[	$walk5, boss_idle6 ] {boss_face();};
+void() boss_idle6	=[	$walk6, boss_idle7 ] {boss_face();};
+void() boss_idle7	=[	$walk7, boss_idle8 ] {boss_face();};
+void() boss_idle8	=[	$walk8, boss_idle9 ] {boss_face();};
+void() boss_idle9	=[	$walk9, boss_idle10 ] {boss_face();};
+void() boss_idle10	=[	$walk10, boss_idle11 ] {boss_face();};
+void() boss_idle11	=[	$walk11, boss_idle12 ] {boss_face();};
+void() boss_idle12	=[	$walk12, boss_idle13 ] {boss_face();};
+void() boss_idle13	=[	$walk13, boss_idle14 ] {boss_face();};
+void() boss_idle14	=[	$walk14, boss_idle15 ] {boss_face();};
+void() boss_idle15	=[	$walk15, boss_idle16 ] {boss_face();};
+void() boss_idle16	=[	$walk16, boss_idle17 ] {boss_face();};
+void() boss_idle17	=[	$walk17, boss_idle18 ] {boss_face();};
+void() boss_idle18	=[	$walk18, boss_idle19 ] {boss_face();};
+void() boss_idle19	=[	$walk19, boss_idle20 ] {boss_face();};
+void() boss_idle20	=[	$walk20, boss_idle21 ] {boss_face();};
+void() boss_idle21	=[	$walk21, boss_idle22 ] {boss_face();};
+void() boss_idle22	=[	$walk22, boss_idle23 ] {boss_face();};
+void() boss_idle23	=[	$walk23, boss_idle24 ] {boss_face();};
+void() boss_idle24	=[	$walk24, boss_idle25 ] {boss_face();};
+void() boss_idle25	=[	$walk25, boss_idle26 ] {boss_face();};
+void() boss_idle26	=[	$walk26, boss_idle27 ] {boss_face();};
+void() boss_idle27	=[	$walk27, boss_idle28 ] {boss_face();};
+void() boss_idle28	=[	$walk28, boss_idle29 ] {boss_face();};
+void() boss_idle29	=[	$walk29, boss_idle30 ] {boss_face();};
+void() boss_idle30	=[	$walk30, boss_idle31 ] {boss_face();};
+void() boss_idle31	=[	$walk31, boss_idle1 ] {boss_face();};
+
+void() boss_missile1	=[	$attack1, boss_missile2 ] {boss_face();};
+void() boss_missile2	=[	$attack2, boss_missile3 ] {boss_face();};
+void() boss_missile3	=[	$attack3, boss_missile4 ] {boss_face();};
+void() boss_missile4	=[	$attack4, boss_missile5 ] {boss_face();};
+void() boss_missile5	=[	$attack5, boss_missile6 ] {boss_face();};
+void() boss_missile6	=[	$attack6, boss_missile7 ] {boss_face();};
+void() boss_missile7	=[	$attack7, boss_missile8 ] {boss_face();};
+void() boss_missile8	=[	$attack8, boss_missile9 ] {boss_face();};
+void() boss_missile9	=[	$attack9, boss_missile10 ] {boss_missile('100 100 200');};
+void() boss_missile10	=[	$attack10, boss_missile11 ] {boss_face();};
+void() boss_missile11	=[	$attack11, boss_missile12 ] {boss_face();};
+void() boss_missile12	=[	$attack12, boss_missile13 ] {boss_face();};
+void() boss_missile13	=[	$attack13, boss_missile14 ] {boss_face();};
+void() boss_missile14	=[	$attack14, boss_missile15 ] {boss_face();};
+void() boss_missile15	=[	$attack15, boss_missile16 ] {boss_face();};
+void() boss_missile16	=[	$attack16, boss_missile17 ] {boss_face();};
+void() boss_missile17	=[	$attack17, boss_missile18 ] {boss_face();};
+void() boss_missile18	=[	$attack18, boss_missile19 ] {boss_face();};
+void() boss_missile19	=[	$attack19, boss_missile20 ] {boss_face();};
+void() boss_missile20	=[	$attack20, boss_missile21 ] {boss_missile('100 -100 200');};
+void() boss_missile21	=[	$attack21, boss_missile22 ] {boss_face();};
+void() boss_missile22	=[	$attack22, boss_missile23 ] {boss_face();};
+void() boss_missile23	=[	$attack23, boss_missile1 ] {boss_face();};
+
+void() boss_shocka1 =[	$shocka1, boss_shocka2 ] {};
+void() boss_shocka2 =[	$shocka2, boss_shocka3 ] {};
+void() boss_shocka3 =[	$shocka3, boss_shocka4 ] {};
+void() boss_shocka4 =[	$shocka4, boss_shocka5 ] {};
+void() boss_shocka5 =[	$shocka5, boss_shocka6 ] {};
+void() boss_shocka6 =[	$shocka6, boss_shocka7 ] {};
+void() boss_shocka7 =[	$shocka7, boss_shocka8 ] {};
+void() boss_shocka8 =[	$shocka8, boss_shocka9 ] {};
+void() boss_shocka9 =[	$shocka9, boss_shocka10 ] {};
+void() boss_shocka10 =[	$shocka10, boss_missile1 ] {};
+
+void() boss_shockb1 =[	$shockb1, boss_shockb2 ] {};
+void() boss_shockb2 =[	$shockb2, boss_shockb3 ] {};
+void() boss_shockb3 =[	$shockb3, boss_shockb4 ] {};
+void() boss_shockb4 =[	$shockb4, boss_shockb5 ] {};
+void() boss_shockb5 =[	$shockb5, boss_shockb6 ] {};
+void() boss_shockb6 =[	$shockb6, boss_shockb7 ] {};
+void() boss_shockb7 =[	$shockb1, boss_shockb8 ] {};
+void() boss_shockb8 =[	$shockb2, boss_shockb9 ] {};
+void() boss_shockb9 =[	$shockb3, boss_shockb10 ] {};
+void() boss_shockb10 =[	$shockb4, boss_missile1 ] {};
+
+void() boss_shockc1 =[	$shockc1, boss_shockc2 ] {};
+void() boss_shockc2 =[	$shockc2, boss_shockc3 ] {};
+void() boss_shockc3 =[	$shockc3, boss_shockc4 ] {};
+void() boss_shockc4 =[	$shockc4, boss_shockc5 ] {};
+void() boss_shockc5 =[	$shockc5, boss_shockc6 ] {};
+void() boss_shockc6 =[	$shockc6, boss_shockc7 ] {};
+void() boss_shockc7 =[	$shockc7, boss_shockc8 ] {};
+void() boss_shockc8 =[	$shockc8, boss_shockc9 ] {};
+void() boss_shockc9 =[	$shockc9, boss_shockc10 ] {};
+void() boss_shockc10 =[	$shockc10, boss_death1 ] {};
+
+void() boss_death1 = [$death1, boss_death2] {
+sound (self, CHAN_VOICE, "boss1/death.wav", 1, ATTN_NORM);
+};
+void() boss_death2 = [$death2, boss_death3] {};
+void() boss_death3 = [$death3, boss_death4] {};
+void() boss_death4 = [$death4, boss_death5] {};
+void() boss_death5 = [$death5, boss_death6] {};
+void() boss_death6 = [$death6, boss_death7] {};
+void() boss_death7 = [$death7, boss_death8] {};
+void() boss_death8 = [$death8, boss_death9] {};
+void() boss_death9 = [$death9, boss_death10]
+{
+	sound (self, CHAN_BODY, "boss1/out1.wav", 1, ATTN_NORM);
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LAVASPLASH);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+};
+
+void() boss_death10 = [$death9, boss_death10]
+{
+	killed_monsters = killed_monsters + 1;
+	WriteByte (MSG_ALL, SVC_KILLEDMONSTER);	// FIXME: reliable broadcast
+	SUB_UseTargets ();
+	remove (self);
+};
+
+void(vector p) boss_missile =
+{
+	local	vector	offang;
+	local	vector	org, vec, d;
+	local	float	t;
+
+	offang = vectoangles (self.enemy.origin - self.origin);	
+	makevectors (offang);
+
+	org = self.origin + p_x*v_forward + p_y*v_right + p_z*'0 0 1';
+	
+// lead the player on hard mode
+	if (skill > 1)
+	{
+		t = vlen(self.enemy.origin - org) / 300;
+		vec = self.enemy.velocity;
+		vec_z = 0;
+		d = self.enemy.origin + t * vec;		
+	}
+	else
+	{
+		d = self.enemy.origin;
+	}
+	
+	vec = normalize (d - org);
+
+	launch_spike (org, vec);
+	setmodel (newmis, "progs/lavaball.mdl");
+	newmis.avelocity = '200 100 300';
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	newmis.velocity = vec*300;
+	newmis.touch = T_MissileTouch; // rocket explosion
+	sound (self, CHAN_WEAPON, "boss1/throw.wav", 1, ATTN_NORM);
+
+// check for dead enemy
+	if (self.enemy.health <= 0)
+		boss_idle1 ();
+};
+
+
+void() boss_awake =
+{
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+	self.takedamage = DAMAGE_NO;
+	
+	setmodel (self, "progs/boss.mdl");
+	setsize (self, '-128 -128 -24', '128 128 256');
+	
+	if (skill == 0)
+		self.health = 1;
+	else
+		self.health = 3;
+
+	self.enemy = activator;
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LAVASPLASH);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	self.yaw_speed = 20;
+	boss_rise1 ();
+};
+
+
+/*QUAKED monster_boss (1 0 0) (-128 -128 -24) (128 128 256)
+*/
+void() monster_boss =
+{
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model ("progs/boss.mdl");
+	precache_model ("progs/lavaball.mdl");
+
+	precache_sound ("weapons/rocket1i.wav");
+	precache_sound ("boss1/out1.wav");
+	precache_sound ("boss1/sight1.wav");
+	precache_sound ("misc/power.wav");
+	precache_sound ("boss1/throw.wav");
+	precache_sound ("boss1/pain.wav");
+	precache_sound ("boss1/death.wav");
+
+	total_monsters = total_monsters + 1;
+
+	self.use = boss_awake;
+};
+
+//===========================================================================
+
+entity	le1, le2;
+float	lightning_end;
+
+void() lightning_fire =
+{
+	local vector p1, p2;
+	
+	if (time >= lightning_end)
+	{	// done here, put the terminals back up
+		self = le1;
+		door_go_down ();
+		self = le2;
+		door_go_down ();
+		return;
+	}
+	
+	p1 = (le1.mins + le1.maxs) * 0.5;
+	p1_z = le1.absmin_z - 16;
+	
+	p2 = (le2.mins + le2.maxs) * 0.5;
+	p2_z = le2.absmin_z - 16;
+	
+	// compensate for length of bolt
+	p2 = p2 - normalize(p2-p1)*100;
+
+	self.nextthink = time + 0.1;
+	self.think = lightning_fire;
+
+	WriteByte (MSG_ALL, SVC_TEMPENTITY);
+	WriteByte (MSG_ALL, TE_LIGHTNING3);
+	WriteEntity (MSG_ALL, world);
+	WriteCoord (MSG_ALL, p1_x);
+	WriteCoord (MSG_ALL, p1_y);
+	WriteCoord (MSG_ALL, p1_z);
+	WriteCoord (MSG_ALL, p2_x);
+	WriteCoord (MSG_ALL, p2_y);
+	WriteCoord (MSG_ALL, p2_z);
+};
+
+void() lightning_use =
+{
+	if (lightning_end >= time + 1)
+		return;
+
+	le1 = find( world, target, "lightning");
+	le2 = find( le1, target, "lightning");
+	if (!le1 || !le2)
+	{
+		dprint ("missing lightning targets\n");
+		return;
+	}
+	
+	if (
+	 (le1.state != STATE_TOP && le1.state != STATE_BOTTOM)
+	|| (le2.state != STATE_TOP && le2.state != STATE_BOTTOM)
+	|| (le1.state != le2.state) )
+	{
+//		dprint ("not aligned\n");
+		return;
+	}
+
+// don't let the electrodes go back up until the bolt is done
+	le1.nextthink = -1;
+	le2.nextthink = -1;
+	lightning_end = time + 1;
+
+	sound (self, CHAN_VOICE, "misc/power.wav", 1, ATTN_NORM);
+	lightning_fire ();		
+
+// advance the boss pain if down
+	self = find (world, classname, "monster_boss");
+	if (!self)
+		return;
+	self.enemy = activator;
+	if (le1.state == STATE_TOP && self.health > 0)
+	{
+		sound (self, CHAN_VOICE, "boss1/pain.wav", 1, ATTN_NORM);
+		self.health = self.health - 1;
+		if (self.health >= 2)
+			boss_shocka1();
+		else if (self.health == 1)
+			boss_shockb1();
+		else if (self.health == 0)
+			boss_shockc1();
+	}	
+};
+
+
+/*QUAKED event_lightning (0 1 1) (-16 -16 -16) (16 16 16)
+Just for boss level.
+*/
+void() event_lightning =
+{
+	self.use = lightning_use;
+};
+
+
+// button and multiple button
+
+void() button_wait;
+void() button_return;
+
+void() button_wait =
+{
+	self.state = STATE_TOP;
+	self.nextthink = self.ltime + self.wait;
+	self.think = button_return;
+	activator = self.enemy;
+	SUB_UseTargets();
+	self.frame = 1;			// use alternate textures
+};
+
+void() button_done =
+{
+	self.state = STATE_BOTTOM;
+};
+
+void() button_return =
+{
+	self.state = STATE_DOWN;
+	SUB_CalcMove (self.pos1, self.speed, button_done);
+	self.frame = 0;			// use normal textures
+	if (self.health)
+		self.takedamage = DAMAGE_YES;	// can be shot again
+};
+
+
+void() button_blocked =
+{	// do nothing, just don't ome all the way back out
+};
+
+
+void() button_fire =
+{
+	if (self.state == STATE_UP || self.state == STATE_TOP)
+		return;
+
+	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+
+	self.state = STATE_UP;
+	SUB_CalcMove (self.pos2, self.speed, button_wait);
+};
+
+
+void() button_use =
+{
+	self.enemy = activator;
+	button_fire ();
+};
+
+void() button_touch =
+{
+	if (other.classname != "player")
+		return;
+	self.enemy = other;
+	button_fire ();
+};
+
+void() button_killed =
+{
+	self.enemy = damage_attacker;
+	self.health = self.max_health;
+	self.takedamage = DAMAGE_NO;	// wil be reset upon return
+	button_fire ();
+};
+
+
+/*QUAKED func_button (0 .5 .8) ?
+When a button is touched, it moves some distance in the direction of it's angle, triggers all of it's targets, waits some time, then returns to it's original position where it can be triggered again.
+
+"angle"		determines the opening direction
+"target"	all entities with a matching targetname will be used
+"speed"		override the default 40 speed
+"wait"		override the default 1 second wait (-1 = never return)
+"lip"		override the default 4 pixel lip remaining at end of move
+"health"	if set, the button must be killed instead of touched
+"sounds"
+0) steam metal
+1) wooden clunk
+2) metallic click
+3) in-out
+*/
+void() func_button =
+{
+local float		gtemp, ftemp;
+
+	if (self.sounds == 0)
+	{
+		precache_sound ("buttons/airbut1.wav");
+		self.noise = "buttons/airbut1.wav";
+	}
+	if (self.sounds == 1)
+	{
+		precache_sound ("buttons/switch21.wav");
+		self.noise = "buttons/switch21.wav";
+	}
+	if (self.sounds == 2)
+	{
+		precache_sound ("buttons/switch02.wav");
+		self.noise = "buttons/switch02.wav";
+	}
+	if (self.sounds == 3)
+	{
+		precache_sound ("buttons/switch04.wav");
+		self.noise = "buttons/switch04.wav";
+	}
+	
+	SetMovedir ();
+
+	self.movetype = MOVETYPE_PUSH;
+	self.solid = SOLID_BSP;
+	setmodel (self, self.model);
+
+	self.blocked = button_blocked;
+	self.use = button_use;
+
+	if (self.health)
+	{
+		self.max_health = self.health;
+		self.th_die = button_killed;
+		self.takedamage = DAMAGE_YES;
+	}
+	else
+		self.touch = button_touch;
+
+	if (!self.speed)
+		self.speed = 40;
+	if (!self.wait)
+		self.wait = 1;
+	if (!self.lip)
+		self.lip = 4;
+
+	self.state = STATE_BOTTOM;
+
+	self.pos1 = self.origin;
+	self.pos2 = self.pos1 + self.movedir*(fabs(self.movedir*self.size) - self.lip);
+};
+
+
+// prototypes
+void () W_WeaponFrame;
+void() W_SetCurrentAmmo;
+void() player_pain;
+void() player_stand1;
+void (vector org) spawn_tfog;
+void (vector org, entity death_owner) spawn_tdeath;
+void() UnHookPlayer;
+
+float	modelindex_eyes, modelindex_player;
+float pregameover;
+
+
+// ZOID: with several effects doing the dimlight thing, they just can't
+// turn it off.  Do not set self.effects with EF_DIMLIGHT directly.  This
+// will automatically do it when CheckPowerups is called
+// EF_DIMLIGHT is used;
+// 1. Invincible (Pentagram)
+// 2. Super Damage (Quad Power)
+// 3. Having Flag in Capture
+// self is player
+void () CheckDimLight = {
+	local float flag;
+
+	flag = 0;
+	// invincable
+	if (self.invincible_finished > time)
+		flag = 1;
+	// quad
+	if (self.super_damage_finished > time)
+		flag = 1;
+	// flag
+//	if (self.player_flag & ITEM_ENEMY_FLAG)
+//		flag = 1;
+
+	if (flag)
+		self.effects = self.effects | EF_DIMLIGHT;
+	else
+		self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+};
+
+/*
+=============================================================================
+
+				LEVEL CHANGING / INTERMISSION
+
+=============================================================================
+*/
+
+float	intermission_running;
+float	intermission_exittime;
+
+/*QUAKED info_intermission (1 0.5 0.5) (-16 -16 -16) (16 16 16)
+This is the camera point for the intermission.
+Use mangle instead of angle, so you can set pitch or roll as well as yaw.  'pitch roll yaw'
+*/
+void() info_intermission =
+{
+};
+
+void() SetChangeParms =
+{
+	if (self.health <= 0)
+	{
+		SetNewParms ();
+// *TEAMPLAY*
+		parm10 = self.lastteam;	// Save the current team of the player
+		parm11 = self.CamState;
+		parm15 = self.accesslvl; // remote admin state
+		parm16 = self.player_flag;
+		return;
+	}
+
+// remove items
+	self.items = self.items - (self.items & 
+	(IT_KEY1 | IT_KEY2 | IT_INVISIBILITY | IT_INVULNERABILITY | IT_SUIT | IT_QUAD) );
+
+// cap super health
+	if (self.health > 100)
+		self.health = 100;
+	if (self.health < 50)
+		self.health = 50;
+	SetNewParms();
+// *TEAMPLAY*
+	if (gamestart || self.observer)
+		parm10 = -1;
+	else
+		parm10 = self.lastteam;	// Save the current team of the player
+	parm11 = self.CamState;
+	parm15 = self.accesslvl; // remote admin state
+	parm16 = self.player_flag;
+};
+
+void() SetNewParms =
+{
+	if (gamestart && !pregameover) {
+		parm1 = IT_AXE;
+		parm2 = 100;
+		parm4 = 0;
+		parm8 = IT_AXE;
+		parm10 = 1;
+	} else {
+		parm1 = IT_SHOTGUN | IT_AXE | IT_HOOK;
+		parm2 = 100;
+		parm3 = 50;
+		parm9 = 30;
+		parm1 = parm1 + IT_ARMOR1;
+		parm4 = 40;
+		parm8 = IT_SHOTGUN;
+		parm10 = -1;	// Reset 
+	}
+	parm5 = 0;
+	parm6 = 0;
+	parm7 = 0;
+// *TEAMPLAY*
+	parm11 = CAM_NOT;
+	parm15 = 0; // remote admin
+	parm16 = 0;
+};
+
+void() DecodeLevelParms =
+{
+	self.player_flag = self.player_flag | parm16;
+	self.player_flag = self.player_flag - (self.player_flag & ITEM_RUNE_MASK);
+	self.player_flag = self.player_flag - (self.player_flag & ITEM_ENEMY_FLAG);
+	self.skin = (self.player_flag & 65280)/256;
+	self.accesslvl = parm15;
+
+	if (gamestart)
+		SetNewParms ();		// take away all stuff on starting new episode
+	
+	self.items = parm1;
+	self.health = parm2;
+	self.armorvalue = parm3;
+	self.ammo_shells = parm4;
+	self.ammo_nails = parm5;
+	self.ammo_rockets = parm6;
+	self.ammo_cells = parm7;
+	self.weapon = parm8;
+	self.armortype = parm9 * 0.01;
+
+	// *XXX* EXPERT CTF
+
+	// Reset times for additional scoring system on level change and server join
+	// dprint("decode level parms\n");
+	self.last_returned_flag = -10;
+	self.last_fragged_carrier = -10;
+	self.flag_since = -10;
+	self.last_hurt_carrier = -10;
+
+	if (parm11 > CAM_NOT)
+		self.CamState = CAM_PREBECOME;
+
+// *TEAMPLAY*
+	if(TeamColorIsLegal(parm10))
+		self.lastteam = parm10;
+};
+
+/*
+============
+FindIntermission
+
+Returns the entity to view from
+============
+*/
+entity() FindIntermission =
+{
+	local	entity spot;
+	local	float cyc;
+
+// look for info_intermission first
+	spot = find (world, classname, "info_intermission");
+	if (spot)
+	{	// pick a random one
+		cyc = random() * 4;
+		while (cyc > 1)
+		{
+			spot = find (spot, classname, "info_intermission");
+			if (!spot)
+				spot = find (spot, classname, "info_intermission");
+			cyc = cyc - 1;
+		}
+		return spot;
+	}
+
+// then look for the start position
+	spot = find (world, classname, "info_player_start");
+	if (spot)
+		return spot;
+	
+// testinfo_player_start is only found in regioned levels
+	spot = find (world, classname, "testplayerstart");
+	if (spot)
+		return spot;
+	
+	objerror ("FindIntermission: no spot");
+};
+
+
+string nextmap;
+void() GotoNextMap =
+{
+	if (cvar("samelevel"))	// if samelevel is set, stay on same level
+		changelevel (mapname);
+	else {
+		if (nextmap == "e1m7") // skip House of Chthon
+			nextmap = "e1m8";
+		else if (nextmap == "start" && (teamplay & TEAM_CAPTURE_CUSTOM))
+			nextmap = "ctfstart";
+		else if (nextmap == "ctf9")
+			nextmap = "ctf2m1";
+		else if (nextmap == "end")
+			nextmap = "dm1";
+
+		changelevel (nextmap);
+	}
+};
+
+
+void() ExitIntermission =
+{
+// skip any text in deathmatch
+	if (deathmatch)
+	{
+		GotoNextMap ();
+		return;
+	}
+	
+	intermission_exittime = time + 1;
+	intermission_running = intermission_running + 1;
+
+//
+// run some text if at the end of an episode
+//
+	if (intermission_running == 2)
+	{
+		if (world.model == "maps/e1m7.bsp")
+		{
+			WriteByte (MSG_ALL, SVC_CDTRACK);
+			WriteByte (MSG_ALL, 2);
+			WriteByte (MSG_ALL, 3);
+			if (!cvar("registered"))
+			{
+				WriteByte (MSG_ALL, SVC_FINALE);
+				WriteString (MSG_ALL, "As the corpse of the monstrous entity\nChthon sinks back into the lava whence\nit rose, you grip the Rune of Earth\nMagic tightly. Now that you have\nconquered the Dimension of the Doomed,\nrealm of Earth Magic, you are ready to\ncomplete your task in the other three\nhaunted lands of Quake. Or are you? If\nyou don't register Quake, you'll never\nknow what awaits you in the Realm of\nBlack Magic, the Netherworld, and the\nElder World!");
+			}
+			else
+			{
+				WriteByte (MSG_ALL, SVC_FINALE);
+				WriteString (MSG_ALL, "As the corpse of the monstrous entity\nChthon sinks back into the lava whence\nit rose, you grip the Rune of Earth\nMagic tightly. Now that you have\nconquered the Dimension of the Doomed,\nrealm of Earth Magic, you are ready to\ncomplete your task. A Rune of magic\npower lies at the end of each haunted\nland of Quake. Go forth, seek the\ntotality of the four Runes!");
+			}
+			return;
+		}
+		else if (world.model == "maps/e2m6.bsp")
+		{
+			WriteByte (MSG_ALL, SVC_CDTRACK);
+			WriteByte (MSG_ALL, 2);
+			WriteByte (MSG_ALL, 3);
+
+			WriteByte (MSG_ALL, SVC_FINALE);
+			WriteString (MSG_ALL, "The Rune of Black Magic throbs evilly in\nyour hand and whispers dark thoughts\ninto your brain. You learn the inmost\nlore of the Hell-Mother; Shub-Niggurath!\nYou now know that she is behind all the\nterrible plotting which has led to so\nmuch death and horror. But she is not\ninviolate! Armed with this Rune, you\nrealize that once all four Runes are\ncombined, the gate to Shub-Niggurath's\nPit will open, and you can face the\nWitch-Goddess herself in her frightful\notherworld cathedral.");
+			return;
+		}
+		else if (world.model == "maps/e3m6.bsp")
+		{
+			WriteByte (MSG_ALL, SVC_CDTRACK);
+			WriteByte (MSG_ALL, 2);
+			WriteByte (MSG_ALL, 3);
+
+			WriteByte (MSG_ALL, SVC_FINALE);
+			WriteString (MSG_ALL, "The charred viscera of diabolic horrors\nbubble viscously as you seize the Rune\nof Hell Magic. Its heat scorches your\nhand, and its terrible secrets blight\nyour mind. Gathering the shreds of your\ncourage, you shake the devil's shackles\nfrom your soul, and become ever more\nhard and determined to destroy the\nhideous creatures whose mere existence\nthreatens the souls and psyches of all\nthe population of Earth.");
+			return;
+		}
+		else if (world.model == "maps/e4m7.bsp")
+		{
+			WriteByte (MSG_ALL, SVC_CDTRACK);
+			WriteByte (MSG_ALL, 2);
+			WriteByte (MSG_ALL, 3);
+
+			WriteByte (MSG_ALL, SVC_FINALE);
+			WriteString (MSG_ALL, "Despite the awful might of the Elder\nWorld, you have achieved the Rune of\nElder Magic, capstone of all types of\narcane wisdom. Beyond good and evil,\nbeyond life and death, the Rune\npulsates, heavy with import. Patient and\npotent, the Elder Being Shub-Niggurath\nweaves her dire plans to clear off all\nlife from the Earth, and bring her own\nfoul offspring to our world! For all the\ndwellers in these nightmare dimensions\nare her descendants! Once all Runes of\nmagic power are united, the energy\nbehind them will blast open the Gateway\nto Shub-Niggurath, and you can travel\nthere to foil the Hell-Mother's plots\nin person.");
+			return;
+		}
+
+		GotoNextMap();
+	}
+	
+	if (intermission_running == 3)
+	{
+		if (!cvar("registered"))
+		{	// shareware episode has been completed, go to sell screen
+			WriteByte (MSG_ALL, SVC_SELLSCREEN);
+			return;
+		}
+		
+		if ( (serverflags&15) == 15)
+		{
+			WriteByte (MSG_ALL, SVC_FINALE);
+			WriteString (MSG_ALL, "Now, you have all four Runes. You sense\ntremendous invisible forces moving to\nunseal ancient barriers. Shub-Niggurath\nhad hoped to use the Runes Herself to\nclear off the Earth, but now instead,\nyou will use them to enter her home and\nconfront her as an avatar of avenging\nEarth-life. If you defeat her, you will\nbe remembered forever as the savior of\nthe planet. If she conquers, it will be\nas if you had never been born.");
+			return;
+		}
+		
+	}
+
+	GotoNextMap();
+};
+
+/*
+============
+IntermissionThink
+
+When the player presses attack or jump, change to the next level
+============
+*/
+void() IntermissionThink =
+{
+	if (time < intermission_exittime)
+		return;
+
+	if (!self.button0 && !self.button1 && !self.button2)
+		return;
+	
+	ExitIntermission ();
+};
+
+void() execute_changelevel =
+{
+	local entity	pos;
+
+	intermission_running = 1;
+	
+// enforce a wait time before allowing changelevel
+	if (deathmatch)
+		intermission_exittime = time + 8;
+	else
+		intermission_exittime = time + 2;
+
+	WriteByte (MSG_ALL, SVC_CDTRACK);
+	WriteByte (MSG_ALL, 3);
+	WriteByte (MSG_ALL, 3);
+	
+	pos = FindIntermission ();
+
+	other = find (world, classname, "player");
+	while (other != world)
+	{
+		other.view_ofs = '0 0 0';
+		other.angles = other.v_angle = pos.mangle;
+		other.fixangle = TRUE;		// turn this way immediately
+		other.nextthink = time + 0.5;
+		other.takedamage = DAMAGE_NO;
+		other.solid = SOLID_NOT;
+		other.movetype = MOVETYPE_NONE;
+		other.modelindex = 0;
+		setorigin (other, pos.origin);
+		other = find (other, classname, "player");
+	}	
+
+	WriteByte (MSG_ALL, SVC_INTERMISSION);
+};
+
+
+void() changelevel_touch =
+{
+	local entity	pos;
+	local float noexit;
+
+	if (other.classname != "player")
+		return;
+
+	noexit = cvar("noexit");
+
+	if (noexit == 1 || (noexit == 2 && !gamestart))
+		return; // do nothing
+
+	if (coop || deathmatch)
+	{
+		bprint (other.netname);
+		bprint (" exited the level\n");
+	}
+	
+	nextmap = self.map;
+
+	SUB_UseTargets ();
+
+	if ( (self.spawnflags & 1) && (deathmatch == 0) )
+	{	// NO_INTERMISSION
+		GotoNextMap();
+		return;
+	}
+	
+	self.touch = SUB_Null;
+
+// we can't move people right now, because touch functions are called
+// in the middle of C movement code, so set a think time to do it
+	self.think = execute_changelevel;
+	self.nextthink = time + 0.1;
+};
+
+/*QUAKED trigger_changelevel (0.5 0.5 0.5) ? NO_INTERMISSION
+When the player touches this, he gets sent to the map listed in the "map" variable.  Unless the NO_INTERMISSION flag is set, the view will go to the info_intermission spot and display stats.
+*/
+void() trigger_changelevel =
+{
+// ZOID:  If we are in CTF on start map, but not custom, change these
+// info trigger vote exits
+	if (gamestart && !(teamplay & TEAM_CAPTURE_CUSTOM)) {
+		if (self.map == "e1m1")
+			self.message = "E1 Dimension of the Doomed";
+		else if (self.map == "e2m1")
+			self.message = "E2 The Realm of Black Magic";
+		else if (self.map == "e3m1")
+			self.message = "E3 The Netherworld";
+		else if (self.map == "e4m1")
+			self.message = "E4 The Elder World";
+		else if (self.map == "end")
+			self.message = "The Deathmatch Arenas";
+		else
+			self.message = "Unknown";
+		self.classname = "trigger_voteexit";
+		trigger_voteexit();
+		return;
+	}
+
+	if (!self.map)
+		objerror ("chagnelevel trigger doesn't have map");
+	
+	InitTrigger ();
+	self.touch = changelevel_touch;
+};
+
+
+/*
+=============================================================================
+
+				PLAYER GAME EDGE FUNCTIONS
+
+=============================================================================
+*/
+
+void() set_suicide_frame;
+
+// called by ClientKill and DeadThink
+void() respawn =
+{
+	// make a copy of the dead body for appearances sake
+	CopyToBodyQue (self);
+	// set default spawn parms
+	SetNewParms ();
+	// respawn		
+	PutClientInServer ();
+};
+
+
+/*
+============
+ClientKill
+
+Player entered the suicide command
+============
+*/
+void() ClientKill =
+{
+	if (self.observer)
+		return; // can't suicide when observer
+
+	if (gamestart) {
+		sprint(self, "Life just started.\n");
+		return;
+	}
+
+	if (self.suicide_count > 3) {
+		sprint(self, "You have suicided too much already.\n");
+		return;
+	}
+	bprint (self.netname);
+	bprint (" suicides\n");
+	DropRune();
+    TeamCaptureDropFlagOfPlayer(self);
+	UnHookPlayer();
+	set_suicide_frame ();
+	self.modelindex = modelindex_player;
+	self.frags = self.frags - 2;	// extra penalty
+	self.suicide_count = self.suicide_count + 1;
+	respawn ();
+};
+
+void() SilentKill =
+{
+	set_suicide_frame ();
+	self.modelindex = modelindex_player;
+	respawn ();
+};
+
+float(vector v) CheckSpawnPoint =
+{
+	return FALSE;
+};
+
+/*
+============
+SelectSpawnPoint
+
+Returns the entity to spawn at
+============
+*/
+entity() SelectSpawnPoint =
+{
+	local	entity spot;
+	
+// testinfo_player_start is only found in regioned levels
+	spot = find (world, classname, "testplayerstart");
+	if (spot)
+		return spot;
+		
+// choose a info_player_deathmatch point
+	if (coop)
+	{
+		lastspawn = find(lastspawn, classname, "info_player_coop");
+		if (lastspawn == world)
+			lastspawn = find (lastspawn, classname, "info_player_start");
+		if (lastspawn != world)
+			return lastspawn;
+	}
+	else if (deathmatch)
+	{
+		if (!self.killed) {
+			spot = TeamCaptureSpawn();
+			if (spot != world) 
+				return spot;
+		} else if (gamestart && self.killed && (teamplay & TEAM_CAPTURE_CUSTOM)) {
+			lastvotespawn = find(lastvotespawn, classname, "info_vote_destination");
+			if (lastvotespawn == world)
+				lastvotespawn = find(lastvotespawn, classname, "info_vote_destination");
+			return lastvotespawn;
+		}
+	
+		lastspawn = find(lastspawn, classname, "info_player_deathmatch");
+		if (lastspawn == world)
+			lastspawn = find (lastspawn, classname, "info_player_deathmatch");
+		if (lastspawn != world)
+			return lastspawn;
+	}
+
+	if (serverflags)
+	{	// return with a rune to start
+		spot = find (world, classname, "info_player_start2");
+		if (spot)
+			return spot;
+	}
+	
+	spot = find (world, classname, "info_player_start");
+	if (!spot)
+		error ("PutClientInServer: no info_player_start on level");
+	
+	return spot;
+};
+
+/*
+===========
+PutClientInServer
+
+called each time a player is spawned
+============
+*/
+void() DecodeLevelParms;
+void() PlayerDie;
+
+
+void() PutClientInServer =
+{
+	local	entity spot;
+
+	spot = SelectSpawnPoint ();
+//ZOID: Minimize chance of telefragging someone, from Johannes Plass
+//(plass@dipmza.physik.uni-mainz.de) ServerModules package
+	spot = TelefragSelectSpawnPoint(spot);
+
+	self.classname = "player";
+	self.health = 100;
+	self.takedamage = DAMAGE_AIM;
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_WALK;
+	self.show_hostile = 0;
+	self.max_health = 100;
+	self.flags = FL_CLIENT;
+	self.air_finished = time + 12;
+	self.dmg = 2;   		// initial water damage
+	self.super_damage_finished = 0;
+	self.radsuit_finished = 0;
+	self.invisible_finished = 0;
+	self.invincible_finished = 0;
+	self.effects = 0;
+	self.invincible_time = 0;
+	self.staydeadtime = 0;
+	self.regen_time = 0;
+	self.rune_notice_time = 0;
+
+	self.last_hurt_carrier = -10;
+
+	DecodeLevelParms ();
+	
+	W_SetCurrentAmmo ();
+
+	self.attack_finished = time;
+	self.th_pain = player_pain;
+	self.th_die = PlayerDie;
+	
+	self.deadflag = DEAD_NO;
+// paustime is set by teleporters to keep the player from moving a while
+	self.pausetime = 0;
+	
+//	spot = SelectSpawnPoint ();
+
+	self.fixangle = TRUE;		// turn this way immediately
+
+// oh, this is a hack!
+	setmodel (self, "progs/eyes.mdl");
+	modelindex_eyes = self.modelindex;
+
+	setmodel (self, "progs/player.mdl");
+	modelindex_player = self.modelindex;
+
+	setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+	self.view_ofs = '0 0 22';
+
+	self.origin = spot.origin + '0 0 1';
+	self.angles = spot.angles;
+	player_stand1 ();
+
+	if (self.do_observer) {
+		BecomeObserver(self);
+		return;
+	}
+
+	if (deathmatch || coop)
+	{
+		makevectors(self.angles);
+		spawn_tfog (self.origin + v_forward*20);
+	}
+
+	spawn_tdeath (self.origin, self);
+};
+
+
+/*
+=============================================================================
+
+				QUAKED FUNCTIONS
+
+=============================================================================
+*/
+
+
+/*QUAKED info_player_start (1 0 0) (-16 -16 -24) (16 16 24)
+The normal starting point for a level.
+*/
+void() info_player_start =
+{
+};
+
+
+/*QUAKED info_player_start2 (1 0 0) (-16 -16 -24) (16 16 24)
+Only used on start map for the return point from an episode.
+*/
+void() info_player_start2 =
+{
+};
+
+
+void() SpawnRunes;
+
+/*
+saved out by quaked in region mode
+*/
+void() testplayerstart =
+{
+};
+
+/*QUAKED info_player_deathmatch (1 0 1) (-16 -16 -24) (16 16 24)
+potential spawning position for deathmatch games
+*/
+void() info_player_deathmatch =
+{
+	if (deathmatch)
+		StartRuneSpawn();
+};
+
+void() info_player_team1 =
+{
+};
+
+void() info_player_team2 =
+{
+};
+
+/*QUAKED info_player_coop (1 0 1) (-16 -16 -24) (16 16 24)
+potential spawning position for coop games
+*/
+void() info_player_coop =
+{
+};
+
+/*
+===============================================================================
+
+RULES
+
+===============================================================================
+*/
+
+/*
+go to the next level for deathmatch
+only called if a time or frag limit has expired
+*/
+void() NextLevel =
+{
+	local entity o;
+
+	// episode one
+	if (mapname == "e1m1") nextmap = "e1m2";
+	else if (mapname == "e1m2") nextmap = "e1m3";
+	else if (mapname == "e1m3") nextmap = "e1m4";
+	else if (mapname == "e1m4") nextmap = "e1m5";
+	else if (mapname == "e1m5") nextmap = "e1m6";
+	else if (mapname == "e1m6") nextmap = "e1m8";
+	// e1m7 skipped, lag city
+	else if (mapname == "e1m8") nextmap = "ctfstart";
+
+	// episode two
+	else if (mapname == "e2m1") nextmap = "e2m2";
+	else if (mapname == "e2m2") nextmap = "e2m3";
+	else if (mapname == "e2m3") nextmap = "e2m4";
+	else if (mapname == "e2m4") nextmap = "e2m5";
+	else if (mapname == "e2m5") nextmap = "e2m6";
+	else if (mapname == "e2m6") nextmap = "e2m7";
+	else if (mapname == "e2m7") nextmap = "ctfstart";
+
+	// episode three
+	else if (mapname == "e3m1") nextmap = "e3m2";
+	else if (mapname == "e3m2") nextmap = "e3m3";
+	else if (mapname == "e3m3") nextmap = "e3m4";
+	else if (mapname == "e3m4") nextmap = "e3m5";
+	else if (mapname == "e3m5") nextmap = "e3m6";
+	else if (mapname == "e3m6") nextmap = "e3m7";
+	else if (mapname == "e3m7") nextmap = "ctfstart";
+
+	// episode four
+	else if (mapname == "e4m1") nextmap = "e4m2";
+	else if (mapname == "e4m2") nextmap = "e4m3";
+	else if (mapname == "e4m3") nextmap = "e4m4";
+	else if (mapname == "e4m4") nextmap = "e4m5";
+	else if (mapname == "e4m5") nextmap = "e4m6";
+	else if (mapname == "e4m6") nextmap = "e4m7";
+	else if (mapname == "e4m7") nextmap = "e4m8";
+	else if (mapname == "e4m8") nextmap = "ctfstart";
+
+	// the deathmatch arenas
+	else if (mapname == "dm1") nextmap = "dm2";
+	else if (mapname == "dm2") nextmap = "dm3";
+	else if (mapname == "dm3") nextmap = "dm4";
+	else if (mapname == "dm4") nextmap = "dm5";
+	else if (mapname == "dm5") nextmap = "dm6";
+	else if (mapname == "dm6") nextmap = "ctfstart";
+
+	// ctf episode one
+	else if (mapname == "ctf1") nextmap = "ctf2";
+	else if (mapname == "ctf2") nextmap = "ctf3";
+	else if (mapname == "ctf3") nextmap = "ctf4";
+	else if (mapname == "ctf4") nextmap = "ctf5";
+	else if (mapname == "ctf5") nextmap = "ctf6";
+	else if (mapname == "ctf6") nextmap = "ctf7";
+	else if (mapname == "ctf7") nextmap = "ctf8";
+	else if (mapname == "ctf8") nextmap = "ctfstart";
+
+	// ctf episode two
+	else if (mapname == "ctf2m1") nextmap = "ctf2m2";
+	else if (mapname == "ctf2m2") nextmap = "ctf2m3";
+	else if (mapname == "ctf2m3") nextmap = "ctf2m4";
+	else if (mapname == "ctf2m4") nextmap = "ctf2m5";
+	else if (mapname == "ctf2m5") nextmap = "ctf2m6";
+	else if (mapname == "ctf2m6") nextmap = "ctf2m7";
+	else if (mapname == "ctf2m7") nextmap = "ctf2m8";
+	else if (mapname == "ctf2m8") nextmap = "ctfstart";
+
+	o = spawn();
+	o.map = nextmap;
+	o.think = execute_changelevel;
+	o.nextthink = time + 0.1;
+	return;
+
+// DISABLED from here
+
+	// find a trigger changelevel
+	o = find(world, classname, "trigger_changelevel");
+
+	// go back to start if no trigger_changelevel
+	if (!o)
+	{
+		mapname = "start";
+		o = spawn();
+		o.map = mapname;
+	}
+
+	nextmap = o.map;
+	gameover = TRUE;
+	
+	if (o.nextthink < time)
+	{
+		o.think = execute_changelevel;
+		o.nextthink = time + 0.1;
+	}
+
+};
+
+/*
+============
+CheckRules
+
+Exit deathmatch games upon conditions
+============
+*/
+void() CheckRules =
+{
+	local	float		timelimit;
+	local	float		fraglimit;
+	local	entity		o;
+
+	if (gameover || pregameover)	// someone else quit the game already
+		return;
+
+	if (gamestart) {
+		if ((vote_leader != world) && voteexit_time && (time > voteexit_time)) {
+			pregameover = 1;
+			o = spawn();
+			nextmap = vote_leader.map;
+			o.map = nextmap;
+			o.think = execute_changelevel;
+			o.nextthink = time + 0.1;
+			return;
+		}
+		return;
+	}
+
+	timelimit = cvar("timelimit") * 60;
+	fraglimit = cvar("fraglimit");
+	
+	if ((timelimit && time >= timelimit) ||
+		(fraglimit && (self.frags >= fraglimit))) {
+		pregameover = 1;
+		TeamEndScore();
+		NextLevel ();
+		return;
+	}
+
+};
+
+//============================================================================
+
+void() PlayerDeathThink =
+{
+	local entity	old_self;
+	local float		forward;
+
+	if ((self.flags & FL_ONGROUND))
+	{
+		forward = vlen (self.velocity);
+		forward = forward - 20;
+		if (forward <= 0)
+			self.velocity = '0 0 0';
+		else
+			self.velocity = forward * normalize(self.velocity);
+	}
+
+// wait for all buttons released
+	if (self.deadflag == DEAD_DEAD)
+	{
+		if (self.button2 || self.button1 || self.button0)
+			return;
+		self.deadflag = DEAD_RESPAWNABLE;
+		return;
+	}
+
+// wait for any button down
+	if (!self.button2 && !self.button1 && !self.button0)
+		return;
+
+	self.button0 = 0;
+	self.button1 = 0;
+	self.button2 = 0;
+	respawn();
+};
+
+
+void() PlayerJump =
+{
+	local vector start, end;
+	
+	if (self.flags & FL_WATERJUMP)
+		return;
+	
+	if (self.waterlevel >= 2)
+	{
+		if (self.watertype == CONTENT_WATER)
+			self.velocity_z = 100;
+		else if (self.watertype == CONTENT_SLIME)
+			self.velocity_z = 80;
+		else
+			self.velocity_z = 50;
+
+// play swiming sound
+		if (self.swim_flag < time)
+		{
+			self.swim_flag = time + 1;
+			if (random() < 0.5)
+				sound (self, CHAN_BODY, "misc/water1.wav", 1, ATTN_NORM);
+			else
+				sound (self, CHAN_BODY, "misc/water2.wav", 1, ATTN_NORM);
+		}
+
+		return;
+	}
+
+	if (!(self.flags & FL_ONGROUND))
+		return;
+
+	if ( !(self.flags & FL_JUMPRELEASED) )
+		return;		// don't pogo stick
+
+	self.flags = self.flags - (self.flags & FL_JUMPRELEASED);
+
+	self.flags = self.flags - FL_ONGROUND;	// don't stairwalk
+	
+	self.button2 = 0;
+// player jumping sound
+	sound (self, CHAN_BODY, "player/plyrjmp8.wav", 1, ATTN_NORM);
+	self.velocity_z = self.velocity_z + 270;
+};
+
+
+/*
+===========
+WaterMove
+
+============
+*/
+.float	dmgtime;
+
+void() WaterMove =
+{
+//dprint (ftos(self.waterlevel));
+	if (self.movetype == MOVETYPE_NOCLIP)
+		return;
+	if (self.health < 0)
+		return;
+
+	if (self.waterlevel != 3)
+	{
+		if (self.air_finished < time)
+			sound (self, CHAN_VOICE, "player/gasp2.wav", 1, ATTN_NORM);
+		else if (self.air_finished < time + 9)
+			sound (self, CHAN_VOICE, "player/gasp1.wav", 1, ATTN_NORM);
+		self.air_finished = time + 12;
+		self.dmg = 2;
+	}
+	else if (self.air_finished < time)
+	{	// drown!
+		if (self.pain_finished < time)
+		{
+			self.dmg = self.dmg + 2;
+			if (self.dmg > 15)
+				self.dmg = 10;
+			T_Damage (self, world, world, self.dmg);
+			self.pain_finished = time + 1;
+		}
+	}
+
+	if (!self.waterlevel)
+	{
+		if (self.flags & FL_INWATER)
+		{	
+			// play leave water sound
+			sound (self, CHAN_BODY, "misc/outwater.wav", 1, ATTN_NORM);
+			self.flags = self.flags - FL_INWATER;
+		}
+		return;
+	}
+
+	if (self.watertype == CONTENT_LAVA)
+	{	// do damage
+		if (self.dmgtime < time)
+		{
+			if (self.radsuit_finished > time)
+				self.dmgtime = time + 1;
+			else
+				self.dmgtime = time + 0.2;
+
+			T_Damage (self, world, world, 10*self.waterlevel);
+		}
+	}
+	else if (self.watertype == CONTENT_SLIME)
+	{	// do damage
+		if (self.dmgtime < time && self.radsuit_finished < time)
+		{
+			self.dmgtime = time + 1;
+			T_Damage (self, world, world, 4*self.waterlevel);
+		}
+	}
+	
+	if ( !(self.flags & FL_INWATER) )
+	{	
+
+// player enter water sound
+
+		if (self.watertype == CONTENT_LAVA)
+			sound (self, CHAN_BODY, "player/inlava.wav", 1, ATTN_NORM);
+		if (self.watertype == CONTENT_WATER)
+			sound (self, CHAN_BODY, "player/inh2o.wav", 1, ATTN_NORM);
+		if (self.watertype == CONTENT_SLIME)
+			sound (self, CHAN_BODY, "player/slimbrn2.wav", 1, ATTN_NORM);
+
+		self.flags = self.flags + FL_INWATER;
+		self.dmgtime = 0;
+	}
+	
+	if (! (self.flags & FL_WATERJUMP) )
+		self.velocity = self.velocity - 0.8*self.waterlevel*frametime*self.velocity;
+};
+
+void() CheckWaterJump =
+{
+	local vector start, end;
+
+// check for a jump-out-of-water
+	makevectors (self.angles);
+	start = self.origin;
+	start_z = start_z + 8; 
+	v_forward_z = 0;
+	normalize(v_forward);
+	end = start + v_forward*24;
+	traceline (start, end, TRUE, self);
+	if (trace_fraction < 1)
+	{	// solid at waist
+		start_z = start_z + self.maxs_z - 8;
+		end = start + v_forward*24;
+		self.movedir = trace_plane_normal * -50;
+		traceline (start, end, TRUE, self);
+		if (trace_fraction == 1)
+		{	// open at eye level
+			self.flags = self.flags | FL_WATERJUMP;
+			self.velocity_z = 225;
+			self.flags = self.flags - (self.flags & FL_JUMPRELEASED);
+			self.teleport_time = time + 2;	// safety net
+			return;
+		}
+	}
+
+};
+
+
+/*
+================
+PlayerPreThink
+
+Called every frame before physics are run
+================
+*/
+void() PlayerPreThink =
+{
+	local	float	mspeed, aspeed;
+	local	float	r;
+	local	string	s;
+
+	if (intermission_running)
+	{
+		IntermissionThink ();	// otherwise a button could be missed between
+		return;					// the think tics
+	}
+	if (self.staydeadtime && self.staydeadtime > time)
+		return;// wait a bit before respawn
+
+// *TEAMPLAY*
+	if (coop && TEAM_STRICT_COOP)
+		return;
+
+	TeamCapturePlayerUpdate();
+
+	if (self.CamState) {
+		if (self.CamState > CAM_BECOME)
+			CamPreThink();
+		return;
+	}
+
+	if (self.view_ofs == '0 0 0')
+		return;		// intermission or finale
+
+	makevectors (self.v_angle);		// is this still used
+
+	CheckRules ();
+	WaterMove ();
+
+// *TEAMPLAY*
+// TeamCheckLock performs all necessary teamlock checking, and performs all
+// actions needed.
+	TeamCheckLock();
+
+	if (self.waterlevel == 2)
+		CheckWaterJump ();
+
+	if (self.deadflag >= DEAD_DEAD)
+	{
+		PlayerDeathThink ();
+		return;
+	}
+	
+//ZOID-Observer
+	if (self.observer) {
+		if (self.CamState <= CAM_BECOME)
+			ObserverThink();
+		return;
+	}
+//
+
+	if (self.deadflag == DEAD_DYING)
+		return;	// dying, so do nothing
+
+	if (self.button2)
+	{
+		PlayerJump ();
+	}
+	else
+		self.flags = self.flags | FL_JUMPRELEASED;
+
+// teleporters can force a non-moving pause time	
+	if (time < self.pausetime)
+		self.velocity = '0 0 0';
+
+
+// RUNE: If player has rune of elder magic (4), regeneration
+	if (self.player_flag & ITEM_RUNE4_FLAG) {
+		if (self.regen_time < time) {
+			self.regen_time = time;
+			if (self.health < 150) {
+				self.health = self.health + 5;
+				if (self.health > 150)
+					self.health = 150;
+				self.regen_time = self.regen_time + 0.5;
+				RegenerationSound();
+			}
+			if (self.armorvalue < 150 && self.armortype) {
+				self.armorvalue = self.armorvalue + 5;
+				if (self.armorvalue > 150)
+					self.armorvalue = 150;
+				self.regen_time = self.regen_time + 0.5;
+				RegenerationSound();
+			}
+		}
+	}
+// RUNE
+
+	if(time > self.attack_finished && self.currentammo == 0 && 
+		self.weapon != IT_AXE && self.weapon != IT_HOOK)
+	{
+		self.weapon = W_BestWeapon ();
+		W_SetCurrentAmmo ();
+	}
+};
+	
+/*
+================
+CheckPowerups
+
+Check for turning off powerups
+================
+*/
+void() CheckPowerups =
+{
+	if (self.health <= 0)
+		return;
+
+// invisibility
+	if (self.invisible_finished)
+	{
+// sound and screen flash when items starts to run out
+		if (self.invisible_sound < time)
+		{
+			sound (self, CHAN_AUTO, "items/inv3.wav", 0.5, ATTN_IDLE);
+			self.invisible_sound = time + ((random() * 3) + 1);
+		}
+
+
+		if (self.invisible_finished < time + 3)
+		{
+			if (self.invisible_time == 1)
+			{
+				sprint (self, "Ring of Shadows magic is fading\n");
+				stuffcmd (self, "bf\n");
+				sound (self, CHAN_AUTO, "items/inv2.wav", 1, ATTN_NORM);
+				self.invisible_time = time + 1;
+			}
+			
+			if (self.invisible_time < time)
+			{
+				self.invisible_time = time + 1;
+				stuffcmd (self, "bf\n");
+			}
+		}
+
+		if (self.invisible_finished < time)
+		{	// just stopped
+			self.items = self.items - IT_INVISIBILITY;
+			self.invisible_finished = 0;
+			self.invisible_time = 0;
+		}
+		
+	// use the eyes
+		self.frame = 0;
+		self.modelindex = modelindex_eyes;
+	}
+	else
+		self.modelindex = modelindex_player;	// don't use eyes
+
+// invincibility
+	if (self.invincible_finished)
+	{
+// sound and screen flash when items starts to run out
+		if (self.invincible_finished < time + 3)
+		{
+			if (self.invincible_time == 1)
+			{
+				sprint (self, "Protection is almost burned out\n");
+				stuffcmd (self, "bf\n");
+				sound (self, CHAN_AUTO, "items/protect2.wav", 1, ATTN_NORM);
+				self.invincible_time = time + 1;
+			}
+			
+			if (self.invincible_time < time)
+			{
+				self.invincible_time = time + 1;
+				stuffcmd (self, "bf\n");
+			}
+		}
+		
+		if (self.invincible_finished < time)
+		{	// just stopped
+			self.items = self.items - IT_INVULNERABILITY;
+			self.invincible_time = 0;
+			self.invincible_finished = 0;
+		}
+// ZOID, next line isn't needed, EF_DIMLIGHT is handled by
+// client.qc:CheckDimLight
+//		if (self.invincible_finished > time)
+//			self.effects = self.effects | EF_DIMLIGHT;
+//		else
+//			self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+	}
+
+// super damage
+	if (self.super_damage_finished)
+	{
+
+// sound and screen flash when items starts to run out
+
+		if (self.super_damage_finished < time + 3)
+		{
+			if (self.super_time == 1)
+			{
+				sprint (self, "Quad Damage is wearing off\n");
+				stuffcmd (self, "bf\n");
+				sound (self, CHAN_AUTO, "items/damage2.wav", 1, ATTN_NORM);
+				self.super_time = time + 1;
+			}	  
+			
+			if (self.super_time < time)
+			{
+				self.super_time = time + 1;
+				stuffcmd (self, "bf\n");
+			}
+		}
+
+		if (self.super_damage_finished < time)
+		{	// just stopped
+			self.items = self.items - IT_QUAD;
+			self.super_damage_finished = 0;
+			self.super_time = 0;
+		}
+// ZOID, next line isn't needed, EF_DIMLIGHT is handled by
+// client.qc:CheckDimLight
+//		if (self.super_damage_finished > time)
+//			self.effects = self.effects | EF_DIMLIGHT;
+//		else
+//			self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+	}	
+
+// suit	
+	if (self.radsuit_finished)
+	{
+		self.air_finished = time + 12;		// don't drown
+
+// sound and screen flash when items starts to run out
+		if (self.radsuit_finished < time + 3)
+		{
+			if (self.rad_time == 1)
+			{
+				sprint (self, "Air supply in Biosuit expiring\n");
+				stuffcmd (self, "bf\n");
+				sound (self, CHAN_AUTO, "items/suit2.wav", 1, ATTN_NORM);
+				self.rad_time = time + 1;
+			}
+			
+			if (self.rad_time < time)
+			{
+				self.rad_time = time + 1;
+				stuffcmd (self, "bf\n");
+			}
+		}
+
+		if (self.radsuit_finished < time)
+		{	// just stopped
+			self.items = self.items - IT_SUIT;
+			self.rad_time = 0;
+			self.radsuit_finished = 0;
+		}
+	}	
+
+	// Check to see about DIMLIGHT effects
+	CheckDimLight();
+};
+
+
+/*
+================
+PlayerPostThink
+
+Called every frame after physics are run
+================
+*/
+void() PlayerPostThink =
+{
+	local	float	mspeed, aspeed;
+	local	float	r;
+    local   string  num;
+
+	if (self.CamState > CAM_BECOME) {
+		CamThink();
+		return;
+	}
+	if (self.CamState == CAM_BECOME) {
+		InitCamClient();
+		return;
+	}
+
+	if (self.view_ofs == '0 0 0')
+		return;		// intermission or finale
+
+	if (self.deadflag) {
+		// check admin impulses if dead
+		if (self.impulse) {
+			CheckAdminCmd();
+			self.impulse = 0;
+		}
+		return;
+	}
+
+// do weapon stuff
+
+	W_WeaponFrame ();
+
+// check to see if player landed and play landing sound	
+	if ((self.jump_flag < -300) && (self.flags & FL_ONGROUND) && (self.health > 0))
+	{
+		if (self.watertype == CONTENT_WATER)
+			sound (self, CHAN_BODY, "player/h2ojump.wav", 1, ATTN_NORM);
+		else if (self.jump_flag < -650)
+		{
+			T_Damage (self, world, world, 5); 
+			sound (self, CHAN_VOICE, "player/land2.wav", 1, ATTN_NORM);
+			self.deathtype = "falling";
+		}
+		else
+			sound (self, CHAN_VOICE, "player/land.wav", 1, ATTN_NORM);
+
+		self.jump_flag = 0;
+	}
+
+	if (!(self.flags & FL_ONGROUND))
+		self.jump_flag = self.velocity_z;
+
+	CheckPowerups ();
+
+};
+
+
+/*
+===========
+ClientConnect
+
+called when a player connects to a server
+============
+*/
+void() ClientConnect =
+{
+	bprint (self.netname);
+	bprint (" entered the game\n");
+	
+	LogMsg(self, "CONNECT");
+
+	self.motd_count = 1;
+
+	self.suicide_count = 0;
+	self.killed = 0;
+	self.frags = 0;
+	self.voted = 0;
+	
+// *TEAMPLAY*
+ 	// If this is our first connection, parm10 is < 0
+ 	// Set lastteam negative.
+ 	if(parm10 < 0 && teamplay > 0) {
+ 		self.lastteam = -50;
+		self.team = -1;
+		if (teamplay & TEAM_CAPTURE_SELECT_TEAM)
+			self.do_observer = 1;
+		else if (!self.do_observer) {
+			TeamCheckLock();
+			self.player_flag = self.player_flag | TEAM_STUFF_COLOR;
+			if ((teamplay & TEAM_CAPTURE_CUSTOM)) {
+				if (self.lastteam == TEAM_COLOR1)
+					self.skin = 1;
+				else
+					self.skin = 3;
+				if (random() < 0.5)
+					self.skin = self.skin + 1; // visor dude
+				self.player_flag = self.player_flag - (self.player_flag & 65280);
+				self.player_flag = self.player_flag | (self.skin * 256);  
+			}
+		}
+	}
+
+
+// a client connecting during an intermission can cause problems
+	if (intermission_running)
+		ExitIntermission ();
+};
+
+
+/*
+===========
+ClientDisconnect
+
+called when a player disconnects from a server
+============
+*/
+void() ClientDisconnect =
+{
+	if (gameover)
+		return;
+	// if the level end trigger has been activated, just return
+	// since they aren't *really* leaving
+
+	// let everyone else know
+	bprint (self.netname);
+	bprint (" left the game with ");
+	bprint (ftos(self.frags));
+	bprint (" frags\n");
+	sound (self, CHAN_BODY, "player/tornoff2.wav", 1, ATTN_NONE);
+	DropRune();
+    TeamCaptureDropFlagOfPlayer(self);
+	set_suicide_frame ();
+
+	self.lastteam = -50;
+	self.team = -50;
+	self.frags = 0;
+	self.statoff = 0;
+
+	CamPlayerDisconnect();
+
+	LogMsg(self, "DISCONNECT");
+};
+
+// *TEAMPLAY*
+// Prototypes
+
+float(entity targ, entity attacker) TeamFragPenalty;
+void(entity targ, entity attacker) TeamDeathPenalty;
+
+/*
+===========
+ClientObituary
+
+called when a player dies
+============
+*/
+void(entity targ, entity attacker) ClientObituary =
+{
+
+	// *XXX* EXPERT CTF variable for 
+	// flag/flag carrier defense bonus determination
+	local	entity head;
+	local float flag_radius;
+	local float flag_carrier_radius;
+
+	local	float rnum;
+	local	string deathstring, deathstring2, what, s;
+	rnum = random();
+
+	if (targ.classname == "player")
+	{
+
+		// *XXX* EXPERT CTF: 
+		// When the flag carrier dies, reset the last_hurt_carrier field in
+		// all players on the opposite team from the flag carrier.  The carrier
+		// has been killed, so there is no longer a reason to award points for
+		// killing off his assailants
+		if (targ.player_flag & ITEM_ENEMY_FLAG) {
+
+			head = find(world, classname, "player");
+
+			while (head != world) {	
+				if (head.team != targ.team) {
+					head.last_hurt_carrier = -10;
+				}
+				head = find(head, classname, "player");
+			}
+		}
+		// END EXPERT CTF
+
+		if (attacker.classname == "teledeath")
+		{
+			bprint (targ.netname);
+			bprint (" was telefragged by ");
+			bprint (attacker.owner.netname);
+			bprint ("\n");
+
+			attacker.owner.frags = attacker.owner.frags + 1;
+			LogPlayerDMDeath(targ, attacker.owner, "telefrag");
+			return;
+		}
+
+		if (attacker.classname == "teledeath2")
+		{
+			bprint ("Satan's power deflects ");
+			bprint (targ.netname);
+			bprint ("'s telefrag\n");
+
+			targ.frags = targ.frags - 1;
+			LogPlayerDeath(targ, "telefrag");
+			return;
+		}
+
+		if (attacker.classname == "player")
+		{
+			if (targ == attacker)
+			{
+				// killed self
+				attacker.frags = attacker.frags - 1;
+				bprint (targ.netname);
+				
+				if (targ.weapon == 64 && targ.waterlevel > 1)
+				{
+					bprint (" discharges into the water.\n");
+					LogPlayerDeath(targ, "discharge");
+					return;
+				}
+				if (targ.weapon == IT_GRENADE_LAUNCHER) {
+					bprint (" tries to put the pin back in\n");
+					LogPlayerDeath(targ, "grenade");
+				} else if (targ.team != targ.lastteam) {
+					//ZOID: try if player was gibbed for changing teams
+					if (teamplay & TEAM_STATIC_TEAMS)
+						bprint (" tried to change teams\n");
+					else
+						bprint (" changed teams\n");
+					LogPlayerDeath(targ, "teamchange");
+				} else {
+					bprint (" becomes bored with life\n");
+					LogPlayerDeath(targ, "rocket");
+				}
+				return;
+			}
+			else if ( (teamplay == 2) && (targ.team > 0)&&(targ.team == attacker.team) )
+			{
+				if (rnum < 0.25)
+					deathstring = " mows down a teammate\n";
+				else if (rnum < 0.50)
+					deathstring = " checks his glasses\n";
+				else if (rnum < 0.75)
+					deathstring = " gets a frag for the other team\n";
+				else
+					deathstring = " loses another friend\n";
+				bprint (attacker.netname);
+				bprint (deathstring);
+				attacker.frags = attacker.frags - 1;
+				return;
+			}
+			else
+			{
+ 				// *TEAMPLAY*
+ 				// TeamFragPenalty returns true if the attacker gets a frag penalty for
+ 				// killing this target.  It also deducts frags as needed.
+ 				if (!TeamFragPenalty(targ, attacker)) {
+
+ 					// the attacker is award the normal one frag.. now we 
+ 					// determine if he gets any bonuses
+ 					attacker.frags = attacker.frags + 1;
+ 
+ 					if ((targ.player_flag & ITEM_ENEMY_FLAG) &&
+ 						(targ.team != attacker.team)) {
+ 						//ZOID: one team fragged the other team's flag carrier
+ 
+ 						// *XXX* EXPERT CTF
+ 						// Mark the attacker with the time at which he killed the flag
+ 						// carrier, for awarding assist points
+ 
+ 						attacker.last_fragged_carrier = time;
+ 
+ 						// *XXX* EXPERT CTF: give player only the normal amount of frags
+ 						// if the carrier has only had the flag for a few seconds, to
+ 						// prevent ppl intentionally allowing enemies to grab the flag,
+ 						// then immediately fragging them
+ 
+ 						if (targ.flag_since + TEAM_CAPTURE_CARRIER_FLAG_SINCE_TIMEOUT > time) {
+ 							sprint(attacker, "Enemy flag carrier killed, no bonus\n");
+ 						} else {
+ 							attacker.frags = attacker.frags + TEAM_CAPTURE_FRAG_CARRIER_BONUS;
+                         			// TeamScore (attacker, TEAM_CAPTURE_FRAG_CARRIER_BONUS);
+ 							sprint(attacker, "Enemy flag carrier killed: ");
+ 							s = ftos(TEAM_CAPTURE_FRAG_CARRIER_BONUS);
+ 							sprint(attacker, s);
+ 							sprint(attacker, " bonus frags\n");
+ 						}
+ 						// END FLAG CARRIER FRAG CODE
+ 					}
+ 					
+ 					// *XXX* EXPERT CTF
+ 					// This code checks for all game-critical kills OTHER THAN fragging the enemy
+ 					// flag carrier, like killing players who are trying to kill your flag carrier
+ 					// or trying to grab your flag, and hands out bonus frags.
+ 
+ 					// The two variables below track whether special bonus frags have already
+ 					// been awarded for the attacker or target being near the flag or flag carrier.  
+ 
+ 					flag_radius = 0;
+ 					flag_carrier_radius = 0;
+ 
+ 					// get a string for the attacker's team now, for later announcements
+ 					s = GetCTFTeam(attacker.team);
+ 
+ 					if ((targ.last_hurt_carrier + TEAM_CAPTURE_CARRIER_DANGER_PROTECT_TIMEOUT > time) &&
+ 					    !(attacker.player_flag & ITEM_ENEMY_FLAG) ) {
+ 						// a player on the same team as the flag carrier killed 
+ 						// someone who recently shot the flag carrier
+ 						attacker.frags = attacker.frags + 
+ 							TEAM_CAPTURE_CARRIER_DANGER_PROTECT_BONUS;
+ 						flag_carrier_radius = 1;
+ 						// NOTE: getting CARRIER_DANGER_PROTECT_BONUS precludes getting
+ 						// other kinds of bonuses for defending the flag carrier, since
+ 						// it's worth more points
+ 						bprint(attacker.netname);
+ 						bprint(" defends ");
+ 						bprint(s);
+ 						bprint("'s flag carrier against an agressive enemy\n");
+ 					}
+ 
+ 					// *XXX* EXPERT CTF
+ 					// Bonusus for defending the flag carrier or the flag itself.
+ 					// Extra frags are awarded if either the attacker or the target are
+ 					// 1. within 40 feet of a flag carrier on the same team as the attacker
+ 					// 2. within 40 feet of the attacker's flag
+ 					// These bonuses are cumulative with respect to defending both the
+ 					// flag and the flag carrier at the same time, but not cumulative with
+ 					// respect to both the target and attacker being near the object being defended
+ 
+ 					// find flags or flag carriers within a radius of the attacker
+ 					head = findradius(attacker.origin, TEAM_CAPTURE_ATTACKER_PROTECT_RADIUS);
+ 
+ 					while (head) {
+ 						if (head.classname == "player") {
+ 							if ( (head.team == attacker.team) &&
+ 							     (head.player_flag & ITEM_ENEMY_FLAG) &&
+ 							     (head != attacker) && // self defense
+ 							     (!flag_carrier_radius) ) { 
+								// attacker was near his own flag carrier
+ 								attacker.frags = attacker.frags + 
+ 									TEAM_CAPTURE_CARRIER_PROTECT_BONUS;
+ 								flag_carrier_radius = 1;
+ 								bprint(attacker.netname);
+ 								bprint(" defends ");
+ 								bprint(s);
+ 								bprint("'s flag carrier\n");
+ 							}
+ 						}
+ 						if ( (head.classname == "item_flag_team1") ||
+ 						     (head.classname == "item_flag_team2")) {
+ 							if (((attacker.team == TEAM_COLOR1) &&
+								(head.classname == "item_flag_team1")) ||
+ 								((attacker.team == TEAM_COLOR2) &&
+ 								(head.classname == "item_flag_team2"))) { 
+								// attacker was near his own flag
+ 								attacker.frags = attacker.frags + 
+ 									TEAM_CAPTURE_FLAG_DEFENSE_BONUS;
+ 								flag_radius = 1; 
+ 								bprint(attacker.netname);
+ 								bprint(" defends the ");
+ 								bprint(s);
+ 								bprint(" flag\n");
+ 							}
+ 						}
+ 						head = head.chain;
+ 					}
+ 
+ 					// find flags or flag carriers within a radius from the target
+ 					head = findradius(targ.origin, TEAM_CAPTURE_TARGET_PROTECT_RADIUS);
+ 					while (head) {
+ 						if (head.classname == "player") {
+ 							if ( (head.team == attacker.team) &&
+ 							     (head.player_flag & ITEM_ENEMY_FLAG) &&
+ 							     (head != attacker) &&
+ 							     (!flag_carrier_radius)) { // prevents redundant points awarded
+ 								// target was near attacker's flag carrier
+ 								attacker.frags = attacker.frags + 
+ 									TEAM_CAPTURE_CARRIER_PROTECT_BONUS;
+ 								flag_carrier_radius = 1;
+ 								bprint(attacker.netname);
+ 								bprint(" defends ");
+ 								bprint(s);
+ 								bprint("'s flag carrier\n");
+ 							}
+ 						}
+						if (((attacker.team == TEAM_COLOR1) &&
+							(head.classname == "item_flag_team1")) ||
+							((attacker.team == TEAM_COLOR2) &&
+							(head.classname == "item_flag_team2"))
+							&& (!flag_radius)) { // prevents redundant points awarded
+							// target was near attacker's flag
+							attacker.frags = attacker.frags + 
+								TEAM_CAPTURE_FLAG_DEFENSE_BONUS;
+							flag_radius = 1;
+							bprint(attacker.netname);
+							bprint(" defends the ");
+							bprint(s);
+							bprint(" flag\n");
+						}
+ 						head = head.chain;
+ 					}
+ 				}	
+ 			 
+ 				// *XXX* EXPERT CTF 
+ 				// End frag determination code.  Now determine death text for
+ 				// a member of one team killing a member of the other
+ 
+ 				// *TEAMPLAY*
+ 				// TeamDeathPenalty kills the attacker if necessary and adjusts frags to
+ 				// offset the one frag penalty for dying.
+				TeamDeathPenalty(targ, attacker);
+
+				rnum = attacker.weapon;
+				if (rnum == IT_AXE)
+				{
+					deathstring = " was ax-murdered by ";
+					deathstring2 = "\n";
+					what = "axe";
+				}
+				if (rnum == IT_HOOK) {
+					if (random() < 0.5)
+						deathstring = " was disembowled by ";
+					else
+						deathstring = " was hooked by ";
+					deathstring2 = "\n";
+					what = "hook";
+				}
+				if (rnum == IT_SHOTGUN)
+				{
+					deathstring = " chewed on ";
+					deathstring2 = "'s boomstick\n";
+					what = "shotgun";
+				}
+				if (rnum == IT_SUPER_SHOTGUN)
+				{
+					deathstring = " ate 2 loads of ";
+					if (targ.health < -40)
+						deathstring = " ate a box of ";
+					deathstring2 = "'s buckshot\n";
+					what = "supershotgun";
+				}
+				if (rnum == IT_NAILGUN)
+				{
+					deathstring = " was nailed by ";
+					deathstring2 = "\n";
+					what = "nailgun";
+				}
+				if (rnum == IT_SUPER_NAILGUN)
+				{
+					deathstring = " was punctured by ";
+					deathstring2 = "\n";
+					what = "supernailgun";
+				}
+				if (rnum == IT_GRENADE_LAUNCHER)
+				{
+					deathstring = " eats ";
+					deathstring2 = "'s pineapple\n";
+					if (targ.health < -40)
+					{
+						deathstring = " was gibbed by ";
+						deathstring2 = "'s grenade\n";
+					}
+					what = "grenade";
+				}
+				if (rnum == IT_ROCKET_LAUNCHER)
+				{
+					if (attacker.items & IT_QUAD) {
+						deathstring = " was destroyed by ";
+						deathstring2 = "'s Quad rocket\n";
+					} else {
+						deathstring = " rides ";
+						deathstring2 = "'s rocket\n";
+						if (targ.health < -40)
+						{
+							deathstring = " was gibbed by ";
+							deathstring2 = "'s rocket\n" ;
+						}
+					}
+					what = "rocket";
+				}
+				if (rnum == IT_LIGHTNING)
+				{
+					if (attacker.items & IT_QUAD) {
+						deathstring = " was touched by ";
+						deathstring2 = "'s Quad lightning\n";
+					} else {
+						deathstring = " accepts ";
+						if (attacker.waterlevel > 1)
+							deathstring2 = "'s discharge\n";
+						else
+							deathstring2 = "'s shaft\n";
+					}
+					what = "lightning";
+				}
+				bprint (targ.netname);
+				bprint (deathstring);
+				bprint (attacker.netname);
+				bprint (deathstring2);
+				LogPlayerDMDeath(targ, attacker, what);
+			}
+			return;
+		}
+		else
+		{
+			targ.frags = targ.frags - 1;
+			bprint (targ.netname);
+
+			// killed by a montser?
+			if (attacker.flags & FL_MONSTER)
+			{
+				if (attacker.classname == "monster_army") {
+					bprint (" was shot by a Grunt\n");
+					LogPlayerDeath(targ, "grunt");
+				} else if (attacker.classname == "monster_demon1") {
+					bprint (" was eviscerated by a Fiend\n");
+					LogPlayerDeath(targ, "fiend");
+				} else if (attacker.classname == "monster_dog") {
+					bprint (" was mauled by a Rottweiler\n");
+					LogPlayerDeath(targ, "dog");
+				} else if (attacker.classname == "monster_dragon") {
+					bprint (" was fried by a Dragon\n");
+					LogPlayerDeath(targ, "dragon");
+				} else if (attacker.classname == "monster_enforcer") {
+					bprint (" was blasted by an Enforcer\n");
+					LogPlayerDeath(targ, "enforcer");
+				} else if (attacker.classname == "monster_fish") {
+					bprint (" was fed to the Rotfish\n");
+					LogPlayerDeath(targ, "fish");
+				} else if (attacker.classname == "monster_hell_knight") {
+					bprint (" was slain by a Death Knight\n");
+					LogPlayerDeath(targ, "deathknight");
+				} else if (attacker.classname == "monster_knight") {
+					bprint (" was slashed by a Knight\n");
+					LogPlayerDeath(targ, "knight");
+				} else if (attacker.classname == "monster_ogre") {
+					bprint (" was destroyed by an Ogre\n");
+					LogPlayerDeath(targ, "ogre");
+				} else if (attacker.classname == "monster_oldone") {
+					bprint (" became one with Shub-Niggurath\n");
+					LogPlayerDeath(targ, "shub");
+				} else if (attacker.classname == "monster_shalrath") {
+					bprint (" was exploded by a Vore\n");
+					LogPlayerDeath(targ, "vore");
+				} else if (attacker.classname == "monster_shambler") {
+					bprint (" was smashed by a Shambler\n");
+					LogPlayerDeath(targ, "shambler");
+				} else if (attacker.classname == "monster_tarbaby") {
+					bprint (" was slimed by a Spawn\n");
+					LogPlayerDeath(targ, "spawn");
+				} else if (attacker.classname == "monster_vomit") {
+					bprint (" was vomited on by a Vomitus\n");
+					LogPlayerDeath(targ, "vomitus");
+				} else if (attacker.classname == "monster_wizard") {
+					bprint (" was scragged by a Scrag\n");
+					LogPlayerDeath(targ, "scrag");
+				} else if (attacker.classname == "monster_zombie") {
+					bprint (" joins the Zombies\n");
+					LogPlayerDeath(targ, "zombie");
+				}
+
+				return;
+			}
+
+			// tricks and traps
+			if (attacker.classname == "explo_box")
+			{
+				bprint (" blew up\n");
+				LogPlayerDeath(targ, "explosion");
+				return;
+			}
+			if (attacker.solid == SOLID_BSP && attacker != world)
+			{	
+				bprint (" was squished\n");
+				LogPlayerDeath(targ, "squished");
+				return;
+			}
+			if (attacker.classname == "trap_shooter" || attacker.classname == "trap_spikeshooter")
+			{
+				bprint (" was spiked\n");
+				LogPlayerDeath(targ, "spiked");
+				return;
+			}
+			if (attacker.classname == "fireball")
+			{
+				bprint (" ate a lavaball\n");
+				LogPlayerDeath(targ, "fireball");
+				return;
+			}
+			if (attacker.classname == "trigger_changelevel")
+			{
+				bprint (" tried to leave\n");
+				LogPlayerDeath(targ, "noexit");
+				return;
+			}
+
+			// in-water deaths
+			rnum = targ.watertype;
+			if (rnum == -3)
+			{
+				if (random() < 0.5)
+					bprint (" sleeps with the fishes\n");
+				else
+					bprint (" sucks it down\n");
+				LogPlayerDeath(targ, "drowned");
+				return;
+			}
+			else if (rnum == -4)
+			{
+				if (random() < 0.5)
+					bprint (" gulped a load of slime\n");
+				else
+					bprint (" can't exist on slime alone\n");
+				LogPlayerDeath(targ, "slimed");
+				return;
+			}
+			else if (rnum == -5)
+			{
+				if (targ.health < -15)
+				{
+					bprint (" burst into flames\n");
+					LogPlayerDeath(targ, "melted");
+					return;
+				}
+				if (random() < 0.5)
+					bprint (" turned into hot slag\n");
+				else
+					bprint (" visits the Volcano God\n");
+				LogPlayerDeath(targ, "melted");
+				return;
+			}
+
+			// fell to their death?
+			if (targ.deathtype == "falling")
+			{
+				targ.deathtype = "";
+				bprint (" fell to his death\n");
+				LogPlayerDeath(targ, "falling");
+				return;
+			}
+
+			// hell if I know; he's just dead!!!
+			LogPlayerDeath(targ, "died");
+			bprint (" died\n");
+		}
+	}
+};
+
+void() T_MissileTouch;
+void() info_player_start;
+void(entity targ, entity attacker) ClientObituary;
+void(entity who) ResistanceSound;
+
+//============================================================================
+
+/*
+============
+CanDamage
+
+Returns true if the inflictor can directly damage the target.  Used for
+explosions and melee attacks.
+============
+*/
+float(entity targ, entity inflictor) CanDamage =
+{
+// bmodels need special checking because their origin is 0,0,0
+	if (targ.movetype == MOVETYPE_PUSH)
+	{
+		traceline(inflictor.origin, 0.5 * (targ.absmin + targ.absmax), TRUE, self);
+		if (trace_fraction == 1)
+			return TRUE;
+		if (trace_ent == targ)
+			return TRUE;
+		return FALSE;
+	}
+	
+	traceline(inflictor.origin, targ.origin, TRUE, self);
+	if (trace_fraction == 1)
+		return TRUE;
+	traceline(inflictor.origin, targ.origin + '15 15 0', TRUE, self);
+	if (trace_fraction == 1)
+		return TRUE;
+	traceline(inflictor.origin, targ.origin + '-15 -15 0', TRUE, self);
+	if (trace_fraction == 1)
+		return TRUE;
+	traceline(inflictor.origin, targ.origin + '-15 15 0', TRUE, self);
+	if (trace_fraction == 1)
+		return TRUE;
+	traceline(inflictor.origin, targ.origin + '15 -15 0', TRUE, self);
+	if (trace_fraction == 1)
+		return TRUE;
+
+	return FALSE;
+};
+
+
+/*
+============
+Killed
+============
+*/
+void(entity targ, entity attacker) Killed =
+{
+	local entity oself;
+
+	oself = self;
+	self = targ;
+	
+	if (self.health < -99)
+		self.health = -99;		// don't let sbar look bad if a player
+
+	if (self.movetype == MOVETYPE_PUSH || self.movetype == MOVETYPE_NONE)
+	{	// doors, triggers, etc
+
+		self.th_die ();
+		self = oself;
+		return;
+	}
+
+	self.enemy = attacker;
+
+// bump the monster counter
+	if (self.flags & FL_MONSTER)
+	{
+		killed_monsters = killed_monsters + 1;
+		WriteByte (MSG_ALL, SVC_KILLEDMONSTER);
+	}
+
+	ClientObituary(self, attacker);
+	
+	self.takedamage = DAMAGE_NO;
+	self.touch = SUB_Null;
+
+//  removed monsters
+//	monster_death_use();
+	self.th_die ();
+	
+	self = oself;
+};
+
+
+// *TEAMPLAY*
+// Prototypes
+
+float(entity targ, entity inflictor, entity attacker, float damage) TeamArmorDam;
+float(entity targ, entity inflictor, entity attacker, float damage) TeamHealthDam;
+
+/*
+============
+T_Damage
+
+The damage is coming from inflictor, but get mad at attacker
+This should be the only function that ever reduces health.
+============
+*/
+void(entity targ, entity inflictor, entity attacker, float damage) T_Damage=
+{
+	local	vector	dir;
+	local	entity	oldself;
+	local	float	save;
+	local	float	take;
+
+	if (!targ.takedamage)
+		return;
+
+// used by buttons and triggers to set activator for target firing
+	damage_attacker = attacker;
+
+// check for quad damage powerup on the attacker
+	if (attacker.super_damage_finished > time)
+		damage = damage * 4;
+// RUNE: check for double damage for rune of Black Magic powerup
+	if (attacker.player_flag & ITEM_RUNE2_FLAG)
+		damage = damage * 2;
+// RUNE
+
+//RUNE check if target has rune of Earth Magic (half damage)
+	if (targ.player_flag & ITEM_RUNE1_FLAG) {
+		damage = damage / 2;
+		ResistanceSound(targ);
+	}
+//RUNE
+
+	// *XXX* EXPERT CTF mark players who hurt the flag carrier, so they 
+	// are worth more points for a while.
+ 	if ( (attacker.classname == "player") && // attacker must be a player
+ 	     (targ.player_flag & ITEM_ENEMY_FLAG) && // target is a flag carrier
+ 	     (attacker.lastteam != targ.lastteam) && // target and attacker on diff teams
+ 	     (targ.lastteam > 0) ) // unconnected check?
+ 		attacker.last_hurt_carrier = time;
+ 
+// save damage based on the target's armor level
+
+// *TEAMPLAY*
+// TeamArmorDam returns true iff the attacker can damage the target's armor
+
+	if (TeamArmorDam(targ, inflictor, attacker, damage))
+		save = ceil(targ.armortype*damage);
+	else
+		save = 0;
+
+	if (save >= targ.armorvalue)
+	{
+		save = targ.armorvalue;
+		targ.armortype = 0;	// lost all armor
+		targ.items = targ.items - (targ.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3));
+	}
+	
+	targ.armorvalue = targ.armorvalue - save;
+	take = ceil(damage-save);
+
+// add to the damage total for clients, which will be sent as a single
+// message at the end of the frame
+// FIXME: remove after combining shotgun blasts?
+	if (targ.flags & FL_CLIENT)
+	{
+		targ.dmg_take = targ.dmg_take + take;
+		targ.dmg_save = targ.dmg_save + save;
+		targ.dmg_inflictor = inflictor;
+	}
+
+// figure momentum add
+	if ( (inflictor != world) && (targ.movetype == MOVETYPE_WALK) )
+	{
+		dir = targ.origin - (inflictor.absmin + inflictor.absmax) * 0.5;
+		dir = normalize(dir);
+		targ.velocity = targ.velocity + dir*damage*8;
+	}
+
+// check for godmode or invincibility
+	if (targ.flags & FL_GODMODE)
+		return;
+	if (targ.invincible_finished >= time)
+	{
+		if (self.invincible_sound < time)
+		{
+			sound (targ, CHAN_ITEM, "items/protect3.wav", 1, ATTN_NORM);
+			self.invincible_sound = time + 2;
+		}
+		return;
+	}
+
+// team play damage avoidance
+	if ( (teamplay == 1) && (targ.team > 0)&&(targ.team == attacker.team) )
+		return;
+		
+// *TEAMPLAY*
+// TeamHealthDam will return true if the attacker can damage the target's
+// health
+
+        if (!TeamHealthDam(targ, inflictor, attacker, damage))
+                return;
+		
+// do the damage
+	targ.health = targ.health - take;
+
+	if (targ.health <= 0)
+	{
+		Killed (targ, attacker);
+		return;
+	}
+
+// react to the damage
+	oldself = self;
+	self = targ;
+
+	if (self.th_pain)
+		self.th_pain (attacker, take);
+
+	self = oldself;
+};
+
+/*
+============
+T_RadiusDamage
+============
+*/
+void(entity inflictor, entity attacker, float damage, entity ignore) T_RadiusDamage =
+{
+	local	float 	points;
+	local	entity	head;
+	local	vector	org;
+
+	head = findradius(inflictor.origin, damage+40);
+	
+	while (head)
+	{
+		if (head != ignore)
+		{
+			if (head.takedamage)
+			{
+				org = head.origin + (head.mins + head.maxs)*0.5;
+				points = 0.5*vlen (inflictor.origin - org);
+				if (points < 0)
+					points = 0;
+				points = damage - points;
+				if (head == attacker)
+					points = points * 0.5;
+				if (points > 0)
+				{
+					if (CanDamage (head, inflictor))
+					{	// shambler takes half damage from all explosions
+						if (head.classname == "monster_shambler")						
+							T_Damage (head, inflictor, attacker, points*0.5);
+						else
+							T_Damage (head, inflictor, attacker, points);
+					}
+				}
+			}
+		}
+		head = head.chain;
+	}
+};
+
+/*
+============
+T_BeamDamage
+============
+*/
+void(entity attacker, float damage) T_BeamDamage =
+{
+	local	float 	points;
+	local	entity	head;
+	
+	head = findradius(attacker.origin, damage+40);
+	
+	while (head)
+	{
+		if (head.takedamage)
+		{
+			points = 0.5*vlen (attacker.origin - head.origin);
+			if (points < 0)
+				points = 0;
+			points = damage - points;
+			if (head == attacker)
+				points = points * 0.5;
+			if (points > 0)
+			{
+				if (CanDamage (head, attacker))
+				{
+					if (head.classname == "monster_shambler")						
+						T_Damage (head, attacker, attacker, points*0.5);
+					else
+						T_Damage (head, attacker, attacker, points);
+				}
+			}
+		}
+		head = head.chain;
+	}
+};
+
+/*
+==============================================================================
+
+			SOURCE FOR GLOBALVARS_T C STRUCTURE
+
+==============================================================================
+*/
+
+//
+// system globals
+//
+entity		self;
+entity		other;
+entity		world;
+float		time;
+float		frametime;
+
+float		force_retouch;		// force all entities to touch triggers
+								// next frame.  this is needed because
+								// non-moving things don't normally scan
+								// for triggers, and when a trigger is
+								// created (like a teleport trigger), it
+								// needs to catch everything.
+								// decremented each frame, so set to 2
+								// to guarantee everything is touched
+string		mapname;
+
+float		deathmatch;
+float		coop;
+float		teamplay;
+
+float		serverflags;		// propagated from level to level, used to
+								// keep track of completed episodes
+
+float		total_secrets;
+float		total_monsters;
+
+float		found_secrets;		// number of secrets found
+float		killed_monsters;	// number of monsters killed
+
+
+// spawnparms are used to encode information about clients across server
+// level changes
+float		parm1, parm2, parm3, parm4, parm5, parm6, parm7, parm8, parm9, parm10, parm11, parm12, parm13, parm14, parm15, parm16;
+
+//
+// global variables set by built in functions
+//	
+vector		v_forward, v_up, v_right;	// set by makevectors()
+	
+// set by traceline / tracebox
+float		trace_allsolid;
+float		trace_startsolid;
+float		trace_fraction;
+vector		trace_endpos;
+vector		trace_plane_normal;
+float		trace_plane_dist;
+entity		trace_ent;
+float		trace_inopen;
+float		trace_inwater;
+
+entity		msg_entity;				// destination of single entity writes
+
+//
+// required prog functions
+//
+void() 		main;						// only for testing
+
+void()		StartFrame;
+
+void() 		PlayerPreThink;
+void() 		PlayerPostThink;
+
+void()		ClientKill;
+void()		ClientConnect;
+void() 		PutClientInServer;		// call after setting the parm1... parms
+void()		ClientDisconnect;
+
+void()		SetNewParms;			// called when a client first connects to
+									// a server. sets parms so they can be
+									// saved off for restarts
+
+void()		SetChangeParms;			// call to set parms for self so they can
+									// be saved for a level transition
+
+
+//================================================
+void		end_sys_globals;		// flag for structure dumping
+//================================================
+
+/*
+==============================================================================
+
+			SOURCE FOR ENTVARS_T C STRUCTURE
+
+==============================================================================
+*/
+
+//
+// system fields (*** = do not set in prog code, maintained by C code)
+//
+.float		modelindex;		// *** model index in the precached list
+.vector		absmin, absmax;	// *** origin + mins / maxs
+
+.float		ltime;			// local time for entity
+.float		movetype;
+.float		solid;
+
+.vector		origin;			// ***
+.vector		oldorigin;		// ***
+.vector		velocity;
+.vector		angles;
+.vector		avelocity;
+
+.vector		punchangle;		// temp angle adjust from damage or recoil
+
+.string		classname;		// spawn function
+.string		model;
+.float		frame;
+.float		skin;
+.float		effects;
+
+.vector		mins, maxs;		// bounding box extents reletive to origin
+.vector		size;			// maxs - mins
+
+.void()		touch;
+.void()		use;
+.void()		think;
+.void()		blocked;		// for doors or plats, called when can't push other
+
+.float		nextthink;
+.entity		groundentity;
+
+// stats
+.float		health;
+.float		frags;
+.float		weapon;			// one of the IT_SHOTGUN, etc flags
+.string		weaponmodel;
+.float		weaponframe;
+.float		currentammo;
+.float		ammo_shells, ammo_nails, ammo_rockets, ammo_cells;
+
+.float		items;			// bit flags
+
+.float		takedamage;
+.entity		chain;
+.float		deadflag;
+
+.vector		view_ofs;			// add to origin to get eye point
+
+
+.float		button0;		// fire
+.float		button1;		// use
+.float		button2;		// jump
+
+.float		impulse;		// weapon changes
+
+.float		fixangle;
+.vector		v_angle;		// view / targeting angle for players
+.float		idealpitch;		// calculated pitch angle for lookup up slopes
+
+
+.string		netname;
+
+.entity 	enemy;
+
+.float		flags;
+
+.float		colormap;
+.float		team;
+
+.float		max_health;		// players maximum health is stored here
+
+.float		teleport_time;	// don't back up
+
+.float		armortype;		// save this fraction of incoming damage
+.float		armorvalue;
+
+.float		waterlevel;		// 0 = not in, 1 = feet, 2 = wast, 3 = eyes
+.float		watertype;		// a contents value
+
+.float		ideal_yaw;
+.float		yaw_speed;
+
+.entity		aiment;
+
+.entity 	goalentity;		// a movetarget or an enemy
+
+.float		spawnflags;
+
+.string		target;
+.string		targetname;
+
+// damage is accumulated through a frame. and sent as one single
+// message, so the super shotgun doesn't generate huge messages
+.float		dmg_take;
+.float		dmg_save;
+.entity		dmg_inflictor;
+
+.entity		owner;		// who launched a missile
+.vector		movedir;	// mostly for doors, but also used for waterjump
+
+.string		message;		// trigger messages
+
+.float		sounds;		// either a cd track number or sound number
+
+.string		noise, noise1, noise2, noise3;	// contains names of wavs to play
+
+//================================================
+void		end_sys_fields;			// flag for structure dumping
+//================================================
+
+/*
+==============================================================================
+
+				VARS NOT REFERENCED BY C CODE
+
+==============================================================================
+*/
+
+
+//
+// constants
+//
+
+float	FALSE					= 0;
+float 	TRUE					= 1;
+
+// edict.flags
+float	FL_FLY					= 1;
+float	FL_SWIM					= 2;
+float	FL_CLIENT				= 8;	// set for all client edicts
+float	FL_INWATER				= 16;	// for enter / leave water splash
+float	FL_MONSTER				= 32;
+float	FL_GODMODE				= 64;	// player cheat
+float	FL_NOTARGET				= 128;	// player cheat
+float	FL_ITEM					= 256;	// extra wide size for bonus items
+float	FL_ONGROUND				= 512;	// standing on something
+float	FL_PARTIALGROUND		= 1024;	// not all corners are valid
+float	FL_WATERJUMP			= 2048;	// player jumping out of water
+float	FL_JUMPRELEASED			= 4096;	// for jump debouncing
+
+// edict.movetype values
+float	MOVETYPE_NONE			= 0;	// never moves
+//float	MOVETYPE_ANGLENOCLIP	= 1;
+//float	MOVETYPE_ANGLECLIP		= 2;
+float	MOVETYPE_WALK			= 3;	// players only
+float	MOVETYPE_STEP			= 4;	// discrete, not real time unless fall
+float	MOVETYPE_FLY			= 5;
+float	MOVETYPE_TOSS			= 6;	// gravity
+float	MOVETYPE_PUSH			= 7;	// no clip to world, push and crush
+float	MOVETYPE_NOCLIP			= 8;
+float	MOVETYPE_FLYMISSILE		= 9;	// fly with extra size against monsters
+float	MOVETYPE_BOUNCE			= 10;
+float	MOVETYPE_BOUNCEMISSILE	= 11;	// bounce with extra size
+
+// edict.solid values
+float	SOLID_NOT				= 0;	// no interaction with other objects
+float	SOLID_TRIGGER			= 1;	// touch on edge, but not blocking
+float	SOLID_BBOX				= 2;	// touch on edge, block
+float	SOLID_SLIDEBOX			= 3;	// touch on edge, but not an onground
+float	SOLID_BSP				= 4;	// bsp clip, touch on edge, block
+
+// range values
+float	RANGE_MELEE				= 0;
+float	RANGE_NEAR				= 1;
+float	RANGE_MID				= 2;
+float	RANGE_FAR				= 3;
+
+// deadflag values
+
+float	DEAD_NO					= 0;
+float	DEAD_DYING				= 1;
+float	DEAD_DEAD				= 2;
+float	DEAD_RESPAWNABLE		= 3;
+
+// takedamage values
+
+float	DAMAGE_NO				= 0;
+float	DAMAGE_YES				= 1;
+float	DAMAGE_AIM				= 2;
+
+// items
+float	IT_AXE					= 4096;
+float	IT_SHOTGUN				= 1;
+float	IT_SUPER_SHOTGUN		= 2;
+float	IT_NAILGUN				= 4;
+float	IT_SUPER_NAILGUN		= 8;
+float	IT_GRENADE_LAUNCHER		= 16;
+float	IT_ROCKET_LAUNCHER		= 32;
+float	IT_LIGHTNING			= 64;
+float	IT_EXTRA_WEAPON			= 128;
+
+float	IT_SHELLS				= 256;
+float	IT_NAILS				= 512;
+float	IT_ROCKETS				= 1024;
+float	IT_CELLS				= 2048;
+
+float	IT_ARMOR1				= 8192;
+float	IT_ARMOR2				= 16384;
+float	IT_ARMOR3				= 32768;
+float	IT_SUPERHEALTH			= 65536;
+
+float	IT_KEY1					= 131072;
+float	IT_KEY2					= 262144;
+
+float	IT_INVISIBILITY			= 524288;
+float	IT_INVULNERABILITY		= 1048576;
+float	IT_SUIT					= 2097152;
+float	IT_QUAD					= 4194304;
+float	IT_HOOK					= 8388608;
+
+// point content values
+
+float	CONTENT_EMPTY			= -1;
+float	CONTENT_SOLID			= -2;
+float	CONTENT_WATER			= -3;
+float	CONTENT_SLIME			= -4;
+float	CONTENT_LAVA			= -5;
+float	CONTENT_SKY				= -6;
+
+float	STATE_TOP		= 0;
+float	STATE_BOTTOM	= 1;
+float	STATE_UP		= 2;
+float	STATE_DOWN		= 3;
+
+vector	VEC_ORIGIN = '0 0 0';
+vector	VEC_HULL_MIN = '-16 -16 -24';
+vector	VEC_HULL_MAX = '16 16 32';
+
+vector	VEC_HULL2_MIN = '-32 -32 -24';
+vector	VEC_HULL2_MAX = '32 32 64';
+
+// protocol bytes
+float	SVC_TEMPENTITY		= 23;
+float	SVC_KILLEDMONSTER	= 27;
+float	SVC_FOUNDSECRET		= 28;
+float	SVC_INTERMISSION	= 30;
+float	SVC_FINALE			= 31;
+float	SVC_CDTRACK			= 32;
+float	SVC_SELLSCREEN		= 33;
+
+
+float	TE_SPIKE		= 0;
+float	TE_SUPERSPIKE	= 1;
+float	TE_GUNSHOT		= 2;
+float	TE_EXPLOSION	= 3;
+float	TE_TAREXPLOSION	= 4;
+float	TE_LIGHTNING1	= 5;
+float	TE_LIGHTNING2	= 6;
+float	TE_WIZSPIKE		= 7;
+float	TE_KNIGHTSPIKE	= 8;
+float	TE_LIGHTNING3	= 9;
+float	TE_LAVASPLASH	= 10;
+float	TE_TELEPORT		= 11;
+
+// sound channels
+// channel 0 never willingly overrides
+// other channels (1-7) allways override a playing sound on that channel
+float	CHAN_AUTO		= 0;
+float	CHAN_WEAPON		= 1;
+float	CHAN_VOICE		= 2;
+float	CHAN_ITEM		= 3;
+float	CHAN_BODY		= 4;
+
+float	ATTN_NONE		= 0;
+float	ATTN_NORM		= 1;
+float	ATTN_IDLE		= 2;
+float	ATTN_STATIC		= 3;
+
+// update types
+
+float	UPDATE_GENERAL	= 0;
+float	UPDATE_STATIC	= 1;
+float	UPDATE_BINARY	= 2;
+float	UPDATE_TEMP		= 3;
+
+// entity effects
+
+float	EF_BRIGHTFIELD	= 1;
+float	EF_MUZZLEFLASH 	= 2;
+float	EF_BRIGHTLIGHT 	= 4;
+float	EF_DIMLIGHT 	= 8;
+
+
+// messages
+float	MSG_BROADCAST	= 0;		// unreliable to all
+float	MSG_ONE			= 1;		// reliable to one (msg_entity)
+float	MSG_ALL			= 2;		// reliable to all
+float	MSG_INIT		= 3;		// write to the init string
+
+//================================================
+
+//
+// globals
+//
+float	movedist;
+float	gameover;		// set when a rule exits
+
+string	string_null;	// null string, nothing should be held here
+float	empty_float;
+
+entity	newmis;			// launch_spike sets this after spawning it
+
+entity	activator;		// the entity that activated a trigger or brush
+
+entity	damage_attacker;	// set by T_Damage
+float	framecount;
+
+float		skill;
+
+entity	runespawn;
+float	runespawned;
+
+float	gamestart;		// at start
+
+//================================================
+
+//
+// world fields (FIXME: make globals)
+//
+.string		wad;
+.string 	map;
+.float		worldtype;	// 0=medieval 1=metal 2=base
+
+//================================================
+
+.string		killtarget;
+
+//
+// quakeed fields
+//
+.float		light_lev;		// not used by game, but parsed by light util
+.float		style;
+
+
+//
+// monster ai
+//
+.void()		th_stand;
+.void()		th_walk;
+.void()		th_run;
+.void()		th_missile;
+.void()		th_melee;
+.void(entity attacker, float damage)		th_pain;
+.void()		th_die;
+
+.entity		oldenemy;		// mad at this player before taking damage
+
+.float		speed;
+
+.float	lefty;
+
+.float	search_time;
+.float	attack_state;
+
+float	AS_STRAIGHT		= 1;
+float	AS_SLIDING		= 2;
+float	AS_MELEE		= 3;
+float	AS_MISSILE		= 4;
+
+//
+// player only fields
+//
+
+// *TEAMPLAY*
+
+.float          lastteam;       // The last team this player was a member of.
+
+// *XXX* EXPERT CTF ALTERNATE SCORING
+
+// time values
+
+.float 		flag_since; 		// how long a player has had the flag
+.float		last_returned_flag; 	// last time player returned his own flag
+.float		last_fragged_carrier; 	// last time player fragged a flag carrier
+.float		last_hurt_carrier; 	// last time player hurt the flag carrier
+
+// *XXX* end 
+
+// OBSERVER
+.float observer;
+.float do_observer;
+
+//ADMIN
+.float accesslvl; // current access level
+.float accessparm; // current access parm
+
+.float		walkframe;
+
+.float 		attack_finished;
+.float		pain_finished;
+.float		hook_out;
+
+.float		invincible_finished;
+.float		invisible_finished;
+.float		super_damage_finished;
+.float		radsuit_finished;
+
+.float		invincible_time, invincible_sound;
+.float		invisible_time, invisible_sound;
+.float		super_time, super_sound;
+.float		regeneration_sound;//RUNE: Elder Magic
+.float		haste_sound;//RUNE: Hell Magic
+.float		rad_time;
+.float		fly_sound;
+
+.float		axhitme;
+
+.float		show_hostile;	// set to time+0.2 whenever a client fires a
+							// weapon or takes damage.  Used to alert
+							// monsters that otherwise would let the player go
+.float		jump_flag;		// player jump flag
+.float		swim_flag;		// player swimming sound flag
+.float		air_finished;	// when time > air_finished, start drowning
+.float		bubble_count;	// keeps track of the number of bubbles
+.string		deathtype;		// keeps track of how the player died
+.float 		player_flag;	// misc flags (skins, etc.)
+.float		staydeadtime;	// how long we should stay dead
+.float		regen_time;		// time to next regen
+.float		rune_notice_time;	// last time we notified about multi-runes
+
+.float		voted;			// non-zero if voted
+
+// ZOID: Runes
+float		ITEM_RUNE1_FLAG		= 1;
+float		ITEM_RUNE2_FLAG		= 2;
+float		ITEM_RUNE3_FLAG		= 4;
+float		ITEM_RUNE4_FLAG		= 8;
+float		ITEM_RUNE_MASK		= 15;
+
+// ZOID: Capture the flag
+float		ITEM_ENEMY_FLAG		= 16;
+// TEAMPLAY
+float		TEAM_STUFF_COLOR	= 32;
+
+.float		suicide_count;
+.float		killed;			// have we been killed yet
+
+//McBain: PreviousWeaponCommand
+.float		previous_weapon;	// one of the IT_SHOTGUN, etc flags
+
+//
+// object stuff
+//
+.string		mdl;
+.vector		mangle;			// angle at start
+
+.vector		oldorigin;		// only used by secret door
+
+.float		t_length, t_width;
+
+
+//
+// doors, etc
+//
+.vector		dest, dest1, dest2;
+.float		wait;			// time from firing to restarting
+.float		delay;			// time from activation to firing
+.entity		trigger_field;	// door's trigger entity
+.string		noise4;
+
+//
+// monsters
+//
+.float 		pausetime;
+.entity 	movetarget;
+
+
+//
+// doors
+//
+.float		aflag;
+.float		dmg;			// damage done by door when hit
+	
+//
+// misc
+//
+.float		cnt; 			// misc flag
+	
+//
+// subs
+//
+.void()		think1;
+.vector		finaldest, finalangle;
+
+//
+// triggers
+//
+.float		count;			// for counting triggers
+
+
+//
+// plats / doors / buttons
+//
+.float		lip;
+.float		state;
+.vector		pos1, pos2;		// top and bottom positions
+.float		height;
+
+//
+// sounds
+//
+.float		waitmin, waitmax;
+.float		distance;
+.float		volume;
+
+
+
+
+//===========================================================================
+	
+
+//
+// builtin functions
+//
+
+void(vector ang)	makevectors		= #1;		// sets v_forward, etc globals
+void(entity e, vector o) setorigin	= #2;
+void(entity e, string m) setmodel	= #3;		// set movetype and solid first
+void(entity e, vector min, vector max) setsize = #4;
+// #5 was removed
+void() break						= #6;
+float() random						= #7;		// returns 0 - 1
+void(entity e, float chan, string samp, float vol, float atten) sound = #8;
+vector(vector v) normalize			= #9;
+void(string e) error				= #10;
+void(string e) objerror				= #11;
+float(vector v) vlen				= #12;
+float(vector v) vectoyaw			= #13;
+entity() spawn						= #14;
+void(entity e) remove				= #15;
+
+// sets trace_* globals
+// nomonsters can be:
+// An entity will also be ignored for testing if forent == test,
+// forent->owner == test, or test->owner == forent
+// a forent of world is ignored
+void(vector v1, vector v2, float nomonsters, entity forent) traceline = #16;	
+
+entity() checkclient				= #17;	// returns a client to look for
+entity(entity start, .string fld, string match) find = #18;
+string(string s) precache_sound		= #19;
+string(string s) precache_model		= #20;
+void(entity client, string s)stuffcmd = #21;
+entity(vector org, float rad) findradius = #22;
+void(string s) bprint				= #23;
+void(entity client, string s) sprint = #24;
+void(string s) dprint				= #25;
+string(float f) ftos				= #26;
+string(vector v) vtos				= #27;
+void() coredump						= #28;		// prints all edicts
+void() traceon						= #29;		// turns statment trace on
+void() traceoff						= #30;
+void(entity e) eprint				= #31;		// prints an entire edict
+float(float yaw, float dist) walkmove	= #32;	// returns TRUE or FALSE
+// #33 was removed
+float(float yaw, float dist) droptofloor= #34;	// TRUE if landed on floor
+void(float style, string value) lightstyle = #35;
+float(float v) rint					= #36;		// round to nearest int
+float(float v) floor				= #37;		// largest integer <= v
+float(float v) ceil					= #38;		// smallest integer >= v
+// #39 was removed
+float(entity e) checkbottom			= #40;		// true if self is on ground
+float(vector v) pointcontents		= #41;		// returns a CONTENT_*
+// #42 was removed
+float(float f) fabs = #43;
+vector(entity e, float speed) aim = #44;		// returns the shooting vector
+float(string s) cvar = #45;						// return cvar.value
+void(string s) localcmd = #46;					// put string into local que
+entity(entity e) nextent = #47;					// for looping through all ents
+void(vector o, vector d, float color, float count) particle = #48;// start a particle effect
+void() ChangeYaw = #49;						// turn towards self.ideal_yaw
+											// at self.yaw_speed
+// #50 was removed
+vector(vector v) vectoangles			= #51;
+
+//
+// direct client message generation
+//
+void(float to, float f) WriteByte		= #52;
+void(float to, float f) WriteChar		= #53;
+void(float to, float f) WriteShort		= #54;
+void(float to, float f) WriteLong		= #55;
+void(float to, float f) WriteCoord		= #56;
+void(float to, float f) WriteAngle		= #57;
+void(float to, string s) WriteString	= #58;
+void(float to, entity s) WriteEntity	= #59;
+
+//
+// broadcast client message generation
+//
+
+// void(float f) bWriteByte		= #59;
+// void(float f) bWriteChar		= #60;
+// void(float f) bWriteShort		= #61;
+// void(float f) bWriteLong		= #62;
+// void(float f) bWriteCoord		= #63;
+// void(float f) bWriteAngle		= #64;
+// void(string s) bWriteString	= #65;
+// void(entity e) bWriteEntity = #66;
+
+void(float step) movetogoal				= #67;
+
+string(string s) precache_file		= #68;	// no effect except for -copy
+void(entity e) makestatic		= #69;
+void(string s) changelevel = #70;
+
+//#71 was removed
+
+void(string var, string val) cvar_set = #72;	// sets cvar.value
+
+void(entity client, string s) centerprint = #73;	// sprint, but in middle
+void(entity client, string s, string s1) centerprint2 = #73;	// sprint, but in middle
+void(entity client, string s, string s1, string s2) centerprint3 = #73;	// sprint, but in middle
+void(entity client, string s, string s1, string s2, string s3) centerprint4 = #73;	// sprint, but in middle
+void(entity client, string s, string s1, string s2, string s3, string s4) centerprint5 = #73;	// sprint, but in middle
+void(entity client, string s, string s1, string s2, string s3, string s4, string s5) centerprint6 = #73;	// sprint, but in middle
+void(entity client, string s, string s1, string s2, string s3, string s4, string s5, string s6) centerprint7 = #73;	// sprint, but in middle
+
+void(vector pos, string samp, float vol, float atten) ambientsound = #74;
+
+string(string s) precache_model2	= #75;		// registered version only
+string(string s) precache_sound2	= #76;		// registered version only
+string(string s) precache_file2		= #77;		// registered version only
+
+void(entity e) setspawnparms		= #78;		// set parm1... to the
+												// values at level start
+												// for coop respawn
+
+//============================================================================
+
+//
+// subs.qc
+//
+void(vector tdest, float tspeed, void() func) SUB_CalcMove;
+void(entity ent, vector tdest, float tspeed, void() func) SUB_CalcMoveEnt;
+void(vector destangle, float tspeed, void() func) SUB_CalcAngleMove;
+void()  SUB_CalcMoveDone;
+void() SUB_CalcAngleMoveDone;
+void() SUB_Null;
+void() SUB_UseTargets;
+void() SUB_Remove;
+
+//
+//	combat.qc
+//
+void(entity targ, entity inflictor, entity attacker, float damage) T_Damage;
+
+
+float (entity e, float healamount, float ignore) T_Heal; // health function
+
+float(entity targ, entity inflictor) CanDamage;
+
+
+float VOTEEXIT_TIME_LIMIT	=	60;		// 60 seconds after first vote
+float voteexit_time;
+entity vote_leader;		// current leader
+entity lastvotespawn;
+
+void(vector org) spawn_tfog;
+void(vector org, entity death_owner) spawn_tdeath;
+void() InitTrigger;
+
+/*QUAKED info_vote_destination (.5 .5 .5) (-8 -8 -8) (8 8 32)
+This is the destination marker for a voteexit.  It should have a "targetname" 
+field with the same value as a voteexit's "target" field.
+*/
+void() info_vote_destination =
+{
+	// this does nothing, just serves as a target spot
+	self.mangle = self.angles;
+	self.angles = '0 0 0';
+	self.model = "";
+	self.origin = self.origin + '0 0 27';
+	if (!self.targetname)
+		objerror ("no targetname");
+};
+
+void() voteexit_teleport =
+{
+local entity	t;
+local vector	org;
+
+// put a tfog where the player was
+	spawn_tfog (other.origin);
+
+// if we aren't in custom mode, just find a deathmatch target
+	if (!(teamplay & TEAM_CAPTURE_CUSTOM)) {
+		lastvotespawn = find(lastvotespawn, classname, "info_player_deathmatch");
+		if (lastvotespawn == world)
+			lastvotespawn = find (lastvotespawn, classname, "info_player_deathmatch");
+		t = lastvotespawn;
+	} else
+		t = find (world, targetname, self.target);
+
+	if (!t)
+		objerror ("couldn't find target");
+		
+// spawn a tfog flash in front of the destination
+	makevectors (t.mangle);
+	org = t.origin + 32 * v_forward;
+
+	spawn_tfog (org);
+	spawn_tdeath(t.origin, other);
+
+// move the player and lock him down for a little while
+	if (!other.health)
+	{
+		other.origin = t.origin;
+		other.velocity = (v_forward * other.velocity_x) + (v_forward * other.velocity_y);
+		return;
+	}
+	setorigin (other, t.origin);
+	other.angles = t.mangle;
+
+	other.fixangle = 1;		// turn this way immediately
+	other.teleport_time = time + 0.7;
+
+	if (other.flags & FL_ONGROUND)
+		other.flags = other.flags - FL_ONGROUND;
+	other.velocity = v_forward * 300;
+};
+
+void() voteexit_touch =
+{
+local entity	t;
+
+	if (other.classname != "player")
+		return;
+
+// only teleport living creatures
+	if (other.health <= 0 || other.solid != SOLID_SLIDEBOX)
+		return;
+
+	if (other.voted) {
+		if (other.voted < time)
+			TeamPlayerUpdate(other, "You have already voted.");
+		other.voted = time + 1;
+		voteexit_teleport();
+		return;
+	}
+
+	// non-zero for vote, time is when to display a 'you voted' msg
+	other.voted = time + 1;
+
+	SUB_UseTargets ();
+
+	bprint(other.netname);
+	bprint(" has voted for ");
+	bprint(self.message);
+	bprint("\n");
+
+// ok, the player has voted for this exit
+	self.cnt = self.cnt + 1;
+
+	// find new leader
+	// we're on the start map, something special is happening
+	vote_leader = world;
+	t = find(world, classname, "trigger_voteexit");
+	while (t != world) {
+		if ((t.cnt > vote_leader.cnt) && (t != self))
+			vote_leader = t;
+		t = find(t, classname, "trigger_voteexit");
+	}
+	// if we are higher than the current leader, then we are the new
+	// leader, if we are same, half chance
+	if (self.cnt > vote_leader.cnt)
+		vote_leader = self;
+	else if ((self.cnt == vote_leader.cnt) && (random() > 0.5))
+		vote_leader = self;
+
+	// we check here about exit time
+	if (vote_leader != world && voteexit_time == 0)
+		voteexit_time = time + VOTEEXIT_TIME_LIMIT;
+
+	// notify everyone about the change
+	TeamCaptureResetUpdate();
+
+	voteexit_teleport();
+};
+
+/*QUAKED trigger_voteexit (.5 .5 .5) ?
+A merge of trigger_changelevel and trigger_teleport.  A player touching
+this this teleported just like a trigger_teleport, except this triggers
+.cnt field gets incremented.  This allows players to vote for their exit.
+See status.qc for the display and total of the voting.
+Any object touching this will be transported to the corresponding 
+info_vote_destination entity. You must set the "target" field, and 
+create an object with a "targetname" field that matches.
+*/
+void() trigger_voteexit =
+{
+	local vector o;
+
+	InitTrigger ();
+	self.touch = voteexit_touch;
+	self.cnt = 0;
+	// find the destination 
+	if ((teamplay & TEAM_CAPTURE_CUSTOM) && !self.target)
+		objerror ("no target");
+};
+
+/*
+*/
+void (entity targ, entity inflictor, entity attacker, float damage) T_Damage;
+void () player_run;
+void(entity bomb, entity attacker, float rad, entity ignore) T_RadiusDamage;
+void(vector org, vector vel, float damage) SpawnBlood;
+void() SuperDamageSound;
+void() HasteSound;
+
+// called by worldspawn
+void() W_Precache =
+{
+	precache_sound ("hknight/hit.wav");  // flamethrower
+
+	precache_sound ("weapons/r_exp3.wav");	// new rocket explosion
+	precache_sound ("weapons/rocket1i.wav");	// spike gun
+	precache_sound ("weapons/sgun1.wav");
+	precache_sound ("weapons/guncock.wav");	// player shotgun
+	precache_sound ("weapons/ric1.wav");	// ricochet (used in c code)
+	precache_sound ("weapons/ric2.wav");	// ricochet (used in c code)
+	precache_sound ("weapons/ric3.wav");	// ricochet (used in c code)
+	precache_sound ("weapons/spike2.wav");	// super spikes
+	precache_sound ("weapons/tink1.wav");	// spikes tink (used in c code)
+	precache_sound ("weapons/grenade.wav");	// grenade launcher
+	precache_sound ("weapons/bounce.wav");		// grenade bounce
+	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+
+	precache_sound2 ("blob/land1.wav");     // chain go splorch!
+	if (cvar("teamplay") & TEAM_CAPTURE_CUSTOM) {
+		precache_sound ("weapons/chain1.wav");
+		precache_sound ("weapons/chain2.wav");
+		precache_sound ("weapons/chain3.wav");
+		precache_sound ("weapons/bounce2.wav");
+	}
+
+	// ZOID:
+	// normally the weapon models are precached in the individual item
+	// creation routines.  But since we've added impulse 21 we can drop
+	// weapons at any time.  Must precache all weapon models.
+	precache_model ("progs/g_shot.mdl");
+	precache_model ("progs/g_nail.mdl");
+	precache_model ("progs/g_nail2.mdl");
+	precache_model ("progs/g_rock.mdl");
+	precache_model ("progs/g_rock2.mdl");
+	precache_model ("progs/g_light.mdl");
+};
+
+float() crandom =
+{
+	return 2*(random() - 0.5);
+};
+
+/*
+================
+W_FireAxe
+================
+*/
+void() W_FireAxe =
+{
+	local	vector	source;
+	local	vector	org;
+
+	makevectors (self.v_angle);
+	source = self.origin + '0 0 16';
+	traceline (source, source + v_forward*64, FALSE, self);
+	if (trace_fraction == 1.0)
+		return;
+	
+	org = trace_endpos - v_forward*4;
+
+	if (trace_ent.takedamage)
+	{
+		trace_ent.axhitme = 1;
+		SpawnBlood (org, '0 0 0', 20);
+		T_Damage (trace_ent, self, self, 20);
+	}
+	else
+	{	// hit wall
+		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
+		WriteCoord (MSG_BROADCAST, org_x);
+		WriteCoord (MSG_BROADCAST, org_y);
+		WriteCoord (MSG_BROADCAST, org_z);
+	}
+};
+
+
+//============================================================================
+
+
+vector() wall_velocity =
+{
+	local vector	vel;
+	
+	vel = normalize (self.velocity);
+	vel = normalize(vel + v_up*(random()- 0.5) + v_right*(random()- 0.5));
+	vel = vel + 2*trace_plane_normal;
+	vel = vel * 200;
+	
+	return vel;
+};
+
+
+/*
+================
+SpawnMeatSpray
+================
+*/
+void(vector org, vector vel) SpawnMeatSpray =
+{
+	local	entity missile, mpuff;
+	local	vector	org;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_NOT;
+
+	makevectors (self.angles);
+
+	missile.velocity = vel;
+	missile.velocity_z = missile.velocity_z + 250 + 50*random();
+
+	missile.avelocity = '3000 1000 2000';
+	
+// set missile duration
+	missile.nextthink = time + 1;
+	missile.think = SUB_Remove;
+
+	setmodel (missile, "progs/zom_gib.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, org);
+};
+
+/*
+================
+SpawnBlood
+================
+*/
+void(vector org, vector vel, float damage) SpawnBlood =
+{
+	particle (org, vel*0.1, 73, damage*2);
+};
+
+/*
+================
+spawn_touchblood
+================
+*/
+void(float damage) spawn_touchblood =
+{
+	local vector	vel;
+
+	vel = wall_velocity () * 0.2;
+	SpawnBlood (self.origin + vel*0.01, vel, damage);
+};
+
+
+/*
+================
+SpawnChunk
+================
+*/
+void(vector org, vector vel) SpawnChunk =
+{
+	particle (org, vel*0.02, 0, 10);
+};
+
+/*
+==============================================================================
+
+MULTI-DAMAGE
+
+Collects multiple small damages into a single damage
+
+==============================================================================
+*/
+
+entity	multi_ent;
+float	multi_damage;
+
+void() ClearMultiDamage =
+{
+	multi_ent = world;
+	multi_damage = 0;
+};
+
+void() ApplyMultiDamage =
+{
+	if (!multi_ent)
+		return;
+	T_Damage (multi_ent, self, self, multi_damage);
+};
+
+void(entity hit, float damage) AddMultiDamage =
+{
+	if (!hit)
+		return;
+	
+	if (hit != multi_ent)
+	{
+		ApplyMultiDamage ();
+		multi_damage = damage;
+		multi_ent = hit;
+	}
+	else
+		multi_damage = multi_damage + damage;
+};
+
+/*
+==============================================================================
+
+BULLETS
+
+==============================================================================
+*/
+
+/*
+================
+TraceAttack
+================
+*/
+void(float damage, vector dir) TraceAttack =
+{
+	local	vector	vel, org;
+	
+	vel = normalize(dir + v_up*crandom() + v_right*crandom());
+	vel = vel + 2*trace_plane_normal;
+	vel = vel * 200;
+
+	org = trace_endpos - dir*4;
+
+	if (trace_ent.takedamage)
+	{
+		SpawnBlood (org, vel*0.2, damage);
+		AddMultiDamage (trace_ent, damage);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
+		WriteCoord (MSG_BROADCAST, org_x);
+		WriteCoord (MSG_BROADCAST, org_y);
+		WriteCoord (MSG_BROADCAST, org_z);
+	}
+};
+
+/*
+================
+FireBullets
+
+Used by shotgun, super shotgun, and enemy soldier firing
+Go to the trouble of combining multiple pellets into a single damage call.
+================
+*/
+void(float shotcount, vector dir, vector spread) FireBullets =
+{
+	local	vector direction;
+	local	vector	src;
+	
+	makevectors(self.v_angle);
+
+	src = self.origin + v_forward*10;
+	src_z = self.absmin_z + self.size_z * 0.7;
+
+	ClearMultiDamage ();
+	while (shotcount > 0)
+	{
+		direction = dir + crandom()*spread_x*v_right + crandom()*spread_y*v_up;
+
+		traceline (src, src + direction*2048, FALSE, self);
+		if (trace_fraction != 1.0)
+			TraceAttack (4, direction);
+
+		shotcount = shotcount - 1;
+	}
+	ApplyMultiDamage ();
+};
+
+/*
+================
+W_FireShotgun
+================
+*/
+void() W_FireShotgun =
+{
+	local vector dir;
+
+	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM);	
+
+	self.punchangle_x = -2;
+	
+	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
+	dir = aim (self, 100000);
+	FireBullets (6, dir, '0.04 0.04 0');
+};
+
+
+/*
+================
+W_FireSuperShotgun
+================
+*/
+void() W_FireSuperShotgun =
+{
+	local vector dir;
+
+	if (self.currentammo == 1)
+	{
+		W_FireShotgun ();
+		return;
+	}
+		
+	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM);	
+
+	self.punchangle_x = -4;
+	
+	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
+	dir = aim (self, 100000);
+	FireBullets (14, dir, '0.14 0.08 0');
+};
+
+
+/*
+==============================================================================
+
+ROCKETS
+
+==============================================================================
+*/
+
+void()	s_explode1	=	[0,		s_explode2] {};
+void()	s_explode2	=	[1,		s_explode3] {};
+void()	s_explode3	=	[2,		s_explode4] {};
+void()	s_explode4	=	[3,		s_explode5] {};
+void()	s_explode5	=	[4,		s_explode6] {};
+void()	s_explode6	=	[5,		SUB_Remove] {};
+
+void() BecomeExplosion =
+{
+	self.movetype = MOVETYPE_NONE;
+	self.velocity = '0 0 0';
+	self.touch = SUB_Null;
+	setmodel (self, "progs/s_explod.spr");
+	self.solid = SOLID_NOT;
+	s_explode1 ();
+};
+
+void() T_MissileTouch =
+{
+	local float	damg;
+
+	if (other == self.owner)
+		return;		// don't explode on owner
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+
+	damg = 100 + random()*20;
+	
+	if (other.health)
+	{
+		if (other.classname == "monster_shambler")
+			damg = damg * 0.5;	// mostly immune
+		T_Damage (other, self, self.owner, damg );
+	}
+
+	// don't do radius damage to the other, because all the damage
+	// was done in the impact
+	T_RadiusDamage (self, self.owner, 120, other);
+
+//	sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
+	self.origin = self.origin - 8*normalize(self.velocity);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	BecomeExplosion ();
+};
+
+
+
+/*
+================
+W_FireRocket
+================
+*/
+void() W_FireRocket =
+{
+	local	entity missile, mpuff;
+	
+	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
+	
+	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+
+	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	missile.solid = SOLID_BBOX;
+	missile.classname = "missile";
+		
+// set missile speed	
+
+	makevectors (self.v_angle);
+	missile.velocity = aim(self, 1000);
+	missile.velocity = missile.velocity * 1000;
+	missile.angles = vectoangles(missile.velocity);
+	
+	missile.touch = T_MissileTouch;
+	
+// set missile duration
+	missile.nextthink = time + 5;
+	missile.think = SUB_Remove;
+
+	setmodel (missile, "progs/missile.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
+};
+
+/*
+===============================================================================
+
+LIGHTNING
+
+===============================================================================
+*/
+
+/*
+=================
+LightningDamage
+=================
+*/
+void(vector p1, vector p2, entity from, float damage) LightningDamage =
+{
+	local entity		e1, e2;
+	local vector		f;
+	
+	f = p2 - p1;
+	normalize (f);
+	f_x = 0 - f_y;
+	f_y = f_x;
+	f_z = 0;
+	f = f*16;
+
+	e1 = e2 = world;
+
+	traceline (p1, p2, FALSE, self);
+	if (trace_ent.takedamage)
+	{
+		particle (trace_endpos, '0 0 100', 225, damage*4);
+		T_Damage (trace_ent, from, from, damage);
+		if (self.classname == "player")
+		{
+			if (other.classname == "player")
+				trace_ent.velocity_z = trace_ent.velocity_z + 400;
+		}
+	}
+	e1 = trace_ent;
+
+	traceline (p1 + f, p2 + f, FALSE, self);
+	if (trace_ent != e1 && trace_ent.takedamage)
+	{
+		particle (trace_endpos, '0 0 100', 225, damage*4);
+		T_Damage (trace_ent, from, from, damage);
+	}
+	e2 = trace_ent;
+
+	traceline (p1 - f, p2 - f, FALSE, self);
+	if (trace_ent != e1 && trace_ent != e2 && trace_ent.takedamage)
+	{
+		particle (trace_endpos, '0 0 100', 225, damage*4);
+		T_Damage (trace_ent, from, from, damage);
+	}
+};
+
+
+void() W_FireLightning =
+{
+	local	vector		org;
+	local	float		cells;
+
+	if (self.ammo_cells < 1)
+	{
+		self.weapon = W_BestWeapon ();
+		W_SetCurrentAmmo ();
+		return;
+	}
+
+// explode if under water
+	if (self.waterlevel > 1)
+	{
+		cells = self.ammo_cells;
+		self.ammo_cells = 0;
+		W_SetCurrentAmmo ();
+		T_RadiusDamage (self, self, 35*cells, world);
+		return;
+	}
+
+	if (self.t_width < time)
+	{
+		sound (self, CHAN_WEAPON, "weapons/lhit.wav", 1, ATTN_NORM);
+		self.t_width = time + 0.6;
+	}
+	self.punchangle_x = -2;
+
+	self.currentammo = self.ammo_cells = self.ammo_cells - 1;
+
+	org = self.origin + '0 0 16';
+	
+	traceline (org, org + v_forward*600, TRUE, self);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LIGHTNING2);
+	WriteEntity (MSG_BROADCAST, self);
+	WriteCoord (MSG_BROADCAST, org_x);
+	WriteCoord (MSG_BROADCAST, org_y);
+	WriteCoord (MSG_BROADCAST, org_z);
+	WriteCoord (MSG_BROADCAST, trace_endpos_x);
+	WriteCoord (MSG_BROADCAST, trace_endpos_y);
+	WriteCoord (MSG_BROADCAST, trace_endpos_z);
+
+	LightningDamage (self.origin, trace_endpos + v_forward*4, self, 30);
+};
+
+
+//=============================================================================
+
+
+void() GrenadeExplode =
+{
+	T_RadiusDamage (self, self.owner, 120, world);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	BecomeExplosion ();
+};
+
+void() GrenadeTouch =
+{
+	if (other == self.owner)
+		return;		// don't explode on owner
+	if (other.takedamage == DAMAGE_AIM)
+	{
+		GrenadeExplode();
+		return;
+	}
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);	// bounce sound
+	if (self.velocity == '0 0 0')
+		self.avelocity = '0 0 0';
+};
+
+/*
+================
+W_FireGrenade
+================
+*/
+void() W_FireGrenade =
+{
+	local	entity missile, mpuff;
+	
+	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
+	
+	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
+
+	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_BBOX;
+	missile.classname = "grenade";
+		
+// set missile speed	
+
+	makevectors (self.v_angle);
+
+	if (self.v_angle_x)
+		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+	else
+	{
+		missile.velocity = aim(self, 10000);
+		missile.velocity = missile.velocity * 600;
+		missile.velocity_z = 200;
+	}
+
+	missile.avelocity = '300 300 300';
+
+	missile.angles = vectoangles(missile.velocity);
+	
+	missile.touch = GrenadeTouch;
+	
+// set missile duration
+	missile.nextthink = time + 2.5;
+	missile.think = GrenadeExplode;
+
+	setmodel (missile, "progs/grenade.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, self.origin);
+};
+
+
+//=============================================================================
+
+void() spike_touch;
+void() superspike_touch;
+
+
+/*
+===============
+launch_spike
+
+Used for both the player and the ogre
+===============
+*/
+void(vector org, vector dir, float spd) launch_spike =
+{
+	newmis = spawn ();
+	newmis.owner = self;
+	newmis.movetype = MOVETYPE_FLYMISSILE;
+	newmis.solid = SOLID_BBOX;
+
+	newmis.angles = vectoangles(dir);
+	
+	newmis.touch = spike_touch;
+	newmis.classname = "spike";
+	newmis.think = SUB_Remove;
+	newmis.nextthink = time + 6;
+	setmodel (newmis, "progs/spike.mdl");
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	setorigin (newmis, org);
+
+	newmis.velocity = dir * spd;
+};
+
+void() W_FireSuperSpikes =
+{
+	local vector	dir;
+	local entity	old;
+	
+	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
+	self.attack_finished = time + 0.2;
+	self.currentammo = self.ammo_nails = self.ammo_nails - 2;
+	dir = aim (self, 1000);
+	if (self.player_flag & ITEM_RUNE3_FLAG) {
+		HasteSound();
+		launch_spike (self.origin + '0 0 16', dir, 2000);
+	} else
+		launch_spike (self.origin + '0 0 16', dir, 1000);
+	newmis.touch = superspike_touch;
+	setmodel (newmis, "progs/s_spike.mdl");
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	self.punchangle_x = -2;
+};
+
+void(float ox) W_FireSpikes =
+{
+	local vector	dir;
+	local entity	old;
+	
+	makevectors (self.v_angle);
+	
+	if (self.ammo_nails >= 2 && self.weapon == IT_SUPER_NAILGUN)
+	{
+		W_FireSuperSpikes ();
+		return;
+	}
+
+	if (self.ammo_nails < 1)
+	{
+		self.weapon = W_BestWeapon ();
+		W_SetCurrentAmmo ();
+		return;
+	}
+
+	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
+	self.attack_finished = time + 0.2;
+	self.currentammo = self.ammo_nails = self.ammo_nails - 1;
+	dir = aim (self, 1000);
+	if (self.player_flag & ITEM_RUNE3_FLAG) {
+		HasteSound();
+		launch_spike (self.origin + '0 0 16' + v_right*ox, dir, 2000);
+	} else
+		launch_spike (self.origin + '0 0 16' + v_right*ox, dir, 1000);
+
+	self.punchangle_x = -2;
+};
+
+
+
+.float hit_z;
+void() spike_touch =
+{
+local float rand;
+	if (other == self.owner)
+		return;
+
+	if (other.solid == SOLID_TRIGGER)
+		return;	// trigger field, do nothing
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	
+// hit something that bleeds
+	if (other.takedamage)
+	{
+		spawn_touchblood (9);
+		T_Damage (other, self, self.owner, 9);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		
+		if (self.classname == "wizspike")
+			WriteByte (MSG_BROADCAST, TE_WIZSPIKE);
+		else if (self.classname == "knightspike")
+			WriteByte (MSG_BROADCAST, TE_KNIGHTSPIKE);
+		else
+			WriteByte (MSG_BROADCAST, TE_SPIKE);
+		WriteCoord (MSG_BROADCAST, self.origin_x);
+		WriteCoord (MSG_BROADCAST, self.origin_y);
+		WriteCoord (MSG_BROADCAST, self.origin_z);
+	}
+
+	remove(self);
+
+};
+
+void() superspike_touch =
+{
+local float rand;
+	if (other == self.owner)
+		return;
+
+	if (other.solid == SOLID_TRIGGER)
+		return;	// trigger field, do nothing
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	
+// hit something that bleeds
+	if (other.takedamage)
+	{
+		spawn_touchblood (18);
+		T_Damage (other, self, self.owner, 18);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_SUPERSPIKE);
+		WriteCoord (MSG_BROADCAST, self.origin_x);
+		WriteCoord (MSG_BROADCAST, self.origin_y);
+		WriteCoord (MSG_BROADCAST, self.origin_z);
+	}
+
+	remove(self);
+
+};
+
+
+/*
+===============================================================================
+
+PLAYER WEAPON USE
+
+===============================================================================
+*/
+
+void() W_SetCurrentAmmo =
+{
+	player_run ();		// get out of any weapon firing states
+
+	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
+	
+	if (self.weapon == IT_AXE)
+	{
+		self.currentammo = 0;
+		self.weaponmodel = "progs/v_axe.mdl";
+		self.weaponframe = 0;
+	}
+	else if (self.weapon == IT_HOOK)
+	{
+		self.currentammo = 0;
+		if (teamplay & TEAM_CAPTURE_CUSTOM) 
+			self.weaponmodel = "progs/v_star.mdl";
+		else
+			self.weaponmodel = "progs/v_axe.mdl";
+		self.weaponframe = 0;
+	}
+	else if (self.weapon == IT_SHOTGUN)
+	{
+		self.currentammo = self.ammo_shells;
+		self.weaponmodel = "progs/v_shot.mdl";
+		self.weaponframe = 0;
+		self.items = self.items | IT_SHELLS;
+	}
+	else if (self.weapon == IT_SUPER_SHOTGUN)
+	{
+		self.currentammo = self.ammo_shells;
+		self.weaponmodel = "progs/v_shot2.mdl";
+		self.weaponframe = 0;
+		self.items = self.items | IT_SHELLS;
+	}
+	else if (self.weapon == IT_NAILGUN)
+	{
+		self.currentammo = self.ammo_nails;
+		self.weaponmodel = "progs/v_nail.mdl";
+		self.weaponframe = 0;
+		self.items = self.items | IT_NAILS;
+	}
+	else if (self.weapon == IT_SUPER_NAILGUN)
+	{
+		self.currentammo = self.ammo_nails;
+		self.weaponmodel = "progs/v_nail2.mdl";
+		self.weaponframe = 0;
+		self.items = self.items | IT_NAILS;
+	}
+	else if (self.weapon == IT_GRENADE_LAUNCHER)
+	{
+		self.currentammo = self.ammo_rockets;
+		self.weaponmodel = "progs/v_rock.mdl";
+		self.weaponframe = 0;
+		self.items = self.items | IT_ROCKETS;
+	}
+	else if (self.weapon == IT_ROCKET_LAUNCHER)
+	{
+		self.currentammo = self.ammo_rockets;
+		self.weaponmodel = "progs/v_rock2.mdl";
+		self.weaponframe = 0;
+		self.items = self.items | IT_ROCKETS;
+	}
+	else if (self.weapon == IT_LIGHTNING)
+	{
+		self.currentammo = self.ammo_cells;
+		self.weaponmodel = "progs/v_light.mdl";
+		self.weaponframe = 0;
+		self.items = self.items | IT_CELLS;
+	}
+	else
+	{
+		self.currentammo = 0;
+		self.weaponmodel = "";
+		self.weaponframe = 0;
+	}
+};
+
+float() W_BestWeapon =
+{
+	local	float	it;
+	
+	it = self.items;
+
+	if (self.waterlevel <= 1 && self.ammo_cells >= 1 && (it & IT_LIGHTNING) )
+		return IT_LIGHTNING;
+	if(self.ammo_nails >= 2 && (it & IT_SUPER_NAILGUN) )
+		return IT_SUPER_NAILGUN;
+	if(self.ammo_shells >= 2 && (it & IT_SUPER_SHOTGUN) )
+		return IT_SUPER_SHOTGUN;
+	if(self.ammo_nails >= 1 && (it & IT_NAILGUN) )
+		return IT_NAILGUN;
+	if(self.ammo_shells >= 1 && (it & IT_SHOTGUN) )
+		return IT_SHOTGUN;
+	return IT_AXE;
+};
+
+float() W_CheckNoAmmo =
+{
+	if (self.currentammo > 0)
+		return TRUE;
+
+	if (self.weapon == IT_AXE || self.weapon == IT_HOOK)
+		return TRUE;
+	
+	self.weapon = W_BestWeapon ();
+
+	W_SetCurrentAmmo ();
+	
+// drop the weapon down
+	return FALSE;
+};
+
+/*
+============
+W_Attack
+
+An attack impulse can be triggered now
+============
+*/
+void()	player_axe1;
+void()	player_axeb1;
+void()	player_axec1;
+void()	player_axed1;
+void()	player_shot1;
+void()	player_nail1;
+void()	player_light1;
+void()	player_rocket1;
+void()	player_chain1;
+void()  player_chain3;
+
+void() W_Attack =
+{
+	local	float	r;
+
+	if (!W_CheckNoAmmo ())
+		return;
+
+	makevectors	(self.v_angle);			// calculate forward angle for velocity
+	self.show_hostile = time + 1;	// wake monsters up
+
+	if (self.weapon == IT_AXE)
+	{
+		sound (self, CHAN_WEAPON, "weapons/ax1.wav", 1, ATTN_NORM);
+		r = random();
+		if (r < 0.25)
+			player_axe1 ();
+		else if (r<0.5)
+			player_axeb1 ();
+		else if (r<0.75)
+			player_axec1 ();
+		else
+			player_axed1 ();
+		// RUNE: rune of hell magic
+		if (self.player_flag & ITEM_RUNE3_FLAG) {
+			self.attack_finished = time + 0.3;
+			HasteSound();
+		} else
+			self.attack_finished = time + 0.5;
+	}
+	else if (self.weapon == IT_SHOTGUN)
+	{
+		player_shot1 ();
+		W_FireShotgun ();
+		// RUNE: rune of hell magic
+		if (self.player_flag & ITEM_RUNE3_FLAG) {
+			self.attack_finished = time + 0.3;
+			HasteSound();
+		} else
+		self.attack_finished = time + 0.5;
+	}
+	else if (self.weapon == IT_SUPER_SHOTGUN)
+	{
+		player_shot1 ();
+		W_FireSuperShotgun ();
+		// RUNE: rune of hell magic
+		if (self.player_flag & ITEM_RUNE3_FLAG) {
+			self.attack_finished = time + 0.4;
+			HasteSound();
+		} else
+		self.attack_finished = time + 0.7;
+	}
+	else if (self.weapon == IT_NAILGUN)
+	{
+		player_nail1 ();
+	}
+	else if (self.weapon == IT_SUPER_NAILGUN)
+	{
+		player_nail1 ();
+	}
+	else if (self.weapon == IT_GRENADE_LAUNCHER)
+	{
+		player_rocket1();
+		W_FireGrenade();
+		// RUNE: rune of hell magic
+		if (self.player_flag & ITEM_RUNE3_FLAG) {
+			self.attack_finished = time + 0.3;
+			HasteSound();
+		} else
+			self.attack_finished = time + 0.6;
+	}
+	else if (self.weapon == IT_ROCKET_LAUNCHER)
+	{
+		player_rocket1();
+		W_FireRocket();
+		// RUNE: rune of hell magic
+		if (self.player_flag & ITEM_RUNE3_FLAG) {
+			self.attack_finished = time + 0.4;
+			HasteSound();
+		} else
+			self.attack_finished = time + 0.8;
+	}
+	else if (self.weapon == IT_LIGHTNING)
+	{
+		player_light1();
+		self.attack_finished = time + 0.1;
+		sound (self, CHAN_AUTO, "weapons/lstart.wav", 1, ATTN_NORM);
+	}
+	else if (self.weapon == IT_HOOK)
+	{
+		if (!self.hook_out)
+			player_chain1();
+		else
+			player_chain3();
+		self.attack_finished = time + 0.1;
+	}
+};
+
+void() NotifyWeapon =
+{
+	if (self.weapon == IT_AXE)
+		sprint(self, "Axe selected.\n");
+	else if (self.weapon == IT_HOOK)
+		sprint(self, "Grappling hook selected.\n");
+};
+
+/*
+============
+W_ChangeWeapon
+
+============
+*/
+void() W_ChangeWeapon =
+{
+	local	float	it, am, fl;
+	
+	it = self.items;
+	am = 0;
+	
+	if (self.impulse == 1) {
+		if (self.weapon == IT_AXE)
+			fl = IT_HOOK;
+		else
+			fl = IT_AXE;
+	} else if (self.impulse == 31) {
+		fl = IT_AXE;
+	} else if (self.impulse == 2 || self.impulse == 32) {
+		fl = IT_SHOTGUN;
+		if (self.ammo_shells < 1)
+			am = 1;
+	} else if (self.impulse == 3 || self.impulse == 33) {
+		fl = IT_SUPER_SHOTGUN;
+		if (self.ammo_shells < 2)
+			am = 1;
+	} else if (self.impulse == 4 || self.impulse == 34) {
+		fl = IT_NAILGUN;
+		if (self.ammo_nails < 1)
+			am = 1;
+	} else if (self.impulse == 5) {
+		fl = IT_SUPER_NAILGUN;
+		if (self.ammo_nails < 2)
+			am = 1;
+	} else if (self.impulse == 35) {
+		fl = IT_SUPER_NAILGUN;
+		if (self.ammo_nails < 2)
+			am = 1;
+	} else if (self.impulse == 6 || self.impulse == 36) {
+		fl = IT_GRENADE_LAUNCHER;
+		if (self.ammo_rockets < 1)
+			am = 1;
+	} else if (self.impulse == 7 || self.impulse == 37) {
+		fl = IT_ROCKET_LAUNCHER;
+		if (self.ammo_rockets < 1)
+			am = 1;
+	} else if (self.impulse == 8 || self.impulse == 38) {
+		fl = IT_LIGHTNING;
+		if (self.ammo_cells < 1)
+			am = 1;
+	} else if (self.impulse == 22 || self.impulse == 39) {
+		fl = IT_HOOK;
+	}
+
+	self.impulse = 0;
+	
+	if (!(self.items & fl))
+	{	// don't have the weapon or the ammo
+		sprint (self, "no weapon.\n");
+		return;
+	}
+	
+	if (am)
+	{	// don't have the ammo
+		sprint (self, "not enough ammo.\n");
+		return;
+	}
+
+//McBain: save current weapon
+// For explicite weapon selection, allow previous weapon and new weapon to be
+// same except for IT_HOOK.
+	if (self.weapon != IT_HOOK || fl != IT_HOOK)
+		self.previous_weapon = self.weapon;
+
+//
+// set weapon, set ammo
+//
+	self.weapon = fl;		
+	NotifyWeapon();
+	W_SetCurrentAmmo ();
+};
+
+/*
+============
+CheatCommand
+============
+*/
+void() CheatCommand =
+{
+	if (deathmatch || coop)
+		return;
+
+	self.ammo_rockets = 100;
+	self.ammo_nails = 200;
+	self.ammo_shells = 100;
+	self.items = self.items | 
+		IT_AXE |
+		IT_HOOK |
+		IT_SHOTGUN |
+		IT_SUPER_SHOTGUN |
+		IT_NAILGUN |
+		IT_SUPER_NAILGUN |
+		IT_GRENADE_LAUNCHER |
+		IT_ROCKET_LAUNCHER |
+		IT_KEY1 | IT_KEY2;
+
+	self.ammo_cells = 200;
+	self.items = self.items | IT_LIGHTNING;
+
+	self.weapon = IT_ROCKET_LAUNCHER;
+	self.impulse = 0;
+	W_SetCurrentAmmo ();
+};
+
+/*
+============
+CycleWeaponCommand
+
+Go to the next weapon with ammo
+============
+*/
+void() CycleWeaponCommand =
+{
+	local	float	it, am;
+	
+	it = self.items;
+	self.impulse = 0;
+	
+//McBain: save current weapon
+	self.previous_weapon = self.weapon;
+
+	while (1)
+	{
+		am = 0;
+
+		if (self.weapon == IT_LIGHTNING) {
+			self.weapon = IT_AXE;
+		} else if (self.weapon == IT_AXE) {
+			self.weapon = IT_HOOK;
+		} else if (self.weapon == IT_HOOK) {
+			self.weapon = IT_SHOTGUN;
+			if (self.ammo_shells < 1)
+				am = 1;
+		} else if (self.weapon == IT_SHOTGUN) {
+			self.weapon = IT_SUPER_SHOTGUN;
+			if (self.ammo_shells < 2)
+				am = 1;
+		} else if (self.weapon == IT_SUPER_SHOTGUN) {
+			self.weapon = IT_NAILGUN;
+			if (self.ammo_nails < 1)
+				am = 1;
+		} else if (self.weapon == IT_NAILGUN) {
+			self.weapon = IT_SUPER_NAILGUN;
+			if (self.ammo_nails < 2)
+				am = 1;
+		} else if (self.weapon == IT_SUPER_NAILGUN) {
+			self.weapon = IT_GRENADE_LAUNCHER;
+			if (self.ammo_rockets < 1)
+				am = 1;
+		} else if (self.weapon == IT_GRENADE_LAUNCHER) {
+			self.weapon = IT_ROCKET_LAUNCHER;
+			if (self.ammo_rockets < 1)
+				am = 1;
+		} else if (self.weapon == IT_ROCKET_LAUNCHER) {
+			self.weapon = IT_LIGHTNING;
+			if (self.ammo_cells < 1)
+				am = 1;
+		}
+	
+		if ( (it & self.weapon) && am == 0)
+		{
+			NotifyWeapon();
+			W_SetCurrentAmmo ();
+			return;
+		}
+	}
+
+};
+
+/*
+============
+CycleWeaponReverseCommand
+
+Go to the prev weapon with ammo
+============
+*/
+void() CycleWeaponReverseCommand =
+{
+	local	float	it, am;
+	
+	it = self.items;
+	self.impulse = 0;
+
+//McBain: save current weapon
+	self.previous_weapon = self.weapon;
+
+	while (1)
+	{
+		am = 0;
+
+		if (self.weapon == IT_LIGHTNING)
+		{
+			self.weapon = IT_ROCKET_LAUNCHER;
+			if (self.ammo_rockets < 1)
+				am = 1;
+		}
+		else if (self.weapon == IT_ROCKET_LAUNCHER)
+		{
+			self.weapon = IT_GRENADE_LAUNCHER;
+			if (self.ammo_rockets < 1)
+				am = 1;
+		}
+		else if (self.weapon == IT_GRENADE_LAUNCHER)
+		{
+			self.weapon = IT_SUPER_NAILGUN;
+			if (self.ammo_nails < 1)
+				am = 1;
+		}
+		else if (self.weapon == IT_SUPER_NAILGUN)
+		{
+			self.weapon = IT_NAILGUN;
+			if (self.ammo_nails < 1)
+				am = 1;
+		}
+		else if (self.weapon == IT_NAILGUN)
+		{
+			self.weapon = IT_SUPER_SHOTGUN;
+			if (self.ammo_shells < 2)
+				am = 1;
+		}		
+		else if (self.weapon == IT_SUPER_SHOTGUN)
+		{
+			self.weapon = IT_SHOTGUN;
+			if (self.ammo_shells < 1)
+				am = 1;
+		}
+		else if (self.weapon == IT_SHOTGUN)
+		{
+			self.weapon = IT_HOOK;
+		}
+		else if (self.weapon == IT_HOOK)
+		{
+			self.weapon = IT_AXE;
+		}
+		else if (self.weapon == IT_AXE)
+		{
+			self.weapon = IT_LIGHTNING;
+			if (self.ammo_cells < 1)
+				am = 1;
+		}
+	
+		if ( (it & self.weapon) && am == 0)
+		{
+			NotifyWeapon();
+			W_SetCurrentAmmo ();
+			return;
+		}
+	}
+
+};
+
+//McBain: Here's the beef...
+/*
+============
+PreviousWeaponCommand
+============
+*/
+void() PreviousWeaponCommand =
+{
+	local	float	fl, am;
+	
+	self.impulse = 0;
+	am = 0;
+
+	fl = self.weapon;
+	self.weapon = self.previous_weapon;
+	self.previous_weapon = fl;
+
+	// this might not be the best method, but I'll be able to play sooner
+	if (self.weapon == IT_SHOTGUN || self.weapon == IT_SUPER_SHOTGUN) {
+		if (self.ammo_shells < 1)
+			am = 1;
+	}
+	else if (self.weapon == IT_NAILGUN || self.weapon == IT_SUPER_NAILGUN) {
+		if (self.ammo_nails < 1)
+			am = 1;
+	}
+	else if (self.weapon == IT_GRENADE_LAUNCHER || self.weapon == IT_ROCKET_LAUNCHER) {
+		if (self.ammo_rockets < 1)
+			am = 1;
+	}
+	else if (self.weapon == IT_LIGHTNING) {
+		if (self.ammo_cells < 1)
+			am = 1;
+	}
+	// ignore AXE & HOOK -- no ammo needed
+
+	if (am)
+		self.weapon = W_BestWeapon ();
+
+	W_SetCurrentAmmo ();
+};
+
+/*
+============
+ServerflagsCommand
+
+Just for development
+============
+*/
+void() ServerflagsCommand =
+{
+	serverflags = serverflags * 2 + 1;
+// ZOID:  Bug fix
+	serverflags = (serverflags & 15);
+};
+
+void() QuadCheat =
+{
+	if (deathmatch || coop)
+		return;
+	self.super_time = 1;
+	self.super_damage_finished = time + 30;
+	self.items = self.items | IT_QUAD;
+	dprint ("quad cheat\n");
+};
+
+//ZOID:  Uhm, where am I?
+void() PrintLocation =
+{
+	local string p;
+
+	p = vtos(self.origin);
+
+	sprint(self, "You are at ");
+	sprint(self, p);
+	sprint(self, "\n");
+};
+
+/*
+============
+ImpulseCommands
+
+============
+*/
+//ZOID: Note, changed it all to an if/else construct.  No need to check
+//remaining impulses if we have one already.  Much cleaner and a tad
+//more efficient.  Using a non-existant impulse is still the worst case. :(
+void() ImpulseCommands =
+{
+	if (self.accessparm) // admin functions
+		CheckAdminCmd();
+
+	else if (!self.observer &&
+		((self.impulse >= 1 && self.impulse <= 8) || self.impulse == 22 ||
+		(self.impulse >= 31 && self.impulse <= 40) ||
+ 		self.impulse == 50))
+		W_ChangeWeapon ();
+
+	else if (self.impulse == 9)
+		CheatCommand ();
+
+	else if (!self.observer && self.impulse == 10)
+		CycleWeaponCommand ();
+
+	else if (self.impulse == 11)
+		ServerflagsCommand ();
+
+	else if (!self.observer && self.impulse == 12)
+		CycleWeaponReverseCommand ();
+
+//McBain: I picked 69 -- seems appropriate!  I hope 69 hasn't been used in
+// other add-ons.  This is my first attempt at Quake C, and I hope I haven't
+// violated any Quake C ettiquette.  :(
+	else if (!self.observer && self.impulse == 69)
+		PreviousWeaponCommand ();
+
+	else if (self.impulse == 99)
+		PrintLocation();
+		
+/* -=CT=-KALWeb : Begin Enhanced -=CT=-CTF */
+// If Rune Dropping is allowed, let me. :)
+        else if (!self.observer && (teamplay & TEAM_DROP_RUNE) && (self.impulse & DROP_RUNE_IMPULSE))
+                TossRune();
+
+// *TEAMPLAY*
+// If we're allowed to drop items, enable impulse 20 and 21
+	else if (!self.observer && (teamplay & TEAM_DROP_ITEMS) && self.impulse == 20)
+		TossBackpack ();
+
+	else if (!self.observer && (teamplay & TEAM_DROP_ITEMS) && self.impulse == 21)
+		TossWeapon ();
+
+// *TEAMPLAY*
+// Impulse 25 prints info about the current teamplay settings.
+	else if (self.impulse == 25)
+		TeamPrintSettings ();
+
+// *Capture The Flag - Status report by Wonko
+// Impulse 23 prints the current status of your flag and the
+// enemy flag (summarizes the endless messages)
+	else if (self.impulse == 23)
+		TeamFlagStatusReport();
+
+	else if (self.impulse == 141)
+		identify_player();
+
+	else if (self.impulse == 70) {
+		self.statoff = !self.statoff; // status bar toggle
+		if (self.statoff)
+			sprint(self, "Status bar off.\n");
+		else
+			sprint(self, "Status bar on.\n");
+
+	} else if (self.impulse == 255)
+		QuadCheat ();
+	else
+		CheckAdminCmd();
+		
+	self.impulse = 0;
+};
+
+/*
+============
+W_WeaponFrame
+
+Called every frame so impulse events can be handled as well as possible
+============
+*/
+void() W_WeaponFrame =
+{
+	if (time < self.attack_finished)
+		return;
+
+//ZOID: Only call ImpulseCommands() if needed!  This saves a good chunk
+//of cpu.  'profile' in console listed ImpulseCommands() as #1 user of
+//cpu (instructions), adding this one line caused it to not even be in
+//the top ten.
+	if (self.impulse)
+		ImpulseCommands ();
+	
+// check for attack
+	if (self.button0)
+	{
+		SuperDamageSound ();
+		W_Attack ();
+	}
+};
+
+/*
+========
+Resistancesound
+
+Plays sound if needed
+========
+*/
+void(entity who) ResistanceSound =
+{
+// RUNE play resistance sound if player has Earth Magic
+	if (who.player_flag & ITEM_RUNE1_FLAG) {
+		if (who.invincible_sound < time) {
+			who.invincible_sound = time + 1;
+			if (teamplay & TEAM_CAPTURE_CUSTOM)
+				sound(who, CHAN_BODY, "rune/rune1.wav", 1, ATTN_NORM);
+			else
+				sound(who, CHAN_BODY, "items/protect3.wav", 1, ATTN_NORM);
+		}
+	}
+};
+/*
+========
+SuperDamageSound
+
+Plays sound if needed
+========
+*/
+void() SuperDamageSound =
+{
+// RUNE play super damage sound if player has Black Magic, too
+	if (!(teamplay & TEAM_CAPTURE_CUSTOM)) {
+		if (self.super_damage_finished > time ||
+			(self.player_flag & ITEM_RUNE2_FLAG)) {
+			if (self.super_sound < time) {
+				self.super_sound = time + 1;
+				sound (self, CHAN_BODY, "items/damage3.wav", 1, ATTN_NORM);
+			}
+		}
+		return;
+	}
+
+	if ((self.player_flag & ITEM_RUNE2_FLAG) && 
+		(self.super_damage_finished > time)) {
+		if (self.super_sound < time) {
+			self.super_sound = time + 1;
+			sound (self, CHAN_BODY, "rune/rune22.wav", 1, ATTN_NORM);
+		}
+	}
+
+	if (self.super_damage_finished > time) {
+		if (self.super_sound < time) {
+			self.super_sound = time + 1;
+			sound (self, CHAN_BODY, "items/damage3.wav", 1, ATTN_NORM);
+		}
+	}
+
+	if (self.player_flag & ITEM_RUNE2_FLAG) {
+		if (self.super_sound < time) {
+			self.super_sound = time + 1;
+			sound (self, CHAN_BODY, "rune/rune2.wav", 1, ATTN_NORM);
+		}
+	}
+};
+
+/*
+========
+RegenerationSound
+
+Plays sound if needed
+========
+*/
+void() RegenerationSound =
+{
+// RUNE play healing sound if player has Elder Magic
+	if (self.player_flag & ITEM_RUNE4_FLAG) {
+		if (self.regeneration_sound < time) {
+			self.regeneration_sound = time + 1;
+			if (teamplay & TEAM_CAPTURE_CUSTOM)
+				sound(self, CHAN_BODY, "rune/rune4.wav", 1, ATTN_NORM);
+			else
+				sound(self, CHAN_BODY, "items/r_item1.wav", 1, ATTN_NORM);
+		}
+	}
+};
+
+/*
+========
+HasteSound
+
+Plays sound if needed
+========
+*/
+void() HasteSound =
+{
+// RUNE play haste (Chthon's roar) sound if player has Hell Magic
+	if (self.player_flag & ITEM_RUNE3_FLAG) {
+		if (self.haste_sound < time) {
+			self.haste_sound = time + 1;
+			if (teamplay & TEAM_CAPTURE_CUSTOM)
+				sound(self, CHAN_BODY, "rune/rune3.wav", 1, ATTN_NORM);
+			else
+				sound(self, CHAN_BODY, "boss1/sight1.wav", 1, ATTN_NORM);
+		}
+	}
+};
+
+// Identify the player you are pointed towards
+// By Suck (Nat Friedman)
+// This code falls under the GNU public license, and cannot be 
+// redistributed without my name attached.
+
+// hacked by Zoid for CTF4
+
+// This is called with the player who wants to know whose in front
+// of him as "self."  I call it with an impulse in weapons.qc 
+entity(float disp) identify_player =
+{
+	// e is a temp entity; guy is our current best guess
+	// as to at whom the player is pointing
+	local entity e, guy;
+
+	// The best "closeness" heuristic so far.
+	local float closeness = -1;
+
+	// Temp vars.
+	local vector diff, point;
+	local float currclose;
+	local string s1, s2, s3;
+
+	// Walk the list of players...
+	e=find(world, classname, "player");
+	while (e!=world)
+	{
+		// Get a vector pointing from the viewer to the current
+		// player under consideration
+		diff=self.origin - e.origin;
+
+		// Normalize it since we only care where he's pointing,
+		// not how far away the guy is.
+		diff=normalize(diff);
+
+		// Normalize self.angles so we can do a length-independent
+		// consideration
+		point=normalize(self.angles);
+
+		// Find the different between the current player's angle
+		// and the viewer's vision angle
+		diff=diff - point;
+
+		// The length is going to be our definition of closeness
+		currclose=vlen(diff);
+		traceline(self.origin, e.origin, FALSE, self);
+		if (trace_ent == e) {
+			if (closeness == -1) {
+				closeness = currclose;
+				guy = e;
+			} else if (currclose < closeness) {
+				closeness = currclose;
+				guy = e;
+			}
+		}
+		e=find(e, classname, "player");
+	}
+
+	// Now we display.
+	if (disp==0)
+		return guy;
+	if (guy == world)
+	{
+		TeamPlayerUpdate(self, "You're not looking at anyone!");
+		return world;
+	}
+	TeamPlayerUpdate2(self, "You are looking at ", guy.netname);
+	return guy;
+};	 
+
+
+float DOOR_START_OPEN = 1;
+float DOOR_DONT_LINK = 4;
+float DOOR_GOLD_KEY = 8;
+float DOOR_SILVER_KEY = 16;
+float DOOR_TOGGLE = 32;
+
+/*
+
+Doors are similar to buttons, but can spawn a fat trigger field around them
+to open without a touch, and they link together to form simultanious
+double/quad doors.
+ 
+Door.owner is the master door.  If there is only one door, it points to itself.
+If multiple doors, all will point to a single one.
+
+Door.enemy chains from the master door through all doors linked in the chain.
+
+*/
+
+/*
+=============================================================================
+
+THINK FUNCTIONS
+
+=============================================================================
+*/
+
+void() door_go_down;
+void() door_go_up;
+
+void() door_blocked =
+{
+	T_Damage (other, self, self, self.dmg);
+	
+// if a door has a negative wait, it would never come back if blocked,
+// so let it just squash the object to death real fast
+	if (self.wait >= 0)
+	{
+		if (self.state == STATE_DOWN)
+			door_go_up ();
+		else
+			door_go_down ();
+	}
+};
+
+
+void() door_hit_top =
+{
+	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
+	self.state = STATE_TOP;
+	if (self.spawnflags & DOOR_TOGGLE)
+		return;		// don't come down automatically
+	self.think = door_go_down;
+	self.nextthink = self.ltime + self.wait;
+};
+
+void() door_hit_bottom =
+{
+	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
+	self.state = STATE_BOTTOM;
+};
+
+void() door_go_down =
+{
+	sound (self, CHAN_VOICE, self.noise2, 1, ATTN_NORM);
+	if (self.max_health)
+	{
+		self.takedamage = DAMAGE_YES;
+		self.health = self.max_health;
+	}
+	
+	self.state = STATE_DOWN;
+	SUB_CalcMove (self.pos1, self.speed, door_hit_bottom);
+};
+
+void() door_go_up =
+{
+	if (self.state == STATE_UP)
+		return;		// allready going up
+
+	if (self.state == STATE_TOP)
+	{	// reset top wait time
+		self.nextthink = self.ltime + self.wait;
+		return;
+	}
+	
+	sound (self, CHAN_VOICE, self.noise2, 1, ATTN_NORM);
+	self.state = STATE_UP;
+	SUB_CalcMove (self.pos2, self.speed, door_hit_top);
+
+	SUB_UseTargets();
+};
+
+
+/*
+=============================================================================
+
+ACTIVATION FUNCTIONS
+
+=============================================================================
+*/
+
+void() door_fire =
+{
+	local entity 	oself;
+	local entity	starte;
+
+	if (self.owner != self)
+		objerror ("door_fire: self.owner != self");
+
+// play use key sound
+
+	if (self.items)
+		sound (self, CHAN_VOICE, self.noise4, 1, ATTN_NORM);
+
+	self.message = string_null;		// no more message
+	oself = self;
+
+	if (self.spawnflags & DOOR_TOGGLE)
+	{
+		if (self.state == STATE_UP || self.state == STATE_TOP)
+		{
+			starte = self;
+			do
+			{
+				door_go_down ();
+				self = self.enemy;
+			} while ( (self != starte) && (self != world) );
+			self = oself;
+			return;
+		}
+	}
+	
+// trigger all paired doors
+	starte = self;
+	do
+	{
+		door_go_up ();
+		self = self.enemy;
+	} while ( (self != starte) && (self != world) );
+	self = oself;
+};
+
+
+void() door_use =
+{
+	local entity oself;
+
+	self.message = "";			// door message are for touch only
+	self.owner.message = "";	
+	self.enemy.message = "";
+	oself = self;
+	self = self.owner;
+	door_fire ();
+	self = oself;
+};
+
+
+void() door_trigger_touch =
+{
+	if (other.health <= 0)
+		return;
+
+	if (time < self.attack_finished)
+		return;
+	self.attack_finished = time + 1;
+
+	activator = other;
+
+	self = self.owner;
+	door_use ();
+};
+
+
+void() door_killed =
+{
+	local entity oself;
+	
+	oself = self;
+	self = self.owner;
+	self.health = self.max_health;
+	self.takedamage = DAMAGE_NO;	// wil be reset upon return
+	door_use ();
+	self = oself;
+};
+
+
+/*
+================
+door_touch
+
+Prints messages and opens key doors
+================
+*/
+void() door_touch =
+{
+	if (other.classname != "player")
+		return;
+	if (self.owner.attack_finished > time)
+		return;
+
+	self.owner.attack_finished = time + 2;
+
+	if (self.owner.message != "")
+	{
+		centerprint (other, self.owner.message);
+		sound (other, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
+	}
+	
+// key door stuff
+	if (!self.items)
+		return;
+
+// FIXME: blink key on player's status bar
+	if ( (self.items & other.items) != self.items )
+	{
+		if (self.owner.items == IT_KEY1)
+		{
+			if (world.worldtype == 2)
+			{
+				centerprint (other, "You need the silver keycard");
+				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+			}
+			else if (world.worldtype == 1)
+			{
+				centerprint (other, "You need the silver runekey");
+				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+			}
+			else if (world.worldtype == 0)
+			{
+				centerprint (other, "You need the silver key");
+				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+			}
+		}
+		else
+		{
+			if (world.worldtype == 2)
+			{
+				centerprint (other, "You need the gold keycard");
+				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+			}
+			else if (world.worldtype == 1)
+			{
+				centerprint (other, "You need the gold runekey");
+				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);			
+			}
+			else if (world.worldtype == 0)
+			{
+				centerprint (other, "You need the gold key");
+				sound (self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+			}
+		}
+		return;
+	}
+
+	other.items = other.items - self.items;
+	self.touch = SUB_Null;
+	if (self.enemy)
+		self.enemy.touch = SUB_Null;	// get paired door
+	door_use ();
+};
+
+/*
+=============================================================================
+
+SPAWNING FUNCTIONS
+
+=============================================================================
+*/
+
+
+entity(vector fmins, vector fmaxs) spawn_field =
+{
+	local entity	trigger;
+	local	vector	t1, t2;
+
+	trigger = spawn();
+	trigger.movetype = MOVETYPE_NONE;
+	trigger.solid = SOLID_TRIGGER;
+	trigger.owner = self;
+	trigger.touch = door_trigger_touch;
+
+	t1 = fmins;
+	t2 = fmaxs;
+	setsize (trigger, t1 - '60 60 8', t2 + '60 60 8');
+	return (trigger);
+};
+
+
+float (entity e1, entity e2) EntitiesTouching =
+{
+	if (e1.mins_x > e2.maxs_x)
+		return FALSE;
+	if (e1.mins_y > e2.maxs_y)
+		return FALSE;
+	if (e1.mins_z > e2.maxs_z)
+		return FALSE;
+	if (e1.maxs_x < e2.mins_x)
+		return FALSE;
+	if (e1.maxs_y < e2.mins_y)
+		return FALSE;
+	if (e1.maxs_z < e2.mins_z)
+		return FALSE;
+	return TRUE;
+};
+
+
+/*
+=============
+LinkDoors
+
+
+=============
+*/
+void() LinkDoors =
+{
+	local entity	t, starte;
+	local vector	cmins, cmaxs;
+
+	if (self.enemy)
+		return;		// already linked by another door
+	if (self.spawnflags & 4)
+	{
+		self.owner = self.enemy = self;
+		return;		// don't want to link this door
+	}
+
+	cmins = self.mins;
+	cmaxs = self.maxs;
+	
+	starte = self;
+	t = self;
+	
+	do
+	{
+		self.owner = starte;			// master door
+
+		if (self.health)
+			starte.health = self.health;
+		if (self.targetname)
+			starte.targetname = self.targetname;
+		if (self.message != "")
+			starte.message = self.message;
+
+		t = find (t, classname, self.classname);	
+		if (!t)
+		{
+			self.enemy = starte;		// make the chain a loop
+
+		// shootable, fired, or key doors just needed the owner/enemy links,
+		// they don't spawn a field
+	
+			self = self.owner;
+
+			if (self.health)
+				return;
+			if (self.targetname)
+				return;
+			if (self.items)
+				return;
+
+			self.owner.trigger_field = spawn_field(cmins, cmaxs);
+
+			return;
+		}
+
+		if (EntitiesTouching(self,t))
+		{
+			if (t.enemy)
+				objerror ("cross connected doors");
+			
+			self.enemy = t;
+			self = t;
+
+			if (t.mins_x < cmins_x)
+				cmins_x = t.mins_x;
+			if (t.mins_y < cmins_y)
+				cmins_y = t.mins_y;
+			if (t.mins_z < cmins_z)
+				cmins_z = t.mins_z;
+			if (t.maxs_x > cmaxs_x)
+				cmaxs_x = t.maxs_x;
+			if (t.maxs_y > cmaxs_y)
+				cmaxs_y = t.maxs_y;
+			if (t.maxs_z > cmaxs_z)
+				cmaxs_z = t.maxs_z;
+		}
+	} while (1 );
+
+};
+
+
+/*QUAKED func_door (0 .5 .8) ? START_OPEN x DOOR_DONT_LINK GOLD_KEY SILVER_KEY TOGGLE
+if two doors touch, they are assumed to be connected and operate as a unit.
+
+TOGGLE causes the door to wait in both the start and end states for a trigger event.
+
+START_OPEN causes the door to move to its destination when spawned, and operate in reverse.  It is used to temporarily or permanently close off an area when triggered (not usefull for touch or takedamage doors).
+
+Key doors are allways wait -1.
+
+"message"	is printed when the door is touched if it is a trigger door and it hasn't been fired yet
+"angle"		determines the opening direction
+"targetname" if set, no touch field will be spawned and a remote button or trigger field activates the door.
+"health"	if set, door must be shot open
+"speed"		movement speed (100 default)
+"wait"		wait before returning (3 default, -1 = never return)
+"lip"		lip remaining at end of move (8 default)
+"dmg"		damage to inflict when blocked (2 default)
+"sounds"
+0)	no sound
+1)	stone
+2)	base
+3)	stone chain
+4)	screechy metal
+*/
+
+void() func_door =
+
+{
+
+	if (world.worldtype == 0)
+	{
+		precache_sound ("doors/medtry.wav");
+		precache_sound ("doors/meduse.wav");
+		self.noise3 = "doors/medtry.wav";
+		self.noise4 = "doors/meduse.wav";
+	}
+	else if (world.worldtype == 1)
+	{
+		precache_sound ("doors/runetry.wav");
+		precache_sound ("doors/runeuse.wav");
+		self.noise3 = "doors/runetry.wav";
+		self.noise4 = "doors/runeuse.wav";
+	}
+	else if (world.worldtype == 2)
+	{
+		precache_sound ("doors/basetry.wav");
+		precache_sound ("doors/baseuse.wav");
+		self.noise3 = "doors/basetry.wav";
+		self.noise4 = "doors/baseuse.wav";
+	}
+	else
+	{
+		dprint ("no worldtype set!\n");
+	}
+	if (self.sounds == 0)
+	{
+		precache_sound ("misc/null.wav");
+		precache_sound ("misc/null.wav");
+		self.noise1 = "misc/null.wav";
+		self.noise2 = "misc/null.wav";
+	}
+	if (self.sounds == 1)
+	{
+		precache_sound ("doors/drclos4.wav");
+		precache_sound ("doors/doormv1.wav");
+		self.noise1 = "doors/drclos4.wav";
+		self.noise2 = "doors/doormv1.wav";
+	}
+	if (self.sounds == 2)
+	{
+		precache_sound ("doors/hydro1.wav");
+		precache_sound ("doors/hydro2.wav");
+		self.noise2 = "doors/hydro1.wav";
+		self.noise1 = "doors/hydro2.wav";
+	}
+	if (self.sounds == 3)
+	{
+		precache_sound ("doors/stndr1.wav");
+		precache_sound ("doors/stndr2.wav");
+		self.noise2 = "doors/stndr1.wav";
+		self.noise1 = "doors/stndr2.wav";
+	}
+	if (self.sounds == 4)
+	{
+		precache_sound ("doors/ddoor1.wav");
+		precache_sound ("doors/ddoor2.wav");
+		self.noise1 = "doors/ddoor2.wav";
+		self.noise2 = "doors/ddoor1.wav";
+	}
+
+
+	SetMovedir ();
+
+	self.max_health = self.health;
+	self.solid = SOLID_BSP;
+	self.movetype = MOVETYPE_PUSH;
+	setorigin (self, self.origin);	
+	setmodel (self, self.model);
+	self.classname = "door";
+
+	self.blocked = door_blocked;
+	self.use = door_use;
+	
+	if (self.spawnflags & DOOR_SILVER_KEY)
+		self.items = IT_KEY1;
+	if (self.spawnflags & DOOR_GOLD_KEY)
+		self.items = IT_KEY2;
+	
+	if (!self.speed)
+		self.speed = 100;
+	if (!self.wait)
+		self.wait = 3;
+	if (!self.lip)
+		self.lip = 8;
+	if (!self.dmg)
+		self.dmg = 2;
+
+	self.pos1 = self.origin;
+	self.pos2 = self.pos1 + self.movedir*(fabs(self.movedir*self.size) - self.lip);
+
+// DOOR_START_OPEN is to allow an entity to be lighted in the closed position
+// but spawn in the open position
+	if (self.spawnflags & DOOR_START_OPEN)
+	{
+		setorigin (self, self.pos2);
+		self.pos2 = self.pos1;
+		self.pos1 = self.origin;
+	}
+
+	self.state = STATE_BOTTOM;
+
+	if (self.health)
+	{
+		self.takedamage = DAMAGE_YES;
+		self.th_die = door_killed;
+	}
+	
+	if (self.items)
+		self.wait = -1;
+		
+	self.touch = door_touch;
+
+// LinkDoors can't be done until all of the doors have been spawned, so
+// the sizes can be detected properly.
+	self.think = LinkDoors;
+	self.nextthink = self.ltime + 0.1;
+};
+
+/*
+=============================================================================
+
+SECRET DOORS
+
+=============================================================================
+*/
+
+void() fd_secret_move1;
+void() fd_secret_move2;
+void() fd_secret_move3;
+void() fd_secret_move4;
+void() fd_secret_move5;
+void() fd_secret_move6;
+void() fd_secret_done;
+
+float SECRET_OPEN_ONCE = 1;		// stays open
+float SECRET_1ST_LEFT = 2;		// 1st move is left of arrow
+float SECRET_1ST_DOWN = 4;		// 1st move is down from arrow
+float SECRET_NO_SHOOT = 8;		// only opened by trigger
+float SECRET_YES_SHOOT = 16;	// shootable even if targeted
+float SECRET_NEVER = 32;		// lock it shut
+
+
+void () fd_secret_use =
+{
+	local float temp;
+	
+	self.health = 10000;
+
+	// exit if still moving around...
+	if (self.origin != self.oldorigin)
+		return;
+	
+	self.message = string_null;		// no more message
+
+	SUB_UseTargets();				// fire all targets / killtargets
+	
+	if (self.spawnflags & SECRET_NEVER)
+		return; // it never opens
+	
+	if (!(self.spawnflags & SECRET_NO_SHOOT))
+	{
+		self.th_pain = SUB_Null;
+		self.takedamage = DAMAGE_NO;
+	}
+	self.velocity = '0 0 0';
+
+	// Make a sound, wait a little...
+	
+	sound(self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
+	self.nextthink = self.ltime + 0.1;
+
+	temp = 1 - (self.spawnflags & SECRET_1ST_LEFT);	// 1 or -1
+	makevectors(self.mangle);
+	
+	if (!self.t_width)
+	{
+		if (self.spawnflags & SECRET_1ST_DOWN)
+			self. t_width = fabs(v_up * self.size);
+		else
+			self. t_width = fabs(v_right * self.size);
+	}
+		
+	if (!self.t_length)
+		self. t_length = fabs(v_forward * self.size);
+
+	if (self.spawnflags & SECRET_1ST_DOWN)
+		self.dest1 = self.origin - v_up * self.t_width;
+	else
+		self.dest1 = self.origin + v_right * (self.t_width * temp);
+		
+	self.dest2 = self.dest1 + v_forward * self.t_length;
+	SUB_CalcMove(self.dest1, self.speed, fd_secret_move1);
+	sound(self, CHAN_VOICE, self.noise2, 1, ATTN_NORM);
+};
+
+// Wait after first movement...
+void () fd_secret_move1 = 
+{
+	self.nextthink = self.ltime + 1.0;
+	self.think = fd_secret_move2;
+	sound(self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+};
+
+// Start moving sideways w/sound...
+void () fd_secret_move2 =
+{
+	sound(self, CHAN_VOICE, self.noise2, 1, ATTN_NORM);
+	SUB_CalcMove(self.dest2, self.speed, fd_secret_move3);
+};
+
+// Wait here until time to go back...
+void () fd_secret_move3 =
+{
+	sound(self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+	if (!(self.spawnflags & SECRET_OPEN_ONCE))
+	{
+		self.nextthink = self.ltime + self.wait;
+		self.think = fd_secret_move4;
+	}
+};
+
+// Move backward...
+void () fd_secret_move4 =
+{
+	sound(self, CHAN_VOICE, self.noise2, 1, ATTN_NORM);
+	SUB_CalcMove(self.dest1, self.speed, fd_secret_move5);		
+};
+
+// Wait 1 second...
+void () fd_secret_move5 = 
+{
+	self.nextthink = self.ltime + 1.0;
+	self.think = fd_secret_move6;
+	sound(self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+};
+
+void () fd_secret_move6 =
+{
+	sound(self, CHAN_VOICE, self.noise2, 1, ATTN_NORM);
+	SUB_CalcMove(self.oldorigin, self.speed, fd_secret_done);
+};
+
+void () fd_secret_done =
+{
+	if (!self.targetname || self.spawnflags&SECRET_YES_SHOOT)
+	{
+		self.health = 10000;
+		self.takedamage = DAMAGE_YES;
+		self.th_pain = fd_secret_use;	
+	}
+	sound(self, CHAN_VOICE, self.noise3, 1, ATTN_NORM);
+};
+
+void () secret_blocked =
+{
+	if (time < self.attack_finished)
+		return;
+	self.attack_finished = time + 0.5;
+	T_Damage (other, self, self, self.dmg);
+};
+
+/*
+================
+secret_touch
+
+Prints messages
+================
+*/
+void() secret_touch =
+{
+	if (other.classname != "player")
+		return;
+	if (self.attack_finished > time)
+		return;
+
+	self.attack_finished = time + 2;
+	
+	if (self.message)
+	{
+		centerprint (other, self.message);
+		sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
+	}
+};
+
+
+/*QUAKED func_door_secret (0 .5 .8) ? open_once 1st_left 1st_down no_shoot always_shoot
+Basic secret door. Slides back, then to the side. Angle determines direction.
+wait  = # of seconds before coming back
+1st_left = 1st move is left of arrow
+1st_down = 1st move is down from arrow
+always_shoot = even if targeted, keep shootable
+t_width = override WIDTH to move back (or height if going down)
+t_length = override LENGTH to move sideways
+"dmg"		damage to inflict when blocked (2 default)
+
+If a secret door has a targetname, it will only be opened by it's botton or trigger, not by damage.
+"sounds"
+1) medieval
+2) metal
+3) base
+*/
+
+void () func_door_secret =
+{
+	if (self.sounds == 0)
+		self.sounds = 3;
+	if (self.sounds == 1)
+	{
+		precache_sound ("doors/latch2.wav");
+		precache_sound ("doors/winch2.wav");
+		precache_sound ("doors/drclos4.wav");
+		self.noise1 = "doors/latch2.wav";
+		self.noise2 = "doors/winch2.wav";
+		self.noise3 = "doors/drclos4.wav";
+	}
+	if (self.sounds == 2)
+	{
+		precache_sound ("doors/airdoor1.wav");
+		precache_sound ("doors/airdoor2.wav");
+		self.noise2 = "doors/airdoor1.wav";
+		self.noise1 = "doors/airdoor2.wav";
+		self.noise3 = "doors/airdoor2.wav";
+	}
+	if (self.sounds == 3)
+	{
+		precache_sound ("doors/basesec1.wav");
+		precache_sound ("doors/basesec2.wav");
+		self.noise2 = "doors/basesec1.wav";
+		self.noise1 = "doors/basesec2.wav";
+		self.noise3 = "doors/basesec2.wav";
+	}
+
+	if (!self.dmg)
+		self.dmg = 2;
+		
+	// Magic formula...
+	self.mangle = self.angles;
+	self.angles = '0 0 0';
+	self.solid = SOLID_BSP;
+	self.movetype = MOVETYPE_PUSH;
+	self.classname = "door";
+
+	setmodel (self, self.model);
+	setorigin (self, self.origin);	
+	
+	self.touch = secret_touch;
+	self.blocked = secret_blocked;
+	self.speed = 50;
+	self.use = fd_secret_use;
+	if ( !self.targetname || self.spawnflags&SECRET_YES_SHOOT)
+	{
+		self.health = 10000;
+		self.takedamage = DAMAGE_YES;
+		self.th_pain = fd_secret_use;
+		self.th_die = fd_secret_use;
+	}
+	self.oldorigin = self.origin;
+	if (!self.wait)
+		self.wait = 5;		// 5 seconds before closing
+};
+/*
+==============================================================================
+
+SOLDIER / PLAYER
+
+==============================================================================
+*/
+
+$cd id1/models/enforcer
+$origin 0 -6 24
+$base base		
+$skin skin
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8 walk9 walk10
+$frame walk11 walk12 walk13 walk14 walk15 walk16
+
+$frame run1 run2 run3 run4 run5 run6 run7 run8
+
+$frame attack1 attack2 attack3 attack4 attack5 attack6
+$frame attack7 attack8 attack9 attack10
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8
+$frame death9 death10 death11 death12 death13 death14
+
+$frame fdeath1 fdeath2 fdeath3 fdeath4 fdeath5 fdeath6 fdeath7 fdeath8
+$frame fdeath9 fdeath10 fdeath11
+
+$frame paina1 paina2 paina3 paina4
+
+$frame painb1 painb2 painb3 painb4 painb5
+
+$frame painc1 painc2 painc3 painc4 painc5 painc6 painc7 painc8
+
+$frame paind1 paind2 paind3 paind4 paind5 paind6 paind7 paind8
+$frame paind9 paind10 paind11 paind12 paind13 paind14 paind15 paind16
+$frame paind17 paind18 paind19
+
+
+void() Laser_Touch =
+{
+	local vector org;
+	
+	if (other == self.owner)
+		return;		// don't explode on owner
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	
+	sound (self, CHAN_WEAPON, "enforcer/enfstop.wav", 1, ATTN_STATIC);
+	org = self.origin - 8*normalize(self.velocity);
+
+	if (other.health)
+	{
+		SpawnBlood (org, self.velocity*0.2, 15);
+		T_Damage (other, self, self.owner, 15);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
+		WriteCoord (MSG_BROADCAST, org_x);
+		WriteCoord (MSG_BROADCAST, org_y);
+		WriteCoord (MSG_BROADCAST, org_z);
+	}
+	
+	remove(self);	
+};
+
+void(vector org, vector vec) LaunchLaser =
+{
+	local	vector	vec;
+		
+	if (self.classname == "monster_enforcer")
+		sound (self, CHAN_WEAPON, "enforcer/enfire.wav", 1, ATTN_NORM);
+
+	vec = normalize(vec);
+	
+	newmis = spawn();
+	newmis.owner = self;
+	newmis.movetype = MOVETYPE_FLY;
+	newmis.solid = SOLID_BBOX;
+	newmis.effects = EF_DIMLIGHT;
+
+	setmodel (newmis, "progs/laser.mdl");
+	setsize (newmis, '0 0 0', '0 0 0');		
+
+	setorigin (newmis, org);
+
+	newmis.velocity = vec * 600;
+	newmis.angles = vectoangles(newmis.velocity);
+
+	newmis.nextthink = time + 5;
+	newmis.think = SUB_Remove;
+	newmis.touch = Laser_Touch;
+};
+
+
+
+void() enforcer_fire =
+{
+	local vector org;
+
+	self.effects = self.effects | EF_MUZZLEFLASH;
+	makevectors (self.angles);
+	
+	org = self.origin + v_forward * 30 + v_right * 8.5 + '0 0 16';
+
+	LaunchLaser(org, self.enemy.origin - self.origin);
+};
+
+//============================================================================
+
+void()	enf_stand1	=[	$stand1,	enf_stand2	] {ai_stand();};
+void()	enf_stand2	=[	$stand2,	enf_stand3	] {ai_stand();};
+void()	enf_stand3	=[	$stand3,	enf_stand4	] {ai_stand();};
+void()	enf_stand4	=[	$stand4,	enf_stand5	] {ai_stand();};
+void()	enf_stand5	=[	$stand5,	enf_stand6	] {ai_stand();};
+void()	enf_stand6	=[	$stand6,	enf_stand7	] {ai_stand();};
+void()	enf_stand7	=[	$stand7,	enf_stand1	] {ai_stand();};
+
+void()	enf_walk1	=[	$walk1 ,	enf_walk2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "enforcer/idle1.wav", 1, ATTN_IDLE);
+ai_walk(2);};
+void()	enf_walk2	=[	$walk2 ,	enf_walk3	] {ai_walk(4);};
+void()	enf_walk3	=[	$walk3 ,	enf_walk4	] {ai_walk(4);};
+void()	enf_walk4	=[	$walk4 ,	enf_walk5	] {ai_walk(3);};
+void()	enf_walk5	=[	$walk5 ,	enf_walk6	] {ai_walk(1);};
+void()	enf_walk6	=[	$walk6 ,	enf_walk7	] {ai_walk(2);};
+void()	enf_walk7	=[	$walk7 ,	enf_walk8	] {ai_walk(2);};
+void()	enf_walk8	=[	$walk8 ,	enf_walk9	] {ai_walk(1);};
+void()	enf_walk9	=[	$walk9 ,	enf_walk10	] {ai_walk(2);};
+void()	enf_walk10	=[	$walk10,	enf_walk11	] {ai_walk(4);};
+void()	enf_walk11	=[	$walk11,	enf_walk12	] {ai_walk(4);};
+void()	enf_walk12	=[	$walk12,	enf_walk13	] {ai_walk(1);};
+void()	enf_walk13	=[	$walk13,	enf_walk14	] {ai_walk(2);};
+void()	enf_walk14	=[	$walk14,	enf_walk15	] {ai_walk(3);};
+void()	enf_walk15	=[	$walk15,	enf_walk16	] {ai_walk(4);};
+void()	enf_walk16	=[	$walk16,	enf_walk1	] {ai_walk(2);};
+
+void()	enf_run1	=[	$run1  ,	enf_run2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "enforcer/idle1.wav", 1, ATTN_IDLE);
+ai_run(18);};
+void()	enf_run2	=[	$run2  ,	enf_run3	] {ai_run(14);};
+void()	enf_run3	=[	$run3  ,	enf_run4	] {ai_run(7);};
+void()	enf_run4	=[	$run4  ,	enf_run5	] {ai_run(12);};
+void()	enf_run5	=[	$run5  ,	enf_run6	] {ai_run(14);};
+void()	enf_run6	=[	$run6  ,	enf_run7	] {ai_run(14);};
+void()	enf_run7	=[	$run7  ,	enf_run8	] {ai_run(7);};
+void()	enf_run8	=[	$run8  ,	enf_run1	] {ai_run(11);};
+
+void()	enf_atk1	=[	$attack1,	enf_atk2	] {ai_face();};
+void()	enf_atk2	=[	$attack2,	enf_atk3	] {ai_face();};
+void()	enf_atk3	=[	$attack3,	enf_atk4	] {ai_face();};
+void()	enf_atk4	=[	$attack4,	enf_atk5	] {ai_face();};
+void()	enf_atk5	=[	$attack5,	enf_atk6	] {ai_face();};
+void()	enf_atk6	=[	$attack6,	enf_atk7	] {enforcer_fire();};
+void()	enf_atk7	=[	$attack7,	enf_atk8	] {ai_face();};
+void()	enf_atk8	=[	$attack8,	enf_atk9	] {ai_face();};
+void()	enf_atk9	=[	$attack5,	enf_atk10	] {ai_face();};
+void()	enf_atk10	=[	$attack6,	enf_atk11	] {enforcer_fire();};
+void()	enf_atk11	=[	$attack7,	enf_atk12	] {ai_face();};
+void()	enf_atk12	=[	$attack8,	enf_atk13	] {ai_face();};
+void()	enf_atk13	=[	$attack9,	enf_atk14	] {ai_face();};
+void()	enf_atk14	=[	$attack10,	enf_run1	] {ai_face();
+SUB_CheckRefire (enf_atk1);
+};
+
+void()	enf_paina1	=[	$paina1,	enf_paina2	] {};
+void()	enf_paina2	=[	$paina2,	enf_paina3	] {};
+void()	enf_paina3	=[	$paina3,	enf_paina4	] {};
+void()	enf_paina4	=[	$paina4,	enf_run1	] {};
+
+void()	enf_painb1	=[	$painb1,	enf_painb2	] {};
+void()	enf_painb2	=[	$painb2,	enf_painb3	] {};
+void()	enf_painb3	=[	$painb3,	enf_painb4	] {};
+void()	enf_painb4	=[	$painb4,	enf_painb5	] {};
+void()	enf_painb5	=[	$painb5,	enf_run1	] {};
+
+void()	enf_painc1	=[	$painc1,	enf_painc2	] {};
+void()	enf_painc2	=[	$painc2,	enf_painc3	] {};
+void()	enf_painc3	=[	$painc3,	enf_painc4	] {};
+void()	enf_painc4	=[	$painc4,	enf_painc5	] {};
+void()	enf_painc5	=[	$painc5,	enf_painc6	] {};
+void()	enf_painc6	=[	$painc6,	enf_painc7	] {};
+void()	enf_painc7	=[	$painc7,	enf_painc8	] {};
+void()	enf_painc8	=[	$painc8,	enf_run1	] {};
+
+void()	enf_paind1	=[	$paind1,	enf_paind2	] {};
+void()	enf_paind2	=[	$paind2,	enf_paind3	] {};
+void()	enf_paind3	=[	$paind3,	enf_paind4	] {};
+void()	enf_paind4	=[	$paind4,	enf_paind5	] {ai_painforward(2);};
+void()	enf_paind5	=[	$paind5,	enf_paind6	] {ai_painforward(1);};
+void()	enf_paind6	=[	$paind6,	enf_paind7	] {};
+void()	enf_paind7	=[	$paind7,	enf_paind8	] {};
+void()	enf_paind8	=[	$paind8,	enf_paind9	] {};
+void()	enf_paind9	=[	$paind9,	enf_paind10	] {};
+void()	enf_paind10	=[	$paind10,	enf_paind11	] {};
+void()	enf_paind11	=[	$paind11,	enf_paind12	] {ai_painforward(1);};
+void()	enf_paind12	=[	$paind12,	enf_paind13	] {ai_painforward(1);};
+void()	enf_paind13	=[	$paind13,	enf_paind14	] {ai_painforward(1);};
+void()	enf_paind14	=[	$paind14,	enf_paind15	] {};
+void()	enf_paind15	=[	$paind15,	enf_paind16	] {};
+void()	enf_paind16	=[	$paind16,	enf_paind17	] {ai_pain(1);};
+void()	enf_paind17	=[	$paind17,	enf_paind18	] {ai_pain(1);};
+void()	enf_paind18	=[	$paind18,	enf_paind19	] {};
+void()	enf_paind19	=[	$paind19,	enf_run1	] {};
+
+void(entity attacker, float damage)	enf_pain =
+{
+	local float r;
+
+	r = random ();
+	if (self.pain_finished > time)
+		return;
+
+	
+	if (r < 0.5)
+		sound (self, CHAN_VOICE, "enforcer/pain1.wav", 1, ATTN_NORM);
+	else
+		sound (self, CHAN_VOICE, "enforcer/pain2.wav", 1, ATTN_NORM);
+
+	if (r < 0.2)
+	{
+		self.pain_finished = time + 1;
+		enf_paina1 ();
+	}
+	else if (r < 0.4)
+	{
+		self.pain_finished = time + 1;
+		enf_painb1 ();
+	}
+	else if (r < 0.7)
+	{
+		self.pain_finished = time + 1;
+		enf_painc1 ();
+	}
+	else
+	{
+		self.pain_finished = time + 2;
+		enf_paind1 ();
+	}
+};
+
+//============================================================================
+
+
+
+
+void()	enf_die1	=[	$death1,	enf_die2	] {};
+void()	enf_die2	=[	$death2,	enf_die3	] {};
+void()	enf_die3	=[	$death3,	enf_die4	]
+{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+void()	enf_die4	=[	$death4,	enf_die5	] {ai_forward(14);};
+void()	enf_die5	=[	$death5,	enf_die6	] {ai_forward(2);};
+void()	enf_die6	=[	$death6,	enf_die7	] {};
+void()	enf_die7	=[	$death7,	enf_die8	] {};
+void()	enf_die8	=[	$death8,	enf_die9	] {};
+void()	enf_die9	=[	$death9,	enf_die10	] {ai_forward(3);};
+void()	enf_die10	=[	$death10,	enf_die11	] {ai_forward(5);};
+void()	enf_die11	=[	$death11,	enf_die12	] {ai_forward(5);};
+void()	enf_die12	=[	$death12,	enf_die13	] {ai_forward(5);};
+void()	enf_die13	=[	$death13,	enf_die14	] {};
+void()	enf_die14	=[	$death14,	enf_die14	] {};
+
+void()	enf_fdie1	=[	$fdeath1,	enf_fdie2	] {
+
+};
+void()	enf_fdie2	=[	$fdeath2,	enf_fdie3	] {};
+void()	enf_fdie3	=[	$fdeath3,	enf_fdie4	] 
+{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+void()	enf_fdie4	=[	$fdeath4,	enf_fdie5	] {};
+void()	enf_fdie5	=[	$fdeath5,	enf_fdie6	] {};
+void()	enf_fdie6	=[	$fdeath6,	enf_fdie7	] {};
+void()	enf_fdie7	=[	$fdeath7,	enf_fdie8	] {};
+void()	enf_fdie8	=[	$fdeath8,	enf_fdie9	] {};
+void()	enf_fdie9	=[	$fdeath9,	enf_fdie10	] {};
+void()	enf_fdie10	=[	$fdeath10,	enf_fdie11	] {};
+void()	enf_fdie11	=[	$fdeath11,	enf_fdie11	] {};
+
+
+void() enf_die =
+{
+// check for gib
+	if (self.health < -35)
+	{
+		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		ThrowHead ("progs/h_mega.mdl", self.health);
+		ThrowGib ("progs/gib1.mdl", self.health);
+		ThrowGib ("progs/gib2.mdl", self.health);
+		ThrowGib ("progs/gib3.mdl", self.health);
+		return;
+	}
+
+// regular death
+	sound (self, CHAN_VOICE, "enforcer/death1.wav", 1, ATTN_NORM);
+	if (random() > 0.5)
+		enf_die1 ();
+	else
+		enf_fdie1 ();
+};
+
+
+/*QUAKED monster_enforcer (1 0 0) (-16 -16 -24) (16 16 40) Ambush
+
+*/
+void() monster_enforcer =
+{
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model2 ("progs/enforcer.mdl");
+	precache_model2 ("progs/h_mega.mdl");
+	precache_model2 ("progs/laser.mdl");
+
+	precache_sound2 ("enforcer/death1.wav");
+	precache_sound2 ("enforcer/enfire.wav");
+	precache_sound2 ("enforcer/enfstop.wav");
+	precache_sound2 ("enforcer/idle1.wav");
+	precache_sound2 ("enforcer/pain1.wav");
+	precache_sound2 ("enforcer/pain2.wav");
+	precache_sound2 ("enforcer/sight1.wav");
+	precache_sound2 ("enforcer/sight2.wav");
+	precache_sound2 ("enforcer/sight3.wav");
+	precache_sound2 ("enforcer/sight4.wav");
+	
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+
+	setmodel (self, "progs/enforcer.mdl");
+
+	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = 80;
+
+	self.th_stand = enf_stand1;
+	self.th_walk = enf_walk1;
+	self.th_run = enf_run1;
+	self.th_pain = enf_pain;
+	self.th_die = enf_die;
+	self.th_missile = enf_atk1;
+
+	walkmonster_start();
+};
+
+/*
+
+A monster is in fight mode if it thinks it can effectively attack its
+enemy.
+
+When it decides it can't attack, it goes into hunt mode.
+
+*/
+
+float(float v) anglemod;
+
+void() knight_atk1;
+void() knight_runatk1;
+void() ogre_smash1;
+void() ogre_swing1;
+
+void() sham_smash1;
+void() sham_swingr1;
+void() sham_swingl1;
+
+float()	DemonCheckAttack;
+void(float side)	Demon_Melee;
+
+void(vector dest) ChooseTurn;
+
+void() ai_face;
+
+
+float	enemy_vis, enemy_infront, enemy_range;
+float	enemy_yaw;
+
+
+void() knight_attack =
+{
+	local float		len;
+	
+// decide if now is a good swing time
+	len = vlen(self.enemy.origin+self.enemy.view_ofs - (self.origin+self.view_ofs));
+	
+	if (len<80)
+		knight_atk1 ();
+	else
+		knight_runatk1 ();
+};
+
+//=============================================================================
+
+/*
+===========
+CheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() CheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_ent != targ)
+		return FALSE;		// don't have a clear shot
+			
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (enemy_range == RANGE_MELEE)
+	{	// melee attack
+		if (self.th_melee)
+		{
+			if (self.classname == "monster_knight")
+				knight_attack ();
+			else
+				self.th_melee ();
+			return TRUE;
+		}
+	}
+	
+// missile attack
+	if (!self.th_missile)
+		return FALSE;
+		
+	if (time < self.attack_finished)
+		return FALSE;
+		
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	if (enemy_range == RANGE_MELEE)
+	{
+		chance = 0.9;
+		self.attack_finished = 0;
+	}
+	else if (enemy_range == RANGE_NEAR)
+	{
+		if (self.th_melee)
+			chance = 0.2;
+		else
+			chance = 0.4;
+	}
+	else if (enemy_range == RANGE_MID)
+	{
+		if (self.th_melee)
+			chance = 0.05;
+		else
+			chance = 0.1;
+	}
+	else
+		chance = 0;
+
+	if (random () < chance)
+	{
+		self.th_missile ();
+		SUB_AttackFinished (2*random());
+		return TRUE;
+	}
+
+	return FALSE;
+};
+
+
+/*
+=============
+ai_face
+
+Stay facing the enemy
+=============
+*/
+void() ai_face =
+{
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+	ChangeYaw ();
+};
+
+/*
+=============
+ai_charge
+
+The monster is in a melee attack, so get as close as possible to .enemy
+=============
+*/
+float (entity targ) visible;
+float(entity targ) infront;
+float(entity targ) range;
+
+void(float d) ai_charge =
+{
+	ai_face ();	
+	movetogoal (d);		// done in C code...
+};
+
+void() ai_charge_side =
+{
+	local	vector	dtemp;
+	local	float	heading;
+	
+// aim to the left of the enemy for a flyby
+
+	self.ideal_yaw = vectoyaw(self.enemy.origin - self.origin);
+	ChangeYaw ();
+
+	makevectors (self.angles);
+	dtemp = self.enemy.origin - 30*v_right;
+	heading = vectoyaw(dtemp - self.origin);
+	
+	walkmove(heading, 20);
+};
+
+
+/*
+=============
+ai_melee
+
+=============
+*/
+void() ai_melee =
+{
+	local vector	delta;
+	local float 	ldmg;
+
+	if (!self.enemy)
+		return;		// removed before stroke
+		
+	delta = self.enemy.origin - self.origin;
+
+	if (vlen(delta) > 60)
+		return;
+		
+	ldmg = (random() + random() + random()) * 3;
+	T_Damage (self.enemy, self, self, ldmg);
+};
+
+
+void() ai_melee_side =
+{
+	local vector	delta;
+	local float 	ldmg;
+
+	if (!self.enemy)
+		return;		// removed before stroke
+		
+	ai_charge_side();
+	
+	delta = self.enemy.origin - self.origin;
+
+	if (vlen(delta) > 60)
+		return;
+	if (!CanDamage (self.enemy, self))
+		return;
+	ldmg = (random() + random() + random()) * 3;
+	T_Damage (self.enemy, self, self, ldmg);
+};
+
+
+//=============================================================================
+
+/*
+===========
+SoldierCheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() SoldierCheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_ent != targ)
+		return FALSE;	// don't have a clear shot
+			
+	
+// missile attack
+	if (time < self.attack_finished)
+		return FALSE;
+		
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	if (enemy_range == RANGE_MELEE)
+		chance = 0.9;
+	else if (enemy_range == RANGE_NEAR)
+		chance = 0.4;
+	else if (enemy_range == RANGE_MID)
+		chance = 0.05;
+	else
+		chance = 0;
+
+	if (random () < chance)
+	{
+		self.th_missile ();
+		SUB_AttackFinished (1 + random());
+		if (random() < 0.3)
+			self.lefty = !self.lefty;
+
+		return TRUE;
+	}
+
+	return FALSE;
+};
+//=============================================================================
+
+/*
+===========
+ShamCheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() ShamCheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+	local float		enemy_yaw;
+
+	if (enemy_range == RANGE_MELEE)
+	{
+		if (CanDamage (self.enemy, self))
+		{
+			self.attack_state = AS_MELEE;
+			return TRUE;
+		}
+	}
+
+	if (time < self.attack_finished)
+		return FALSE;
+	
+	if (!enemy_vis)
+		return FALSE;
+		
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	if (vlen(spot1 - spot2) > 600)
+		return FALSE;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_ent != targ)
+	{
+		return FALSE;	// don't have a clear shot
+	}
+			
+// missile attack
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	self.attack_state = AS_MISSILE;
+	SUB_AttackFinished (2 + 2*random());
+	return TRUE;
+};
+
+//============================================================================
+
+/*
+===========
+OgreCheckAttack
+
+The player is in view, so decide to move or launch an attack
+Returns FALSE if movement should continue
+============
+*/
+float() OgreCheckAttack =
+{
+	local vector	spot1, spot2;	
+	local entity	targ;
+	local float		chance;
+
+	if (enemy_range == RANGE_MELEE)
+	{
+		if (CanDamage (self.enemy, self))
+		{
+			self.attack_state = AS_MELEE;
+			return TRUE;
+		}
+	}
+
+	if (time < self.attack_finished)
+		return FALSE;
+	
+	if (!enemy_vis)
+		return FALSE;
+		
+	targ = self.enemy;
+	
+// see if any entities are in the way of the shot
+	spot1 = self.origin + self.view_ofs;
+	spot2 = targ.origin + targ.view_ofs;
+
+	traceline (spot1, spot2, FALSE, self);
+
+	if (trace_inopen && trace_inwater)
+		return FALSE;			// sight line crossed contents
+
+	if (trace_ent != targ)
+	{
+		return FALSE;	// don't have a clear shot
+	}
+			
+// missile attack
+	if (time < self.attack_finished)
+		return FALSE;
+		
+	if (enemy_range == RANGE_FAR)
+		return FALSE;
+		
+	else if (enemy_range == RANGE_NEAR)
+		chance = 0.10;
+	else if (enemy_range == RANGE_MID)
+		chance = 0.05;
+	else
+		chance = 0;
+
+	self.attack_state = AS_MISSILE;
+	SUB_AttackFinished (1 + 2*random());
+	return TRUE;
+};
+
+//Kasuha's DeathMatch Camera patch version 2.0
+
+// KasCam variables
+
+.vector CamPos;       // Current expected camera position
+.entity CamTargEnt;   // Targeted entity
+.vector CamTarget;    // Current expected targeted point
+.vector CamTargAim;   // Aiming point
+.float CamSpeed;     // Force pulling the camera to ideal position
+.float CamCut;       // TRUE if camera has to jump to destination
+.float CamDist;      // Max distance for flyby mode
+.float CamMsgs;      // "take" messages ON/OFF
+.float CamState;     // Camera state
+.float Camnextthink;  // Delay measure
+.float Camforceidle;     // How long to keep looking at dead body
+
+// KasCam constants
+
+float CAM_NOT       = 0;   // Not a camera
+float CAM_PREBECOME = 1;   // Become a camera
+float CAM_BECOME    = 2;   // Become a camera
+float CAM_IDLE      = 3;   // Camera idle, nobody to look at
+float CAM_FLYBY     = 4;   // Fly-by camera
+float CAM_FOLLOW    = 5;   // Camera following a player
+
+// KasCam functions
+
+void() InitCamClient;
+void() CamThink;
+float() DoObserverImpulse;
+void() CheckAdminCmd;
+
+float(float num) sign =
+{
+    if (num>0)
+        return 1;
+    else if (num<0)
+        return -1;
+    else
+        return 0;
+};
+
+float(float adist, float vprev) ang_speed =
+{
+    local float sg;
+
+    while (adist > 128)
+        adist = adist - 256;
+    while (adist < -128)
+        adist = adist + 256;
+    adist = floor(adist);
+    sg = sign (adist);
+    adist = fabs (adist);
+    if (((vprev == 0) && (adist < 5)) || (adist < 2))
+        adist = 0;
+    else if (adist < 15)
+        adist = 1;
+    else
+    {
+        adist = (adist - 9) / 3;
+        adist = floor(adist);
+    }
+    adist = adist * sg;
+    return adist;
+};
+
+// Visibility test
+
+float(vector vec) CamVisible =
+{
+    traceline(self.origin,vec,TRUE,self);
+    return ((trace_fraction == 1) && !((trace_inopen && trace_inwater)));
+};
+
+float(entity ent) CamVisibleEnt =
+{
+    local vector vec;
+
+// Three points: origin, bottom and eyes
+    if (CamVisible(ent.origin))
+        return TRUE;
+    vec = ent.origin;
+    vec_z = ent.absmin_z;
+    if (CamVisible(vec))
+        return TRUE;
+    vec_z = ent.absmax_z - 8;
+    return CamVisible(vec);
+};
+
+float(entity targ, vector vec) TryFlybyVector =
+{
+    local vector orig,vec1;
+    local float vl;
+
+    vec1 = normalize(vec);
+    vec = 700 * vec1;
+    orig = targ.origin;
+    orig_z = targ.absmax_z - 8;
+    traceline(orig,orig+vec,TRUE,self);
+    if (trace_inopen && trace_inwater)
+        return 1111;
+    trace_endpos = trace_endpos - vec1;
+    vl = vlen(targ.origin - trace_endpos);
+    if (vl<50)
+        return 1111;
+    if (pointcontents(trace_endpos) == CONTENT_SOLID)
+        return 1111;
+    return fabs(333 - vl);
+};
+
+// FlyBy mode initialization
+// Targeted player is in CamTargEnt
+
+void(entity newtarg) InitFlybyMode =
+{
+    local float f, max;
+    local vector vec, vec2;
+    local entity ent;
+
+
+// Keep camera at this point some time...
+    self.Camnextthink = time + 0.3;
+
+// Report selected player
+    if (self.CamTargEnt!=newtarg)
+    {
+        if (self.CamMsgs)
+        {
+            bprint("Now tracking ");
+            bprint(newtarg.netname);
+            bprint(" with ");
+            if (newtarg.frags < 0)
+                bprint("[ahem] ");
+            if (newtarg.frags < 1)
+                bprint("no");
+            else
+                bprint(ftos(newtarg.frags));
+            if (newtarg.frags!=1)
+                bprint(" frags\n");
+            else
+                bprint(" frag\n");
+        }
+        self.CamTargEnt = newtarg;
+    }
+    vec = self.CamTargEnt.angles;
+    vec_x = 0;
+    makevectors (vec);
+    v_forward = 3 * v_forward;
+
+    max = 1000;
+    f = TryFlybyVector(self.CamTargEnt, v_forward + v_up + v_right);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    f = TryFlybyVector(self.CamTargEnt, v_forward + v_up - v_right);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    f = TryFlybyVector(self.CamTargEnt, v_forward + v_right);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    f = TryFlybyVector(self.CamTargEnt, v_forward - v_right);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    f = TryFlybyVector(self.CamTargEnt, v_forward + v_up);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    f = TryFlybyVector(self.CamTargEnt, v_up - v_forward);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    f = TryFlybyVector(self.CamTargEnt, v_up + v_right - v_forward);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    f = TryFlybyVector(self.CamTargEnt, v_up - v_right - v_forward);
+    if (f<max)
+    {
+        max = f;
+        vec = trace_endpos;
+    }
+    if (max >= 1000)
+    {
+        self.CamState = CAM_IDLE;
+        self.Camnextthink = time + 2;
+        return;
+    }
+    self.CamTarget = self.CamTargEnt.origin;
+    self.CamPos = vec;
+    self.CamCut = TRUE;
+    self.CamState = CAM_FLYBY;
+    self.CamDist = 1.5 * vlen(self.CamPos - self.CamTarget);
+    if (self.CamDist < 500)
+        self.CamDist = 500;
+};
+
+vector() GetFollowCam =
+{
+    local vector vec, vec2;
+
+    makevectors(self.CamTargEnt.v_angle);
+    vec = self.CamTargEnt.origin + (self.CamTargEnt.maxs_z + 4) * v_up;
+    traceline(self.CamTargEnt.origin,vec,FALSE,self);
+    vec = trace_endpos - normalize(vec);
+    vec2 = -100 * v_forward;
+    traceline(vec,vec+vec2,TRUE,self);
+    vec2 = trace_endpos - normalize(vec2);
+    if (CamVisible(vec2))
+        return vec2;
+    else
+        return vec;
+};
+
+vector() GetFollowTrg =
+{
+    local vector vec;
+
+    makevectors(self.CamTargEnt.v_angle);
+    vec = aim(self.CamTargEnt,100000);
+    vec = self.CamTargEnt.origin + 2048 * vec;
+
+    return vec;
+};
+
+// Impulse handling
+
+void() CamImpulses =
+{
+    local float c;
+    local entity ent;
+
+	if (self.impulse && self.accessparm) { // admin functions
+		CheckAdminCmd();
+		self.impulse = 0;
+	} else if ((self.impulse > 100) && (self.impulse < 200)) {
+		// camera impulses
+
+        c = self.impulse - 100;
+        ent = world;
+        do
+        {
+           ent = find(ent,classname,"player");
+           c = c - 1;
+        } while ((c>0) && (ent != world));
+        if (ent != world)
+        {
+            if (ent.deadflag == DEAD_NO)
+                InitFlybyMode(ent);
+        }
+    } else if ((self.impulse == 200) && (self.CamState != CAM_IDLE))
+        InitFlybyMode(self.CamTargEnt);
+    else if ((self.impulse == 201) && (self.CamState != CAM_IDLE))
+        self.CamState = CAM_FOLLOW;
+    else if (self.impulse == 210)
+        self.CamMsgs = !self.CamMsgs;
+	else if (DoObserverImpulse())
+		return;
+	else if (self.impulse)
+		CheckAdminCmd();
+
+    self.impulse = 0;
+};
+
+// Camera thinking routine
+// Called every frame
+
+void() CamThink =
+{
+    local vector vmove, vec;
+    local float grad;
+    local entity ent,ent2;
+    local float it;
+    local float p1,p2;
+	local string s;
+
+// I know this is terrible but I think that it is better to keep
+// hooking points at the smallest possible count...
+// I also think that the variable change increases the packet
+// size so I test everything rather than only updating
+
+    if (self.CamTargEnt.classname == "player")
+    {
+// Mask out items which change view color
+        it = IT_INVISIBILITY | IT_INVULNERABILITY | IT_SUIT | IT_QUAD;
+        it = (self.CamTargEnt.items | it) - it;
+        if (self.items != it)
+            self.items = it;
+        if (self.health != self.CamTargEnt.health)
+// do not let the camera die or the view will rotate
+            if (self.CamTargEnt.health>0)
+                self.health = self.CamTargEnt.health;
+            else if (self.health != 1)
+                self.health = 1;
+        if (self.armorvalue != self.CamTargEnt.armorvalue)
+            self.armorvalue = self.CamTargEnt.armorvalue;
+        if (self.ammo_shells != self.CamTargEnt.ammo_shells)
+            self.ammo_shells = self.CamTargEnt.ammo_shells;
+        if (self.ammo_nails != self.CamTargEnt.ammo_nails)
+            self.ammo_nails = self.CamTargEnt.ammo_nails;
+        if (self.ammo_rockets != self.CamTargEnt.ammo_rockets)
+            self.ammo_rockets = self.CamTargEnt.ammo_rockets;
+        if (self.ammo_cells != self.CamTargEnt.ammo_cells)
+            self.ammo_cells = self.CamTargEnt.ammo_cells;
+        if (self.weapon != self.CamTargEnt.weapon)
+            self.weapon = self.CamTargEnt.weapon;
+        if (self.currentammo != self.CamTargEnt.currentammo)
+            self.currentammo = self.CamTargEnt.currentammo;
+    }
+    else
+    {
+        if (self.items != 0)
+            self.items = 0;
+        if (self.health != 100)
+            self.health = 100;
+        if (self.armorvalue != 0)
+            self.armorvalue = 0;
+        if (self.ammo_shells != 0)
+            self.ammo_shells = 0;
+        if (self.ammo_nails != 0)
+            self.ammo_nails = 0;
+        if (self.ammo_rockets != 0)
+            self.ammo_rockets = 0;
+        if (self.ammo_cells != 0)
+            self.ammo_cells = 0;
+        if (self.weapon != IT_AXE)
+            self.weapon = IT_AXE;
+        if (self.currentammo != 0)
+            self.currentammo = 0;
+    }
+
+    if (self.CamState == CAM_IDLE)
+    {
+// Look for some players
+// If nobody present, do idle movement
+        ent = find (world, classname, "player");
+        ent2 = self;
+// find the most promising player
+        if (self.Camforceidle < time)
+        {
+            while (ent != world)
+            {
+// Dead or dying are not interesting at this point
+                if (ent.deadflag == DEAD_NO)
+                {
+                    if (ent2 == self)
+                        ent2 = ent;
+                    else if ((ent2.frags < ent.frags) || ((ent2.frags == ent.frags) && (ent2.health < ent.health)))
+                        ent2 = ent;
+                }
+                ent = find (ent,classname,"player");
+            }
+        }
+// If a interesting object found
+        if (ent2 != self)
+        {
+// Go to FlyBy mode
+            InitFlybyMode (ent2);
+        }
+        else
+        {
+// Idle moves
+            self.CamTargEnt =  self;
+            self.CamSpeed = 0.01;
+            traceline(self.CamPos,self.CamTarget,TRUE,self);
+            if (trace_fraction != 1)
+                self.CamTarget = trace_endpos;
+            if (self.Camnextthink < time)
+            {
+                self.Camnextthink = time + 0.5;
+                vec_x = random () - 0.5;
+                vec_y = random () - 0.5;
+                vec_z = (random () - 0.5) / 10;
+                vec = 2000 * normalize(vec);
+                vec = self.CamPos + vec;
+                traceline(self.CamPos, vec, TRUE, self);
+                if (trace_fraction != 1)
+                    vec = trace_endpos;
+
+                p1 = vlen(vec - self.CamPos);
+                p2 = vlen(self.CamTarget - self.CamPos);
+                if (p1 > p2)
+                {
+                    self.CamTarget = vec;
+                }
+                else
+                {
+                    if (random() > 0.9)
+                    {
+                        self.CamPos = self.CamPos + 0.9 * (self.CamTarget -
+							self.CamPos);
+                    }
+                }
+            }
+        }
+    }
+    else if (self.CamState == CAM_FLYBY)
+    {
+// self.CamTarget is set to player
+// Check if the player is not dead
+        if (self.CamTargEnt.deadflag == DEAD_RESPAWNABLE)
+        {
+// player is dead
+// make camera idle so that it finds another good target
+            self.CamState = CAM_IDLE;
+            self.Camnextthink = time + 3;
+            self.Camforceidle = time + 1;
+            return;
+        }
+// All other restrictions apply after some time
+// Test player visibility
+// If player not visible place another camera
+        p1 = vlen(self.CamPos - self.CamTargEnt.origin);
+        if ((CamVisibleEnt(self.CamTargEnt) && (self.CamDist > p1)) ||
+			(self.Camnextthink > time))
+            self.CamTarget = self.CamTargEnt.origin;
+        else
+            InitFlybyMode (self.CamTargEnt);
+// Check for FOLLOW mode change
+// Player has to be near
+// And looking away
+// And the destination point must be visible
+        p1 = vlen(self.CamTargEnt.origin - self.origin);
+        if (p1 < 200)
+        {
+// Player is near enough
+// Now if it points away
+            grad = fabs(self.CamTargEnt.angles_y - self.angles_y);
+            if (grad > 180)
+                grad = 360 - grad;
+            if (grad < 30)
+            {
+// Calculate following point
+                vec = GetFollowCam();
+                if (CamVisible(vec))
+                {
+                    self.CamState = CAM_FOLLOW;
+                }
+            }
+        }
+    }
+    else if (self.CamState == CAM_FOLLOW)
+    {
+        self.CamSpeed = 0.35;
+// Check player death
+        if (self.CamTargEnt.deadflag == DEAD_RESPAWNABLE)
+        {
+// player is dead
+// make camera idle so that it finds another good target
+            self.CamState = CAM_IDLE;
+            self.Camnextthink = time + 3;
+            self.Camforceidle = time + 1;
+        }
+        else
+        {
+            if (CamVisibleEnt(self.CamTargEnt))
+            {
+                self.CamPos = GetFollowCam();
+                self.CamTarget = GetFollowTrg();
+                if (pointcontents(self.CamPos) == CONTENT_SOLID)
+                    InitFlybyMode(self.CamTargEnt);
+            }
+            else
+            {
+                InitFlybyMode(self.CamTargEnt);
+            }
+        }
+    }
+//  else if (self.CamState == ...
+
+// Check destination visibility
+    traceline(self.origin,self.CamPos,TRUE,self);
+    if (trace_fraction != 1)
+        self.CamCut = TRUE;
+// Rotate the camera towards the target
+// and move it towards the ideal position
+    if (self.CamCut) {
+//dprint("self.origin=");
+//dprint(vtos(self.origin));
+//dprint(" set to=");
+//dprint(vtos(self.CamPos));
+//dprint("\n");
+        setorigin(self,self.CamPos);
+//dprint("  now=");
+//dprint(vtos(self.origin));
+//dprint("\n");
+	} else {
+        vmove = self.CamPos - self.origin;
+        vmove = self.CamSpeed * vmove;
+        vmove = self.origin + vmove;
+//dprint("self.origin=");
+//dprint(vtos(self.origin));
+//dprint(" set to=");
+//dprint(vtos(self.CamPos));
+//dprint("\n");
+        setorigin(self, vmove);
+//dprint("  now=");
+//dprint(vtos(self.origin));
+//dprint("\n");
+    }
+
+    if (self.CamCut)
+        self.CamTargAim = self.CamTarget;
+    else
+        if (self.CamState == CAM_IDLE)
+            self.CamTargAim = 0.02 * (self.CamTarget - self.CamTargAim) +
+				self.CamTargAim;
+        else
+            self.CamTargAim = 0.2 * (self.CamTarget - self.CamTargAim) + self.CamTargAim;
+
+// Maybe now the following is too much complicated but I don't care
+
+    vmove = vectoangles(self.CamTargAim - self.origin);
+    vmove_x = 360 - vmove_x;
+    if (vmove_x > 180)
+        vmove_x = vmove_x - 360;
+    if (vmove_x > 70)
+        vmove_x = 70;
+    else if (vmove_x < -70)
+        vmove_x = -70;
+    self.CamCut = FALSE;
+    self.fixangle = TRUE;
+    self.angles_y = vmove_y;
+    self.angles_x = vmove_x;
+    self.angles_z = 0;
+    self.v_angle = self.angles;
+};
+
+void() CamPreThink =
+{
+// Impulse handling (standard is not active)
+    CamImpulses();
+};
+
+void() CamPlayerDisconnect =
+{
+	local entity p;
+
+	p = find(world, classname, "CameraClient");
+	while (p != world) {
+		if (p.CamTargEnt == self) {
+			p.CamState = CAM_IDLE;
+			p.Camnextthink = time + 2;
+		}
+		p = find(p, classname, "CameraClient");
+	}
+};
+
+void() InitCamClient =
+{
+    local entity spot;
+
+    self.classname = "CameraClient";
+//    setmodel (self, string_null);
+	if (cvar("teamplay") & TEAM_CAPTURE_CUSTOM)
+		setmodel (self, "progs/bit.mdl");
+	else
+		setmodel (self, "progs/v_spike.mdl");
+    self.weaponmodel = string_null;
+    setsize (self, '0 0 0', '0 0 0');
+    self.velocity = '0 0 0';
+    self.view_ofs = '0 0 0';
+	self.movetype = MOVETYPE_FLY;
+	self.solid = SOLID_NOT;
+    self.takedamage = DAMAGE_NO;
+    self.fixangle = TRUE;
+    self.nextthink = -1;
+    self.colormap = 0;
+    self.CamPos = self.origin;
+    makevectors(self.angles);
+    self.CamTarget = self.CamPos + 100 * v_forward;
+    self.CamTargAim = self.CamTarget;
+    self.CamTargEnt = self;
+    self.CamState = CAM_IDLE;
+    self.CamCut = FALSE;
+    self.CamMsgs = TRUE;
+    self.Camnextthink = time;
+    self.Camforceidle = time;
+};
+
+
+.float laststattime;		// time of last status update
+.float motd_count;
+.float statoff;				// is the status bar on?
+
+float teamscr1;			// team 1's teamscr score
+float teamscr2;			// team 2's teamscr score
+float lastteamscrtime;		// last time we calculated it
+
+float TEAMSCRTIME = 1;
+float PLAYERSTATTIME = 1.75;
+
+void() MOTD =
+{
+	if (self.motd_count < 4) {
+		self.motd_count = self.motd_count + 1;
+		if (gamestart) {
+			centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nChoose an exit...\n"); //red
+			return;
+		}
+		if (self.team == TEAM_COLOR1)
+			centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nYou are  team\n"); //red
+		else
+			centerprint(self, "Welcome!\nRunning Threewave CTF 4.0\n\n  !\n\nYou are  team"); //blue
+		return;
+	}
+	self.motd_count = 0;
+};
+
+void() MOTD_ChooseTeam =
+{
+	if (self.motd_count < 6) {
+		self.motd_count = self.motd_count + 1;
+		centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nPress 1 for  team\nPress 2 for  team\nOr Press Jump for automatic team\n");
+		return;
+	}
+	self.motd_count = 0;
+};
+
+void() TeamCaptureCheckUpdate =
+{
+	local entity p;
+
+	if (gamestart)
+		return; // handled by vote exit
+	if (lastteamscrtime > time)
+		return;
+
+	lastteamscrtime = time + TEAMSCRTIME;
+
+	// count up teamscr
+	teamscr1 = teamscr2 = 0;
+	p = find(world, classname, "player");
+	while (p != world) {
+		if (p.lastteam == TEAM_COLOR1)
+			teamscr1 = teamscr1 + p.frags;
+		else if (p.lastteam == TEAM_COLOR2)
+			teamscr2 = teamscr2 + p.frags;
+		p = find(p, classname, "player");
+	}
+};
+
+void() TeamCaptureResetUpdate =
+{
+	lastteamscrtime = 0;
+	TeamCaptureCheckUpdate();
+};
+
+void() TeamEndScore = 
+{
+	local string s;
+
+	if (gamestart)
+		return;
+
+	lastteamscrtime = 0;
+	TeamCaptureCheckUpdate();
+
+	if (teamscr1 > teamscr2) {
+		bprint(" team won the level with ");
+		s = ftos(teamscr1);
+		bprint(s);
+		bprint(" points!\n");
+		bprint(" team lost with ");
+		s = ftos(teamscr2);
+		bprint(s);
+		bprint(" points.\n");
+	} else if (teamscr1 < teamscr2) {
+		bprint(" team won the level with ");
+		s = ftos(teamscr2);
+		bprint(s);
+		bprint(" points!\n");
+		bprint(" team lost with ");
+		s = ftos(teamscr1);
+		bprint(s);
+		bprint(" points.\n");
+	} else {
+		bprint(" and  team tied level with ");
+		s = ftos(teamscr1);
+		bprint(s);
+		bprint(" points!\n");
+	}
+};
+
+string(entity who) RuneName =
+{
+	if (who.player_flag & ITEM_RUNE1_FLAG)
+		return "\nEarth/Resistance   ";
+	if (who.player_flag & ITEM_RUNE2_FLAG)
+		return "\nBlack/Strength     ";
+	if (who.player_flag & ITEM_RUNE3_FLAG)
+		return "\nHell/Haste         ";
+	if (who.player_flag & ITEM_RUNE4_FLAG)
+		return "\nElder/Regeneration ";
+	return     "\n                   ";
+};
+
+void() TeamCapturePlayerUpdate =
+{
+	local string n;
+	local string t;
+
+	if (self.laststattime > time)
+		return;
+
+	TeamCaptureCheckUpdate();
+
+	self.laststattime = time + PLAYERSTATTIME;
+
+	if (self.motd_count) {
+		if (self.observer)
+			MOTD_ChooseTeam();
+		else
+			MOTD();
+		return;
+	}
+
+	if (self.statoff)
+		return;
+
+	if (gamestart) {
+		if (vote_leader == world)
+			centerprint(self, "\n\n\n\n\n\n\n\n\n\n\n\n                    Choose an exit...");
+		else {
+			n = ftos(voteexit_time - time);
+			centerprint5(self, "\n\n\n\n\n\n\n\n\n\n\n", vote_leader.message,
+				" leads\n", n, " seconds until exit");
+		}
+		return;
+	}
+
+	t = RuneName(self);
+	if (teamscr1 == 0 && teamscr2 == 0) {
+		centerprint3(self, "\n\n\n\n\n\n\n\n\n\n\n", t, "  Capture The Flag");
+		return;
+	}
+
+	if (teamscr1 > teamscr2) {
+		n = ftos(teamscr1 - teamscr2);
+		centerprint4(self, "\n\n\n\n\n\n\n\n\n\n\n", t, "           RED ", n);
+	} else if (teamscr1 < teamscr2) {
+		n = ftos(teamscr2 - teamscr1);
+		centerprint4(self, "\n\n\n\n\n\n\n\n\n\n\n", t, "          BLUE ", n);
+	} else {
+		centerprint3(self, "\n\n\n\n\n\n\n\n\n\n\n", t, "          TIED");
+		return;
+	}
+};
+
+void(entity who, string s) TeamPlayerUpdate =
+{
+	local string n;
+	local string t;
+
+	TeamCaptureCheckUpdate();
+	who.laststattime = time + PLAYERSTATTIME;
+
+	if (self.statoff) {
+		centerprint2(who, "\n\n\n\n\n\n\n\n\n\n\n", s);
+		return;
+	}
+
+	t = RuneName(who);
+	if (teamscr1 == 0 && teamscr2 == 0) {
+		centerprint4(who, "\n\n\n\n\n\n\n\n\n\n\n", s, t, "  Capture The Flag");
+	} else if (teamscr1 > teamscr2) {
+		n = ftos(teamscr1 - teamscr2);
+		centerprint5(who, "\n\n\n\n\n\n\n\n\n\n\n", s, t, "           RED ", n);
+	} else if (teamscr1 < teamscr2) {
+		n = ftos(teamscr2 - teamscr1);
+		centerprint5(who, "\n\n\n\n\n\n\n\n\n\n\n", s, t, "          BLUE ", n);
+	} else
+		centerprint4(who, "\n\n\n\n\n\n\n\n\n\n\n", s, t, "          TIED");
+};
+
+void(entity who, string s1, string s2) TeamPlayerUpdate2 =
+{
+	local string n;
+	local string t;
+
+	TeamCaptureCheckUpdate();
+	who.laststattime = time + PLAYERSTATTIME;
+
+	if (self.statoff) {
+		centerprint3(who, "\n\n\n\n\n\n\n\n\n\n\n", s1, s2);
+		return;
+	}
+
+	t = RuneName(who);
+	if (teamscr1 == 0 && teamscr2 == 0) {
+		centerprint5(who, "\n\n\n\n\n\n\n\n\n\n\n", s1, s2, t, " Capture The Flag");
+		return;
+	} else if (teamscr1 > teamscr2) {
+		n = ftos(teamscr1 - teamscr2);
+		centerprint6(who, "\n\n\n\n\n\n\n\n\n\n\n", s1, s2, t, "          RED ", n);
+	} else if (teamscr1 < teamscr2) {
+		n = ftos(teamscr2 - teamscr1);
+		centerprint6(who, "\n\n\n\n\n\n\n\n\n\n\n", s1, s2, t, "          BLUE ", n);
+	} else {
+		centerprint5(who, "\n\n\n\n\n\n\n\n\n\n\n", s1, s2, t, "          TIED");
+		return;
+	}
+};
+
+void() W_SetCurrentAmmo;
+/* ALL LIGHTS SHOULD BE 0 1 0 IN COLOR ALL OTHER ITEMS SHOULD
+BE .8 .3 .4 IN COLOR */
+
+
+void() SUB_regen =
+{
+	self.model = self.mdl;		// restore original model
+	self.solid = SOLID_TRIGGER;	// allow it to be touched again
+	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
+	setorigin (self, self.origin);
+};
+
+
+
+/*QUAKED noclass (0 0 0) (-8 -8 -8) (8 8 8)
+prints a warning message when spawned
+*/
+void() noclass =
+{
+	dprint ("noclass spawned at");
+	dprint (vtos(self.origin));
+	dprint ("\n");
+	remove (self);
+};
+
+
+
+/*
+============
+PlaceItem
+
+plants the object on the floor
+============
+*/
+void() PlaceItem =
+{
+	local float	oldz;
+
+	self.mdl = self.model;		// so it can be restored on respawn
+	self.flags = FL_ITEM;		// make extra wide
+	self.solid = SOLID_TRIGGER;
+	self.movetype = MOVETYPE_TOSS;	
+	self.velocity = '0 0 0';
+	self.origin_z = self.origin_z + 6;
+	oldz = self.origin_z;
+	if (!droptofloor())
+	{
+		dprint ("Bonus item fell out of level at ");
+		dprint (vtos(self.origin));
+		dprint ("\n");
+		remove(self);
+		return;
+	}
+};
+
+/*
+============
+StartItem
+
+Sets the clipping size and plants the object on the floor
+============
+*/
+void() StartItem =
+{
+	self.nextthink = time + 0.2;	// items start after other solids
+	self.think = PlaceItem;
+};
+
+/*
+=========================================================================
+
+HEALTH BOX
+
+=========================================================================
+*/
+//
+// T_Heal: add health to an entity, limiting health to max_health
+// "ignore" will ignore max_health limit
+//
+float (entity e, float healamount, float ignore) T_Heal =
+{
+	if (e.health <= 0)
+		return 0;
+	if ((!ignore) && (e.health >= other.max_health))
+		return 0;
+	healamount = ceil(healamount);
+
+	e.health = e.health + healamount;
+	if ((!ignore) && (e.health >= other.max_health))
+		e.health = other.max_health;
+		
+	if (e.health > 250)
+		e.health = 250;
+	return 1;
+};
+
+/*QUAKED item_health (.3 .3 1) (0 0 0) (32 32 32) rotten megahealth
+Health box. Normally gives 25 points.
+Rotten box heals 5-10 points,
+megahealth will add 100 health, then 
+rot you down to your maximum health limit, 
+one point per second.
+*/
+
+float	H_ROTTEN = 1;
+float	H_MEGA = 2;
+.float	healamount, healtype;
+void() health_touch;
+void() item_megahealth_rot;
+
+void() item_health =
+{	
+	self.touch = health_touch;
+
+	if (self.spawnflags & H_ROTTEN)
+	{
+		precache_model("maps/b_bh10.bsp");
+
+		precache_sound("items/r_item1.wav");
+		setmodel(self, "maps/b_bh10.bsp");
+		self.noise = "items/r_item1.wav";
+		self.healamount = 15;
+		self.healtype = 0;
+	}
+	else
+	if (self.spawnflags & H_MEGA)
+	{
+		precache_model("maps/b_bh100.bsp");
+		precache_sound("items/r_item2.wav");
+		setmodel(self, "maps/b_bh100.bsp");
+		self.noise = "items/r_item2.wav";
+		self.healamount = 100;
+		self.healtype = 2;
+	}
+	else
+	{
+		precache_model("maps/b_bh25.bsp");
+		precache_sound("items/health1.wav");
+		setmodel(self, "maps/b_bh25.bsp");
+		self.noise = "items/health1.wav";
+		self.healamount = 25;
+		self.healtype = 1;
+	}
+	setsize (self, '0 0 0', '32 32 56');
+	StartItem ();
+};
+
+
+void() health_touch =
+{
+	local	float amount;
+	local	string	s;
+	
+	if (other.classname != "player")
+		return;
+	
+	if (self.healtype == 2) // Megahealth?  Ignore max_health...
+	{
+		if (other.health >= 250)
+			return;
+		if (!T_Heal(other, self.healamount, 1))
+			return;
+	}
+	else
+	{
+		if (!T_Heal(other, self.healamount, 0))
+			return;
+	}
+	
+// ZOID--remove uncessary msgs
+	if (!deathmatch) {
+		sprint(other, "You receive ");
+		s = ftos(self.healamount);
+		sprint(other, s);
+		sprint(other, " health\n");
+	}
+	
+// health touch sound
+	sound(other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
+
+	stuffcmd (other, "bf\n");
+	
+	self.model = string_null;
+	self.solid = SOLID_NOT;
+
+	// Megahealth = rot down the player's super health
+	if (self.healtype == 2)
+	{
+		other.items = other.items | IT_SUPERHEALTH;
+		self.nextthink = time + 5;
+		self.think = item_megahealth_rot;
+		self.owner = other;
+	}
+	else
+	{
+		if (deathmatch != 2)		// deathmatch 2 is the silly old rules
+		{
+			if (deathmatch)
+				self.nextthink = time + 20;
+			self.think = SUB_regen;
+		}
+	}
+	
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};	
+
+void() item_megahealth_rot =
+{
+	other = self.owner;
+	
+//ZOID: player doesn't rot if they have Elder Magic rune
+	if (other.health > other.max_health && 
+		!(other.player_flag & ITEM_RUNE4_FLAG)) {
+		other.health = other.health - 1;
+		self.nextthink = time + 1;
+		return;
+	}
+
+// it is possible for a player to die and respawn between rots, so don't
+// just blindly subtract the flag off
+	other.items = other.items - (other.items & IT_SUPERHEALTH);
+	
+	if (deathmatch == 1 || deathmatch == 3)	// deathmatch 2 is silly old rules
+	{
+		self.nextthink = time + 20;
+		self.think = SUB_regen;
+	}
+};
+
+/*
+===============================================================================
+
+ARMOR
+
+===============================================================================
+*/
+
+void() armor_touch;
+
+void() armor_touch =
+{
+	local	float	type, value, bit;
+	
+	if (other.health <= 0)
+		return;
+	if (other.classname != "player")
+		return;
+
+	if (self.classname == "item_armor1")
+	{
+		type = 0.3;
+		value = 100;
+		bit = IT_ARMOR1;
+	}
+	if (self.classname == "item_armor2")
+	{
+		type = 0.6;
+		value = 150;
+		bit = IT_ARMOR2;
+	}
+	if (self.classname == "item_armorInv")
+	{
+		type = 0.8;
+		value = 200;
+		bit = IT_ARMOR3;
+	}
+	if (other.armortype*other.armorvalue >= type*value)
+		return;
+		
+	other.armortype = type;
+	other.armorvalue = value;
+	other.items = other.items - (other.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + bit;
+
+	self.solid = SOLID_NOT;
+	self.model = string_null;
+	if (deathmatch == 1 || deathmatch == 3)
+		self.nextthink = time + 20;
+	self.think = SUB_regen;
+
+//ZOID--remove unneccessary msgs
+	if (!deathmatch)
+		sprint(other, "You got armor\n");
+// armor touch sound
+	sound(other, CHAN_ITEM, "items/armor1.wav", 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+	
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};
+
+
+/*QUAKED item_armor1 (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() item_armor1 =
+{
+	self.touch = armor_touch;
+	precache_model ("progs/armor.mdl");
+	setmodel (self, "progs/armor.mdl");
+	self.skin = 0;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+/*QUAKED item_armor2 (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() item_armor2 =
+{
+	self.touch = armor_touch;
+	precache_model ("progs/armor.mdl");
+	setmodel (self, "progs/armor.mdl");
+	self.skin = 1;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+/*QUAKED item_armorInv (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() item_armorInv =
+{
+	self.touch = armor_touch;
+	precache_model ("progs/armor.mdl");
+	setmodel (self, "progs/armor.mdl");
+	self.skin = 2;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+/*
+===============================================================================
+
+WEAPONS
+
+===============================================================================
+*/
+
+void() bound_other_ammo =
+{
+	if (other.ammo_shells > 100)
+		other.ammo_shells = 100;
+	if (other.ammo_nails > 200)
+		other.ammo_nails = 200;
+	if (other.ammo_rockets > 100)
+		other.ammo_rockets = 100;		
+	if (other.ammo_cells > 100)
+		other.ammo_cells = 100;		
+};
+
+
+float(float w) RankForWeapon =
+{
+	if (w == IT_LIGHTNING)
+		return 1;
+	if (w == IT_ROCKET_LAUNCHER)
+		return 2;
+	if (w == IT_SUPER_NAILGUN)
+		return 3;
+	if (w == IT_GRENADE_LAUNCHER)
+		return 4;
+	if (w == IT_SUPER_SHOTGUN)
+		return 5;
+	if (w == IT_NAILGUN)
+		return 6;
+	return 7;
+};
+
+/*
+=============
+Deathmatch_Weapon
+
+Deathmatch weapon change rules for picking up a weapon
+
+.float		ammo_shells, ammo_nails, ammo_rockets, ammo_cells;
+=============
+*/
+void(float old, float new) Deathmatch_Weapon =
+{
+	local float or, nr;
+
+// change self.weapon if desired
+	if (self.weapon == IT_HOOK && self.button0)
+		return; // never change if we pulled ourselves to it.
+	or = RankForWeapon (self.weapon);
+	nr = RankForWeapon (new);
+	if ( nr < or )
+		self.weapon = new;
+};
+
+/*
+=============
+weapon_touch
+=============
+*/
+float() W_BestWeapon;
+
+void() weapon_touch =
+{
+	local	float	hadammo, best, new, old;
+	local	entity	stemp;
+	local	float	leave;
+//McBain: added prevweapon local variable
+	local	float	prevweapon;
+
+	if (!(other.flags & FL_CLIENT))
+		return;
+
+// if the player was using his best weapon, change up to the new one if better		
+	stemp = self;
+	self = other;
+	best = W_BestWeapon();
+	self = stemp;
+
+	if (deathmatch == 2 || deathmatch == 3 || coop)
+		leave = 1;
+	else
+		leave = 0;
+	
+	if (self.classname == "weapon_nailgun")
+	{
+		if (leave && (other.items & IT_NAILGUN) )
+			return;
+		hadammo = other.ammo_nails;			
+		new = IT_NAILGUN;
+// *TEAMPLAY*
+		if ( !( coop && (teamplay & TEAM_DROP_ITEMS) ) )
+			other.ammo_nails = other.ammo_nails + 30;
+	}
+	else if (self.classname == "weapon_supernailgun")
+	{
+		if (leave && (other.items & IT_SUPER_NAILGUN) )
+			return;
+		hadammo = other.ammo_rockets;			
+		new = IT_SUPER_NAILGUN;
+// *TEAMPLAY*
+		if ( !( coop && (teamplay & TEAM_DROP_ITEMS) ) ) {
+			other.ammo_nails = other.ammo_nails + 30;
+		}
+	}
+	else if (self.classname == "weapon_supershotgun")
+	{
+		if (leave && (other.items & IT_SUPER_SHOTGUN) )
+			return;
+		hadammo = other.ammo_rockets;			
+		new = IT_SUPER_SHOTGUN;
+// *TEAMPLAY*
+		if ( !( coop && (teamplay & TEAM_DROP_ITEMS) ) )
+			other.ammo_shells = other.ammo_shells + 5;
+	}
+	else if (self.classname == "weapon_rocketlauncher")
+	{
+		if (leave && (other.items & IT_ROCKET_LAUNCHER) )
+			return;
+		hadammo = other.ammo_rockets;			
+		new = IT_ROCKET_LAUNCHER;
+// *TEAMPLAY*
+		if ( !( coop && (teamplay & TEAM_DROP_ITEMS) ) )
+			other.ammo_rockets = other.ammo_rockets + 5;
+	}
+	else if (self.classname == "weapon_grenadelauncher")
+	{
+		if (leave && (other.items & IT_GRENADE_LAUNCHER) )
+			return;
+		hadammo = other.ammo_rockets;			
+		new = IT_GRENADE_LAUNCHER;
+// *TEAMPLAY*
+		if ( !( coop && (teamplay & TEAM_DROP_ITEMS) ) )
+			other.ammo_rockets = other.ammo_rockets + 5;
+	}
+	else if (self.classname == "weapon_lightning")
+	{
+		if (leave && (other.items & IT_LIGHTNING) )
+			return;
+		hadammo = other.ammo_rockets;			
+		new = IT_LIGHTNING;
+// *TEAMPLAY*
+		if ( !( coop && (teamplay & TEAM_DROP_ITEMS) ) )
+			other.ammo_cells = other.ammo_cells + 15;
+	}
+	else
+		objerror ("weapon_touch: unknown classname");
+
+//ZOID--remove unnessary msgs
+	if (!deathmatch) {
+		sprint (other, "You got the ");
+		sprint (other, self.netname);
+		sprint (other, "\n");
+	}
+
+// weapon touch sound
+	sound (other, CHAN_ITEM, "weapons/pkup.wav", 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+
+	bound_other_ammo ();
+
+// change to the weapon
+	old = other.items;
+	other.items = other.items | new;
+	
+	stemp = self;
+	self = other;
+
+//McBain: temp store old weapon
+	prevweapon = self.weapon; 
+
+	if (!deathmatch)
+		self.weapon = new;
+	else
+		Deathmatch_Weapon (old, new);
+
+//McBain: save previous weapon if different
+	if (self.weapon != prevweapon)
+		self.previous_weapon = prevweapon;
+
+	W_SetCurrentAmmo();
+
+	self = stemp;
+
+	if (leave)
+		return;
+
+// remove it in single player, or setup for respawning in deathmatch
+	self.model = string_null;
+	self.solid = SOLID_NOT;
+	if (deathmatch == 1 || deathmatch == 3)
+		self.nextthink = time + 30;
+	self.think = SUB_regen;
+	
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};
+
+
+/*QUAKED weapon_supershotgun (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() weapon_supershotgun =
+{
+	precache_model ("progs/g_shot.mdl");
+	setmodel (self, "progs/g_shot.mdl");
+	self.weapon = IT_SUPER_SHOTGUN;
+	self.netname = "Double-barrelled Shotgun";
+	self.touch = weapon_touch;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+/*QUAKED weapon_nailgun (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() weapon_nailgun =
+{
+	precache_model ("progs/g_nail.mdl");
+	setmodel (self, "progs/g_nail.mdl");
+	self.weapon = IT_NAILGUN;
+	self.netname = "nailgun";
+	self.touch = weapon_touch;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+/*QUAKED weapon_supernailgun (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() weapon_supernailgun =
+{
+	precache_model ("progs/g_nail2.mdl");
+	setmodel (self, "progs/g_nail2.mdl");
+	self.weapon = IT_SUPER_NAILGUN;
+	self.netname = "Super Nailgun";
+	self.touch = weapon_touch;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+/*QUAKED weapon_grenadelauncher (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() weapon_grenadelauncher =
+{
+	precache_model ("progs/g_rock.mdl");
+	setmodel (self, "progs/g_rock.mdl");
+	self.weapon = 3;
+	self.netname = "Grenade Launcher";
+	self.touch = weapon_touch;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+/*QUAKED weapon_rocketlauncher (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() weapon_rocketlauncher =
+{
+	precache_model ("progs/g_rock2.mdl");
+	setmodel (self, "progs/g_rock2.mdl");
+	self.weapon = 3;
+	self.netname = "Rocket Launcher";
+	self.touch = weapon_touch;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+
+/*QUAKED weapon_lightning (0 .5 .8) (-16 -16 0) (16 16 32)
+*/
+
+void() weapon_lightning =
+{
+	precache_model ("progs/g_light.mdl");
+	setmodel (self, "progs/g_light.mdl");
+	self.weapon = 3;
+	self.netname = "Thunderbolt";
+	self.touch = weapon_touch;
+	setsize (self, '-16 -16 0', '16 16 56');
+	StartItem ();
+};
+
+
+/*
+===============================================================================
+
+AMMO
+
+===============================================================================
+*/
+
+void() ammo_touch =
+{
+local entity	stemp;
+local float		best;
+
+	if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+
+// if the player was using his best weapon, change up to the new one if better		
+	stemp = self;
+	self = other;
+	best = W_BestWeapon();
+	self = stemp;
+
+
+// shotgun
+	if (self.weapon == 1)
+	{
+		if (other.ammo_shells >= 100)
+			return;
+		other.ammo_shells = other.ammo_shells + self.aflag;
+	}
+
+// spikes
+	if (self.weapon == 2)
+	{
+		if (other.ammo_nails >= 200)
+			return;
+		other.ammo_nails = other.ammo_nails + self.aflag;
+	}
+
+//	rockets
+	if (self.weapon == 3)
+	{
+		if (other.ammo_rockets >= 100)
+			return;
+		other.ammo_rockets = other.ammo_rockets + self.aflag;
+	}
+
+//	cells
+	if (self.weapon == 4)
+	{
+		if (other.ammo_cells >= 100)
+			return;
+		other.ammo_cells = other.ammo_cells + self.aflag;
+	}
+
+	bound_other_ammo ();
+	
+//ZOID--remove unnessary msgs
+	if (!deathmatch) {
+		sprint (other, "You got the ");
+		sprint (other, self.netname);
+		sprint (other, "\n");
+	}
+// ammo touch sound
+	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+
+// change to a better weapon if appropriate
+
+	if ( other.weapon == best )
+	{
+		stemp = self;
+		self = other;
+		self.weapon = W_BestWeapon();
+		W_SetCurrentAmmo ();
+		self = stemp;
+	}
+
+// if changed current ammo, update it
+	stemp = self;
+	self = other;
+	W_SetCurrentAmmo();
+	self = stemp;
+
+// remove it in single player, or setup for respawning in deathmatch
+	self.model = string_null;
+	self.solid = SOLID_NOT;
+	if (deathmatch == 1 || deathmatch == 3)
+		self.nextthink = time + 30;
+	self.think = SUB_regen;
+
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};
+
+
+
+
+float WEAPON_BIG2 = 1;
+
+/*QUAKED item_shells (0 .5 .8) (0 0 0) (32 32 32) big
+*/
+
+void() item_shells =
+{
+	self.touch = ammo_touch;
+
+	if (self.spawnflags & WEAPON_BIG2)
+	{
+		precache_model ("maps/b_shell1.bsp");
+		setmodel (self, "maps/b_shell1.bsp");
+		self.aflag = 40;
+	}
+	else
+	{
+		precache_model ("maps/b_shell0.bsp");
+		setmodel (self, "maps/b_shell0.bsp");
+		self.aflag = 20;
+	}
+	self.weapon = 1;
+	self.netname = "shells";
+	setsize (self, '0 0 0', '32 32 56');
+	StartItem ();
+};
+
+/*QUAKED item_spikes (0 .5 .8) (0 0 0) (32 32 32) big
+*/
+
+void() item_spikes =
+{
+	self.touch = ammo_touch;
+
+	if (self.spawnflags & WEAPON_BIG2)
+	{
+		precache_model ("maps/b_nail1.bsp");
+		setmodel (self, "maps/b_nail1.bsp");
+		self.aflag = 50;
+	}
+	else
+	{
+		precache_model ("maps/b_nail0.bsp");
+		setmodel (self, "maps/b_nail0.bsp");
+		self.aflag = 25;
+	}
+	self.weapon = 2;
+	self.netname = "nails";
+	setsize (self, '0 0 0', '32 32 56');
+	StartItem ();
+};
+
+/*QUAKED item_rockets (0 .5 .8) (0 0 0) (32 32 32) big
+*/
+
+void() item_rockets =
+{
+	self.touch = ammo_touch;
+
+	if (self.spawnflags & WEAPON_BIG2)
+	{
+		precache_model ("maps/b_rock1.bsp");
+		setmodel (self, "maps/b_rock1.bsp");
+		self.aflag = 10;
+	}
+	else
+	{
+		precache_model ("maps/b_rock0.bsp");
+		setmodel (self, "maps/b_rock0.bsp");
+		self.aflag = 5;
+	}
+	self.weapon = 3;
+	self.netname = "rockets";
+	setsize (self, '0 0 0', '32 32 56');
+	StartItem ();
+};
+
+
+/*QUAKED item_cells (0 .5 .8) (0 0 0) (32 32 32) big
+*/
+
+void() item_cells =
+{
+	self.touch = ammo_touch;
+
+	if (self.spawnflags & WEAPON_BIG2)
+	{
+		precache_model ("maps/b_batt1.bsp");
+		setmodel (self, "maps/b_batt1.bsp");
+		self.aflag = 12;
+	}
+	else
+	{
+		precache_model ("maps/b_batt0.bsp");
+		setmodel (self, "maps/b_batt0.bsp");
+		self.aflag = 6;
+	}
+	self.weapon = 4;
+	self.netname = "cells";
+	setsize (self, '0 0 0', '32 32 56');
+	StartItem ();
+};
+
+
+/*QUAKED item_weapon (0 .5 .8) (0 0 0) (32 32 32) shotgun rocket spikes big
+DO NOT USE THIS!!!! IT WILL BE REMOVED!
+*/
+
+float WEAPON_SHOTGUN = 1;
+float WEAPON_ROCKET = 2;
+float WEAPON_SPIKES = 4;
+float WEAPON_BIG = 8;
+void() item_weapon =
+{
+	self.touch = ammo_touch;
+
+	if (self.spawnflags & WEAPON_SHOTGUN)
+	{
+		if (self.spawnflags & WEAPON_BIG)
+		{
+			precache_model ("maps/b_shell1.bsp");
+			setmodel (self, "maps/b_shell1.bsp");
+			self.aflag = 40;
+		}
+		else
+		{
+			precache_model ("maps/b_shell0.bsp");
+			setmodel (self, "maps/b_shell0.bsp");
+			self.aflag = 20;
+		}
+		self.weapon = 1;
+		self.netname = "shells";
+	}
+
+	if (self.spawnflags & WEAPON_SPIKES)
+	{
+		if (self.spawnflags & WEAPON_BIG)
+		{
+			precache_model ("maps/b_nail1.bsp");
+			setmodel (self, "maps/b_nail1.bsp");
+			self.aflag = 40;
+		}
+		else
+		{
+			precache_model ("maps/b_nail0.bsp");
+			setmodel (self, "maps/b_nail0.bsp");
+			self.aflag = 20;
+		}
+		self.weapon = 2;
+		self.netname = "spikes";
+	}
+
+	if (self.spawnflags & WEAPON_ROCKET)
+	{
+		if (self.spawnflags & WEAPON_BIG)
+		{
+			precache_model ("maps/b_rock1.bsp");
+			setmodel (self, "maps/b_rock1.bsp");
+			self.aflag = 10;
+		}
+		else
+		{
+			precache_model ("maps/b_rock0.bsp");
+			setmodel (self, "maps/b_rock0.bsp");
+			self.aflag = 5;
+		}
+		self.weapon = 3;
+		self.netname = "rockets";
+	}
+	
+	setsize (self, '0 0 0', '32 32 56');
+	StartItem ();
+};
+
+
+/*
+===============================================================================
+
+KEYS
+
+===============================================================================
+*/
+
+void() key_touch =
+{
+local entity	stemp;
+local float		best;
+
+	if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+	if (other.items & self.items)
+		return;
+
+	sprint (other, "You got the ");
+	sprint (other, self.netname);
+	sprint (other,"\n");
+
+	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+	other.items = other.items | self.items;
+
+	if (!coop)
+	{	
+		self.solid = SOLID_NOT;
+		self.model = string_null;
+	}
+
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};
+
+
+void() key_setsounds =
+{
+	if (world.worldtype == 0)
+	{
+		precache_sound ("misc/medkey.wav");
+		self.noise = "misc/medkey.wav";
+	}
+	if (world.worldtype == 1)
+	{
+		precache_sound ("misc/runekey.wav");
+		self.noise = "misc/runekey.wav";
+	}
+	if (world.worldtype == 2)
+	{
+		precache_sound2 ("misc/basekey.wav");
+		self.noise = "misc/basekey.wav";
+	}
+};
+
+/*QUAKED item_key1 (0 .5 .8) (-16 -16 -24) (16 16 32)
+SILVER key
+In order for keys to work
+you MUST set your maps
+worldtype to one of the
+following:
+0: medieval
+1: metal
+2: base
+*/
+
+void() item_key1 =
+{
+	if (world.worldtype == 0)
+	{
+		precache_model ("progs/w_s_key.mdl");
+		setmodel (self, "progs/w_s_key.mdl");
+		self.netname = "silver key";
+	}
+	else if (world.worldtype == 1)
+	{
+		precache_model ("progs/m_s_key.mdl");
+		setmodel (self, "progs/m_s_key.mdl");
+		self.netname = "silver runekey";
+	}
+	else if (world.worldtype == 2)
+	{
+		precache_model2 ("progs/b_s_key.mdl");
+		setmodel (self, "progs/b_s_key.mdl");
+		self.netname = "silver keycard";
+	}
+	key_setsounds();
+	self.touch = key_touch;
+	self.items = IT_KEY1;
+	setsize (self, '-16 -16 -24', '16 16 32');
+	StartItem ();
+};
+
+/*QUAKED item_key2 (0 .5 .8) (-16 -16 -24) (16 16 32)
+GOLD key
+In order for keys to work
+you MUST set your maps
+worldtype to one of the
+following:
+0: medieval
+1: metal
+2: base
+*/
+
+void() item_key2 =
+{
+	if (world.worldtype == 0)
+	{
+		precache_model ("progs/w_g_key.mdl");
+		setmodel (self, "progs/w_g_key.mdl");
+		self.netname = "gold key";
+	}
+	if (world.worldtype == 1)
+	{
+		precache_model ("progs/m_g_key.mdl");
+		setmodel (self, "progs/m_g_key.mdl");
+		self.netname = "gold runekey";
+	}
+	if (world.worldtype == 2)
+	{
+		precache_model2 ("progs/b_g_key.mdl");
+		setmodel (self, "progs/b_g_key.mdl");
+		self.netname = "gold keycard";
+	}
+	key_setsounds();
+	self.touch = key_touch;
+	self.items = IT_KEY2;
+	setsize (self, '-16 -16 -24', '16 16 32');
+	StartItem ();
+};
+
+
+
+/*
+===============================================================================
+
+END OF LEVEL RUNES
+
+===============================================================================
+*/
+
+void() sigil_touch =
+{
+local entity	stemp;
+local float		best;
+
+	if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+
+	centerprint (other, "You got the rune!");
+
+	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+	self.solid = SOLID_NOT;
+	self.model = string_null;
+	serverflags = serverflags | (self.spawnflags & 15);
+	self.classname = "";		// so rune doors won't find it
+	
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};
+
+
+/*QUAKED item_sigil (0 .5 .8) (-16 -16 -24) (16 16 32) E1 E2 E3 E4
+End of level sigil, pick up to end episode and return to jrstart.
+*/
+
+void() item_sigil =
+{
+	if (!self.spawnflags)
+		objerror ("no spawnflags");
+
+	precache_sound ("misc/runekey.wav");
+	self.noise = "misc/runekey.wav";
+
+	if (self.spawnflags & 1)
+	{
+		precache_model ("progs/end1.mdl");
+		setmodel (self, "progs/end1.mdl");
+	}
+	if (self.spawnflags & 2)
+	{
+		precache_model2 ("progs/end2.mdl");
+		setmodel (self, "progs/end2.mdl");
+	}
+	if (self.spawnflags & 4)
+	{
+		precache_model2 ("progs/end3.mdl");
+		setmodel (self, "progs/end3.mdl");
+	}
+	if (self.spawnflags & 8)
+	{
+		precache_model2 ("progs/end4.mdl");
+		setmodel (self, "progs/end4.mdl");
+	}
+	
+	self.touch = sigil_touch;
+	setsize (self, '-16 -16 -24', '16 16 32');
+	StartItem ();
+};
+
+/*
+===============================================================================
+
+POWERUPS
+
+===============================================================================
+*/
+
+void() powerup_touch;
+
+
+void() powerup_touch =
+{
+local entity	stemp;
+local float		best;
+
+	if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+
+	sprint (other, "You got the ");
+	sprint (other, self.netname);
+	sprint (other,"\n");
+
+	if (deathmatch)
+	{
+		self.mdl = self.model;
+		
+		if ((self.classname == "item_artifact_invulnerability") ||
+			(self.classname == "item_artifact_invisibility"))
+			self.nextthink = time + 60*5;
+		else
+			self.nextthink = time + 60;
+		
+		self.think = SUB_regen;
+	}	
+
+	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+	self.solid = SOLID_NOT;
+	other.items = other.items | self.items;
+	self.model = string_null;
+
+// do the apropriate action
+	if (self.classname == "item_artifact_envirosuit")
+	{
+		other.rad_time = 1;
+		other.radsuit_finished = time + 30;
+	}
+	
+	if (self.classname == "item_artifact_invulnerability")
+	{
+		other.invincible_time = 1;
+		other.invincible_finished = time + 30;
+	}
+	
+	if (self.classname == "item_artifact_invisibility")
+	{
+		other.invisible_time = 1;
+		other.invisible_finished = time + 30;
+	}
+
+	if (self.classname == "item_artifact_super_damage")
+	{
+		other.super_time = 1;
+		other.super_damage_finished = time + 30;
+	}	
+
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};
+
+
+
+/*QUAKED item_artifact_invulnerability (0 .5 .8) (-16 -16 -24) (16 16 32)
+Player is invulnerable for 30 seconds
+*/
+void() item_artifact_invulnerability =
+{
+	self.touch = powerup_touch;
+
+	precache_model ("progs/invulner.mdl");
+	precache_sound ("items/protect.wav");
+	precache_sound ("items/protect2.wav");
+	precache_sound ("items/protect3.wav");
+	self.noise = "items/protect.wav";
+	setmodel (self, "progs/invulner.mdl");
+	self.netname = "Pentagram of Protection";
+	self.items = IT_INVULNERABILITY;
+	setsize (self, '-16 -16 -24', '16 16 32');
+	StartItem ();
+};
+
+/*QUAKED item_artifact_envirosuit (0 .5 .8) (-16 -16 -24) (16 16 32)
+Player takes no damage from water or slime for 30 seconds
+*/
+void() item_artifact_envirosuit =
+{
+	self.touch = powerup_touch;
+
+	precache_model ("progs/suit.mdl");
+	precache_sound ("items/suit.wav");
+	precache_sound ("items/suit2.wav");
+	self.noise = "items/suit.wav";
+	setmodel (self, "progs/suit.mdl");
+	self.netname = "Biosuit";
+	self.items = IT_SUIT;
+	setsize (self, '-16 -16 -24', '16 16 32');
+	StartItem ();
+};
+
+
+/*QUAKED item_artifact_invisibility (0 .5 .8) (-16 -16 -24) (16 16 32)
+Player is invisible for 30 seconds
+*/
+void() item_artifact_invisibility =
+{
+	self.touch = powerup_touch;
+
+	precache_model ("progs/invisibl.mdl");
+	precache_sound ("items/inv1.wav");
+	precache_sound ("items/inv2.wav");
+	precache_sound ("items/inv3.wav");
+	self.noise = "items/inv1.wav";
+	setmodel (self, "progs/invisibl.mdl");
+	self.netname = "Ring of Shadows";
+	self.items = IT_INVISIBILITY;
+	setsize (self, '-16 -16 -24', '16 16 32');
+	StartItem ();
+};
+
+
+/*QUAKED item_artifact_super_damage (0 .5 .8) (-16 -16 -24) (16 16 32)
+The next attack from the player will do 4x damage
+*/
+void() item_artifact_super_damage =
+{
+	self.touch = powerup_touch;
+
+	precache_model ("progs/quaddama.mdl");
+	precache_sound ("items/damage.wav");
+	precache_sound ("items/damage2.wav");
+	precache_sound ("items/damage3.wav");
+	self.noise = "items/damage.wav";
+	setmodel (self, "progs/quaddama.mdl");
+	self.netname = "Quad Damage";
+	self.items = IT_QUAD;
+	setsize (self, '-16 -16 -24', '16 16 32');
+	StartItem ();
+};
+
+
+
+/*
+===============================================================================
+
+PLAYER BACKPACKS
+
+===============================================================================
+*/
+
+void() BackpackTouch =
+{
+	local string	s;
+	local	float	best, old, new;
+	local		entity	stemp;
+	local	float	acount;
+	
+	if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+	//don't let self pick it up for a sec
+	if ((other == self.owner) && ( (self.nextthink - time) > 118 ) )
+		return;
+
+	acount = 0;
+	sprint (other, "You get ");
+
+	if (self.items)
+		if ((other.items & self.items) == 0)
+		{
+			acount = 1;
+			sprint (other, "the ");
+			sprint (other, self.netname);
+		}
+
+// if the player was using his best weapon, change up to the new one if better		
+	stemp = self;
+	self = other;
+	best = W_BestWeapon();
+	self = stemp;
+
+// change weapons
+	other.ammo_shells = other.ammo_shells + self.ammo_shells;
+	other.ammo_nails = other.ammo_nails + self.ammo_nails;
+	other.ammo_rockets = other.ammo_rockets + self.ammo_rockets;
+	other.ammo_cells = other.ammo_cells + self.ammo_cells;
+
+	new = self.items;
+	if (!new)
+		new = other.weapon;
+	old = other.items;
+	other.items = other.items | new;
+	
+	bound_other_ammo ();
+
+	if (self.ammo_shells)
+	{
+		if (acount)
+			sprint(other, ", ");
+		acount = 1;
+		s = ftos(self.ammo_shells);
+		sprint (other, s);
+		sprint (other, " shells");
+	}
+	if (self.ammo_nails)
+	{
+		if (acount)
+			sprint(other, ", ");
+		acount = 1;
+		s = ftos(self.ammo_nails);
+		sprint (other, s);
+		sprint (other, " nails");
+	}
+	if (self.ammo_rockets)
+	{
+		if (acount)
+			sprint(other, ", ");
+		acount = 1;
+		s = ftos(self.ammo_rockets);
+		sprint (other, s);
+		sprint (other, " rockets");
+	}
+	if (self.ammo_cells)
+	{
+		if (acount)
+			sprint(other, ", ");
+		acount = 1;
+		s = ftos(self.ammo_cells);
+		sprint (other, s);
+		sprint (other, " cells");
+	}
+	
+	sprint (other, "\n");
+// backpack touch sound
+	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+
+// remove the backpack, change self to the player
+	remove(self);
+	self = other;
+
+// change to the weapon
+	if (!deathmatch)
+		self.weapon = new;
+	else
+		Deathmatch_Weapon (old, new);
+
+	W_SetCurrentAmmo ();
+};
+
+/*
+===============
+DropBackpack
+===============
+*/
+void() DropBackpack =
+{
+	local entity	item;
+
+	if (!(self.ammo_shells + self.ammo_nails + self.ammo_rockets + self.ammo_cells))
+		return;	// nothing in it
+
+	item = spawn();
+	item.origin = self.origin - '0 0 24';
+
+	item.items = 0; // none by default
+
+//ZOID--axe and hook don't go into backpack
+	if (self.weapon != IT_HOOK || self.weapon != IT_AXE)
+		item.items = self.weapon;
+
+	if (item.items == IT_SHOTGUN)
+		item.netname = "Shotgun";
+	else if (item.items == IT_SUPER_SHOTGUN)
+		item.netname = "Double-barrelled Shotgun";
+	else if (item.items == IT_NAILGUN)
+		item.netname = "Nailgun";
+	else if (item.items == IT_SUPER_NAILGUN)
+		item.netname = "Super Nailgun";
+	else if (item.items == IT_GRENADE_LAUNCHER)
+		item.netname = "Grenade Launcher";
+	else if (item.items == IT_ROCKET_LAUNCHER)
+		item.netname = "Rocket Launcher";
+	else if (item.items == IT_LIGHTNING)
+		item.netname = "Thunderbolt";
+	else
+		item.netname = "";
+
+	item.ammo_shells = self.ammo_shells;
+	item.ammo_nails = self.ammo_nails;
+	item.ammo_rockets = self.ammo_rockets;
+	item.ammo_cells = self.ammo_cells;
+
+	item.velocity_z = 300;
+	item.velocity_x = -100 + (random() * 200);
+	item.velocity_y = -100 + (random() * 200);
+	
+	item.flags = FL_ITEM;
+	item.solid = SOLID_TRIGGER;
+	item.movetype = MOVETYPE_TOSS;
+	setmodel (item, "progs/backpack.mdl");
+	setsize (item, '-16 -16 0', '16 16 56');
+	item.touch = BackpackTouch;
+	
+	item.nextthink = time + 120;	// remove after 2 minutes
+	item.think = SUB_Remove;
+};
+
+/*----------------------------------------------------------------------
+  The Rune Game modes
+
+  Rune 1 - Earth Magic
+	  resistance
+  Rune 2 - Black Magic
+	  strength
+  Rune 3 - Hell Magic
+	  haste
+  Rune 4 - Elder Magic
+	  regeneration
+
+ ----------------------------------------------------------------------*/
+
+entity() SelectRuneSpawnPoint =
+{
+	runespawn = find(runespawn, classname, "info_player_deathmatch");
+	if (runespawn == world)
+		runespawn = find (runespawn, classname, "info_player_deathmatch");
+	if (runespawn == world)
+		error("no info_player_deathmatch to spawn rune");
+	return runespawn;
+};
+
+void() RuneTouch =
+{
+	local string	s;
+	local	float	best;
+	local		entity	stemp;
+	
+	if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+	if (other.player_flag & ITEM_RUNE_MASK) {
+		if (other.rune_notice_time < time) {
+			TeamPlayerUpdate(other, "You already have a rune.");
+			other.rune_notice_time = time + 5;
+		}
+		return; // one per customer
+	}
+		
+	other.player_flag = other.player_flag | self.player_flag;
+
+	// notification of rune, no nofity in team mode
+	if (self.player_flag & ITEM_RUNE1_FLAG) {
+		if (teamplay == 0) {
+			bprint(other.netname);
+			bprint(" got the rune of  !\n");
+		}
+		TeamPlayerUpdate(other, " !    ");
+	}
+	if (self.player_flag & ITEM_RUNE2_FLAG) {
+		if (teamplay == 0) {
+			bprint(other.netname);
+			bprint(" got the rune of  !\n");
+		}
+		TeamPlayerUpdate(other, " !    ");
+	}
+	if (self.player_flag & ITEM_RUNE3_FLAG) {
+		if (teamplay == 0) {
+			bprint(other.netname);
+			bprint(" got the rune of  !\n");
+		}
+		TeamPlayerUpdate(other, " !    ");
+	}
+	if (self.player_flag & ITEM_RUNE4_FLAG) {
+		if (teamplay == 0) {
+			bprint(other.netname);
+			bprint(" got the rune of  !\n");
+		}
+		TeamPlayerUpdate(other, " !    ");
+	}
+	
+	// backpack touch sound
+	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+
+	remove(self);
+};
+
+void (float flag) Do_DropRune;
+void (float flag) Do_TossRune;
+
+void() RuneRespawn =
+{
+	local entity oself;
+
+	oself = self;
+
+	// choose random starting points
+	self = SelectRuneSpawnPoint();
+	Do_DropRune(oself.player_flag);
+
+	remove(oself);
+};
+
+void (float flag) Do_DropRune = 
+{
+	local entity	item;
+
+	item = spawn();
+	item.origin = self.origin - '0 0 24';
+	
+	item.player_flag = flag;
+
+	item.velocity_z = 400;
+	item.velocity_x = -500 + (random() * 1000);
+	item.velocity_y = -500 + (random() * 1000);
+	
+	item.flags = FL_ITEM;
+	item.solid = SOLID_TRIGGER;
+	item.movetype = MOVETYPE_TOSS;
+	if (flag & ITEM_RUNE1_FLAG)
+		setmodel (item, "progs/end1.mdl");
+	else if (flag & ITEM_RUNE2_FLAG)
+		setmodel (item, "progs/end2.mdl");
+	else if (flag & ITEM_RUNE3_FLAG)
+		setmodel (item, "progs/end3.mdl");
+	else if (flag & ITEM_RUNE4_FLAG)
+		setmodel (item, "progs/end4.mdl");
+	setsize (item, '-16 -16 0', '16 16 56');
+	item.touch = RuneTouch;
+	
+	item.nextthink = time + 120; /* if no one touches it in two minutes,
+		respawn it somewhere else, so inaccessible ones will come 'back' */
+	item.think = RuneRespawn;
+};
+
+/*
+===============
+Droprune
+self is player
+===============
+*/
+void() DropRune =
+{
+        if (self.player_flag & ITEM_RUNE1_FLAG)
+		Do_DropRune(ITEM_RUNE1_FLAG);
+	if (self.player_flag & ITEM_RUNE2_FLAG)
+		Do_DropRune(ITEM_RUNE2_FLAG);
+	if (self.player_flag & ITEM_RUNE3_FLAG)
+		Do_DropRune(ITEM_RUNE3_FLAG);
+	if (self.player_flag & ITEM_RUNE4_FLAG)
+		Do_DropRune(ITEM_RUNE4_FLAG);
+	self.player_flag = self.player_flag - (self.player_flag & ITEM_RUNE_MASK);
+};
+
+/* -=CT=-KALWeb : Begin of TossRune code ... */
+void (float flag) Do_TossRune =
+{
+	local entity	item;
+
+	item = spawn();
+//        item.origin = self.origin - '0 0 24';
+	
+	item.player_flag = flag;
+
+//        item.velocity_z = 400;
+//        item.velocity_x = -500 + (random() * 1000);
+//        item.velocity_y = -500 + (random() * 1000);
+	
+	item.flags = FL_ITEM;
+//        item.solid = SOLID_TRIGGER;
+        item.movetype = MOVETYPE_TOSS;
+
+/*
+        if (flag & ITEM_RUNE1_FLAG)
+                setmodel (item, "progs/end1.mdl");
+	else if (flag & ITEM_RUNE2_FLAG)
+		setmodel (item, "progs/end2.mdl");
+	else if (flag & ITEM_RUNE3_FLAG)
+		setmodel (item, "progs/end3.mdl");
+	else if (flag & ITEM_RUNE4_FLAG)
+		setmodel (item, "progs/end4.mdl");
+	setsize (item, '-16 -16 0', '16 16 56');
+*/
+
+//      item.touch = RuneTouch;
+	
+        item.nextthink = time + 1;
+	item.think = RuneRespawn;
+};
+
+/*
+===============
+TossRune
+self is player
+===============
+*/
+void() TossRune =
+{
+        if ((self.player_flag & ITEM_RUNE1_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE1_FLAG);
+        if ((self.player_flag & ITEM_RUNE2_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE2_FLAG);
+        if ((self.player_flag & ITEM_RUNE3_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE3_FLAG);
+        if ((self.player_flag & ITEM_RUNE4_FLAG) && self.impulse == 26)
+                Do_TossRune(ITEM_RUNE4_FLAG);
+	self.player_flag = self.player_flag - (self.player_flag & ITEM_RUNE_MASK);
+};
+/* End -=CT=-KALWeb */
+
+/*
+================
+SpawnRunes
+spawn all the runes
+self is the entity that was created for us, we remove it
+================
+*/
+void() SpawnRunes =
+{
+	local entity oself;
+	local float i;
+
+	oself = self;
+
+	// choose random starting points
+	i = random() * 10;
+	while (i > 0) {
+		self = SelectRuneSpawnPoint();
+		i = i - 1;
+	}
+
+	self = SelectRuneSpawnPoint();
+	Do_DropRune(ITEM_RUNE1_FLAG);
+	self = SelectRuneSpawnPoint();
+	Do_DropRune(ITEM_RUNE2_FLAG);
+	self = SelectRuneSpawnPoint();
+	Do_DropRune(ITEM_RUNE3_FLAG);
+	self = SelectRuneSpawnPoint();
+	Do_DropRune(ITEM_RUNE4_FLAG);
+
+	remove(oself);
+};
+
+void() StartRuneSpawn =
+{
+	local entity rspawn;
+
+	if (runespawned || gamestart)
+		return;
+
+	runespawned = 1;
+
+	precache_model ("progs/end1.mdl");
+	precache_model ("progs/end2.mdl");
+	precache_model ("progs/end3.mdl");
+	precache_model ("progs/end4.mdl");
+
+	if (cvar("teamplay") & TEAM_CAPTURE_CUSTOM) {
+		precache_sound("rune/rune1.wav");
+		precache_sound("rune/rune2.wav");
+		precache_sound("rune/rune22.wav"); // special rune and quad combo
+		precache_sound("rune/rune3.wav");
+		precache_sound("rune/rune4.wav");
+	} else {
+		precache_sound("boss1/sight1.wav");
+		precache_sound("items/r_item1.wav");
+		precache_sound("items/damage3.wav");
+		precache_sound("items/protect3.wav");
+	}
+
+	// spawn the runes
+	rspawn = spawn();
+	rspawn.nextthink = time + 0.1;
+	rspawn.think = SpawnRunes;
+};
+
+
+void() jctrig =
+{
+dprint ("here\n\n");
+	lightstyle(0, "az");
+};
+
+/*QUAKED trigger_jctest (.5 .5 .5) ?
+*/
+void() trigger_jctest =
+{
+	setsize (self, self.mins, self.maxs);
+	self.solid = SOLID_EDGE;
+	self.touch = jctrig;
+};
+
+/*QUAKED info_null (0 0.5 0) (-4 -4 -4) (4 4 4)
+Used as a positional target for spotlights, etc.
+*/
+void() info_null =
+{
+	remove(self);
+};
+
+/*QUAKED info_notnull (0 0.5 0) (-4 -4 -4) (4 4 4)
+Used as a positional target for lightning.
+*/
+void() info_notnull =
+{
+};
+
+//============================================================================
+
+float START_OFF = 1;
+
+void() light_use =
+{
+	if (self.spawnflags & START_OFF)
+	{
+		lightstyle(self.style, "m");
+		self.spawnflags = self.spawnflags - START_OFF;
+	}
+	else
+	{
+		lightstyle(self.style, "a");
+		self.spawnflags = self.spawnflags + START_OFF;
+	}
+};
+
+/*QUAKED light (0 1 0) (-8 -8 -8) (8 8 8) START_OFF
+Non-displayed light.
+Default light value is 300
+Default style is 0
+If targeted, it will toggle between on or off.
+*/
+void() light =
+{
+	if (!self.targetname)
+	{	// inert light
+		remove(self);
+		return;
+	}
+	
+	if (self.style >= 32)
+	{
+		self.use = light_use;
+		if (self.spawnflags & START_OFF)
+			lightstyle(self.style, "a");
+		else
+			lightstyle(self.style, "m");
+	}
+};
+
+/*QUAKED light_fluoro (0 1 0) (-8 -8 -8) (8 8 8) START_OFF
+Non-displayed light.
+Default light value is 300
+Default style is 0
+If targeted, it will toggle between on or off.
+Makes steady fluorescent humming sound
+*/
+void() light_fluoro =
+{
+	if (self.style >= 32)
+	{
+		self.use = light_use;
+		if (self.spawnflags & START_OFF)
+			lightstyle(self.style, "a");
+		else
+			lightstyle(self.style, "m");
+	}
+	
+	precache_sound ("ambience/fl_hum1.wav");
+	ambientsound (self.origin, "ambience/fl_hum1.wav", 0.5, ATTN_STATIC);
+};
+
+/*QUAKED light_fluorospark (0 1 0) (-8 -8 -8) (8 8 8)
+Non-displayed light.
+Default light value is 300
+Default style is 10
+Makes sparking, broken fluorescent sound
+*/
+void() light_fluorospark =
+{
+	if (!self.style)
+		self.style = 10;
+
+	precache_sound ("ambience/buzz1.wav");
+	ambientsound (self.origin, "ambience/buzz1.wav", 0.5, ATTN_STATIC);
+};
+
+/*QUAKED light_globe (0 1 0) (-8 -8 -8) (8 8 8)
+Sphere globe light.
+Default light value is 300
+Default style is 0
+*/
+void() light_globe =
+{
+	precache_model ("progs/s_light.spr");
+	setmodel (self, "progs/s_light.spr");
+	makestatic (self);
+};
+
+void() FireAmbient =
+{
+	precache_sound ("ambience/fire1.wav");
+// attenuate fast
+	ambientsound (self.origin, "ambience/fire1.wav", 0.5, ATTN_STATIC);
+};
+
+/*QUAKED light_torch_small_walltorch (0 .5 0) (-10 -10 -20) (10 10 20)
+Short wall torch
+Default light value is 200
+Default style is 0
+*/
+void() light_torch_small_walltorch =
+{
+	precache_model ("progs/flame.mdl");
+	setmodel (self, "progs/flame.mdl");
+	FireAmbient ();
+	makestatic (self);
+};
+
+/*QUAKED light_flame_large_yellow (0 1 0) (-10 -10 -12) (12 12 18)
+Large yellow flame ball
+*/
+void() light_flame_large_yellow =
+{
+	precache_model ("progs/flame2.mdl");
+	setmodel (self, "progs/flame2.mdl");
+	self.frame = 1;
+	FireAmbient ();
+	makestatic (self);
+};
+
+/*QUAKED light_flame_small_yellow (0 1 0) (-8 -8 -8) (8 8 8) START_OFF
+Small yellow flame ball
+*/
+void() light_flame_small_yellow =
+{
+	precache_model ("progs/flame2.mdl");
+	setmodel (self, "progs/flame2.mdl");
+	FireAmbient ();
+	makestatic (self);
+};
+
+/*QUAKED light_flame_small_white (0 1 0) (-10 -10 -40) (10 10 40) START_OFF
+Small white flame ball
+*/
+void() light_flame_small_white =
+{
+	precache_model ("progs/flame2.mdl");
+	setmodel (self, "progs/flame2.mdl");
+	FireAmbient ();
+	makestatic (self);
+};
+
+//============================================================================
+
+
+/*QUAKED misc_fireball (0 .5 .8) (-8 -8 -8) (8 8 8)
+Lava Balls
+*/
+
+void() fire_fly;
+void() fire_touch;
+void() misc_fireball =
+{
+	
+	precache_model ("progs/lavaball.mdl");
+	self.classname = "fireball";
+	self.nextthink = time + (random() * 5);
+	self.think = fire_fly;
+	if (!self.speed)
+		self.speed == 1000;
+};
+
+void() fire_fly =
+{
+local entity	fireball;
+
+	fireball = spawn();
+	fireball.solid = SOLID_TRIGGER;
+	fireball.movetype = MOVETYPE_TOSS;
+	fireball.velocity = '0 0 1000';
+	fireball.velocity_x = (random() * 100) - 50;
+	fireball.velocity_y = (random() * 100) - 50;
+	fireball.velocity_z = self.speed + (random() * 200);
+	fireball.classname = "fireball";
+	setmodel (fireball, "progs/lavaball.mdl");
+	setsize (fireball, '0 0 0', '0 0 0');
+	setorigin (fireball, self.origin);
+	fireball.nextthink = time + 5;
+	fireball.think = SUB_Remove;
+	fireball.touch = fire_touch;
+	
+	self.nextthink = time + (random() * 5) + 3;
+	self.think = fire_fly;
+};
+
+
+void() fire_touch =
+{
+	T_Damage (other, self, self, 20);
+	remove(self);
+};
+
+//============================================================================
+
+
+void() barrel_explode =
+{
+	self.takedamage = DAMAGE_NO;
+	self.classname = "explo_box";
+	// did say self.owner
+	T_RadiusDamage (self, self, 160, world);
+	sound (self, CHAN_VOICE, "weapons/r_exp3.wav", 1, ATTN_NORM);
+	particle (self.origin, '0 0 0', 75, 255);
+
+	self.origin_z = self.origin_z + 32;
+	BecomeExplosion ();
+};
+
+
+
+/*QUAKED misc_explobox (0 .5 .8) (0 0 0) (32 32 64)
+TESTING THING
+*/
+
+void() misc_explobox =
+{
+	local float	oldz;
+	
+	self.solid = SOLID_BBOX;
+	self.movetype = MOVETYPE_NONE;
+	precache_model ("maps/b_explob.bsp");
+	setmodel (self, "maps/b_explob.bsp");
+	precache_sound ("weapons/r_exp3.wav");
+	self.health = 20;
+	self.th_die = barrel_explode;
+	self.takedamage = DAMAGE_AIM;
+
+	self.origin_z = self.origin_z + 2;
+	oldz = self.origin_z;
+	droptofloor();
+	if (oldz - self.origin_z > 250)
+	{
+		dprint ("item fell out of level at ");
+		dprint (vtos(self.origin));
+		dprint ("\n");
+		remove(self);
+	}
+};
+
+
+
+
+/*QUAKED misc_explobox2 (0 .5 .8) (0 0 0) (32 32 64)
+Smaller exploding box, REGISTERED ONLY
+*/
+
+void() misc_explobox2 =
+{
+	local float	oldz;
+	
+	self.solid = SOLID_BBOX;
+	self.movetype = MOVETYPE_NONE;
+	precache_model2 ("maps/b_exbox2.bsp");
+	setmodel (self, "maps/b_exbox2.bsp");
+	precache_sound ("weapons/r_exp3.wav");
+	self.health = 20;
+	self.th_die = barrel_explode;
+	self.takedamage = DAMAGE_AIM;
+
+	self.origin_z = self.origin_z + 2;
+	oldz = self.origin_z;
+	droptofloor();
+	if (oldz - self.origin_z > 250)
+	{
+		dprint ("item fell out of level at ");
+		dprint (vtos(self.origin));
+		dprint ("\n");
+		remove(self);
+	}
+};
+
+//============================================================================
+
+float SPAWNFLAG_SUPERSPIKE	= 1;
+float SPAWNFLAG_LASER = 2;
+
+void() Laser_Touch =
+{
+	local vector org;
+	
+	if (other == self.owner)
+		return;		// don't explode on owner
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	
+	sound (self, CHAN_WEAPON, "enforcer/enfstop.wav", 1, ATTN_STATIC);
+	org = self.origin - 8*normalize(self.velocity);
+
+	if (other.health)
+	{
+		SpawnBlood (org, self.velocity, 15);
+		T_Damage (other, self, self.owner, 15);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
+		WriteCoord (MSG_BROADCAST, org_x);
+		WriteCoord (MSG_BROADCAST, org_y);
+		WriteCoord (MSG_BROADCAST, org_z);
+	}
+	
+	remove(self);	
+};
+
+void(vector org, vector vec) LaunchLaser =
+{
+	local	vector	vec;
+		
+	if (self.classname == "monster_enforcer")
+		sound (self, CHAN_WEAPON, "enforcer/enfire.wav", 1, ATTN_NORM);
+
+	vec = normalize(vec);
+	
+	newmis = spawn();
+	newmis.owner = self;
+	newmis.movetype = MOVETYPE_FLY;
+	newmis.solid = SOLID_BBOX;
+	newmis.effects = EF_DIMLIGHT;
+
+	setmodel (newmis, "progs/laser.mdl");
+	setsize (newmis, '0 0 0', '0 0 0');		
+
+	setorigin (newmis, org);
+
+	newmis.velocity = vec * 600;
+	newmis.angles = vectoangles(newmis.velocity);
+
+	newmis.nextthink = time + 5;
+	newmis.think = SUB_Remove;
+	newmis.touch = Laser_Touch;
+};
+
+
+void() spikeshooter_use =
+{
+	if (self.spawnflags & SPAWNFLAG_LASER)
+	{
+		sound (self, CHAN_VOICE, "enforcer/enfire.wav", 1, ATTN_NORM);
+		LaunchLaser (self.origin, self.movedir);
+	}
+	else
+	{
+		sound (self, CHAN_VOICE, "weapons/spike2.wav", 1, ATTN_NORM);
+		launch_spike (self.origin, self.movedir, 500);
+//		newmis.velocity = self.movedir * 500;
+		if (self.spawnflags & SPAWNFLAG_SUPERSPIKE)
+			newmis.touch = superspike_touch;
+	}
+};
+
+void() shooter_think =
+{
+	spikeshooter_use ();
+	self.nextthink = time + self.wait;
+	newmis.velocity = self.movedir * 500;
+};
+
+
+/*QUAKED trap_spikeshooter (0 .5 .8) (-8 -8 -8) (8 8 8) superspike laser
+When triggered, fires a spike in the direction set in QuakeEd.
+Laser is only for REGISTERED.
+*/
+
+void() trap_spikeshooter =
+{
+	SetMovedir ();
+	self.use = spikeshooter_use;
+	if (self.spawnflags & SPAWNFLAG_LASER)
+	{
+		precache_model2 ("progs/laser.mdl");
+		
+		precache_sound2 ("enforcer/enfire.wav");
+		precache_sound2 ("enforcer/enfstop.wav");
+	}
+	else
+		precache_sound ("weapons/spike2.wav");
+};
+
+
+/*QUAKED trap_shooter (0 .5 .8) (-8 -8 -8) (8 8 8) superspike laser
+Continuously fires spikes.
+"wait" time between spike (1.0 default)
+"nextthink" delay before firing first spike, so multiple shooters can be stagered.
+*/
+void() trap_shooter =
+{
+	trap_spikeshooter ();
+	
+	if (self.wait == 0)
+		self.wait = 1;
+	self.nextthink = self.nextthink + self.wait + self.ltime;
+	self.think = shooter_think;
+};
+
+
+
+/*
+===============================================================================
+
+
+===============================================================================
+*/
+
+
+void() make_bubbles;
+void() bubble_remove;
+void() bubble_bob;
+
+/*QUAKED air_bubbles (0 .5 .8) (-8 -8 -8) (8 8 8)
+
+testing air bubbles
+*/
+
+void() air_bubbles =
+
+{
+	if (deathmatch)
+	{
+		remove (self);
+		return;
+	}
+	precache_model ("progs/s_bubble.spr");
+	self.nextthink = time + 1;
+	self.think = make_bubbles;
+};
+
+void() make_bubbles =
+{
+local entity	bubble;
+
+	bubble = spawn();
+	setmodel (bubble, "progs/s_bubble.spr");
+	setorigin (bubble, self.origin);
+	bubble.movetype = MOVETYPE_NOCLIP;
+	bubble.solid = SOLID_NOT;
+	bubble.velocity = '0 0 15';
+	bubble.nextthink = time + 0.5;
+	bubble.think = bubble_bob;
+	bubble.touch = bubble_remove;
+	bubble.classname = "bubble";
+	bubble.frame = 0;
+	bubble.cnt = 0;
+	setsize (bubble, '-8 -8 -8', '8 8 8');
+	self.nextthink = time + random() + 0.5;
+	self.think = make_bubbles;
+};
+
+void() bubble_split =
+{
+local entity	bubble;
+	bubble = spawn();
+	setmodel (bubble, "progs/s_bubble.spr");
+	setorigin (bubble, self.origin);
+	bubble.movetype = MOVETYPE_NOCLIP;
+	bubble.solid = SOLID_NOT;
+	bubble.velocity = self.velocity;
+	bubble.nextthink = time + 0.5;
+	bubble.think = bubble_bob;
+	bubble.touch = bubble_remove;
+	bubble.classname = "bubble";
+	bubble.frame = 1;
+	bubble.cnt = 10;
+	setsize (bubble, '-8 -8 -8', '8 8 8');
+	self.frame = 1;
+	self.cnt = 10;
+	if (self.waterlevel != 3)
+		remove (self);
+};
+
+void() bubble_remove =
+{
+	if (other.classname == self.classname)
+	{
+//		dprint ("bump");
+		return;
+	}
+	remove(self);
+};
+
+void() bubble_bob =
+{
+local float		rnd1, rnd2, rnd3;
+local vector	vtmp1, modi;
+
+	self.cnt = self.cnt + 1;
+	if (self.cnt == 4)
+		bubble_split();
+	if (self.cnt == 20)
+		remove(self);
+
+	rnd1 = self.velocity_x + (-10 + (random() * 20));
+	rnd2 = self.velocity_y + (-10 + (random() * 20));
+	rnd3 = self.velocity_z + 10 + random() * 10;
+
+	if (rnd1 > 10)
+		rnd1 = 5;
+	if (rnd1 < -10)
+		rnd1 = -5;
+		
+	if (rnd2 > 10)
+		rnd2 = 5;
+	if (rnd2 < -10)
+		rnd2 = -5;
+		
+	if (rnd3 < 10)
+		rnd3 = 15;
+	if (rnd3 > 30)
+		rnd3 = 25;
+	
+	self.velocity_x = rnd1;
+	self.velocity_y = rnd2;
+	self.velocity_z = rnd3;
+		
+	self.nextthink = time + 0.5;
+	self.think = bubble_bob;
+};
+
+/*~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>
+~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~<~>~*/
+
+/*QUAKED viewthing (0 .5 .8) (-8 -8 -8) (8 8 8)
+
+Just for the debugging level.  Don't use
+*/
+
+void() viewthing =
+
+{
+	self.movetype = MOVETYPE_NONE;
+	self.solid = SOLID_NOT;
+	precache_model ("progs/player.mdl");
+	setmodel (self, "progs/player.mdl");
+};
+
+
+/*
+==============================================================================
+
+SIMPLE BMODELS
+
+==============================================================================
+*/
+
+void() func_wall_use =
+{	// change to alternate textures
+	self.frame = 1 - self.frame;
+};
+
+/*QUAKED func_wall (0 .5 .8) ?
+This is just a solid wall if not inhibitted
+*/
+void() func_wall =
+{
+	if (gamestart && self.model == "*47")
+		return; // remove deathmatch only wall on start map
+
+	self.angles = '0 0 0';
+	self.movetype = MOVETYPE_PUSH;	// so it doesn't get pushed by anything
+	self.solid = SOLID_BSP;
+	self.use = func_wall_use;
+	setmodel (self, self.model);
+};
+
+
+/*QUAKED func_illusionary (0 .5 .8) ?
+A simple entity that looks solid but lets you walk through it.
+*/
+void() func_illusionary =
+
+{
+	self.angles = '0 0 0';
+	self.movetype = MOVETYPE_NONE;
+	self.solid = SOLID_NOT;
+	setmodel (self, self.model);
+	makestatic ();
+};
+
+/*QUAKED func_episodegate (0 .5 .8) ? E1 E2 E3 E4
+This bmodel will appear if the episode has allready been completed, so players can't reenter it.
+*/
+void() func_episodegate =
+
+{
+	if (!(serverflags & self.spawnflags))
+		return;			// can still enter episode
+
+	self.angles = '0 0 0';
+	self.movetype = MOVETYPE_PUSH;	// so it doesn't get pushed by anything
+	self.solid = SOLID_BSP;
+	self.use = func_wall_use;
+	setmodel (self, self.model);
+};
+
+/*QUAKED func_bossgate (0 .5 .8) ?
+This bmodel appears unless players have all of the episode sigils.
+*/
+void() func_bossgate =
+
+{
+	if ( (serverflags & 15) == 15 || gamestart)
+		return;		// all episodes completed
+	self.angles = '0 0 0';
+	self.movetype = MOVETYPE_PUSH;	// so it doesn't get pushed by anything
+	self.solid = SOLID_BSP;
+	self.use = func_wall_use;
+	setmodel (self, self.model);
+};
+
+//============================================================================
+/*QUAKED ambient_suck_wind (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_suck_wind =
+{
+	precache_sound ("ambience/suck1.wav");
+	ambientsound (self.origin, "ambience/suck1.wav", 1, ATTN_STATIC);
+};
+
+/*QUAKED ambient_drone (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_drone =
+{
+	precache_sound ("ambience/drone6.wav");
+	ambientsound (self.origin, "ambience/drone6.wav", 0.5, ATTN_STATIC);
+};
+
+/*QUAKED ambient_flouro_buzz (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_flouro_buzz =
+{
+	precache_sound ("ambience/buzz1.wav");
+	ambientsound (self.origin, "ambience/buzz1.wav", 1, ATTN_STATIC);
+};
+/*QUAKED ambient_drip (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_drip =
+{
+	precache_sound ("ambience/drip1.wav");
+	ambientsound (self.origin, "ambience/drip1.wav", 0.5, ATTN_STATIC);
+};
+/*QUAKED ambient_comp_hum (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_comp_hum =
+{
+	precache_sound ("ambience/comp1.wav");
+	ambientsound (self.origin, "ambience/comp1.wav", 1, ATTN_STATIC);
+};
+/*QUAKED ambient_thunder (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_thunder =
+{
+	precache_sound ("ambience/thunder1.wav");
+	ambientsound (self.origin, "ambience/thunder1.wav", 0.5, ATTN_STATIC);
+};
+/*QUAKED ambient_light_buzz (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_light_buzz =
+{
+	precache_sound ("ambience/fl_hum1.wav");
+	ambientsound (self.origin, "ambience/fl_hum1.wav", 0.5, ATTN_STATIC);
+};
+/*QUAKED ambient_swamp1 (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_swamp1 =
+{
+	precache_sound ("ambience/swamp1.wav");
+	ambientsound (self.origin, "ambience/swamp1.wav", 0.5, ATTN_STATIC);
+};
+/*QUAKED ambient_swamp2 (0.3 0.1 0.6) (-10 -10 -8) (10 10 8)
+*/
+void() ambient_swamp2 =
+{
+	precache_sound ("ambience/swamp2.wav");
+	ambientsound (self.origin, "ambience/swamp2.wav", 0.5, ATTN_STATIC);
+};
+
+//============================================================================
+
+void() noise_think =
+{
+	self.nextthink = time + 0.5;
+	sound (self, 1, "enforcer/enfire.wav", 1, ATTN_NORM);
+	sound (self, 2, "enforcer/enfstop.wav", 1, ATTN_NORM);
+	sound (self, 3, "enforcer/sight1.wav", 1, ATTN_NORM);
+	sound (self, 4, "enforcer/sight2.wav", 1, ATTN_NORM);
+	sound (self, 5, "enforcer/sight3.wav", 1, ATTN_NORM);
+	sound (self, 6, "enforcer/sight4.wav", 1, ATTN_NORM);
+	sound (self, 7, "enforcer/pain1.wav", 1, ATTN_NORM);
+};
+
+/*QUAKED misc_noisemaker (1 0.5 0) (-10 -10 -10) (10 10 10)
+
+For optimzation testing, starts a lot of sounds.
+*/
+
+void() misc_noisemaker =
+
+{
+	precache_sound2 ("enforcer/enfire.wav");
+	precache_sound2 ("enforcer/enfstop.wav");
+	precache_sound2 ("enforcer/sight1.wav");
+	precache_sound2 ("enforcer/sight2.wav");
+	precache_sound2 ("enforcer/sight3.wav");
+	precache_sound2 ("enforcer/sight4.wav");
+	precache_sound2 ("enforcer/pain1.wav");
+	precache_sound2 ("enforcer/pain2.wav");
+	precache_sound2 ("enforcer/death1.wav");
+	precache_sound2 ("enforcer/idle1.wav");
+
+	self.nextthink = time + 0.1 + random();
+	self.think = noise_think;
+};
+
+/*
+===============================================================================
+
+WORLD WEAPONS
+
+===============================================================================
+*/
+
+$modelname g_shot
+$cd id1/models/g_shot
+$origin 0 0 -24
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame shot1
+
+
+$modelname g_nail
+$cd id1/models/g_nail
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+
+$modelname g_nail2
+$cd id1/models/g_nail2
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot2
+
+
+$modelname g_rock
+$cd id1/models/g_rock
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+
+$modelname g_rock2
+$cd id1/models/g_rock2
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+$modelname g_light
+$cd id1/models/g_light
+$flags 8		// client side rotate
+$origin 0 0 -24
+$base base
+$skin skin
+$frame shot1
+
+/*
+===============================================================================
+
+VIEW WEAPONS
+
+===============================================================================
+*/
+
+$modelname v_axe
+$cd id1/models/v_axe
+$origin 0 5 54
+$base base
+$skin skin
+$frame frame1 frame2 frame3 frame4 frame5 frame6 frame7 frame8 frame9
+
+
+$modelname v_shot
+$cd id1/models/v_shot
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7
+
+
+$modelname v_shot2
+$cd id1/models/v_shot2
+$origin 0 0 56
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7
+
+
+$modelname v_rock2
+$cd id1/models/v_rock2
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot6
+
+
+$modelname v_rock
+$cd id1/models/v_rock
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7
+
+
+$modelname v_nail2
+$cd id1/models/v_nail2
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7 shot8 shot9
+
+
+$modelname v_nail
+$cd id1/models/v_nail
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5 shot6 shot7 shot8 shot9
+
+$modelname v_light
+$cd id1/models/v_light
+$origin 0 0 54
+$base base
+$skin skin
+$frame shot1 shot2 shot3 shot4 shot5
+
+
+/*
+===============================================================================
+
+ITEMS
+
+===============================================================================
+*/
+
+$modelname w_g_key
+$cd id1/models/w_g_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname w_s_key
+$cd id1/models/w_s_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname m_g_key
+$cd id1/models/m_g_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname m_s_key
+$cd id1/models/m_s_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname b_g_key
+$cd id1/models/b_g_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname b_s_key
+$cd id1/models/b_s_key
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+
+$modelname quaddama
+$cd id1/models/quaddama
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname invisibl
+$cd id1/models/invisibl
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname invulner
+$flags 8		// client side rotate
+$cd id1/models/invulner
+$base base
+$skin skin
+$frame frame1
+
+//modelname jetpack
+//cd id1/models/jetpack
+//flags 8		// client side rotate
+//base base
+//skin skin
+//frame frame1
+
+$modelname cube
+$cd id1/models/cube
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname suit
+$cd id1/models/suit
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname boots
+$cd id1/models/boots
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end1
+$cd id1/models/end1
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end2
+$cd id1/models/end2
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end3
+$cd id1/models/end3
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+$modelname end4
+$cd id1/models/end4
+$flags 8		// client side rotate
+$base base
+$skin skin
+$frame frame1
+
+
+/*
+===============================================================================
+
+GIBS
+
+===============================================================================
+*/
+
+$modelname gib1
+$cd id1/models/gib1
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+
+// torso
+$modelname gib2
+$cd id1/models/gib2
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname gib3
+$cd id1/models/gib3
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+
+// heads
+
+$modelname h_player
+$cd id1/models/h_player
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_dog
+$cd id1/models/h_dog
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_mega
+$cd id1/models/h_mega
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_guard
+$cd id1/models/h_guard
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_wizard
+$cd id1/models/h_wizard
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_knight
+$cd id1/models/h_knight
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_hellkn
+$cd id1/models/h_hellkn
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_zombie
+$cd id1/models/h_zombie
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_shams
+$cd id1/models/h_shams
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_shal
+$cd id1/models/h_shal
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_ogre
+$cd id1/models/h_ogre
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname h_demon
+$cd id1/models/h_demon
+$flags 4		// EF_GIB
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+/*
+===============================================================================
+
+MISC
+
+===============================================================================
+*/
+
+$modelname armor
+$cd id1/models/armor
+$flags 8		// client side rotate
+$origin 0 0 -8
+$base base
+$skin skin
+$skin skin2
+$skin skin3
+$frame armor
+
+$modelname s_light			// shambler lightning ready
+$cd id1/models/s_light
+$origin 0 0 24
+$base base
+$skin skin
+$frame	frame1 frame2 frame3
+
+$modelname bolt3			// lightning towar bolts
+$cd id1/models/bolt2
+$origin 0 0 0
+$base base
+$scale 4
+$skin skin
+$frame	light
+
+$modelname bolt2
+$cd id1/models/bolt2
+$origin 0 0 0
+$base base
+$skin skin
+$frame	light
+
+$modelname bolt
+$cd id1/models/bolt
+$origin 0 0 0
+$base light
+$skin light
+$frame	light
+
+$modelname laser
+$cd id1/models/laser
+$base base
+$skin skin
+$scale 2
+$frame frame1
+
+$modelname flame		// with torch
+$cd id1/models/flame
+$origin 0 0 12
+$base base
+$skin skin
+$framegroupstart
+$frame flame1	0.1
+$frame flame2	0.1
+$frame flame3	0.1
+$frame flame4	0.1
+$frame flame5	0.1
+$frame flame6	0.1
+$framegroupend
+
+$modelname flame2		// standing flame, no torch
+$cd id1/models/flame2
+$origin 0 0 12
+$base base
+$skin skin
+$framegroupstart
+$frame flame1	0.1
+$frame flame2	0.1
+$frame flame3	0.1
+$frame flame4	0.1
+$frame flame5	0.1
+$frame flame6	0.1
+$framegroupend
+$framegroupstart
+$frame flameb1
+$frame flameb2
+$frame flameb3
+$frame flameb4
+$frame flameb5
+$frame flameb6
+$frame flameb7
+$frame flameb8
+$frame flameb9
+$frame flameb10
+$frame flameb11
+$framegroupend
+
+$modelname zom_gib
+$cd id1/models/zom_gib
+$flags 32		// EF_ZOMGIB
+$base base
+$skin skin
+$frame frame1
+
+$modelname eyes
+$cd id1/models/eyes
+$origin 0 0 -24
+$base base
+$skin skin
+$frame frame1
+
+$modelname spike
+$cd id1/models/spike
+$origin 0 0 0
+$base spike
+$skin skin
+$frame spike
+
+$modelname s_spike
+$cd id1/models/s_spike
+$origin 0 0 0
+$base spike
+$skin skin
+$frame spike
+
+$modelname v_spike
+$cd id1/models/v_spike
+$flags 128		// EF_TRACER3
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname w_spike
+$cd id1/models/w_spike
+$flags 16		// EF_TRACER
+$origin 0 0 0
+$base base
+$skin skin
+$framegroupstart
+$frame frame1	0.1
+$frame frame2	0.1
+$frame frame3	0.1
+$frame frame4	0.1
+$framegroupend
+
+$modelname k_spike
+$cd id1/models/k_spike
+$flags 64		// EF_TRACER2
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname backpack
+$cd id1/models/backpack
+$flags 8		// EF_ROTATE
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname grenade
+$cd id1/models/grenade2
+$flags 2		// EF_GRENADE
+$origin 0 0 0
+$base base
+$skin skin
+$frame grenade
+
+$modelname missile
+$cd id1/models/missile
+$flags	1			// EF_ROCKET
+$origin 0 0 0
+$base base
+$skin skin
+$frame missile
+
+$modelname lavaball
+$cd id1/models/lavaball
+$flags	1			// EF_ROCKET
+$origin 0 0 0
+$base base
+$skin skin
+$frame frame1
+
+$modelname teleport
+$cd id1/models/teleport
+$origin 0 0 24
+$base base
+$skin skin
+$frame frame1
+
+/****************************************************************************
+ * ThreeWave Capture The Flag
+ ****************************************************************************
+ * Based on John Spikles Complete Enhanced Teamplay
+ ****************************************************************************
+ * Version 4.0 rewrite Mar 21, 1997
+ ****************************************************************************/
+
+/** Defs **/
+
+/** MODIFIABLE CONSTANTS **/
+
+float TEAM_DEFAULT_PENALTY =    1;      // Default frag penalty
+float TEAM_STRICT_COOP =	0;	// Strict Coop
+
+// Allowed team colors
+// -1 indicates no color
+
+float TEAM_COLOR1       =       5;
+float TEAM_COLOR2       =       14;
+
+float team1shirt;
+float team2shirt;
+
+/** End of MODIFIABLE CONSTANTS **/
+
+// Globals
+
+entity team1_lastspawn;
+entity team2_lastspawn;
+float	nextteamupdtime;	// time until next team update
+
+// Teamplay bitfield entries
+
+float TEAM_HEALTH_PROTECT =     1;      // No health damage from friendly fire
+float TEAM_ARMOR_PROTECT =      2;      // No armor damage from friendly fire
+float TEAM_ATTACKER_DAMAGE =    4;      // Attacker takes damage from hitting teammates
+float TEAM_FRAG_PENALTY =       8;      // One frag penalty for killing teammate
+float TEAM_DEATH_PENALTY =      16;     // Die when you kill a teammate.
+float TEAM_STATIC_TEAMS =       64;     // Don't allow players to switch teams
+float TEAM_DROP_ITEMS = 		128;	// Allow players to drop packs and 
+float TEAM_CAPTURE_CUSTOM = 	512;	// custom models
+float TEAM_CAPTURE_SELECT_TEAM = 1024; // team selection
+
+/* -=CT=-KALWeb : Begin Enhanced -=CT=-CTF Constants */
+float TEAM_DROP_RUNE =          2048; // Allow droppable runes
+float TEAM_DROP_FLAG =          4096; // Allow droppable flag
+float DROP_RUNE_IMPULSE =       26; // Impulse to use to drop rune
+float DROP_FLAG_IMPULSE =       27; // Impulse to use to drop flag
+/* End -=CT=-KALWeb */
+
+float TEAM_CAPTURE_CAPTURE_BONUS = 15; // what you get for capture
+float TEAM_CAPTURE_TEAM_BONUS = 10; // what your team gets for capture
+float TEAM_CAPTURE_RECOVERY_BONUS = 1; // what you get for recovery
+float TEAM_CAPTURE_FLAG_BONUS = 0; // what you get for picking up enemy flag
+float TEAM_CAPTURE_FRAG_CARRIER_BONUS = 2; // what you get for fragging
+	//enemy flag carrier
+float TEAM_CAPTURE_FLAG_RETURN_TIME = 40; // seconds until auto return
+
+// XXX EXPERT CTF Additional scoring system
+
+// bonuses
+
+float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_BONUS = 2; // bonus for fraggin someone
+// who has recently hurt your flag carrier
+float TEAM_CAPTURE_CARRIER_PROTECT_BONUS = 1; // bonus for fraggin someone while
+// either you or your target are near your flag carrier
+float TEAM_CAPTURE_FLAG_DEFENSE_BONUS = 1; // bonus for fraggin someone while
+// either you or your target are near your flag
+float TEAM_CAPTURE_RETURN_FLAG_ASSIST_BONUS = 1; // awarded for returning a flag that causes a
+// capture to happen almost immediately
+float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_BONUS = 2; // award for fragging a flag carrier if a
+// capture happens almost immediately
+
+// radii
+
+float TEAM_CAPTURE_TARGET_PROTECT_RADIUS = 550; // the radius around an object being
+// defended where a target will be worth extra frags
+float TEAM_CAPTURE_ATTACKER_PROTECT_RADIUS = 550; // the radius around an object being
+// defended where an attacker will get extra frags when making kills
+
+// timeouts
+
+float TEAM_CAPTURE_CARRIER_DANGER_PROTECT_TIMEOUT = 4;
+float TEAM_CAPTURE_CARRIER_FLAG_SINCE_TIMEOUT = 2;
+float TEAM_CAPTURE_FRAG_CARRIER_ASSIST_TIMEOUT = 6;
+float TEAM_CAPTURE_RETURN_FLAG_ASSIST_TIMEOUT = 4;
+
+float TEAM_CAPTURE_UPDATE_TIME = 120;
+
+// END EXPERT CTF
+
+// flag status used in cnt field of flag
+float FLAG_AT_BASE = 0;
+float FLAG_CARRIED = 1;
+float FLAG_DROPPED = 2;
+
+
+// Prototypes
+float() W_BestWeapon;
+void() W_SetCurrentAmmo;
+void() bound_other_ammo;
+void(float o, float n) Deathmatch_Weapon;
+void() BackpackTouch;
+void(entity who, string s) TeamPlayerUpdate;
+void() TeamCaptureResetUpdate;
+
+// Return a name for the color of a team
+string(float Team) GetTeamColor =
+{
+	if(Team == 0) return("Blue");
+	else if(Team == 1) return("Steel blue");
+	else if(Team == 2) return("Brown");
+	else if(Team == 3) return("Baby blue");
+	else if(Team == 4) return("Green");
+	else if(Team == 5) return("Red");
+	else if(Team == 6) return("Olive");
+	else if(Team == 7) return("Orange");
+	else if(Team == 8) return("Peech");
+	else if(Team == 9) return("Purple");
+	else if(Team == 10) return("Majenta");
+	else if(Team == 11) return("Grey");
+	else if(Team == 12) return("Aqua");
+	else if(Team == 13) return("Yellow");
+	else if(Team == 14) return("Blue");
+	return "Unknown";
+};
+
+// *XXX* EXPERT CTF
+// Just a quickie to return the ASCII-ized team names for CTF
+string(float Team) GetCTFTeam =
+{
+
+	if (Team == TEAM_COLOR1) return "";
+	if (Team == TEAM_COLOR2) return "";
+	return "";
+
+};
+
+
+/*
+================
+TeamPrintSettings
+
+Print out current teamplay options
+================
+*/
+
+void() TeamPrintSettings =
+{
+	local string s;
+	
+	sprint(self,"The following Teamplay options are set:\n");
+	
+	if(teamplay < 0)
+	{
+		sprint(self, "Frag penalty manually set to ");
+		s = ftos(teamplay);
+		sprint(self, s);
+		sprint(self, "\n");
+		return;
+	}
+	
+	if(!teamplay) 
+	{
+		sprint(self, "None\n");
+		return;
+	}
+	
+	if(1 == teamplay)
+	{
+		sprint(self, "ID's original teamplay 1\n");
+		return;
+	}
+	
+	if(teamplay & TEAM_HEALTH_PROTECT)
+		sprint(self, "Health-Protect ");
+	
+	if(teamplay & TEAM_ARMOR_PROTECT)
+		sprint(self, "Armor-Protect ");
+		
+	if(teamplay & TEAM_ATTACKER_DAMAGE)
+		sprint(self, "Mirror-Damage ");
+		
+	if(teamplay & TEAM_FRAG_PENALTY)
+		sprint(self, "Frag-Penalty ");
+		
+	if(teamplay & TEAM_DEATH_PENALTY)
+		sprint(self, "Death-Penalty ");
+		
+	if(teamplay & TEAM_STATIC_TEAMS)
+		sprint(self, "Static-Teams ");
+		
+	if(teamplay & TEAM_DROP_ITEMS)
+		sprint(self, "Drop-Items (Backpack Impulse 20, Weapon Impulse 21) ");
+		
+	sprint(self, "\n");
+};
+
+/*
+================
+TeamArmorDam
+
+Return TRUE if the target's armor can take damage from this attacker.
+================
+*/
+
+float(entity targ, entity inflictor, entity attacker, float damage) TeamArmorDam =
+{
+        if ((teamplay < 0) || gamestart)
+                return TRUE;
+
+        if( (teamplay & TEAM_ARMOR_PROTECT) && 
+			(attacker.lastteam == targ.lastteam) && 
+			(attacker != targ) && (targ.lastteam > 0) )
+        {
+                // Armor is protected
+                return FALSE;
+        }
+        return TRUE;
+};
+
+/*
+================
+TeamHealthDam
+
+Return TRUE if the target can take health damage from this attacker.
+================
+*/
+
+float(entity targ, entity inflictor, entity attacker, float damage) TeamHealthDam =
+{
+        if ((teamplay < 0) || gamestart)
+                return TRUE;
+
+        if( (attacker.lastteam == targ.lastteam) && 
+			(attacker != targ) && (targ.lastteam > 0) ) {
+                // Attacker and target are on the same team.
+                if( teamplay & TEAM_ATTACKER_DAMAGE )
+                {
+                        // Damage applied to teammate.
+                        T_Damage(attacker, inflictor, attacker, damage);
+                }
+                if( teamplay & TEAM_HEALTH_PROTECT )
+                {
+                        // Health is protected
+                        return FALSE;
+                }
+        }
+        return TRUE;
+};
+
+/*
+================
+TeamPFrags
+
+Return the number of frags we should penalize attacker for killing targ.
+================
+*/
+
+float(entity targ, entity attacker) TeamPFrags =
+{
+        if( teamplay < 0 )
+                return (-1 * teamplay);
+        if( (targ.lastteam > 0) && (targ != attacker) && (targ.lastteam ==
+			attacker.lastteam) )
+        {
+                // targ and attacker are on the same team
+                if( teamplay < 0 )
+                {
+                        // teamplay indicates frag penalty
+                        return ( -1 * teamplay );
+                }
+                if( teamplay & TEAM_FRAG_PENALTY )
+                {
+                        // default penalty
+                        return TEAM_DEFAULT_PENALTY;
+                }
+        }
+        // No frag penalty
+        return 0;
+};
+
+/*
+================
+TeamFragPenalty
+
+If attacker should be penalized for killing targ, penalize attacker
+and return TRUE.
+================
+*/
+
+float(entity targ, entity attacker) TeamFragPenalty =
+{
+        local float f;
+
+        f = TeamPFrags(targ, attacker);
+
+        if( f )
+        {
+                // We should penalize some frags.
+                attacker.frags = attacker.frags - f;
+                return TRUE;
+        }
+        // No penalty
+        return FALSE;
+};
+
+/*
+=================
+TeamDeathPenalty
+
+If attacker should be killed for killing targ, kill attacker and
+add a frag to offset the one attacker will lose for killing himself.
+*/
+
+void(entity targ, entity attacker) TeamDeathPenalty =
+{
+        //Don't kill anyone if teamplay is negative.
+        if ( teamplay < 0 )
+                return;
+
+        if ( (teamplay & TEAM_DEATH_PENALTY) && (targ.lastteam > 0) &&
+			(attacker != targ) && (attacker.lastteam == targ.lastteam) )
+        {
+                //We should kill the attacker.
+                T_Damage(attacker,attacker,attacker,1000);
+                //Add a frag to offset the self-kill penalty.
+                attacker.frags = attacker.frags + 1;
+        }
+};
+
+/*
+==================
+TeamColorIsLegal
+
+Return TRUE if the indicated color is legal
+==================
+*/
+float(float color) TeamColorIsLegal =
+{
+        // All colors are legal if teamplay is negative.
+        if( teamplay < 0 )
+                return TRUE;
+        if( (color == TEAM_COLOR1) && (TEAM_COLOR1 >= 0) )
+                return TRUE;
+        if( (color == TEAM_COLOR2) && (TEAM_COLOR2 >= 0) )
+                return TRUE;
+};
+
+float(float t) TeamGetShirt =
+{
+	if (t == TEAM_COLOR1) {
+		team1shirt = team1shirt + 1;
+		if (team1shirt > 14)
+			team1shirt = 0;
+		if (team1shirt == TEAM_COLOR2)
+			team1shirt = team2shirt + 1;
+		return team1shirt;
+	} else { // color2
+		team2shirt = team2shirt + 1;
+		if (team2shirt > 14)
+			team2shirt = 0;
+		if (team2shirt == TEAM_COLOR1)
+			team2shirt = team1shirt + 1;
+		return team2shirt;
+	}
+	return t - 1;
+};
+
+/*
+==================
+TeamCheckTeam
+
+Check if the team self is on is legal, and put self in a legal team if not.
+==================
+*/
+void() TeamCheckTeam =
+{
+	local float TEAM1;
+	local float TEAM2;
+
+	local float newcolor;
+	local float t;
+
+	local entity p;
+
+	local string n; 
+
+	if( self.lastteam >= 0 )
+	{
+			if(TeamColorIsLegal(self.team)) {
+				self.lastteam = self.team;
+				return;
+			}
+	}
+
+	// Assign the player to a team.
+
+	// Sum the players on all the teams.
+
+	TEAM1 = 0;
+	TEAM2 = 0;
+
+	p = find (world, classname, "player");
+
+	while(p)
+	{
+		if (p != self) {
+			if (p.team == TEAM_COLOR1)
+				TEAM1 = TEAM1 + 1;
+			else if (p.team == TEAM_COLOR2)
+				TEAM2 = TEAM2 + 1;
+		}
+		p = find(p, classname, "player");
+	}
+
+	// Find the team with the least players.
+	newcolor = TEAM_COLOR1;
+	if (((TEAM2 < TEAM1) || (TEAM2 == TEAM1 && random() < 0.5)))
+		newcolor = TEAM_COLOR2;
+
+	// Put the player on a the new team.
+
+	stuffcmd(self, "color ");
+	t = TeamGetShirt(newcolor);
+	n = ftos(t);
+	stuffcmd(self, n);
+	stuffcmd(self, " ");
+	n = ftos(newcolor - 1);
+	stuffcmd(self, n);
+	stuffcmd(self, "\n");
+
+	self.lastteam = newcolor;      // Remember what team we're on
+	self.team = newcolor;
+};
+
+/*
+===============
+TeamCheckLock
+
+Check for team changing and perform whatever actions are neccessary.
+===============
+*/
+void() TeamCheckLock =
+{
+	local   float   n;
+	local   string  s;
+
+	// Don't do anything if teamplay is negative
+	if ( teamplay < 0 )
+			return;
+	
+	if (self.observer || self.do_observer || gamestart) {
+		if (self.team != 1)
+			stuffcmd(self, "color 0\n");
+		self.lastteam = 1;
+		return;
+	}
+
+	if (self.player_flag & TEAM_STUFF_COLOR) {
+		self.player_flag = self.player_flag - TEAM_STUFF_COLOR;
+		stuffcmd(self, "color ");
+		n = TeamGetShirt(self.lastteam);
+		s = ftos(n);
+		stuffcmd(self, s);
+		stuffcmd(self, " ");
+		n = self.lastteam - 1;
+		s = ftos(n);
+		stuffcmd(self, s);
+		stuffcmd(self, "\n");
+		return;
+	}
+
+	if ( !TeamColorIsLegal(self.team) && (self.team == self.lastteam)) {
+		self.lastteam = -1;
+	}
+
+	// Check to see if the player has changed colors
+	if (self.team != self.lastteam)
+	{
+		// Player has changed colors
+
+		// If teams are static and we've been on some team already,
+		// put us back on the team we were on.
+
+		if ( (teamplay & TEAM_STATIC_TEAMS) && (self.lastteam >= 0) )
+		{
+			if ( TeamColorIsLegal(self.lastteam) )
+			{
+				// changing teams sucks, kill him
+
+				// if he has tried to change teams several
+				// times, kick him off the server.
+				if (self.suicide_count > 3) {
+					sprint(self, "You were told you can't change teams.\nGo play color games somewhere else.\n");
+					stuffcmd(self, "disconnect\n");
+					bprint(self.netname);
+					bprint(" has bad color sense\n");
+				}
+				// case base respawn
+				if (self.killed != 1)
+					self.killed = 2;
+				self.invincible_finished = 0;
+				T_Damage(self,self,self,1000);  // Kill the player
+				// trying to change teams counts as a suicide
+				self.suicide_count = self.suicide_count + 1;
+
+				sprint(self, "You cannot change teams.\n");
+				stuffcmd(self, "color ");
+				n = TeamGetShirt(self.lastteam);
+				s = ftos(n);
+				stuffcmd(self, s);
+				stuffcmd(self, " ");
+				n = self.lastteam - 1;
+				s = ftos(n);
+				stuffcmd(self, s);
+				stuffcmd(self, "\n");
+				self.team = self.lastteam;
+				return;
+			}
+			else {
+				// If we're on an illegal team, force a change.
+				self.lastteam = -50;
+			}
+		}
+
+		if(self.lastteam > 0) {
+			// case base respawn
+			if (self.killed != 1)
+				self.killed = 2;
+			T_Damage(self,self,self,1000);  // Kill the player
+		}
+		self.frags = 0;                 // Zero out frags
+		TeamCheckTeam();
+	}
+};
+
+/*
+=======================
+TossBackPack
+
+Original idea by Vhold
+Rewritten by John Spickes
+
+Toss out a backpack containing some ammo from your current weapon,
+and any weapons you don't have.
+=======================
+*/
+void() TossBackpack =
+{
+	local entity 	item;
+
+	// If we don't have any ammo, return
+	if(self.currentammo <= 0)
+		return;
+
+	item = spawn();
+
+	// See if you have the Shotgun or Super Shotgun on
+        if ( (self.weapon == IT_SHOTGUN) || (self.weapon == IT_SUPER_SHOTGUN)) {
+		if( self.ammo_shells >= 20 ) {
+			item.ammo_shells = 20;
+			self.ammo_shells = self.ammo_shells - 20;
+		}
+		else
+		{
+			item.ammo_shells = self.ammo_shells;
+			self.ammo_shells = 0;
+		}
+	}		
+	
+	// See if you have neither the Shotgun or Super Shotgun
+        if ( !(self.items & IT_SHOTGUN) && !(self.items & IT_SUPER_SHOTGUN)) {
+		if( self.ammo_shells >= 20 ) {
+			item.ammo_shells = 20;
+			self.ammo_shells = self.ammo_shells - 20;
+		}
+		else
+		{
+			item.ammo_shells = self.ammo_shells;
+			self.ammo_shells = 0;
+		}
+	}		
+	
+	// See if we are using a nailgun
+        if ( (self.weapon == IT_NAILGUN) || (self.weapon == IT_SUPER_NAILGUN) )
+	{
+		if( self.ammo_nails >= 20 )
+		{
+			item.ammo_nails = 20;
+			self.ammo_nails = self.ammo_nails - 20;
+		}
+		else
+		{
+			item.ammo_nails = self.ammo_nails;
+			self.ammo_nails = 0;
+		}
+	}	
+	// Check to see if we have neither nailgun
+        if ( !(self.items & IT_NAILGUN) && !(self.items & IT_SUPER_NAILGUN) )
+	{
+		if( self.ammo_nails >= 20 )
+		{
+			item.ammo_nails = 20;
+			self.ammo_nails = self.ammo_nails - 20;
+		}
+		else
+		{
+			item.ammo_nails = self.ammo_nails;
+			self.ammo_nails = 0;
+		}
+	}	
+	
+	// See if we are using a grenade or rocket launcher
+        if ( (self.weapon == IT_GRENADE_LAUNCHER) || (self.weapon == IT_ROCKET_LAUNCHER) )
+	{
+		if( self.ammo_rockets >= 10 )
+		{
+			item.ammo_rockets = 10;
+			self.ammo_rockets = self.ammo_rockets - 10;
+		}
+		else
+		{
+			item.ammo_rockets = self.ammo_rockets;
+			self.ammo_rockets = 0;
+		}
+	}
+	// See if we have neither the Grenade or rocket launcher
+        if ( !(self.items & IT_GRENADE_LAUNCHER) && !(self.items & IT_ROCKET_LAUNCHER) )
+	{
+		if( self.ammo_rockets >= 10 )
+		{
+			item.ammo_rockets = 10;
+			self.ammo_rockets = self.ammo_rockets - 10;
+		}
+		else
+		{
+			item.ammo_rockets = self.ammo_rockets;
+			self.ammo_rockets = 0;
+		}
+	}
+
+	// See if we're using the lightning gun
+	if ( self.weapon == IT_LIGHTNING )
+	{	
+		if( self.ammo_cells >= 20 )
+		{
+			item.ammo_cells = 20;
+			self.ammo_cells = self.ammo_cells - 20;
+		}
+		else
+		{
+			item.ammo_cells = self.ammo_cells;
+			self.ammo_cells = 0;
+		}
+	}
+	// see if we don't have the lightning gun
+        if ( !(self.items & IT_LIGHTNING) )
+	{	
+		if( self.ammo_cells >= 20 )
+		{
+			item.ammo_cells = 20;
+			self.ammo_cells = self.ammo_cells - 20;
+		}
+		else
+		{
+			item.ammo_cells = self.ammo_cells;
+			self.ammo_cells = 0;
+		}
+	}
+	 
+	item.owner = self;
+	makevectors(self.v_angle);
+
+	setorigin(item, self.origin + '0 0 16');
+	item.velocity = aim(self, 1000);
+	item.velocity = item.velocity * 500;
+	item.flags = FL_ITEM;
+	item.solid = SOLID_TRIGGER;
+	item.movetype = MOVETYPE_BOUNCE;
+
+	setmodel (item, "progs/backpack.mdl");
+	setsize(item, '-16 -16 0', '16 16 56');
+	item.touch = BackpackTouch;
+	item.nextthink = time + 120;	// remove after 2 minutes
+	item.think = SUB_Remove;
+
+	W_SetCurrentAmmo();
+
+};
+
+void() Team_weapon_touch =
+{
+	local	float	hadammo, best, new, old;
+	local entity stemp;
+
+	if (!(other.flags & FL_CLIENT))
+		return;
+	// Don't let the owner pick up his own weapon for a second.
+	if ( (other == self.owner) && ( (self.nextthink - time) > 119 ) )
+		return;
+
+// if the player was using his best weapon, change up to the new one if better		
+	stemp = self;
+	self = other;
+	best = W_BestWeapon();
+	self = stemp;
+
+	if (self.classname == "weapon_nailgun")
+	{
+		hadammo = other.ammo_nails;			
+		new = IT_NAILGUN;
+	}
+	else if (self.classname == "weapon_supernailgun")
+	{
+		hadammo = other.ammo_rockets;			
+		new = IT_SUPER_NAILGUN;
+	}
+	else if (self.classname == "weapon_supershotgun")
+	{
+		hadammo = other.ammo_rockets;			
+		new = IT_SUPER_SHOTGUN;
+	}
+	else if (self.classname == "weapon_rocketlauncher")
+	{
+		hadammo = other.ammo_rockets;			
+		new = IT_ROCKET_LAUNCHER;
+	}
+	else if (self.classname == "weapon_grenadelauncher")
+	{
+		hadammo = other.ammo_rockets;			
+		new = IT_GRENADE_LAUNCHER;
+	}
+	else if (self.classname == "weapon_lightning")
+	{
+		hadammo = other.ammo_rockets;			
+		new = IT_LIGHTNING;
+	}
+	else
+		objerror ("Team_weapon_touch: unknown classname");
+
+	sprint (other, "You got the ");
+	sprint (other, self.netname);
+	sprint (other, "\n");
+// weapon touch sound
+	sound (other, CHAN_ITEM, "weapons/pkup.wav", 1, ATTN_NORM);
+	stuffcmd (other, "bf\n");
+
+	bound_other_ammo ();
+
+// change to the weapon
+	old = other.items;
+	other.items = other.items | new;
+	
+	remove(self);
+	self = other;
+
+	if (!deathmatch)
+		self.weapon = new;
+	else
+		Deathmatch_Weapon (old, new);
+
+	W_SetCurrentAmmo();
+
+	activator = other;
+	SUB_UseTargets();				// fire all targets / killtargets
+};
+        
+void() TossWeapon =
+{
+	local entity item;
+	
+	if (deathmatch != 1)
+		return;  // only in deathmatch 1
+
+	if((self.weapon == IT_AXE) || (self.weapon == IT_SHOTGUN) ||
+		(self.weapon == IT_HOOK))
+		return;
+		
+	item = spawn();
+	item.owner = self;
+	makevectors(self.v_angle);
+
+	setorigin(item, self.origin + '0 0 16');
+	item.velocity = aim(self, 1000);
+	item.velocity = item.velocity * 500;
+	item.flags = FL_ITEM;
+	item.solid = SOLID_TRIGGER;
+	item.movetype = MOVETYPE_BOUNCE;
+	
+	if(self.weapon == IT_SUPER_SHOTGUN)
+	{
+		setmodel (item, "progs/g_shot.mdl");
+		item.weapon = IT_SUPER_SHOTGUN;
+		item.netname = "Double-barrelled Shotgun";
+		item.classname = "weapon_supershotgun";
+		self.items = self.items - IT_SUPER_SHOTGUN;
+	}
+
+	if( self.weapon == IT_NAILGUN )
+	{
+		setmodel (item, "progs/g_nail.mdl");
+		item.weapon = IT_NAILGUN;
+		item.netname = "nailgun";
+		item.classname = "weapon_nailgun";
+		self.items = self.items - IT_NAILGUN;
+	}
+		
+	if( self.weapon == IT_SUPER_NAILGUN)
+	{
+		setmodel (item, "progs/g_nail2.mdl");
+		item.weapon = IT_SUPER_NAILGUN;
+		item.netname = "Super Nailgun";
+		item.classname = "weapon_supernailgun";
+		self.items = self.items - IT_SUPER_NAILGUN;
+	}
+	
+	if( self.weapon == IT_GRENADE_LAUNCHER)
+	{
+		setmodel (item, "progs/g_rock.mdl");
+		item.weapon = 3;
+		item.netname = "Grenade Launcher";
+		item.classname = "weapon_grenadelauncher";
+		self.items = self.items - IT_GRENADE_LAUNCHER;
+	}
+	
+	if( self.weapon == IT_ROCKET_LAUNCHER )
+	{
+		setmodel (item, "progs/g_rock2.mdl");
+		item.weapon = 3;
+		item.netname = "Rocket Launcher";
+		item.classname = "weapon_rocketlauncher";
+		self.items = self.items - IT_ROCKET_LAUNCHER;
+	}
+	
+	if( self.weapon == IT_LIGHTNING )
+	{
+		setmodel (item, "progs/g_light.mdl");
+		item.weapon = 3;
+		item.netname = "Thunderbolt";
+		item.classname = "weapon_lightning";
+		self.items = self.items - IT_LIGHTNING;
+	}
+	setsize(item, '-16 -16 0', '16 16 56');
+	item.touch = Team_weapon_touch;
+	item.think = SUB_Remove;
+	item.nextthink = time + 120;
+	
+	self.weapon = W_BestWeapon();
+	W_SetCurrentAmmo();
+};
+
+void(entity flg) RegenFlag =
+{
+	flg.movetype = MOVETYPE_TOSS;
+	flg.solid = SOLID_TRIGGER;
+	sound (flg, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
+	setorigin(flg, flg.oldorigin);
+	flg.angles = flg.mangle;
+	flg.cnt = FLAG_AT_BASE; // it's at home base
+	flg.owner = world;
+};
+
+void(entity flg) TeamCaptureReturnFlag =
+{
+	local entity p;
+
+	RegenFlag(flg);
+
+	p = find(world, classname, "player");
+	while (p != world) {
+		if (p.team != flg.team)
+			TeamPlayerUpdate(p, "Enemy flag has been returned to base!");
+		else if (p.team == flg.team)
+			TeamPlayerUpdate(p, "Your flag has been returned to base!");
+		p = find(p, classname, "player");
+	}
+};
+
+void () TeamCaptureRegenFlags =
+{
+	local entity f;
+
+	f = find(world, classname, "item_flag_team1");
+	if (f != world)
+		RegenFlag(f);
+	f = find(world, classname, "item_flag_team2");
+	if (f != world)
+		RegenFlag(f);
+};
+
+void(entity flg) TeamDropFlag =
+{
+	local entity item, f, oself;
+	local entity p;
+
+	p = flg.owner;
+
+	bprint(p.netname);
+	if (p.lastteam == TEAM_COLOR1)
+		bprint("  the  flag!\n"); // blue
+	else
+		bprint("  the  flag!\n"); // red
+	LogMsg(p, "FLAG-DROP");
+
+	flg.origin = p.origin - '0 0 24';
+	flg.cnt = FLAG_DROPPED;
+	//NOTE! We check lastteam here instead of team--this is because
+	//in the mode where we change colors, we get killed
+	flg.velocity_z = 300;
+	flg.velocity_x = 0;
+	flg.velocity_y = 0;
+	flg.flags = FL_ITEM;
+	flg.solid = SOLID_TRIGGER;
+	flg.movetype = MOVETYPE_TOSS;
+	if (teamplay & TEAM_CAPTURE_CUSTOM)
+		setsize(flg, '-16 -16 0', '16 16 74');
+	else
+		setsize(flg, '-16 -16 -24', '16 16 32');
+	// return it after so long
+	flg.super_time = time + TEAM_CAPTURE_FLAG_RETURN_TIME;
+};
+
+void(entity player) TeamCaptureDropFlagOfPlayer =
+{
+	local string kn;
+	local entity e;
+
+	if (!(player.player_flag & ITEM_ENEMY_FLAG))
+		return;
+	if (player.lastteam == TEAM_COLOR1) 
+		kn = "item_flag_team2";
+	else
+		kn = "item_flag_team1";
+	player.player_flag = player.player_flag - ITEM_ENEMY_FLAG;
+	e = find(world, classname, kn);
+	if (e != world)
+		TeamDropFlag(e);
+};
+
+void() TeamCaptureFlagTouch =
+{
+	local entity p, oself;
+
+	if (other.classname != "player")
+		return;
+	if (other.health <= 0)
+		return;
+
+	if (other.team != other.lastteam)
+		return; // something is fishy, somebody is playing with colors
+
+	if (self.lastteam == other.lastteam) {
+		// same team, if the flag is *not* at the base, return
+		// it to base.  we overload the 'cnt' field for this
+		if (self.cnt == FLAG_AT_BASE) {
+			// the flag is at home base.  if the player has the enemy
+			// flag, he's just won!
+
+			if (other.player_flag & ITEM_ENEMY_FLAG) {
+				bprint(other.netname);
+				if (other.team == TEAM_COLOR1)
+					bprint("  the  flag!\n"); // blue
+				else
+					bprint("  the  flag!\n"); // red
+				LogMsg(other, "FLAG-CAPTURE");
+				other.items = other.items - (other.items & (IT_KEY1 | IT_KEY2));
+
+				if (cvar("teamplay") & TEAM_CAPTURE_CUSTOM)
+					sound (other, CHAN_VOICE, "misc/flagcap.wav", 1, ATTN_NONE);
+				else
+					sound (other, CHAN_VOICE, "doors/meduse.wav", 1, ATTN_NONE);
+
+				// other gets another 10 frag bonus
+				other.frags = other.frags + TEAM_CAPTURE_CAPTURE_BONUS;
+
+				// Ok, let's do the player loop, hand out the bonuses
+				p = find(world, classname, "player");
+				while (p != world) {
+					self = p;
+					self.killed = 0;
+					if (self.lastteam == other.lastteam && self != other)
+						self.frags = self.frags + TEAM_CAPTURE_TEAM_BONUS;
+					if (self.lastteam != other.lastteam) {
+						// *XXX* EXPERT CTF
+						// reset the last_hurt_carrier variable in all enemy players, so that you don't get
+						// bonuses for defending the flag carrier if the flag carrier has already
+						// completed a capture
+						self.last_hurt_carrier = -5;
+					} else if (self.lastteam == other.lastteam) {
+						// done to all players on the capturing team
+						// *XXX* EXPERT CTF
+	
+						// award extra points for capture assists
+						if (self.last_returned_flag + TEAM_CAPTURE_RETURN_FLAG_ASSIST_TIMEOUT > time) {
+							bprint(self.netname);
+							bprint(" gets an assist for returning his flag!\n");
+							self.frags = self.frags + TEAM_CAPTURE_RETURN_FLAG_ASSIST_BONUS;
+						}
+						if (self.last_fragged_carrier + TEAM_CAPTURE_FRAG_CARRIER_ASSIST_TIMEOUT > time) {
+							bprint(self.netname);
+							bprint(" gets an assist for fragging the flag carrier!\n");
+							self.frags = self.frags + TEAM_CAPTURE_FRAG_CARRIER_ASSIST_BONUS;
+						}
+					}
+					self.player_flag = self.player_flag - (self.player_flag & ITEM_ENEMY_FLAG);
+					
+					p = find(p, classname, "player");
+				}
+
+				TeamCaptureResetUpdate();
+				
+				p = find(world, classname, "player");
+				while (p != world) {
+					if ((p.lastteam == TEAM_COLOR1 && other.lastteam == TEAM_COLOR2) ||
+						(p.lastteam == TEAM_COLOR2 && other.lastteam == TEAM_COLOR1))
+						TeamPlayerUpdate(p, "Your flag was captured!");
+					else if (p.lastteam == other.lastteam)
+						TeamPlayerUpdate(p, "Your team captured the flag!");
+					p = find(p, classname, "player");
+				}
+				// respawn flags
+				TeamCaptureRegenFlags();
+				return;
+			}
+			return; // its at home base already
+		}	
+		// hey, its not home.  return it by teleporting it back
+		bprint(other.netname);
+		if (other.team == TEAM_COLOR1)
+			bprint("  the  flag!\n"); // red
+		else
+			bprint("  the  flag!\n"); // blue
+		LogMsg(other, "FLAG-RECOVERY");
+		other.frags = other.frags + TEAM_CAPTURE_RECOVERY_BONUS;
+		// *XXX* EXPERT CTF set time when player last returned his flag
+		other.last_returned_flag = time;
+		sound (other, CHAN_ITEM, self.noise1, 1, ATTN_NORM);
+		TeamCaptureReturnFlag(self);
+		return;
+	}
+
+	// hey, its not our flag, pick it up
+	bprint(other.netname);
+	if (other.team == TEAM_COLOR1)
+		bprint("  the  flag!\n"); // blue
+	else
+		bprint("  the  flag!\n"); // red
+	LogMsg(other, "FLAG-PICKUP");
+	if (TEAM_CAPTURE_FLAG_BONUS)
+		other.frags = other.frags + TEAM_CAPTURE_FLAG_BONUS;
+//	TeamPlayerUpdate(other, "YOU GOT THE ENEMY FLAG!  RETURN TO BASE!");
+	TeamPlayerUpdate(other, "        ");
+	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
+
+	other.player_flag = other.player_flag + ITEM_ENEMY_FLAG;
+	other.items = other.items | self.items;
+
+	// *XXX* EXPERT CTF set the time at which the carrier picked up the flag
+	other.flag_since = time;
+
+	// pick up the flag
+	self.cnt = FLAG_CARRIED;
+	self.movetype = MOVETYPE_NOCLIP;
+	self.solid = SOLID_NOT;
+	self.owner = other;
+
+	p = find(world, classname, "player");
+	while (p != world) {
+		if (p != other) {
+			if ((p.team == TEAM_COLOR1 && other.team == TEAM_COLOR2) ||
+				(p.team == TEAM_COLOR2 && other.team == TEAM_COLOR1))
+				TeamPlayerUpdate(p, "Your flag has been taken!");
+			else if (p.team == other.team)
+				TeamPlayerUpdate(p, "Your team has the enemy flag!");
+		}
+		p = find(p, classname, "player");
+	}
+};
+
+void() TeamCaptureFlagThink =
+{
+	local entity e;
+	local vector v;
+	local float f;
+	local string s;
+
+	self.nextthink = time + 0.1;
+
+	if (self.cnt == FLAG_AT_BASE)
+		return; // just sitting around waiting to be picked up
+
+	if (self.cnt == FLAG_DROPPED) {
+		if (time - self.super_time > TEAM_CAPTURE_FLAG_RETURN_TIME)
+			TeamCaptureReturnFlag(self);
+		return;
+	}
+
+	if (self.cnt != FLAG_CARRIED)
+		objerror("Flag in invalid state\n");
+
+	e = self.owner;
+	if ((e.classname != "player") || (e.deadflag) ||
+		(!(e.player_flag & ITEM_ENEMY_FLAG))) {
+		TeamDropFlag(self);
+		return;
+	}
+	makevectors (e.angles);
+	v = v_forward;
+//dprint("fwd: ");
+//s = vtos(v);
+//dprint(s);
+//dprint("\n");
+//	if (v_z < 0) { 
+//		v_z = (-1)*v_z; 
+//		v = v + v * 1.2 * v_z; 
+//	}
+//dprint("adj: ");
+//s = vtos(v);
+//dprint(s);
+//dprint("\n");
+	v_z = (-1) * v_z; // reverse z component
+
+	f = 14;
+	if (self.owner.frame >= 29 && self.owner.frame <= 40) {
+		if (self.owner.frame >= 29 && self.owner.frame <= 34) { //axpain
+			if      (self.owner.frame == 29) f = f + 2; 
+			else if (self.owner.frame == 30) f = f + 8;
+			else if (self.owner.frame == 31) f = f + 12;
+			else if (self.owner.frame == 32) f = f + 11;
+			else if (self.owner.frame == 33) f = f + 10;
+			else if (self.owner.frame == 34) f = f + 4;
+		} else if (self.owner.frame >= 35 && self.owner.frame <= 40) { // pain
+			if      (self.owner.frame == 35) f = f + 2; 
+			else if (self.owner.frame == 36) f = f + 10;
+			else if (self.owner.frame == 37) f = f + 10;
+			else if (self.owner.frame == 38) f = f + 8;
+			else if (self.owner.frame == 39) f = f + 4;
+			else if (self.owner.frame == 40) f = f + 2;
+		}
+	} else if (self.owner.frame >= 103 && self.owner.frame <= 118) {
+		if      (self.owner.frame >= 103 && self.owner.frame <= 104) f = f + 6;  //nailattack
+		else if (self.owner.frame >= 105 && self.owner.frame <= 106) f = f + 6;  //light 
+		else if (self.owner.frame >= 107 && self.owner.frame <= 112) f = f + 7;  //rocketattack
+		else if (self.owner.frame >= 112 && self.owner.frame <= 118) f = f + 7;  //shotattack
+	}
+	self.origin = e.origin + '0 0 -16' - f*v + v_right * 22;
+	self.angles = e.angles + '0 0 -45';
+	setorigin (self, self.origin);
+	self.nextthink = time + 0.01;
+};
+
+// self is player
+entity() TeamCaptureSpawn =
+{
+	if (self.team == TEAM_COLOR1) {
+		team1_lastspawn = find(team1_lastspawn, classname, "info_player_team1");
+		if (team1_lastspawn == world)
+			team1_lastspawn = find(team1_lastspawn, classname, "info_player_team1");
+		return team1_lastspawn;
+	} else if (self.team == TEAM_COLOR2) {
+		team2_lastspawn = find(team2_lastspawn, classname, "info_player_team2");
+		if (team2_lastspawn == world)
+			team2_lastspawn = find(team2_lastspawn, classname, "info_player_team2");
+		return team2_lastspawn;
+	}
+	return world;
+};
+
+/*
+	From byron@caseware.com Wed Oct 16 18:57:44 1996
+	Date: Wed, 16 Oct 1996 21:22:37 -0400
+	From: Byron Long <byron@caseware.com>
+	To: zoid@mindlink.net
+	Subject: Team Status Command (source code included) :-)
+
+	A co-worker of mine wondered if it was possible to add a function to
+	your capture the flag code that would give a status report on an
+	impulse. I think he may have mailed you, but I wrote a quick version
+	myself, which your welcome to use if you like the feature (it offsets
+	some of the problems with the chat capabilities in Quake so it seems
+	like a worthwhile feature). Feel free to change it
+	as necessary.
+*/
+
+// *Capture The Flag - Status report by Wonko
+void() TeamFlagStatusReport =
+{
+	local entity flag1, flag2, p;
+
+	// Find the flags at home base
+	flag1 = find (world,classname, "item_flag_team1");
+	flag2 = find (world,classname, "item_flag_team2");
+
+	// If on team 2 switch meanings of flags
+	if (self.team != TEAM_COLOR1) {
+		p = flag1;
+		flag1 = flag2;
+		flag2 = p;
+	}
+
+	if (flag1 != world && flag1.cnt == FLAG_CARRIED) {
+		sprint(self, flag1.owner.netname);
+		sprint(self, " has your flag. ");
+	} else {
+		sprint(self, "Your flag is ");
+		if (flag1 == world)
+			sprint(self, "missing! ");
+		if (flag1.cnt == FLAG_AT_BASE)
+			sprint(self, "in your base. ");
+		else if (flag1.cnt == FLAG_DROPPED)
+			sprint(self, "lying about. ");
+		else
+			sprint(self, " corrupt. ");
+	}
+
+	if (flag2 != world && flag2.cnt == FLAG_CARRIED) {
+		if (self == flag2.owner) 
+			sprint(self, "You have the enemy flag.\n");
+		else {
+			sprint(self, flag2.owner.netname);
+			sprint(self, " has the enemy flag.\n");
+		}
+	} else {
+		sprint(self, "The enemy flag is ");
+		if (flag2 == world)
+			sprint(self, "missing!\n");
+		if (flag2.cnt == FLAG_AT_BASE)
+			sprint(self, "in their base.\n");
+		else if (flag2.cnt == FLAG_DROPPED)
+			sprint(self, "lying about.\n");
+		else
+			sprint(self, " corrupt.\n");
+	}
+};
+
+/////////////////////////////////////////////////////////////////////////
+
+$cd id1/models/flag
+$base base
+$skin skin
+
+void() place_flag = {
+	self.mdl = self.model;		// so it can be restored on respawn
+	self.flags = FL_ITEM;		// make extra wide
+	self.solid = SOLID_TRIGGER;
+	self.movetype = MOVETYPE_TOSS;	
+	self.velocity = '0 0 0';
+	self.origin_z = self.origin_z + 6;
+	self.think = TeamCaptureFlagThink;
+	self.touch = TeamCaptureFlagTouch;
+	self.nextthink = time + 0.1;
+	self.cnt = FLAG_AT_BASE;
+	self.mangle = self.angles;
+	self.effects = self.effects | EF_DIMLIGHT;
+	if (!droptofloor()) {
+		dprint ("Flag fell out of level at ");
+		dprint (vtos(self.origin));
+		dprint ("\n");
+		remove(self);
+		return;
+	}
+	self.oldorigin = self.origin; // save for flag return
+};
+
+// ZOID Capture the flag
+void() item_flag_team1 =
+{
+	self.team = TEAM_COLOR1;
+	self.lastteam = TEAM_COLOR1;
+	self.items = IT_KEY2;
+	if (cvar("teamplay") & TEAM_CAPTURE_CUSTOM) {
+		precache_model ("progs/flag.mdl");
+		setmodel (self, "progs/flag.mdl");
+		self.skin = 0;
+		precache_sound ("misc/flagtk.wav");			// flag taken
+		precache_sound ("misc/flagcap.wav");			// flag capture
+		precache_sound ("doors/runetry.wav");
+		self.noise = "misc/flagtk.wav";
+		self.noise1 = "doors/runetry.wav";
+		setsize(self, '-16 -16 0', '16 16 74');
+	} else {
+		precache_model ("progs/w_g_key.mdl");
+		setmodel (self, "progs/w_g_key.mdl");
+		precache_sound ("misc/medkey.wav");
+		precache_sound ("doors/meduse.wav");
+		precache_sound ("doors/runetry.wav");
+		self.noise = "misc/medkey.wav";
+		self.noise1 = "doors/runetry.wav";
+		self.origin_z = self.origin_z + 24;
+		setsize(self, '-16 -16 -24', '16 16 32');
+	}
+	self.nextthink = time + 0.2;	// items start after other solids
+	self.think = place_flag;
+};
+
+void() item_flag_team2 =
+{
+	self.team = TEAM_COLOR2;
+	self.lastteam = TEAM_COLOR2;
+	self.items = IT_KEY1;
+	if (cvar("teamplay") & TEAM_CAPTURE_CUSTOM) {
+		precache_model ("progs/flag.mdl");
+		setmodel (self, "progs/flag.mdl");
+		self.skin = 1;
+		precache_sound ("misc/flagtk.wav");			// flag taken
+		precache_sound ("misc/flagcap.wav");			// flag capture
+		precache_sound ("doors/runetry.wav");
+		self.noise = "misc/flagtk.wav";
+		self.noise1 = "doors/runetry.wav";
+		setsize(self, '-16 -16 0', '16 16 74');
+	} else {
+		precache_model ("progs/w_s_key.mdl");
+		setmodel (self, "progs/w_s_key.mdl");
+		precache_sound ("misc/medkey.wav");
+		precache_sound ("doors/meduse.wav");
+		precache_sound ("doors/runetry.wav");
+		self.noise = "misc/medkey.wav";
+		self.noise1 = "doors/runetry.wav";
+		self.origin_z = self.origin_z + 24;
+		setsize(self, '-16 -16 -24', '16 16 32');
+	}
+	// make it glow
+	self.nextthink = time + 0.2;	// items start after other solids
+	self.think = place_flag;
+};
+
+
+/*QUAKED func_ctf_wall (0 .5 .8) ?
+This is just a solid wall if not inhibitted
+Only appears in CTF teamplay
+*/
+void() func_ctf_wall =
+{
+	self.angles = '0 0 0';
+	self.movetype = MOVETYPE_PUSH;	// so it doesn't get pushed by anything
+	self.solid = SOLID_BSP;
+	setmodel (self, self.model);
+};
+
+
+void() InitBodyQue;
+
+
+void() main =
+{
+	dprint ("main function\n");
+	
+// these are just commands the the prog compiler to copy these files
+
+	precache_file ("progs.dat");
+	precache_file ("gfx.wad");
+	precache_file ("quake.rc");
+	precache_file ("default.cfg");
+
+	precache_file ("end1.bin");
+	precache_file2 ("end2.bin");
+
+	precache_file ("demo1.dem");
+	precache_file ("demo2.dem");
+	precache_file ("demo3.dem");
+
+//
+// these are all of the lumps from the cached.ls files
+//
+	precache_file ("gfx/palette.lmp");
+	precache_file ("gfx/colormap.lmp");
+
+	precache_file2 ("gfx/pop.lmp");
+
+	precache_file ("gfx/complete.lmp");
+	precache_file ("gfx/inter.lmp");
+
+	precache_file ("gfx/ranking.lmp");
+	precache_file ("gfx/vidmodes.lmp");
+	precache_file ("gfx/finale.lmp");
+	precache_file ("gfx/conback.lmp");
+	precache_file ("gfx/qplaque.lmp");
+
+	precache_file ("gfx/menudot1.lmp");
+	precache_file ("gfx/menudot2.lmp");
+	precache_file ("gfx/menudot3.lmp");
+	precache_file ("gfx/menudot4.lmp");
+	precache_file ("gfx/menudot5.lmp");
+	precache_file ("gfx/menudot6.lmp");
+
+	precache_file ("gfx/menuplyr.lmp");
+	precache_file ("gfx/bigbox.lmp");
+	precache_file ("gfx/dim_modm.lmp");
+	precache_file ("gfx/dim_drct.lmp");
+	precache_file ("gfx/dim_ipx.lmp");
+	precache_file ("gfx/dim_tcp.lmp");
+	precache_file ("gfx/dim_mult.lmp");
+	precache_file ("gfx/mainmenu.lmp");
+	
+	precache_file ("gfx/box_tl.lmp");
+	precache_file ("gfx/box_tm.lmp");
+	precache_file ("gfx/box_tr.lmp");
+	
+	precache_file ("gfx/box_ml.lmp");
+	precache_file ("gfx/box_mm.lmp");
+	precache_file ("gfx/box_mm2.lmp");
+	precache_file ("gfx/box_mr.lmp");
+	
+	precache_file ("gfx/box_bl.lmp");
+	precache_file ("gfx/box_bm.lmp");
+	precache_file ("gfx/box_br.lmp");
+	
+	precache_file ("gfx/sp_menu.lmp");
+	precache_file ("gfx/ttl_sgl.lmp");
+	precache_file ("gfx/ttl_main.lmp");
+	precache_file ("gfx/ttl_cstm.lmp");
+	
+	precache_file ("gfx/mp_menu.lmp");
+	
+	precache_file ("gfx/netmen1.lmp");
+	precache_file ("gfx/netmen2.lmp");
+	precache_file ("gfx/netmen3.lmp");
+	precache_file ("gfx/netmen4.lmp");
+	precache_file ("gfx/netmen5.lmp");
+	
+	precache_file ("gfx/sell.lmp");
+	
+	precache_file ("gfx/help0.lmp");
+	precache_file ("gfx/help1.lmp");
+	precache_file ("gfx/help2.lmp");
+	precache_file ("gfx/help3.lmp");
+	precache_file ("gfx/help4.lmp");
+	precache_file ("gfx/help5.lmp");
+
+	precache_file ("gfx/pause.lmp");
+	precache_file ("gfx/loading.lmp");
+
+	precache_file ("gfx/p_option.lmp");
+	precache_file ("gfx/p_load.lmp");
+	precache_file ("gfx/p_save.lmp");
+	precache_file ("gfx/p_multi.lmp");
+
+// sounds loaded by C code
+	precache_sound ("misc/menu1.wav");
+	precache_sound ("misc/menu2.wav");
+	precache_sound ("misc/menu3.wav");
+
+	precache_sound ("ambience/water1.wav");
+	precache_sound ("ambience/wind2.wav");
+
+// shareware
+	precache_file ("maps/start.bsp");
+
+	precache_file ("maps/e1m1.bsp");
+	precache_file ("maps/e1m2.bsp");
+	precache_file ("maps/e1m3.bsp");
+	precache_file ("maps/e1m4.bsp");
+	precache_file ("maps/e1m5.bsp");
+	precache_file ("maps/e1m6.bsp");
+	precache_file ("maps/e1m7.bsp");
+	precache_file ("maps/e1m8.bsp");
+
+// registered
+	precache_file2 ("gfx/pop.lmp");
+
+	precache_file2 ("maps/e2m1.bsp");
+	precache_file2 ("maps/e2m2.bsp");
+	precache_file2 ("maps/e2m3.bsp");
+	precache_file2 ("maps/e2m4.bsp");
+	precache_file2 ("maps/e2m5.bsp");
+	precache_file2 ("maps/e2m6.bsp");
+	precache_file2 ("maps/e2m7.bsp");
+
+	precache_file2 ("maps/e3m1.bsp");
+	precache_file2 ("maps/e3m2.bsp");
+	precache_file2 ("maps/e3m3.bsp");
+	precache_file2 ("maps/e3m4.bsp");
+	precache_file2 ("maps/e3m5.bsp");
+	precache_file2 ("maps/e3m6.bsp");
+	precache_file2 ("maps/e3m7.bsp");
+
+	precache_file2 ("maps/e4m1.bsp");
+	precache_file2 ("maps/e4m2.bsp");
+	precache_file2 ("maps/e4m3.bsp");
+	precache_file2 ("maps/e4m4.bsp");
+	precache_file2 ("maps/e4m5.bsp");
+	precache_file2 ("maps/e4m6.bsp");
+	precache_file2 ("maps/e4m7.bsp");
+	precache_file2 ("maps/e4m8.bsp");
+
+	precache_file2 ("maps/end.bsp");
+
+	precache_file2 ("maps/dm1.bsp");
+	precache_file2 ("maps/dm2.bsp");
+	precache_file2 ("maps/dm3.bsp");
+	precache_file2 ("maps/dm4.bsp");
+	precache_file2 ("maps/dm5.bsp");
+	precache_file2 ("maps/dm6.bsp");
+};
+
+
+entity	lastspawn;
+
+//=======================
+/*QUAKED worldspawn (0 0 0) ?
+Only used for the world entity.
+Set message to the level name.
+Set sounds to the cd track to play.
+
+World Types:
+0: medieval
+1: metal
+2: base
+*/
+//=======================
+void() worldspawn =
+{
+	lastspawn = world;
+	runespawn = world;
+	runespawned = 0;
+	InitBodyQue ();
+
+// custom map attributes
+	if (self.model == "maps/e1m8.bsp")
+		cvar_set ("sv_gravity", "100");
+	else
+		cvar_set ("sv_gravity", "800");
+
+	if (self.model == "maps/ctfstart.bsp" || self.model == "maps/start.bsp")
+		gamestart = 1;
+	else
+		gamestart = 0;
+
+// the area based ambient sounds MUST be the first precache_sounds
+
+// player precaches	
+	W_Precache ();			// get weapon precaches
+
+// sounds used from C physics code
+	precache_sound ("demon/dland2.wav");		// landing thud
+	precache_sound ("misc/h2ohit1.wav");		// landing splash
+
+// setup precaches allways needed
+	precache_sound ("items/itembk2.wav");		// item respawn sound
+	precache_sound ("player/plyrjmp8.wav");		// player jump
+	precache_sound ("player/land.wav");			// player landing
+	precache_sound ("player/land2.wav");		// player hurt landing
+	precache_sound ("player/drown1.wav");		// drowning pain
+	precache_sound ("player/drown2.wav");		// drowning pain
+	precache_sound ("player/gasp1.wav");		// gasping for air
+	precache_sound ("player/gasp2.wav");		// taking breath
+	precache_sound ("player/h2odeath.wav");		// drowning death
+
+	precache_sound ("misc/talk.wav");			// talk
+	precache_sound ("player/teledth1.wav");		// telefrag
+	precache_sound ("misc/r_tele1.wav");		// teleport sounds
+	precache_sound ("misc/r_tele2.wav");
+	precache_sound ("misc/r_tele3.wav");
+	precache_sound ("misc/r_tele4.wav");
+	precache_sound ("misc/r_tele5.wav");
+	precache_sound ("weapons/lock4.wav");		// ammo pick up
+	precache_sound ("weapons/pkup.wav");		// weapon up
+	precache_sound ("items/armor1.wav");		// armor up
+	precache_sound ("weapons/lhit.wav");		//lightning
+	precache_sound ("weapons/lstart.wav");		//lightning start
+	precache_sound ("items/damage3.wav");
+
+	precache_sound ("misc/power.wav");			//lightning for boss
+
+// player gib sounds
+	precache_sound ("player/gib.wav");			// player gib sound
+	precache_sound ("player/udeath.wav");		// player gib sound
+	precache_sound ("player/tornoff2.wav");		// gib sound
+
+// player pain sounds
+
+	precache_sound ("player/pain1.wav");
+	precache_sound ("player/pain2.wav");
+	precache_sound ("player/pain3.wav");
+	precache_sound ("player/pain4.wav");
+	precache_sound ("player/pain5.wav");
+	precache_sound ("player/pain6.wav");
+
+// player death sounds
+	precache_sound ("player/death1.wav");
+	precache_sound ("player/death2.wav");
+	precache_sound ("player/death3.wav");
+	precache_sound ("player/death4.wav");
+	precache_sound ("player/death5.wav");
+
+// ax sounds	
+	precache_sound ("weapons/ax1.wav");			// ax swoosh
+	precache_sound ("player/axhit1.wav");		// ax hit meat
+	precache_sound ("player/axhit2.wav");		// ax hit world
+	precache_sound ("hknight/hit.wav");			// ZOID: hook launch
+
+	precache_sound ("player/h2ojump.wav");		// player jumping into water
+	precache_sound ("player/slimbrn2.wav");		// player enter slime
+	precache_sound ("player/inh2o.wav");		// player enter water
+	precache_sound ("player/inlava.wav");		// player enter lava
+	precache_sound ("misc/outwater.wav");		// leaving water sound
+
+	precache_sound ("player/lburn1.wav");		// lava burn
+	precache_sound ("player/lburn2.wav");		// lava burn
+
+	precache_sound ("misc/water1.wav");			// swimming
+	precache_sound ("misc/water2.wav");			// swimming
+
+	precache_model ("progs/player.mdl");
+	precache_model ("progs/h_player.mdl");
+
+	precache_model ("progs/eyes.mdl");
+	precache_model ("progs/gib1.mdl");
+	precache_model ("progs/gib2.mdl");
+	precache_model ("progs/gib3.mdl");
+
+	precache_model ("progs/s_bubble.spr");	// drowning bubbles
+	precache_model ("progs/s_explod.spr");	// sprite explosion
+
+	precache_model ("progs/v_axe.mdl");
+	precache_model ("progs/v_shot.mdl");
+	precache_model ("progs/v_nail.mdl");
+	precache_model ("progs/v_rock.mdl");
+	precache_model ("progs/v_shot2.mdl");
+	precache_model ("progs/v_nail2.mdl");
+	precache_model ("progs/v_rock2.mdl");
+
+	precache_model ("progs/bolt.mdl");		// for lightning gun
+	precache_model ("progs/bolt2.mdl");		// for lightning gun
+	precache_model ("progs/bolt3.mdl");		// for boss shock
+	precache_model ("progs/lavaball.mdl");	// for testing
+	
+	precache_model ("progs/missile.mdl");
+	precache_model ("progs/grenade.mdl");
+	precache_model ("progs/spike.mdl");
+	precache_model ("progs/s_spike.mdl");
+
+// for hook
+	if (cvar("teamplay") & TEAM_CAPTURE_CUSTOM) {
+		precache_model ("progs/star.mdl");
+		precache_model ("progs/bit.mdl");
+		precache_model ("progs/v_star.mdl");
+	} else
+		precache_model ("progs/v_spike.mdl");
+
+	precache_model ("progs/backpack.mdl");
+
+	precache_model ("progs/zom_gib.mdl");
+
+	precache_model ("progs/v_light.mdl");
+
+//
+// Setup light animation tables. 'a' is total darkness, 'z' is maxbright.
+//
+
+	// 0 normal
+	lightstyle(0, "m");
+	
+	// 1 FLICKER (first variety)
+	lightstyle(1, "mmnmmommommnonmmonqnmmo");
+	
+	// 2 SLOW STRONG PULSE
+	lightstyle(2, "abcdefghijklmnopqrstuvwxyzyxwvutsrqponmlkjihgfedcba");
+	
+	// 3 CANDLE (first variety)
+	lightstyle(3, "mmmmmaaaaammmmmaaaaaabcdefgabcdefg");
+	
+	// 4 FAST STROBE
+	lightstyle(4, "mamamamamama");
+	
+	// 5 GENTLE PULSE 1
+	lightstyle(5,"jklmnopqrstuvwxyzyxwvutsrqponmlkj");
+	
+	// 6 FLICKER (second variety)
+	lightstyle(6, "nmonqnmomnmomomno");
+	
+	// 7 CANDLE (second variety)
+	lightstyle(7, "mmmaaaabcdefgmmmmaaaammmaamm");
+	
+	// 8 CANDLE (third variety)
+	lightstyle(8, "mmmaaammmaaammmabcdefaaaammmmabcdefmmmaaaa");
+	
+	// 9 SLOW STROBE (fourth variety)
+	lightstyle(9, "aaaaaaaazzzzzzzz");
+	
+	// 10 FLUORESCENT FLICKER
+	lightstyle(10, "mmamammmmammamamaaamammma");
+
+	// 11 SLOW PULSE NOT FADE TO BLACK
+	lightstyle(11, "abcdefghijklmnopqrrqponmlkjihgfedcba");
+	
+	// styles 32-62 are assigned by the light program for switchable lights
+
+	// 63 testing
+	lightstyle(63, "a");
+};
+
+void() StartFrame =
+{
+	teamplay = cvar("teamplay");
+	skill = cvar("skill");
+	framecount = framecount + 1;
+};
+
+/*
+==============================================================================
+
+BODY QUE
+
+==============================================================================
+*/
+
+entity	bodyque_head;
+
+void() bodyque =
+{	// just here so spawn functions don't complain after the world
+	// creates bodyques
+};
+
+void() InitBodyQue =
+{
+	local entity	e;
+	
+	bodyque_head = spawn();
+	bodyque_head.classname = "bodyque";
+	bodyque_head.owner = spawn();
+	bodyque_head.owner.classname = "bodyque";
+	bodyque_head.owner.owner = spawn();
+	bodyque_head.owner.owner.classname = "bodyque";
+	bodyque_head.owner.owner.owner = spawn();
+	bodyque_head.owner.owner.owner.classname = "bodyque";
+	bodyque_head.owner.owner.owner.owner = bodyque_head;
+};
+
+
+// make a body que entry for the given ent so the ent can be
+// respawned elsewhere
+void(entity ent) CopyToBodyQue =
+{
+	bodyque_head.skin = ent.skin;
+	bodyque_head.angles = ent.angles;
+	bodyque_head.model = ent.model;
+	bodyque_head.modelindex = ent.modelindex;
+	bodyque_head.frame = ent.frame;
+	bodyque_head.colormap = ent.colormap;
+	bodyque_head.movetype = ent.movetype;
+	bodyque_head.velocity = ent.velocity;
+	bodyque_head.flags = 0;
+	setorigin (bodyque_head, ent.origin);
+	setsize (bodyque_head, ent.mins, ent.maxs);
+	bodyque_head = bodyque_head.owner;
+};
+
+
+
+
+void() plat_center_touch;
+void() plat_outside_touch;
+void() plat_trigger_use;
+void() plat_go_up;
+void() plat_go_down;
+void() plat_crush;
+float PLAT_LOW_TRIGGER = 1;
+
+void() plat_spawn_inside_trigger =
+{
+	local entity	trigger;
+	local vector	tmin, tmax;
+
+//
+// middle trigger
+//	
+	trigger = spawn();
+	trigger.touch = plat_center_touch;
+	trigger.movetype = MOVETYPE_NONE;
+	trigger.solid = SOLID_TRIGGER;
+	trigger.enemy = self;
+	
+	tmin = self.mins + '25 25 0';
+	tmax = self.maxs - '25 25 -8';
+	tmin_z = tmax_z - (self.pos1_z - self.pos2_z + 8);
+	if (self.spawnflags & PLAT_LOW_TRIGGER)
+		tmax_z = tmin_z + 8;
+	
+	if (self.size_x <= 50)
+	{
+		tmin_x = (self.mins_x + self.maxs_x) / 2;
+		tmax_x = tmin_x + 1;
+	}
+	if (self.size_y <= 50)
+	{
+		tmin_y = (self.mins_y + self.maxs_y) / 2;
+		tmax_y = tmin_y + 1;
+	}
+	
+	setsize (trigger, tmin, tmax);
+};
+
+void() plat_hit_top =
+{
+	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
+	self.state = STATE_TOP;
+	self.think = plat_go_down;
+	self.nextthink = self.ltime + 3;
+};
+
+void() plat_hit_bottom =
+{
+	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
+	self.state = STATE_BOTTOM;
+};
+
+void() plat_go_down =
+{
+	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+	self.state = STATE_DOWN;
+	SUB_CalcMove (self.pos2, self.speed, plat_hit_bottom);
+};
+
+void() plat_go_up =
+{
+	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+	self.state = STATE_UP;
+	SUB_CalcMove (self.pos1, self.speed, plat_hit_top);
+};
+
+void() plat_center_touch =
+{
+	if (other.classname != "player")
+		return;
+		
+	if (other.health <= 0)
+		return;
+
+	self = self.enemy;
+
+
+	if (self.state == STATE_BOTTOM) {
+		if (self.cnt > time)
+			return; // delay until going up again
+		plat_go_up ();
+		return;
+	}
+//	else if (self.state == STATE_TOP)
+//		self.nextthink = self.ltime + 1;	// delay going down
+	self.cnt = time + 2;
+};
+
+void() plat_outside_touch =
+{
+	if (other.classname != "player")
+		return;
+
+	if (other.health <= 0)
+		return;
+		
+	self = self.enemy;
+	if (self.state == STATE_TOP)
+		plat_go_down ();
+};
+
+void() plat_trigger_use =
+{
+	if (self.think)
+		return;		// allready activated
+	plat_go_down();
+};
+
+
+void() plat_crush =
+{
+	T_Damage (other, self, self, 1);
+	
+	if (self.state == STATE_UP)
+		plat_go_down ();
+	else if (self.state == STATE_DOWN)
+		plat_go_up ();
+	else
+		objerror ("plat_crush: bad self.state\n");
+};
+
+void() plat_use =
+{
+	self.use = SUB_Null;
+	if (self.state != STATE_UP)
+		objerror ("plat_use: not in up state");
+	plat_go_down();
+};
+
+
+/*QUAKED func_plat (0 .5 .8) ? PLAT_LOW_TRIGGER
+speed	default 150
+
+Plats are always drawn in the extended position, so they will light correctly.
+
+If the plat is the target of another trigger or button, it will start out disabled in the extended position until it is trigger, when it will lower and become a normal plat.
+
+If the "height" key is set, that will determine the amount the plat moves, instead of being implicitly determined by the model's height.
+Set "sounds" to one of the following:
+1) base fast
+2) chain slow
+*/
+
+
+void() func_plat =
+
+{
+local entity t;
+
+	if (!self.t_length)
+		self.t_length = 80;
+	if (!self.t_width)
+		self.t_width = 10;
+
+	if (self.sounds == 0)
+		self.sounds = 2;
+// FIX THIS TO LOAD A GENERIC PLAT SOUND
+
+	if (self.sounds == 1)
+	{
+		precache_sound ("plats/plat1.wav");
+		precache_sound ("plats/plat2.wav");
+		self.noise = "plats/plat1.wav";
+		self.noise1 = "plats/plat2.wav";
+	}
+
+	if (self.sounds == 2)
+	{
+		precache_sound ("plats/medplat1.wav");
+		precache_sound ("plats/medplat2.wav");
+		self.noise = "plats/medplat1.wav";
+		self.noise1 = "plats/medplat2.wav";
+	}
+
+
+	self.mangle = self.angles;
+	self.angles = '0 0 0';
+
+	self.classname = "plat";
+	self.solid = SOLID_BSP;
+	self.movetype = MOVETYPE_PUSH;
+	setorigin (self, self.origin);	
+	setmodel (self, self.model);
+	setsize (self, self.mins , self.maxs);
+
+	self.blocked = plat_crush;
+	if (!self.speed)
+		self.speed = 150;
+
+// pos1 is the top position, pos2 is the bottom
+	self.pos1 = self.origin;
+	self.pos2 = self.origin;
+	if (self.height)
+		self.pos2_z = self.origin_z - self.height;
+	else
+		self.pos2_z = self.origin_z - self.size_z + 8;
+
+	self.use = plat_trigger_use;
+
+	plat_spawn_inside_trigger ();	// the "start moving" trigger	
+
+	if (self.targetname)
+	{
+		self.state = STATE_UP;
+		self.use = plat_use;
+	}
+	else
+	{
+		setorigin (self, self.pos2);
+		self.state = STATE_BOTTOM;
+	}
+};
+
+//============================================================================
+
+void() train_next;
+void() func_train_find;
+
+void() train_blocked =
+{
+	if (time < self.attack_finished)
+		return;
+	self.attack_finished = time + 0.5;
+	T_Damage (other, self, self, self.dmg);
+};
+void() train_use =
+{
+	if (self.think != func_train_find)
+		return;		// already activated
+	train_next();
+};
+
+void() train_wait =
+{
+	if (self.wait)
+	{
+		self.nextthink = self.ltime + self.wait;
+		sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+	}
+	else
+		self.nextthink = self.ltime + 0.1;
+	
+	self.think = train_next;
+};
+
+void() train_next =
+{
+	local entity	targ;
+
+	targ = find (world, targetname, self.target);
+	self.target = targ.target;
+	if (!self.target)
+		objerror ("train_next: no next target");
+	if (targ.wait)
+		self.wait = targ.wait;
+	else
+		self.wait = 0;
+	sound (self, CHAN_VOICE, self.noise1, 1, ATTN_NORM);
+	SUB_CalcMove (targ.origin - self.mins, self.speed, train_wait);
+};
+
+void() func_train_find =
+
+{
+	local entity	targ;
+
+	targ = find (world, targetname, self.target);
+	self.target = targ.target;
+	setorigin (self, targ.origin - self.mins);
+	if (!self.targetname)
+	{	// not triggered, so start immediately
+		self.nextthink = self.ltime + 0.1;
+		self.think = train_next;
+	}
+};
+
+/*QUAKED func_train (0 .5 .8) ?
+Trains are moving platforms that players can ride.
+The targets origin specifies the min point of the train at each corner.
+The train spawns at the first target it is pointing at.
+If the train is the target of a button or trigger, it will not begin moving until activated.
+speed	default 100
+dmg		default	2
+sounds
+1) ratchet metal
+
+*/
+void() func_train =
+{	
+	if (!self.speed)
+		self.speed = 100;
+	if (!self.target)
+		objerror ("func_train without a target");
+	if (!self.dmg)
+		self.dmg = 2;
+
+	if (self.sounds == 0)
+	{
+		self.noise = ("misc/null.wav");
+		precache_sound ("misc/null.wav");
+		self.noise1 = ("misc/null.wav");
+		precache_sound ("misc/null.wav");
+	}
+
+	if (self.sounds == 1)
+	{
+		self.noise = ("plats/train2.wav");
+		precache_sound ("plats/train2.wav");
+		self.noise1 = ("plats/train1.wav");
+		precache_sound ("plats/train1.wav");
+	}
+
+	self.cnt = 1;
+	self.solid = SOLID_BSP;
+	self.movetype = MOVETYPE_PUSH;
+	self.blocked = train_blocked;
+	self.use = train_use;
+	self.classname = "train";
+
+	setmodel (self, self.model);
+	setsize (self, self.mins , self.maxs);
+	setorigin (self, self.origin);
+
+// start trains on the second frame, to make sure their targets have had
+// a chance to spawn
+	self.nextthink = self.ltime + 0.1;
+	self.think = func_train_find;
+};
+
+/*QUAKED misc_teleporttrain (0 .5 .8) (-8 -8 -8) (8 8 8)
+This is used for the final bos
+*/
+void() misc_teleporttrain =
+{	
+	if (!self.speed)
+		self.speed = 100;
+	if (!self.target)
+		objerror ("func_train without a target");
+
+	self.cnt = 1;
+	self.solid = SOLID_NOT;
+	self.movetype = MOVETYPE_PUSH;
+	self.blocked = train_blocked;
+	self.use = train_use;
+	self.avelocity = '100 200 300';
+
+	self.noise = ("misc/null.wav");
+	precache_sound ("misc/null.wav");
+	self.noise1 = ("misc/null.wav");
+	precache_sound ("misc/null.wav");
+
+	precache_model2 ("progs/teleport.mdl");
+	setmodel (self, "progs/teleport.mdl");
+	setsize (self, self.mins , self.maxs);
+	setorigin (self, self.origin);
+
+// start trains on the second frame, to make sure their targets have had
+// a chance to spawn
+	self.nextthink = self.ltime + 0.1;
+	self.think = func_train_find;
+};
+
+
+void() bubble_bob;
+void() W_FireChain;
+void() player_chain5;
+void() player_chain4;
+
+/*
+==============================================================================
+
+PLAYER
+
+==============================================================================
+*/
+
+$cd id1/models/player_4
+$origin 0 -6 24
+$base base		
+$skin skin
+
+//
+// running
+//
+$frame axrun1 axrun2 axrun3 axrun4 axrun5 axrun6
+
+$frame rockrun1 rockrun2 rockrun3 rockrun4 rockrun5 rockrun6
+
+//
+// standing
+//
+$frame stand1 stand2 stand3 stand4 stand5
+
+$frame axstnd1 axstnd2 axstnd3 axstnd4 axstnd5 axstnd6
+$frame axstnd7 axstnd8 axstnd9 axstnd10 axstnd11 axstnd12
+
+
+//
+// pain
+//
+$frame axpain1 axpain2 axpain3 axpain4 axpain5 axpain6
+
+$frame pain1 pain2 pain3 pain4 pain5 pain6
+
+
+//
+// death
+//
+
+$frame axdeth1 axdeth2 axdeth3 axdeth4 axdeth5 axdeth6
+$frame axdeth7 axdeth8 axdeth9
+
+$frame deatha1 deatha2 deatha3 deatha4 deatha5 deatha6 deatha7 deatha8
+$frame deatha9 deatha10 deatha11
+
+$frame deathb1 deathb2 deathb3 deathb4 deathb5 deathb6 deathb7 deathb8
+$frame deathb9
+
+$frame deathc1 deathc2 deathc3 deathc4 deathc5 deathc6 deathc7 deathc8
+$frame deathc9 deathc10 deathc11 deathc12 deathc13 deathc14 deathc15
+
+$frame deathd1 deathd2 deathd3 deathd4 deathd5 deathd6 deathd7
+$frame deathd8 deathd9
+
+$frame deathe1 deathe2 deathe3 deathe4 deathe5 deathe6 deathe7
+$frame deathe8 deathe9
+
+//
+// attacks
+//
+$frame nailatt1 nailatt2
+
+$frame light1 light2
+
+$frame rockatt1 rockatt2 rockatt3 rockatt4 rockatt5 rockatt6
+
+$frame shotatt1 shotatt2 shotatt3 shotatt4 shotatt5 shotatt6
+
+$frame axatt1 axatt2 axatt3 axatt4 axatt5 axatt6
+
+$frame axattb1 axattb2 axattb3 axattb4 axattb5 axattb6
+
+$frame axattc1 axattc2 axattc3 axattc4 axattc5 axattc6
+
+$frame axattd1 axattd2 axattd3 axattd4 axattd5 axattd6
+
+/*
+==============================================================================
+PLAYER
+==============================================================================
+*/
+
+void() player_run;
+
+void()	player_stand1 =[	$axstnd1,	player_stand1	]
+{
+	self.weaponframe=0;
+	if (self.velocity_x || self.velocity_y)
+	{
+		self.walkframe=0;
+		player_run();
+		return;
+	}
+
+	if (self.weapon == IT_AXE || self.weapon == IT_HOOK)
+	{
+		if (self.walkframe >= 12)
+			self.walkframe = 0;
+		self.frame = $axstnd1 + self.walkframe;
+	}
+	else
+	{
+		if (self.walkframe >= 5)
+			self.walkframe = 0;
+		self.frame = $stand1 + self.walkframe;
+	}
+	self.walkframe = self.walkframe + 1;	
+};
+
+void()	player_run =[	$rockrun1,	player_run	]
+{
+	self.weaponframe=0;
+	if (!self.velocity_x && !self.velocity_y)
+	{
+		self.walkframe=0;
+		player_stand1();
+		return;
+	}
+
+	if (self.weapon == IT_AXE || self.weapon == IT_HOOK)
+	{
+		if (self.walkframe == 6)
+			self.walkframe = 0;
+		self.frame = $axrun1 + self.walkframe;
+	}
+	else
+	{
+		if (self.walkframe == 6)
+			self.walkframe = 0;
+		self.frame = self.frame + self.walkframe;
+	}
+	self.walkframe = self.walkframe + 1;
+};
+
+
+void()	player_shot1 =	[$shotatt1, player_shot2	] {self.weaponframe=1;
+self.effects = self.effects | EF_MUZZLEFLASH;};
+void()	player_shot2 =	[$shotatt2, player_shot3	] {self.weaponframe=2;};
+void()	player_shot3 =	[$shotatt3, player_shot4	] {self.weaponframe=3;};
+void()	player_shot4 =	[$shotatt4, player_shot5	] {self.weaponframe=4;};
+void()	player_shot5 =	[$shotatt5, player_shot6	] {self.weaponframe=5;};
+void()	player_shot6 =	[$shotatt6, player_run	] {self.weaponframe=6;};
+
+void()	player_axe1 =	[$axatt1, player_axe2	] {self.weaponframe=1;};
+void()	player_axe2 =	[$axatt2, player_axe3	] {self.weaponframe=2;};
+void()	player_axe3 =	[$axatt3, player_axe4	] {self.weaponframe=3;W_FireAxe();};
+void()	player_axe4 =	[$axatt4, player_run	] {self.weaponframe=4;};
+
+void()	player_axeb1 =	[$axattb1, player_axeb2	] {self.weaponframe=5;};
+void()	player_axeb2 =	[$axattb2, player_axeb3	] {self.weaponframe=6;};
+void()	player_axeb3 =	[$axattb3, player_axeb4	] {self.weaponframe=7;W_FireAxe();};
+void()	player_axeb4 =	[$axattb4, player_run	] {self.weaponframe=8;};
+
+void()	player_axec1 =	[$axattc1, player_axec2	] {self.weaponframe=1;};
+void()	player_axec2 =	[$axattc2, player_axec3	] {self.weaponframe=2;};
+void()	player_axec3 =	[$axattc3, player_axec4	] {self.weaponframe=3;W_FireAxe();};
+void()	player_axec4 =	[$axattc4, player_run	] {self.weaponframe=4;};
+
+void()	player_axed1 =	[$axattd1, player_axed2	] {self.weaponframe=5;};
+void()	player_axed2 =	[$axattd2, player_axed3	] {self.weaponframe=6;};
+void()	player_axed3 =	[$axattd3, player_axed4	] {self.weaponframe=7;W_FireAxe();};
+void()	player_axed4 =	[$axattd4, player_run	] {self.weaponframe=8;};
+
+void()  player_chain1=  [$axattd1, player_chain2 ] {self.weaponframe=2;};
+void()  player_chain2=  [$axattd2, player_chain3 ] {self.weaponframe=3;W_FireChain();};
+
+void()  player_chain3=  [$axattd3, player_chain3 ]
+{
+        self.weaponframe=3;
+        if (!self.hook_out)
+        {
+                player_chain5();
+                return;
+        }
+        if (vlen(self.velocity) >= 750)
+        {
+                player_chain4();
+                return;
+        }
+};
+
+void() player_chain4=  [$deathc4, player_chain4 ]
+{
+        self.weaponframe=4;
+        if (!self.hook_out)
+        {
+                player_chain5();
+                return;
+        }
+        if (vlen(self.velocity) < 750)
+        {
+                player_chain3();
+                return;
+        }
+};
+
+void()  player_chain5=  [$axattd4, player_run    ] {self.weaponframe=5;};
+
+
+//============================================================================
+
+void() player_nail1   =[$nailatt1, player_nail2  ] 
+{
+	self.effects = self.effects | EF_MUZZLEFLASH;
+
+	if (!self.button0)
+		{player_run ();return;}
+	self.weaponframe = self.weaponframe + 1;
+	if (self.weaponframe == 9)
+		self.weaponframe = 1;
+	SuperDamageSound();
+	W_FireSpikes (4);
+	self.attack_finished = time + 0.2;
+};
+void() player_nail2   =[$nailatt2, player_nail1  ]
+{
+	self.effects = self.effects | EF_MUZZLEFLASH;
+
+	if (!self.button0)
+		{player_run ();return;}
+	self.weaponframe = self.weaponframe + 1;
+	if (self.weaponframe == 9)
+		self.weaponframe = 1;
+	SuperDamageSound();
+	W_FireSpikes (-4);
+	self.attack_finished = time + 0.2;
+};
+
+//============================================================================
+
+void() player_light1   =[$light1, player_light2  ] 
+{
+	self.effects = self.effects | EF_MUZZLEFLASH;
+
+	if (!self.button0)
+		{player_run ();return;}
+	self.weaponframe = self.weaponframe + 1;
+	if (self.weaponframe == 5)
+		self.weaponframe = 1;
+	SuperDamageSound();
+	W_FireLightning();
+	self.attack_finished = time + 0.2;
+};
+void() player_light2   =[$light2, player_light1  ]
+{
+	self.effects = self.effects | EF_MUZZLEFLASH;
+
+	if (!self.button0)
+		{player_run ();return;}
+	self.weaponframe = self.weaponframe + 1;
+	if (self.weaponframe == 5)
+		self.weaponframe = 1;
+	SuperDamageSound();
+	W_FireLightning();
+	self.attack_finished = time + 0.2;
+};
+
+//============================================================================
+
+
+void() player_rocket1   =[$rockatt1, player_rocket2  ] {self.weaponframe=1;
+self.effects = self.effects | EF_MUZZLEFLASH;};
+void() player_rocket2   =[$rockatt2, player_rocket3  ] {self.weaponframe=2;};
+void() player_rocket3   =[$rockatt3, player_rocket4  ] {self.weaponframe=3;};
+void() player_rocket4   =[$rockatt4, player_rocket5  ] {self.weaponframe=4;};
+void() player_rocket5   =[$rockatt5, player_rocket6  ] {self.weaponframe=5;};
+void() player_rocket6   =[$rockatt6, player_run  ] {self.weaponframe=6;};
+void(float num_bubbles) DeathBubbles;
+
+
+void() PainSound =
+{
+local float		rs;
+
+	if (self.health < 0)
+		return;
+
+	if (damage_attacker.classname == "teledeath")
+	{
+		sound (self, CHAN_VOICE, "player/teledth1.wav", 1, ATTN_NONE);
+		return;
+	}
+
+// water pain sounds
+	if (self.watertype == CONTENT_WATER && self.waterlevel == 3)
+	{
+		DeathBubbles(1);
+		if (random() > 0.5)
+			sound (self, CHAN_VOICE, "player/drown1.wav", 1, ATTN_NORM);
+		else
+			sound (self, CHAN_VOICE, "player/drown2.wav", 1, ATTN_NORM);
+		return;
+	}
+
+// slime pain sounds
+	if (self.watertype == CONTENT_SLIME)
+	{
+// FIX ME	put in some steam here
+		if (random() > 0.5)
+			sound (self, CHAN_VOICE, "player/lburn1.wav", 1, ATTN_NORM);
+		else
+			sound (self, CHAN_VOICE, "player/lburn2.wav", 1, ATTN_NORM);
+		return;
+	}
+
+	if (self.watertype == CONTENT_LAVA)
+	{
+		if (random() > 0.5)
+			sound (self, CHAN_VOICE, "player/lburn1.wav", 1, ATTN_NORM);
+		else
+			sound (self, CHAN_VOICE, "player/lburn2.wav", 1, ATTN_NORM);
+		return;
+	}
+
+	if (self.pain_finished > time)
+	{
+		self.axhitme = 0;
+		return;
+	}
+	self.pain_finished = time + 0.5;
+
+// don't make multiple pain sounds right after each other
+
+// ax pain sound
+	if (self.axhitme == 1)
+	{
+		self.axhitme = 0;
+		sound (self, CHAN_VOICE, "player/axhit1.wav", 1, ATTN_NORM);
+		return;
+	}
+	
+
+	rs = rint((random() * 5) + 1);
+
+	self.noise = "";
+	if (rs == 1)
+		self.noise = "player/pain1.wav";
+	else if (rs == 2)
+		self.noise = "player/pain2.wav";
+	else if (rs == 3)
+		self.noise = "player/pain3.wav";
+	else if (rs == 4)
+		self.noise = "player/pain4.wav";
+	else if (rs == 5)
+		self.noise = "player/pain5.wav";
+	else
+		self.noise = "player/pain6.wav";
+
+	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+	return;
+};
+
+void()	player_pain1 =	[	$pain1,	player_pain2	] {PainSound();self.weaponframe=0;};
+void()	player_pain2 =	[	$pain2,	player_pain3	] {};
+void()	player_pain3 =	[	$pain3,	player_pain4	] {};
+void()	player_pain4 =	[	$pain4,	player_pain5	] {};
+void()	player_pain5 =	[	$pain5,	player_pain6	] {};
+void()	player_pain6 =	[	$pain6,	player_run	] {};
+
+void()	player_axpain1 =	[	$axpain1,	player_axpain2	] {PainSound();self.weaponframe=0;};
+void()	player_axpain2 =	[	$axpain2,	player_axpain3	] {};
+void()	player_axpain3 =	[	$axpain3,	player_axpain4	] {};
+void()	player_axpain4 =	[	$axpain4,	player_axpain5	] {};
+void()	player_axpain5 =	[	$axpain5,	player_axpain6	] {};
+void()	player_axpain6 =	[	$axpain6,	player_run	] {};
+
+void() player_pain =
+{
+	if (self.weaponframe)
+		return;
+
+	if (self.invisible_finished > time)
+		return;		// eyes don't have pain frames
+
+	if (self.weapon == IT_AXE || self.weapon == IT_HOOK)
+		player_axpain1 ();
+	else
+		player_pain1 ();
+};
+
+void() player_diea1;
+void() player_dieb1;
+void() player_diec1;
+void() player_died1;
+void() player_diee1;
+void() player_die_ax1;
+
+void() DeathBubblesSpawn =
+{
+local entity	bubble;
+	if (self.owner.waterlevel != 3)
+		return;
+	bubble = spawn();
+	setmodel (bubble, "progs/s_bubble.spr");
+	setorigin (bubble, self.owner.origin + '0 0 24');
+	bubble.movetype = MOVETYPE_NOCLIP;
+	bubble.solid = SOLID_NOT;
+	bubble.velocity = '0 0 15';
+	bubble.nextthink = time + 0.5;
+	bubble.think = bubble_bob;
+	bubble.classname = "bubble";
+	bubble.frame = 0;
+	bubble.cnt = 0;
+	setsize (bubble, '-8 -8 -8', '8 8 8');
+	self.nextthink = time + 0.1;
+	self.think = DeathBubblesSpawn;
+	self.air_finished = self.air_finished + 1;
+	if (self.air_finished >= self.bubble_count)
+		remove(self);
+};
+
+void(float num_bubbles) DeathBubbles =
+{
+local entity	bubble_spawner;
+	
+	bubble_spawner = spawn();
+	setorigin (bubble_spawner, self.origin);
+	bubble_spawner.movetype = MOVETYPE_NONE;
+	bubble_spawner.solid = SOLID_NOT;
+	bubble_spawner.nextthink = time + 0.1;
+	bubble_spawner.think = DeathBubblesSpawn;
+	bubble_spawner.air_finished = 0;
+	bubble_spawner.owner = self;
+	bubble_spawner.bubble_count = num_bubbles;
+	return;
+};
+
+
+void() DeathSound =
+{
+local float		rs;
+
+	// water death sounds
+	if (self.waterlevel == 3)
+	{
+		DeathBubbles(20);
+		sound (self, CHAN_VOICE, "player/h2odeath.wav", 1, ATTN_NONE);
+		return;
+	}
+	
+	rs = rint ((random() * 4) + 1);
+	if (rs == 1)
+		self.noise = "player/death1.wav";
+	if (rs == 2)
+		self.noise = "player/death2.wav";
+	if (rs == 3)
+		self.noise = "player/death3.wav";
+	if (rs == 4)
+		self.noise = "player/death4.wav";
+	if (rs == 5)
+		self.noise = "player/death5.wav";
+
+	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NONE);
+	return;
+};
+
+
+void() PlayerDead =
+{
+	self.nextthink = -1;
+// allow respawn after a certain time
+	self.deadflag = DEAD_DEAD;
+};
+
+vector(float dm) VelocityForDamage =
+{
+	local vector v;
+
+	v_x = 100 * crandom();
+	v_y = 100 * crandom();
+	v_z = 200 + 100 * random();
+
+	if (dm > -50)
+	{
+//		dprint ("level 1\n");
+		v = v * 0.7;
+	}
+	else if (dm > -200)
+	{
+//		dprint ("level 3\n");
+		v = v * 2;
+	}
+	else
+		v = v * 10;
+
+	return v;
+};
+
+void(string gibname, float dm) ThrowGib =
+{
+	local	entity new;
+
+	new = spawn();
+	new.origin = self.origin;
+	setmodel (new, gibname);
+	setsize (new, '0 0 0', '0 0 0');
+	new.velocity = VelocityForDamage (dm);
+	new.movetype = MOVETYPE_BOUNCE;
+	new.solid = SOLID_NOT;
+	new.avelocity_x = random()*600;
+	new.avelocity_y = random()*600;
+	new.avelocity_z = random()*600;
+	new.think = SUB_Remove;
+	new.ltime = time;
+	new.nextthink = time + 10 + random()*10;
+	new.frame = 0;
+	new.flags = 0;
+};
+
+void(string gibname, float dm) ThrowHead =
+{
+	setmodel (self, gibname);
+	self.frame = 0;
+	self.nextthink = -1;
+	self.movetype = MOVETYPE_BOUNCE;
+	self.takedamage = DAMAGE_NO;
+	self.solid = SOLID_NOT;
+	self.view_ofs = '0 0 8';
+	setsize (self, '-16 -16 0', '16 16 56');
+	self.velocity = VelocityForDamage (dm);
+	self.origin_z = self.origin_z - 24;
+	self.flags = self.flags - (self.flags & FL_ONGROUND);
+	self.avelocity = crandom() * '0 600 0';
+};
+
+
+void() GibPlayer =
+{
+	ThrowHead ("progs/h_player.mdl", self.health);
+	ThrowGib ("progs/gib1.mdl", self.health);
+	ThrowGib ("progs/gib2.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+
+	self.deadflag = DEAD_DEAD;
+
+	if (damage_attacker.classname == "teledeath")
+	{
+		self.staydeadtime = time + 2 + (random() * 3);
+		sound (self, CHAN_VOICE, "player/teledth1.wav", 1, ATTN_NONE);
+		return;
+	}
+
+	if (damage_attacker.classname == "teledeath2")
+	{
+		self.staydeadtime = time + 3 + (random() * 6);
+		sound (self, CHAN_VOICE, "player/teledth1.wav", 1, ATTN_NONE);
+		return;
+	}
+		
+	if (random() < 0.5)
+		sound (self, CHAN_VOICE, "player/gib.wav", 1, ATTN_NONE);
+	else
+		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NONE);
+};
+
+void() PlayerDie =
+{
+	local	float	i;
+	
+	self.items = self.items - (self.items & IT_INVISIBILITY);
+	self.invisible_finished = 0;	// don't die as eyes
+	self.invincible_finished = 0;
+	self.super_damage_finished = 0;
+	self.radsuit_finished = 0;
+	self.modelindex = modelindex_player;	// don't use eyes
+
+	if (deathmatch || coop) {
+		DropBackpack();
+		DropRune();
+		TeamCaptureDropFlagOfPlayer(self);
+	}
+	
+	if (self.killed == 2)
+		self.killed = 0;
+	else
+		self.killed = 1;
+	self.weaponmodel="";
+	self.view_ofs = '0 0 -8';
+	self.deadflag = DEAD_DYING;
+	self.solid = SOLID_NOT;
+	self.flags = self.flags - (self.flags & FL_ONGROUND);
+	self.movetype = MOVETYPE_TOSS;
+	if (self.velocity_z < 10)
+		self.velocity_z = self.velocity_z + random()*300;
+
+	if (self.health < -40)
+	{
+		GibPlayer ();
+		return;
+	}
+
+	DeathSound();
+	
+	self.angles_x = 0;
+	self.angles_z = 0;
+	
+	if (self.weapon == IT_AXE || self.weapon == IT_HOOK)
+	{
+		player_die_ax1 ();
+		return;
+	}
+	
+	i = cvar("temp1");
+	if (!i)
+		i = 1 + floor(random()*6);
+	
+	if (i == 1)
+		player_diea1();
+	else if (i == 2)
+		player_dieb1();
+	else if (i == 3)
+		player_diec1();
+	else if (i == 4)
+		player_died1();
+	else
+		player_diee1();
+
+};
+
+void() set_suicide_frame =
+{	// used by klill command and diconnect command
+/*
+	if (self.model != "progs/player.mdl")
+		return;	// allready gibbed
+*/
+	if (self.health <= 0)
+		return;
+	self.frame = $deatha11;
+	self.solid = SOLID_NOT;
+	self.movetype = MOVETYPE_TOSS;
+	self.deadflag = DEAD_DEAD;
+	self.nextthink = -1;
+};
+
+
+void()	player_diea1	=	[	$deatha1,	player_diea2	] {};
+void()	player_diea2	=	[	$deatha2,	player_diea3	] {};
+void()	player_diea3	=	[	$deatha3,	player_diea4	] {};
+void()	player_diea4	=	[	$deatha4,	player_diea5	] {};
+void()	player_diea5	=	[	$deatha5,	player_diea6	] {};
+void()	player_diea6	=	[	$deatha6,	player_diea7	] {};
+void()	player_diea7	=	[	$deatha7,	player_diea8	] {};
+void()	player_diea8	=	[	$deatha8,	player_diea9	] {};
+void()	player_diea9	=	[	$deatha9,	player_diea10	] {};
+void()	player_diea10	=	[	$deatha10,	player_diea11	] {};
+void()	player_diea11	=	[	$deatha11,	player_diea11 ] {PlayerDead();};
+
+void()	player_dieb1	=	[	$deathb1,	player_dieb2	] {};
+void()	player_dieb2	=	[	$deathb2,	player_dieb3	] {};
+void()	player_dieb3	=	[	$deathb3,	player_dieb4	] {};
+void()	player_dieb4	=	[	$deathb4,	player_dieb5	] {};
+void()	player_dieb5	=	[	$deathb5,	player_dieb6	] {};
+void()	player_dieb6	=	[	$deathb6,	player_dieb7	] {};
+void()	player_dieb7	=	[	$deathb7,	player_dieb8	] {};
+void()	player_dieb8	=	[	$deathb8,	player_dieb9	] {};
+void()	player_dieb9	=	[	$deathb9,	player_dieb9	] {PlayerDead();};
+
+void()	player_diec1	=	[	$deathc1,	player_diec2	] {};
+void()	player_diec2	=	[	$deathc2,	player_diec3	] {};
+void()	player_diec3	=	[	$deathc3,	player_diec4	] {};
+void()	player_diec4	=	[	$deathc4,	player_diec5	] {};
+void()	player_diec5	=	[	$deathc5,	player_diec6	] {};
+void()	player_diec6	=	[	$deathc6,	player_diec7	] {};
+void()	player_diec7	=	[	$deathc7,	player_diec8	] {};
+void()	player_diec8	=	[	$deathc8,	player_diec9	] {};
+void()	player_diec9	=	[	$deathc9,	player_diec10	] {};
+void()	player_diec10	=	[	$deathc10,	player_diec11	] {};
+void()	player_diec11	=	[	$deathc11,	player_diec12	] {};
+void()	player_diec12	=	[	$deathc12,	player_diec13	] {};
+void()	player_diec13	=	[	$deathc13,	player_diec14	] {};
+void()	player_diec14	=	[	$deathc14,	player_diec15	] {};
+void()	player_diec15	=	[	$deathc15,	player_diec15 ] {PlayerDead();};
+
+void()	player_died1	=	[	$deathd1,	player_died2	] {};
+void()	player_died2	=	[	$deathd2,	player_died3	] {};
+void()	player_died3	=	[	$deathd3,	player_died4	] {};
+void()	player_died4	=	[	$deathd4,	player_died5	] {};
+void()	player_died5	=	[	$deathd5,	player_died6	] {};
+void()	player_died6	=	[	$deathd6,	player_died7	] {};
+void()	player_died7	=	[	$deathd7,	player_died8	] {};
+void()	player_died8	=	[	$deathd8,	player_died9	] {};
+void()	player_died9	=	[	$deathd9,	player_died9	] {PlayerDead();};
+
+void()	player_diee1	=	[	$deathe1,	player_diee2	] {};
+void()	player_diee2	=	[	$deathe2,	player_diee3	] {};
+void()	player_diee3	=	[	$deathe3,	player_diee4	] {};
+void()	player_diee4	=	[	$deathe4,	player_diee5	] {};
+void()	player_diee5	=	[	$deathe5,	player_diee6	] {};
+void()	player_diee6	=	[	$deathe6,	player_diee7	] {};
+void()	player_diee7	=	[	$deathe7,	player_diee8	] {};
+void()	player_diee8	=	[	$deathe8,	player_diee9	] {};
+void()	player_diee9	=	[	$deathe9,	player_diee9	] {PlayerDead();};
+
+void()	player_die_ax1	=	[	$axdeth1,	player_die_ax2	] {};
+void()	player_die_ax2	=	[	$axdeth2,	player_die_ax3	] {};
+void()	player_die_ax3	=	[	$axdeth3,	player_die_ax4	] {};
+void()	player_die_ax4	=	[	$axdeth4,	player_die_ax5	] {};
+void()	player_die_ax5	=	[	$axdeth5,	player_die_ax6	] {};
+void()	player_die_ax6	=	[	$axdeth6,	player_die_ax7	] {};
+void()	player_die_ax7	=	[	$axdeth7,	player_die_ax8	] {};
+void()	player_die_ax8	=	[	$axdeth8,	player_die_ax9	] {};
+void()	player_die_ax9	=	[	$axdeth9,	player_die_ax9	] {PlayerDead();};
+
+// these are the only sprites still in the game...
+
+$spritename s_explod
+$type vp_parallel
+$load id1/gfx/sprites/explod03.lbm
+$frame	24	24	56	56
+$frame	120	24	56	56
+$frame	216	24	56	56
+$frame	24	88	56	56
+$frame	120	88	56	56
+$frame	216	88	56	56
+
+
+$spritename s_bubble
+$type vp_parallel
+$load id1/gfx/sprites/bubble.lbm
+$frame	16	16	16	16
+$frame	40	16	16	16
+
+
+$spritename s_light
+$type vp_parallel
+$load id1/gfx/sprites/light.lbm
+$frame	104	32	32	32
+
+
+
+void() SUB_Null = {};
+
+void() SUB_Remove = {remove(self);};
+
+
+/*
+QuakeEd only writes a single float for angles (bad idea), so up and down are
+just constant angles.
+*/
+vector() SetMovedir =
+{
+	if (self.angles == '0 -1 0')
+		self.movedir = '0 0 1';
+	else if (self.angles == '0 -2 0')
+		self.movedir = '0 0 -1';
+	else
+	{
+		makevectors (self.angles);
+		self.movedir = v_forward;
+	}
+	
+	self.angles = '0 0 0';
+};
+
+/*
+================
+InitTrigger
+================
+*/
+void() InitTrigger =
+{
+// trigger angles are used for one-way touches.  An angle of 0 is assumed
+// to mean no restrictions, so use a yaw of 360 instead.
+	if (self.angles != '0 0 0')
+		SetMovedir ();
+	self.solid = SOLID_TRIGGER;
+	setmodel (self, self.model);	// set size and link into world
+	self.movetype = MOVETYPE_NONE;
+	self.modelindex = 0;
+	self.model = "";
+};
+
+/*
+=============
+SUB_CalcMove
+
+calculate self.velocity and self.nextthink to reach dest from
+self.origin traveling at speed
+===============
+*/
+void(entity ent, vector tdest, float tspeed, void() func) SUB_CalcMoveEnt =
+{
+local entity	stemp;
+	stemp = self;
+	self = ent;
+
+	SUB_CalcMove (tdest, tspeed, func);
+	self = stemp;
+};
+
+void(vector tdest, float tspeed, void() func) SUB_CalcMove =
+{
+local vector	vdestdelta;
+local float		len, traveltime;
+
+	if (!tspeed)
+		objerror("No speed is defined!");
+
+	self.think1 = func;
+	self.finaldest = tdest;
+	self.think = SUB_CalcMoveDone;
+
+	if (tdest == self.origin)
+	{
+		self.velocity = '0 0 0';
+		self.nextthink = self.ltime + 0.1;
+		return;
+	}
+		
+// set destdelta to the vector needed to move
+	vdestdelta = tdest - self.origin;
+	
+// calculate length of vector
+	len = vlen (vdestdelta);
+	
+// divide by speed to get time to reach dest
+	traveltime = len / tspeed;
+
+	if (traveltime < 0.1)
+	{
+		self.velocity = '0 0 0';
+		self.nextthink = self.ltime + 0.1;
+		return;
+	}
+	
+// set nextthink to trigger a think when dest is reached
+	self.nextthink = self.ltime + traveltime;
+
+// scale the destdelta vector by the time spent traveling to get velocity
+	self.velocity = vdestdelta * (1/traveltime);	// qcc won't take vec/float	
+};
+
+/*
+============
+After moving, set origin to exact final destination
+============
+*/
+void()  SUB_CalcMoveDone =
+{
+	setorigin(self, self.finaldest);
+	self.velocity = '0 0 0';
+	self.nextthink = -1;
+	if (self.think1)
+		self.think1();
+};
+
+
+/*
+=============
+SUB_CalcAngleMove
+
+calculate self.avelocity and self.nextthink to reach destangle from
+self.angles rotating 
+
+The calling function should make sure self.think is valid
+===============
+*/
+void(entity ent, vector destangle, float tspeed, void() func) SUB_CalcAngleMoveEnt =
+{
+local entity		stemp;
+	stemp = self;
+	self = ent;
+	SUB_CalcAngleMove (destangle, tspeed, func);
+	self = stemp;
+};
+
+void(vector destangle, float tspeed, void() func) SUB_CalcAngleMove =
+{
+local vector	destdelta;
+local float		len, traveltime;
+
+	if (!tspeed)
+		objerror("No speed is defined!");
+		
+// set destdelta to the vector needed to move
+	destdelta = destangle - self.angles;
+	
+// calculate length of vector
+	len = vlen (destdelta);
+	
+// divide by speed to get time to reach dest
+	traveltime = len / tspeed;
+
+// set nextthink to trigger a think when dest is reached
+	self.nextthink = self.ltime + traveltime;
+
+// scale the destdelta vector by the time spent traveling to get velocity
+	self.avelocity = destdelta * (1 / traveltime);
+	
+	self.think1 = func;
+	self.finalangle = destangle;
+	self.think = SUB_CalcAngleMoveDone;
+};
+
+/*
+============
+After rotating, set angle to exact final angle
+============
+*/
+void() SUB_CalcAngleMoveDone =
+{
+	self.angles = self.finalangle;
+	self.avelocity = '0 0 0';
+	self.nextthink = -1;
+	if (self.think1)
+		self.think1();
+};
+
+
+//=============================================================================
+
+void() DelayThink =
+{
+	activator = self.enemy;
+	SUB_UseTargets ();
+	remove(self);
+};
+
+/*
+==============================
+SUB_UseTargets
+
+the global "activator" should be set to the entity that initiated the firing.
+
+If self.delay is set, a DelayedUse entity will be created that will actually
+do the SUB_UseTargets after that many seconds have passed.
+
+Centerprints any self.message to the activator.
+
+Removes all entities with a targetname that match self.killtarget,
+and removes them, so some events can remove other triggers.
+
+Search for (string)targetname in all entities that
+match (string)self.target and call their .use function
+
+==============================
+*/
+void() SUB_UseTargets =
+{
+	local entity t, stemp, otemp, act;
+
+//
+// check for a delay
+//
+	if (self.delay)
+	{
+	// create a temp object to fire at a later time
+		t = spawn();
+		t.classname = "DelayedUse";
+		t.nextthink = time + self.delay;
+		t.think = DelayThink;
+		t.enemy = activator;
+		t.message = self.message;
+		t.killtarget = self.killtarget;
+		t.target = self.target;
+		return;
+	}
+	
+	
+//
+// print the message
+//
+	if (activator.classname == "player" && self.message != "")
+	{
+		centerprint (activator, self.message);
+		if (!self.noise)
+			sound (activator, CHAN_VOICE, "misc/talk.wav", 1, ATTN_NORM);
+	}
+
+//
+// kill the killtagets
+//
+	if (self.killtarget)
+	{
+		t = world;
+		do
+		{
+			t = find (t, targetname, self.killtarget);
+			if (!t)
+				return;
+			remove (t);
+		} while ( 1 );
+	}
+	
+//
+// fire targets
+//
+	if (self.target)
+	{
+		act = activator;
+		t = world;
+		do
+		{
+			t = find (t, targetname, self.target);
+			if (!t)
+			{
+				return;
+			}
+			stemp = self;
+			otemp = other;
+			self = t;
+			other = stemp;
+			if (self.use != SUB_Null)
+			{
+				if (self.use)
+					self.use ();
+			}
+			self = stemp;
+			other = otemp;
+			activator = act;
+		} while ( 1 );
+	}
+	
+
+};
+
+
+
+entity stemp, otemp, s, old;
+
+
+void() trigger_reactivate =
+{
+	self.solid = SOLID_TRIGGER;
+};
+
+//=============================================================================
+
+float	SPAWNFLAG_NOMESSAGE = 1;
+float	SPAWNFLAG_NOTOUCH = 1;
+
+// the wait time has passed, so set back up for another activation
+void() multi_wait =
+{
+	if (self.max_health)
+	{
+		self.health = self.max_health;
+		self.takedamage = DAMAGE_YES;
+		self.solid = SOLID_BBOX;
+	}
+};
+
+
+// the trigger was just touched/killed/used
+// self.enemy should be set to the activator so it can be held through a delay
+// so wait for the delay time before firing
+void() multi_trigger =
+{
+	if (self.nextthink > time)
+	{
+		return;		// allready been triggered
+	}
+
+	if (self.classname == "trigger_secret")
+	{
+		if (self.enemy.classname != "player")
+			return;
+		found_secrets = found_secrets + 1;
+		WriteByte (MSG_ALL, SVC_FOUNDSECRET);
+	}
+
+	if (self.noise)
+		sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+
+// don't trigger again until reset
+	self.takedamage = DAMAGE_NO;
+
+	activator = self.enemy;
+	
+	SUB_UseTargets();
+
+	if (self.wait > 0)	
+	{
+		self.think = multi_wait;
+		self.nextthink = time + self.wait;
+	}
+	else
+	{	// we can't just remove (self) here, because this is a touch function
+		// called wheil C code is looping through area links...
+		self.touch = SUB_Null;
+		self.nextthink = time + 0.1;
+		self.think = SUB_Remove;
+	}
+};
+
+void() multi_killed =
+{
+	self.enemy = damage_attacker;
+	multi_trigger();
+};
+
+void() multi_use =
+{
+	self.enemy = activator;
+	multi_trigger();
+};
+
+void() multi_touch =
+{
+	if (other.classname != "player")
+		return;
+	
+// if the trigger has an angles field, check player's facing direction
+	if (self.movedir != '0 0 0')
+	{
+		makevectors (other.angles);
+		if (v_forward * self.movedir < 0)
+			return;		// not facing the right way
+	}
+	
+	self.enemy = other;
+	multi_trigger ();
+};
+
+/*QUAKED trigger_multiple (.5 .5 .5) ? notouch
+Variable sized repeatable trigger.  Must be targeted at one or more entities.  If "health" is set, the trigger must be killed to activate each time.
+If "delay" is set, the trigger waits some time after activating before firing.
+"wait" : Seconds between triggerings. (.2 default)
+If notouch is set, the trigger is only fired by other entities, not by touching.
+NOTOUCH has been obsoleted by trigger_relay!
+sounds
+1)	secret
+2)	beep beep
+3)	large switch
+4)
+set "message" to text string
+*/
+void() trigger_multiple =
+{
+	if (self.sounds == 1)
+	{
+		precache_sound ("misc/secret.wav");
+		self.noise = "misc/secret.wav";
+	}
+	else if (self.sounds == 2)
+	{
+		precache_sound ("misc/talk.wav");
+		self.noise = "misc/talk.wav";
+	}
+	else if (self.sounds == 3)
+	{
+		precache_sound ("misc/trigger1.wav");
+		self.noise = "misc/trigger1.wav";
+	}
+	
+	if (!self.wait)
+		self.wait = 0.2;
+	self.use = multi_use;
+
+	InitTrigger ();
+
+	if (self.health)
+	{
+		if (self.spawnflags & SPAWNFLAG_NOTOUCH)
+			objerror ("health and notouch don't make sense\n");
+		self.max_health = self.health;
+		self.th_die = multi_killed;
+		self.takedamage = DAMAGE_YES;
+		self.solid = SOLID_BBOX;
+		setorigin (self, self.origin);	// make sure it links into the world
+	}
+	else
+	{
+		if ( !(self.spawnflags & SPAWNFLAG_NOTOUCH) )
+		{
+			self.touch = multi_touch;
+		}
+	}
+};
+
+
+/*QUAKED trigger_once (.5 .5 .5) ? notouch
+Variable sized trigger. Triggers once, then removes itself.  You must set the key "target" to the name of another object in the level that has a matching
+"targetname".  If "health" is set, the trigger must be killed to activate.
+If notouch is set, the trigger is only fired by other entities, not by touching.
+if "killtarget" is set, any objects that have a matching "target" will be removed when the trigger is fired.
+if "angle" is set, the trigger will only fire when someone is facing the direction of the angle.  Use "360" for an angle of 0.
+sounds
+1)	secret
+2)	beep beep
+3)	large switch
+4)
+set "message" to text string
+*/
+void() trigger_once =
+{
+	self.wait = -1;
+	trigger_multiple();
+};
+
+//=============================================================================
+
+/*QUAKED trigger_relay (.5 .5 .5) (-8 -8 -8) (8 8 8)
+This fixed size trigger cannot be touched, it can only be fired by other events.  It can contain killtargets, targets, delays, and messages.
+*/
+void() trigger_relay =
+{
+	self.use = SUB_UseTargets;
+};
+
+
+//=============================================================================
+
+/*QUAKED trigger_secret (.5 .5 .5) ?
+secret counter trigger
+sounds
+1)	secret
+2)	beep beep
+3)
+4)
+set "message" to text string
+*/
+void() trigger_secret =
+{
+	total_secrets = total_secrets + 1;
+	self.wait = -1;
+	if (!self.message)
+		self.message = "You found a secret area!";
+	if (!self.sounds)
+		self.sounds = 1;
+	
+	if (self.sounds == 1)
+	{
+		precache_sound ("misc/secret.wav");
+		self.noise = "misc/secret.wav";
+	}
+	else if (self.sounds == 2)
+	{
+		precache_sound ("misc/talk.wav");
+		self.noise = "misc/talk.wav";
+	}
+
+	trigger_multiple ();
+};
+
+//=============================================================================
+
+
+void() counter_use =
+{
+	local string junk;
+
+	self.count = self.count - 1;
+	if (self.count < 0)
+		return;
+	
+	if (self.count != 0)
+	{
+		if (activator.classname == "player"
+		&& (self.spawnflags & SPAWNFLAG_NOMESSAGE) == 0)
+		{
+			if (self.count >= 4)
+				centerprint (activator, "There are more to go...");
+			else if (self.count == 3)
+				centerprint (activator, "Only 3 more to go...");
+			else if (self.count == 2)
+				centerprint (activator, "Only 2 more to go...");
+			else
+				centerprint (activator, "Only 1 more to go...");
+		}
+		return;
+	}
+	
+	if (activator.classname == "player"
+	&& (self.spawnflags & SPAWNFLAG_NOMESSAGE) == 0)
+		centerprint(activator, "Sequence completed!");
+	self.enemy = activator;
+	multi_trigger ();
+};
+
+/*QUAKED trigger_counter (.5 .5 .5) ? nomessage
+Acts as an intermediary for an action that takes multiple inputs.
+
+If nomessage is not set, t will print "1 more.. " etc when triggered and "sequence complete" when finished.
+
+After the counter has been triggered "count" times (default 2), it will fire all of it's targets and remove itself.
+*/
+void() trigger_counter =
+{
+	self.wait = -1;
+	if (!self.count)
+		self.count = 2;
+
+	self.use = counter_use;
+};
+
+
+/*
+==============================================================================
+
+TELEPORT TRIGGERS
+
+==============================================================================
+*/
+
+float	PLAYER_ONLY	= 1;
+float	SILENT = 2;
+
+void() play_teleport =
+{
+	local	float v;
+	local	string tmpstr;
+
+	v = random() * 5;
+	if (v < 1)
+		tmpstr = "misc/r_tele1.wav";
+	else if (v < 2)
+		tmpstr = "misc/r_tele2.wav";
+	else if (v < 3)
+		tmpstr = "misc/r_tele3.wav";
+	else if (v < 4)
+		tmpstr = "misc/r_tele4.wav";
+	else
+		tmpstr = "misc/r_tele5.wav";
+
+	sound (self, CHAN_VOICE, tmpstr, 1, ATTN_NORM);
+	remove (self);
+};
+
+void(vector org) spawn_tfog =
+{
+	s = spawn ();
+	s.origin = org;
+	s.nextthink = time + 0.2;
+	s.think = play_teleport;
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_TELEPORT);
+	WriteCoord (MSG_BROADCAST, org_x);
+	WriteCoord (MSG_BROADCAST, org_y);
+	WriteCoord (MSG_BROADCAST, org_z);
+};
+
+
+void() tdeath_touch =
+{
+	if (other == self.owner)
+		return;
+
+// frag anyone who teleports in on top of an invincible player
+	if (other.classname == "player")
+	{
+		if (other.invincible_finished > time)
+			self.classname = "teledeath2";
+		if (self.owner.classname != "player")
+		{	// other monsters explode themselves
+			T_Damage (self.owner, self, self, 50000);
+			return;
+		}
+		
+	}
+
+	if (other.health)
+	{
+		T_Damage (other, self, self, 50000);
+	}
+};
+
+
+void(vector org, entity death_owner) spawn_tdeath =
+{
+local entity	death;
+
+	death = spawn();
+	death.classname = "teledeath";
+	death.movetype = MOVETYPE_NONE;
+	death.solid = SOLID_TRIGGER;
+	death.angles = '0 0 0';
+	setsize (death, death_owner.mins - '1 1 1', death_owner.maxs + '1 1 1');
+	setorigin (death, org);
+	death.touch = tdeath_touch;
+	death.nextthink = time + 0.1;
+	death.think = SUB_Remove;
+	death.owner = death_owner;
+	
+	force_retouch = 2;		// make sure even still objects get hit
+};
+
+void() teleport_touch =
+{
+local entity	t;
+local vector	org;
+
+	if (self.targetname)
+	{
+		if (self.nextthink < time)
+		{
+			return;		// not fired yet
+		}
+	}
+
+	if (self.spawnflags & PLAYER_ONLY)
+	{
+		if (other.classname != "player")
+			return;
+	}
+
+// only teleport living creatures
+	if (other.health <= 0 || other.solid != SOLID_SLIDEBOX)
+		return;
+	SUB_UseTargets ();
+
+// put a tfog where the player was
+	spawn_tfog (other.origin);
+
+	t = find (world, targetname, self.target);
+	if (!t)
+		objerror ("couldn't find target");
+		
+// spawn a tfog flash in front of the destination
+	makevectors (t.mangle);
+	org = t.origin + 32 * v_forward;
+
+	spawn_tfog (org);
+	spawn_tdeath(t.origin, other);
+
+// move the player and lock him down for a little while
+	if (!other.health)
+	{
+		other.origin = t.origin;
+		other.velocity = (v_forward * other.velocity_x) + (v_forward * other.velocity_y);
+		return;
+	}
+	setorigin (other, t.origin);
+	other.angles = t.mangle;
+
+	if (other.classname == "player")
+	{
+		other.fixangle = 1;		// turn this way immediately
+		other.teleport_time = time + 0.7;
+
+		if (other.flags & FL_ONGROUND)
+			other.flags = other.flags - FL_ONGROUND;
+		other.velocity = v_forward * 300;
+	}
+	other.flags = other.flags - other.flags & FL_ONGROUND;
+};
+
+/*QUAKED info_teleport_destination (.5 .5 .5) (-8 -8 -8) (8 8 32)
+This is the destination marker for a teleporter.  It should have a "targetname" field with the same value as a teleporter's "target" field.
+*/
+void() info_teleport_destination =
+{
+// this does nothing, just serves as a target spot
+	self.mangle = self.angles;
+	self.angles = '0 0 0';
+	self.model = "";
+	self.origin = self.origin + '0 0 27';
+	if (!self.targetname)
+		objerror ("no targetname");
+};
+
+void() teleport_use =
+{
+	self.nextthink = time + 0.2;
+	force_retouch = 2;		// make sure even still objects get hit
+	self.think = SUB_Null;
+};
+
+/*QUAKED trigger_teleport (.5 .5 .5) ? PLAYER_ONLY SILENT
+Any object touching this will be transported to the corresponding info_teleport_destination entity. You must set the "target" field, and create an object with a "targetname" field that matches.
+
+If the trigger_teleport has a targetname, it will only teleport entities when it has been fired.
+*/
+void() trigger_teleport =
+{
+	local vector o;
+
+	InitTrigger ();
+	self.touch = teleport_touch;
+	// find the destination 
+	if (!self.target)
+		objerror ("no target");
+	self.use = teleport_use;
+
+	if (!(self.spawnflags & SILENT))
+	{
+		precache_sound ("ambience/hum1.wav");
+		o = (self.mins + self.maxs)*0.5;
+		ambientsound (o, "ambience/hum1.wav",0.5 , ATTN_STATIC);
+	}
+};
+
+/*
+==============================================================================
+
+trigger_setskill
+
+==============================================================================
+*/
+
+void() trigger_skill_touch =
+{
+	if (other.classname != "player")
+		return;
+		
+	cvar_set ("skill", self.message);
+};
+
+/*QUAKED trigger_setskill (.5 .5 .5) ?
+sets skill level to the value of "message".
+Only used on start map.
+*/
+void() trigger_setskill =
+{
+	InitTrigger ();
+	self.touch = trigger_skill_touch;
+};
+
+
+/*
+==============================================================================
+
+ONLY REGISTERED TRIGGERS
+
+==============================================================================
+*/
+
+void() trigger_onlyregistered_touch =
+{
+	if (other.classname != "player")
+		return;
+	if (self.attack_finished > time)
+		return;
+
+	self.attack_finished = time + 2;
+	if (cvar("registered"))
+	{
+		self.message = "";
+		SUB_UseTargets ();
+		remove (self);
+	}
+	else
+	{
+		if (self.message != "")
+		{
+			centerprint (other, self.message);
+			sound (other, CHAN_BODY, "misc/talk.wav", 1, ATTN_NORM);
+		}
+	}
+};
+
+/*QUAKED trigger_onlyregistered (.5 .5 .5) ?
+Only fires if playing the registered version, otherwise prints the message
+*/
+void() trigger_onlyregistered =
+{
+	precache_sound ("misc/talk.wav");
+	InitTrigger ();
+	self.touch = trigger_onlyregistered_touch;
+};
+
+//============================================================================
+
+void() hurt_on =
+{
+	self.solid = SOLID_TRIGGER;
+	self.nextthink = -1;
+};
+
+void() hurt_touch =
+{
+	if (other.takedamage)
+	{
+		self.solid = SOLID_NOT;
+		T_Damage (other, self, self, self.dmg);
+		self.think = hurt_on;
+		self.nextthink = time + 1;
+	}
+
+	return;
+};
+
+/*QUAKED trigger_hurt (.5 .5 .5) ?
+Any object touching this will be hurt
+set dmg to damage amount
+defalt dmg = 5
+*/
+void() trigger_hurt =
+{
+	InitTrigger ();
+	self.touch = hurt_touch;
+	if (!self.dmg)
+		self.dmg = 5;
+};
+
+//============================================================================
+
+float PUSH_ONCE = 1;
+
+void() trigger_push_touch =
+{
+	if (other.classname == "grenade")
+		other.velocity = self.speed * self.movedir * 10;
+	else if (other.health > 0)
+	{
+		other.velocity = self.speed * self.movedir * 10;
+		if (other.classname == "player")
+		{
+			if (other.fly_sound < time)
+			{
+				other.fly_sound = time + 1.5;
+				sound (other, CHAN_AUTO, "ambience/windfly.wav", 1, ATTN_NORM);
+			}
+		}
+	}
+	if (self.spawnflags & PUSH_ONCE)
+		remove(self);
+};
+
+
+/*QUAKED trigger_push (.5 .5 .5) ? PUSH_ONCE
+Pushes the player
+*/
+void() trigger_push =
+{
+	InitTrigger ();
+	precache_sound ("ambience/windfly.wav");
+	self.touch = trigger_push_touch;
+	if (!self.speed)
+		self.speed = 1000;
+};
+
+//============================================================================
+
+void() trigger_monsterjump_touch =
+{
+	if ( other.flags & (FL_MONSTER | FL_FLY | FL_SWIM) != FL_MONSTER )
+		return;
+
+// set XY even if not on ground, so the jump will clear lips
+	other.velocity_x = self.movedir_x * self.speed;
+	other.velocity_y = self.movedir_y * self.speed;
+	
+	if ( !(other.flags & FL_ONGROUND) )
+		return;
+	
+	other.flags = other.flags - FL_ONGROUND;
+
+	other.velocity_z = self.height;
+};
+
+/*QUAKED trigger_monsterjump (.5 .5 .5) ?
+Walking monsters that touch this will jump in the direction of the trigger's angle
+"speed" default to 200, the speed thrown forward
+"height" default to 200, the speed thrown upwards
+*/
+void() trigger_monsterjump =
+{
+	if (!self.speed)
+		self.speed = 200;
+	if (!self.height)
+		self.height = 200;
+	if (self.angles == '0 0 0')
+		self.angles = '0 360 0';
+	InitTrigger ();
+	self.touch = trigger_monsterjump_touch;
+};
+
+/*
+**
+** _telefrg.qc (Telefrag Code, 1.1)
+**
+** Copyright (C) 1996 Johannes Plass
+**
+** This program is free software; you can redistribute it and/or modify
+** it under the terms of the GNU General Public License as published by
+** the Free Software Foundation; either version 2 of the License, or
+** (at your option) any later version.
+**
+** This program is distributed in the hope that it will be useful,
+** but WITHOUT ANY WARRANTY; without even the implied warranty of
+** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+** GNU General Public License for more details.
+**
+** You should have received a copy of the GNU General Public License
+** along with this program; if not, write to the Free Software
+** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
+**
+** Author:   Johannes Plass (plass@dipmza.physik.uni-mainz.de)
+**
+** --
+** Sniped by Zoid for ThreeWave Mods, GPL respected
+**
+*/
+
+entity() SelectSpawnPoint;
+
+entity(entity spot) TelefragSelectSpawnPoint =
+{
+	local entity e, firstspot;
+	local float search_spot;
+
+	search_spot = 25;
+	firstspot = spot;
+
+	while (search_spot) {
+		e = findradius(spot.origin, 50);
+		if (!e)
+			search_spot = 0;
+		else {
+			local float occupied;
+			occupied = 0;
+			while (!occupied && !(!e)) {
+				if (e.classname == "player" && e.deadflag == DEAD_NO)
+						occupied = 1;
+				else
+					e = e.chain;
+			}
+			if (occupied) {
+				spot = SelectSpawnPoint();
+				search_spot = search_spot - 1;
+				if (spot == firstspot)
+						search_spot = 0;
+			} else
+				search_spot = 0;
+		}
+	}
+	return (spot);
+};
+
+void(entity targ, entity attacker, string what) LogPlayerDMDeath =
+{
+	// note embedded tabs in the next string
+	dprint("LOG:	DEATH	");
+	dprint(targ.netname);
+	dprint("/");
+	dprint(ftos(targ.frags));
+	dprint("	");
+	dprint(attacker.netname);
+	dprint("/");
+	dprint(ftos(attacker.frags));
+	dprint("	");
+	dprint(what);
+	dprint("\n");
+};
+
+void (entity targ, string what) LogPlayerDeath =
+{
+	dprint("LOG:	DEATH	");
+	dprint(targ.netname);
+	dprint("/");
+	dprint(ftos(targ.frags));
+	dprint("	");
+	dprint(what);
+	dprint("\n");
+};
+
+void (entity who, string what) LogMsg =
+{
+	dprint("LOG:	");
+	dprint(what);
+	dprint("	");
+	dprint(who.netname);
+	dprint("\n");
+};
+
+/************\
+* BreakChain *
+\************/
+
+void (entity Head) BreakChain =
+{
+        local entity link;
+
+        link = Head.goalentity;
+        while (link != world)
+        {
+                Head = link.goalentity;
+                remove (link);
+                link = Head;
+        }
+};
+
+/*********\
+* LinkPos *
+\*********/
+
+void () LinkPos =
+{
+        makevectors (self.enemy.angles);
+        setorigin (self, self.owner.origin + ( ( ( self.enemy.origin + 
+                (v_up * 16 * (!self.enemy.button2)) + (v_forward * 16) ) - self.owner.origin ) *
+                ( self.weapon ) ) );
+        self.nextthink = time + 0.1;
+};
+
+/***********\
+* MakeChain *
+\***********/
+
+entity (entity head, entity tail, float num) MakeChain =
+{
+        local entity link, prevlink;
+        local float linknum;
+
+        linknum = num;
+        num = num + 1;
+        prevlink = world;
+        while (linknum > 0)
+        {
+                link = spawn();
+
+                link.goalentity = prevlink;
+                prevlink = link;
+
+                link.owner = head;
+                link.enemy = tail;
+                link.weapon = linknum / num;
+                link.movetype = MOVETYPE_NOCLIP;
+                link.solid = SOLID_NOT;
+                link.angles_z = 51 * linknum;
+                link.angles_y = 41 * linknum;
+                link.angles_x = 31 * linknum;
+                link.avelocity = '310 410 510';
+				if (teamplay & TEAM_CAPTURE_CUSTOM)
+					setmodel (link, "progs/bit.mdl");
+				else
+					setmodel (link, "progs/s_spike.mdl");
+                setsize (link, '0 0 0', '0 0 0');
+                makevectors (tail.angles);
+                setorigin (link, head.origin + ( ( ( tail.origin 
+                        + (v_up * 16 * (!tail.button2)) + ( v_forward * 16 ) ) - head.origin )
+                        * ( link.weapon ) ) );
+                link.nextthink = time + 0.1;
+                link.think = LinkPos;
+                linknum = linknum - 1;
+        }
+        return link;
+};
+
+
+/************\
+* HookVanish *
+\************/
+
+void () HookVanish =
+{
+        self.owner.hook_out = FALSE;
+/*
+        if (self.enemy.classname == "player")
+                self.enemy.attack_finished = time + 0.1;
+*/
+		if (teamplay & TEAM_CAPTURE_CUSTOM)
+			sound(self.owner, CHAN_WEAPON, "weapons/bounce2.wav", 1, ATTN_NORM);
+        BreakChain (self);
+        remove (self);
+};
+
+void() UnHookPlayer =
+{
+	local entity oself;
+
+	if (self.hook_out) {
+		oself = self;
+		self = self.goalentity;
+		HookVanish();
+		self = oself;
+	}
+};
+
+/**********\
+* HookPull *
+\**********/
+
+void () HookPull =
+{
+        local vector vel, spray;
+        local float v, dorg;
+
+	if ((!self.owner.button0 && (self.owner.weapon == IT_HOOK)) ||
+		(self.owner.teleport_time > time ) || self.owner.deadflag ) {
+		HookVanish();
+		return;
+	} else {
+		 if (self.enemy.takedamage) {
+			// don't hurt teammates
+			if (self.enemy.classname != "player" || !teamplay ||
+				self.enemy.lastteam != self.owner.lastteam) {
+				sound (self, CHAN_WEAPON, "blob/land1.wav", 1, ATTN_NORM);
+				T_Damage (self.enemy, self, self.owner, 1);
+				makevectors (self.v_angle);
+				spray_x = 100 * crandom();
+				spray_y = 100 * crandom();
+				spray_z = 100 * crandom() + 50;
+				SpawnBlood (self.origin, spray, 20);
+			}
+			if (self.enemy.solid == SOLID_SLIDEBOX) {
+					self.velocity = '0 0 0';
+					setorigin (self, self.enemy.origin +
+							self.enemy.mins +
+							(self.enemy.size * 0.5));
+			} else {
+					self.velocity = self.enemy.velocity;
+			}
+		} else {
+				self.velocity = self.enemy.velocity;
+		}
+		if (self.enemy.solid == SOLID_NOT) {
+				HookVanish();
+				return;
+		}
+		makevectors (self.owner.angles);
+		vel = self.origin - ( self.owner.origin + (v_up * 16 *
+				(!self.owner.button2)) + (v_forward * 16));
+		v = vlen (vel);
+		if (v <= 100)
+				vel = normalize(vel) * v * 10;  
+		if ( v > 100 )
+				vel = normalize(vel) * 1000;  
+
+		if (teamplay & TEAM_CAPTURE_CUSTOM) {
+			dorg = vlen(self.owner.origin - self.dest);
+			if (dorg > 10 && self.style == 3) {
+				sound(self.owner, CHAN_WEAPON, "weapons/chain2.wav", 1, ATTN_NORM);
+				self.style = 2;
+			}
+			if (dorg < 10 && self.style == 2) {
+				sound(self.owner, CHAN_WEAPON, "weapons/chain3.wav", 1, ATTN_NORM);
+				self.style = 3;
+			}
+		}
+
+		self.owner.velocity = vel;
+		self.dest = self.owner.origin;
+		self.nextthink = time + 0.1;
+	}
+};
+
+/**************\
+* T_ChainTouch *
+\**************/
+
+void() T_ChainTouch =
+{
+	if (other == self.owner)
+			return;         // don't attach to owner
+
+	if (pointcontents(self.origin) == CONTENT_SKY) {
+                HookVanish();
+                return;
+	}
+
+	if (other.classname == "player" && teamplay &&
+		other.team == self.owner.lastteam)
+		return; // just pass through teammates
+
+	if (other.takedamage) {
+		// don't damage teammates
+		if (other.classname == "player")
+			other.axhitme = 1; // make axe noise
+		else
+			sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
+		T_Damage (other, self, self.owner, 10 );
+		SpawnBlood (self.origin, self.velocity, 10);
+	} else {
+		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
+		self.avelocity = '0 0 0';
+	}
+                
+	if (!self.owner.button0) {
+			HookVanish();
+			return;
+	} else {
+			if (other.solid == SOLID_SLIDEBOX) {
+					setorigin (self, other.origin + other.mins +
+							(other.size * 0.5));
+					self.velocity = '0 0 0';
+			} else {
+					self.velocity = other.velocity;
+			}
+			self.weapon = other.nextthink - time;
+			if (teamplay & TEAM_CAPTURE_CUSTOM)
+				sound (self.owner, CHAN_WEAPON, "weapons/chain2.wav", 1, ATTN_NORM);
+
+			self.style = 2;
+			self.enemy = other;
+			self.nextthink = time + 0.1;
+			self.think = HookPull;
+			self.touch = SUB_Null;
+	}
+};
+
+/*************\
+* W_FireChain *
+\*************/
+
+void() W_FireChain =
+{
+        local entity hook;
+
+        self.hook_out = TRUE;
+        hook = spawn ();
+        hook.owner = self;
+		self.goalentity = hook;
+        hook.movetype = MOVETYPE_FLY;
+        hook.solid = SOLID_BBOX;
+		
+// set hook speed 
+
+        makevectors (self.v_angle);
+        hook.velocity = aim(self, 1000);
+        hook.velocity = hook.velocity * 800;
+        hook.angles = vectoangles(hook.velocity);
+        hook.avelocity = '0 0 -500';
+	
+        hook.touch = T_ChainTouch;
+	
+// set hook sound
+        hook.nextthink = time + 5;
+        hook.think = HookVanish;
+
+		if (teamplay & TEAM_CAPTURE_CUSTOM)
+			setmodel (hook, "progs/star.mdl");
+		else
+			setmodel (hook, "progs/v_spike.mdl");
+        setsize (hook, '0 0 0', '0 0 0');     
+        setorigin (hook, self.origin + (v_forward*16) + '0 0 16' );
+
+		if (teamplay & TEAM_CAPTURE_CUSTOM)
+			sound (self, CHAN_WEAPON, "weapons/chain1.wav", 1, ATTN_NORM);	
+		else
+			sound (self, CHAN_WEAPON, "hknight/hit.wav", 1, ATTN_NORM);	
+
+        hook.goalentity = MakeChain (hook, self, 3);
+};
+
+//---------------------------------------------------------------------------
+//Quake
+//
+//Copyright (c) 1995-96 by Dave Kirsch
+//---------------------------------------------------------------------------
+//admin - remove server admin functions
+//---------------------------------------------------------------------------
+
+// NOTE:  THE FOLLOWING VALUES ARE THE PASSWORD USED TO ENABLE
+// REMOTE ACCESS.
+//
+// The have the following properties and requirements:
+// a. Must not be an existing impulse
+// b. Must be entered in the specified order
+// c. Must be in the range 1 to 255 excluding previously used impulses
+//
+// They must be entered in the correct order which gives 256*256*256 or
+// 16777216 possible passwords.  If a specified order wasn't given, it
+// would only be 768 possibilities.
+//
+// BY DEFAULT, REMOTE ADMIN ACCESS IS DISABLED
+// This is done by setting the admin passwords all to -1.
+//
+// If you wanted to enable it, pick three random numbers (that aren't
+// existing impulses) and put 'em here, for example:
+//
+//		float	ADMIN_PWD_1	= 179;
+//		float	ADMIN_PWD_2	= 131;
+//		float	ADMIN_PWD_3	= 157;
+//
+// which would give you a password of 179, 131 and 157.  To send this from
+// a Quake client, do a bind like this:
+//
+// bind p "impulse 179;wait;impulse 131;wait;impulse 157"
+//
+// When you hit p, you'll be granted remote admin functionality.
+//
+// Currently the only admin functions available right now are kick
+// team change, and level change.  They are bound to impulse 151, 
+// impulse 152 and impuluse 153 respectively.
+//
+// The way it works is after you enter the admin password, do an
+// impulse 151/152/153.  You'll get a list of players on the server with their
+// numbers.  Send the next impulse with the number of the player
+// to act the command on.
+
+// CHANGE THE FOLLOWING THREE -1 NUMBERS TO YOUR ADMIN PASSWD
+float	ADMIN_PWD_1	= -1;  // change me to first number of the passwd
+float	ADMIN_PWD_2	= -1;  // change me to second number of the passwd
+float	ADMIN_PWD_3	= -1;  // change me to third number of the passwd
+
+float	ADMIN_KICK = 151;
+float	ADMIN_TEAMCHANGE = 152;
+float	ADMIN_CHANGEMAP = 153;
+float	ADMIN_GIVERUNE = 154;
+float	ADMIN_CAMERA = 155;
+float	ADMIN_TIMELIMIT = 156;
+float	ADMIN_FRAGLIMIT = 157;
+
+// used for admin to change maps
+void(string nmap) AdminChangeLevel =
+{
+	local entity o;
+
+	bprint(self.netname);
+	bprint(" has changed the level to ");
+	bprint(nmap);
+	bprint("\n");
+
+	o = spawn();
+	o.map = nmap;
+	nextmap = o.map;
+	gameover = TRUE;
+
+	o.think = execute_changelevel;
+	o.nextthink = time + 0.1;
+};
+
+void() CheckAdminCmd =
+{
+	local float n;
+	local entity p;
+	local string st;
+
+	if (ADMIN_PWD_1 < 0 || ADMIN_PWD_2 < 0 || ADMIN_PWD_3 < 0)
+		return; // disabled
+
+	if (self.impulse == ADMIN_PWD_1 && self.accesslvl == 0) {
+		self.accesslvl = self.accesslvl + 1;
+		return;
+
+	} else if (self.impulse == ADMIN_PWD_2 && self.accesslvl == 1) {
+		self.accesslvl = self.accesslvl + 1;
+		return;
+
+	} else if (self.impulse == ADMIN_PWD_3 && self.accesslvl == 2) {
+		self.accesslvl = self.accesslvl + 1;
+
+		bprint(self.netname);
+		bprint(" has become a sysop\n");
+
+		sprint(self, "Admin Impulse Codes:\n");
+		st = ftos(ADMIN_KICK);
+		sprint(self, st);
+		sprint(self, " to kick\nImpulse ");
+		st = ftos(ADMIN_TEAMCHANGE);
+		sprint(self, st);
+		sprint(self, " to switch teamplayer\n");
+		st = ftos(ADMIN_CHANGEMAP);
+		sprint(self, st);
+		sprint(self, " to change map\n");
+		st = ftos(ADMIN_GIVERUNE);
+		sprint(self, st);
+		sprint(self, " to give rune\n");
+		st = ftos(ADMIN_CAMERA);
+		sprint(self, st);
+		sprint(self, " to become autocam\n");
+		st = ftos(ADMIN_TIMELIMIT);
+		sprint(self, st);
+		sprint(self, " to set timelimit\n");
+		st = ftos(ADMIN_FRAGLIMIT);
+		sprint(self, st);
+		sprint(self, " to set fraglimit\n");
+		self.accessparm = 0;
+		return;
+	}
+
+	if (self.accesslvl < 3) {
+		self.accesslvl = 0;
+		self.accessparm = 0;
+		return; // must be a sysop beyond this point
+	}
+
+	if (self.accessparm == 1) { // kick cmd
+
+		n = self.impulse - 1;
+		p = find(world, classname, "player");
+		while (p != world && n > 0) {
+			p = find(p, classname, "player");
+			n = n - 1;
+		}
+
+		if (p != world) {
+			sprint(p, "\n\nYou have been kicked.\nGo abuse somewhere else.\n");
+			stuffcmd(p, "disconnect\n");
+			bprint(p.netname);
+			bprint(" was kicked by ");
+			bprint(self.netname);
+			bprint("\n");
+		} else {
+			sprint(self, "Can't kick #");
+			st = ftos(self.impulse);
+			sprint(self, st);
+			sprint(self, "\n");
+		}
+
+		self.accessparm = 0;
+		return;
+
+	} else if (self.accessparm == 2) { // switch teams
+
+		n = self.impulse - 1;
+		p = find(world, classname, "player");
+		while (p != world && n > 0) {
+			p = find(p, classname, "player");
+			n = n - 1;
+		}
+
+		if (p != world) {
+			TeamCaptureDropFlagOfPlayer(p);
+			centerprint(p, "YOU HAVE SWITCHED TEAMS!");
+			if (p.lastteam == TEAM_COLOR1) {
+				p.team = p.lastteam = TEAM_COLOR2;
+				st = ftos(TEAM_COLOR2 - 1);
+			} else {
+				p.team = p.lastteam = TEAM_COLOR1;
+				st = ftos(TEAM_COLOR1 - 1);
+			}
+			stuffcmd(p, "color ");
+			stuffcmd(p, st);
+			stuffcmd(p, "\n");
+			bprint(p.netname);
+			bprint(" changed teams (by ");
+			bprint(self.netname);
+			bprint(")\n");
+		} else {
+			sprint(self, "Can't change #");
+			st = ftos(self.impulse);
+			sprint(self, st);
+			sprint(self, "\n");
+		}
+
+		self.accessparm = 0;
+		return;
+
+	} else if (self.accessparm == 3) { // select episode
+
+		if (self.impulse == 1) {
+			self.accessparm = 4;
+
+			sprint(self, "Choose Level:\n");
+			sprint(self, "1 e1m1 Slipgate Complex\n");
+			sprint(self, "2 e1m2 Castle of the Damned\n");
+			sprint(self, "3 e1m3 The Necropolis\n");
+			sprint(self, "4 e1m4 The Grisly Grotto\n");
+			sprint(self, "5 e1m5 Gloom Keep\n");
+			sprint(self, "6 e1m6 The Door To Chthon\n");
+			sprint(self, "7 e1m7 The House of Chthon\n");
+			sprint(self, "8 e1m8 Ziggurat Vertigo\n");
+
+			self.impulse = 0;
+			return;
+
+		} else if (self.impulse == 2) {
+			self.accessparm = 5;
+
+			sprint(self, "Choose Level:\n");
+			sprint(self, "1 e2m1 The Installation\n");
+			sprint(self, "2 e2m2 Ogre Citadel\n");
+			sprint(self, "3 e2m3 Crypt of Decay\n");
+			sprint(self, "4 e2m4 The Ebon Fortress \n");
+			sprint(self, "5 e2m5 The Wizard's Manse\n");
+			sprint(self, "6 e2m6 The Dismal Oubliette\n");
+			sprint(self, "7 e2m7 Underearth\n");
+
+			self.impulse = 0;
+			return;
+
+		} else if (self.impulse == 3) {
+			self.accessparm = 6;
+
+			sprint(self, "Choose Level:\n");
+			sprint(self, "1 e3m1 Termination Central\n");
+			sprint(self, "2 e3m2 The Vaults of Zin\n");
+			sprint(self, "3 e3m3 The Tomb of Terror\n");
+			sprint(self, "4 e3m4 Satan's Dark Delight\n");
+			sprint(self, "5 e3m5 Wind Tunnels\n");
+			sprint(self, "6 e3m6 Chambers of Torment\n");
+			sprint(self, "7 e3m7 The Haunted Halls\n");
+
+			self.impulse = 0;
+			return;
+
+		} else if (self.impulse == 4) {
+			self.accessparm = 7;
+
+			sprint(self, "Choose Level:\n");
+			sprint(self, "1 e4m1 The Sewage System\n");
+			sprint(self, "2 e4m2 The Tower of Despair\n");
+			sprint(self, "3 e4m3 The Elder God Shrine\n");
+			sprint(self, "4 e4m4 The Palace of Hate\n");
+			sprint(self, "5 e4m5 Hell's Atrium\n");
+			sprint(self, "6 e4m6 The Pain Maze\n");
+			sprint(self, "7 e4m7 Azure Agony\n");
+			sprint(self, "8 e4m8 The Nameless City\n");
+
+			self.impulse = 0;
+			return;
+
+		} else if (self.impulse == 5) {
+			self.accessparm = 8;
+
+			sprint(self, "Choose Level:\n");
+			sprint(self, "1 dm1 Place of Two Deaths\n");
+			sprint(self, "2 dm2 Claustrophobopolis\n");
+			sprint(self, "3 dm3 The Abandoned Base\n");
+			sprint(self, "4 dm4 The Bad Place\n");
+			sprint(self, "5 dm5 The Cistern\n");
+			sprint(self, "6 dm6 The Dark Zone\n");
+
+			self.impulse = 0;
+			return;
+
+		} else if (self.impulse == 6) {
+			self.accessparm = 9;
+
+			sprint(self, "Choose Level:\n");
+			sprint(self, "1 ctf1 McKinley Base\n");
+			sprint(self, "2 ctf2 The Kiln\n");
+			sprint(self, "3 ctf3 Dysphoria\n");
+			sprint(self, "4 ctf4 The Forgotten Mines\n");
+			sprint(self, "5 ctf5 Da Ancient War Grounds\n");
+			sprint(self, "6 ctf6 Vertigo\n");
+			sprint(self, "7 ctf7 Tale of Two Cities\n");
+			sprint(self, "8 ctf8 The Strongbox\n");
+
+			self.impulse = 0;
+			return;
+
+		} else if (self.impulse == 7) {
+			self.accessparm = 10;
+
+			sprint(self, "Choose Level:\n");
+			sprint(self, "1 ctf2m1 McKinley Station\n");
+			sprint(self, "2 ctf2m2 The Warzone\n");
+			sprint(self, "3 ctf2m3 Spill the Blood\n");
+			sprint(self, "4 ctf2m4 Ruins of NeoMinonk\n");
+			sprint(self, "5 ctf2m5 Disciple War Grounds\n");
+			sprint(self, "6 ctf2m6 The Two Towers\n");
+			sprint(self, "7 ctf2m7 Gloom Castles\n");
+			sprint(self, "8 ctf2m8 Capturephobolis\n");
+
+			self.impulse = 0;
+			return;
+		}
+		sprint(self, "Invalid episode\n");
+		self.accessparm = 0;
+		return;
+
+	} else if (self.accessparm == 4) {
+
+		if (self.impulse == 1)		AdminChangeLevel("e1m1");
+		else if (self.impulse == 2)	AdminChangeLevel("e1m2");
+		else if (self.impulse == 3)	AdminChangeLevel("e1m3");
+		else if (self.impulse == 4)	AdminChangeLevel("e1m4");
+		else if (self.impulse == 5)	AdminChangeLevel("e1m5");
+		else if (self.impulse == 6)	AdminChangeLevel("e1m6");
+		else if (self.impulse == 7)	AdminChangeLevel("e1m7");
+		else if (self.impulse == 8)	AdminChangeLevel("e1m8");
+		else sprint(self, "Invalid map\n");
+		self.impulse = 0;
+		self.accessparm = 0;
+		return;
+			
+	} else if (self.accessparm == 5) {
+
+		if (self.impulse == 1)		AdminChangeLevel("e2m1");
+		else if (self.impulse == 2)	AdminChangeLevel("e2m2");
+		else if (self.impulse == 3)	AdminChangeLevel("e2m3");
+		else if (self.impulse == 4)	AdminChangeLevel("e2m4");
+		else if (self.impulse == 5)	AdminChangeLevel("e2m5");
+		else if (self.impulse == 6)	AdminChangeLevel("e2m6");
+		else if (self.impulse == 7)	AdminChangeLevel("e2m7");
+		else sprint(self, "Invalid map\n");
+		self.impulse = 0;
+		self.accessparm = 0;
+		return;
+			
+	} else if (self.accessparm == 6) {
+
+		if (self.impulse == 1)		AdminChangeLevel("e3m1");
+		else if (self.impulse == 2)	AdminChangeLevel("e3m2");
+		else if (self.impulse == 3)	AdminChangeLevel("e3m3");
+		else if (self.impulse == 4)	AdminChangeLevel("e3m4");
+		else if (self.impulse == 5)	AdminChangeLevel("e3m5");
+		else if (self.impulse == 6)	AdminChangeLevel("e3m6");
+		else if (self.impulse == 7)	AdminChangeLevel("e3m7");
+		else sprint(self, "Invalid map\n");
+		self.impulse = 0;
+		self.accessparm = 0;
+		return;
+			
+	} else if (self.accessparm == 7) {
+
+		if (self.impulse == 1)		AdminChangeLevel("e4m1");
+		else if (self.impulse == 2)	AdminChangeLevel("e4m2");
+		else if (self.impulse == 3)	AdminChangeLevel("e4m3");
+		else if (self.impulse == 4)	AdminChangeLevel("e4m4");
+		else if (self.impulse == 5)	AdminChangeLevel("e4m5");
+		else if (self.impulse == 6)	AdminChangeLevel("e4m6");
+		else if (self.impulse == 7)	AdminChangeLevel("e4m7");
+		else if (self.impulse == 8)	AdminChangeLevel("e4m8");
+		else sprint(self, "Invalid map\n");
+		self.impulse = 0;
+		self.accessparm = 0;
+		return;
+			
+	} else if (self.accessparm == 8) {
+
+		if (self.impulse == 1)		AdminChangeLevel("dm1");
+		else if (self.impulse == 2)	AdminChangeLevel("dm2");
+		else if (self.impulse == 3)	AdminChangeLevel("dm3");
+		else if (self.impulse == 4)	AdminChangeLevel("dm4");
+		else if (self.impulse == 5)	AdminChangeLevel("dm5");
+		else if (self.impulse == 6)	AdminChangeLevel("dm6");
+		else sprint(self, "Invalid map\n");
+		self.impulse = 0;
+		self.accessparm = 0;
+		return;
+			
+	} else if (self.accessparm == 9) {
+
+		if (self.impulse == 1)		AdminChangeLevel("ctf1");
+		else if (self.impulse == 2)	AdminChangeLevel("ctf2");
+		else if (self.impulse == 3)	AdminChangeLevel("ctf3");
+		else if (self.impulse == 4)	AdminChangeLevel("ctf4");
+		else if (self.impulse == 5)	AdminChangeLevel("ctf5");
+		else if (self.impulse == 6)	AdminChangeLevel("ctf6");
+		else if (self.impulse == 7)	AdminChangeLevel("ctf7");
+		else if (self.impulse == 8)	AdminChangeLevel("ctf8");
+		else sprint(self, "Invalid map\n");
+		self.impulse = 0;
+		self.accessparm = 0;
+		return;
+
+	} else if (self.accessparm == 10) {
+
+		if (self.impulse == 1)		AdminChangeLevel("ctf2m1");
+		else if (self.impulse == 2)	AdminChangeLevel("ctf2m2");
+		else if (self.impulse == 3)	AdminChangeLevel("ctf2m3");
+		else if (self.impulse == 4)	AdminChangeLevel("ctf2m4");
+		else if (self.impulse == 5)	AdminChangeLevel("ctf2m5");
+		else if (self.impulse == 6)	AdminChangeLevel("ctf2m6");
+		else if (self.impulse == 7)	AdminChangeLevel("ctf2m7");
+		else if (self.impulse == 8)	AdminChangeLevel("ctf2m8");
+		else sprint(self, "Invalid map\n");
+		self.impulse = 0;
+		self.accessparm = 0;
+		return;
+
+	} else if (self.accessparm == 20) { // give rune
+		if (self.impulse == 1) {
+			self.player_flag = self.player_flag | ITEM_RUNE1_FLAG;
+			sprint(self, "You now have the Earth Magic rune\n");
+		} else if (self.impulse == 2) {
+			self.player_flag = self.player_flag | ITEM_RUNE2_FLAG;
+			sprint(self, "You now have the Black Magic rune\n");
+		} else if (self.impulse == 3) {
+			self.player_flag = self.player_flag | ITEM_RUNE3_FLAG;
+			sprint(self, "You now have the Hell Magic rune\n");
+		} else if (self.impulse == 4) {
+			self.player_flag = self.player_flag | ITEM_RUNE4_FLAG;
+			sprint(self, "You now have the Elder Magic rune\n");
+		}
+
+		self.accessparm = 0;
+		return;
+
+	} else if (self.accessparm == 21) { // time limit
+		st = ftos(self.impulse);
+		localcmd("timelimit ");
+		localcmd(st);
+		localcmd("\n");
+		self.accessparm = 0;
+		return;
+
+	} else if (self.accessparm == 22) { // frag limit
+		st = ftos(self.impulse);
+		localcmd("fraglimit ");
+		localcmd(st);
+		localcmd("\n");
+		self.accessparm = 0;
+		return;
+
+	}
+
+	self.accessparm = 0;
+
+	if (self.impulse == ADMIN_KICK) {
+
+		sprint(self, "Kick:\n");
+		p = find(world, classname, "player");
+		n = 1;
+		while (p != world) {
+			st = ftos(n);
+			if (n < 10)
+				sprint(self, " ");
+			sprint(self, st);
+			sprint(self, " ");
+			sprint(self, p.netname);
+			sprint(self, "\n");
+			p = find(p, classname, "player");
+			n = n + 1;
+		}
+
+		self.accessparm = 1;
+
+	} else if (self.impulse == ADMIN_TEAMCHANGE) {
+
+		sprint(self, "Switch:\n");
+		p = find(world, classname, "player");
+		n = 1;
+		while (p != world) {
+			st = ftos(n);
+			if (n < 10)
+				sprint(self, " ");
+			sprint(self, st);
+			sprint(self, " ");
+			sprint(self, p.netname);
+			sprint(self, "\n");
+			p = find(p, classname, "player");
+			n = n + 1;
+		}
+
+		self.accessparm = 2;
+
+	} else if (self.impulse == ADMIN_CHANGEMAP) {
+		sprint(self, "Select Episode:\n");
+		sprint(self, "1 Dimension of the Doomed\n");
+		sprint(self, "2 Realm of Black Magic\n");
+		sprint(self, "3 Netherworld\n");
+		sprint(self, "4 The Elder World\n");
+		sprint(self, "5 The Deathmatch Arenas\n");
+		sprint(self, "6 Capture Levels - One\n");
+		sprint(self, "7 Capture Levels - Two\n");
+
+		self.accessparm = 3;
+
+	} else if (self.impulse == ADMIN_GIVERUNE) {
+		sprint(self, "Give Rune:\n");
+		sprint(self, "1 Earth Magic - Regeneration\n");
+		sprint(self, "2 Black Magic - Strength\n");
+		sprint(self, "3 Hell Magic - Haste\n");
+		sprint(self, "4 Elder Magic - Regen\n");
+
+		self.accessparm = 20;
+
+	} else if (self.impulse == ADMIN_CAMERA) {
+		self.CamState = CAM_BECOME;
+		sprint(self, "Becoming Camera\n");
+
+	} else if (self.impulse == ADMIN_TIMELIMIT) {
+		sprint(self, "Enter timelimit via impulse\n");
+		self.accessparm = 21;
+
+	} else if (self.impulse == ADMIN_FRAGLIMIT) {
+		sprint(self, "Enter fraglimit via impulse\n");
+		self.accessparm = 22;
+
+	}
+
+	self.impulse = 0;
+	return;
+};
+
+
+
+void() respawn;
+entity() SelectSpawnPoint;
+void() CheckAdminCmd;
+
+void(entity player,entity door) ObserverDoor =
+{
+  local entity d,d_master;
+  local vector dmin,dmax;
+    local float is_x,is_y,is_z,set;
+    local vector dir,or;
+  
+  d_master = d = door.owner;
+  if (d_master) {
+    dmin = d_master.absmin;
+    dmax = d_master.absmax;
+  } else { 
+    dmin = dmax = '0 0 0'; 
+  }
+  if (dmin != dmax) {
+    // regular doors
+    if (d_master.state != STATE_BOTTOM) return;
+    do {
+      // dprint (vtos(d.absmin)); dprint (" "); dprint (vtos(d.absmax)); dprint ("\n");
+      if (d.absmin_x < dmin_x) { dmin_x = d.absmin_x; }
+      if (d.absmax_x > dmax_x) { dmax_x = d.absmax_x; }
+      if (d.absmin_y < dmin_y) { dmin_y = d.absmin_y; }
+      if (d.absmax_y > dmax_y) { dmax_y = d.absmax_y; }
+      if (d.absmin_z < dmin_z) { dmin_z = d.absmin_z; }
+      if (d.absmax_z > dmax_z) { dmax_z = d.absmax_z; }
+      d = d.enemy; // next linked door;
+    } while ((d != d_master) && (d != world));
+  }
+  else {
+    // secret doors
+    // we ignore these currently
+    return;
+  }
+  
+    set = is_x = is_y = is_z = FALSE;
+    or = player.origin;
+    if (dmin_x + 15 < player.absmin_x && player.absmax_x < dmax_x - 15) is_x = TRUE;
+    if (dmin_y + 15 < player.absmin_y && player.absmax_y < dmax_y - 15) is_y = TRUE;
+    if (dmin_z + 15 < player.absmin_z && player.absmax_z < dmax_z - 15) is_z = TRUE;
+    // dprint("doors:  "); dprint (vtos(dmin)); dprint (" "); dprint (vtos(dmax)); dprint ("\n");
+    // dprint("player: "); dprint (vtos(player.absmin)); dprint (" "); dprint (vtos(player.absmax)); dprint ("\n");
+    if (is_x && is_y) {
+      // dprint("door is in xy plane\n");
+      if      (or_z < dmin_z) { dir = '0 0  1'; or_z = dmax_z + 25; }
+      else if (or_z > dmax_z) { dir = '0 0 -1'; or_z = dmin_z - 25; }
+      set = TRUE;
+    }
+    else if (is_x && is_z) {
+      // dprint("door is in xz plane\n");
+      if      (or_y < dmin_y) { dir = '0  1 0'; or_y = dmax_y + 25; }
+      else if (or_y > dmax_y) { dir = '0 -1 0'; or_y = dmin_y - 25; }
+      set = TRUE;
+    }
+    else if (is_y && is_z) {
+      // dprint("door is in yz plane\n");
+      if      (or_x < dmin_x) { dir = ' 1 0 0'; or_x = dmax_x + 25; }
+      else if (or_x > dmax_x) { dir = '-1 0 0'; or_x = dmin_x - 25; }
+      set = TRUE;
+    }
+      if (set) { 
+		local vector v;
+		v =  normalize(player.velocity);
+		if (dir * v < 0.5) return;
+		player.origin = or;
+		setorigin (player, player.origin);
+      }
+};
+
+void(entity player,entity tele) ObserverTeleporter =
+{
+  local entity targ;
+  local vector v1,v2;
+  
+  v1 = ((tele.absmax + tele.absmin) * 0.5) - player.origin; normalize(v1);
+  v2 = player.velocity; normalize(v2);
+  if (v1 * v2 <= 0.1) return;
+  
+  targ = find (world, targetname, tele.target);
+  if (!targ) {
+    dprint("ObserverTeleportThroughTeleporter: couldn't find teleporter target\n");
+    return;
+  }
+  makevectors (targ.mangle);
+  setorigin (player, targ.origin);
+  player.angles = targ.mangle;
+  player.fixangle = TRUE; // turn this way immediately
+  player.teleport_time = time + 0.7;
+  player.velocity = v_forward * 300;
+  // player.flags = player.flags - player.flags & FL_ONGROUND;
+};
+
+float() DoObserverImpulse =
+{
+	if (self.impulse == 1 || self.impulse == 2 || /* self.impulse == 3 ||  */
+		self.button2) {
+
+/*
+		if (self.impulse == 3) {
+			if (self.CamState == CAM_NOT)
+				self.CamState = CAM_BECOME;
+			return TRUE;
+		}
+*/
+
+		self.observer = 0;
+		self.CamState = CAM_NOT;
+		SetChangeParms ();
+		self.killed = 0;
+
+		if (self.impulse == 1)
+			self.team = self.lastteam = TEAM_COLOR1;
+		else if (self.impulse == 2)
+			self.team = self.lastteam = TEAM_COLOR2;
+		else {
+			self.lastteam = -50;
+			TeamCheckTeam();
+		}
+
+		if (self.lastteam == TEAM_COLOR1)  {
+			bprint(self.netname);
+			bprint(" joined  team!\n"); // red
+		} else if (self.lastteam == TEAM_COLOR2) {
+			bprint(self.netname);
+			bprint(" joined  team!\n"); // blue
+		}
+
+		self.impulse = 0;
+
+		self.player_flag = self.player_flag | TEAM_STUFF_COLOR;
+		if (teamplay & TEAM_CAPTURE_CUSTOM) {
+			if (self.lastteam == TEAM_COLOR1)
+				self.skin = 1;
+			else
+				self.skin = 3;
+			if (random() < 0.5)
+				self.skin = self.skin + 1; // visor dude
+			self.player_flag = self.player_flag - (self.player_flag & 65280);
+			self.player_flag = self.player_flag | (self.skin * 256);  
+		}
+
+		self.weapon = W_BestWeapon();
+		respawn();
+		W_SetCurrentAmmo();
+		return TRUE;
+	}
+	return FALSE;
+};
+
+void () ObserverThink =
+{
+    local entity e;
+    local float cont;
+
+	self.weaponmodel = "";
+	self.weaponframe = 0;
+	self.flags = self.flags | FL_ONGROUND;
+
+  { 
+    local float invcos,nv,nvp,nvpmax,nvs,nsp,sp,svz;
+    local vector f,vp,vs;
+    
+    svz = self.velocity_z * 0.75;
+    self.velocity_z = 0;
+    
+    // v_forward is already normalized
+    f_x = v_forward_x; 
+    f_y = v_forward_y; 
+    f_z = 0;
+    invcos = vlen(f); if (invcos) invcos= 1/invcos; else invcos=0;
+    f = f*invcos; // normalize f
+    
+    sp = f * self.velocity;
+    vp = sp*f;
+    nvp = vlen(vp); if (sp<0) nvp = nvp*(-1);
+    vs = self.velocity - vp;
+    
+    vp = v_forward * (nvp * invcos);
+    vp_z = vp_z + svz;
+    nvp = vlen(vp);
+    nvpmax = (320 - 100*(v_forward * '0 0 1'));
+    if (nvp > nvpmax) { vp = vp * (nvpmax/nvp); }
+    
+    self.velocity = vp + vs;
+  }
+  
+	// look for doors, etc.
+    e = findradius(self.origin,75);
+    while (e != world) {
+		if (e.classname == "door") {
+			ObserverDoor(self, e);
+			e = world;
+		}
+    	if (e.classname == "trigger_teleport") {
+			ObserverTeleporter(self,e);
+			e = world;
+        }
+        e = e.chain;
+		if (!e) e = world;
+    }
+
+	if (self.impulse && self.accessparm) { // admin functions
+		CheckAdminCmd();
+		self.impulse = 0;
+	} else if (DoObserverImpulse()) {
+		return;
+	} else if (self.impulse) {
+		CheckAdminCmd();
+		self.impulse = 0;
+	}
+};
+
+void(entity player) BecomeObserver =
+{
+	player.health           = 999;
+	player.takedamage       = DAMAGE_NO;
+	player.solid            = SOLID_NOT;
+	player.movetype         = MOVETYPE_FLY;
+	player.deadflag         = DEAD_NO;
+
+	setmodel (player, string_null);
+
+	player.weaponmodel      = "";
+	player.weaponframe      = 0;
+	player.weapon           = 0;
+
+	setsize(player, '-12 -12 -12', '12 12 12');
+	player.view_ofs = '0 0 10';
+
+	player.observer = 1;
+	player.do_observer = 0;
+};
+
+
+void() monster_ogre = {remove(self);};
+void() monster_demon1 = {remove(self);};
+void() monster_shambler = {remove(self);};
+void() monster_knight = {remove(self);};
+void() monster_army = {remove(self);};
+void() monster_wizard = {remove(self);};
+void() monster_dog = {remove(self);};
+void() monster_zombie = {remove(self);};
+void() monster_boss = {remove(self);};
+void() monster_tarbaby = {remove(self);};
+void() monster_hell_knight = {remove(self);};
+void() monster_fish = {remove(self);};
+void() monster_shalrath = {remove(self);};
+void() monster_enforcer = {remove(self);};
+void() monster_oldone = {remove(self);};
+
+/*
+==============================================================================
+
+MOVETARGET CODE
+
+The angle of the movetarget effects standing and bowing direction, but has no effect on movement, which allways heads to the next target.
+
+targetname
+must be present.  The name of this movetarget.
+
+target
+the next spot to move to.  If not present, stop here for good.
+
+pausetime
+The number of seconds to spend standing or bowing for path_stand or path_bow
+
+==============================================================================
+*/
+
+/*
+=============
+t_movetarget
+
+Something has bumped into a movetarget.  If it is a monster
+moving towards it, change the next destination and continue.
+==============
+*/
+void() t_movetarget =
+{
+local entity	temp;
+
+	if (other.movetarget != self)
+		return;
+	
+	if (other.enemy)
+		return;		// fighting, not following a path
+
+	temp = self;
+	self = other;
+	other = temp;
+
+	if (self.classname == "monster_ogre")
+		sound (self, CHAN_VOICE, "ogre/ogdrag.wav", 1, ATTN_IDLE);// play chainsaw drag sound
+
+//dprint ("t_movetarget\n");
+	self.goalentity = self.movetarget = find (world, targetname, other.target);
+	self.ideal_yaw = vectoyaw(self.goalentity.origin - self.origin);
+	if (!self.movetarget)
+	{
+		self.pausetime = time + 999999;
+		self.th_stand ();
+		return;
+	}
+};
+
+
+
+void() movetarget_f =
+{
+	if (!self.targetname)
+		objerror ("monster_movetarget: no targetname");
+		
+	self.solid = SOLID_TRIGGER;
+	self.touch = t_movetarget;
+	setsize (self, '-8 -8 -8', '8 8 8');
+	
+};
+
+/*QUAKED path_corner (0.5 0.3 0) (-8 -8 -8) (8 8 8)
+Monsters will continue walking towards the next target corner.
+*/
+void() path_corner =
+{
+	movetarget_f ();
+};
+
+
+
+//============================================================================
diff -ur --new-file src/sprites.qc kal-ctf/sprites.qc
--- src/sprites.qc	Thu Jan  1 00:00:00 1970
+++ kal-ctf/sprites.qc	Sun Oct  6 15:01:18 1996
@@ -0,0 +1,26 @@
+
+// these are the only sprites still in the game...
+
+$spritename s_explod
+$type vp_parallel
+$load id1/gfx/sprites/explod03.lbm
+$frame	24	24	56	56
+$frame	120	24	56	56
+$frame	216	24	56	56
+$frame	24	88	56	56
+$frame	120	88	56	56
+$frame	216	88	56	56
+
+
+$spritename s_bubble
+$type vp_parallel
+$load id1/gfx/sprites/bubble.lbm
+$frame	16	16	16	16
+$frame	40	16	16	16
+
+
+$spritename s_light
+$type vp_parallel
+$load id1/gfx/sprites/light.lbm
+$frame	104	32	32	32
+
diff -ur --new-file src/status.qc kal-ctf/status.qc
--- src/status.qc	Sun Apr 13 18:53:22 1997
+++ kal-ctf/status.qc	Fri May  2 22:38:52 1997
@@ -15,13 +15,35 @@
 	if (self.motd_count < 4) {
 		self.motd_count = self.motd_count + 1;
 		if (gamestart) {
-			centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nChoose an exit...\n"); //red
-			return;
+                        if (teamplay & TEAM_DROP_RUNE1) {
+                                centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nChoose an exit...\n\nwith Original Drop Rune mod!\n"); //red
+                                return;
+                        }
+                        else if (teamplay & TEAM_DROP_RUNE2) {
+                                centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nChoose an exit...\n\nwith *NEW* Drop Rune mod!\n"); //red
+                                return;
+                        }
+                        else {
+                                centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nChoose an exit...\n"); //red
+                                return;
+                        }
 		}
-		if (self.team == TEAM_COLOR1)
-			centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nYou are  team\n"); //red
-		else
-			centerprint(self, "Welcome!\nRunning Threewave CTF 4.0\n\n  !\n\nYou are  team"); //blue
+                if (self.team == TEAM_COLOR1) {
+                        if (teamplay & TEAM_DROP_RUNE1)
+                                centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nwith Droppable Runes!\n\nYou are  team\n"); //red
+                        else if (teamplay & TEAM_DROP_RUNE2)
+                                centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nwith Droppable Runes!\n\nYou are  team\n"); //red                                
+                        else
+                                centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nYou are  team\n"); //red
+                }
+                else {
+                        if (teamplay & TEAM_DROP_RUNE1)
+                                centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nwith Droppable Runes!\n\nYou are  team"); //blue
+                        else if (teamplay & TEAM_DROP_RUNE2)
+                                centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nwith Droppable Runes!\n\nYou are  team"); //blue                                
+                        else
+                                centerprint(self, "Welcome!\nRunning Threewave CTF 4.0\n\n  !\n\nYou are  team"); //blue
+                }
 		return;
 	}
 	self.motd_count = 0;
@@ -31,8 +53,18 @@
 {
 	if (self.motd_count < 6) {
 		self.motd_count = self.motd_count + 1;
-		centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nPress 1 for  team\nPress 2 for  team\nOr Press Jump for automatic team\n");
-		return;
+                if (teamplay & TEAM_DROP_RUNE1) {
+                        centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nwith Droppable Runes!\n\nPress 1 for  team\nPress 2 for  team\nOr Press Jump for automatic team\n");
+                        return;
+                }
+                else if (teamplay & TEAM_DROP_RUNE2) {
+                        centerprint(self, "Welcome!\nRunning -=CT=- Custom CTF 4.0\n\n  !\n\nwith Droppable Runes!\n\nPress 1 for  team\nPress 2 for  team\nOr Press Jump for automatic team\n");
+                        return;
+                }
+                else {
+                        centerprint(self, "Welcome!\nRunning ThreeWave CTF 4.0\n\n  !\n\nPress 1 for  team\nPress 2 for  team\nOr Press Jump for automatic team\n");
+                        return;
+                }                        
 	}
 	self.motd_count = 0;
 };
diff -ur --new-file src/teamplay.qc kal-ctf/teamplay.qc
--- src/teamplay.qc	Mon Apr 14 22:38:00 1997
+++ kal-ctf/teamplay.qc	Fri May  2 22:23:02 1997
@@ -42,6 +42,14 @@
 float TEAM_CAPTURE_CUSTOM = 	512;	// custom models
 float TEAM_CAPTURE_SELECT_TEAM = 1024; // team selection
 
+/* -=CT=-KALWeb : Begin Enhanced -=CT=-CTF Constants */
+float TEAM_DROP_RUNE1 =         2048; // Original allow droppable runes
+float TEAM_DROP_RUNE2 =         4096; // *New* allow droppable runes
+float TEAM_DROP_FLAG =          8192; // Allow droppable flag
+float DROP_RUNE_IMPULSE =       26; // Impulse to use to drop rune
+float DROP_FLAG_IMPULSE =       27; // Impulse to use to drop flag
+/* End -=CT=-KALWeb */
+
 float TEAM_CAPTURE_CAPTURE_BONUS = 15; // what you get for capture
 float TEAM_CAPTURE_TEAM_BONUS = 10; // what your team gets for capture
 float TEAM_CAPTURE_RECOVERY_BONUS = 1; // what you get for recovery
diff -ur --new-file src/weapons.qc kal-ctf/weapons.qc
--- src/weapons.qc	Mon Apr 14 13:37:36 1997
+++ kal-ctf/weapons.qc	Fri May  2 22:24:30 1997
@@ -1402,6 +1402,12 @@
 	else if (self.impulse == 99)
 		PrintLocation();
 		
+/* -=CT=-KALWeb : Begin Enhanced -=CT=-CTF */
+// If Rune Dropping is allowed, let me. :)
+        else if (!self.observer && ((teamplay & TEAM_DROP_RUNE1) || (teamplay & TEAM_DROP_RUNE2)) && (self.impulse & DROP_RUNE_IMPULSE))
+                TossRune();
+/* End -=CT=-KALWeb */
+
 // *TEAMPLAY*
 // If we're allowed to drop items, enable impulse 20 and 21
 	else if (!self.observer && (teamplay & TEAM_DROP_ITEMS) && self.impulse == 20)
