diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/demon.qc solidmn/demon.qc
--- v101qc/demon.qc	Thu Jul 25 01:51:22 1996
+++ solidmn/demon.qc	Wed Jul 31 22:15:01 1996
@@ -145,7 +145,7 @@
 void()	demon1_die4		=[	$death4,		demon1_die5	] {};
 void()	demon1_die5		=[	$death5,		demon1_die6	] {};
 void()	demon1_die6		=[	$death6,		demon1_die7	]
-{self.solid = SOLID_NOT;};
+{};
 void()	demon1_die7		=[	$death7,		demon1_die8	] {};
 void()	demon1_die8		=[	$death8,		demon1_die9	] {};
 void()	demon1_die9		=[	$death9,		demon1_die9 ] {};
@@ -156,15 +156,14 @@
 	if (self.health < -80)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_demon.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
+		monster_gib("progs/h_demon.mdl");
 		return;
 	}
 
 // regular death
 	demon1_die1 ();
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -12', "progs/h_demon.mdl");
 };
 
 
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/dog.qc solidmn/dog.qc
--- v101qc/dog.qc	Thu Jul 25 01:51:22 1996
+++ solidmn/dog.qc	Wed Jul 31 22:02:32 1996
@@ -1,363 +1,364 @@
-/*
-==============================================================================
-
-DOG
-
-==============================================================================
-*/
-$cd /raid/quake/id1/models/dog
-$origin 0 0 24
-$base base
-$skin skin
-
-$frame attack1 attack2 attack3 attack4 attack5 attack6 attack7 attack8
-
-$frame death1 death2 death3 death4 death5 death6 death7 death8 death9
-
-$frame deathb1 deathb2 deathb3 deathb4 deathb5 deathb6 deathb7 deathb8
-$frame deathb9
-
-$frame pain1 pain2 pain3 pain4 pain5 pain6
-
-$frame painb1 painb2 painb3 painb4 painb5 painb6 painb7 painb8 painb9 painb10
-$frame painb11 painb12 painb13 painb14 painb15 painb16
-
-$frame run1 run2 run3 run4 run5 run6 run7 run8 run9 run10 run11 run12
-
-$frame leap1 leap2 leap3 leap4 leap5 leap6 leap7 leap8 leap9
-
-$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8 stand9
-
-$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8
-
-
-void() dog_leap1;
-void() dog_run1;
-
-/*
-================
-dog_bite
-
-================
-*/
-void() dog_bite =
-{
-local vector	delta;
-local float 	ldmg;
-
-	if (!self.enemy)
-		return;
-
-	ai_charge(10);
-
-	if (!CanDamage (self.enemy, self))
-		return;
-
-	delta = self.enemy.origin - self.origin;
-
-	if (vlen(delta) > 100)
-		return;
-		
-	ldmg = (random() + random() + random()) * 8;
-	T_Damage (self.enemy, self, self, ldmg);
-};
-
-void()	Dog_JumpTouch =
-{
-	local	float	ldmg;
-
-	if (self.health <= 0)
-		return;
-		
-	if (other.takedamage)
-	{
-		if ( vlen(self.velocity) > 300 )
-		{
-			ldmg = 10 + 10*random();
-			T_Damage (other, self, self, ldmg);	
-		}
-	}
-
-	if (!checkbottom(self))
-	{
-		if (self.flags & FL_ONGROUND)
-		{	// jump randomly to not get hung up
-//dprint ("popjump\n");
-	self.touch = SUB_Null;
-	self.think = dog_leap1;
-	self.nextthink = time + 0.1;
-
-//			self.velocity_x = (random() - 0.5) * 600;
-//			self.velocity_y = (random() - 0.5) * 600;
-//			self.velocity_z = 200;
-//			self.flags = self.flags - FL_ONGROUND;
-		}
-		return;	// not on ground yet
-	}
-
-	self.touch = SUB_Null;
-	self.think = dog_run1;
-	self.nextthink = time + 0.1;
-};
-
-
-void() dog_stand1	=[	$stand1,	dog_stand2	] {ai_stand();};
-void() dog_stand2	=[	$stand2,	dog_stand3	] {ai_stand();};
-void() dog_stand3	=[	$stand3,	dog_stand4	] {ai_stand();};
-void() dog_stand4	=[	$stand4,	dog_stand5	] {ai_stand();};
-void() dog_stand5	=[	$stand5,	dog_stand6	] {ai_stand();};
-void() dog_stand6	=[	$stand6,	dog_stand7	] {ai_stand();};
-void() dog_stand7	=[	$stand7,	dog_stand8	] {ai_stand();};
-void() dog_stand8	=[	$stand8,	dog_stand9	] {ai_stand();};
-void() dog_stand9	=[	$stand9,	dog_stand1	] {ai_stand();};
-
-void() dog_walk1	=[	$walk1 ,	dog_walk2	] {
-if (random() < 0.2)
-	sound (self, CHAN_VOICE, "dog/idle.wav", 1, ATTN_IDLE);
-ai_walk(8);};
-void() dog_walk2	=[	$walk2 ,	dog_walk3	] {ai_walk(8);};
-void() dog_walk3	=[	$walk3 ,	dog_walk4	] {ai_walk(8);};
-void() dog_walk4	=[	$walk4 ,	dog_walk5	] {ai_walk(8);};
-void() dog_walk5	=[	$walk5 ,	dog_walk6	] {ai_walk(8);};
-void() dog_walk6	=[	$walk6 ,	dog_walk7	] {ai_walk(8);};
-void() dog_walk7	=[	$walk7 ,	dog_walk8	] {ai_walk(8);};
-void() dog_walk8	=[	$walk8 ,	dog_walk1	] {ai_walk(8);};
-
-void() dog_run1		=[	$run1  ,	dog_run2	] {
-if (random() < 0.2)
-	sound (self, CHAN_VOICE, "dog/idle.wav", 1, ATTN_IDLE);
-ai_run(16);};
-void() dog_run2		=[	$run2  ,	dog_run3	] {ai_run(32);};
-void() dog_run3		=[	$run3  ,	dog_run4	] {ai_run(32);};
-void() dog_run4		=[	$run4  ,	dog_run5	] {ai_run(20);};
-void() dog_run5		=[	$run5  ,	dog_run6	] {ai_run(64);};
-void() dog_run6		=[	$run6  ,	dog_run7	] {ai_run(32);};
-void() dog_run7		=[	$run7  ,	dog_run8	] {ai_run(16);};
-void() dog_run8		=[	$run8  ,	dog_run9	] {ai_run(32);};
-void() dog_run9		=[	$run9  ,	dog_run10	] {ai_run(32);};
-void() dog_run10	=[	$run10  ,	dog_run11	] {ai_run(20);};
-void() dog_run11	=[	$run11  ,	dog_run12	] {ai_run(64);};
-void() dog_run12	=[	$run12  ,	dog_run1	] {ai_run(32);};
-
-void() dog_atta1	=[	$attack1,	dog_atta2	] {ai_charge(10);};
-void() dog_atta2	=[	$attack2,	dog_atta3	] {ai_charge(10);};
-void() dog_atta3	=[	$attack3,	dog_atta4	] {ai_charge(10);};
-void() dog_atta4	=[	$attack4,	dog_atta5	] {
-sound (self, CHAN_VOICE, "dog/dattack1.wav", 1, ATTN_NORM);
-dog_bite();};
-void() dog_atta5	=[	$attack5,	dog_atta6	] {ai_charge(10);};
-void() dog_atta6	=[	$attack6,	dog_atta7	] {ai_charge(10);};
-void() dog_atta7	=[	$attack7,	dog_atta8	] {ai_charge(10);};
-void() dog_atta8	=[	$attack8,	dog_run1	] {ai_charge(10);};
-
-void() dog_leap1	=[	$leap1,		dog_leap2	] {ai_face();};
-void() dog_leap2	=[	$leap2,		dog_leap3	]
-{
-	ai_face();
-	
-	self.touch = Dog_JumpTouch;
-	makevectors (self.angles);
-	self.origin_z = self.origin_z + 1;
-	self.velocity = v_forward * 300 + '0 0 200';
-	if (self.flags & FL_ONGROUND)
-		self.flags = self.flags - FL_ONGROUND;
-};
-
-void() dog_leap3	=[	$leap3,		dog_leap4	] {};
-void() dog_leap4	=[	$leap4,		dog_leap5	] {};
-void() dog_leap5	=[	$leap5,		dog_leap6	] {};
-void() dog_leap6	=[	$leap6,		dog_leap7	] {};
-void() dog_leap7	=[	$leap7,		dog_leap8	] {};
-void() dog_leap8	=[	$leap8,		dog_leap9	] {};
-void() dog_leap9	=[	$leap9,		dog_leap9	] {};
-
-void() dog_pain1	=[	$pain1 ,	dog_pain2	] {};
-void() dog_pain2	=[	$pain2 ,	dog_pain3	] {};
-void() dog_pain3	=[	$pain3 ,	dog_pain4	] {};
-void() dog_pain4	=[	$pain4 ,	dog_pain5	] {};
-void() dog_pain5	=[	$pain5 ,	dog_pain6	] {};
-void() dog_pain6	=[	$pain6 ,	dog_run1	] {};
-
-void() dog_painb1	=[	$painb1 ,	dog_painb2	] {};
-void() dog_painb2	=[	$painb2 ,	dog_painb3	] {};
-void() dog_painb3	=[	$painb3 ,	dog_painb4	] {ai_pain(4);};
-void() dog_painb4	=[	$painb4 ,	dog_painb5	] {ai_pain(12);};
-void() dog_painb5	=[	$painb5 ,	dog_painb6	] {ai_pain(12);};
-void() dog_painb6	=[	$painb6 ,	dog_painb7	] {ai_pain(2);};
-void() dog_painb7	=[	$painb7 ,	dog_painb8	] {};
-void() dog_painb8	=[	$painb8 ,	dog_painb9	] {ai_pain(4);};
-void() dog_painb9	=[	$painb9 ,	dog_painb10	] {};
-void() dog_painb10	=[	$painb10 ,	dog_painb11	] {ai_pain(10);};
-void() dog_painb11	=[	$painb11 ,	dog_painb12	] {};
-void() dog_painb12	=[	$painb12 ,	dog_painb13	] {};
-void() dog_painb13	=[	$painb13 ,	dog_painb14	] {};
-void() dog_painb14	=[	$painb14 ,	dog_painb15	] {};
-void() dog_painb15	=[	$painb15 ,	dog_painb16	] {};
-void() dog_painb16	=[	$painb16 ,	dog_run1	] {};
-
-void() dog_pain =
-{
-	sound (self, CHAN_VOICE, "dog/dpain1.wav", 1, ATTN_NORM);
-
-	if (random() > 0.5)
-		dog_pain1 ();
-	else
-		dog_painb1 ();
-};
-
-void() dog_die1		=[	$death1,	dog_die2	] {};
-void() dog_die2		=[	$death2,	dog_die3	] {};
-void() dog_die3		=[	$death3,	dog_die4	] {};
-void() dog_die4		=[	$death4,	dog_die5	] {};
-void() dog_die5		=[	$death5,	dog_die6	] {};
-void() dog_die6		=[	$death6,	dog_die7	] {};
-void() dog_die7		=[	$death7,	dog_die8	] {};
-void() dog_die8		=[	$death8,	dog_die9	] {};
-void() dog_die9		=[	$death9,	dog_die9	] {};
-
-void() dog_dieb1		=[	$deathb1,	dog_dieb2	] {};
-void() dog_dieb2		=[	$deathb2,	dog_dieb3	] {};
-void() dog_dieb3		=[	$deathb3,	dog_dieb4	] {};
-void() dog_dieb4		=[	$deathb4,	dog_dieb5	] {};
-void() dog_dieb5		=[	$deathb5,	dog_dieb6	] {};
-void() dog_dieb6		=[	$deathb6,	dog_dieb7	] {};
-void() dog_dieb7		=[	$deathb7,	dog_dieb8	] {};
-void() dog_dieb8		=[	$deathb8,	dog_dieb9	] {};
-void() dog_dieb9		=[	$deathb9,	dog_dieb9	] {};
-
-
-void() dog_die =
-{
-// check for gib
-	if (self.health < -35)
-	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowHead ("progs/h_dog.mdl", self.health);
-		return;
-	}
-
-// regular death
-	sound (self, CHAN_VOICE, "dog/ddeath.wav", 1, ATTN_NORM);
-	self.solid = SOLID_NOT;
-
-	if (random() > 0.5)
-		dog_die1 ();
-	else
-		dog_dieb1 ();
-};
-
-//============================================================================
-
-/*
-==============
-CheckDogMelee
-
-Returns TRUE if a melee attack would hit right now
-==============
-*/
-float()	CheckDogMelee =
-{
-	if (enemy_range == RANGE_MELEE)
-	{	// FIXME: check canreach
-		self.attack_state = AS_MELEE;
-		return TRUE;
-	}
-	return FALSE;
-};
-
-/*
-==============
-CheckDogJump
-
-==============
-*/
-float()	CheckDogJump =
-{
-	local	vector	dist;
-	local	float	d;
-
-	if (self.origin_z + self.mins_z > self.enemy.origin_z + self.enemy.mins_z
-	+ 0.75 * self.enemy.size_z)
-		return FALSE;
-		
-	if (self.origin_z + self.maxs_z < self.enemy.origin_z + self.enemy.mins_z
-	+ 0.25 * self.enemy.size_z)
-		return FALSE;
-		
-	dist = self.enemy.origin - self.origin;
-	dist_z = 0;
-	
-	d = vlen(dist);
-	
-	if (d < 80)
-		return FALSE;
-		
-	if (d > 150)
-		return FALSE;
-		
-	return TRUE;
-};
-
-float()	DogCheckAttack =
-{
-	local	vector	vec;
-	
-// if close enough for slashing, go for it
-	if (CheckDogMelee ())
-	{
-		self.attack_state = AS_MELEE;
-		return TRUE;
-	}
-	
-	if (CheckDogJump ())
-	{
-		self.attack_state = AS_MISSILE;
-		return TRUE;
-	}
-	
-	return FALSE;
-};
-
-
-//===========================================================================
-
-/*QUAKED monster_dog (1 0 0) (-32 -32 -24) (32 32 40) Ambush
-
-*/
-void() monster_dog =
-{
-	if (deathmatch)
-	{
-		remove(self);
-		return;
-	}
-	precache_model ("progs/h_dog.mdl");
-	precache_model ("progs/dog.mdl");
-
-	precache_sound ("dog/dattack1.wav");
-	precache_sound ("dog/ddeath.wav");
-	precache_sound ("dog/dpain1.wav");
-	precache_sound ("dog/dsight.wav");
-	precache_sound ("dog/idle.wav");
-
-	self.solid = SOLID_SLIDEBOX;
-	self.movetype = MOVETYPE_STEP;
-
-	setmodel (self, "progs/dog.mdl");
-
-	setsize (self, '-32 -32 -24', '32 32 40');
-	self.health = 25;
-
-	self.th_stand = dog_stand1;
-	self.th_walk = dog_walk1;
-	self.th_run = dog_run1;
-	self.th_pain = dog_pain;
-	self.th_die = dog_die;
-	self.th_melee = dog_atta1;
-	self.th_missile = dog_leap1;
-
-	walkmonster_start();
-};
+/*
+==============================================================================
+
+DOG
+
+==============================================================================
+*/
+$cd /raid/quake/id1/models/dog
+$origin 0 0 24
+$base base
+$skin skin
+
+$frame attack1 attack2 attack3 attack4 attack5 attack6 attack7 attack8
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8 death9
+
+$frame deathb1 deathb2 deathb3 deathb4 deathb5 deathb6 deathb7 deathb8
+$frame deathb9
+
+$frame pain1 pain2 pain3 pain4 pain5 pain6
+
+$frame painb1 painb2 painb3 painb4 painb5 painb6 painb7 painb8 painb9 painb10
+$frame painb11 painb12 painb13 painb14 painb15 painb16
+
+$frame run1 run2 run3 run4 run5 run6 run7 run8 run9 run10 run11 run12
+
+$frame leap1 leap2 leap3 leap4 leap5 leap6 leap7 leap8 leap9
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8 stand9
+
+$frame walk1 walk2 walk3 walk4 walk5 walk6 walk7 walk8
+
+
+void() dog_leap1;
+void() dog_run1;
+
+/*
+================
+dog_bite
+
+================
+*/
+void() dog_bite =
+{
+local vector	delta;
+local float 	ldmg;
+
+	if (!self.enemy)
+		return;
+
+	ai_charge(10);
+
+	if (!CanDamage (self.enemy, self))
+		return;
+
+	delta = self.enemy.origin - self.origin;
+
+	if (vlen(delta) > 100)
+		return;
+		
+	ldmg = (random() + random() + random()) * 8;
+	T_Damage (self.enemy, self, self, ldmg);
+};
+
+void()	Dog_JumpTouch =
+{
+	local	float	ldmg;
+
+	if (self.health <= 0)
+		return;
+		
+	if (other.takedamage)
+	{
+		if ( vlen(self.velocity) > 300 )
+		{
+			ldmg = 10 + 10*random();
+			T_Damage (other, self, self, ldmg);	
+		}
+	}
+
+	if (!checkbottom(self))
+	{
+		if (self.flags & FL_ONGROUND)
+		{	// jump randomly to not get hung up
+//dprint ("popjump\n");
+	self.touch = SUB_Null;
+	self.think = dog_leap1;
+	self.nextthink = time + 0.1;
+
+//			self.velocity_x = (random() - 0.5) * 600;
+//			self.velocity_y = (random() - 0.5) * 600;
+//			self.velocity_z = 200;
+//			self.flags = self.flags - FL_ONGROUND;
+		}
+		return;	// not on ground yet
+	}
+
+	self.touch = SUB_Null;
+	self.think = dog_run1;
+	self.nextthink = time + 0.1;
+};
+
+
+void() dog_stand1	=[	$stand1,	dog_stand2	] {ai_stand();};
+void() dog_stand2	=[	$stand2,	dog_stand3	] {ai_stand();};
+void() dog_stand3	=[	$stand3,	dog_stand4	] {ai_stand();};
+void() dog_stand4	=[	$stand4,	dog_stand5	] {ai_stand();};
+void() dog_stand5	=[	$stand5,	dog_stand6	] {ai_stand();};
+void() dog_stand6	=[	$stand6,	dog_stand7	] {ai_stand();};
+void() dog_stand7	=[	$stand7,	dog_stand8	] {ai_stand();};
+void() dog_stand8	=[	$stand8,	dog_stand9	] {ai_stand();};
+void() dog_stand9	=[	$stand9,	dog_stand1	] {ai_stand();};
+
+void() dog_walk1	=[	$walk1 ,	dog_walk2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "dog/idle.wav", 1, ATTN_IDLE);
+ai_walk(8);};
+void() dog_walk2	=[	$walk2 ,	dog_walk3	] {ai_walk(8);};
+void() dog_walk3	=[	$walk3 ,	dog_walk4	] {ai_walk(8);};
+void() dog_walk4	=[	$walk4 ,	dog_walk5	] {ai_walk(8);};
+void() dog_walk5	=[	$walk5 ,	dog_walk6	] {ai_walk(8);};
+void() dog_walk6	=[	$walk6 ,	dog_walk7	] {ai_walk(8);};
+void() dog_walk7	=[	$walk7 ,	dog_walk8	] {ai_walk(8);};
+void() dog_walk8	=[	$walk8 ,	dog_walk1	] {ai_walk(8);};
+
+void() dog_run1		=[	$run1  ,	dog_run2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "dog/idle.wav", 1, ATTN_IDLE);
+ai_run(16);};
+void() dog_run2		=[	$run2  ,	dog_run3	] {ai_run(32);};
+void() dog_run3		=[	$run3  ,	dog_run4	] {ai_run(32);};
+void() dog_run4		=[	$run4  ,	dog_run5	] {ai_run(20);};
+void() dog_run5		=[	$run5  ,	dog_run6	] {ai_run(64);};
+void() dog_run6		=[	$run6  ,	dog_run7	] {ai_run(32);};
+void() dog_run7		=[	$run7  ,	dog_run8	] {ai_run(16);};
+void() dog_run8		=[	$run8  ,	dog_run9	] {ai_run(32);};
+void() dog_run9		=[	$run9  ,	dog_run10	] {ai_run(32);};
+void() dog_run10	=[	$run10  ,	dog_run11	] {ai_run(20);};
+void() dog_run11	=[	$run11  ,	dog_run12	] {ai_run(64);};
+void() dog_run12	=[	$run12  ,	dog_run1	] {ai_run(32);};
+
+void() dog_atta1	=[	$attack1,	dog_atta2	] {ai_charge(10);};
+void() dog_atta2	=[	$attack2,	dog_atta3	] {ai_charge(10);};
+void() dog_atta3	=[	$attack3,	dog_atta4	] {ai_charge(10);};
+void() dog_atta4	=[	$attack4,	dog_atta5	] {
+sound (self, CHAN_VOICE, "dog/dattack1.wav", 1, ATTN_NORM);
+dog_bite();};
+void() dog_atta5	=[	$attack5,	dog_atta6	] {ai_charge(10);};
+void() dog_atta6	=[	$attack6,	dog_atta7	] {ai_charge(10);};
+void() dog_atta7	=[	$attack7,	dog_atta8	] {ai_charge(10);};
+void() dog_atta8	=[	$attack8,	dog_run1	] {ai_charge(10);};
+
+void() dog_leap1	=[	$leap1,		dog_leap2	] {ai_face();};
+void() dog_leap2	=[	$leap2,		dog_leap3	]
+{
+	ai_face();
+	
+	self.touch = Dog_JumpTouch;
+	makevectors (self.angles);
+	self.origin_z = self.origin_z + 1;
+	self.velocity = v_forward * 300 + '0 0 200';
+	if (self.flags & FL_ONGROUND)
+		self.flags = self.flags - FL_ONGROUND;
+};
+
+void() dog_leap3	=[	$leap3,		dog_leap4	] {};
+void() dog_leap4	=[	$leap4,		dog_leap5	] {};
+void() dog_leap5	=[	$leap5,		dog_leap6	] {};
+void() dog_leap6	=[	$leap6,		dog_leap7	] {};
+void() dog_leap7	=[	$leap7,		dog_leap8	] {};
+void() dog_leap8	=[	$leap8,		dog_leap9	] {};
+void() dog_leap9	=[	$leap9,		dog_leap9	] {};
+
+void() dog_pain1	=[	$pain1 ,	dog_pain2	] {};
+void() dog_pain2	=[	$pain2 ,	dog_pain3	] {};
+void() dog_pain3	=[	$pain3 ,	dog_pain4	] {};
+void() dog_pain4	=[	$pain4 ,	dog_pain5	] {};
+void() dog_pain5	=[	$pain5 ,	dog_pain6	] {};
+void() dog_pain6	=[	$pain6 ,	dog_run1	] {};
+
+void() dog_painb1	=[	$painb1 ,	dog_painb2	] {};
+void() dog_painb2	=[	$painb2 ,	dog_painb3	] {};
+void() dog_painb3	=[	$painb3 ,	dog_painb4	] {ai_pain(4);};
+void() dog_painb4	=[	$painb4 ,	dog_painb5	] {ai_pain(12);};
+void() dog_painb5	=[	$painb5 ,	dog_painb6	] {ai_pain(12);};
+void() dog_painb6	=[	$painb6 ,	dog_painb7	] {ai_pain(2);};
+void() dog_painb7	=[	$painb7 ,	dog_painb8	] {};
+void() dog_painb8	=[	$painb8 ,	dog_painb9	] {ai_pain(4);};
+void() dog_painb9	=[	$painb9 ,	dog_painb10	] {};
+void() dog_painb10	=[	$painb10 ,	dog_painb11	] {ai_pain(10);};
+void() dog_painb11	=[	$painb11 ,	dog_painb12	] {};
+void() dog_painb12	=[	$painb12 ,	dog_painb13	] {};
+void() dog_painb13	=[	$painb13 ,	dog_painb14	] {};
+void() dog_painb14	=[	$painb14 ,	dog_painb15	] {};
+void() dog_painb15	=[	$painb15 ,	dog_painb16	] {};
+void() dog_painb16	=[	$painb16 ,	dog_run1	] {};
+
+void() dog_pain =
+{
+	sound (self, CHAN_VOICE, "dog/dpain1.wav", 1, ATTN_NORM);
+
+	if (random() > 0.5)
+		dog_pain1 ();
+	else
+		dog_painb1 ();
+};
+
+void() dog_die1		=[	$death1,	dog_die2	] {};
+void() dog_die2		=[	$death2,	dog_die3	] {};
+void() dog_die3		=[	$death3,	dog_die4	] {};
+void() dog_die4		=[	$death4,	dog_die5	] {};
+void() dog_die5		=[	$death5,	dog_die6	] {};
+void() dog_die6		=[	$death6,	dog_die7	] {};
+void() dog_die7		=[	$death7,	dog_die8	] {};
+void() dog_die8		=[	$death8,	dog_die9	] {};
+void() dog_die9		=[	$death9,	dog_die9	] {};
+
+void() dog_dieb1		=[	$deathb1,	dog_dieb2	] {};
+void() dog_dieb2		=[	$deathb2,	dog_dieb3	] {};
+void() dog_dieb3		=[	$deathb3,	dog_dieb4	] {};
+void() dog_dieb4		=[	$deathb4,	dog_dieb5	] {};
+void() dog_dieb5		=[	$deathb5,	dog_dieb6	] {};
+void() dog_dieb6		=[	$deathb6,	dog_dieb7	] {};
+void() dog_dieb7		=[	$deathb7,	dog_dieb8	] {};
+void() dog_dieb8		=[	$deathb8,	dog_dieb9	] {};
+void() dog_dieb9		=[	$deathb9,	dog_dieb9	] {};
+
+void() dog_die =
+{
+// check for gib
+	if (self.health < -35)
+	{
+                sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		monster_gib("progs/h_dog.mdl");
+		return;
+	}
+
+// regular death
+	sound (self, CHAN_VOICE, "dog/ddeath.wav", 1, ATTN_NORM);
+	//self.solid = SOLID_NOT;
+
+	if (random() > 0.5)
+		dog_die1 ();
+	else
+		dog_dieb1 ();
+
+// We want a corpse:  No actions, a little health, and a new .th_die
+// Frob some flags so we're damagable as well
+
+	monster_corpse_setup('-32 -32 -24', '32 32 -12',"progs/h_dog.mdl"); 
+};
+
+//============================================================================
+
+/*
+==============
+CheckDogMelee
+
+Returns TRUE if a melee attack would hit right now
+==============
+*/
+float()	CheckDogMelee =
+{
+	if (enemy_range == RANGE_MELEE)
+	{	// FIXME: check canreach
+		self.attack_state = AS_MELEE;
+		return TRUE;
+	}
+	return FALSE;
+};
+
+/*
+==============
+CheckDogJump
+
+==============
+*/
+float()	CheckDogJump =
+{
+	local	vector	dist;
+	local	float	d;
+
+	if (self.origin_z + self.mins_z > self.enemy.origin_z + self.enemy.mins_z
+	+ 0.75 * self.enemy.size_z)
+		return FALSE;
+		
+	if (self.origin_z + self.maxs_z < self.enemy.origin_z + self.enemy.mins_z
+	+ 0.25 * self.enemy.size_z)
+		return FALSE;
+		
+	dist = self.enemy.origin - self.origin;
+	dist_z = 0;
+	
+	d = vlen(dist);
+	
+	if (d < 80)
+		return FALSE;
+		
+	if (d > 150)
+		return FALSE;
+		
+	return TRUE;
+};
+
+float()	DogCheckAttack =
+{
+	local	vector	vec;
+	
+// if close enough for slashing, go for it
+	if (CheckDogMelee ())
+	{
+		self.attack_state = AS_MELEE;
+		return TRUE;
+	}
+	
+	if (CheckDogJump ())
+	{
+		self.attack_state = AS_MISSILE;
+		return TRUE;
+	}
+	
+	return FALSE;
+};
+
+
+//===========================================================================
+
+/*QUAKED monster_dog (1 0 0) (-32 -32 -24) (32 32 40) Ambush
+
+*/
+void() monster_dog =
+{
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model ("progs/h_dog.mdl");
+	precache_model ("progs/dog.mdl");
+
+	precache_sound ("dog/dattack1.wav");
+	precache_sound ("dog/ddeath.wav");
+	precache_sound ("dog/dpain1.wav");
+	precache_sound ("dog/dsight.wav");
+	precache_sound ("dog/idle.wav");
+
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+
+	setmodel (self, "progs/dog.mdl");
+
+	setsize (self, '-32 -32 -24', '32 32 40');
+	self.health = 25;
+
+	self.th_stand = dog_stand1;
+	self.th_walk = dog_walk1;
+	self.th_run = dog_run1;
+	self.th_pain = dog_pain;
+	self.th_die = dog_die;
+	self.th_melee = dog_atta1;
+	self.th_missile = dog_leap1;
+
+	walkmonster_start();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/enforcer.qc solidmn/enforcer.qc
--- v101qc/enforcer.qc	Thu Jul 25 01:51:22 1996
+++ solidmn/enforcer.qc	Wed Jul 31 22:12:10 1996
@@ -256,7 +256,7 @@
 void()	enf_die1	=[	$death1,	enf_die2	] {};
 void()	enf_die2	=[	$death2,	enf_die3	] {};
 void()	enf_die3	=[	$death3,	enf_die4	]
-{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+{self.ammo_cells = 5;DropBackpack();};
 void()	enf_die4	=[	$death4,	enf_die5	] {ai_forward(14);};
 void()	enf_die5	=[	$death5,	enf_die6	] {ai_forward(2);};
 void()	enf_die6	=[	$death6,	enf_die7	] {};
@@ -274,7 +274,7 @@
 };
 void()	enf_fdie2	=[	$fdeath2,	enf_fdie3	] {};
 void()	enf_fdie3	=[	$fdeath3,	enf_fdie4	] 
-{self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
+{self.ammo_cells = 5;DropBackpack();};
 void()	enf_fdie4	=[	$fdeath4,	enf_fdie5	] {};
 void()	enf_fdie5	=[	$fdeath5,	enf_fdie6	] {};
 void()	enf_fdie6	=[	$fdeath6,	enf_fdie7	] {};
@@ -284,17 +284,13 @@
 void()	enf_fdie10	=[	$fdeath10,	enf_fdie11	] {};
 void()	enf_fdie11	=[	$fdeath11,	enf_fdie11	] {};
 
-
 void() enf_die =
 {
 // check for gib
 	if (self.health < -35)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_mega.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("h/mega.mdl");
 		return;
 	}
 
@@ -304,6 +300,8 @@
 		enf_die1 ();
 	else
 		enf_fdie1 ();
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -8', "progs/h_mega.mdl");
 };
 
 
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/hknight.qc solidmn/hknight.qc
--- v101qc/hknight.qc	Thu Jul 25 01:51:23 1996
+++ solidmn/hknight.qc	Wed Jul 31 22:22:00 1996
@@ -175,7 +175,7 @@
 void()	hknight_die1	=[	$death1,	hknight_die2	] {ai_forward(10);};
 void()	hknight_die2	=[	$death2,	hknight_die3	] {ai_forward(8);};
 void()	hknight_die3	=[	$death3,	hknight_die4	]
-{self.solid = SOLID_NOT; ai_forward(7);};
+{ai_forward(7);};
 void()	hknight_die4	=[	$death4,	hknight_die5	] {};
 void()	hknight_die5	=[	$death5,	hknight_die6	] {};
 void()	hknight_die6	=[	$death6,	hknight_die7	] {};
@@ -189,7 +189,7 @@
 void()	hknight_dieb1	=[	$deathb1,	hknight_dieb2	] {};
 void()	hknight_dieb2	=[	$deathb2,	hknight_dieb3	] {};
 void()	hknight_dieb3	=[	$deathb3,	hknight_dieb4	]
-{self.solid = SOLID_NOT;};
+{};
 void()	hknight_dieb4	=[	$deathb4,	hknight_dieb5	] {};
 void()	hknight_dieb5	=[	$deathb5,	hknight_dieb6	] {};
 void()	hknight_dieb6	=[	$deathb6,	hknight_dieb7	] {};
@@ -203,10 +203,7 @@
 	if (self.health < -40)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_hellkn.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_hellkn.mdl");
 		return;
 	}
 
@@ -216,6 +213,7 @@
 		hknight_die1 ();
 	else
 		hknight_dieb1 ();
+	monster_corpse_setup ( '-16 -16 -24', '16 16 -12', "progs/h_hellkn.mdl");
 };
 
 
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/jsubs.qc solidmn/jsubs.qc
--- v101qc/jsubs.qc	Wed Dec 31 18:00:00 1969
+++ solidmn/jsubs.qc	Tue Jul 30 22:34:23 1996
@@ -0,0 +1,18 @@
+void(string gibname, float dm) ThrowGib;
+float() random;
+
+void() SUB_Gib =
+{
+	local vector x,y,v;
+	x='1 0 0';
+	y='0 1 0';
+	v=x*(50-random()*100)+y*(50-random()*100);
+	if (random() < 0.8)  // Meat spray only, most of the time
+		SpawnMeatSpray(self.origin, v);
+        else if (random() < 0.3)
+                ThrowGib("progs/gib1.mdl", self.health);
+        else if (random() < 0.5)
+                ThrowGib("progs/gib2.mdl", self.health);
+        else
+                ThrowGib("progs/gib3.mdl", self.health);
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/knight.qc solidmn/knight.qc
--- v101qc/knight.qc	Thu Jul 25 01:51:23 1996
+++ solidmn/knight.qc	Wed Jul 31 22:16:25 1996
@@ -186,7 +186,7 @@
 void()	knight_die1	=[	$death1,	knight_die2	] {};
 void()	knight_die2	=[	$death2,	knight_die3	] {};
 void()	knight_die3	=[	$death3,	knight_die4	] 
-{self.solid = SOLID_NOT;};
+{};
 void()	knight_die4	=[	$death4,	knight_die5	] {};
 void()	knight_die5	=[	$death5,	knight_die6	] {};
 void()	knight_die6	=[	$death6,	knight_die7	] {};
@@ -199,7 +199,7 @@
 void()	knight_dieb1	=[	$deathb1,	knight_dieb2	] {};
 void()	knight_dieb2	=[	$deathb2,	knight_dieb3	] {};
 void()	knight_dieb3	=[	$deathb3,	knight_dieb4	] 	
-{self.solid = SOLID_NOT;};
+{};
 void()	knight_dieb4	=[	$deathb4,	knight_dieb5	] {};
 void()	knight_dieb5	=[	$deathb5,	knight_dieb6	] {};
 void()	knight_dieb6	=[	$deathb6,	knight_dieb7	] {};
@@ -209,17 +209,13 @@
 void()	knight_dieb10 = [	$deathb10,	knight_dieb11] {};
 void()	knight_dieb11 = [	$deathb11,	knight_dieb11] {};
 
-
 void() knight_die =
 {
 // check for gib
 	if (self.health < -40)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_knight.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_knight.mdl");
 		return;
 	}
 
@@ -229,6 +225,7 @@
 		knight_die1 ();
 	else
 		knight_dieb1 ();
+	monster_corpse_setup('-16 -16 -24', '16 16 -12', "progs/h_knight.mdl");
 };
 
 
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/monsters.qc solidmn/monsters.qc
--- v101qc/monsters.qc	Thu Jul 25 01:51:23 1996
+++ solidmn/monsters.qc	Wed Jul 31 22:37:54 1996
@@ -38,6 +38,44 @@
 	self.think = FoundTarget;
 };
 
+void() monster_dead_push =
+{
+	local float dir;
+	dir = vectoyaw(other.velocity);
+	self.origin = self.origin + '0 0 1'; // Now we can be lifted, pushed off ledges, &c
+	walkmove(dir, 7);
+};
+
+void(string headmdl) monster_gib =
+{
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+	ThrowHead (headmdl, self.health);
+};
+	
+void() monster_corpse_gib =
+{
+	monster_gib(self.weaponmodel);
+};
+
+void(vector bb1, vector bb2, string headmdl) monster_corpse_setup =
+{
+	setsize(self, bb1, bb2);
+	self.weaponmodel=headmdl; // This should be unused in monsters
+	self.health=35;
+	self.th_stand = SUB_Null;
+	self.th_walk = SUB_Null;
+	self.th_run = SUB_Null;
+        self.th_pain = SUB_Gib;
+        self.th_die = monster_corpse_gib;
+	self.th_melee = SUB_Null;
+	self.th_missile = SUB_Null;
+	// self.touch = monster_dead_push; // This does funny things
+	self.takedamage= DAMAGE_AIM; // grenades explode 
+	self.flags = self.flags &! FL_MONSTER;  // Next "death" isn't counted
+};
+
 /*
 ================
 monster_death_use
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/ogre.qc solidmn/ogre.qc
--- v101qc/ogre.qc	Thu Jul 25 01:51:23 1996
+++ solidmn/ogre.qc	Wed Jul 31 22:21:37 1996
@@ -354,8 +354,7 @@
 void()	ogre_die1	=[	$death1,	ogre_die2	] {};
 void()	ogre_die2	=[	$death2,	ogre_die3	] {};
 void()	ogre_die3	=[	$death3,	ogre_die4	]
-{self.solid = SOLID_NOT;
-self.ammo_rockets = 2;DropBackpack();};
+{ self.ammo_rockets = 2;DropBackpack();};
 void()	ogre_die4	=[	$death4,	ogre_die5	] {};
 void()	ogre_die5	=[	$death5,	ogre_die6	] {};
 void()	ogre_die6	=[	$death6,	ogre_die7	] {};
@@ -371,8 +370,7 @@
 void()	ogre_bdie1	=[	$bdeath1,	ogre_bdie2	] {};
 void()	ogre_bdie2	=[	$bdeath2,	ogre_bdie3	] {ai_forward(5);};
 void()	ogre_bdie3	=[	$bdeath3,	ogre_bdie4	]
-{self.solid = SOLID_NOT;
-self.ammo_rockets = 2;DropBackpack();};
+{self.ammo_rockets = 2;DropBackpack();};
 void()	ogre_bdie4	=[	$bdeath4,	ogre_bdie5	] {ai_forward(1);};
 void()	ogre_bdie5	=[	$bdeath5,	ogre_bdie6	] {ai_forward(3);};
 void()	ogre_bdie6	=[	$bdeath6,	ogre_bdie7	] {ai_forward(7);};
@@ -387,10 +385,7 @@
 	if (self.health < -80)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_ogre.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_ogre.mdl");
 		return;
 	}
 
@@ -400,6 +395,10 @@
 		ogre_die1 ();
 	else
 		ogre_bdie1 ();
+// We want a corpse:  No actions, a little health, and a new .th_die
+// Frob some flags so we're damagable as well
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -8', "progs/h_ogre.mdl");
 };
 
 void() ogre_melee =
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/progs.src solidmn/progs.src
--- v101qc/progs.src	Wed Jul 31 21:15:26 1996
+++ solidmn/progs.src	Wed Jul 31 21:24:22 1996
@@ -1,35 +1,36 @@
-progs.dat
-
-defs.qc
-subs.qc
-fight.qc
-ai.qc
-combat.qc
-items.qc
-weapons.qc
-world.qc
-client.qc
-player.qc
-monsters.qc
-doors.qc
-buttons.qc
-triggers.qc
-plats.qc
-misc.qc
-
-ogre.qc
-demon.qc
-shambler.qc
-knight.qc
-soldier.qc
-wizard.qc
-dog.qc
-zombie.qc
-boss.qc
-
-tarbaby.qc		// registered
-hknight.qc		// registered
-fish.qc			// registered
-shalrath.qc		// registered
-enforcer.qc		// registered
-oldone.qc		// registered
+progs.dat
+
+defs.qc
+subs.qc
+fight.qc
+ai.qc
+combat.qc
+items.qc
+weapons.qc
+world.qc
+client.qc
+player.qc
+jsubs.qc
+monsters.qc
+doors.qc
+buttons.qc
+triggers.qc
+plats.qc
+misc.qc
+
+ogre.qc
+demon.qc
+shambler.qc
+knight.qc
+soldier.qc
+wizard.qc
+dog.qc
+zombie.qc
+boss.qc
+
+tarbaby.qc		// registered
+hknight.qc		// registered
+fish.qc			// registered
+shalrath.qc		// registered
+enforcer.qc		// registered
+oldone.qc		// registered
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/shalrath.qc solidmn/shalrath.qc
--- v101qc/shalrath.qc	Thu Jul 25 01:51:23 1996
+++ solidmn/shalrath.qc	Wed Jul 31 22:21:41 1996
@@ -103,17 +103,15 @@
 	if (self.health < -90)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_shal.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_shal.mdl");
 		return;
 	}
 
 	sound (self, CHAN_VOICE, "shalrath/death.wav", 1, ATTN_NORM);
 	shal_death1();
-	self.solid = SOLID_NOT;
+	// self.solid = SOLID_NOT;
 	// insert death sounds here
+	monster_corpse_setup('-16 -16 -24', '16 16 -10', "progs/h_shal.mdl");
 };
 
 /*
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/shambler.qc solidmn/shambler.qc
--- v101qc/shambler.qc	Thu Jul 25 01:51:24 1996
+++ solidmn/shambler.qc	Wed Jul 31 22:21:46 1996
@@ -293,7 +293,7 @@
 
 void() sham_death1      =[      $death1,       sham_death2     ] {};
 void() sham_death2      =[      $death2,       sham_death3     ] {};
-void() sham_death3      =[      $death3,       sham_death4     ] {self.solid = SOLID_NOT;};
+void() sham_death3      =[      $death3,       sham_death4     ] {};
 void() sham_death4      =[      $death4,       sham_death5     ] {};
 void() sham_death5      =[      $death5,       sham_death6     ] {};
 void() sham_death6      =[      $death6,       sham_death7     ] {};
@@ -309,16 +309,15 @@
 	if (self.health < -60)
 	{
 		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_shams.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		monster_gib("progs/h_shams.mdl");
 		return;
 	}
 
 // regular death
 	sound (self, CHAN_VOICE, "shambler/sdeath.wav", 1, ATTN_NORM);
 	sham_death1 ();
+        self.health=300;
+	monster_corpse_setup ('-16 -16 -24', '42 42 -4', "progs/h_shams.mdl");
 };
 
 //============================================================================
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/soldier.qc solidmn/soldier.qc
--- v101qc/soldier.qc	Thu Jul 25 01:51:24 1996
+++ solidmn/soldier.qc	Wed Jul 31 22:31:32 1996
@@ -1,284 +1,285 @@
-/*
-==============================================================================
-
-SOLDIER / PLAYER
-
-==============================================================================
-*/
-
-$cd /raid/quake/id1/models/soldier3
-$origin 0 -6 24
-$base base		
-$skin skin
-
-$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8
-
-$frame death1 death2 death3 death4 death5 death6 death7 death8
-$frame death9 death10
-
-$frame deathc1 deathc2 deathc3 deathc4 deathc5 deathc6 deathc7 deathc8
-$frame deathc9 deathc10 deathc11
-
-$frame load1 load2 load3 load4 load5 load6 load7 load8 load9 load10 load11
-
-$frame pain1 pain2 pain3 pain4 pain5 pain6
-
-$frame painb1 painb2 painb3 painb4 painb5 painb6 painb7 painb8 painb9 painb10
-$frame painb11 painb12 painb13 painb14
-
-$frame painc1 painc2 painc3 painc4 painc5 painc6 painc7 painc8 painc9 painc10
-$frame painc11 painc12 painc13
-
-$frame run1 run2 run3 run4 run5 run6 run7 run8
-
-$frame shoot1 shoot2 shoot3 shoot4 shoot5 shoot6 shoot7 shoot8 shoot9
-
-$frame prowl_1 prowl_2 prowl_3 prowl_4 prowl_5 prowl_6 prowl_7 prowl_8
-$frame prowl_9 prowl_10 prowl_11 prowl_12 prowl_13 prowl_14 prowl_15 prowl_16
-$frame prowl_17 prowl_18 prowl_19 prowl_20 prowl_21 prowl_22 prowl_23 prowl_24
-
-/*
-==============================================================================
-SOLDIER CODE
-==============================================================================
-*/
-
-void() army_fire;
-
-void()	army_stand1	=[	$stand1,	army_stand2	] {ai_stand();};
-void()	army_stand2	=[	$stand2,	army_stand3	] {ai_stand();};
-void()	army_stand3	=[	$stand3,	army_stand4	] {ai_stand();};
-void()	army_stand4	=[	$stand4,	army_stand5	] {ai_stand();};
-void()	army_stand5	=[	$stand5,	army_stand6	] {ai_stand();};
-void()	army_stand6	=[	$stand6,	army_stand7	] {ai_stand();};
-void()	army_stand7	=[	$stand7,	army_stand8	] {ai_stand();};
-void()	army_stand8	=[	$stand8,	army_stand1	] {ai_stand();};
-
-void()	army_walk1	=[	$prowl_1,	army_walk2	] {
-if (random() < 0.2)
-	sound (self, CHAN_VOICE, "soldier/idle.wav", 1, ATTN_IDLE);
-ai_walk(1);};
-void()	army_walk2	=[	$prowl_2,	army_walk3	] {ai_walk(1);};
-void()	army_walk3	=[	$prowl_3,	army_walk4	] {ai_walk(1);};
-void()	army_walk4	=[	$prowl_4,	army_walk5	] {ai_walk(1);};
-void()	army_walk5	=[	$prowl_5,	army_walk6	] {ai_walk(2);};
-void()	army_walk6	=[	$prowl_6,	army_walk7	] {ai_walk(3);};
-void()	army_walk7	=[	$prowl_7,	army_walk8	] {ai_walk(4);};
-void()	army_walk8	=[	$prowl_8,	army_walk9	] {ai_walk(4);};
-void()	army_walk9	=[	$prowl_9,	army_walk10	] {ai_walk(2);};
-void()	army_walk10	=[	$prowl_10,	army_walk11	] {ai_walk(2);};
-void()	army_walk11	=[	$prowl_11,	army_walk12	] {ai_walk(2);};
-void()	army_walk12	=[	$prowl_12,	army_walk13	] {ai_walk(1);};
-void()	army_walk13	=[	$prowl_13,	army_walk14	] {ai_walk(0);};
-void()	army_walk14	=[	$prowl_14,	army_walk15	] {ai_walk(1);};
-void()	army_walk15	=[	$prowl_15,	army_walk16	] {ai_walk(1);};
-void()	army_walk16	=[	$prowl_16,	army_walk17	] {ai_walk(1);};
-void()	army_walk17	=[	$prowl_17,	army_walk18	] {ai_walk(3);};
-void()	army_walk18	=[	$prowl_18,	army_walk19	] {ai_walk(3);};
-void()	army_walk19	=[	$prowl_19,	army_walk20	] {ai_walk(3);};
-void()	army_walk20	=[	$prowl_20,	army_walk21	] {ai_walk(3);};
-void()	army_walk21	=[	$prowl_21,	army_walk22	] {ai_walk(2);};
-void()	army_walk22	=[	$prowl_22,	army_walk23	] {ai_walk(1);};
-void()	army_walk23	=[	$prowl_23,	army_walk24	] {ai_walk(1);};
-void()	army_walk24	=[	$prowl_24,	army_walk1	] {ai_walk(1);};
-
-void()	army_run1	=[	$run1,		army_run2	] {
-if (random() < 0.2)
-	sound (self, CHAN_VOICE, "soldier/idle.wav", 1, ATTN_IDLE);
-ai_run(11);};
-void()	army_run2	=[	$run2,		army_run3	] {ai_run(15);};
-void()	army_run3	=[	$run3,		army_run4	] {ai_run(10);};
-void()	army_run4	=[	$run4,		army_run5	] {ai_run(10);};
-void()	army_run5	=[	$run5,		army_run6	] {ai_run(8);};
-void()	army_run6	=[	$run6,		army_run7	] {ai_run(15);};
-void()	army_run7	=[	$run7,		army_run8	] {ai_run(10);};
-void()	army_run8	=[	$run8,		army_run1	] {ai_run(8);};
-
-void()	army_atk1	=[	$shoot1,	army_atk2	] {ai_face();};
-void()	army_atk2	=[	$shoot2,	army_atk3	] {ai_face();};
-void()	army_atk3	=[	$shoot3,	army_atk4	] {ai_face();};
-void()	army_atk4	=[	$shoot4,	army_atk5	] {ai_face();};
-void()	army_atk5	=[	$shoot5,	army_atk6	] {ai_face();army_fire();
-self.effects = self.effects | EF_MUZZLEFLASH;};
-void()	army_atk6	=[	$shoot6,	army_atk7	] {ai_face();};
-void()	army_atk7	=[	$shoot7,	army_atk8	] {ai_face();SUB_CheckRefire (army_atk1);};
-void()	army_atk8	=[	$shoot8,	army_atk9	] {ai_face();};
-void()	army_atk9	=[	$shoot9,	army_run1	] {ai_face();};
-
-
-void()	army_pain1	=[	$pain1,		army_pain2	] {};
-void()	army_pain2	=[	$pain2,		army_pain3	] {};
-void()	army_pain3	=[	$pain3,		army_pain4	] {};
-void()	army_pain4	=[	$pain4,		army_pain5	] {};
-void()	army_pain5	=[	$pain5,		army_pain6	] {};
-void()	army_pain6	=[	$pain6,		army_run1	] {ai_pain(1);};
-
-void()	army_painb1	=[	$painb1,	army_painb2	] {};
-void()	army_painb2	=[	$painb2,	army_painb3	] {ai_painforward(13);};
-void()	army_painb3	=[	$painb3,	army_painb4	] {ai_painforward(9);};
-void()	army_painb4	=[	$painb4,	army_painb5	] {};
-void()	army_painb5	=[	$painb5,	army_painb6	] {};
-void()	army_painb6	=[	$painb6,	army_painb7	] {};
-void()	army_painb7	=[	$painb7,	army_painb8	] {};
-void()	army_painb8	=[	$painb8,	army_painb9	] {};
-void()	army_painb9	=[	$painb9,	army_painb10] {};
-void()	army_painb10=[	$painb10,	army_painb11] {};
-void()	army_painb11=[	$painb11,	army_painb12] {};
-void()	army_painb12=[	$painb12,	army_painb13] {ai_pain(2);};
-void()	army_painb13=[	$painb13,	army_painb14] {};
-void()	army_painb14=[	$painb14,	army_run1	] {};
-
-void()	army_painc1	=[	$painc1,	army_painc2	] {};
-void()	army_painc2	=[	$painc2,	army_painc3	] {ai_pain(1);};
-void()	army_painc3	=[	$painc3,	army_painc4	] {};
-void()	army_painc4	=[	$painc4,	army_painc5	] {};
-void()	army_painc5	=[	$painc5,	army_painc6	] {ai_painforward(1);};
-void()	army_painc6	=[	$painc6,	army_painc7	] {ai_painforward(1);};
-void()	army_painc7	=[	$painc7,	army_painc8	] {};
-void()	army_painc8	=[	$painc8,	army_painc9	] {ai_pain(1);};
-void()	army_painc9	=[	$painc9,	army_painc10] {ai_painforward(4);};
-void()	army_painc10=[	$painc10,	army_painc11] {ai_painforward(3);};
-void()	army_painc11=[	$painc11,	army_painc12] {ai_painforward(6);};
-void()	army_painc12=[	$painc12,	army_painc13] {ai_painforward(8);};
-void()	army_painc13=[	$painc13,	army_run1] {};
-
-void(entity attacker, float damage)	army_pain =
-{
-	local float r;
-	
-	if (self.pain_finished > time)
-		return;
-
-	r = random();
-
-	if (r < 0.2)
-	{
-		self.pain_finished = time + 0.6;
-		army_pain1 ();
-		sound (self, CHAN_VOICE, "soldier/pain1.wav", 1, ATTN_NORM);
-	}
-	else if (r < 0.6)
-	{
-		self.pain_finished = time + 1.1;
-		army_painb1 ();
-		sound (self, CHAN_VOICE, "soldier/pain2.wav", 1, ATTN_NORM);
-	}
-	else
-	{
-		self.pain_finished = time + 1.1;
-		army_painc1 ();
-		sound (self, CHAN_VOICE, "soldier/pain2.wav", 1, ATTN_NORM);
-	}
-};
-
-
-void() army_fire =
-{
-	local	vector	dir;
-	local	entity	en;
-	
-	ai_face();
-	
-	sound (self, CHAN_WEAPON, "soldier/sattck1.wav", 1, ATTN_NORM);	
-
-// fire somewhat behind the player, so a dodging player is harder to hit
-	en = self.enemy;
-	
-	dir = en.origin - en.velocity*0.2;
-	dir = normalize (dir - self.origin);
-	
-	FireBullets (4, dir, '0.1 0.1 0');
-};
-
-
-
-void()	army_die1	=[	$death1,	army_die2	] {};
-void()	army_die2	=[	$death2,	army_die3	] {};
-void()	army_die3	=[	$death3,	army_die4	]
-{self.solid = SOLID_NOT;self.ammo_shells = 5;DropBackpack();};
-void()	army_die4	=[	$death4,	army_die5	] {};
-void()	army_die5	=[	$death5,	army_die6	] {};
-void()	army_die6	=[	$death6,	army_die7	] {};
-void()	army_die7	=[	$death7,	army_die8	] {};
-void()	army_die8	=[	$death8,	army_die9	] {};
-void()	army_die9	=[	$death9,	army_die10	] {};
-void()	army_die10	=[	$death10,	army_die10	] {};
-
-void()	army_cdie1	=[	$deathc1,	army_cdie2	] {};
-void()	army_cdie2	=[	$deathc2,	army_cdie3	] {ai_back(5);};
-void()	army_cdie3	=[	$deathc3,	army_cdie4	]
-{self.solid = SOLID_NOT;self.ammo_shells = 5;DropBackpack();ai_back(4);};
-void()	army_cdie4	=[	$deathc4,	army_cdie5	] {ai_back(13);};
-void()	army_cdie5	=[	$deathc5,	army_cdie6	] {ai_back(3);};
-void()	army_cdie6	=[	$deathc6,	army_cdie7	] {ai_back(4);};
-void()	army_cdie7	=[	$deathc7,	army_cdie8	] {};
-void()	army_cdie8	=[	$deathc8,	army_cdie9	] {};
-void()	army_cdie9	=[	$deathc9,	army_cdie10	] {};
-void()	army_cdie10	=[	$deathc10,	army_cdie11	] {};
-void()	army_cdie11	=[	$deathc11,	army_cdie11	] {};
-
-
-void() army_die =
-{
-// check for gib
-	if (self.health < -35)
-	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_guard.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		return;
-	}
-
-// regular death
-	sound (self, CHAN_VOICE, "soldier/death1.wav", 1, ATTN_NORM);
-	if (random() < 0.5)
-		army_die1 ();
-	else
-		army_cdie1 ();
-};
-
-
-/*QUAKED monster_army (1 0 0) (-16 -16 -24) (16 16 40) Ambush
-*/
-void() monster_army =
-{	
-	if (deathmatch)
-	{
-		remove(self);
-		return;
-	}
-	precache_model ("progs/soldier.mdl");
-	precache_model ("progs/h_guard.mdl");
-	precache_model ("progs/gib1.mdl");
-	precache_model ("progs/gib2.mdl");
-	precache_model ("progs/gib3.mdl");
-
-	precache_sound ("soldier/death1.wav");
-	precache_sound ("soldier/idle.wav");
-	precache_sound ("soldier/pain1.wav");
-	precache_sound ("soldier/pain2.wav");
-	precache_sound ("soldier/sattck1.wav");
-	precache_sound ("soldier/sight1.wav");
-
-	precache_sound ("player/udeath.wav");		// gib death
-
-
-	self.solid = SOLID_SLIDEBOX;
-	self.movetype = MOVETYPE_STEP;
-
-	setmodel (self, "progs/soldier.mdl");
-
-	setsize (self, '-16 -16 -24', '16 16 40');
-	self.health = 30;
-
-	self.th_stand = army_stand1;
-	self.th_walk = army_walk1;
-	self.th_run = army_run1;
-	self.th_missile = army_atk1;
-	self.th_pain = army_pain;
-	self.th_die = army_die;
-
-	walkmonster_start ();
-};
+/*
+==============================================================================
+
+SOLDIER / PLAYER
+
+==============================================================================
+*/
+
+$cd /raid/quake/id1/models/soldier3
+$origin 0 -6 24
+$base base		
+$skin skin
+
+$frame stand1 stand2 stand3 stand4 stand5 stand6 stand7 stand8
+
+$frame death1 death2 death3 death4 death5 death6 death7 death8
+$frame death9 death10
+
+$frame deathc1 deathc2 deathc3 deathc4 deathc5 deathc6 deathc7 deathc8
+$frame deathc9 deathc10 deathc11
+
+$frame load1 load2 load3 load4 load5 load6 load7 load8 load9 load10 load11
+
+$frame pain1 pain2 pain3 pain4 pain5 pain6
+
+$frame painb1 painb2 painb3 painb4 painb5 painb6 painb7 painb8 painb9 painb10
+$frame painb11 painb12 painb13 painb14
+
+$frame painc1 painc2 painc3 painc4 painc5 painc6 painc7 painc8 painc9 painc10
+$frame painc11 painc12 painc13
+
+$frame run1 run2 run3 run4 run5 run6 run7 run8
+
+$frame shoot1 shoot2 shoot3 shoot4 shoot5 shoot6 shoot7 shoot8 shoot9
+
+$frame prowl_1 prowl_2 prowl_3 prowl_4 prowl_5 prowl_6 prowl_7 prowl_8
+$frame prowl_9 prowl_10 prowl_11 prowl_12 prowl_13 prowl_14 prowl_15 prowl_16
+$frame prowl_17 prowl_18 prowl_19 prowl_20 prowl_21 prowl_22 prowl_23 prowl_24
+
+/*
+==============================================================================
+SOLDIER CODE
+==============================================================================
+*/
+
+void() army_fire;
+
+void()	army_stand1	=[	$stand1,	army_stand2	] {ai_stand();};
+void()	army_stand2	=[	$stand2,	army_stand3	] {ai_stand();};
+void()	army_stand3	=[	$stand3,	army_stand4	] {ai_stand();};
+void()	army_stand4	=[	$stand4,	army_stand5	] {ai_stand();};
+void()	army_stand5	=[	$stand5,	army_stand6	] {ai_stand();};
+void()	army_stand6	=[	$stand6,	army_stand7	] {ai_stand();};
+void()	army_stand7	=[	$stand7,	army_stand8	] {ai_stand();};
+void()	army_stand8	=[	$stand8,	army_stand1	] {ai_stand();};
+
+void()	army_walk1	=[	$prowl_1,	army_walk2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "soldier/idle.wav", 1, ATTN_IDLE);
+ai_walk(1);};
+void()	army_walk2	=[	$prowl_2,	army_walk3	] {ai_walk(1);};
+void()	army_walk3	=[	$prowl_3,	army_walk4	] {ai_walk(1);};
+void()	army_walk4	=[	$prowl_4,	army_walk5	] {ai_walk(1);};
+void()	army_walk5	=[	$prowl_5,	army_walk6	] {ai_walk(2);};
+void()	army_walk6	=[	$prowl_6,	army_walk7	] {ai_walk(3);};
+void()	army_walk7	=[	$prowl_7,	army_walk8	] {ai_walk(4);};
+void()	army_walk8	=[	$prowl_8,	army_walk9	] {ai_walk(4);};
+void()	army_walk9	=[	$prowl_9,	army_walk10	] {ai_walk(2);};
+void()	army_walk10	=[	$prowl_10,	army_walk11	] {ai_walk(2);};
+void()	army_walk11	=[	$prowl_11,	army_walk12	] {ai_walk(2);};
+void()	army_walk12	=[	$prowl_12,	army_walk13	] {ai_walk(1);};
+void()	army_walk13	=[	$prowl_13,	army_walk14	] {ai_walk(0);};
+void()	army_walk14	=[	$prowl_14,	army_walk15	] {ai_walk(1);};
+void()	army_walk15	=[	$prowl_15,	army_walk16	] {ai_walk(1);};
+void()	army_walk16	=[	$prowl_16,	army_walk17	] {ai_walk(1);};
+void()	army_walk17	=[	$prowl_17,	army_walk18	] {ai_walk(3);};
+void()	army_walk18	=[	$prowl_18,	army_walk19	] {ai_walk(3);};
+void()	army_walk19	=[	$prowl_19,	army_walk20	] {ai_walk(3);};
+void()	army_walk20	=[	$prowl_20,	army_walk21	] {ai_walk(3);};
+void()	army_walk21	=[	$prowl_21,	army_walk22	] {ai_walk(2);};
+void()	army_walk22	=[	$prowl_22,	army_walk23	] {ai_walk(1);};
+void()	army_walk23	=[	$prowl_23,	army_walk24	] {ai_walk(1);};
+void()	army_walk24	=[	$prowl_24,	army_walk1	] {ai_walk(1);};
+
+void()	army_run1	=[	$run1,		army_run2	] {
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "soldier/idle.wav", 1, ATTN_IDLE);
+ai_run(11);};
+void()	army_run2	=[	$run2,		army_run3	] {ai_run(15);};
+void()	army_run3	=[	$run3,		army_run4	] {ai_run(10);};
+void()	army_run4	=[	$run4,		army_run5	] {ai_run(10);};
+void()	army_run5	=[	$run5,		army_run6	] {ai_run(8);};
+void()	army_run6	=[	$run6,		army_run7	] {ai_run(15);};
+void()	army_run7	=[	$run7,		army_run8	] {ai_run(10);};
+void()	army_run8	=[	$run8,		army_run1	] {ai_run(8);};
+
+void()	army_atk1	=[	$shoot1,	army_atk2	] {ai_face();};
+void()	army_atk2	=[	$shoot2,	army_atk3	] {ai_face();};
+void()	army_atk3	=[	$shoot3,	army_atk4	] {ai_face();};
+void()	army_atk4	=[	$shoot4,	army_atk5	] {ai_face();};
+void()	army_atk5	=[	$shoot5,	army_atk6	] {ai_face();army_fire();
+self.effects = self.effects | EF_MUZZLEFLASH;};
+void()	army_atk6	=[	$shoot6,	army_atk7	] {ai_face();};
+void()	army_atk7	=[	$shoot7,	army_atk8	] {ai_face();SUB_CheckRefire (army_atk1);};
+void()	army_atk8	=[	$shoot8,	army_atk9	] {ai_face();};
+void()	army_atk9	=[	$shoot9,	army_run1	] {ai_face();};
+
+
+void()	army_pain1	=[	$pain1,		army_pain2	] {};
+void()	army_pain2	=[	$pain2,		army_pain3	] {};
+void()	army_pain3	=[	$pain3,		army_pain4	] {};
+void()	army_pain4	=[	$pain4,		army_pain5	] {};
+void()	army_pain5	=[	$pain5,		army_pain6	] {};
+void()	army_pain6	=[	$pain6,		army_run1	] {ai_pain(1);};
+
+void()	army_painb1	=[	$painb1,	army_painb2	] {};
+void()	army_painb2	=[	$painb2,	army_painb3	] {ai_painforward(13);};
+void()	army_painb3	=[	$painb3,	army_painb4	] {ai_painforward(9);};
+void()	army_painb4	=[	$painb4,	army_painb5	] {};
+void()	army_painb5	=[	$painb5,	army_painb6	] {};
+void()	army_painb6	=[	$painb6,	army_painb7	] {};
+void()	army_painb7	=[	$painb7,	army_painb8	] {};
+void()	army_painb8	=[	$painb8,	army_painb9	] {};
+void()	army_painb9	=[	$painb9,	army_painb10] {};
+void()	army_painb10=[	$painb10,	army_painb11] {};
+void()	army_painb11=[	$painb11,	army_painb12] {};
+void()	army_painb12=[	$painb12,	army_painb13] {ai_pain(2);};
+void()	army_painb13=[	$painb13,	army_painb14] {};
+void()	army_painb14=[	$painb14,	army_run1	] {};
+
+void()	army_painc1	=[	$painc1,	army_painc2	] {};
+void()	army_painc2	=[	$painc2,	army_painc3	] {ai_pain(1);};
+void()	army_painc3	=[	$painc3,	army_painc4	] {};
+void()	army_painc4	=[	$painc4,	army_painc5	] {};
+void()	army_painc5	=[	$painc5,	army_painc6	] {ai_painforward(1);};
+void()	army_painc6	=[	$painc6,	army_painc7	] {ai_painforward(1);};
+void()	army_painc7	=[	$painc7,	army_painc8	] {};
+void()	army_painc8	=[	$painc8,	army_painc9	] {ai_pain(1);};
+void()	army_painc9	=[	$painc9,	army_painc10] {ai_painforward(4);};
+void()	army_painc10=[	$painc10,	army_painc11] {ai_painforward(3);};
+void()	army_painc11=[	$painc11,	army_painc12] {ai_painforward(6);};
+void()	army_painc12=[	$painc12,	army_painc13] {ai_painforward(8);};
+void()	army_painc13=[	$painc13,	army_run1] {};
+
+void(entity attacker, float damage)	army_pain =
+{
+	local float r;
+	
+	if (self.pain_finished > time)
+		return;
+
+	r = random();
+
+	if (r < 0.2)
+	{
+		self.pain_finished = time + 0.6;
+		army_pain1 ();
+		sound (self, CHAN_VOICE, "soldier/pain1.wav", 1, ATTN_NORM);
+	}
+	else if (r < 0.6)
+	{
+		self.pain_finished = time + 1.1;
+		army_painb1 ();
+		sound (self, CHAN_VOICE, "soldier/pain2.wav", 1, ATTN_NORM);
+	}
+	else
+	{
+		self.pain_finished = time + 1.1;
+		army_painc1 ();
+		sound (self, CHAN_VOICE, "soldier/pain2.wav", 1, ATTN_NORM);
+	}
+};
+
+
+void() army_fire =
+{
+	local	vector	dir;
+	local	entity	en;
+	
+	ai_face();
+	
+	sound (self, CHAN_WEAPON, "soldier/sattck1.wav", 1, ATTN_NORM);	
+
+// fire somewhat behind the player, so a dodging player is harder to hit
+	en = self.enemy;
+	
+	dir = en.origin - en.velocity*0.2;
+	dir = normalize (dir - self.origin);
+	
+	FireBullets (4, dir, '0.1 0.1 0');
+};
+
+
+
+void()	army_die1	=[	$death1,	army_die2	] {};
+void()	army_die2	=[	$death2,	army_die3	] {};
+void()	army_die3	=[	$death3,	army_die4	]
+{self.ammo_shells = 5;DropBackpack();};
+void()	army_die4	=[	$death4,	army_die5	] {};
+void()	army_die5	=[	$death5,	army_die6	] {};
+void()	army_die6	=[	$death6,	army_die7	] {};
+void()	army_die7	=[	$death7,	army_die8	] {};
+void()	army_die8	=[	$death8,	army_die9	] {};
+void()	army_die9	=[	$death9,	army_die10	] {};
+void()	army_die10	=[	$death10,	army_die10	] {};
+
+void()	army_cdie1	=[	$deathc1,	army_cdie2	] {};
+void()	army_cdie2	=[	$deathc2,	army_cdie3	] {ai_back(5);};
+void()	army_cdie3	=[	$deathc3,	army_cdie4	]
+{self.ammo_shells = 5;DropBackpack();ai_back(4);};
+void()	army_cdie4	=[	$deathc4,	army_cdie5	] {ai_back(13);};
+void()	army_cdie5	=[	$deathc5,	army_cdie6	] {ai_back(3);};
+void()	army_cdie6	=[	$deathc6,	army_cdie7	] {ai_back(4);};
+void()	army_cdie7	=[	$deathc7,	army_cdie8	] {};
+void()	army_cdie8	=[	$deathc8,	army_cdie9	] {};
+void()	army_cdie9	=[	$deathc9,	army_cdie10	] {};
+void()	army_cdie10	=[	$deathc10,	army_cdie11	] {};
+void()	army_cdie11	=[	$deathc11,	army_cdie11	] {};
+
+void() army_die =
+{
+// check for gib
+	if (self.health < -35)
+	{
+                sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+		monster_gib("progs/h_guard.mdl");
+		return;
+	}
+
+// regular death
+	sound (self, CHAN_VOICE, "soldier/death1.wav", 1, ATTN_NORM);
+	if (random() < 0.5)
+		army_die1 ();
+	else
+		army_cdie1 ();
+	
+// We want a corpse:  No actions, a little health, and a new .th_die
+// Frob some flags so we're damagable as well
+
+	monster_corpse_setup('-16 -16 -24', '16 16 -10', "progs/h_guard.mdl");
+};
+
+
+/*QUAKED monster_army (1 0 0) (-16 -16 -24) (16 16 40) Ambush
+*/
+void() monster_army =
+{	
+	if (deathmatch)
+	{
+		remove(self);
+		return;
+	}
+	precache_model ("progs/soldier.mdl");
+	precache_model ("progs/h_guard.mdl");
+	precache_model ("progs/gib1.mdl");
+	precache_model ("progs/gib2.mdl");
+	precache_model ("progs/gib3.mdl");
+
+	precache_sound ("soldier/death1.wav");
+	precache_sound ("soldier/idle.wav");
+	precache_sound ("soldier/pain1.wav");
+	precache_sound ("soldier/pain2.wav");
+	precache_sound ("soldier/sattck1.wav");
+	precache_sound ("soldier/sight1.wav");
+
+	precache_sound ("player/udeath.wav");		// gib death
+
+
+	self.solid = SOLID_SLIDEBOX;
+	self.movetype = MOVETYPE_STEP;
+
+	setmodel (self, "progs/soldier.mdl");
+
+	setsize (self, '-16 -16 -24', '16 16 40');
+	self.health = 30;
+
+	self.th_stand = army_stand1;
+	self.th_walk = army_walk1;
+	self.th_run = army_run1;
+	self.th_missile = army_atk1;
+	self.th_pain = army_pain;
+	self.th_die = army_die;
+
+	walkmonster_start ();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/weapons.qc solidmn/weapons.qc
--- v101qc/weapons.qc	Thu Jul 25 01:51:24 1996
+++ solidmn/weapons.qc	Tue Jul 30 22:34:24 1996
@@ -22,6 +22,7 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+	precache_sound ("zombie/z_hit.wav");    // Axe
 };
 
 float() crandom =
@@ -48,6 +49,8 @@
 
 	if (trace_ent.takedamage)
 	{
+		sound (self, CHAN_WEAPON, "zombie/z_hit.wav", 1, ATTN_NORM);
+		// Some sort of thunking sound ...
 		trace_ent.axhitme = 1;
 		SpawnBlood (org, '0 0 0', 20);
 		T_Damage (trace_ent, self, self, 20);
@@ -406,6 +409,45 @@
 /*
 ===============================================================================
 
+Pain missile
+
+===============================================================================
+*/
+void() W_FireFireball =
+{
+	local	entity missile, mpuff;
+	
+	T_Damage(self, self, self, 10);
+
+	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+
+	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	missile.solid = SOLID_BBOX;
+		
+// set missile speed	
+
+	makevectors (self.v_angle);
+	missile.velocity = aim(self, 1000);
+	missile.velocity = missile.velocity * 1000;
+	missile.angles = vectoangles(missile.velocity);
+	
+	missile.touch = T_MissileTouch;
+	
+// set missile duration
+	missile.nextthink = time + 5;
+	missile.think = SUB_Remove;
+
+	setmodel (missile, "progs/lavaball.mdl");
+	setsize (missile, '0 0 0', '0 0 0');		
+	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
+};
+/*
+===============================================================================
+
 LIGHTNING
 
 ===============================================================================
@@ -855,6 +897,9 @@
 
 	if (self.weapon == IT_AXE)
 		return TRUE;
+
+	if (self.weapon == IT_EXTRA_WEAPON)
+		return TRUE;
 	
 	self.weapon = W_BestWeapon ();
 
@@ -942,6 +987,12 @@
 		self.attack_finished = time + 0.1;
 		sound (self, CHAN_AUTO, "weapons/lstart.wav", 1, ATTN_NORM);
 	}
+	else if (self.weapon == IT_EXTRA_WEAPON)
+	{
+		player_rocket1();
+		W_FireFireball();
+		self.attack_finished = time + 0.8;
+	}
 };
 
 /*
@@ -1003,6 +1054,10 @@
 		if (self.ammo_cells < 1)
 			am = 1;
 	}
+	else if (self.impulse == 32)
+	{
+		fl = IT_EXTRA_WEAPON;
+	}
 
 	self.impulse = 0;
 	
@@ -1038,6 +1093,7 @@
 	self.ammo_rockets = 100;
 	self.ammo_nails = 200;
 	self.ammo_shells = 100;
+	self.ammo_cells = 200;
 	self.items = self.items | 
 		IT_AXE |
 		IT_SHOTGUN |
@@ -1046,12 +1102,10 @@
 		IT_SUPER_NAILGUN |
 		IT_GRENADE_LAUNCHER |
 		IT_ROCKET_LAUNCHER |
+		IT_EXTRA_WEAPON |
+		IT_LIGHTNING |
 		IT_KEY1 | IT_KEY2;
 
-	self.ammo_cells = 200;
-	self.items = self.items | IT_LIGHTNING;
-
-	self.weapon = IT_ROCKET_LAUNCHER;
 	self.impulse = 0;
 	W_SetCurrentAmmo ();
 };
@@ -1076,6 +1130,10 @@
 
 		if (self.weapon == IT_LIGHTNING)
 		{
+			self.weapon = IT_EXTRA_WEAPON;
+		}
+		else if (self.weapon == IT_EXTRA_WEAPON)
+		{
 			self.weapon = IT_AXE;
 		}
 		else if (self.weapon == IT_AXE)
@@ -1162,15 +1220,16 @@
 {
 	if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
-
-	if (self.impulse == 9)
+	// 32..128 for added weapons
+ 	else if (self.impulse >=32 && self.impulse <=128)
+		W_ChangeWeapon ();
+	else if (self.impulse == 9)
 		CheatCommand ();
-	if (self.impulse == 10)
+	else if (self.impulse == 10)
 		CycleWeaponCommand ();
-	if (self.impulse == 11)
+	else if (self.impulse == 11)
 		ServerflagsCommand ();
-
-	if (self.impulse == 255)
+	else if (self.impulse == 255)
 		QuadCheat ();
 		
 	self.impulse = 0;
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej v101qc/wizard.qc solidmn/wizard.qc
--- v101qc/wizard.qc	Thu Jul 25 01:51:24 1996
+++ solidmn/wizard.qc	Wed Jul 31 22:24:02 1996
@@ -331,7 +331,7 @@
 sound (self, CHAN_VOICE, "wizard/wdeath.wav", 1, ATTN_NORM);
 };
 void()	wiz_death2	=[	$death2,		wiz_death3	] {};
-void()	wiz_death3	=[	$death3,		wiz_death4	]{self.solid = SOLID_NOT;};
+void()	wiz_death3	=[	$death3,		wiz_death4	]{};
 void()	wiz_death4	=[	$death4,		wiz_death5	] {};
 void()	wiz_death5	=[	$death5,		wiz_death6	] {};
 void()	wiz_death6	=[	$death6,		wiz_death7	] {};
@@ -343,15 +343,14 @@
 // check for gib
 	if (self.health < -40)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_wizard.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
+		monster_gib("progs/h_wizard.mdl");
+		sound(self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
 		return;
 	}
 
 	wiz_death1 ();
+        self.health=135;
+	monster_corpse_setup('-16 -16 -24', '16 16 -10', "progs/h_wizard.mdl");
 };
 
 
