diff -ur --new-file ..\quake-c\src106/client.qc .\src/client.qc
--- ..\quake-c\src106/client.qc	Sun Sep 29 23:29:00 1996
+++ .\src/client.qc	Fri Nov 29 21:06:56 1996
@@ -50,8 +50,8 @@
 	parm1 = self.items;
 	parm2 = self.health;
 	parm3 = self.armorvalue;
-	if (self.ammo_shells < 25)
-		parm4 = 25;
+   if (self.ammo_shells < 15)
+      parm4 = 15;
 	else
 		parm4 = self.ammo_shells;
 	parm5 = self.ammo_nails;
@@ -61,17 +61,20 @@
 	parm9 = self.armortype * 100;
 };
 
+
 void() SetNewParms =
 {
-	parm1 = IT_SHOTGUN | IT_AXE;
-	parm2 = 100;
-	parm3 = 0;
-	parm4 = 25;
-	parm5 = 0;
-	parm6 = 0;
+
+   parm1 = IT_ARMOR3 | IT_SHOTGUN | IT_GRENADE_LAUNCHER | IT_AXE;
+   parm2 = 100;
+   parm3 = 200;
+   parm4 = 15;
+   parm5 = 0;
+   parm6 = 15;
 	parm7 = 0;
-	parm8 = 1;
-	parm9 = 0;
+   parm8 = IT_GRENADE_LAUNCHER;
+   parm9 = 80;
+
 };
 
 void() DecodeLevelParms =
diff -ur --new-file ..\quake-c\src106/demon.qc .\src/demon.qc
--- ..\quake-c\src106/demon.qc	Thu Sep 26 11:15:38 1996
+++ .\src/demon.qc	Fri Nov 29 20:17:24 1996
@@ -68,13 +68,83 @@
 void()	demon1_run3	=[	$run3,		demon1_run4	] {ai_run(36);};
 void()	demon1_run4	=[	$run4,		demon1_run5	] {ai_run(20);};
 void()	demon1_run5	=[	$run5,		demon1_run6	] {ai_run(15);};
-void()	demon1_run6	=[	$run6,		demon1_run1	] {ai_run(36);};
+
+void()   demon1_jump1;
+void()   demon1_run6 =[ $run6,      demon1_run1 ]
+{
+   ai_run(36);
+   if (self.waterlevel == 1)
+   {
+      if ( random() > 0.8 )
+         self.think = demon1_jump1;
+   }
+
+};
 
 void()	demon1_jump1	=[	$leap1,		demon1_jump2	] {ai_face();};
 void()	demon1_jump2	=[	$leap2,		demon1_jump3	] {ai_face();};
 void()	demon1_jump3	=[	$leap3,		demon1_jump4	] {ai_face();};
 void()	demon1_jump4	=[	$leap4,		demon1_jump5	]
 {
+   local vector dir;
+   local float dist;
+
+   ai_face();
+	
+	self.touch = Demon_JumpTouch;
+	makevectors (self.angles);
+	self.origin_z = self.origin_z + 1;
+   if (self.enemy.origin_z > self.origin_z + 40)
+   {
+
+      if ( infront(self.enemy) )
+      {
+         dir = normalize(self.enemy.origin - self.origin);
+         dist = vlen(self.enemy.origin - self.origin);
+         self.velocity = dir * dist;
+      }
+      else
+         self.velocity = v_forward * 150 * (random() + 1);
+
+      dist = self.enemy.origin_z - self.origin_z;
+
+      // a vertical velocity to jump just above player's head
+      // for any given distance between z origins.
+      dist = dist - 237;
+      self.velocity_z = 714 + dist;
+
+   }
+   else
+   {
+      // slow forward to fall off ledge if player down
+      // else normal horizontal velocity
+      if (self.enemy.origin_z < self.origin_z - 40)
+         self.velocity = v_forward * 150 * (random() + 1);
+      else
+         self.velocity = v_forward * 600;
+
+      // check for wall in front
+      traceline( self.origin - '0 0 16',
+                 (self.origin - '0 0 16') + v_forward*150, TRUE, self);
+
+      // attempt to jump wall or normal vel.
+      if (trace_fraction < 1)
+      {
+         self.velocity = v_forward * 90;
+         self.velocity_z = 250 * (random() + 1);
+      }
+      else
+         self.velocity_z = 250;
+   }
+
+
+   if (self.flags & FL_ONGROUND)
+		self.flags = self.flags - FL_ONGROUND;
+
+};
+
+/*
+{
 	ai_face();
 	
 	self.touch = Demon_JumpTouch;
@@ -84,6 +154,7 @@
 	if (self.flags & FL_ONGROUND)
 		self.flags = self.flags - FL_ONGROUND;
 };
+*/
 void()	demon1_jump5	=[	$leap5,		demon1_jump6	] {};
 void()	demon1_jump6	=[	$leap6,		demon1_jump7	] {};
 void()	demon1_jump7	=[	$leap7,		demon1_jump8	] {};
@@ -199,7 +270,8 @@
 
 	setmodel (self, "progs/demon.mdl");
 
-	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+   setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+   // setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
 	self.health = 300;
 
 	self.th_stand = demon1_stand1;
@@ -250,7 +322,10 @@
 	local	vector	dist;
 	local	float	d;
 
-	if (self.origin_z + self.mins_z > self.enemy.origin_z + self.enemy.mins_z
+   if (random() < 0.4)
+      return TRUE;
+
+   if (self.origin_z + self.mins_z > self.enemy.origin_z + self.enemy.mins_z
 	+ 0.75 * self.enemy.size_z)
 		return FALSE;
 		
diff -ur --new-file ..\quake-c\src106/enforcer.qc .\src/enforcer.qc
--- ..\quake-c\src106/enforcer.qc	Thu Sep 26 11:15:38 1996
+++ .\src/enforcer.qc	Fri Nov 29 20:17:26 1996
@@ -37,6 +37,7 @@
 $frame paind9 paind10 paind11 paind12 paind13 paind14 paind15 paind16
 $frame paind17 paind18 paind19
 
+void() OgreFireGrenade;
 
 void() Laser_Touch =
 {
@@ -160,11 +161,18 @@
 void()	enf_atk3	=[	$attack3,	enf_atk4	] {ai_face();};
 void()	enf_atk4	=[	$attack4,	enf_atk5	] {ai_face();};
 void()	enf_atk5	=[	$attack5,	enf_atk6	] {ai_face();};
-void()	enf_atk6	=[	$attack6,	enf_atk7	] {enforcer_fire();};
+
+// ### grenade mod ###
+// void()   enf_atk6 =[ $attack6,   enf_atk7 ] {enforcer_fire();};
+void()   enf_atk6 =[ $attack6,   enf_atk7 ] {ai_face();OgreFireGrenade();};
+
 void()	enf_atk7	=[	$attack7,	enf_atk8	] {ai_face();};
 void()	enf_atk8	=[	$attack8,	enf_atk9	] {ai_face();};
 void()	enf_atk9	=[	$attack5,	enf_atk10	] {ai_face();};
-void()	enf_atk10	=[	$attack6,	enf_atk11	] {enforcer_fire();};
+
+// void()   enf_atk10   =[ $attack6,   enf_atk11   ] {enforcer_fire();};
+void()   enf_atk10   =[ $attack6,   enf_atk11   ] {ai_face();};
+
 void()	enf_atk11	=[	$attack7,	enf_atk12	] {ai_face();};
 void()	enf_atk12	=[	$attack8,	enf_atk13	] {ai_face();};
 void()	enf_atk13	=[	$attack9,	enf_atk14	] {ai_face();};
diff -ur --new-file ..\quake-c\src106/items.qc .\src/items.qc
--- ..\quake-c\src106/items.qc	Thu Sep 26 11:15:38 1996
+++ .\src/items.qc	Fri Nov 29 20:17:26 1996
@@ -398,7 +398,9 @@
 	if (!(other.flags & FL_CLIENT))
 		return;
 
-// if the player was using his best weapon, change up to the new one if better		
+   self.classname = "weapon_grenadelauncher";
+
+// if the player was using his best weapon, change up to the new one if better
 	stemp = self;
 	self = other;
 	best = W_BestWeapon();
@@ -409,39 +411,7 @@
 	else
 		leave = 0;
 	
-	if (self.classname == "weapon_nailgun")
-	{
-		if (leave && (other.items & IT_NAILGUN) )
-			return;
-		hadammo = other.ammo_nails;			
-		new = IT_NAILGUN;
-		other.ammo_nails = other.ammo_nails + 30;
-	}
-	else if (self.classname == "weapon_supernailgun")
-	{
-		if (leave && (other.items & IT_SUPER_NAILGUN) )
-			return;
-		hadammo = other.ammo_rockets;			
-		new = IT_SUPER_NAILGUN;
-		other.ammo_nails = other.ammo_nails + 30;
-	}
-	else if (self.classname == "weapon_supershotgun")
-	{
-		if (leave && (other.items & IT_SUPER_SHOTGUN) )
-			return;
-		hadammo = other.ammo_rockets;			
-		new = IT_SUPER_SHOTGUN;
-		other.ammo_shells = other.ammo_shells + 5;
-	}
-	else if (self.classname == "weapon_rocketlauncher")
-	{
-		if (leave && (other.items & IT_ROCKET_LAUNCHER) )
-			return;
-		hadammo = other.ammo_rockets;			
-		new = IT_ROCKET_LAUNCHER;
-		other.ammo_rockets = other.ammo_rockets + 5;
-	}
-	else if (self.classname == "weapon_grenadelauncher")
+   if (self.classname == "weapon_grenadelauncher")
 	{
 		if (leave && (other.items & IT_GRENADE_LAUNCHER) )
 			return;
@@ -449,14 +419,6 @@
 		new = IT_GRENADE_LAUNCHER;
 		other.ammo_rockets = other.ammo_rockets + 5;
 	}
-	else if (self.classname == "weapon_lightning")
-	{
-		if (leave && (other.items & IT_LIGHTNING) )
-			return;
-		hadammo = other.ammo_rockets;			
-		new = IT_LIGHTNING;
-		other.ammo_cells = other.ammo_cells + 15;
-	}
 	else
 		objerror ("weapon_touch: unknown classname");
 
@@ -505,10 +467,10 @@
 
 void() weapon_supershotgun =
 {
-	precache_model ("progs/g_shot.mdl");
-	setmodel (self, "progs/g_shot.mdl");
-	self.weapon = IT_SUPER_SHOTGUN;
-	self.netname = "Double-barrelled Shotgun";
+	precache_model ("progs/g_rock.mdl");
+	setmodel (self, "progs/g_rock.mdl");
+	self.weapon = 3;
+	self.netname = "Grenade Launcher";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
 	StartItem ();
@@ -519,10 +481,10 @@
 
 void() weapon_nailgun =
 {
-	precache_model ("progs/g_nail.mdl");
-	setmodel (self, "progs/g_nail.mdl");
-	self.weapon = IT_NAILGUN;
-	self.netname = "nailgun";
+	precache_model ("progs/g_rock.mdl");
+	setmodel (self, "progs/g_rock.mdl");
+	self.weapon = 3;
+	self.netname = "Grenade Launcher";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
 	StartItem ();
@@ -533,10 +495,10 @@
 
 void() weapon_supernailgun =
 {
-	precache_model ("progs/g_nail2.mdl");
-	setmodel (self, "progs/g_nail2.mdl");
-	self.weapon = IT_SUPER_NAILGUN;
-	self.netname = "Super Nailgun";
+	precache_model ("progs/g_rock.mdl");
+	setmodel (self, "progs/g_rock.mdl");
+	self.weapon = 3;
+	self.netname = "Grenade Launcher";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
 	StartItem ();
@@ -561,10 +523,10 @@
 
 void() weapon_rocketlauncher =
 {
-	precache_model ("progs/g_rock2.mdl");
-	setmodel (self, "progs/g_rock2.mdl");
+	precache_model ("progs/g_rock.mdl");
+	setmodel (self, "progs/g_rock.mdl");
 	self.weapon = 3;
-	self.netname = "Rocket Launcher";
+	self.netname = "Grenade Launcher";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
 	StartItem ();
@@ -576,10 +538,10 @@
 
 void() weapon_lightning =
 {
-	precache_model ("progs/g_light.mdl");
-	setmodel (self, "progs/g_light.mdl");
+	precache_model ("progs/g_rock.mdl");
+	setmodel (self, "progs/g_rock.mdl");
 	self.weapon = 3;
-	self.netname = "Thunderbolt";
+	self.netname = "Grenade Launcher";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
 	StartItem ();
@@ -694,18 +656,18 @@
 
 	if (self.spawnflags & WEAPON_BIG2)
 	{
-		precache_model ("maps/b_shell1.bsp");
-		setmodel (self, "maps/b_shell1.bsp");
-		self.aflag = 40;
+		precache_model ("maps/b_rock1.bsp");
+		setmodel (self, "maps/b_rock1.bsp");
+      self.aflag = 10;
 	}
 	else
 	{
-		precache_model ("maps/b_shell0.bsp");
-		setmodel (self, "maps/b_shell0.bsp");
-		self.aflag = 20;
+		precache_model ("maps/b_rock0.bsp");
+		setmodel (self, "maps/b_rock0.bsp");
+      self.aflag = 5;
 	}
-	self.weapon = 1;
-	self.netname = "shells";
+	self.weapon = 3;
+	self.netname = "rockets";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
 };
@@ -719,18 +681,18 @@
 
 	if (self.spawnflags & WEAPON_BIG2)
 	{
-		precache_model ("maps/b_nail1.bsp");
-		setmodel (self, "maps/b_nail1.bsp");
-		self.aflag = 50;
+		precache_model ("maps/b_rock1.bsp");
+		setmodel (self, "maps/b_rock1.bsp");
+      self.aflag = 10;
 	}
 	else
 	{
-		precache_model ("maps/b_nail0.bsp");
-		setmodel (self, "maps/b_nail0.bsp");
-		self.aflag = 25;
+		precache_model ("maps/b_rock0.bsp");
+		setmodel (self, "maps/b_rock0.bsp");
+      self.aflag = 5;
 	}
-	self.weapon = 2;
-	self.netname = "nails";
+	self.weapon = 3;
+	self.netname = "rockets";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
 };
@@ -746,13 +708,13 @@
 	{
 		precache_model ("maps/b_rock1.bsp");
 		setmodel (self, "maps/b_rock1.bsp");
-		self.aflag = 10;
+      self.aflag = 10;
 	}
 	else
 	{
 		precache_model ("maps/b_rock0.bsp");
 		setmodel (self, "maps/b_rock0.bsp");
-		self.aflag = 5;
+      self.aflag = 5;
 	}
 	self.weapon = 3;
 	self.netname = "rockets";
@@ -770,18 +732,18 @@
 
 	if (self.spawnflags & WEAPON_BIG2)
 	{
-		precache_model ("maps/b_batt1.bsp");
-		setmodel (self, "maps/b_batt1.bsp");
-		self.aflag = 12;
+		precache_model ("maps/b_rock1.bsp");
+		setmodel (self, "maps/b_rock1.bsp");
+      self.aflag = 10;
 	}
 	else
 	{
-		precache_model ("maps/b_batt0.bsp");
-		setmodel (self, "maps/b_batt0.bsp");
-		self.aflag = 6;
+		precache_model ("maps/b_rock0.bsp");
+		setmodel (self, "maps/b_rock0.bsp");
+      self.aflag = 5;
 	}
-	self.weapon = 4;
-	self.netname = "cells";
+	self.weapon = 3;
+	self.netname = "rockets";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
 };
@@ -803,36 +765,36 @@
 	{
 		if (self.spawnflags & WEAPON_BIG)
 		{
-			precache_model ("maps/b_shell1.bsp");
-			setmodel (self, "maps/b_shell1.bsp");
-			self.aflag = 40;
+			precache_model ("maps/b_rock1.bsp");
+			setmodel (self, "maps/b_rock1.bsp");
+			self.aflag = 10;
 		}
 		else
 		{
-			precache_model ("maps/b_shell0.bsp");
-			setmodel (self, "maps/b_shell0.bsp");
-			self.aflag = 20;
+			precache_model ("maps/b_rock0.bsp");
+			setmodel (self, "maps/b_rock0.bsp");
+			self.aflag = 5;
 		}
-		self.weapon = 1;
-		self.netname = "shells";
+		self.weapon = 3;
+		self.netname = "rockets";
 	}
 
 	if (self.spawnflags & WEAPON_SPIKES)
 	{
 		if (self.spawnflags & WEAPON_BIG)
 		{
-			precache_model ("maps/b_nail1.bsp");
-			setmodel (self, "maps/b_nail1.bsp");
-			self.aflag = 40;
+			precache_model ("maps/b_rock1.bsp");
+			setmodel (self, "maps/b_rock1.bsp");
+			self.aflag = 10;
 		}
 		else
 		{
-			precache_model ("maps/b_nail0.bsp");
-			setmodel (self, "maps/b_nail0.bsp");
-			self.aflag = 20;
+			precache_model ("maps/b_rock0.bsp");
+			setmodel (self, "maps/b_rock0.bsp");
+			self.aflag = 5;
 		}
-		self.weapon = 2;
-		self.netname = "spikes";
+		self.weapon = 3;
+		self.netname = "rockets";
 	}
 
 	if (self.spawnflags & WEAPON_ROCKET)
@@ -1359,10 +1321,11 @@
 	else
 		item.netname = "";
 
-	item.ammo_shells = self.ammo_shells;
-	item.ammo_nails = self.ammo_nails;
-	item.ammo_rockets = self.ammo_rockets;
-	item.ammo_cells = self.ammo_cells;
+   item.ammo_shells = 0; // self.ammo_shells;
+   item.ammo_nails = 0; // self.ammo_nails;
+   item.ammo_cells = 0; // self.ammo_cells;
+
+   item.ammo_rockets = 2;
 
 	item.velocity_z = 300;
 	item.velocity_x = -100 + (random() * 200);
diff -ur --new-file ..\quake-c\src106/ogre.qc .\src/ogre.qc
--- ..\quake-c\src106/ogre.qc	Thu Sep 26 11:15:40 1996
+++ .\src/ogre.qc	Fri Nov 29 20:17:26 1996
@@ -203,6 +203,7 @@
 void() ogre_walk15	=[	$walk15,	ogre_walk16	] {ai_walk(3);};
 void() ogre_walk16	=[	$walk16,	ogre_walk1	] {ai_walk(4);};
 
+/*
 void() ogre_run1	=[	$run1,		ogre_run2	] {ai_run(9);
 if (random() < 0.2)
 	sound (self, CHAN_VOICE, "ogre/ogidle2.wav", 1, ATTN_IDLE);
@@ -214,6 +215,185 @@
 void() ogre_run6	=[	$run6,		ogre_run7	] {ai_run(4);};
 void() ogre_run7	=[	$run7,		ogre_run8	] {ai_run(13);};
 void() ogre_run8	=[	$run8,		ogre_run1	] {ai_run(24);};
+*/
+
+void()   ogre_jump1;
+
+void() ogre_run1  =[ $run1,      ogre_run2   ] {ai_run(10 * 2.6);
+if (random() < 0.2)
+	sound (self, CHAN_VOICE, "ogre/ogidle2.wav", 1, ATTN_IDLE);
+};
+void() ogre_run2  =[ $run2,      ogre_run3   ] {ai_run(12 * 2.6);};
+void() ogre_run3  =[ $run3,      ogre_run4   ] {ai_run(9 * 2.6);};
+void() ogre_run4  =[ $run4,      ogre_run5   ] {ai_run(18 * 2.6);};
+void() ogre_run5  =[ $run5,      ogre_run6   ] {ai_run(14 * 2.6);};
+void() ogre_run6  =[ $run6,      ogre_run7   ]
+{
+   ai_run(11 * 2.6);
+   if (self.waterlevel == 1)
+   {
+      if ( random() > 0.8 )
+      {
+         self.think = ogre_jump1;
+         self.nextthink = time + 0.2;
+      }
+   }
+
+};
+void() ogre_run7  =[ $run7,      ogre_run8   ] {ai_run(13 * 2.6);};
+void() ogre_run8  =[ $run8,      ogre_run1   ] {ai_run(19 * 2.6);};
+
+
+
+
+
+
+void()   Ogre_JumpTouch;
+
+
+void()   ogre_jump1   =[ $run1,     ogre_jump2   ] {ai_face();};
+void()   ogre_jump2   =[ $run2,     ogre_jump3   ] {ai_face();};
+void()   ogre_jump3   =[ $run3,     ogre_jump4   ] {ai_face();};
+void()   ogre_jump4   =[ $run4,     ogre_jump5   ]
+{
+   local vector dir;
+   local float dist;
+   // local string s1;
+
+   ai_face();
+	
+   self.touch = Ogre_JumpTouch;
+	makevectors (self.angles);
+	self.origin_z = self.origin_z + 1;
+   if (self.enemy.origin_z > self.origin_z + 40)
+   {
+
+      if ( infront(self.enemy) || self.waterlevel == 1 )
+      {
+         dir = normalize(self.enemy.origin - self.origin);
+         dist = vlen(self.enemy.origin - self.origin);
+         self.velocity = dir * dist;
+      }
+      else
+         self.velocity = v_forward * 150;
+
+      dist = self.enemy.origin_z - self.origin_z;
+
+      // complete f***in hack, but a good 'un
+      // gives ogre a vertical velocity to always jump to just
+      // above player's head for any given distance between
+      // z origins.  (Found it the hard way, E2M2 end area w/god/noclip
+      // just moveing up and down checking the effects of different
+      // formulas - write it down, works as good as the real formula
+      // whatever that might be :)
+      dist = dist - 237;
+      self.velocity_z = 714 + dist;
+
+      
+      /*
+      if (self.enemy.classname == "player")
+      {
+          sprint( self.enemy, "waterlevel: " );
+          s1 = ftos( self.waterlevel );
+          sprint( self.enemy, s1 );
+         //sprint( self.enemy, "z vel: " );
+         //s1 = ftos( self.velocity_z );
+         //sprint( self.enemy, s1 );
+          sprint( self.enemy, "\n" );
+
+      }
+      */
+
+
+   }
+   else
+   {
+      // slow forward to fall off ledge if player down
+      // else normal fiend horizontal velocity
+      if (self.enemy.origin_z < self.origin_z - 40)
+         self.velocity = v_forward * 150;
+      else
+         self.velocity = v_forward * 600;
+
+      // check for wall in front
+      traceline( self.origin - '0 0 16',
+                 (self.origin - '0 0 16') + v_forward*150, TRUE, self);
+
+      // attempt to jump wall or normal fiend vel.
+      if (trace_fraction < 1)
+      {
+         self.velocity = v_forward * 110;
+         self.velocity_z = 250 * (random() + 1); // 550;
+      }
+      else
+         self.velocity_z = 250;
+   }
+
+
+   if (self.flags & FL_ONGROUND)
+		self.flags = self.flags - FL_ONGROUND;
+
+};
+void()   ogre_jump5   =[ $run5,     ogre_jump6   ] {};
+void()   ogre_jump6   =[ $run6,     ogre_jump7   ] {};
+void()   ogre_jump7   =[ $run7,     ogre_jump8   ] {};
+void()   ogre_jump8   =[    $run8,     ogre_jump9   ] {};
+void()   ogre_jump9   =[    $run1,     ogre_jump10  ] {};
+void()   ogre_jump10  =[    $run2, ogre_jump1   ] {
+self.nextthink = time + 3;
+// if three seconds pass, assume ogre is stuck and jump again
+};
+
+void()   ogre_jump11  =[    $run1, ogre_jump12  ] {};
+void()   ogre_jump12  =[    $run2, ogre_run1 ] {};
+
+
+void()   Ogre_JumpTouch =
+{
+	local	float	ldmg;
+
+	if (self.health <= 0)
+		return;
+		
+	if (other.takedamage)
+	{
+		if ( vlen(self.velocity) > 400 )
+		{
+         sound (self, CHAN_VOICE, "ogre/ogwake.wav", 1, ATTN_NORM);  
+         ldmg = 1 + 10*random();
+			T_Damage (other, self, self, ldmg);	
+		}
+	}
+
+	if (!checkbottom(self))
+	{
+		if (self.flags & FL_ONGROUND)
+		{	// jump randomly to not get hung up
+//dprint ("popjump\n");
+	self.touch = SUB_Null;
+   self.think = ogre_jump1;
+	self.nextthink = time + 0.1;
+
+//			self.velocity_x = (random() - 0.5) * 600;
+//			self.velocity_y = (random() - 0.5) * 600;
+//			self.velocity_z = 200;
+//			self.flags = self.flags - FL_ONGROUND;
+		}
+		return;	// not on ground yet
+	}
+
+	self.touch = SUB_Null;
+   self.think = ogre_jump11;
+	self.nextthink = time + 0.1;
+};
+
+
+
+
+
+
+
+
 
 void() ogre_swing1	=[	$swing1,		ogre_swing2	] {ai_charge(11);
 sound (self, CHAN_WEAPON, "ogre/ogsawatk.wav", 1, ATTN_NORM);
@@ -438,7 +618,8 @@
 
 	setmodel (self, "progs/ogre.mdl");
 
-	setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+   // setsize (self, VEC_HULL2_MIN, VEC_HULL2_MAX);
+   setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
 	self.health = 200;
 
 	self.th_stand = ogre_stand1;
@@ -446,7 +627,8 @@
 	self.th_run = ogre_run1;
 	self.th_die = ogre_die;
 	self.th_melee = ogre_melee;
-	self.th_missile = ogre_nail1;
+   // self.th_missile = ogre_nail1;
+   self.th_missile = ogre_jump1;
 	self.th_pain = ogre_pain;
 	
 	walkmonster_start();
diff -ur --new-file ..\quake-c\src106/soldier.qc .\src/soldier.qc
--- ..\quake-c\src106/soldier.qc	Thu Sep 26 11:15:40 1996
+++ .\src/soldier.qc	Fri Nov 29 20:17:28 1996
@@ -43,6 +43,7 @@
 ==============================================================================
 */
 
+void() OgreFireGrenade;
 void() army_fire;
 
 void()	army_stand1	=[	$stand1,	army_stand2	] {ai_stand();};
@@ -98,10 +99,17 @@
 void()	army_atk2	=[	$shoot2,	army_atk3	] {ai_face();};
 void()	army_atk3	=[	$shoot3,	army_atk4	] {ai_face();};
 void()	army_atk4	=[	$shoot4,	army_atk5	] {ai_face();};
-void()	army_atk5	=[	$shoot5,	army_atk6	] {ai_face();army_fire();
-self.effects = self.effects | EF_MUZZLEFLASH;};
+
+// ### grenade mod ###
+// void()   army_atk5   =[ $shoot5, army_atk6   ] {ai_face();army_fire();
+// self.effects = self.effects | EF_MUZZLEFLASH;};
+void()   army_atk5   =[ $shoot5, army_atk6   ] {ai_face();OgreFireGrenade();};
+
 void()	army_atk6	=[	$shoot6,	army_atk7	] {ai_face();};
-void()	army_atk7	=[	$shoot7,	army_atk8	] {ai_face();SUB_CheckRefire (army_atk1);};
+
+// void()   army_atk7   =[ $shoot7, army_atk8   ] {ai_face(); SUB_CheckRefire (army_atk1);};
+void()   army_atk7   =[ $shoot7, army_atk8   ] {ai_face();};
+
 void()	army_atk8	=[	$shoot8,	army_atk9	] {ai_face();};
 void()	army_atk9	=[	$shoot9,	army_run1	] {ai_face();};
 
diff -ur --new-file ..\quake-c\src106/weapons.qc .\src/weapons.qc
--- ..\quake-c\src106/weapons.qc	Mon Sep 30 03:08:08 1996
+++ .\src/weapons.qc	Fri Nov 29 21:05:14 1996
@@ -1221,6 +1221,32 @@
 	dprint ("quad cheat\n");
 };
 
+
+void() W_Shotgun_quickshot =
+{
+   local string s;
+
+
+   if (self.ammo_shells < 1)
+      return;
+
+   W_ChangeWeapon();
+   W_Attack();
+
+   if (self.ammo_shells > 0)
+   {
+      s = ftos( self.ammo_shells );
+      sprint( self, "You have " );
+      sprint( self, s );
+      sprint( self, " shells left...\n" );
+   }
+   else
+      sprint( self, "** Out of shells **\n" );
+
+
+   self.impulse = 6;
+};
+
 /*
 ============
 ImpulseCommands
@@ -1229,7 +1255,11 @@
 */
 void() ImpulseCommands =
 {
-	if (self.impulse >= 1 && self.impulse <= 8)
+
+   if (self.impulse == 2)
+      W_Shotgun_quickshot();
+
+   if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
 
 	if (self.impulse == 9)
