diff -ur --new-file old106/client.qc v106qc/client.qc
--- old106/client.qc	Sun Sep 29 23:29:00 1996
+++ v106qc/client.qc	Thu Jan  2 14:38:56 1997
@@ -943,6 +943,12 @@
 		self.weapon = W_BestWeapon ();
 		W_SetCurrentAmmo ();
 	}
+
+// TOLLERTON: MOTD code, from Zoid's CTF source.
+	if (self.motd_on && self.motd_time > time)
+		centerprint(self, "Rich Tollerton's Physics Mods\nBuilt 1-2-97\nNOT TO BE INCLUDED IN OTHER SOURCES WITHOUT\nRICH TOLLERTON'S EXPRESSIVE PERMISSION.\n");
+	else if (self.motd_on && self.motd_time < time)
+		self.motd_on = 0;
 };
 	
 /*
@@ -1161,6 +1167,11 @@
 // a client connecting during an intermission can cause problems
 	if (intermission_running)
 		ExitIntermission ();
+
+// TOLLERTON: From Zoid's CTF code, some MOTD. Shameless, no?
+	self.motd_on = 1;
+	self.motd_time = time + 2;
+
 };
 
 
diff -ur --new-file old106/defs.qc v106qc/defs.qc
--- old106/defs.qc	Thu Sep 26 11:15:38 1996
+++ v106qc/defs.qc	Thu Jan  2 14:35:08 1997
@@ -409,6 +409,11 @@
 
 float		skill;
 
+// TOLLERTON: newphysics toggle.
+// REMOVED because it isn't really necessary.
+// float		newphysics;
+
+
 //================================================
 
 //
@@ -483,6 +488,11 @@
 .float		air_finished;	// when time > air_finished, start drowning
 .float		bubble_count;	// keeps track of the number of bubbles
 .string		deathtype;		// keeps track of how the player died
+
+// TOLLERTON: For MOTD stuff. Shamelessly copied from Zoid's work, no less.
+.float		motd_on;
+.float		motd_time;
+
 
 //
 // object stuff
diff -ur --new-file old106/progdefs.h v106qc/progdefs.h
--- old106/progdefs.h	Thu Jan  1 00:00:00 1970
+++ v106qc/progdefs.h	Thu Jan  2 14:40:16 1997
@@ -0,0 +1,143 @@
+
+/* file generated by qcc, do not modify */
+
+typedef struct
+{	int	pad[28];
+	int	self;
+	int	other;
+	int	world;
+	float	time;
+	float	frametime;
+	float	force_retouch;
+	string_t	mapname;
+	float	deathmatch;
+	float	coop;
+	float	teamplay;
+	float	serverflags;
+	float	total_secrets;
+	float	total_monsters;
+	float	found_secrets;
+	float	killed_monsters;
+	float	parm1;
+	float	parm2;
+	float	parm3;
+	float	parm4;
+	float	parm5;
+	float	parm6;
+	float	parm7;
+	float	parm8;
+	float	parm9;
+	float	parm10;
+	float	parm11;
+	float	parm12;
+	float	parm13;
+	float	parm14;
+	float	parm15;
+	float	parm16;
+	vec3_t	v_forward;
+	vec3_t	v_up;
+	vec3_t	v_right;
+	float	trace_allsolid;
+	float	trace_startsolid;
+	float	trace_fraction;
+	vec3_t	trace_endpos;
+	vec3_t	trace_plane_normal;
+	float	trace_plane_dist;
+	int	trace_ent;
+	float	trace_inopen;
+	float	trace_inwater;
+	int	msg_entity;
+	func_t	main;
+	func_t	StartFrame;
+	func_t	PlayerPreThink;
+	func_t	PlayerPostThink;
+	func_t	ClientKill;
+	func_t	ClientConnect;
+	func_t	PutClientInServer;
+	func_t	ClientDisconnect;
+	func_t	SetNewParms;
+	func_t	SetChangeParms;
+} globalvars_t;
+
+typedef struct
+{
+	float	modelindex;
+	vec3_t	absmin;
+	vec3_t	absmax;
+	float	ltime;
+	float	movetype;
+	float	solid;
+	vec3_t	origin;
+	vec3_t	oldorigin;
+	vec3_t	velocity;
+	vec3_t	angles;
+	vec3_t	avelocity;
+	vec3_t	punchangle;
+	string_t	classname;
+	string_t	model;
+	float	frame;
+	float	skin;
+	float	effects;
+	vec3_t	mins;
+	vec3_t	maxs;
+	vec3_t	size;
+	func_t	touch;
+	func_t	use;
+	func_t	think;
+	func_t	blocked;
+	float	nextthink;
+	int	groundentity;
+	float	health;
+	float	frags;
+	float	weapon;
+	string_t	weaponmodel;
+	float	weaponframe;
+	float	currentammo;
+	float	ammo_shells;
+	float	ammo_nails;
+	float	ammo_rockets;
+	float	ammo_cells;
+	float	items;
+	float	takedamage;
+	int	chain;
+	float	deadflag;
+	vec3_t	view_ofs;
+	float	button0;
+	float	button1;
+	float	button2;
+	float	impulse;
+	float	fixangle;
+	vec3_t	v_angle;
+	float	idealpitch;
+	string_t	netname;
+	int	enemy;
+	float	flags;
+	float	colormap;
+	float	team;
+	float	max_health;
+	float	teleport_time;
+	float	armortype;
+	float	armorvalue;
+	float	waterlevel;
+	float	watertype;
+	float	ideal_yaw;
+	float	yaw_speed;
+	int	aiment;
+	int	goalentity;
+	float	spawnflags;
+	string_t	target;
+	string_t	targetname;
+	float	dmg_take;
+	float	dmg_save;
+	int	dmg_inflictor;
+	int	owner;
+	vec3_t	movedir;
+	string_t	message;
+	float	sounds;
+	string_t	noise;
+	string_t	noise1;
+	string_t	noise2;
+	string_t	noise3;
+} entvars_t;
+
+#define PROGHEADER_CRC 5927
diff -ur --new-file old106/weapons.qc v106qc/weapons.qc
--- old106/weapons.qc	Mon Sep 30 03:08:08 1996
+++ v106qc/weapons.qc	Thu Jan  2 14:40:02 1997
@@ -262,6 +262,16 @@
 W_FireShotgun
 ================
 */
+
+/*
+ TOLLERTON: Great. Not once in this file is the muzzle distance (from player
+ to the end of the barrel) used or shown. It will come in handy later, when
+ I want to simulate 'streaking' (I think that's the word; it's when you fire
+ while quickly rotating, making the shot pattern elliptical and parallel to
+ your rotation; caused by the different muzzle locations when the first and
+ last shots leave the barrel). I'll have to rip the shotgun MDLs and estimate
+ the lengths myself, then...
+*/
 void() W_FireShotgun =
 {
 	local vector dir;
@@ -271,7 +281,14 @@
 	self.punchangle_x = -2;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
+
+// TOLLERTON: Quake trivia fact: Using this method, shot is calculated to
+// be 100 times faster than rockets. But the way the damage is calculated,
+// the shot travels infinitely fast.
 	dir = aim (self, 100000);
+
+// TOLLERTON: '0.04 0.04 0' is the radius of the shot pattern (which should
+// be a cone). NOT the muzzle distance.
 	FireBullets (6, dir, '0.04 0.04 0');
 };
 
@@ -296,6 +313,8 @@
 	self.punchangle_x = -4;
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
+
+// TOLLERTON: See above notes on shot speed and blast radius.
 	dir = aim (self, 100000);
 	FireBullets (14, dir, '0.14 0.08 0');
 };
@@ -379,10 +398,19 @@
 	
 	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
 
+// TOLLERTON: The player should just move backward when firing this thing
+// while moving IMHO. The momentum imparted by the rocket is almost as much
+// as the player (or more than it) under normal circumstances.
+
 	self.punchangle_x = -2;
 
 	missile = spawn ();
 	missile.owner = self;
+
+// TOLLERTON: Missiles are still affected by gravity, without the lift
+// imparted by the fins and possible secondary thrust systems figured in.
+// But standard gravity is too much for rockets, and gravity is hardcoded
+// in physics appearantly, so I won't mess with this for now.
 	missile.movetype = MOVETYPE_FLYMISSILE;
 	missile.solid = SOLID_BBOX;
 	missile.classname = "missile";
@@ -390,10 +418,18 @@
 // set missile speed	
 
 	makevectors (self.v_angle);
+
+// TOLLERTON: This definitely doesn't look too fast, but gameplay suffers if
+// I increase it any (I think).
 	missile.velocity = aim(self, 1000);
-	missile.velocity = missile.velocity * 1000;
+
+// TOLLERTON: I had to change the velocity to account for player movement
+// *AFTER* the missile.angle is set, or else the missile will point in the
+// direction it is moving. Instead, it still points straight ahead.
+
+
 	missile.angles = vectoangles(missile.velocity);
-	
+	missile.velocity = missile.velocity * 1000 + self.velocity;
 	missile.touch = T_MissileTouch;
 	
 // set missile duration
@@ -402,6 +438,8 @@
 
 	setmodel (missile, "progs/missile.mdl");
 	setsize (missile, '0 0 0', '0 0 0');		
+
+// TOLLERTON: '0 0 16' is the muzzle distance.
 	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
 };
 
@@ -567,12 +605,15 @@
 	makevectors (self.v_angle);
 
 	if (self.v_angle_x)
-		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10 + self.velocity;
 	else
 	{
+
+// TOLLERTON: Though it looks at first as if the grenade is calculated to be
+// LOTS faster than a rocket, in reality it's about 30-70% as fast.
 		missile.velocity = aim(self, 10000);
-		missile.velocity = missile.velocity * 600;
-		missile.velocity_z = 200;
+		missile.velocity = missile.velocity * 600 + self.velocity;
+		missile.velocity_z = 200 + missile.velocity_z;
 	}
 
 	missile.avelocity = '300 300 300';
@@ -587,7 +628,12 @@
 
 	setmodel (missile, "progs/grenade.mdl");
 	setsize (missile, '0 0 0', '0 0 0');		
-	setorigin (missile, self.origin);
+
+// TOLLERTON: Phooey. Grenades start at the player's location, not in front
+// of him (like it should be). I'll change it so that there is a muzzle later;
+// right now there's no real difference.
+
+	setorigin (missile, self.origin + '0 0 0');
 };
 
 
@@ -621,7 +667,9 @@
 	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
 	setorigin (newmis, org);
 
-	newmis.velocity = dir * 1000;
+// TOLLERTON: Yet another trivia note: Nails travel at exactly the same speed
+// that rockets do!
+	newmis.velocity = dir * 1000 + self.velocity;
 };
 
 void() W_FireSuperSpikes =
@@ -633,6 +681,8 @@
 	self.attack_finished = time + 0.2;
 	self.currentammo = self.ammo_nails = self.ammo_nails - 2;
 	dir = aim (self, 1000);
+
+// TOLLERTON: See below for muzzle distance notes.
 	launch_spike (self.origin + '0 0 16', dir);
 	newmis.touch = superspike_touch;
 	setmodel (newmis, "progs/s_spike.mdl");
@@ -664,6 +714,9 @@
 	self.attack_finished = time + 0.2;
 	self.currentammo = self.ammo_nails = self.ammo_nails - 1;
 	dir = aim (self, 1000);
+
+// TOLLERTON: '0 0 16' is the muzzle distance, which is the same for rockets
+// and perforators (super nailguns).
 	launch_spike (self.origin + '0 0 16' + v_right*ox, dir);
 
 	self.punchangle_x = -2;
@@ -755,6 +808,11 @@
 ===============================================================================
 */
 
+/*
+ TOLLERTON: I wonder if it's possible to display the weapon MDL's *backwards*.
+ Bludgeon your enemies with the butt of your gun!
+*/
+
 void() W_SetCurrentAmmo =
 {
 	player_run ();		// get out of any weapon firing states
@@ -1027,6 +1085,8 @@
 */
 void() CheatCommand =
 {
+
+// TOLLERTON: If anybody wants cheats in DM, this is what to get rid of.
 	if (deathmatch || coop)
 		return;
 
@@ -1243,7 +1303,22 @@
 
 	if (self.impulse == 255)
 		QuadCheat ();
-		
+
+// TOLLERTON: To enable/disable the new momentum code on nails/missiles.
+// REMOVED because it's not necessary, all players could use it without
+// anybody knowing, etc.
+/*	if (self.impulse == 192)
+	{
+		newphysics  = 1;
+		dprint("Tollerton's newphysics code ACTIVE.\n");
+	}
+	if (self.impulse == 193)
+	{
+		newphysics = 0;
+		dprint("Tollerton's newphysics code DISABLED.\n");
+	}
+*/
+
 	self.impulse = 0;
 };
 
