diff -ur --new-file ..\quake-c\src106/client.qc .\src/client.qc
--- ..\quake-c\src106/client.qc	Sun Sep 29 23:29:00 1996
+++ .\src/client.qc	Fri Jan 24 21:16:14 1997
@@ -59,6 +59,10 @@
 	parm7 = self.ammo_cells;
 	parm8 = self.weapon;
 	parm9 = self.armortype * 100;
+
+    //HUDdle flags
+    parm13 = self.dest_y;
+
 };
 
 void() SetNewParms =
@@ -91,6 +95,11 @@
 	self.ammo_cells = parm7;
 	self.weapon = parm8;
 	self.armortype = parm9 * 0.01;
+
+    //HUDdle flags
+    self.dest_y = parm13;
+    if (self.dest_y & HUD_ON)
+        Spawn_HUD_entity (self);
 };
 
 /*
diff -ur --new-file ..\quake-c\src106/defs.qc .\src/defs.qc
--- ..\quake-c\src106/defs.qc	Thu Sep 26 11:15:38 1996
+++ .\src/defs.qc	Fri Jan 24 21:58:24 1997
@@ -161,7 +161,7 @@
 .float		idealpitch;		// calculated pitch angle for lookup up slopes
 
 
-.string		netname;
+.string     netname;
 
 .entity 	enemy;
 
@@ -691,3 +691,9 @@
 float(entity targ, entity inflictor) CanDamage;
 
 
+// free player entity variable
+// '.float speed'  bit-flag defines:
+float HUD_FULL_ONLY   = 32; //set if HUD should only display in fullscreen
+float HUD_ON          = 16; //set if HUD is on.
+// hack variable
+float HUD_backpack_refresh;
diff -ur --new-file ..\quake-c\src106/hud.qc .\src/hud.qc
--- ..\quake-c\src106/hud.qc	Thu Jan  1 00:00:00 1970
+++ .\src/hud.qc	Fri Jan 24 21:58:26 1997
@@ -0,0 +1,466 @@
+// ###############
+// ### HUD mod ###
+
+/*
+Notes: The following odd things are done.
+1) The HUD entity's .dest_x variable is used as a "timeout" so we can
+   update the HUD, when the seconds change.
+2) The player's .dest_y variable is used to store the HUD flags (like HUD_ON,
+   etc.)
+3) The HUD entity's .height is used to detect screen size changes
+*/
+
+void() HUD_print_info =
+{
+   local string str;
+   local entity player;
+   local vector vec;
+   local float min, sec, fl;
+
+   // reset print conditions
+   self.dest_x      = time + 1;
+   self.ammo_shells = self.owner.ammo_shells;
+   self.ammo_nails  = self.owner.ammo_nails;
+   self.ammo_rockets = self.owner.ammo_rockets;
+   self.ammo_cells  = self.owner.ammo_cells;
+   self.health      = self.owner.health;
+   self.armortype   = self.owner.armortype;
+   self.armorvalue  = self.owner.armorvalue;
+   self.weapon      = self.owner.weapon;
+   self.items       = self.owner.items; 
+   self.angles      = self.owner.angles;
+   self.frags       = self.owner.frags;
+   //used to detect screen size changes
+   self.height = cvar("viewsize");
+
+   player = self.owner;
+
+
+    //axe and shotgun are special case, we assume we always have them
+    if (self.weapon == IT_AXE)
+        sprint (player, ""); //177
+    else
+        sprint (player, "1");
+
+    if (self.weapon == IT_SHOTGUN)
+        sprint (player, ""); //178
+    else
+        sprint (player, "2");
+
+
+    // Show which weapons we have, which we are using.
+
+    if (self.weapon == IT_SUPER_SHOTGUN)        //if we're using the SSG,
+        sprint (player, ""); //179             //print "3" in brown
+    else if (self.items & IT_SUPER_SHOTGUN)    //if we *have* the SSG,
+        sprint (player, "3");                   //print "3" in white
+    else
+        sprint (player, " ");                   //otherwise, print nothing.
+
+    if (self.weapon == IT_NAILGUN)              //ditto for NG, SNG, GL, RL, L
+        sprint (player, ""); //180
+    else if (self.items & IT_NAILGUN)
+        sprint (player, "4");
+    else
+        sprint (player, " ");
+
+    if (self.weapon == IT_SUPER_NAILGUN)
+        sprint (player, ""); //181
+    else if (self.items & IT_SUPER_NAILGUN)
+        sprint (player, "5");
+    else
+        sprint (player, " ");
+
+    if (self.weapon == IT_GRENADE_LAUNCHER)
+        sprint (player, ""); //182
+    else if (self.items & IT_GRENADE_LAUNCHER)
+        sprint (player, "6");
+    else
+        sprint (player, " ");
+
+    if (self.weapon == IT_ROCKET_LAUNCHER)
+        sprint (player, ""); //183
+    else if (self.items & IT_ROCKET_LAUNCHER)
+        sprint (player, "7");
+    else
+        sprint (player, " ");
+
+    if (self.weapon == IT_LIGHTNING)
+        sprint (player, ""); //184
+    else if (self.items & IT_LIGHTNING)
+        sprint (player, "8");
+    else
+        sprint (player, " ");
+
+    //always remember our spaceing :)
+    sprint (player, " ");
+
+    //now for checks for powerups. We don't bother to see about times, etc.
+    //we assume that the flag is cleared when the powerup times out.
+
+    if (self.items & IT_SUIT)  // if we have the biosuit,
+        sprint (player, "B");   // print a "B"
+    else
+        sprint (player, " ");   // otherwise, leave blank.
+
+    if (self.items & IT_QUAD)  // ditto for Quad, Pent, Ring.
+        sprint (player, "Q");   
+    else
+        sprint (player, " ");  
+
+    if (self.items & IT_INVULNERABILITY)  
+        sprint (player, "P");   
+    else
+        sprint (player, " ");   
+
+    if (self.items & IT_INVISIBILITY)  
+        sprint (player, "R");   
+    else
+        sprint (player, " ");   
+
+    //always remember our spaceing :)
+    sprint (player, " ");
+
+    // next, ammo.
+    // shells first.
+    if (self.items & IT_SHELLS)        // true if shells is current ammo.
+        sprint (player, ""); //211     // print brown s
+    else
+        sprint (player, "S");
+
+    if (self.ammo_shells < 100)         // this is a long & complex hack to
+        sprint (player, " ");           // pad short numbers with 0's, so we
+        if (self.ammo_shells < 10)      // can keep our alignment.
+            sprint (player, " ");
+
+    str = ftos(self.ammo_shells);
+    sprint (player, str);
+
+    sprint (player, " ");
+
+    if (self.items & IT_NAILS)         // true if nails is current ammo.
+        sprint (player, ""); //206     // print brown n
+    else
+        sprint (player, "N");
+
+    if (self.ammo_nails < 100)          // this is a long & complex hack to
+        sprint (player, " ");           // pad short numbers with 0's, so we
+        if (self.ammo_nails < 10)       // can keep our alignment.
+            sprint (player, " ");
+
+    str = ftos(self.ammo_nails);
+    sprint (player, str);
+
+    sprint (player, " ");
+
+    if (self.items & IT_ROCKETS)       // true if rockets is current ammo.
+        sprint (player, ""); //210     // print brown R
+    else
+        sprint (player, "R");
+
+    if (self.ammo_rockets < 100)        // this is a long & complex hack to
+        sprint (player, " ");           // pad short numbers with 0's, so we
+        if (self.ammo_rockets < 10)     // can keep our alignment.
+            sprint (player, " ");
+
+    str = ftos(self.ammo_rockets);
+    sprint (player, str);
+
+    sprint (player, " ");
+
+    if (self.items & IT_CELLS)         // true if cells is current ammo.
+        sprint (player, ""); //195     // print brown c
+    else
+        sprint (player, "C");
+
+    if (self.ammo_cells < 100)          // this is a long & complex hack to
+        sprint (player, " ");           // pad short numbers with 0's, so we
+        if (self.ammo_cells < 10)       // can keep our alignment.
+            sprint (player, " ");
+
+    str = ftos(self.ammo_cells);
+    sprint (player, str);
+
+    //always remember our spaceing :)
+    sprint (player, " ");
+
+    //now for angle. this could get dangerous...
+    vec = self.angles;
+    fl = vec_y;
+
+    //Note: angle is from 180 to -180. We need it from 0 to 360, and integer.
+
+    if (fl < 0)         // trust me, this one works.
+        fl = fabs(fl);
+    else
+        fl = 360 - fl;
+
+    fl = fl + 0.5;      // since we use floor, this will make sure we round to
+                        // the nearest number
+    fl = floor (fl);    // makes an integer.
+
+    if (fl > 357 || fl < 3) sprint (player, " N ");
+    else if (fl > 20 && fl < 26) sprint (player, "NNE");
+    else if (fl > 42 && fl < 48) sprint (player, " NE");
+    else if (fl > 65 && fl < 71) sprint (player, "ENE");
+    else if (fl > 87 && fl < 103) sprint (player, " E ");
+    else if (fl > 110 && fl < 116) sprint (player, "ESE");
+    else if (fl > 132 && fl < 138) sprint (player, " SE");
+    else if (fl > 160 && fl < 166) sprint (player, "SSE");
+    else if (fl > 177 && fl < 183) sprint (player, " S ");
+    else if (fl > 200 && fl < 206) sprint (player, "SSW");
+    else if (fl > 222 && fl < 228) sprint (player, " SW");
+    else if (fl > 245 && fl < 251) sprint (player, "WSW");
+    else if (fl > 267 && fl < 273) sprint (player, " W ");
+    else if (fl > 290 && fl < 296) sprint (player, "WNW");
+    else if (fl > 312 && fl < 318) sprint (player, " NW");
+    else if (fl > 335 && fl < 341) sprint (player, "NNW");
+    else
+        {
+            if (fl < 100)                      // this is a long & complex hack to
+                sprint (player, "0");           // pad short numbers with 0's, so we
+            if (fl < 10)                       // can keep our alignment.
+                sprint (player, "0");
+            str = ftos(fl);
+
+            sprint (player, str);
+        }
+
+    //Ahh! Now for the next line!
+    sprint (player, "\n");
+
+    //First, the armor type.
+   if      (self.armortype == 0)   str = " ";
+   else if (self.armortype == 0.3) str = "G";
+   else if (self.armortype == 0.6) str = "Y";
+   else if (self.armortype == 0.8) str = "R";
+   else                            str = "*";
+   sprint(player, str );
+    if (self.armorvalue < 100)          // this is a long & complex hack to
+        sprint (player, " ");           // pad short numbers with 0's, so we
+        if (self.armorvalue < 10)       // can keep our alignment.
+            sprint (player, " ");
+
+    str = ftos(self.armorvalue);
+    sprint (player, str);
+
+    // and now for our spacing again...
+    sprint (player, " ");
+
+    //Next, health
+    sprint (player, "H");
+    if (self.health < 1000)                 // it's physically possible to 
+        {                                   // have health up to 32767, so 
+        if (self.health < 100)              // if it's 3++ digits, just print
+            sprint (player, " ");           // !!!'s.
+        if (self.health < 10)           
+            sprint (player, " ");
+
+        str = ftos(self.health);
+        sprint (player, str);
+        }
+    else
+        sprint (player, "!!!");
+
+    // and now for our spacing again...
+    sprint (player, " ");
+
+    // Gold key?
+    if (self.items & IT_KEY1)  
+        sprint (player, "G");   
+    else
+        sprint (player, " ");   
+
+    // Silver key?
+    if (self.items & IT_KEY2)  
+        sprint (player, "S");   
+    else
+        sprint (player, " ");   
+
+    // and now for our spacing again...
+    sprint (player, " ");
+
+    //Now for the current time... tricky.
+    fl = time;              // store the time in a temporary holder, just in
+                            // case it ticks over during the calcs.
+    min = fl / 60;          // min is minutes with seconds as decimals
+    min = floor(min);       // min is now just minutes
+    if (min < 10)
+        sprint (player, " ");
+    str = ftos(min);
+    sprint (player, str);
+
+    sprint (player, ":");
+
+    sec = fl / 60;          // sec is now minutes with seconds as decimals
+    sec = sec - min;        // sec is now only seconds as decimals
+    sec = sec * 60;         // back to seconds again.
+    sec = floor(sec);       // *integer* # of seconds :)
+    if (sec < 10)
+        sprint (player, "0");
+    str = ftos(sec);
+    sprint (player, str);
+
+    //always remember our spaceing :)
+    sprint (player, " ");
+
+    //Secrets!
+    if (found_secrets < 10)     //note: only supports up to 99 secrets!
+        sprint (player, " ");
+    str = ftos(found_secrets);
+    sprint (player, str);
+
+    sprint (player, "/");
+
+    if (total_secrets < 10)
+        sprint (player, " ");
+    str = ftos(total_secrets);
+    sprint (player, str);
+
+    // and now for our spacing again...
+    sprint (player, " ");
+
+    // Now, this line ends differently for DM and non-DM...
+    if (!deathmatch)
+        {
+        // Monsters...
+        if (killed_monsters < 100)  //note: only supports up to 999 monsters!
+            sprint (player, " ");
+        if (killed_monsters < 10)
+            sprint (player, " ");
+        str = ftos(killed_monsters);
+        sprint (player, str);
+    
+        sprint (player, "/");    
+    
+        if (total_monsters < 100)
+            sprint (player, " ");
+        if (total_monsters < 10)
+            sprint (player, " ");
+        str = ftos(total_monsters);
+        sprint (player, str);
+
+        // and now for our spacing again...
+        sprint (player, " ");
+
+        sprint (player, "0.95");
+        }
+
+    else
+        {
+        sprint (player, " ");
+
+        sprint (player, "F");
+        if (self.frags > 0 || self.frags == 0)
+            {    
+            if (self.frags < 100)      // this is a long & complex hack to
+                sprint (player, " ");  // pad short numbers with 0's, so we
+            if (self.frags < 10)       // can keep our alignment.
+                sprint (player, " ");
+
+            str = ftos(self.frags);
+            sprint (player, str);
+            }
+        else  //loser has suicided some..
+            {
+            if (self.frags < -99)
+                {
+                sprint (player, "-ve");
+                }
+            else
+                {
+                if (self.frags > -10)
+                    sprint (player, " ");
+                str = ftos (self.frags);
+                sprint (player, str);
+                }
+            }
+        }
+    
+    //finally, finish everything off
+    sprint (player, "\n\n\n");
+};
+
+void() HUD_entity_think =
+{
+    local float flag;
+    local float fl;
+
+    self.nextthink = time + 0.3;
+
+    if (!(self.owner.dest_y & HUD_ON))
+        {
+        remove (self);
+        return;
+        }
+
+    flag = 0;
+    if (self.owner.health != self.health)                  flag = 1;
+    else if (self.dest_x > time)                           flag = 1;
+    else if (self.owner.ammo_shells != self.ammo_shells)   flag = 1;
+    else if (self.owner.ammo_nails != self.ammo_nails)     flag = 1;
+    else if (self.owner.ammo_rockets != self.ammo_rockets) flag = 1;
+    else if (self.owner.ammo_cells != self.ammo_cells)     flag = 1;
+    else if (self.owner.armortype != self.armortype)       flag = 1;
+    else if (self.owner.armorvalue != self.armorvalue)     flag = 1;
+    else if (self.owner.weapon != self.weapon)             flag = 1;
+    else if (self.owner.items != self.items)               flag = 1;
+    else if (self.owner.angles != self.angles)             flag = 1;
+    else if (self.owner.frags != self.frags)               flag = 1;
+    else if (cvar("viewsize") != self.height)              flag = 1;
+    // hack to disable backpack messages
+    else if (HUD_backpack_refresh)
+    {
+        HUD_backpack_refresh = FALSE;                      flag = 1;
+    }
+
+    fl = cvar("viewsize");
+
+    if (self.owner.dest_y & HUD_FULL_ONLY) {
+        if (fl == 120) {
+            if (flag) {
+                HUD_print_info();
+                }
+            }
+        else {
+            sprint (self.owner, "\n\n\n\n"); 
+            }
+        }
+    else {
+        if (flag) {
+            HUD_print_info();
+            }
+        }
+};
+
+void(entity HUD_owner) Spawn_HUD_entity =
+{
+   local entity e;
+
+    if ( (HUD_owner.dest_y & HUD_ON) )
+        if (HUD_owner.dest_y & HUD_FULL_ONLY)
+            {
+                HUD_owner.dest_y = HUD_owner.dest_y - HUD_ON;
+                HUD_owner.dest_y = HUD_owner.dest_y - HUD_FULL_ONLY;
+                sprint (HUD_owner, "\n\n\n\n");
+                centerprint(HUD_owner, "\n\n\n\n");
+            }
+        else
+            {
+                HUD_owner.dest_y = HUD_owner.dest_y | HUD_FULL_ONLY;
+                centerprint(HUD_owner, "HUD is Full Screen Only");
+            }
+    else
+    {
+        HUD_owner.dest_y = HUD_owner.dest_y | HUD_ON;
+        e = spawn();
+        e.classname = "HUDdle";
+        e.owner = HUD_owner;
+        e.nextthink = time + 0.3;
+        e.think = HUD_entity_think;
+    }
+
+};
+
+// ### HUD mod ###
+// ###############
diff -ur --new-file ..\quake-c\src106/items.qc .\src/items.qc
--- ..\quake-c\src106/items.qc	Thu Sep 26 11:15:38 1996
+++ .\src/items.qc	Tue Jan 21 21:12:02 1997
@@ -168,11 +168,14 @@
 			return;
 	}
 	
-	sprint(other, "You receive ");
-	s = ftos(self.healamount);
-	sprint(other, s);
-	sprint(other, " health\n");
-	
+    if (! (other.speed & HUD_ON) )
+    {
+    sprint(other, "You receive ");
+    s = ftos(self.healamount);
+    sprint(other, s);
+    sprint(other, " health\n");
+    }
+
 // health touch sound
 	sound(other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
 
@@ -275,7 +278,8 @@
 		self.nextthink = time + 20;
 	self.think = SUB_regen;
 
-	sprint(other, "You got armor\n");
+    if (! (other.speed & HUD_ON) )
+    sprint(other, "You got armor\n");
 // armor touch sound
 	sound(other, CHAN_ITEM, "items/armor1.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -460,9 +464,12 @@
 	else
 		objerror ("weapon_touch: unknown classname");
 
-	sprint (other, "You got the ");
+    if (! (other.speed & HUD_ON) )
+    {
+    sprint (other, "You got the ");
 	sprint (other, self.netname);
 	sprint (other, "\n");
+    }
 // weapon touch sound
 	sound (other, CHAN_ITEM, "weapons/pkup.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -645,9 +652,12 @@
 
 	bound_other_ammo ();
 	
-	sprint (other, "You got the ");
+    if (! (other.speed & HUD_ON) )
+    {
+    sprint (other, "You got the ");
 	sprint (other, self.netname);
 	sprint (other, "\n");
+    }
 // ammo touch sound
 	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
@@ -1322,6 +1332,15 @@
 		Deathmatch_Weapon (old, new);
 
 	W_SetCurrentAmmo ();
+
+    if ( (other.speed & HUD_ON) )
+    {
+        // hack global to disable backpack messages in SP
+        // ensures HUD entities update after clearing display
+        HUD_backpack_refresh = TRUE;
+        sprint( other, "\n\n\n\n" );
+    }
+
 };
 
 /*
diff -ur --new-file ..\quake-c\src106/progs.src .\src/progs.src
--- ..\quake-c\src106/progs.src	Thu Sep 26 11:15:40 1996
+++ .\src/progs.src	Tue Jan 21 21:12:26 1997
@@ -6,6 +6,9 @@
 ai.qc
 combat.qc
 items.qc
+
+hud.qc
+
 weapons.qc
 world.qc
 client.qc
diff -ur --new-file ..\quake-c\src106/weapons.qc .\src/weapons.qc
--- ..\quake-c\src106/weapons.qc	Mon Sep 30 03:08:08 1996
+++ .\src/weapons.qc	Fri Jan 24 11:59:20 1997
@@ -1240,6 +1240,14 @@
 		ServerflagsCommand ();
 	if (self.impulse == 12)
 		CycleWeaponReverseCommand ();
+    if (self.impulse == 50)
+        Spawn_HUD_entity(self);
+    if (self.impulse == 42)
+        {
+        local string str;
+        str = ftos(self.frags);
+        sprint (self, str);
+        }
 
 	if (self.impulse == 255)
 		QuadCheat ();
