diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/client.qc flashlt/client.qc
--- v101qc/client.qc	Thu Jul 25 01:51:22 1996
+++ flashlt/client.qc	Mon Aug  5 19:53:31 1996
@@ -466,6 +466,7 @@
 	self.invincible_finished = 0;
 	self.effects = 0;
 	self.invincible_time = 0;
+	self.impulsehandler=DefaultImpulseCommands;
 
 	DecodeLevelParms ();
 	
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/defs.qc flashlt/defs.qc
--- v101qc/defs.qc	Thu Jul 25 01:51:22 1996
+++ flashlt/defs.qc	Mon Aug  5 19:53:32 1996
@@ -690,4 +690,6 @@
 
 float(entity targ, entity inflictor) CanDamage;
 
-
+.void() impulsehandler;
+.float it_flashlight_on;
+.entity it_flashlight_entity;
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/mktran.c flashlt/mktran.c
--- v101qc/mktran.c	Wed Dec 31 18:00:00 1969
+++ flashlt/mktran.c	Thu Aug 22 22:37:14 1996
@@ -0,0 +1,32 @@
+// A short program which outputs the transparent sprite I use
+
+void putl(long l) {
+	putchar(l);
+	putchar(l>>8);
+	putchar(l>>16);
+	putchar(l>>24);
+}
+
+main() {
+	putchar('I');
+	putchar('D');
+	putchar('S');
+	putchar('P');
+	putl(1); // version
+	putl(2); // type
+	putl(0); // bounding radius
+	putl(1); // max width
+	putl(1); // max height
+	putl(1); // Number of frames
+	putl(0); // "float beamlength"
+	putl(0); // synchronousA
+
+	putl(0); // Single frame picture
+	
+	putl(0); // offsx
+	putl(0); // offsy
+	putl(1); // width
+	putl(1); // height
+	putchar(0xff); //transparent pixel
+};
+
Binary files v101qc/progs/null.spr and flashlt/progs/null.spr differ
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/weapons.qc flashlt/weapons.qc
--- v101qc/weapons.qc	Thu Jul 25 01:51:24 1996
+++ flashlt/weapons.qc	Thu Aug 15 18:30:30 1996
@@ -22,6 +22,8 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+
+	precache_model ("progs/null.spr");	// flashlight
 };
 
 float() crandom =
@@ -1130,6 +1132,69 @@
 
 };
 
+void() it_flashlight_aim = {
+	local vector direction, src;
+	local entity pl; // Player
+	local float temp;
+
+	pl=self.owner;
+//	if(pl.ammo_cells < 0 || ! pl.flags & FL_GODMODE) {
+//		pl.it_flashlight_on=0;
+//		pl.it_flashlight_entity=world;
+//		remove(self);
+//		return;
+//	}
+	makevectors(pl.v_angle);
+	
+	src = pl.origin + v_forward*10;
+	src_z = pl.absmin_z + pl.size_z * 0.7;
+
+	direction=aim(pl, 100000);
+	traceline(src, src + direction * 2048, FALSE, pl);
+	src=0.1*src+0.9*trace_endpos;
+	setorigin(self, src);
+
+//	dprint(vtos(trace_endpos));
+//	dprint("\n");
+
+	self.nextthink=time+0.05;
+//	if(pl.ammo_cells==0) return; /* God mode */
+//	temp=pl.ammo_cells;
+//	if(pl.currentammo==temp) /* FIXME */
+//		pl.currentammo=temp - 1;
+//	pl.ammo_cells=temp - 1;
+};
+
+void() I_FlashlightToggle =
+{
+	local entity oldself;
+	if(self.it_flashlight_on) {
+		if(self.it_flashlight_entity) remove(self.it_flashlight_entity);
+		self.it_flashlight_entity=world;
+		self.it_flashlight_on=0;
+		self.effects=self.effects &! EF_DIMLIGHT;
+	} else {
+		self.it_flashlight_on=1;
+		oldself=self;
+		self.it_flashlight_entity=spawn();
+		self=self.it_flashlight_entity;
+
+		self.movetype= MOVETYPE_NONE;
+		self.solid = SOLID_NOT;
+		setmodel(self, "progs/null.spr");
+		setsize (self, '0 0 0', '0 0 0');		
+		
+		self.effects=EF_DIMLIGHT;
+		self.owner=oldself;
+		self.owner.effects=EF_DIMLIGHT;
+		self.nextthink=time+1;
+		self.think=it_flashlight_aim;
+		it_flashlight_aim();
+		self=oldself;
+	}
+		
+};
+
 /*
 ============
 ServerflagsCommand
@@ -1158,7 +1223,8 @@
 
 ============
 */
-void() ImpulseCommands =
+void() ExtendedImpulseCommands;
+void() DefaultImpulseCommands =
 {
 	if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
@@ -1169,11 +1235,49 @@
 		CycleWeaponCommand ();
 	if (self.impulse == 11)
 		ServerflagsCommand ();
+	if(self.impulse==12)
+		I_FlashlightToggle ();
 
+	if (self.impulse == 254)
+		self.impulsehandler=ExtendedImpulseCommands;
 	if (self.impulse == 255)
 		QuadCheat ();
 		
 	self.impulse = 0;
+};
+
+void() WeaponImpulseCommands =
+{
+	self.impulsehandler=DefaultImpulseCommands;
+	if (self.impulse >= 1 && self.impulse <= 8)
+		W_ChangeWeapon ();
+
+	if (self.impulse == 9)
+		CheatCommand ();
+	if (self.impulse == 10)
+		CycleWeaponCommand ();
+};
+
+void() ItemImpulseCommands =
+{
+	self.impulsehandler=DefaultImpulseCommands;
+	if(self.impulse==1)
+		I_FlashlightToggle();
+};
+
+void() ExtendedImpulseCommands =
+{
+	if(self.impulse==254)
+		self.impulsehandler=DefaultImpulseCommands;
+	else if(self.impulse==1)
+		self.impulsehandler=WeaponImpulseCommands;
+	else if(self.impulse==2)
+		self.impulsehandler=ItemImpulseCommands;
+};
+
+void() ImpulseCommands =
+{
+	self.impulsehandler();
 };
 
 /*
