diff -ur --new-file ..\v106qc/ai.qc .\QC/ai.qc
--- ..\v106qc/ai.qc	Mon Jul 21 23:05:54 1997
+++ .\QC/ai.qc	Fri Oct 24 21:37:34 1997
@@ -682,11 +682,11 @@
 	
 	movedist = dist;
 // see if the enemy is dead
-	if (self.enemy.health <= 0)
+	if (self.enemy.health <= 0 || self.enemy.solid != SOLID_SLIDEBOX)		/// Regeneration
 	{
 		self.enemy = world;
 	// FIXME: look all around for other targets
-		if (self.oldenemy.health > 0)
+		if (self.oldenemy.health>0 && self.oldenemy.solid==SOLID_SLIDEBOX)/// Regeneration
 		{
 			self.enemy = self.oldenemy;
 			HuntTarget ();
diff -ur --new-file ..\v106qc/boss.qc .\QC/boss.qc
--- ..\v106qc/boss.qc	Mon Jul 21 23:05:56 1997
+++ .\QC/boss.qc	Fri Oct 24 21:37:34 1997
@@ -263,7 +263,7 @@
 */
 void() monster_boss =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)	// Won't be in E1M7; No Rune in DM	/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/buttons.qc .\QC/buttons.qc
--- ..\v106qc/buttons.qc	Mon Jul 21 23:05:56 1997
+++ .\QC/buttons.qc	Fri Oct 24 21:37:34 1997
@@ -55,6 +55,8 @@
 {
 	if (other.classname != "player")
 		return;
+	if (other.solid == SOLID_NOT)								/// Battle
+		return;										/// Battle
 	self.enemy = other;
 	button_fire ();
 };
diff -ur --new-file ..\v106qc/client.qc .\QC/client.qc
--- ..\v106qc/client.qc	Mon Jul 21 23:06:00 1997
+++ .\QC/client.qc	Fri Oct 24 21:37:34 1997
@@ -81,16 +81,38 @@
 		if (world.model == "maps/start.bsp")
 			SetNewParms ();		// take away all stuff on starting new episode
 	}
-	
-	self.items = parm1;
-	self.health = parm2;
-	self.armorvalue = parm3;
-	self.ammo_shells = parm4;
-	self.ammo_nails = parm5;
-	self.ammo_rockets = parm6;
-	self.ammo_cells = parm7;
-	self.weapon = parm8;
-	self.armortype = parm9 * 0.01;
+
+	if (deathmatch == 4)									/// Deathmatch 4
+	{												/// Deathmatch 4
+		self.items = IT_SHOTGUN | IT_AXE |						/// Deathmatch 4
+				IT_SUPER_SHOTGUN |						/// Deathmatch 4
+				IT_NAILGUN |							/// Deathmatch 4
+				IT_SUPER_NAILGUN |						/// Deathmatch 4
+				IT_GRENADE_LAUNCHER |						/// Deathmatch 4
+				IT_ROCKET_LAUNCHER |						/// Deathmatch 4
+				IT_LIGHTNING |							/// Deathmatch 4
+				IT_ARMOR3;								/// Deathmatch 4
+		self.health = 100;								/// Deathmatch 4
+		self.armorvalue = 200;								/// Deathmatch 4
+		self.ammo_shells = 100;								/// Deathmatch 4
+		self.ammo_nails = 200;								/// Deathmatch 4
+		self.ammo_rockets = 100;							/// Deathmatch 4
+		self.ammo_cells = 100;								/// Deathmatch 4
+		self.weapon = 1;									/// Deathmatch 4
+		self.armortype = 0.8;								/// Deathmatch 4
+	}												/// Deathmatch 4
+	else												/// Deathmatch 4
+	{
+		self.items = parm1;
+		self.health = parm2;
+		self.armorvalue = parm3;
+		self.ammo_shells = parm4;
+		self.ammo_nails = parm5;
+		self.ammo_rockets = parm6;
+		self.ammo_cells = parm7;
+		self.weapon = parm8;
+		self.armortype = parm9 * 0.01;
+	}
 };
 
 /*
@@ -372,6 +394,7 @@
 	{	// restart the entire server
 		localcmd ("restart\n");
 	}
+	self.delay = time + CAMP_MOVE;							/// Camper
 };
 
 
@@ -384,11 +407,17 @@
 */
 void() ClientKill =
 {
+	if (self.solid == SOLID_NOT)								/// Battle
+		return;										/// Battle
+
 	bprint (self.netname);
 	bprint (" suicides\n");
 	set_suicide_frame ();
 	self.modelindex = modelindex_player;
-	self.frags = self.frags - 2;	// extra penalty
+
+	if (battle >= BATTLE_OFF)								/// Battle
+		self.frags = self.frags - 2;	// extra penalty
+
 	respawn ();
 };
 
@@ -410,6 +439,8 @@
 	local	entity thing;
 	local	float  pcount;
 	
+	local float spots;									/// Random Respawn
+
 // testinfo_player_start is only found in regioned levels
 	spot = find (world, classname, "testplayerstart");
 	if (spot)
@@ -426,6 +457,17 @@
 	}
 	else if (deathmatch)
 	{
+		spots = 0;										/// Random Respawn
+		if (On(RESPAWNS))									/// Random Respawn
+		{											/// Random Respawn
+			spot = find(world, classname, "info_player_deathmatch");	/// Random Respawn
+			while (spot != world)							/// Random Respawn
+			{										/// Random Respawn
+				spots = spots + 1;						/// Random Respawn
+				spot=find(spot, classname, "info_player_deathmatch");	/// Random Respawn
+			}										/// Random Respawn
+			spots = floor(random() * spots);					/// Random Respawn
+		}											/// Random Respawn
 		spot = lastspawn;
 		while (1)
 		{
@@ -435,18 +477,23 @@
 				if (spot == lastspawn)
 					return lastspawn;
 				pcount = 0;
-				thing = findradius(spot.origin, 32);
+				if (On(RESPAWNS))							/// Random Respawn
+					thing = findradius(spot.origin, 500);		/// Random Respawn
+				else									/// Random Respawn
+					thing = findradius(spot.origin, 100);		/// Lord Smagol
+
 				while(thing)
 				{
 					if (thing.classname == "player")
 						pcount = pcount + 1;
 					thing = thing.chain;
 				}
-				if (pcount == 0)
-				{
-					lastspawn = spot;
-					return spot;
-				}
+				if (!pcount)							/// Random Respawn
+					lastspawn = spot;		// spot available		/// Random Respawn
+
+				spots = spots - 1;						/// Random Respawn
+				if (!pcount && spots < 0)					/// Random Respawn
+					return spot;						/// Random Respawn
 			}
 		}
 	}
@@ -536,7 +583,17 @@
 		spawn_tfog (self.origin + v_forward*20);
 	}
 
-	spawn_tdeath (self.origin, self);
+	if (self.mdl == "ghost")								/// Battle
+	{												/// Battle
+		self.solid = SOLID_NOT;								/// Battle
+		self.model = "";									/// Battle
+		self.mdl = "";									/// Battle
+		self.ammo_shells = 0;								/// Battle
+		self.items = IT_AXE;								/// Battle
+		self.impulse = 1;									/// Battle
+	}												/// Battle
+	else
+		spawn_tdeath (self.origin, self);
 };
 
 
@@ -674,13 +731,13 @@
 	timelimit = cvar("timelimit") * 60;
 	fraglimit = cvar("fraglimit");
 	
-	if (timelimit && time >= timelimit)
+	if (timelimit && time >= timelimit && !battle)					/// Battle
 	{
 		NextLevel ();
 		return;
 	}
 	
-	if (fraglimit && self.frags >= fraglimit)
+	if (fraglimit && self.frags >= fraglimit && !battle)				/// Battle
 	{
 		NextLevel ();
 		return;
@@ -714,7 +771,7 @@
 	}
 
 // wait for any button down
-	if (!self.button2 && !self.button1 && !self.button0)
+	if (!self.button2&&!self.button1&&!self.button0&&!(battle&&time>self.pausetime))///Battle
 		return;
 
 	self.button0 = 0;
@@ -745,9 +802,9 @@
 		{
 			self.swim_flag = time + 1;
 			if (random() < 0.5)
-				sound (self, CHAN_BODY, "misc/water1.wav", 1, ATTN_NORM);
+				SoundQ (self, CHAN_BODY, "misc/water1.wav", 1, ATTN_NORM);	/// Battle
 			else
-				sound (self, CHAN_BODY, "misc/water2.wav", 1, ATTN_NORM);
+				SoundQ (self, CHAN_BODY, "misc/water2.wav", 1, ATTN_NORM);	/// Battle
 		}
 
 		return;
@@ -765,7 +822,7 @@
 	
 	self.button2 = 0;
 // player jumping sound
-	sound (self, CHAN_BODY, "player/plyrjmp8.wav", 1, ATTN_NORM);
+	SoundQ (self, CHAN_BODY, "player/plyrjmp8.wav", 1, ATTN_NORM);		/// Battle
 	self.velocity_z = self.velocity_z + 270;
 };
 
@@ -789,9 +846,9 @@
 	if (self.waterlevel != 3)
 	{
 		if (self.air_finished < time)
-			sound (self, CHAN_VOICE, "player/gasp2.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/gasp2.wav", 1, ATTN_NORM);	/// Battle
 		else if (self.air_finished < time + 9)
-			sound (self, CHAN_VOICE, "player/gasp1.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/gasp1.wav", 1, ATTN_NORM);	/// Battle
 		self.air_finished = time + 12;
 		self.dmg = 2;
 	}
@@ -812,7 +869,7 @@
 		if (self.flags & FL_INWATER)
 		{	
 			// play leave water sound
-			sound (self, CHAN_BODY, "misc/outwater.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_BODY, "misc/outwater.wav", 1, ATTN_NORM);	/// Battle
 			self.flags = self.flags - FL_INWATER;
 		}
 		return;
@@ -845,11 +902,11 @@
 // player enter water sound
 
 		if (self.watertype == CONTENT_LAVA)
-			sound (self, CHAN_BODY, "player/inlava.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_BODY, "player/inlava.wav", 1, ATTN_NORM);	/// Battle
 		if (self.watertype == CONTENT_WATER)
-			sound (self, CHAN_BODY, "player/inh2o.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_BODY, "player/inh2o.wav", 1, ATTN_NORM);		/// Battle
 		if (self.watertype == CONTENT_SLIME)
-			sound (self, CHAN_BODY, "player/slimbrn2.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_BODY, "player/slimbrn2.wav", 1, ATTN_NORM);	/// Battle
 
 		self.flags = self.flags + FL_INWATER;
 		self.dmgtime = 0;
@@ -1126,15 +1183,15 @@
 	if ((self.jump_flag < -300) && (self.flags & FL_ONGROUND) && (self.health > 0))
 	{
 		if (self.watertype == CONTENT_WATER)
-			sound (self, CHAN_BODY, "player/h2ojump.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_BODY, "player/h2ojump.wav", 1, ATTN_NORM);	/// Battle
 		else if (self.jump_flag < -650)
 		{
 			T_Damage (self, world, world, 5); 
-			sound (self, CHAN_VOICE, "player/land2.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/land2.wav", 1, ATTN_NORM);	/// Battle
 			self.deathtype = "falling";
 		}
 		else
-			sound (self, CHAN_VOICE, "player/land.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/land.wav", 1, ATTN_NORM);		/// Battle
 
 		self.jump_flag = 0;
 	}
@@ -1155,9 +1212,16 @@
 */
 void() ClientConnect =
 {
+	if (battle == BATTLE_RUNNING)								/// Battle
+	{												/// Battle
+		self.mdl = "ghost";								/// Battle
+		bprint ("Observer ");								/// Battle
+	}												/// Battle
 	bprint (self.netname);
 	bprint (" entered the game\n");
-	
+
+	Welcome();											/// Lord Smagol
+
 // a client connecting during an intermission can cause problems
 	if (intermission_running)
 		ExitIntermission ();
@@ -1179,10 +1243,25 @@
 	// since they aren't *really* leaving
 
 	// let everyone else know
+
+	if (self.solid == SOLID_NOT && self.health > 0)					/// Battle
+		bprint ("Observer ");								/// Battle
+
+	else if (battle == BATTLE_RUNNING)							/// Battle
+		battle = BATTLE_BROKEN;								/// Battle
+
 	bprint (self.netname);
-	bprint (" left the game with ");
-	bprint (ftos(self.frags));
-	bprint (" frags\n");
+	bprint (" left the game");
+	if (self.solid != SOLID_NOT)								/// Battle
+	{
+		bprint (" with ");
+		bprint (ftos(self.frags));
+		bprint (" frag");
+		if (self.frags != 1)
+			bprint ("s");
+	}
+	bprint ("\n");
+	self.classname = "removed_player";							/// Battle
 	sound (self, CHAN_BODY, "player/tornoff2.wav", 1, ATTN_NONE);
 	set_suicide_frame ();
 };
@@ -1210,6 +1289,7 @@
 			bprint ("\n");
 
 			attacker.owner.frags = attacker.owner.frags + 1;
+			TellFrags(attacker.owner);						/// Battle
 			return;
 		}
 
@@ -1231,8 +1311,18 @@
 				attacker.frags = attacker.frags - 1;
 				bprint (targ.netname);
 				
-				if (targ.weapon == 64 && targ.waterlevel > 1)
+				if (targ.weapon == IT_LIGHTNING && targ.waterlevel > 1)
 				{
+					if (targ.watertype == CONTENT_LAVA)			/// Discharge
+					{								/// Discharge
+						bprint (" discharges into the lava.\n");	/// Discharge
+						return;						/// Discharge
+					}								/// Discharge
+					if (targ.watertype == CONTENT_SLIME)		/// Discharge
+					{								/// Discharge
+						bprint (" discharges into the slime.\n");	/// Discharge
+						return;						/// Discharge
+					}								/// Discharge
 					bprint (" discharges into the water.\n");
 					return;
 				}
@@ -1261,7 +1351,7 @@
 			{
 				attacker.frags = attacker.frags + 1;
 
-				rnum = attacker.weapon;
+				rnum = parm16;							/// Killing Weapon
 				if (rnum == IT_AXE)
 				{
 					deathstring = " was ax-murdered by ";
@@ -1319,11 +1409,15 @@
 				bprint (deathstring);
 				bprint (attacker.netname);
 				bprint (deathstring2);
+				TellFrags(attacker);						/// Battle
 			}
 			return;
 		}
 		else
 		{
+			if (attacker.classname == "battle")					/// Battle
+				return;								/// Battle
+
 			targ.frags = targ.frags - 1;
 			bprint (targ.netname);
 
diff -ur --new-file ..\v106qc/combat.qc .\QC/combat.qc
--- ..\v106qc/combat.qc	Mon Jul 21 23:06:00 1997
+++ .\QC/combat.qc	Fri Oct 24 21:37:36 1997
@@ -77,8 +77,12 @@
 	{
 		killed_monsters = killed_monsters + 1;
 		WriteByte (MSG_ALL, SVC_KILLEDMONSTER);
+		attacker.frags = attacker.frags + 1;					/// Monsters
 	}
 
+	if (self.classname == "player")							/// Battle
+		self.pausetime = time + 1;							/// Battle
+
 	ClientObituary(self, attacker);
 	
 	self.takedamage = DAMAGE_NO;
@@ -165,7 +169,8 @@
 		return;
 		
 // do the damage
-	targ.health = targ.health - take;
+	if (battle>=BATTLE_OFF && self.solid!=SOLID_NOT || attacker.classname=="battle")/// Battle
+		targ.health = targ.health - take;
 			
 	if (targ.health <= 0)
 	{
diff -ur --new-file ..\v106qc/defs.qc .\QC/defs.qc
--- ..\v106qc/defs.qc	Mon Jul 21 23:06:02 1997
+++ .\QC/defs.qc	Fri Oct 24 21:37:36 1997
@@ -310,6 +310,8 @@
 float	IT_SUIT					= 2097152;
 float	IT_QUAD					= 4194304;
 
+float	IT_ALIAS				= 8388608;						/// Lord Smagol
+
 // point content values
 
 float	CONTENT_EMPTY			= -1;
@@ -589,7 +591,17 @@
 void(entity client, string s)stuffcmd = #21;
 entity(vector org, float rad) findradius = #22;
 void(string s) bprint				= #23;
+
+void(string s, string s) bprint2						= #23;	/// Lord Smagol
+void(string s, string s, string s) bprint3				= #23;	/// Lord Smagol
+void(string s, string s, string s, string s) bprint4			= #23;	/// Lord Smagol
+void(string s, string s, string s, string s, string s) bprint5	= #23;	/// Lord Smagol
+
 void(entity client, string s) sprint = #24;
+
+void(entity client, string s, string s, string s) sprint3		  = #24;	/// Lord Smagol
+void(entity client, string s, string s, string s, string s) sprint4 = #24;	/// Lord Smagol
+
 void(string s) dprint				= #25;
 string(float f) ftos				= #26;
 string(vector v) vtos				= #27;
@@ -655,6 +667,12 @@
 void(string var, string val) cvar_set = #72;	// sets cvar.value
 
 void(entity client, string s) centerprint = #73;	// sprint, but in middle
+
+void(entity client, string s, string s) centerprint2								= #73;		/// Lord Smagol
+void(entity client, string s, string s, string s) centerprint3						= #73;		/// Lord Smagol
+void(entity client, string s, string s, string s, string s) centerprint4				= #73;		/// Lord Smagol
+void(entity client, string s, string s, string s, string s, string s) centerprint5			= #73;		/// Lord Smagol
+void(entity client, string s, string s, string s, string s, string s, string s) centerprint6	= #73;		/// Lord Smagol
 
 void(vector pos, string samp, float vol, float atten) ambientsound = #74;
 
diff -ur --new-file ..\v106qc/demon.qc .\QC/demon.qc
--- ..\v106qc/demon.qc	Mon Jul 21 23:06:02 1997
+++ .\QC/demon.qc	Fri Oct 24 21:37:36 1997
@@ -78,9 +78,19 @@
 	ai_face();
 	
 	self.touch = Demon_JumpTouch;
-	makevectors (self.angles);
-	self.origin_z = self.origin_z + 1;
-	self.velocity = v_forward * 600 + '0 0 250';
+	self.cnt = 0;										/// Fiend Jump
+	if (Yes(FIENDJUMP))									/// Fiend Jump
+	{												/// Fiend Jump
+		self.velocity=Ballistic(self.origin,self.enemy.origin,'0 600 250');/// Fiend Jump
+		self.angles = vectoangles(self.velocity);					/// Fiend Jump
+		self.angles_x = 0;								/// Fiend Jump
+	}												/// Fiend Jump
+	else												/// Fiend Jump
+	{
+		makevectors (self.angles);
+		self.origin_z = self.origin_z + 1;
+		self.velocity = v_forward * 600 + '0 0 250';
+	}
 	if (self.flags & FL_ONGROUND)
 		self.flags = self.flags - FL_ONGROUND;
 };
@@ -89,11 +99,14 @@
 void()	demon1_jump7	=[	$leap7,		demon1_jump8	] {};
 void()	demon1_jump8	=[ 	$leap8,		demon1_jump9	] {};
 void()	demon1_jump9	=[ 	$leap9,		demon1_jump10	] {};
-void()	demon1_jump10	=[ 	$leap10,	demon1_jump1	] {
-self.nextthink = time + 3;
-// if three seconds pass, assume demon is stuck and jump again
+void()	demon1_jump10	=[ 	$leap10,	demon1_jump10	]
+{
+	if (!self.velocity_z && !checkbottom(self))					/// Fiend Jump
+		if (!self.cnt)									/// Fiend Jump
+			self.cnt = 1;								/// Fiend Jump
+		else											/// Fiend Jump
+			self.think = demon1_jump1;						/// Fiend Jump
 };
-
 void()	demon1_jump11	=[ 	$leap11,	demon1_jump12	] {};
 void()	demon1_jump12	=[ 	$leap12,	demon1_run1	] {};
 
@@ -148,23 +161,32 @@
 {self.solid = SOLID_NOT;};
 void()	demon1_die7		=[	$death7,		demon1_die8	] {};
 void()	demon1_die8		=[	$death8,		demon1_die9	] {};
-void()	demon1_die9		=[	$death9,		demon1_die9 ] {};
+void()	demon1_die9		=[	$death9,		demon1_reg1 ]		/// Regeneration
+{													/// Regeneration
+	RegenMonster(demon1_die9, 300);							/// Regeneration
+};													/// Regeneration
+void()	demon1_reg1	=	[	$death9,	demon1_reg2	] {};			/// Regeneration
+void()	demon1_reg2	=	[	$death8,	demon1_reg3	] {};			/// Regeneration
+void()	demon1_reg3	=	[	$death7,	demon1_reg4	] {};			/// Regeneration
+void()	demon1_reg4	=	[	$death6,	demon1_reg5	] {};			/// Regeneration
+void()	demon1_reg5	=	[	$death5,	demon1_reg6	] {};			/// Regeneration
+void()	demon1_reg6	=	[	$death4,	demon1_reg7	] {};			/// Regeneration
+void()	demon1_reg7	=	[	$death3,	demon1_reg8	] {};			/// Regeneration
+void()	demon1_reg8	=	[	$death2,	demon1_reg9	] {};			/// Regeneration
+void()	demon1_reg9	=	[	$death1,	demon1_run1	] {};			/// Regeneration
 
 void() demon_die =
 {
 // check for gib
 	if (self.health < -80)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_demon.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
+		GibMonster ("progs/h_demon.mdl");						/// Lord Smagol
 		return;
 	}
 
 // regular death
 	demon1_die1 ();
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 
@@ -179,7 +201,7 @@
 */
 void() monster_demon1 =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
@@ -249,6 +271,27 @@
 {
 	local	vector	dist;
 	local	float	d;
+
+	if (Yes(FIENDJUMP))									/// Fiend Jump
+	{												/// Fiend Jump
+		if (time < self.jump_flag)							/// Fiend Jump
+			return FALSE;								/// Fiend Jump
+
+		if (!checkbottom(self))								/// Fiend Jump
+			return FALSE;								/// Fiend Jump
+
+		if (!walkmove(self.ideal_yaw, 1))						/// Fiend Jump
+		{											/// Fiend Jump
+			self.jump_flag = time + 1;						/// Fiend Jump
+			return FALSE;								/// Fiend Jump
+		}											/// Fiend Jump
+
+		d = vlen(self.enemy.origin - self.origin);				/// Fiend Jump
+		if (d < 100 || random() < 0.5 || d > 200 && random() < 0.8)		/// Fiend Jump
+			return FALSE;								/// Fiend Jump
+
+		return InRange(self.origin, self.enemy.origin, '0 600 250', 1);	/// Fiend Jump
+	}												/// Fiend Jump
 
 	if (self.origin_z + self.mins_z > self.enemy.origin_z + self.enemy.mins_z
 	+ 0.75 * self.enemy.size_z)
diff -ur --new-file ..\v106qc/dog.qc .\QC/dog.qc
--- ..\v106qc/dog.qc	Mon Jul 21 23:06:02 1997
+++ .\QC/dog.qc	Fri Oct 24 21:37:36 1997
@@ -156,9 +156,20 @@
 	ai_face();
 	
 	self.touch = Dog_JumpTouch;
-	makevectors (self.angles);
-	self.origin_z = self.origin_z + 1;
-	self.velocity = v_forward * 300 + '0 0 200';
+	self.cnt = 0;										/// Dog Jump
+	if (Yes(DOGJUMP))										/// Dog Jump
+	{												/// Dog Jump
+		self.velocity=Ballistic(self.origin,self.enemy.origin,'0 300 200');/// Dog Jump
+		self.angles = vectoangles(self.velocity);					/// Dog Jump
+		self.angles_x = 0;								/// Dog Jump
+	}												/// Dog Jump
+	else												/// Dog Jump
+	{
+		makevectors (self.angles);
+		self.origin_z = self.origin_z + 1;
+		self.velocity = v_forward * 300 + '0 0 200';
+	}
+
 	if (self.flags & FL_ONGROUND)
 		self.flags = self.flags - FL_ONGROUND;
 };
@@ -169,8 +180,14 @@
 void() dog_leap6	=[	$leap6,		dog_leap7	] {};
 void() dog_leap7	=[	$leap7,		dog_leap8	] {};
 void() dog_leap8	=[	$leap8,		dog_leap9	] {};
-void() dog_leap9	=[	$leap9,		dog_leap9	] {};
-
+void() dog_leap9	=[ 	$leap9,		dog_leap9	]
+{
+	if (!self.velocity_z && !checkbottom(self))					/// Dog Jump
+		if (!self.cnt)									/// Dog Jump
+			self.cnt = 1;								/// Dog Jump
+		else											/// Dog Jump
+			self.think = dog_leap1;							/// Dog Jump
+};
 void() dog_pain1	=[	$pain1 ,	dog_pain2	] {};
 void() dog_pain2	=[	$pain2 ,	dog_pain3	] {};
 void() dog_pain3	=[	$pain3 ,	dog_pain4	] {};
@@ -213,7 +230,19 @@
 void() dog_die6		=[	$death6,	dog_die7	] {};
 void() dog_die7		=[	$death7,	dog_die8	] {};
 void() dog_die8		=[	$death8,	dog_die9	] {};
-void() dog_die9		=[	$death9,	dog_die9	] {};
+void() dog_die9		=[	$death9,	dog_reg1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(dog_die9, 25);								/// Regeneration
+};													/// Regeneration
+void() dog_reg1		=[	$death9,	dog_reg2	] {};				/// Regeneration
+void() dog_reg2		=[	$death8,	dog_reg3	] {};				/// Regeneration
+void() dog_reg3		=[	$death7,	dog_reg4	] {};				/// Regeneration
+void() dog_reg4		=[	$death6,	dog_reg5	] {};				/// Regeneration
+void() dog_reg5		=[	$death5,	dog_reg6	] {};				/// Regeneration
+void() dog_reg6		=[	$death4,	dog_reg7	] {};				/// Regeneration
+void() dog_reg7		=[	$death3,	dog_reg8	] {};				/// Regeneration
+void() dog_reg8		=[	$death2,	dog_reg9	] {};				/// Regeneration
+void() dog_reg9		=[	$death1,	dog_run1	] {};				/// Regeneration
 
 void() dog_dieb1		=[	$deathb1,	dog_dieb2	] {};
 void() dog_dieb2		=[	$deathb2,	dog_dieb3	] {};
@@ -223,19 +252,26 @@
 void() dog_dieb6		=[	$deathb6,	dog_dieb7	] {};
 void() dog_dieb7		=[	$deathb7,	dog_dieb8	] {};
 void() dog_dieb8		=[	$deathb8,	dog_dieb9	] {};
-void() dog_dieb9		=[	$deathb9,	dog_dieb9	] {};
-
+void() dog_dieb9		=[	$death9,	dog_regb1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(dog_dieb9, 25);								/// Regeneration
+};													/// Regeneration
+void() dog_regb1		=[	$deathb9,	dog_regb2	] {};				/// Regeneration
+void() dog_regb2		=[	$deathb8,	dog_regb3	] {};				/// Regeneration
+void() dog_regb3		=[	$deathb7,	dog_regb4	] {};				/// Regeneration
+void() dog_regb4		=[	$deathb6,	dog_regb5	] {};				/// Regeneration
+void() dog_regb5		=[	$deathb5,	dog_regb6	] {};				/// Regeneration
+void() dog_regb6		=[	$deathb4,	dog_regb7	] {};				/// Regeneration
+void() dog_regb7		=[	$deathb3,	dog_regb8	] {};				/// Regeneration
+void() dog_regb8		=[	$deathb2,	dog_regb9	] {};				/// Regeneration
+void() dog_regb9		=[	$deathb1,	dog_run1	] {};				/// Regeneration
 
 void() dog_die =
 {
 // check for gib
 	if (self.health < -35)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowHead ("progs/h_dog.mdl", self.health);
+		GibMonster ("progs/h_dog.mdl");						/// Lord Smagol
 		return;
 	}
 
@@ -247,6 +283,8 @@
 		dog_die1 ();
 	else
 		dog_dieb1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 //============================================================================
@@ -279,6 +317,24 @@
 	local	vector	dist;
 	local	float	d;
 
+	if (Yes(DOGJUMP))										/// Dog Jump
+	{												/// Dog Jump
+		if (!checkbottom(self))								/// Dog Jump
+			return FALSE;								/// Dog Jump
+
+		if (!walkmove(self.ideal_yaw, 1))						/// Dog Jump
+			return FALSE;								/// Dog Jump
+
+		if (vlen(self.enemy.origin - self.origin) < 80)				/// Dog Jump
+			return FALSE;								/// Dog Jump
+
+		traceline (self.origin, self.enemy.origin, FALSE, self);		/// Dog Jump
+		if (trace_fraction < 1 && trace_ent != self.enemy)			/// Dog Jump
+			return FALSE;								/// Dog Jump
+
+		return InRange(self.origin, self.enemy.origin, '0 300 200', 1);	/// Dog Jump
+	}												/// Dog Jump
+
 	if (self.origin_z + self.mins_z > self.enemy.origin_z + self.enemy.mins_z
 	+ 0.75 * self.enemy.size_z)
 		return FALSE;
@@ -329,7 +385,7 @@
 */
 void() monster_dog =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/enforcer.qc .\QC/enforcer.qc
--- ..\v106qc/enforcer.qc	Mon Jul 21 23:06:04 1997
+++ .\QC/enforcer.qc	Fri Oct 24 21:37:36 1997
@@ -73,7 +73,7 @@
 
 void(vector org, vector vec) LaunchLaser =
 {
-	local	vector	vec;
+//	local	vector	vec;									/// Lord Smagol
 		
 	if (self.classname == "monster_enforcer")
 		sound (self, CHAN_WEAPON, "enforcer/enfire.wav", 1, ATTN_NORM);
@@ -92,6 +92,9 @@
 	setorigin (newmis, org);
 
 	newmis.velocity = vec * 600;
+	if (Yes(ENFSHOT))										/// Enforcer Shot
+		LaunchMissile(newmis, 600, 0);						/// Enforcer Shot
+
 	newmis.angles = vectoangles(newmis.velocity);
 
 	newmis.nextthink = time + 5;
@@ -267,11 +270,26 @@
 void()	enf_die11	=[	$death11,	enf_die12	] {ai_forward(5);};
 void()	enf_die12	=[	$death12,	enf_die13	] {ai_forward(5);};
 void()	enf_die13	=[	$death13,	enf_die14	] {};
-void()	enf_die14	=[	$death14,	enf_die14	] {};
-
-void()	enf_fdie1	=[	$fdeath1,	enf_fdie2	] {
+void()	enf_die14	=[	$death14,	enf_reg1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(enf_die14, 80);								/// Regeneration
+};													/// Regeneration
+void()	enf_reg1	=[	$death14,	enf_reg2	] {};				/// Regeneration
+void()	enf_reg2	=[	$death13,	enf_reg3	] {};				/// Regeneration
+void()	enf_reg3	=[	$death12,	enf_reg4	] {ai_back(5);};		/// Regeneration
+void()	enf_reg4	=[	$death11,	enf_reg5	] {ai_back(5);};		/// Regeneration
+void()	enf_reg5	=[	$death10,	enf_reg6	] {ai_back(5);};		/// Regeneration
+void()	enf_reg6	=[	$death9,	enf_reg7	] {ai_back(3);};		/// Regeneration
+void()	enf_reg7	=[	$death8,	enf_reg8	] {};				/// Regeneration
+void()	enf_reg8	=[	$death7,	enf_reg9	] {};				/// Regeneration
+void()	enf_reg9	=[	$death6,	enf_reg10	] {};				/// Regeneration
+void()	enf_reg10	=[	$death5,	enf_reg11	] {ai_back(2);};		/// Regeneration
+void()	enf_reg11	=[	$death4,	enf_reg12	] {ai_back(14);};		/// Regeneration
+void()	enf_reg12	=[	$death3,	enf_reg13	] {};				/// Regeneration
+void()	enf_reg13	=[	$death2,	enf_reg14	] {};				/// Regeneration
+void()	enf_reg14	=[	$death1,	enf_run1	] {};				/// Regeneration
 
-};
+void()	enf_fdie1	=[	$fdeath1,	enf_fdie2	] {};
 void()	enf_fdie2	=[	$fdeath2,	enf_fdie3	] {};
 void()	enf_fdie3	=[	$fdeath3,	enf_fdie4	] 
 {self.solid = SOLID_NOT;self.ammo_cells = 5;DropBackpack();};
@@ -282,19 +300,28 @@
 void()	enf_fdie8	=[	$fdeath8,	enf_fdie9	] {};
 void()	enf_fdie9	=[	$fdeath9,	enf_fdie10	] {};
 void()	enf_fdie10	=[	$fdeath10,	enf_fdie11	] {};
-void()	enf_fdie11	=[	$fdeath11,	enf_fdie11	] {};
-
+void()	enf_fdie11	=[	$fdeath11,	enf_freg1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(enf_fdie11, 80);								/// Regeneration
+};													/// Regeneration
+void()	enf_freg1	=[	$fdeath11,	enf_freg2	] {};				/// Regeneration
+void()	enf_freg2	=[	$fdeath10,	enf_freg3	] {};				/// Regeneration
+void()	enf_freg3	=[	$fdeath9,	enf_freg4	] {};				/// Regeneration
+void()	enf_freg4	=[	$fdeath8,	enf_freg5	] {};				/// Regeneration
+void()	enf_freg5	=[	$fdeath7,	enf_freg6	] {};				/// Regeneration
+void()	enf_freg6	=[	$fdeath6,	enf_freg7	] {};				/// Regeneration
+void()	enf_freg7	=[	$fdeath5,	enf_freg8	] {};				/// Regeneration
+void()	enf_freg8	=[	$fdeath4,	enf_freg9	] {};				/// Regeneration
+void()	enf_freg9	=[	$fdeath3,	enf_freg10	] {};				/// Regeneration
+void()	enf_freg10	=[	$fdeath2,	enf_freg11	] {};				/// Regeneration
+void()	enf_freg11	=[	$fdeath1,	enf_run1	] {};				/// Regeneration
 
 void() enf_die =
 {
 // check for gib
 	if (self.health < -35)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_mega.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		GibMonster ("progs/h_mega.mdl");						/// Lord Smagol
 		return;
 	}
 
@@ -304,6 +331,8 @@
 		enf_die1 ();
 	else
 		enf_fdie1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 
@@ -312,7 +341,7 @@
 */
 void() monster_enforcer =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/fight.qc .\QC/fight.qc
--- ..\v106qc/fight.qc	Mon Jul 21 23:06:06 1997
+++ .\QC/fight.qc	Fri Oct 24 21:37:36 1997
@@ -120,6 +120,10 @@
 
 	if (random () < chance)
 	{
+		if (self.classname == "monster_zombie" && Yes(ZOMBIESHOT))		/// Zombie Shot
+			if (!InRange(self.origin,self.enemy.origin,'0 600 200',1))	/// Zombie Shot
+				return FALSE;							/// Zombie Shot
+
 		self.th_missile ();
 		SUB_AttackFinished (2*random());
 		return TRUE;
@@ -401,6 +405,10 @@
 		chance = 0.05;
 	else
 		chance = 0;
+
+	if (Yes(OGRESHOT))									/// Ogre Shot
+		if (!InRange(self.origin,self.enemy.origin,'0 600 200',1.2))	/// Ogre Shot
+			return FALSE;								/// Ogre Shot
 
 	self.attack_state = AS_MISSILE;
 	SUB_AttackFinished (1 + 2*random());
diff -ur --new-file ..\v106qc/fish.qc .\QC/fish.qc
--- ..\v106qc/fish.qc	Mon Jul 21 23:06:06 1997
+++ .\QC/fish.qc	Fri Oct 24 21:37:38 1997
@@ -155,7 +155,7 @@
 */
 void() monster_fish =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/hknight.qc .\QC/hknight.qc
--- ..\v106qc/hknight.qc	Mon Jul 21 23:06:08 1997
+++ .\QC/hknight.qc	Fri Oct 24 21:37:38 1997
@@ -78,6 +78,14 @@
 	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
 	newmis.velocity = vec*300;
 	sound (self, CHAN_WEAPON, "hknight/attack1.wav", 1, ATTN_NORM);
+	if (Yes(DEATHSHOT))									/// Death Shot
+	{												/// Death Shot
+		LaunchMissile(newmis, 300, 0);						/// Death Shot
+		newmis.angles_y = newmis.angles_y + offset * 3;				/// Death Shot
+		makevectors (newmis.angles);							/// Death Shot
+		newmis.velocity = v_forward * 300;						/// Death Shot
+		newmis.velocity_z = 0 - newmis.velocity_z;	// Bug fix		/// Death Shot
+	}												/// Death Shot
 };
 
 void() CheckForCharge =
@@ -184,7 +192,22 @@
 void()	hknight_die9	=[	$death9,	hknight_die10	] {ai_forward(11);};
 void()	hknight_die10	=[	$death10,	hknight_die11	] {};
 void()	hknight_die11	=[	$death11,	hknight_die12	] {};
-void()	hknight_die12	=[	$death12,	hknight_die12	] {};
+void()	hknight_die12	=[	$death12,	hknight_reg1	]		/// Regeneration
+{													/// Regeneration
+	RegenMonster(hknight_die12, 250);							/// Regeneration
+};													/// Regeneration
+void() hknight_reg1	=[	$death12,	hknight_reg2	] {};			/// Regeneration
+void() hknight_reg2	=[	$death11,	hknight_reg3	] {};			/// Regeneration
+void() hknight_reg3	=[	$death10,	hknight_reg4	] {};			/// Regeneration
+void() hknight_reg4	=[	$death9,	hknight_reg5	] {ai_back(11);};	/// Regeneration
+void() hknight_reg5	=[	$death8,	hknight_reg6	] {ai_back(10);};	/// Regeneration
+void() hknight_reg6	=[	$death7,	hknight_reg7	] {};			/// Regeneration
+void() hknight_reg7	=[	$death6,	hknight_reg8	] {};			/// Regeneration
+void() hknight_reg8	=[	$death5,	hknight_reg9	] {};			/// Regeneration
+void() hknight_reg9	=[	$death4,	hknight_reg10	] {};			/// Regeneration
+void() hknight_reg10	=[	$death3,	hknight_reg11	] {};			/// Regeneration
+void() hknight_reg11	=[	$death2,	hknight_reg12	] {ai_back(8);};	/// Regeneration
+void() hknight_reg12	=[	$death1,	hknight_run1	] {ai_back(10);};	/// Regeneration
 
 void()	hknight_dieb1	=[	$deathb1,	hknight_dieb2	] {};
 void()	hknight_dieb2	=[	$deathb2,	hknight_dieb3	] {};
@@ -195,18 +218,26 @@
 void()	hknight_dieb6	=[	$deathb6,	hknight_dieb7	] {};
 void()	hknight_dieb7	=[	$deathb7,	hknight_dieb8	] {};
 void()	hknight_dieb8	=[	$deathb8,	hknight_dieb9	] {};
-void()	hknight_dieb9	=[	$deathb9,	hknight_dieb9	] {};
+void()	hknight_dieb9	=[	$deathb9,	hknight_regb1	]		/// Regeneration
+{													/// Regeneration
+	RegenMonster(hknight_dieb9, 250);							/// Regeneration
+};													/// Regeneration
+void() hknight_regb1	=[	$deathb9,	hknight_regb2	] {};			/// Regeneration
+void() hknight_regb2	=[	$deathb8,	hknight_regb3	] {};			/// Regeneration
+void() hknight_regb3	=[	$deathb7,	hknight_regb4	] {};			/// Regeneration
+void() hknight_regb4	=[	$deathb6,	hknight_regb5	] {};			/// Regeneration
+void() hknight_regb5	=[	$deathb5,	hknight_regb6	] {};			/// Regeneration
+void() hknight_regb6	=[	$deathb4,	hknight_regb7	] {};			/// Regeneration
+void() hknight_regb7	=[	$deathb3,	hknight_regb8	] {};			/// Regeneration
+void() hknight_regb8	=[	$deathb2,	hknight_regb9	] {};			/// Regeneration
+void() hknight_regb9	=[	$deathb1,	hknight_run1	] {};			/// Regeneration
 
 void() hknight_die =
 {
 // check for gib
 	if (self.health < -40)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_hellkn.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		GibMonster ("progs/h_hellkn.mdl");						/// Lord Smagol
 		return;
 	}
 
@@ -216,6 +247,8 @@
 		hknight_die1 ();
 	else
 		hknight_dieb1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 
@@ -398,7 +431,7 @@
 */
 void() monster_hell_knight =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/items.qc .\QC/items.qc
--- ..\v106qc/items.qc	Mon Jul 21 23:06:08 1997
+++ .\QC/items.qc	Fri Oct 24 21:37:38 1997
@@ -5,6 +5,9 @@
 
 void() SUB_regen =
 {
+	if (On(SHUFFLE))										/// Shuffle Items
+		ShuffleItem();									/// Shuffle Items
+
 	self.model = self.mdl;		// restore original model
 	self.solid = SOLID_TRIGGER;	// allow it to be touched again
 	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
@@ -52,6 +55,11 @@
 		remove(self);
 		return;
 	}
+	if (self.cnt)										/// Object Removal
+	{												/// Object Removal
+		self.model = "";									/// Object Removal
+		self.solid = SOLID_NOT;								/// Object Removal
+	}												/// Object Removal
 };
 
 /*
@@ -122,6 +130,7 @@
 		self.noise = "items/r_item1.wav";
 		self.healamount = 15;
 		self.healtype = 0;
+		Removable (HEALTH, "Health");							/// Object Removal
 	}
 	else
 	if (self.spawnflags & H_MEGA)
@@ -132,6 +141,7 @@
 		self.noise = "items/r_item2.wav";
 		self.healamount = 100;
 		self.healtype = 2;
+		Removable (MEGA, "MegaHealth");						/// Object Removal
 	}
 	else
 	{
@@ -141,6 +151,7 @@
 		self.noise = "items/health1.wav";
 		self.healamount = 25;
 		self.healtype = 1;
+		Removable (HEALTH, "Health");							/// Object Removal
 	}
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
@@ -154,7 +165,9 @@
 	
 	if (other.classname != "player")
 		return;
-	
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
+
 	if (self.healtype == 2) // Megahealth?  Ignore max_health...
 	{
 		if (other.health >= 250)
@@ -199,6 +212,9 @@
 		}
 	}
 	
+	if (deathmatch == 3)									/// Deathmatch 3
+		self.nextthink = time + 20;							/// Deathmatch 3
+
 	activator = other;
 	SUB_UseTargets();				// fire all targets / killtargets
 };	
@@ -218,7 +234,7 @@
 // just blindly subtract the flag off
 	other.items = other.items - (other.items & IT_SUPERHEALTH);
 	
-	if (deathmatch == 1)	// deathmatch 2 is silly old rules
+	if (deathmatch == 1 || deathmatch == 3)						/// Deathmatch 3
 	{
 		self.nextthink = time + 20;
 		self.think = SUB_regen;
@@ -243,6 +259,8 @@
 		return;
 	if (other.classname != "player")
 		return;
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
 
 	if (self.classname == "item_armor1")
 	{
@@ -273,6 +291,9 @@
 	self.model = string_null;
 	if (deathmatch == 1)
 		self.nextthink = time + 20;
+	else if (deathmatch == 3)								/// Deathmatch 3
+		self.nextthink = time + 40;							/// Deathmatch 3
+
 	self.think = SUB_regen;
 
 	sprint(other, "You got armor\n");
@@ -295,6 +316,7 @@
 	setmodel (self, "progs/armor.mdl");
 	self.skin = 0;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (ARMOR1, "Green Armor");							/// Object Removal
 	StartItem ();
 };
 
@@ -308,6 +330,7 @@
 	setmodel (self, "progs/armor.mdl");
 	self.skin = 1;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (ARMOR2, "Yellow Armor");							/// Object Removal
 	StartItem ();
 };
 
@@ -321,6 +344,7 @@
 	setmodel (self, "progs/armor.mdl");
 	self.skin = 2;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (ARMOR3, "Red Armor");							/// Object Removal
 	StartItem ();
 };
 
@@ -397,6 +421,8 @@
 
 	if (!(other.flags & FL_CLIENT))
 		return;
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
 
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
@@ -404,7 +430,7 @@
 	best = W_BestWeapon();
 	self = stemp;
 
-	if (deathmatch == 2 || coop)
+	if (deathmatch == 2 || coop || deathmatch == 3)					/// Deathmatch 3
 		leave = 1;
 	else
 		leave = 0;
@@ -491,8 +517,9 @@
 // remove it in single player, or setup for respawning in deathmatch
 	self.model = string_null;
 	self.solid = SOLID_NOT;
-	if (deathmatch == 1)
+	if (deathmatch && deathmatch != 2)						/// Deathmatch 3
 		self.nextthink = time + 30;
+
 	self.think = SUB_regen;
 	
 	activator = other;
@@ -511,6 +538,7 @@
 	self.netname = "Double-barrelled Shotgun";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (SSG, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -525,6 +553,7 @@
 	self.netname = "nailgun";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (NG, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -539,6 +568,7 @@
 	self.netname = "Super Nailgun";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (SNG, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -553,6 +583,7 @@
 	self.netname = "Grenade Launcher";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (GL, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -567,6 +598,7 @@
 	self.netname = "Rocket Launcher";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (RL, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -582,6 +614,7 @@
 	self.netname = "Thunderbolt";
 	self.touch = weapon_touch;
 	setsize (self, '-16 -16 0', '16 16 56');
+	Removable (LG, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -603,6 +636,8 @@
 		return;
 	if (other.health <= 0)
 		return;
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
 
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
@@ -672,8 +707,9 @@
 // remove it in single player, or setup for respawning in deathmatch
 	self.model = string_null;
 	self.solid = SOLID_NOT;
-	if (deathmatch == 1)
+	if (deathmatch == 1 || deathmatch == 3)						/// Deathmatch 3
 		self.nextthink = time + 30;
+
 	self.think = SUB_regen;
 
 	activator = other;
@@ -707,6 +743,7 @@
 	self.weapon = 1;
 	self.netname = "shells";
 	setsize (self, '0 0 0', '32 32 56');
+	Removable (SHELLS, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -732,6 +769,7 @@
 	self.weapon = 2;
 	self.netname = "nails";
 	setsize (self, '0 0 0', '32 32 56');
+	Removable (NAILS, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -757,6 +795,7 @@
 	self.weapon = 3;
 	self.netname = "rockets";
 	setsize (self, '0 0 0', '32 32 56');
+	Removable (ROCKETS, "");								/// Object Removal
 	StartItem ();
 };
 
@@ -783,6 +822,7 @@
 	self.weapon = 4;
 	self.netname = "cells";
 	setsize (self, '0 0 0', '32 32 56');
+	Removable (CELLS, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -815,6 +855,7 @@
 		}
 		self.weapon = 1;
 		self.netname = "shells";
+		Removable (SHELLS, "");								/// Object Removal
 	}
 
 	if (self.spawnflags & WEAPON_SPIKES)
@@ -833,6 +874,7 @@
 		}
 		self.weapon = 2;
 		self.netname = "spikes";
+		Removable (NAILS, "");								/// Object Removal
 	}
 
 	if (self.spawnflags & WEAPON_ROCKET)
@@ -851,6 +893,7 @@
 		}
 		self.weapon = 3;
 		self.netname = "rockets";
+		Removable (ROCKETS, "");							/// Object Removal
 	}
 	
 	setsize (self, '0 0 0', '32 32 56');
@@ -877,6 +920,8 @@
 		return;
 	if (other.items & self.items)
 		return;
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
 
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
@@ -1011,6 +1056,8 @@
 		return;
 	if (other.health <= 0)
 		return;
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
 
 	centerprint (other, "You got the rune!");
 
@@ -1084,6 +1131,8 @@
 		return;
 	if (other.health <= 0)
 		return;
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
 
 	sprint (other, "You got the ");
 	sprint (other, self.netname);
@@ -1095,9 +1144,19 @@
 		
 		if ((self.classname == "item_artifact_invulnerability") ||
 			(self.classname == "item_artifact_invisibility"))
-			self.nextthink = time + 60*5;
+		{
+			if (deathmatch == 3)							/// Deathmatch 3
+				self.nextthink = time + 60*8;					/// Deathmatch 3
+			else										/// Deathmatch 3
+				self.nextthink = time + 60*5;
+		}
 		else
-			self.nextthink = time + 60;
+		{
+			if (deathmatch == 3)							/// Deathmatch 3
+				self.nextthink = time + 100;					/// Deathmatch 3
+			else										/// Deathmatch 3
+				self.nextthink = time + 60;
+		}
 		
 		self.think = SUB_regen;
 	}	
@@ -1105,34 +1164,47 @@
 	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
 	self.solid = SOLID_NOT;
-	other.items = other.items | self.items;
 	self.model = string_null;
 
 // do the apropriate action
-	if (self.classname == "item_artifact_envirosuit")
+	if (self.items == IT_SUIT)			// Got to be faster :)		/// Lord Smagol
 	{
 		other.rad_time = 1;
-		other.radsuit_finished = time + 30;
+		if (deathmatch && (other.items & IT_SUIT))				/// Drop Powerups
+			other.radsuit_finished = other.radsuit_finished + 30;		/// Drop Powerups
+		else											/// Drop Powerups
+			other.radsuit_finished = time + 30;
 	}
 	
-	if (self.classname == "item_artifact_invulnerability")
+	if (self.items == IT_INVULNERABILITY)	// Got to be faster :)		/// Lord Smagol
 	{
 		other.invincible_time = 1;
-		other.invincible_finished = time + 30;
+		if (deathmatch && (other.items & IT_INVULNERABILITY))			/// Drop Powerups
+			other.invincible_finished = other.invincible_finished + 30;	/// Drop Powerups
+		else											/// Drop Powerups
+			other.invincible_finished = time + 30;
 	}
 	
-	if (self.classname == "item_artifact_invisibility")
+	if (self.items == IT_INVISIBILITY)		// Got to be faster :)		/// Lord Smagol
 	{
 		other.invisible_time = 1;
-		other.invisible_finished = time + 30;
+		if (deathmatch && (other.items & IT_INVISIBILITY))			/// Drop Powerups
+			other.invisible_finished = other.invisible_finished + 30;	/// Drop Powerups
+		else											/// Drop Powerups
+			other.invisible_finished = time + 30;
 	}
 
-	if (self.classname == "item_artifact_super_damage")
+	if (self.items == IT_QUAD)			// Got to be faster :)		/// Lord Smagol
 	{
 		other.super_time = 1;
-		other.super_damage_finished = time + 30;
+		if (deathmatch && (other.items & IT_QUAD))				/// Drop Powerups
+			other.super_damage_finished=other.super_damage_finished+30;	/// Drop Powerups
+		else											/// Drop Powerups
+			other.super_damage_finished = time + 30;
 	}	
 
+	other.items = other.items | self.items;	// Moved it to here		/// Drop Powerups
+
 	activator = other;
 	SUB_UseTargets();				// fire all targets / killtargets
 };
@@ -1155,6 +1227,7 @@
 	self.netname = "Pentagram of Protection";
 	self.items = IT_INVULNERABILITY;
 	setsize (self, '-16 -16 -24', '16 16 32');
+	Removable (PENT, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -1193,6 +1266,7 @@
 	self.netname = "Ring of Shadows";
 	self.items = IT_INVISIBILITY;
 	setsize (self, '-16 -16 -24', '16 16 32');
+	Removable (RING, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -1213,6 +1287,7 @@
 	self.netname = "Quad Damage";
 	self.items = IT_QUAD;
 	setsize (self, '-16 -16 -24', '16 16 32');
+	Removable (QUAD, "");									/// Object Removal
 	StartItem ();
 };
 
@@ -1237,6 +1312,8 @@
 		return;
 	if (other.health <= 0)
 		return;
+	if (battle < BATTLE_OFF || other.wait)						/// Battle
+		return;										/// Battle
 
 	acount = 0;
 	sprint (other, "You get ");
@@ -1337,6 +1414,7 @@
 		return;	// nothing in it
 
 	item = spawn();
+	item.classname = "dropped_stuff";							/// Object Removal
 	item.origin = self.origin - '0 0 24';
 	
 	item.items = self.weapon;
diff -ur --new-file ..\v106qc/knight.qc .\QC/knight.qc
--- ..\v106qc/knight.qc	Mon Jul 21 23:06:08 1997
+++ .\QC/knight.qc	Fri Oct 24 21:37:38 1997
@@ -193,8 +193,20 @@
 void()	knight_die7	=[	$death7,	knight_die8	] {};
 void()	knight_die8	=[	$death8,	knight_die9	] {};
 void()	knight_die9	=[	$death9,	knight_die10] {};
-void()	knight_die10=[	$death10,	knight_die10] {};
-
+void()	knight_die10=[	$death10,	knight_reg1]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(knight_die10, 75);							/// Regeneration
+};													/// Regeneration
+void()	knight_reg1	=[	$death10,	knight_reg2	] {};				/// Regeneration
+void()	knight_reg2	=[	$death9,	knight_reg3	] {};				/// Regeneration
+void()	knight_reg3	=[	$death8,	knight_reg4	] {};				/// Regeneration
+void()	knight_reg4	=[	$death7,	knight_reg5	] {};				/// Regeneration
+void()	knight_reg5	=[	$death6,	knight_reg6	] {};				/// Regeneration
+void()	knight_reg6	=[	$death5,	knight_reg7	] {};				/// Regeneration
+void()	knight_reg7	=[	$death4,	knight_reg8	] {};				/// Regeneration
+void()	knight_reg8	=[	$death3,	knight_reg9	] {};				/// Regeneration
+void()	knight_reg9	=[	$death2,	knight_reg10] {};				/// Regeneration
+void()	knight_reg10=[	$death1,	knight_run1]  {};				/// Regeneration
 
 void()	knight_dieb1	=[	$deathb1,	knight_dieb2	] {};
 void()	knight_dieb2	=[	$deathb2,	knight_dieb3	] {};
@@ -207,19 +219,28 @@
 void()	knight_dieb8	=[	$deathb8,	knight_dieb9	] {};
 void()	knight_dieb9	=[	$deathb9,	knight_dieb10] {};
 void()	knight_dieb10 = [	$deathb10,	knight_dieb11] {};
-void()	knight_dieb11 = [	$deathb11,	knight_dieb11] {};
-
+void()	knight_dieb11 = [	$deathb11,	knight_regb1]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(knight_dieb11, 75);							/// Regeneration
+};													/// Regeneration
+void()	knight_regb1	=[	$deathb11,	knight_regb2	] {};		/// Regeneration
+void()	knight_regb2	=[	$deathb10,	knight_regb3	] {};		/// Regeneration
+void()	knight_regb3	=[	$deathb9,	knight_regb4	] {};		/// Regeneration
+void()	knight_regb4	=[	$deathb8,	knight_regb5	] {};		/// Regeneration
+void()	knight_regb5	=[	$deathb7,	knight_regb6	] {};		/// Regeneration
+void()	knight_regb6	=[	$deathb6,	knight_regb7	] {};		/// Regeneration
+void()	knight_regb7	=[	$deathb5,	knight_regb8	] {};		/// Regeneration
+void()	knight_regb8	=[	$deathb4,	knight_regb9	] {};		/// Regeneration
+void()	knight_regb9	=[	$deathb3,	knight_regb10	] {};		/// Regeneration
+void()	knight_regb10	=[	$deathb2,	knight_regb11	] {};		/// Regeneration
+void()	knight_regb11	=[	$deathb1,	knight_run1		] {};		/// Regeneration
 
 void() knight_die =
 {
 // check for gib
 	if (self.health < -40)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_knight.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		GibMonster ("progs/h_knight.mdl");						/// Lord Smagol
 		return;
 	}
 
@@ -229,6 +250,8 @@
 		knight_die1 ();
 	else
 		knight_dieb1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 
@@ -236,7 +259,7 @@
 */
 void() monster_knight =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/lord.qc .\QC/lord.qc
--- ..\v106qc/lord.qc	Thu Jan  1 00:00:00 1970
+++ .\QC/lord.qc	Fri Oct 24 22:18:38 1997
@@ -0,0 +1,186 @@
+float IM_READY    = 13;
+float IM_NREADY   = 14;
+float IM_JOIN     = 15;
+
+float IM_S0       = 16;
+float IM_S1       = 17;
+float IM_S2       = 18;
+float IM_S3       = 19;
+
+float IM_D1       = 20;
+float IM_D2       = 21;
+float IM_D3       = 22;
+float IM_D4       = 23;
+
+/*    DEVELOPER          */ float IM_SETTINGS  = 24;
+float MONSTERS    =      2; float IM_MONSTERS  = 25;
+float REGEN       =      4; float IM_REGEN     = 26;
+float DOGJUMP     =      8; float IM_DOGJUMP   = 27;
+float FIENDJUMP   =     16; float IM_FIENDJUMP = 28;
+float ENFSHOT     =     32; float IM_ENFSHOT   = 29;
+float DEATHSHOT   =     64; float IM_DEATHSHOT = 30;
+float OGRESHOT    =    128; float IM_OGRESHOT  = 31;
+float SCRAGSHOT   =    256; float IM_SCRAGSHOT = 32;
+float ZOMBIESHOT  =    512; float IM_ZOMBIESHOT= 33;
+// float          =   1024; float IM_          = 34;
+// float          =   2048; float IM_          = 35;
+// float          =   4096; float IM_          = 36;
+// float          =   8192; float IM_          = 37;
+// float          =  16384; float IM_          = 38;
+// float          =  32768; float IM_          = 39;
+// float          =  65536; float IM_          = 40;
+// float          = 131072; float IM_          = 41;
+// float          = 262144; float IM_          = 42;
+// float          = 524288; float IM_          = 43;
+// float          =1048576; float IM_          = 44;
+// float          =2097152; float IM_          = 45;
+// float          =4194304; float IM_          = 46;
+// float          =8388608; float IM_          = 47;
+
+/* TEMP1 */
+float SHELLS      =      1; float IM_SHELLS    = 48;
+float NAILS       =      2; float IM_NAILS     = 49;
+float ROCKETS     =      4; float IM_ROCKETS   = 50;
+float CELLS       =      8; float IM_CELLS     = 51;
+float SSG         =     16; float IM_SSG       = 52;
+float NG          =     32; float IM_NG        = 53;
+float SNG         =     64; float IM_SNG       = 54;
+float GL          =    128; float IM_GL        = 55;
+float RL          =    256; float IM_RL        = 56;
+float LG          =    512; float IM_LG        = 57;
+float HEALTH      =   1024; float IM_HEALTH    = 58;
+float MEGA        =   2048; float IM_MEGA      = 59;
+float ARMOR1      =   4096; float IM_ARMOR1    = 60;
+float ARMOR2      =   8192; float IM_ARMOR2    = 61;
+float ARMOR3      =  16384; float IM_ARMOR3    = 62;
+float PENT        =  32768; float IM_PENT      = 63;
+float QUAD        =  65536; float IM_QUAD      = 64;
+float RING        = 131072; float IM_RING      = 65;
+// float          = 262144; float IM_          = 66;
+// float          = 524288; float IM_          = 67;
+// float          =1048576; float IM_          = 68;
+// float          =2097152; float IM_          = 69;
+// float          =4194304; float IM_          = 70;
+// float          =8388608; float IM_          = 71;
+
+/*    REGISTERED         */ float IM_GOLLUM    = 72;
+float RESPAWNS    =      2; float IM_RESPAWNS  = 73;
+float SHUFFLE     =      4; float IM_SHUFFLE   = 74;
+float TELEPORT    =      8; float IM_TELEPORT  = 75;
+float DROPPENT    =     16; float IM_DROPPENT  = 76;
+float DROPQUAD    =     32; float IM_DROPQUAD  = 77;
+float DROPRING    =     64; float IM_DROPRING  = 78;
+float DROPSUIT    =    128; float IM_DROPSUIT  = 79;
+float DROPARMOR   =    256; float IM_DROPARMOR = 80;
+float DISCHARGE   =    512; float IM_DISCHARGE = 81;
+float BALANCE     =   1024; float IM_BALANCE   = 82;
+float THROWAMMO   =   2048; float IM_THROWAMMO = 83; float IM_THROW  = 238;
+float FLARES      =   4096; float IM_FLARES    = 84; float IM_FLARE  = 239;
+float TRACERS     =   8192; float IM_TRACERS   = 85; float IM_TRACER = 240;
+float HOMING      =  16384; float IM_HOMING    = 86; float IM_HOMER  = 241;
+float PROXBOMBS   =  32768; float IM_PROXBOMBS = 87; float IM_PROX   = 242;
+float TRIGBOMBS   =  65536; float IM_TRIGBOMBS = 88; float IM_TRIG   = 243; float IM_BLOW = 244;
+// float          = 131072; float IM_          = 89;
+// float          = 262144; float IM_          = 90;
+// float          = 524288; float IM_          = 91;
+// float          =1048576; float IM_          = 92;
+// float          =2097152; float IM_          = 93;
+float CAMPER      =4194304; float IM_CAMPER    = 94;
+float BATTLE      =8388608; float IM_BATTLE    = 95;
+
+float IM_FRAGP    = 96;
+float IM_FRAGM    = 97;
+
+float IM_TIMEP    = 98;
+float IM_TIMEM    = 99;
+
+float IM_E1M1    = 200;
+float IM_E1M2    = 201;
+float IM_E1M3    = 202;
+float IM_E1M4    = 203;
+float IM_E1M5    = 204;
+float IM_E1M6    = 205;
+float IM_E1M7    = 206;
+float IM_E1M8    = 207;
+
+float IM_E2M1    = 208;
+float IM_E2M2    = 209;
+float IM_E2M3    = 210;
+float IM_E2M4    = 211;
+float IM_E2M5    = 212;
+float IM_E2M6    = 213;
+float IM_E2M7    = 214;
+float IM_START   = 215;
+
+float IM_E3M1    = 216;
+float IM_E3M2    = 217;
+float IM_E3M3    = 218;
+float IM_E3M4    = 219;
+float IM_E3M5    = 220;
+float IM_E3M6    = 221;
+float IM_E3M7    = 222;
+float IM_END     = 223;
+
+float IM_E4M1    = 224;
+float IM_E4M2    = 225;
+float IM_E4M3    = 226;
+float IM_E4M4    = 227;
+float IM_E4M5    = 228;
+float IM_E4M6    = 229;
+float IM_E4M7    = 230;
+float IM_E4M8    = 231;
+
+float IM_DM1     = 232;
+float IM_DM2     = 233;
+float IM_DM3     = 234;
+float IM_DM4     = 235;
+float IM_DM5     = 236;
+float IM_DM6     = 237;
+
+void() Welcome;
+
+void() CacheExtraStuff;
+
+void() CheckExtraImpulses;
+
+void() DropPowerups;
+
+void() ShuffleItem;
+
+void (float bit, string thing) Removable;
+
+void (entity inflictor, entity attacker, float damage, entity ignore) T_RadiusDamageInWater;
+
+float(vector org, vector trg, vector launch, float limit) InRange;
+
+void (entity who) TellFrags;
+
+void (entity sounder, float chan, string wav, float vol, float attn) SoundQ =
+{
+	if (sounder.solid != SOLID_NOT)
+		sound (self, chan, wav, vol, attn);
+};
+
+float (float bit) Yes;
+float (float bit) No;
+float (float bit) On;
+
+void() NotCamping;
+
+float CAMP_SIZE = 160;
+float CAMP_MOVE = 5;
+float CAMP_FIRE = 3;
+float CAMP_BEEP = 30;
+
+entity battler;
+float battle;
+float BATTLE_WAITING = -2;
+float BATTLE_READY   = -1;
+float BATTLE_OFF     =  0;
+float BATTLE_RUNNING =  1;
+float BATTLE_BROKEN  =  2;
+
+float MONSTER_REGEN_TIME = 30;
+
+float SVC_UPDATESTAT = 3;
+float STAT_KILLEDMONSTERS = 14;
diff -ur --new-file ..\v106qc/misc.qc .\QC/misc.qc
--- ..\v106qc/misc.qc	Mon Jul 21 23:06:10 1997
+++ .\QC/misc.qc	Fri Oct 24 21:37:40 1997
@@ -176,7 +176,7 @@
 	self.nextthink = time + (random() * 5);
 	self.think = fire_fly;
 	if (!self.speed)
-		self.speed == 1000;
+		self.speed = 1000;								/// Typo fixed
 };
 
 void() fire_fly =
diff -ur --new-file ..\v106qc/monsters.qc .\QC/monsters.qc
--- ..\v106qc/monsters.qc	Mon Jul 21 23:06:12 1997
+++ .\QC/monsters.qc	Fri Oct 24 21:37:40 1997
@@ -115,7 +115,7 @@
 	}
 
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 };
 
 
@@ -123,7 +123,7 @@
 {
 // delay drop to floor to make sure all doors have been spawned
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 	self.think = walkmonster_start_go;
 	total_monsters = total_monsters + 1;
 };
@@ -171,12 +171,15 @@
 		self.pausetime = 99999999;
 		self.th_stand ();
 	}
+
+// spread think times so they don't all happen at same time				/// Statue Fix
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 };
 
 void() flymonster_start =
 {
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 	self.think = flymonster_start_go;
 	total_monsters = total_monsters + 1;
 };
@@ -191,7 +194,7 @@
 	}
 
 	self.takedamage = DAMAGE_AIM;
-	total_monsters = total_monsters + 1;
+//	total_monsters = total_monsters + 1;						/// Rotfish fix
 
 	self.ideal_yaw = self.angles * '0 1 0';
 	if (!self.yaw_speed)
@@ -222,13 +225,13 @@
 	}
 
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 };
 
 void() swimmonster_start =
 {
 // spread think times so they don't all happen at same time
-	self.nextthink = self.nextthink + random()*0.5;
+	self.nextthink = time + random()*0.5;						/// Statue Fix
 	self.think = swimmonster_start_go;
 	total_monsters = total_monsters + 1;
 };
diff -ur --new-file ..\v106qc/ogre.qc .\QC/ogre.qc
--- ..\v106qc/ogre.qc	Mon Jul 21 23:06:12 1997
+++ .\QC/ogre.qc	Fri Oct 24 21:37:40 1997
@@ -102,11 +102,16 @@
 		
 // set missile speed	
 
-	makevectors (self.angles);
+	if (Yes(OGRESHOT))									/// Ogre Shot
+		missile.velocity=Ballistic(self.origin,self.enemy.origin,'0 600 200');/// Ogre Shot
+	else												/// Ogre Shot
+	{
+		makevectors (self.angles);
 
-	missile.velocity = normalize(self.enemy.origin - self.origin);
-	missile.velocity = missile.velocity * 600;
-	missile.velocity_z = 200;
+		missile.velocity = normalize(self.enemy.origin - self.origin);
+		missile.velocity = missile.velocity * 600;
+		missile.velocity_z = 200;
+	}
 
 	missile.avelocity = '300 300 300';
 
@@ -366,7 +371,24 @@
 void()	ogre_die11	=[	$death11,	ogre_die12	] {};
 void()	ogre_die12	=[	$death12,	ogre_die13	] {};
 void()	ogre_die13	=[	$death13,	ogre_die14	] {};
-void()	ogre_die14	=[	$death14,	ogre_die14	] {};
+void()	ogre_die14	=[	$death14,	ogre_reg1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(ogre_die14, 200);							/// Regeneration
+};													/// Regeneration
+void()	ogre_reg1	=[	$death14,	ogre_reg2	] {};				/// Regeneration
+void()	ogre_reg2	=[	$death13,	ogre_reg3	] {};				/// Regeneration
+void()	ogre_reg3	=[	$death12,	ogre_reg4	] {};				/// Regeneration
+void()	ogre_reg4	=[	$death11,	ogre_reg5	] {};				/// Regeneration
+void()	ogre_reg5	=[	$death10,	ogre_reg6	] {};				/// Regeneration
+void()	ogre_reg6	=[	$death9,	ogre_reg7	] {};				/// Regeneration
+void()	ogre_reg7	=[	$death8,	ogre_reg8	] {};				/// Regeneration
+void()	ogre_reg8	=[	$death7,	ogre_reg9	] {};				/// Regeneration
+void()	ogre_reg9	=[	$death6,	ogre_reg10	] {};				/// Regeneration
+void()	ogre_reg10	=[	$death5,	ogre_reg11	] {};				/// Regeneration
+void()	ogre_reg11	=[	$death4,	ogre_reg12	] {};				/// Regeneration
+void()	ogre_reg12	=[	$death3,	ogre_reg13	] {};				/// Regeneration
+void()	ogre_reg13	=[	$death2,	ogre_reg14	] {};				/// Regeneration
+void()	ogre_reg14	=[	$death1,	ogre_run1	] {};				/// Regeneration
 
 void()	ogre_bdie1	=[	$bdeath1,	ogre_bdie2	] {};
 void()	ogre_bdie2	=[	$bdeath2,	ogre_bdie3	] {ai_forward(5);};
@@ -379,18 +401,27 @@
 void()	ogre_bdie7	=[	$bdeath7,	ogre_bdie8	] {ai_forward(25);};
 void()	ogre_bdie8	=[	$bdeath8,	ogre_bdie9	] {};
 void()	ogre_bdie9	=[	$bdeath9,	ogre_bdie10	] {};
-void()	ogre_bdie10	=[	$bdeath10,	ogre_bdie10	] {};
+void()	ogre_bdie10	=[	$bdeath10,	ogre_breg1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(ogre_bdie10, 200);							/// Regeneration
+};													/// Regeneration
+void()	ogre_breg1	=[	$bdeath10,	ogre_breg2	] {};				/// Regeneration
+void()	ogre_breg2	=[	$bdeath9,	ogre_breg3	] {};				/// Regeneration
+void()	ogre_breg3	=[	$bdeath8,	ogre_breg4	] {};				/// Regeneration
+void()	ogre_breg4	=[	$bdeath7,	ogre_breg5	] {ai_forward(-25);};	/// Regeneration
+void()	ogre_breg5	=[	$bdeath6,	ogre_breg6	] {ai_forward(-7);};	/// Regeneration
+void()	ogre_breg6	=[	$bdeath5,	ogre_breg7	] {ai_forward(-3);};	/// Regeneration
+void()	ogre_breg7	=[	$bdeath4,	ogre_breg8	] {ai_forward(-1);};	/// Regeneration
+void()	ogre_breg8	=[	$bdeath3,	ogre_breg9	] {};				/// Regeneration
+void()	ogre_breg9	=[	$bdeath2,	ogre_breg10	] {ai_forward(-5);};	/// Regeneration
+void()	ogre_breg10	=[	$bdeath1,	ogre_run1	] {};				/// Regeneration
 
 void() ogre_die =
 {
 // check for gib
 	if (self.health < -80)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_ogre.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		GibMonster ("progs/h_ogre.mdl");						/// Lord Smagol
 		return;
 	}
 
@@ -400,6 +431,8 @@
 		ogre_die1 ();
 	else
 		ogre_bdie1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 void() ogre_melee =
@@ -416,7 +449,7 @@
 */
 void() monster_ogre =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/oldone.qc .\QC/oldone.qc
--- ..\v106qc/oldone.qc	Mon Jul 21 23:06:12 1997
+++ .\QC/oldone.qc	Fri Oct 24 21:37:40 1997
@@ -187,6 +187,8 @@
 	local entity	n;
 
 	sound (self, CHAN_VOICE, "boss2/pop2.wav", 1, ATTN_NORM);
+	killed_monsters = killed_monsters + 1;						/// Shub Kill Fix
+	WriteByte (MSG_ALL, SVC_KILLEDMONSTER);						/// Shub Kill Fix
 	
 	oldo = self.origin;
 
@@ -251,7 +253,7 @@
 */
 void() monster_oldone =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/player.qc .\QC/player.qc
--- ..\v106qc/player.qc	Mon Jul 21 23:06:14 1997
+++ .\QC/player.qc	Fri Oct 24 21:37:40 1997
@@ -180,6 +180,7 @@
 	if (self.weaponframe == 9)
 		self.weaponframe = 1;
 	SuperDamageSound();
+	NotCamping();										/// Camper
 	W_FireSpikes (4);
 	self.attack_finished = time + 0.2;
 };
@@ -193,6 +194,7 @@
 	if (self.weaponframe == 9)
 		self.weaponframe = 1;
 	SuperDamageSound();
+	NotCamping();										/// Camper
 	W_FireSpikes (-4);
 	self.attack_finished = time + 0.2;
 };
@@ -209,6 +211,7 @@
 	if (self.weaponframe == 5)
 		self.weaponframe = 1;
 	SuperDamageSound();
+	NotCamping();										/// Camper
 	W_FireLightning();
 	self.attack_finished = time + 0.2;
 };
@@ -222,6 +225,7 @@
 	if (self.weaponframe == 5)
 		self.weaponframe = 1;
 	SuperDamageSound();
+	NotCamping();										/// Camper
 	W_FireLightning();
 	self.attack_finished = time + 0.2;
 };
@@ -256,9 +260,9 @@
 	{
 		DeathBubbles(1);
 		if (random() > 0.5)
-			sound (self, CHAN_VOICE, "player/drown1.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/drown1.wav", 1, ATTN_NORM);	/// Battle
 		else
-			sound (self, CHAN_VOICE, "player/drown2.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/drown2.wav", 1, ATTN_NORM);	/// Battle
 		return;
 	}
 
@@ -267,18 +271,18 @@
 	{
 // FIX ME	put in some steam here
 		if (random() > 0.5)
-			sound (self, CHAN_VOICE, "player/lburn1.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/lburn1.wav", 1, ATTN_NORM);	/// Battle
 		else
-			sound (self, CHAN_VOICE, "player/lburn2.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/lburn2.wav", 1, ATTN_NORM);	/// Battle
 		return;
 	}
 
 	if (self.watertype == CONTENT_LAVA)
 	{
 		if (random() > 0.5)
-			sound (self, CHAN_VOICE, "player/lburn1.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/lburn1.wav", 1, ATTN_NORM);	/// Battle
 		else
-			sound (self, CHAN_VOICE, "player/lburn2.wav", 1, ATTN_NORM);
+			SoundQ (self, CHAN_VOICE, "player/lburn2.wav", 1, ATTN_NORM);	/// Battle
 		return;
 	}
 
@@ -316,7 +320,7 @@
 	else
 		self.noise = "player/pain6.wav";
 
-	sound (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+	SoundQ (self, CHAN_VOICE, self.noise, 1, ATTN_NORM);				/// Battle
 	return;
 };
 
@@ -525,6 +529,12 @@
 {
 	local	float	i;
 	
+	if (deathmatch || coop)									/// Drop Powerups
+	{
+		DropBackpack();
+		DropPowerups();									/// Drop Powerups
+	}
+	self.wait = 0;										/// Camper
 	self.items = self.items - (self.items & IT_INVISIBILITY);
 	self.invisible_finished = 0;	// don't die as eyes
 	self.invincible_finished = 0;
@@ -532,9 +542,7 @@
 	self.radsuit_finished = 0;
 	self.modelindex = modelindex_player;	// don't use eyes
 
-	if (deathmatch || coop)
-		DropBackpack();
-	
+
 	self.weaponmodel="";
 	self.view_ofs = '0 0 -8';
 	self.deadflag = DEAD_DYING;
@@ -561,9 +569,9 @@
 		return;
 	}
 	
-	i = cvar("temp1");
-	if (!i)
-		i = 1 + floor(random()*6);
+//	i = cvar("temp1");									/// I NEED TEMP1
+//	if (!i)											/// I NEED TEMP1
+	i = 1 + floor(random()*6);
 	
 	if (i == 1)
 		player_diea1();
@@ -580,6 +588,9 @@
 
 void() set_suicide_frame =
 {	// used by klill command and diconnect command
+
+	DropPowerups();										/// Drop Powerups
+
 	if (self.model != "progs/player.mdl")
 		return;	// allready gibbed
 	self.frame = $deatha11;
diff -ur --new-file ..\v106qc/progs.src .\QC/progs.src
--- ..\v106qc/progs.src	Mon Jul 21 23:06:14 1997
+++ .\QC/progs.src	Fri Oct 24 21:37:40 1997
@@ -2,6 +2,9 @@
 
 defs.qc
 subs.qc
+
+lord.qc												/// Lord Smagol
+
 fight.qc
 ai.qc
 combat.qc
@@ -16,6 +19,8 @@
 triggers.qc
 plats.qc
 misc.qc
+
+smeagol.qc												/// Lord Smagol
 
 ogre.qc
 demon.qc
diff -ur --new-file ..\v106qc/shalrath.qc .\QC/shalrath.qc
--- ..\v106qc/shalrath.qc	Mon Jul 21 23:06:16 1997
+++ .\QC/shalrath.qc	Fri Oct 24 21:37:40 1997
@@ -84,8 +84,17 @@
 void() shal_death4      =[      $death4,        shal_death5     ] {};
 void() shal_death5      =[      $death5,        shal_death6     ] {};
 void() shal_death6      =[      $death6,        shal_death7     ] {};
-void() shal_death7      =[      $death7,        shal_death7    ] {};
-
+void() shal_death7      =[      $death7,        shal_reg1       ]			/// Regeneration
+{													/// Regeneration
+	RegenMonster(shal_death7, 400);							/// Regeneration
+};													/// Regeneration
+void() shal_reg1      =[      $death7,        shal_reg2     ] {};			/// Regeneration
+void() shal_reg2      =[      $death6,        shal_reg3     ] {};			/// Regeneration
+void() shal_reg3      =[      $death5,        shal_reg4     ] {};			/// Regeneration
+void() shal_reg4      =[      $death4,        shal_reg5     ] {};			/// Regeneration
+void() shal_reg5      =[      $death3,        shal_reg6     ] {};			/// Regeneration
+void() shal_reg6      =[      $death2,        shal_reg7     ] {};			/// Regeneration
+void() shal_reg7      =[      $death1,        shal_run1     ] {};			/// Regeneration
 
 void() shalrath_pain =
 {
@@ -102,11 +111,7 @@
 // check for gib
 	if (self.health < -90)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_shal.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		GibMonster ("progs/h_shal.mdl");						/// Lord Smagol
 		return;
 	}
 
@@ -114,6 +119,8 @@
 	shal_death1();
 	self.solid = SOLID_NOT;
 	// insert death sounds here
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 /*
@@ -203,7 +210,7 @@
 */
 void() monster_shalrath =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/shambler.qc .\QC/shambler.qc
--- ..\v106qc/shambler.qc	Mon Jul 21 23:06:16 1997
+++ .\QC/shambler.qc	Fri Oct 24 21:37:42 1997
@@ -301,24 +301,36 @@
 void() sham_death8      =[      $death8,       sham_death9     ] {};
 void() sham_death9      =[      $death9,       sham_death10    ] {};
 void() sham_death10     =[      $death10,      sham_death11    ] {};
-void() sham_death11     =[      $death11,      sham_death11    ] {};
+void() sham_death11     =[      $death11,      sham_reg1       ]			/// Regeneration
+{													/// Regeneration
+	RegenMonster(sham_death11, 600);							/// Regeneration
+};													/// Regeneration
+void() sham_reg1	=[	$death11,	sham_reg2	] {};					/// Regeneration
+void() sham_reg2	=[	$death10,	sham_reg3	] {};					/// Regeneration
+void() sham_reg3	=[	$death9,	sham_reg4	] {};					/// Regeneration
+void() sham_reg4	=[	$death8,	sham_reg5	] {};					/// Regeneration
+void() sham_reg5	=[	$death7,	sham_reg6	] {};					/// Regeneration
+void() sham_reg6	=[	$death6,	sham_reg7	] {};					/// Regeneration
+void() sham_reg7	=[	$death5,	sham_reg8	] {};					/// Regeneration
+void() sham_reg8	=[	$death4,	sham_reg9	] {};					/// Regeneration
+void() sham_reg9	=[	$death3,	sham_reg10	] {};					/// Regeneration
+void() sham_reg10	=[	$death2,	sham_reg11	] {};					/// Regeneration
+void() sham_reg11	=[	$death1,	sham_run1	] {};					/// Regeneration
 
 void() sham_die =
 {
 // check for gib
 	if (self.health < -60)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_shams.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		GibMonster ("progs/h_shams.mdl");						/// Lord Smagol
 		return;
 	}
 
 // regular death
 	sound (self, CHAN_VOICE, "shambler/sdeath.wav", 1, ATTN_NORM);
 	sham_death1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 //============================================================================
@@ -328,7 +340,7 @@
 */
 void() monster_shambler =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/smeagol.qc .\QC/smeagol.qc
--- ..\v106qc/smeagol.qc	Thu Jan  1 00:00:00 1970
+++ .\QC/smeagol.qc	Fri Oct 24 22:22:02 1997
@@ -0,0 +1,2190 @@
+		////////////////////////////////////////////
+		//							//
+		//	Lord Smagol's Battler	v 1.0		//
+		//							//
+		//		Release: ??-???-??		//
+		//							//
+		//	Carl.Lloyd-Parker@BigFoot.com		//
+		//							//
+		////////////////////////////////////////////
+
+float (float x, float y) Min =
+{
+	if (x < y)
+		return x;
+
+	return y;
+};
+
+float (float x, float y) Max =
+{
+	if (x > y)
+		return x;
+
+	return y;
+};
+
+void(string headmdl) GibMonster =
+{
+	sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
+	ThrowHead (headmdl, self.health);
+	ThrowGib ("progs/gib1.mdl", self.health);
+	ThrowGib ("progs/gib2.mdl", self.health);
+	ThrowGib ("progs/gib3.mdl", self.health);
+};
+	
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Cache Sounds and Models								//
+
+void() CacheExtraStuff =
+{
+	precache_sound ("shambler/smack.wav");	// Axe
+
+	precache_model ("progs/laser.mdl");		// Flares
+
+	precache_model ("progs/v_spike.mdl");	// Tracer
+
+	precache_model ("progs/armor.mdl");		// Deathmatch 4, Battle, ThrowAmmo
+	precache_model ("progs/g_shot.mdl");	// Deathmatch 4, Battle, ThrowAmmo
+	precache_model ("progs/g_nail.mdl");	// Deathmatch 4, Battle, ThrowAmmo
+	precache_model ("progs/g_nail2.mdl");	// Deathmatch 4, Battle, ThrowAmmo
+	precache_model ("progs/g_rock.mdl");	// Deathmatch 4, Battle, ThrowAmmo
+	precache_model ("progs/g_rock2.mdl");	// Deathmatch 4, Battle, ThrowAmmo
+	precache_model ("progs/g_light.mdl");	// Deathmatch 4, Battle, ThrowAmmo
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Aliases										//
+
+void(string text, float number) StuffAlias =
+{
+	local string temp;
+
+	temp = ftos(number);
+	stuffcmd (msg_entity, "alias ");
+	stuffcmd (msg_entity, text);
+	stuffcmd (msg_entity, " \"impulse ");
+	stuffcmd (msg_entity, temp);
+	stuffcmd (msg_entity, "\"\n");
+};
+
+void(entity client) StuffAliases =
+{
+	local float e, m;
+	local string temp;
+
+	client.items = client.items | IT_ALIAS;
+	msg_entity = client;
+
+	StuffAlias("Settings",  IM_SETTINGS);
+	StuffAlias("Monsters",  IM_MONSTERS);
+	StuffAlias("Regen",     IM_REGEN);
+	StuffAlias("DogJump",   IM_DOGJUMP);
+	StuffAlias("FiendJump", IM_FIENDJUMP);
+	StuffAlias("EnfShot",   IM_ENFSHOT);
+	StuffAlias("DeathShot", IM_DEATHSHOT);
+	StuffAlias("OgreShot",  IM_OGRESHOT);
+	StuffAlias("ScragShot", IM_SCRAGSHOT);
+	StuffAlias("ZombieShot",IM_ZOMBIESHOT);
+
+	StuffAlias("NoShells",  IM_SHELLS);
+	StuffAlias("NoNails",   IM_NAILS);
+	StuffAlias("NoRockets", IM_ROCKETS);
+	StuffAlias("NoCells",   IM_CELLS);
+	StuffAlias("NoSSG",     IM_SSG);
+	StuffAlias("NoNG",      IM_NG);
+	StuffAlias("NoSNG",     IM_SNG);
+	StuffAlias("NoGL",      IM_GL);
+	StuffAlias("NoRL",      IM_RL);
+	StuffAlias("NoLG",      IM_LG);
+	StuffAlias("NoHealth",  IM_HEALTH);
+	StuffAlias("NoMega",    IM_MEGA);
+	StuffAlias("NoArmorG",  IM_ARMOR1);
+	StuffAlias("NoArmorY",  IM_ARMOR2);
+	StuffAlias("NoArmorR",  IM_ARMOR3);
+	StuffAlias("NoPent",    IM_PENT);
+	StuffAlias("NoQuad",    IM_QUAD);
+	StuffAlias("NoRing",    IM_RING);
+
+	StuffAlias("Gollum",    IM_GOLLUM);
+	StuffAlias("Respawns",  IM_RESPAWNS);
+	StuffAlias("Shuffle",   IM_SHUFFLE);
+	StuffAlias("Teleport",  IM_TELEPORT);
+	StuffAlias("DropPent",  IM_DROPPENT);
+	StuffAlias("DropQuad",  IM_DROPQUAD);
+	StuffAlias("DropRing",  IM_DROPRING);
+	StuffAlias("DropSuit",  IM_DROPSUIT);
+	StuffAlias("DropArmor", IM_DROPARMOR);
+	StuffAlias("Discharge", IM_DISCHARGE);
+	StuffAlias("Balance",   IM_BALANCE);
+	StuffAlias("ThrowAmmo", IM_THROWAMMO);
+	StuffAlias("Throw",     IM_THROW);
+	StuffAlias("Flares",    IM_FLARES);
+	StuffAlias("Flare",     IM_FLARE);
+	StuffAlias("Tracers",   IM_TRACERS);
+	StuffAlias("Tracer",    IM_TRACER);
+	StuffAlias("Homing",    IM_HOMING);
+	StuffAlias("Homer",     IM_HOMER);
+	StuffAlias("ProxBombs", IM_PROXBOMBS);
+	StuffAlias("Proximity", IM_PROX);
+	StuffAlias("TrigBombs", IM_TRIGBOMBS);
+	StuffAlias("Trigger",   IM_TRIG);
+	StuffAlias("Detonate",  IM_BLOW);
+	StuffAlias("Camper",    IM_CAMPER);
+	StuffAlias("Battle",    IM_BATTLE);
+	StuffAlias("Ready",     IM_READY);
+	StuffAlias("NotReady",  IM_NREADY);
+	StuffAlias("Join",      IM_JOIN);
+
+	StuffAlias("Frag+",     IM_FRAGP);
+	StuffAlias("Frag-",     IM_FRAGM);
+	StuffAlias("Time+",     IM_TIMEP);
+	StuffAlias("Time-",     IM_TIMEM);
+
+	StuffAlias("D1",        IM_D1);
+	StuffAlias("D2",        IM_D2);
+	StuffAlias("D3",        IM_D3);
+	StuffAlias("D4",        IM_D4);
+
+	StuffAlias("S0",        IM_S0);
+	StuffAlias("S1",        IM_S1);
+	StuffAlias("S2",        IM_S2);
+	StuffAlias("S3",        IM_S3);
+
+	StuffAlias("START",     IM_START);
+	StuffAlias("END",       IM_END);
+	StuffAlias("DM1",       IM_DM1);
+	StuffAlias("DM2",       IM_DM2);
+	StuffAlias("DM3",       IM_DM3);
+	StuffAlias("DM4",       IM_DM4);
+	StuffAlias("DM5",       IM_DM5);
+	StuffAlias("DM6",       IM_DM6);
+	e = 1;
+	while (e <= 4)
+	{
+		m = 1;
+		while (!(e & 2) && m == 8 || m <= 7)
+		{
+			stuffcmd (msg_entity, "alias E");
+			temp = ftos(e);
+			stuffcmd (msg_entity, temp);
+			stuffcmd (msg_entity, "M");
+			temp = ftos(m);
+			stuffcmd (msg_entity, temp);
+			stuffcmd (msg_entity, " \"impulse ");
+			temp = ftos( (e - 1) * 8 + m - 1 + IM_E1M1);
+			stuffcmd (msg_entity, temp);
+			stuffcmd (msg_entity, "\"\n");
+			m = m + 1;
+		}
+		e = e + 1;
+	}
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Client Connect Message								//
+
+void() WelcomeThinks =
+{
+	if (!(self.owner.items & IT_ALIAS))
+		StuffAliases (self.owner);
+
+	if (deathmatch)
+		centerprint2 (self.owner, "  \n\n\n\nType  at the console", self.message);
+
+	self.cnt = self.cnt - 1;
+	if (!self.cnt)
+		remove(self);
+	else
+		self.nextthink = time + 1;
+};
+
+void() WelcomeThink =
+{
+	stuffcmd (self.owner, "Gollum\n");
+	self.owner.cnt = cvar("temp1");
+	self.owner.state = cvar("registered");
+	self.owner.height = cvar("developer");
+	self.think = WelcomeThinks;
+	self.nextthink = time + 0.5;
+};
+
+void() Welcome =
+{
+	local entity welcome, p;
+
+	welcome = spawn();
+	welcome.classname = "welcome";
+	welcome.owner = self;
+	welcome.cnt = 3;
+	if (battle == BATTLE_RUNNING)
+	{
+		p = find(world, classname, "player");
+		while (p != world)
+		{
+			if (p != self)
+				centerprint3 (p, "Type  to allow ", self.netname, " to battle");
+
+			p = find(p, classname, "player");
+		}
+		welcome.message = "\n\nYou are an invisible observer";
+		welcome.cnt = 5;
+	}
+	welcome.think = WelcomeThink;
+	welcome.nextthink = time + 0.5;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Remove Items (health, ammo, weapons, armor, powerups)			//
+
+void (float bit, string thing) Removable =
+{
+	if (thing != "")
+		self.netname = thing;
+
+	if (No(bit))
+		self.cnt = 1;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Item Shuffling (health, ammo, weapons, armor, powerups)		//
+
+void () ShuffleItem =
+{
+	local float latest_time;
+	local entity p, item;
+	local vector temp_origin;
+
+	latest_time = 999999;
+	p = nextent (world);
+	while (p != world)
+	{
+		if (p.think == SUB_regen)
+		{
+			if (p.solid == SOLID_NOT)
+			{
+				if (p.nextthink && p.nextthink < latest_time)
+				{
+					latest_time = p.nextthink;
+					item = p;
+				}
+			}
+		}
+		p = nextent (p);
+	}
+	if (latest_time < 999999)
+	{
+		temp_origin = self.origin;
+		setorigin (self, item.origin);
+		setorigin (item, temp_origin);
+	}
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Drop Pentagram / Quad / Ring / Biosuit					//
+
+void() GetUsedItem =
+{
+	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
+	other.items = other.items | self.items;
+	stuffcmd (other, "bf\n");
+	sprint3 (other, "You got the ", self.netname, "\n");
+	remove(self);
+};
+
+void() UsedPentTouch =
+{
+	if (other.classname != "player" || other.health <= 0 || other.wait)
+		return;
+
+	if (other.items & IT_INVULNERABILITY)
+		other.invincible_finished = other.invincible_finished + self.invincible_finished;
+	else
+		other.invincible_finished = time + self.invincible_finished;
+
+	other.invincible_time = 1;
+	GetUsedItem();
+};
+
+void() UsedQuadTouch =
+{
+	if (other.classname != "player" || other.health <= 0 || other.wait)
+		return;
+
+	if (other.items & IT_QUAD)
+		other.super_damage_finished=other.super_damage_finished+self.super_damage_finished;
+	else
+		other.super_damage_finished = time + self.super_damage_finished;
+
+	other.super_time = 1;
+	GetUsedItem();
+};
+
+void() UsedRingTouch =
+{
+	if (other.classname != "player" || other.health <= 0 || other.wait)
+		return;
+
+	if (other.items & IT_INVISIBILITY)
+		other.invisible_finished = other.invisible_finished + self.invisible_finished;
+	else
+		other.invisible_finished = time + self.invisible_finished;
+
+	other.invisible_time = 1;
+	GetUsedItem();
+};
+
+void() UsedSuitTouch =
+{
+	if (other.classname != "player" || other.health <= 0 || other.wait)
+		return;
+
+	if (other.items & IT_SUIT)
+		other.radsuit_finished = other.radsuit_finished + self.radsuit_finished;
+	else
+		other.radsuit_finished = time + self.radsuit_finished;
+
+	other.rad_time = 1;
+	GetUsedItem();
+};
+
+void() UsedArmorTouch =
+{
+	if (other.classname != "player" || other.health <= 0 || other.wait)
+		return;
+
+	if (other.armortype*other.armorvalue >= self.armortype*self.armorvalue)
+		return;
+
+	other.items = other.items - (other.items & (IT_ARMOR1+IT_ARMOR2+IT_ARMOR3)) + self.items;
+	other.armortype = self.armortype;
+	other.armorvalue = self.armorvalue;
+	GetUsedItem();
+};
+
+entity(float thing, string modl) DropPowerup =
+{
+	local entity powerup;
+
+	powerup = spawn();
+	powerup.classname = "dropped_stuff";
+	powerup.items = thing;
+	self.items = self.items - (self.items & thing);
+	powerup.flags = FL_ITEM;
+	powerup.movetype = MOVETYPE_TOSS;
+	powerup.solid = SOLID_TRIGGER;
+	setmodel (powerup, modl);
+	setsize (powerup, '-16 -16 0', '16 16 56');
+	setorigin (powerup, self.origin - '0 0 24');
+	powerup.velocity_x = random() * 200 - 100;
+	powerup.velocity_y = random() * 200 - 100;
+	powerup.velocity_z = 300;
+	return powerup;
+};
+
+void() DropPent =
+{
+	local entity powerup;
+
+	powerup = DropPowerup(IT_INVULNERABILITY, "progs/invulner.mdl");
+	powerup.netname = "Pentagram of Protection";
+	powerup.noise = "items/protect.wav";
+	powerup.touch = UsedPentTouch;
+	powerup.invincible_finished = self.invincible_finished - time;
+	self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+	self.invincible_time = 0;
+	self.invincible_finished = 0;
+};
+
+void() DropQuad =
+{
+	local entity powerup;
+
+	powerup = DropPowerup(IT_QUAD, "progs/quaddama.mdl");
+	powerup.netname = "Quad Damage";
+	powerup.noise = "items/damage.wav";
+	powerup.touch = UsedQuadTouch;
+	powerup.super_damage_finished = self.super_damage_finished - time;
+	self.effects = self.effects - (self.effects & EF_DIMLIGHT);
+	self.super_time = 0;
+	self.super_damage_finished = 0;
+};
+
+void() DropRing =
+{
+	local entity powerup;
+
+	powerup = DropPowerup(IT_INVISIBILITY, "progs/invisibl.mdl");
+	powerup.netname = "Ring of Shadows";
+	powerup.noise = "items/inv1.wav";
+	powerup.touch = UsedRingTouch;
+	powerup.invisible_finished = self.invisible_finished - time;
+	self.invisible_time = 0;
+	self.invisible_finished = 0;
+};
+
+void() DropSuit =
+{
+	local entity powerup;
+
+	powerup = DropPowerup(IT_SUIT, "progs/suit.mdl");
+	powerup.netname = "Biosuit";
+	powerup.noise = "items/suit.wav";
+	powerup.touch = UsedSuitTouch;
+	powerup.radsuit_finished = self.radsuit_finished - time;
+	self.rad_time = 0;
+	self.radsuit_finished = 0;
+};
+
+void() DropArmor =
+{
+	local entity powerup;
+
+	powerup = DropPowerup(IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3, "progs/armor.mdl");
+	powerup.netname = "Armor";
+	powerup.noise = "items/armor1.wav";
+	powerup.armorvalue = self.armorvalue;
+	powerup.armortype = self.armortype;
+	self.armorvalue = 0;
+	self.armortype = 0;
+	if (powerup.armortype == 0.6)
+	{
+		powerup.skin = 1;
+		powerup.items = IT_ARMOR2;
+	}
+	else if (powerup.armortype == 0.8)
+	{
+		powerup.skin = 2;
+		powerup.items = IT_ARMOR3;
+	}
+	else
+		powerup.items = IT_ARMOR1;
+
+	powerup.touch = UsedArmorTouch;
+};
+
+void() DropPowerups =
+{
+	if (self.items & IT_INVULNERABILITY && On(DROPPENT))
+		DropPent();
+
+	if (self.items & IT_QUAD && On(DROPQUAD))
+		DropQuad();
+
+	if (self.items & IT_INVISIBILITY && On(DROPRING))
+		DropRing();
+
+	if (self.items & IT_SUIT && On(DROPSUIT))
+		DropSuit();
+
+	if (self.armorvalue > 0 && On(DROPARMOR))
+		DropArmor();
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Monsters in Deathmatch								//
+
+float () NoMonster =
+{
+	if (!cvar("skill") && self.spawnflags & 256)
+		return TRUE;
+
+	if (cvar("skill") == 1 && self.spawnflags & 512)
+		return TRUE;
+
+	if (cvar("skill") >= 2 && self.spawnflags & 1024)
+		return TRUE;
+
+	return !Yes(MONSTERS);
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Regenerating Monsters								//
+
+void() SetupMonsterRegen =
+{
+	if (self.enemy.classname != "player")
+		self.enemy = world;
+
+	if (self.oldenemy.classname != "player")
+		self.oldenemy = world;
+
+	self.flags = self.flags - (self.flags & FL_MONSTER);
+
+	self.cnt = time + MONSTER_REGEN_TIME;
+};
+
+void(void() reg_wait, float new_health) RegenMonster =
+{
+	local entity thing;
+
+	if (!Yes(REGEN) || time < self.cnt)
+	{
+		self.think = reg_wait;
+		return;
+	}
+	thing = findradius (self.origin, 100);
+	while (thing)
+	{
+		if (thing.classname == "player" || thing.flags & FL_MONSTER)
+		{
+			self.think = reg_wait;
+			return;
+		}
+		thing = thing.chain;
+	}
+	self.health = new_health;
+	self.solid = SOLID_SLIDEBOX;
+	self.takedamage = DAMAGE_AIM;
+	self.flags = self.flags | FL_MONSTER;
+	setorigin (self, self.origin);
+	spawn_tfog (self.origin);
+	killed_monsters = killed_monsters - 1;
+	WriteByte (MSG_BROADCAST, SVC_UPDATESTAT);
+	WriteByte (MSG_BROADCAST, STAT_KILLEDMONSTERS);
+	WriteLong (MSG_BROADCAST, killed_monsters);
+	if (self.enemy)
+		self.enemy.frags = self.enemy.frags - 1;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Ballistics Calculator (for Dogs, Fiends, Ogres and Zombies)		//
+
+float(vector org, vector trg, vector launch, float limit) InRange =
+{
+	local vector vec, ang, shoot;
+	local float launch_speed, av_speed, max_range, root;
+
+	launch_speed = vlen(launch);
+	av_speed = launch_speed * 0.8660254;
+	shoot = self.enemy.velocity;
+	shoot_z = 0;
+	vec = trg - org;
+	ang = vec + vlen(vec) / av_speed * shoot;
+	ang = vec + vlen(ang) / av_speed * shoot;
+	ang = vec + vlen(ang) / av_speed * shoot;
+	traceline (org, org + ang, TRUE, self);
+	if (trace_fraction >= 1)
+		vec = ang;
+
+	ang = shoot = vectoangles(vec);
+	makevectors (ang);
+	max_range = launch_speed * launch_speed / cvar("sv_gravity");
+	max_range = max_range / v_up_z;
+	if (ang_x > 180)
+		ang_x = ang_x - 360;
+
+	if (ang_x > 80 || ang_x < -60)
+		return FALSE;
+
+	shoot_x = (ang_x + 90) / 2;
+	ang_x = shoot_x - ang_x;
+	makevectors (shoot);
+	max_range = fabs(max_range * v_up_z / v_forward_z);
+	max_range = vlen(vec) / max_range;
+
+	if (max_range > limit)
+		return FALSE;
+
+	return TRUE;
+};
+
+vector(vector org, vector trg, vector launch) Ballistic =
+{
+	local vector vec, ang, shoot;
+	local float launch_speed, av_speed, max_range, root;
+
+	launch_speed = vlen(launch);
+	av_speed = launch_speed * 0.8660254;
+	shoot = self.enemy.velocity;
+	shoot_z = 0;
+	vec = trg - org;
+	ang = vec + vlen(vec) / av_speed * shoot;
+	ang = vec + vlen(ang) / av_speed * shoot;
+	ang = vec + vlen(ang) / av_speed * shoot;
+	traceline (org, org + ang, TRUE, self);
+	if (trace_fraction >= 1)
+		vec = ang;
+
+	ang = shoot = vectoangles(vec);
+	makevectors (ang);
+	max_range = launch_speed * launch_speed / cvar("sv_gravity");
+	max_range = max_range / v_up_z;
+	if (ang_x > 180)
+		ang_x = ang_x - 360;
+
+	shoot_x = (ang_x + 90) / 2;
+	ang_x = shoot_x - ang_x;
+	makevectors (shoot);
+	max_range = fabs(max_range * v_up_z / v_forward_z);
+	max_range = 1 - vlen(vec) / max_range;
+	if (max_range > 0)
+	{
+		root = (max_range * 1.4 + 0.7) / 2;
+		root = (max_range / root + root) / 2;
+		if (random() < 0.95)
+			shoot_x = shoot_x - ang_x * root;
+		else
+			shoot_x = shoot_x + ang_x * root;
+
+		makevectors (shoot);
+	}
+	shoot = v_forward * launch_speed;
+	shoot_z = 0 - shoot_z;			// Bug fix
+	return shoot;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Lightning Discharge into Water						//
+
+void(entity inflictor, entity attacker, float damage, entity ignore) T_RadiusDamageInWater =
+{
+	local	float 	points;
+	local	entity	head;
+	local	vector	org;
+
+	head = findradius(inflictor.origin, damage+40);
+	while (head)
+	{
+		if (head != ignore)
+		{
+			if (head.takedamage)
+			{
+				org = head.origin + (head.mins + head.maxs)*0.5;
+				points = 0.5*vlen (inflictor.origin - org);
+				if (points < 0)
+					points = 0;
+
+				points = damage - points;
+				if (head == attacker)
+					points = points * 0.5;
+
+				if (points>0 && head.waterlevel>0 && head.watertype==attacker.watertype)
+				{
+					if (CanDamage (head, inflictor))
+					{	// shambler takes half damage from all explosions
+						if (head.classname == "monster_shambler")
+							T_Damage (head, inflictor, attacker, points*0.5);
+						else
+							T_Damage (head, inflictor, attacker, points);
+					}
+				}
+			}
+		}
+		head = head.chain;
+	}
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Throw Ammo										//
+
+void() ThrowAmmo =
+{
+	local entity item;
+
+	if (!(self.ammo_shells + self.ammo_nails + self.ammo_rockets + self.ammo_cells))
+		return;
+
+	if (self.weapon == IT_AXE || self.weapon == IT_SHOTGUN)
+		return;
+
+	sound (self, CHAN_BODY, "player/plyrjmp8.wav", 1, ATTN_NORM);
+	item = spawn();
+	item.classname = "dropped_stuff";
+	item.flags = FL_ITEM;
+	item.solid = SOLID_TRIGGER;
+	item.touch = BackpackTouch;
+	item.movetype = MOVETYPE_TOSS;
+
+	if (self.weapon == IT_SUPER_SHOTGUN)
+	{
+		item.ammo_shells = Min (25, self.ammo_shells);
+		self.ammo_shells = self.ammo_shells - item.ammo_shells;
+		item.netname = "Double-barrelled Shotgun";
+		setmodel (item, "progs/g_shot.mdl");
+	}
+	else if (self.weapon == IT_NAILGUN)
+	{
+		item.ammo_nails = Min (50, self.ammo_nails);
+		self.ammo_nails = self.ammo_nails - item.ammo_nails;
+		item.netname = "Nailgun";
+		setmodel (item, "progs/g_nail.mdl");
+	}
+	else if (self.weapon == IT_SUPER_NAILGUN)
+	{
+		item.ammo_nails = Min (50, self.ammo_nails);
+		self.ammo_nails = self.ammo_nails - item.ammo_nails;
+		item.netname = "Super Nailgun";
+		setmodel (item, "progs/g_nail2.mdl");
+	}
+	else if (self.weapon == IT_GRENADE_LAUNCHER)
+	{
+		item.ammo_rockets = Min (25, self.ammo_rockets);
+		self.ammo_rockets = self.ammo_rockets - item.ammo_rockets;
+		item.netname = "Grenade Launcher";
+		setmodel (item, "progs/g_rock.mdl");
+	}
+	else if (self.weapon == IT_ROCKET_LAUNCHER)
+	{
+		item.ammo_rockets = Min (25, self.ammo_rockets);
+		self.ammo_rockets = self.ammo_rockets - item.ammo_rockets;
+		item.netname = "Rocket Launcher";
+		setmodel (item, "progs/g_rock2.mdl");
+	}
+	else if (self.weapon == IT_LIGHTNING)
+	{
+		item.ammo_cells = Min (25, self.ammo_cells);
+		self.ammo_cells = self.ammo_cells - item.ammo_cells;
+		item.netname = "Thunderbolt";
+		setmodel (item, "progs/g_light.mdl");
+	}
+	setsize (item, '-8 -8 0', '8 8 56');
+	setorigin (item, self.origin + v_forward*50);
+	item.velocity = aim (self, 1000);
+	item.velocity = item.velocity * 550;
+	item.items = self.weapon;
+	self.items = self.items - self.weapon;
+	self.weapon = W_BestWeapon ();
+	W_SetCurrentAmmo ();
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Flares										//
+
+void() FlareDim =
+{
+	self.effects = EF_DIMLIGHT;
+	self.think = SUB_Remove;
+	self.nextthink = time + 15;
+};
+
+void() FlareBright =
+{
+	local vector vel;
+
+	sound (self, CHAN_WEAPON, "misc/power.wav", 1, ATTN_NORM);
+	self.effects = EF_BRIGHTLIGHT;
+	particle (self.origin + '0 0 150' * 0.01, '0 0 150', 111, 150);
+	particle (self.origin + '0 0 120' * 0.01, '0 0 120', 73, 200);
+	self.think = FlareDim;
+	self.nextthink = time + 10;
+};
+
+void() FlareTouch =
+{
+	if (other == self.owner || other.solid == SOLID_TRIGGER)
+		return;
+
+	if(other.classname=="door"||other.classname=="plat"||pointcontents(self.origin)==CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+
+	if (other.takedamage)
+	{
+		spawn_touchblood (9);
+		T_Damage (other, self, self.owner, 1);
+		if (self.velocity != '0 0 0')
+			remove(self);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_SPIKE);
+		WriteCoord (MSG_BROADCAST, self.origin_x);
+		WriteCoord (MSG_BROADCAST, self.origin_y);
+		WriteCoord (MSG_BROADCAST, self.origin_z);
+	}
+	self.movetype = MOVETYPE_NONE;
+	setorigin (self, self.origin - self.velocity * 0.005);
+	self.velocity = '0 0 0';
+	self.touch = SUB_Null;
+};
+
+void() FireFlare =
+{
+	local entity missile;
+
+	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
+	self.punchangle_x = -2;
+	self.attack_finished = time + 0.5;
+	missile = spawn ();
+	missile.owner = self;
+	missile.classname = "flare";
+	missile.effects = EF_DIMLIGHT;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	missile.solid = SOLID_BBOX;
+	setmodel (missile, "progs/laser.mdl");
+	setsize (missile, '0 0 0', '0 0 0');
+	setorigin (missile, self.origin + '0 0 16');
+	missile.velocity = aim (self, 1000) * 1000;
+	missile.angles = vectoangles (missile.velocity);
+	missile.touch = FlareTouch;
+	missile.think = FlareBright;
+	missile.nextthink = time + 3;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Tracers										//
+
+void() TracerStick =
+{
+	if (time > self.delay || self.enemy.health < 1)
+		remove(self);
+	else
+	{
+		sound (self, CHAN_WEAPON, "misc/talk.wav", 1, ATTN_NORM);
+		setorigin (self, self.enemy.origin);
+		self.nextthink = time + 0.2;
+	}
+};
+
+void() TraceTouch =
+{
+	local vector dir;
+
+	if (other == self.owner)
+		return;
+
+	if (other.classname != "player" && !(other.flags & FL_MONSTER) || pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	dir = normalize(self.velocity);
+	setorigin (self, self.origin - 8 * dir);
+	self.movetype = MOVETYPE_NONE;
+	self.enemy = other;
+	self.think = TracerStick;
+	self.nextthink = time + 0.1;
+};
+
+void() FireTracer =
+{
+	local	entity missile;
+
+	if (self.ammo_rockets < 1 || self.ammo_cells < 1)
+		return;
+
+	NotCamping();
+
+	self.ammo_rockets = self.ammo_rockets - 1;
+	self.ammo_cells = self.ammo_cells - 1;
+
+	if (self.weapon == IT_ROCKET_LAUNCHER || self.weapon == IT_GRENADE_LAUNCHER)
+		self.currentammo = self.ammo_rockets;
+
+	else if (self.weapon == IT_LIGHTNING)
+		self.currentammo = self.ammo_cells;
+
+	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+	self.punchangle_x = -2;
+	self.attack_finished = time + 0.5;
+	missile = spawn ();
+	missile.owner = self;
+	missile.classname = "tracer";
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	missile.solid = SOLID_BBOX;
+	setmodel (missile, "progs/v_spike.mdl");
+	setsize (missile, '0 0 0', '0 0 0');
+	makevectors (self.v_angle);
+	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
+	missile.velocity = aim(self, 1000) * 1000;
+	missile.angles = vectoangles(missile.velocity);
+	missile.touch = TraceTouch;
+	missile.delay = time + 60;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Homing Rockets									//
+
+entity() HomingFindTarget = 
+{
+	local entity t, victim;
+	local float dist;
+
+	dist = 100000;
+	victim = world;
+	t = findradius (self.origin, dist);
+	while (t)
+	{
+		if (t.classname == "player" && t != self.owner || t.flags & FL_MONSTER)
+		{
+			if ( !(t.items & IT_INVISIBILITY) )
+			{
+				traceline (self.origin, t.origin, TRUE, self);
+				if (trace_fraction >= 1 && vlen(t.origin - self.origin) < dist)
+				{
+					victim = t;
+					dist = vlen (t.origin - self.origin);
+				}
+			}
+		}
+		t = t.chain;
+	}
+	if (victim != world)
+	{
+		if (victim.classname == "player")
+		{
+			centerprint2 (self.owner, "Homing->", victim.netname);
+			centerprint2 (victim, self.owner.netname, " has a bogey on you!");
+		}
+		else
+			centerprint2 (self.owner, "Homing->", victim.classname);
+	}
+	return victim;
+};
+
+void() HomingThink =
+{
+	if ( self.enemy == world || self.enemy.health < 1 )
+		self.enemy = HomingFindTarget();
+	else
+	{
+		traceline (self.origin, self.enemy.origin, TRUE, self);
+		if (trace_fraction < 1 || self.enemy.items & IT_INVISIBILITY)
+			self.enemy = HomingFindTarget();
+	}
+	if (self.enemy != world)
+	{
+		self.velocity=normalize(self.enemy.origin+'0 0 10'-self.origin)*50+self.velocity*0.8;
+		self.angles = vectoangles (self.velocity);
+	}
+	self.nextthink = time + 0.05;
+};
+
+void() FireHoming =
+{
+	local	entity missile;
+
+	if (self.weapon != IT_ROCKET_LAUNCHER || self.ammo_rockets < 5)
+		return;
+
+	NotCamping();
+
+	self.currentammo = self.ammo_rockets = self.ammo_rockets - 5;
+	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+	self.punchangle_x = -2;
+	self.attack_finished = time + 0.8;
+	missile = spawn ();
+	missile.owner = self;
+	missile.classname = "missile";
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	missile.solid = SOLID_BBOX;
+	setmodel (missile, "progs/missile.mdl");
+	setsize (missile, '0 0 0', '0 0 0');
+	makevectors (self.v_angle);
+	setorigin (missile, self.origin + v_forward * 8 + '0 0 16');
+	missile.velocity = aim(self, 1000) * 300;
+	missile.angles = vectoangles(missile.velocity);
+	missile.touch = T_MissileTouch;
+	missile.enemy = world;
+	missile.think = HomingThink;
+	missile.nextthink = time + 0.2;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Trigger Bombs and Proximity Bombs						//
+
+void() BombExplode =
+{
+	self.think = GrenadeExplode;
+	self.nextthink = random() * 0.25 + time + 0.25;
+};
+
+void(void() action) SpawnBomb =
+{
+	local entity bomb;
+
+	NotCamping();
+
+	self.currentammo = self.ammo_rockets = self.ammo_rockets - 5;
+	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
+	self.punchangle_x = -2;
+	self.attack_finished = time + 0.6;
+	bomb = spawn();
+	bomb.owner = self;
+	bomb.classname = "grenade";
+	bomb.flags = FL_ITEM;
+	bomb.movetype = MOVETYPE_BOUNCE;
+	bomb.solid = SOLID_TRIGGER;
+	setmodel (bomb,"progs/grenade.mdl");
+	setsize (bomb, '0 0 0', '0 0 0');
+	setorigin (bomb, self.origin);
+	makevectors (self.v_angle);
+	if (self.v_angle_x)
+		bomb.velocity = v_forward*600 + v_up*200 + crandom()*v_right*10 + crandom()*v_up*10;
+	else
+	{
+		bomb.velocity = aim(self, 10000);
+		bomb.velocity = bomb.velocity * 600;
+		bomb.velocity_z = 200;
+	}
+	bomb.avelocity = '300 300 300';
+	bomb.angles = vectoangles(bomb.velocity);
+	bomb.touch = GrenadeTouch;
+	bomb.takedamage = DAMAGE_YES;
+	bomb.th_die = BombExplode;
+	bomb.delay = time + 30;
+	bomb.think = action;
+	bomb.nextthink = time + 0.5;
+};
+
+void() TriggerBombThink =
+{
+	if (time > self.delay || self.owner.skin)
+	{
+		self.think = GrenadeExplode;
+		self.nextthink = time + 0.25;
+	}
+	else
+		self.nextthink = time + 0.1;
+};
+
+void() SpawnTriggerBomb =
+{
+	self.skin = 0;
+	if (self.weapon == IT_GRENADE_LAUNCHER && self.ammo_rockets >= 5)
+		SpawnBomb(TriggerBombThink);
+};
+
+void() ProximityBombThink =
+{
+	local entity t;
+
+	t = findradius (self.origin, 100);
+	while (t)
+	{
+		if (t.classname == "player" || t.flags & FL_MONSTER)
+		{
+			if ( !(t.items & IT_INVISIBILITY) )
+				self.delay = 0;
+		}
+		t = t.chain;
+	}
+	if (time > self.delay)
+	{
+		sound (self, CHAN_WEAPON, "misc/talk.wav", 1, ATTN_NORM);
+		self.think = GrenadeExplode;
+		self.nextthink = time + 0.25;
+	}
+	else
+		self.nextthink = time + 0.1;
+};
+
+void() SpawnProximityBomb =
+{
+	if (self.weapon == IT_GRENADE_LAUNCHER && self.ammo_rockets >= 5)
+		SpawnBomb(ProximityBombThink);
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Battler										//
+
+void() BattleReadyThink;
+void() BattleRunningThink;
+
+void() BattleWaitingThink =
+{
+	local entity p;
+	local float players;
+	local float waiting;
+
+	if (!self.cnt)
+	{
+		p = nextent (world);
+		while (p != world)
+		{
+			if (p.think == SUB_regen)
+			{
+				if (p.solid == SOLID_NOT)
+				{
+					if (p.nextthink)
+						p.nextthink = time + random();
+				}
+			}
+			p = nextent (p);
+		}
+	}
+
+	self.cnt = self.cnt + 1;
+
+	players = 0;
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		players = players + 1;
+		p.ammo_shells = p.ammo_rockets = p.ammo_cells = 100;
+		p.ammo_nails = 200;
+		p.items = p.items |
+			IT_SUPER_SHOTGUN |
+			IT_NAILGUN |
+			IT_SUPER_NAILGUN |
+			IT_GRENADE_LAUNCHER |
+			IT_ROCKET_LAUNCHER |
+			IT_LIGHTNING;
+
+		if (self.cnt == 6)
+			stuffcmd (p, "-showscores\n");
+
+		p = find(p, classname, "player");
+	}
+
+	if (players > 1)
+	{
+		waiting = 1;
+		p = find(world, classname, "player");
+		while (p != world)
+		{
+			waiting = waiting & 2;
+
+			if (!(p.items & IT_KEY2))
+			{
+				waiting = waiting | 2;
+				if (!(time & 15))
+					centerprint (p, "Type  at the console");
+			}
+			p = find(p, classname, "player");
+		}
+		if (!waiting)
+		{
+			battle = BATTLE_READY;
+			self.think = BattleReadyThink;
+			self.cnt = 11;
+		}
+	}
+	self.nextthink = time + 1;
+};
+
+void(string removeclass) RemoveItems =
+{
+	local entity p;
+
+	p = find(world, classname, removeclass);
+	while (p != world)
+	{
+		remove(p);
+		p = find(p, classname, removeclass);
+	}
+};
+
+void() BattleReadyThink =
+{
+	local entity p;
+	local string temp, sss;
+
+	self.cnt = self.cnt - 1;
+	temp = ftos(self.cnt);
+	if (self.cnt == 1)
+		sss = "";
+	else
+		sss = "s";
+
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		if (self.cnt)
+			centerprint4 (p, "Battle begins in ", temp, " second", sss);
+		else
+		{
+			centerprint (p, "");
+			p.cnt = cvar("temp1");
+			p.state = cvar("registered");
+			p.height = cvar("developer");
+			p.items = IT_SHOTGUN | IT_AXE;
+			p.ammo_shells = p.ammo_nails = p.ammo_rockets = p.ammo_cells = 0;
+			p.frags = 0;
+			T_Damage (p, self, self, 50000);
+		}
+		p = find(p, classname, "player");
+	}
+	if (!self.cnt)
+	{
+		RemoveItems("dropped_stuff");
+		RemoveItems("missile");
+		RemoveItems("grenade");
+		RemoveItems("flare");
+		RemoveItems("tracer");
+		RemoveItems("spike");
+		self.cnt = rint(cvar("timelimit") * 60);
+		battle = BATTLE_RUNNING;
+		self.think = BattleRunningThink;
+	}
+	self.nextthink = time + 1;
+};
+
+void() BattleRunningThink =
+{
+	local entity p;
+	local float fraglimit;
+	local float minutes;
+	local string temp, sss;
+
+	fraglimit = cvar("fraglimit");
+	p = find(world, classname, "player");
+	if (find(p, classname, "player") == world)
+		battle = BATTLE_BROKEN;
+
+	while (p != world)
+	{
+		if (fraglimit && p.frags >= fraglimit)
+			self.cnt = 1;
+
+		p = find(p, classname, "player");
+	}
+
+	if (battle == BATTLE_BROKEN)
+		self.cnt = 1;
+
+	minutes = self.cnt / 60;
+	if (floor(minutes) == minutes && floor(minutes))
+	{
+		temp = ftos(minutes);
+		if (minutes == 1)
+			sss = "";
+		else
+			sss = "s";
+
+		p = find(world, classname, "player");
+		while (p != world)
+		{
+			centerprint4 (p, "Battle ends in ", temp, " minute", sss);
+			p = find(p, classname, "player");
+		}
+	}
+
+	if (self.cnt)
+	{
+		self.cnt = self.cnt - 1;
+		if (self.cnt <= 10)
+		{
+			temp = ftos(self.cnt);
+			if (self.cnt == 1)
+				sss = "";
+			else
+				sss = "s";
+
+			p = find(world, classname, "player");
+			while (p != world)
+			{
+				if (self.cnt)
+					centerprint4 (p, "Battle ends in ", temp, " second", sss);
+				else
+				{
+					stuffcmd (p, "+showscores\n");
+					if (battle == BATTLE_BROKEN)
+						centerprint (p, "Player left - Battle stopped!");
+					else
+						centerprint (p, "Battle over");
+				}
+				p = find(p, classname, "player");
+			}
+			if (!self.cnt)
+			{
+				battle = BATTLE_WAITING;
+				self.think = BattleWaitingThink;
+			}
+		}
+	}
+	self.nextthink = time + 1;
+};
+
+void (entity who) TellFrags =
+{
+	local float fraglimit;
+	local string temp, sss;
+	local entity p;
+
+	fraglimit = cvar("fraglimit");
+	if (battle && fraglimit)
+	{
+		fraglimit = fraglimit - who.frags;
+		if (fraglimit <= 5 && fraglimit > 0)
+		{
+			temp = ftos(fraglimit);
+			if (fraglimit == 1)
+				sss = "";
+			else
+				sss = "s";
+
+			p = find(world, classname, "player");
+			while (p != world)
+			{
+				if (p == who)
+					centerprint5 (p, "You need ", temp, " frag", sss, " to win");
+				else
+					centerprint6 (p, who.netname, " needs ", temp, " frag", sss, " to win");
+
+				p = find(p, classname, "player");
+			}
+		}
+	}
+};
+
+void () CheckBattleStatus =
+{
+	if (self.solid == SOLID_NOT && battle != BATTLE_RUNNING)
+		T_Damage (self, battler, battler, 50000);
+
+	if (On(BATTLE))
+	{
+		if (battle == BATTLE_OFF)
+		{
+			battler = spawn();
+			battler.classname = "battle";
+			battler.think = BattleWaitingThink;
+			battler.nextthink = time + 1;
+			battle = BATTLE_WAITING;
+			cvar_set ("noexit", "1");
+		}
+	}
+	else
+	{
+		if (battle == BATTLE_WAITING)
+		{
+			remove (battler);
+			battle = BATTLE_OFF;
+			cvar_set ("noexit", "0");
+		}
+	}
+};
+
+void() AllowPlayerJoin =
+{
+	local entity p, q;
+
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		if (p.solid == SOLID_NOT)
+		{
+			q = find(world, classname, "player");
+			while (q != world)
+			{
+				centerprint4 (q, self.netname, " allows ", p.netname, " to join battle");
+				q = find(q, classname, "player");
+			}
+			T_Damage (p, battler, battler, 50000);
+		}
+		p = find(p, classname, "player");
+	}
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Camper Detector									//
+
+void() NotCamping =
+{
+	self.delay = Max (time + CAMP_FIRE, self.delay);
+};
+
+void () CheckIfCamping =
+{
+	local	entity p, beeper;
+
+	if (battle < BATTLE_OFF || vlen(self.pos1 - self.origin) > CAMP_SIZE)
+	{
+		self.pos1 = normalize(self.pos1 - self.origin) * CAMP_SIZE * 0.95 + self.origin;
+		self.delay = Max (self.delay, time + CAMP_MOVE);
+	}
+	else if (time > self.delay)
+	{
+		self.wait = time + CAMP_BEEP;
+		self.delay = time + CAMP_BEEP + CAMP_MOVE;
+		DropPowerups();
+		DropBackpack();
+		self.items = self.items - self.items & (
+			IT_SHOTGUN |
+			IT_SUPER_SHOTGUN |
+			IT_NAILGUN |
+			IT_SUPER_NAILGUN |
+			IT_GRENADE_LAUNCHER |
+			IT_ROCKET_LAUNCHER |
+			IT_LIGHTNING |
+			IT_EXTRA_WEAPON );
+		self.weapon = W_BestWeapon ();
+		W_SetCurrentAmmo ();
+		self.ammo_shells = self.ammo_nails = self.ammo_rockets = self.ammo_cells = 0;
+		stuffcmd (self, "bf\n");
+		centerprint (self, "You have been found guilty of camping!");
+
+		p = find(world, classname, "player");
+		while (p != world)
+		{
+			if (p != self)
+				centerprint2 (p, self.netname, " is camping!");
+
+			p = find(p, classname, "player");
+		}
+
+		beeper = spawn ();
+		beeper.solid = SOLID_BBOX;
+		beeper.movetype = MOVETYPE_NONE;
+		setmodel (beeper, "progs/v_spike.mdl");
+		setsize (beeper, '0 0 0', '0 0 0');
+		setorigin (beeper, self.origin);
+		beeper.enemy = self;
+		beeper.delay = time + CAMP_BEEP;
+		beeper.think = TracerStick;
+		beeper.nextthink = time + 0.1;
+	}
+	else if (time > self.wait)
+		self.wait = 0;
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Settings										//
+
+float (float bit) Yes =
+{
+	return cvar("developer") & bit;
+};
+
+float (float bit) No =
+{
+	return cvar("temp1") & bit;
+};
+
+float (float bit) On =
+{
+	return cvar("registered") & bit;
+};
+
+void(float flag, string command, string on, string off, string feature) ShowState =
+{
+	if (flag)
+		sprint4 (self, command, on, feature, "\n");
+	else
+		sprint4 (self, command, off, feature, "\n");
+};
+
+void(float bit, string command, string feature) Active =
+{
+	ShowState (Yes(bit), command, "  ", " No ", feature);
+};
+
+void(float bit, string command, string feature) Removed =
+{
+	ShowState (No(bit), command, " No ", "  ", feature);
+};
+
+void(float bit, string command, string feature) Enabled =
+{
+	ShowState (On(bit), command, "  ", " No ", feature);
+};
+
+float() Battling =
+{
+	if (battle == BATTLE_READY || battle == BATTLE_RUNNING)
+	{
+		sprint (self, "Can't change settings during battle\n");
+		return TRUE;
+	}
+	return FALSE;
+};
+
+float(float bit) VoteActivate =
+{
+	local entity p;
+	local float yes, no;
+
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		if (p.height & bit)
+			yes = yes + 1;
+		else
+			no = no + 1;
+
+		p = find(p, classname, "player");
+	}
+
+	if (yes > no)
+		return bit;
+
+	return 0;
+};
+
+float(float bit) VoteRemove =
+{
+	local entity p;
+	local float yes, no;
+
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		if (p.cnt & bit)
+			yes = yes + 1;
+		else
+			no = no + 1;
+
+		p = find(p, classname, "player");
+	}
+
+	if (yes > no)
+		return bit;
+
+	return 0;
+};
+
+float(float bit) VoteEnable =
+{
+	local entity p;
+	local float yes, no;
+
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		if (p.state & bit)
+			yes = yes + 1;
+		else
+			no = no + 1;
+
+		p = find(p, classname, "player");
+	}
+
+	if (yes > no)
+		return bit;
+
+	return 0;
+};
+
+void(float bit, string text, string feature) TellOthers =
+{
+	local entity p;
+	local float n;
+
+	n = -1;
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		n = n + 1;
+		p = find(p, classname, "player");
+	}
+	if (n)
+	{
+		if (!bit)
+			text = "";
+
+		bprint5 (self.netname, " wants ", text, feature, "\n");
+	}
+};
+
+void(float bit, string feature) Activates =
+{
+	local float number;
+	local string temp;
+
+	if (Battling())
+		return;
+
+	if (self.height & bit)
+		self.height = self.height - (self.height & bit);
+	else
+		self.height = self.height + bit;
+
+	TellOthers (!(self.height & bit), "no ", feature);
+
+	number = VoteActivate(bit);
+	if (number != Yes(bit))
+	{
+		number = cvar("developer");
+		if (Yes(bit))
+		{
+			number = number - (number & bit);
+			bprint ("No ");
+		}
+		else
+			number = number + bit;
+
+		bprint2 (feature, " selected\n");
+		if (bit == MONSTERS)
+			bprint ("(When level is changed/restarted)\n");
+
+		temp = ftos(number);
+		cvar_set ("developer", temp);
+	}
+};
+
+void (float flag, string object) Removal =
+{
+	local entity thing;
+
+	thing = find(world, netname, object);
+	while (thing != world)
+	{
+		if (flag)
+		{
+			thing.model = "";
+			thing.solid = SOLID_NOT;
+		}
+		else
+		{
+			thing.model = thing.mdl;
+			thing.solid = SOLID_TRIGGER;
+		}
+		setorigin (thing, thing.origin);
+		thing = find(thing, netname, object);
+	}
+};
+
+void(float bit, string object) Removes =
+{
+	local float number;
+	local string temp;
+
+	if (Battling())
+		return;
+
+	if (self.cnt & bit)
+		self.cnt = self.cnt - (self.cnt & bit);
+	else
+		self.cnt = self.cnt + bit;
+
+	TellOthers (self.cnt & bit, "No ", object);
+
+	number = VoteRemove(bit);
+	if (number != No(bit))
+	{
+		number = cvar("temp1");
+		if (No(bit))
+			number = number - (number & bit);
+		else
+		{
+			number = number + bit;
+			bprint ("No ");
+		}
+		bprint2 (object, " selected\n");
+
+		temp = ftos(number);
+		cvar_set ("temp1", temp);
+
+		Removal(No(bit), object);
+		if (object == "nails")
+			Removal (No(bit), "spikes");
+	}
+};
+
+void(float bit, string feature) Enables =
+{
+	local float number;
+	local string temp;
+
+	if (Battling())
+		return;
+
+	if (self.state & bit)
+		self.state = self.state - (self.state & bit);
+	else
+		self.state = self.state + bit;
+
+	TellOthers (!(self.state & bit), "no ", feature);
+
+	number = VoteEnable(bit);
+	if (number != On(bit))
+	{
+		number = cvar("registered");
+		if (On(bit))
+		{
+			number = number - (number & bit);
+			bprint ("No ");
+		}
+		else
+			number = number + bit;
+
+		bprint2 (feature, " selected\n");
+		temp = ftos(number);
+		cvar_set ("registered", temp);
+	}
+};
+
+void(string limit, float ceiling, float change) ChangeLimit =
+{
+	local float number;
+	local string temp;
+
+	if (Battling())
+		return;
+
+	number = Max (Min (cvar (limit) + change, ceiling), 0);
+	if (cvar(limit) != number)
+	{
+		bprint2 (self.netname, ": ");
+		temp = ftos(number);
+		cvar_set (limit, temp);
+	}
+};
+
+void(float n, string s1) ShowSetting =
+{
+	local string temp;
+
+	temp = ftos(n);
+	sprint3 (self, s1, temp, "\n");
+};
+
+void() ShowSettings =
+{
+	sprint (self, "   \n");
+	ShowSetting (cvar("skill"),		"      skill ");
+	ShowSetting (cvar("deathmatch"),	"      deathmatch ");
+	ShowSetting (cvar("fraglimit"),	"    fraglimit  ");
+	ShowSetting (cvar("timelimit"),	"    timelimit  ");
+	Active  (MONSTERS,	"  ", "Monsters in Deathmatch");
+	Active  (REGEN,		"     ", "Regenerating Monsters");
+	Active  (DOGJUMP,		"   ", "Good Dog Jumping");
+	Active  (FIENDJUMP,	" ", "Good Fiend Jumping");
+	Active  (ENFSHOT,		"   ", "Good Enforcer Shots");
+	Active  (DEATHSHOT,	" ", "Good Death Knight Shots");
+	Active  (OGRESHOT,	"  ", "Good Ogre Grenades");
+	Active  (SCRAGSHOT,	" ", "Good Scrag Shots");
+	Active  (ZOMBIESHOT,	"", "Good Zombie Shots");
+
+	Removed (SHELLS,		"  ", "shells");
+	Removed (NAILS,		"   ", "nails");
+	Removed (ROCKETS,		" ", "rockets");
+	Removed (CELLS,		"   ", "cells");
+	Removed (SSG,		"     ", "Super Shotguns");
+	Removed (NG,		"      ", "Nailguns");
+	Removed (SNG,		"     ", "Super Nailguns");
+	Removed (GL,		"      ", "Grenade Launchers");
+	Removed (RL,		"      ", "Rocket Launchers");
+	Removed (LG,		"      ", "Lightning Guns");
+	Removed (HEALTH,		"  ", "Health");
+	Removed (MEGA,		"    ", "MegaHealth");
+	Removed (ARMOR1,		"  ", "Green Armor");
+	Removed (ARMOR2,		"  ", "Yellow Armor");
+	Removed (ARMOR3,		"  ", "Red Armor");
+	Removed (PENT,		"    ", "Pentagram");
+	Removed (QUAD,		"    ", "Quad Damage");
+	Removed (RING,		"    ", "Ring of Shadows");
+
+	Enabled (RESPAWNS,	"  ", "Random Respawn");
+	Enabled (SHUFFLE,		"   ", "Item Shuffling");
+	Enabled (TELEPORT,	"  ", "Missile Teleport");
+	Enabled (DROPPENT,	"  ", "Drop Pentagram");
+	Enabled (DROPQUAD,	"  ", "Drop Quad Damage");
+	Enabled (DROPRING,	"  ", "Drop Ring of Shadows");
+	Enabled (DROPSUIT,	"  ", "Drop Biosuit");
+	Enabled (DROPARMOR,	" ", "Drop Armor");
+	Enabled (DISCHARGE,	" ", "Lightning Water Bug Fix");
+	Enabled (BALANCE,		"   ", "Weapon Power Balancing");
+	Enabled (THROWAMMO,	" ", "Throw Ammo");
+	Enabled (FLARES,		"    ", "Flares");
+	Enabled (TRACERS,		"   ", "Tracers");
+	Enabled (HOMING,		"    ", "Homing Rockets");
+	Enabled (PROXBOMBS,	" ", "Proximity Bombs");
+	Enabled (TRIGBOMBS,	" ", "Trigger Bombs");
+	Enabled (CAMPER,		"    ", "Camper Detector");
+	Enabled (BATTLE,		"    ", "Battle Mode");
+};
+
+////////////////////////////////////////////////////////////////////////////////
+//													//
+//		Extra Impulse Commands								//
+
+void() CheckLevelImpulses =
+{
+	local entity p;
+	local float players, agree;
+	local float e, m;
+	local string temp;
+
+	if (Battling())
+		return;
+
+	self.aflag = self.impulse;
+
+	players = 0;
+	agree = 0;
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		players = players + 1;
+		if (p.aflag == self.aflag)
+			agree = agree + 1;
+
+		p = find(p, classname, "player");
+	}
+
+	m = self.impulse - IM_E1M1;
+	e = floor(m / 8);
+	m = m - 8 * e;
+
+	if (agree > players / 2)
+	{
+		if (self.impulse == IM_START)
+			localcmd ("changelevel start\n");
+
+		else if (self.impulse == IM_END)
+			localcmd ("changelevel end\n");
+
+		else if (self.impulse <= IM_E4M8)
+		{
+			localcmd ("changelevel e");
+			temp = ftos(e + 1);
+			localcmd (temp);
+			localcmd ("m");
+			temp = ftos(m + 1);
+			localcmd (temp);
+			localcmd ("\n");
+		}
+		else
+		{
+			localcmd ("changelevel dm");
+			temp = ftos(self.impulse - IM_DM1 + 1);
+			localcmd (temp);
+			localcmd ("\n");
+		}
+	}
+	else
+	{
+		bprint2 (self.netname, " wants to play on ");
+
+		if (self.impulse == IM_START)
+			bprint ("start\n");
+
+		else if (self.impulse == IM_END)
+			bprint ("end\n");
+
+		else if (self.impulse <= IM_E4M8)
+		{
+			bprint ("e");
+			temp = ftos(e + 1);
+			bprint (temp);
+			bprint ("m");
+			temp = ftos(m + 1);
+			bprint (temp);
+			bprint ("\n");
+		}
+		else
+		{
+			bprint ("dm");
+			temp = ftos(self.impulse - IM_DM1 + 1);
+			bprint (temp);
+			bprint ("\n");
+		}
+	}
+};
+
+void() CheckDeathmatchImpulses =
+{
+	local entity p;
+	local float players, agree;
+	local string temp;
+
+	if (Battling())
+		return;
+
+	self.lip = self.impulse;
+	temp = ftos(self.impulse - IM_D1 + 1);
+
+	players = 0;
+	agree = 0;
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		players = players + 1;
+		if (p.lip == self.lip)
+			agree = agree + 1;
+
+		p = find(p, classname, "player");
+	}
+
+	if (agree > players / 2)
+	{
+		bprint3 ("Deathmatch ", temp, " rules selected\n");
+		cvar_set ("deathmatch", temp);
+		deathmatch = cvar("deathmatch");
+	}
+	else
+		bprint4 (self.netname, " wants deathmatch ", temp, " rules\n");
+};
+
+void() CheckSkillImpulses =
+{
+	local entity p;
+	local float players, agree;
+	local string temp;
+
+	if (Battling())
+		return;
+
+	self.count = self.impulse;
+	temp = ftos(self.impulse - IM_S0);
+
+	players = 0;
+	agree = 0;
+	p = find(world, classname, "player");
+	while (p != world)
+	{
+		players = players + 1;
+		if (p.count == self.count)
+			agree = agree + 1;
+
+		p = find(p, classname, "player");
+	}
+
+	if (agree > players / 2)
+	{
+		bprint3 ("Skill ", temp, " selected\n(When level is changed/restarted)\n");
+		cvar_set ("skill", temp);
+		skill = cvar("skill");
+	}
+	else
+		bprint4 (self.netname, " wants skill ", temp, "\n");
+};
+
+void() CheckExtraImpulses =
+{
+	local string temp;
+	local entity p;
+
+	if (!cvar("registered"))	// Don't confuse shareware game
+		return;
+
+	CheckBattleStatus();
+
+	if (On(CAMPER))
+		CheckIfCamping();
+
+	if (!self.impulse)
+		return;
+
+	if (self.impulse >= IM_E1M1 && self.impulse <= IM_DM6)
+		CheckLevelImpulses();
+
+	else if (self.impulse >= IM_S0 && self.impulse <= IM_S3)
+		CheckSkillImpulses();
+
+	else if (self.impulse >= IM_D1 && self.impulse <= IM_D4)
+		CheckDeathmatchImpulses();
+
+	else if (self.impulse == IM_FRAGP)
+		ChangeLimit("fraglimit", 100, 5);
+
+	else if (self.impulse == IM_FRAGM)
+		ChangeLimit("fraglimit", 100, -5);
+
+	else if (self.impulse == IM_TIMEP)
+		ChangeLimit("timelimit", 60, 5);
+
+	else if (self.impulse == IM_TIMEM)
+		ChangeLimit("timelimit", 60, -5);
+
+	else if (self.impulse == IM_SETTINGS)
+		ShowSettings();
+
+	else if (self.impulse == IM_MONSTERS)
+		Activates (MONSTERS, "Monsters in Deathmatch");
+
+	else if (self.impulse == IM_REGEN)
+		Activates (REGEN, "Regenerating Monsters");
+
+	else if (self.impulse == IM_DOGJUMP)
+		Activates (DOGJUMP, "Good Dog Jumping");
+
+	else if (self.impulse == IM_FIENDJUMP)
+		Activates (FIENDJUMP, "Good Fiend Jumping");
+
+	else if (self.impulse == IM_ENFSHOT)
+		Activates (ENFSHOT, "Good Enforcer Shots");
+
+	else if (self.impulse == IM_DEATHSHOT)
+		Activates (DEATHSHOT, "Good Death Knight Shots");
+
+	else if (self.impulse == IM_OGRESHOT)
+		Activates (OGRESHOT, "Good Ogre Grenades");
+
+	else if (self.impulse == IM_SCRAGSHOT)
+		Activates (SCRAGSHOT, "Good Scrag Shots");
+
+	else if (self.impulse == IM_ZOMBIESHOT)
+		Activates (ZOMBIESHOT, "Good Zombie Shots");
+
+	else if (self.impulse == IM_SHELLS)
+		Removes (SHELLS, "shells");
+
+	else if (self.impulse == IM_NAILS)
+		Removes (NAILS, "nails");
+
+	else if (self.impulse == IM_ROCKETS)
+		Removes (ROCKETS, "rockets");
+
+	else if (self.impulse == IM_CELLS)
+		Removes (CELLS, "cells");
+
+	else if (self.impulse == IM_SSG)
+		Removes (SSG, "Double-barrelled Shotgun");
+
+	else if (self.impulse == IM_NG)
+		Removes (NG, "nailgun");
+
+	else if (self.impulse == IM_SNG)
+		Removes (SNG, "Super Nailgun");
+
+	else if (self.impulse == IM_GL)
+		Removes (GL, "Grenade Launcher");
+
+	else if (self.impulse == IM_RL)
+		Removes (RL, "Rocket Launcher");
+
+	else if (self.impulse == IM_LG)
+		Removes (LG, "Thunderbolt");
+
+	else if (self.impulse == IM_HEALTH)
+		Removes (HEALTH, "Health");
+
+	else if (self.impulse == IM_MEGA)
+		Removes (MEGA, "MegaHealth");
+
+	else if (self.impulse == IM_ARMOR1)
+		Removes (ARMOR1, "Green Armor");
+
+	else if (self.impulse == IM_ARMOR2)
+		Removes (ARMOR2, "Yellow Armor");
+
+	else if (self.impulse == IM_ARMOR3)
+		Removes (ARMOR3, "Red Armor");
+
+	else if (self.impulse == IM_PENT)
+		Removes (PENT, "Pentagram of Protection");
+
+	else if (self.impulse == IM_QUAD)
+		Removes (QUAD, "Quad Damage");
+
+	else if (self.impulse == IM_RING)
+		Removes (RING, "Ring of Shadows");
+
+	else if (self.impulse == IM_GOLLUM)
+		self.items = self.items | IT_ALIAS;
+
+	else if (self.impulse == IM_RESPAWNS)
+		Enables (RESPAWNS, "Random Respawn");
+
+	else if (self.impulse == IM_SHUFFLE)
+		Enables (SHUFFLE, "Item Shuffling");
+
+	else if (self.impulse == IM_TELEPORT)
+		Enables (TELEPORT, "Missile Teleport");
+
+	else if (self.impulse == IM_DROPPENT)
+		Enables (DROPPENT, "Drop Pentagram");
+
+	else if (self.impulse == IM_DROPQUAD)
+		Enables (DROPQUAD, "Drop Quad Damage");
+
+	else if (self.impulse == IM_DROPRING)
+		Enables (DROPRING, "Drop Ring of Shadows");
+
+	else if (self.impulse == IM_DROPSUIT)
+		Enables (DROPSUIT, "Drop Biosuit");
+
+	else if (self.impulse == IM_DROPARMOR)
+		Enables (DROPARMOR, "Drop Armor");
+
+	else if (self.impulse == IM_DISCHARGE)
+		Enables (DISCHARGE, "Lightning Water Bug Fix");
+
+	else if (self.impulse == IM_BALANCE)
+		Enables (BALANCE, "Weapon Power Balancing");
+
+	else if (self.impulse == IM_THROWAMMO)
+		Enables (THROWAMMO, "Throw Ammo");
+
+	else if (self.impulse==IM_THROW && On(THROWAMMO) && deathmatch==1 && battle>=BATTLE_OFF)
+		ThrowAmmo ();
+
+	else if (self.impulse == IM_FLARES)
+		Enables (FLARES, "Flares");
+
+	else if (self.impulse == IM_FLARE && On(FLARES))
+		FireFlare ();
+
+	else if (self.impulse == IM_TRACERS)
+		Enables (TRACERS, "Tracers");
+
+	else if (self.impulse == IM_TRACER && On(TRACERS))
+		FireTracer();
+
+	else if (self.impulse == IM_HOMING)
+		Enables (HOMING, "Homing Rockets");
+
+	else if (self.impulse == IM_HOMER && On(HOMING))
+		FireHoming ();
+
+	else if (self.impulse == IM_PROXBOMBS)
+		Enables (PROXBOMBS, "Proximity Bombs");
+
+	else if (self.impulse == IM_PROX && On(PROXBOMBS))
+		SpawnProximityBomb();
+
+	else if (self.impulse == IM_TRIGBOMBS)
+		Enables (TRIGBOMBS, "Trigger Bombs");
+
+	else if (self.impulse == IM_TRIG && On(TRIGBOMBS))
+		SpawnTriggerBomb();
+
+	else if (self.impulse == IM_BLOW && On(TRIGBOMBS))
+	{
+		SoundQ (self, CHAN_WEAPON, "misc/talk.wav", 1, ATTN_NORM);
+		self.skin = 1;
+	}
+	else if (self.impulse == IM_CAMPER)
+		Enables (CAMPER, "Camper Detector");
+
+	else if (self.impulse == IM_BATTLE)
+		Enables (BATTLE, "Battle Mode");
+
+	else if (self.impulse == IM_READY && battle == BATTLE_WAITING)
+	{
+		if (!cvar("fraglimit") && !cvar("timelimit"))
+			sprint (self, "Set timelimit/fraglimit\n");
+		else
+		{
+			self.items = self.items | IT_KEY2;
+			p = find(p, classname, "player");
+			while (p != world)
+			{
+				if (p != self)
+					centerprint2 (p, self.netname, " is ready");
+
+				p = find(p, classname, "player");
+			}
+			sprint (self, "You can type  if you need to\n");
+		}
+	}
+	else if (self.impulse == IM_NREADY && battle == BATTLE_WAITING)
+	{
+		self.items = self.items - (self.items & IT_KEY2);
+		p = find(p, classname, "player");
+		while (p != world)
+		{
+			if (p != self)
+				centerprint2 (p, self.netname, " is not ready");
+
+			p = find(p, classname, "player");
+		}
+	}
+	else if (self.impulse == IM_JOIN && self.solid != SOLID_NOT)
+		AllowPlayerJoin();
+};
diff -ur --new-file ..\v106qc/soldier.qc .\QC/soldier.qc
--- ..\v106qc/soldier.qc	Mon Jul 21 23:06:16 1997
+++ .\QC/soldier.qc	Fri Oct 24 21:37:42 1997
@@ -202,7 +202,20 @@
 void()	army_die7	=[	$death7,	army_die8	] {};
 void()	army_die8	=[	$death8,	army_die9	] {};
 void()	army_die9	=[	$death9,	army_die10	] {};
-void()	army_die10	=[	$death10,	army_die10	] {};
+void()	army_die10	=[	$death10,	army_reg1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(army_die10, 30);								/// Regeneration
+};													/// Regeneration
+void()	army_reg1	=[	$death10,	army_reg2	] {};				/// Regeneration
+void()	army_reg2	=[	$death9,	army_reg3	] {};				/// Regeneration
+void()	army_reg3	=[	$death8,	army_reg4	] {};				/// Regeneration
+void()	army_reg4	=[	$death7,	army_reg5	] {};				/// Regeneration
+void()	army_reg5	=[	$death6,	army_reg6	] {};				/// Regeneration
+void()	army_reg6	=[	$death5,	army_reg7	] {};				/// Regeneration
+void()	army_reg7	=[	$death4,	army_reg8	] {};				/// Regeneration
+void()	army_reg8	=[	$death3,	army_reg9	] {};				/// Regeneration
+void()	army_reg9	=[	$death2,	army_reg10	] {};				/// Regeneration
+void()	army_reg10	=[	$death1,	army_run1	] {};				/// Regeneration
 
 void()	army_cdie1	=[	$deathc1,	army_cdie2	] {};
 void()	army_cdie2	=[	$deathc2,	army_cdie3	] {ai_back(5);};
@@ -215,19 +228,28 @@
 void()	army_cdie8	=[	$deathc8,	army_cdie9	] {};
 void()	army_cdie9	=[	$deathc9,	army_cdie10	] {};
 void()	army_cdie10	=[	$deathc10,	army_cdie11	] {};
-void()	army_cdie11	=[	$deathc11,	army_cdie11	] {};
-
+void()	army_cdie11	=[	$deathc11,	army_creg1	]				/// Regeneration
+{													/// Regeneration
+	RegenMonster(army_cdie11, 30);							/// Regeneration
+};													/// Regeneration
+void()	army_creg1	=[	$deathc11,	army_creg2	] {};				/// Regeneration
+void()	army_creg2	=[	$deathc10,	army_creg3	] {ai_forward(5);};	/// Regeneration
+void()	army_creg3	=[	$deathc9,	army_creg4	] {ai_forward(4);};	/// Regeneration
+void()	army_creg4	=[	$deathc8,	army_creg5	] {ai_forward(13);};	/// Regeneration
+void()	army_creg5	=[	$deathc7,	army_creg6	] {ai_forward(3);};	/// Regeneration
+void()	army_creg6	=[	$deathc6,	army_creg7	] {ai_forward(4);};	/// Regeneration
+void()	army_creg7	=[	$deathc5,	army_creg8	] {};				/// Regeneration
+void()	army_creg8	=[	$deathc4,	army_creg9	] {};				/// Regeneration
+void()	army_creg9	=[	$deathc3,	army_creg10	] {};				/// Regeneration
+void()	army_creg10	=[	$deathc2,	army_creg11	] {};				/// Regeneration
+void()	army_creg11	=[	$deathc1,	army_run1	] {};				/// Regeneration
 
 void() army_die =
 {
 // check for gib
 	if (self.health < -35)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_guard.mdl", self.health);
-		ThrowGib ("progs/gib1.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib3.mdl", self.health);
+		GibMonster ("progs/h_guard.mdl");						/// Lord Smagol
 		return;
 	}
 
@@ -237,6 +259,8 @@
 		army_die1 ();
 	else
 		army_cdie1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 
@@ -244,7 +268,7 @@
 */
 void() monster_army =
 {	
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/tarbaby.qc .\QC/tarbaby.qc
--- ..\v106qc/tarbaby.qc	Mon Jul 21 23:06:18 1997
+++ .\QC/tarbaby.qc	Fri Oct 24 21:37:42 1997
@@ -190,7 +190,7 @@
 */
 void() monster_tarbaby =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/triggers.qc .\QC/triggers.qc
--- ..\v106qc/triggers.qc	Mon Jul 21 23:06:18 1997
+++ .\QC/triggers.qc	Fri Oct 24 21:37:44 1997
@@ -324,7 +324,10 @@
 	if (other.classname == "player")
 	{
 		if (other.invincible_finished > time)
+		{
 			self.classname = "teledeath2";
+			T_Damage (self.owner, self, self, 50000);				/// Satan Telefrag
+		}
 		if (self.owner.classname != "player")
 		{	// other monsters explode themselves
 			T_Damage (self.owner, self, self, 50000);
@@ -361,25 +364,21 @@
 
 void() teleport_touch =
 {
-local entity	t;
-local vector	org;
+	local entity t;
+	local entity thing, p;									/// Lord Smagol
+	local float dist;										/// Lord Smagol
+	local vector org;
 
 	if (self.targetname)
-	{
 		if (self.nextthink < time)
-		{
 			return;		// not fired yet
-		}
-	}
 
-	if (self.spawnflags & PLAYER_ONLY)
-	{
+	if (self.spawnflags & PLAYER_ONLY && !On(TELEPORT))				/// Teleport
 		if (other.classname != "player")
 			return;
-	}
 
 // only teleport living creatures
-	if (other.health <= 0 || other.solid != SOLID_SLIDEBOX)
+	if ( (other.health<=0 || other.solid!=SOLID_SLIDEBOX) && !On(TELEPORT))	/// Teleport
 		return;
 
 	SUB_UseTargets ();
@@ -390,24 +389,39 @@
 	t = find (world, targetname, self.target);
 	if (!t)
 		objerror ("couldn't find target");
-		
+
+	p = world;											/// Teleport
+	dist = 128;											/// Teleport
+	thing = find (world, classname, "info_teleport_destination");		/// Teleport
+	while (thing)										/// Teleport
+	{												/// Teleport
+		if (vlen (thing.origin - other.origin) < dist)				/// Teleport
+		{											/// Teleport
+			dist = vlen (thing.origin - other.origin);			/// Teleport
+			p = thing;									/// Teleport
+		}											/// Teleport
+		thing=find (thing, classname, "info_teleport_destination");		/// Teleport
+	}												/// Teleport
+	other.angles = vectoangles (other.velocity);					/// Teleport
+	if (p)											/// Teleport
+		other.angles_y=anglemod(other.angles_y-p.mangle_y+180+t.mangle_y);/// Teleport
+	else												/// Teleport
+		other.angles_y = t.mangle_y;							/// Teleport
+
+	if (other.health)										/// Teleport
+		other.angles = t.mangle;							/// Teleport
+
 // spawn a tfog flash in front of the destination
-	makevectors (t.mangle);
+	makevectors (other.angles);								/// Teleport
+	v_forward_z = 0 - v_forward_z;							/// Teleport
 	org = t.origin + 32 * v_forward;
+	setorigin (other, t.origin);		// Moved to here				/// Teleport
+	other.velocity = v_forward * vlen (other.velocity);				/// Teleport
 
 	spawn_tfog (org);
 	spawn_tdeath(t.origin, other);
 
 // move the player and lock him down for a little while
-	if (!other.health)
-	{
-		other.origin = t.origin;
-		other.velocity = (v_forward * other.velocity_x) + (v_forward * other.velocity_y);
-		return;
-	}
-
-	setorigin (other, t.origin);
-	other.angles = t.mangle;
 	if (other.classname == "player")
 	{
 		other.fixangle = 1;		// turn this way immediately
diff -ur --new-file ..\v106qc/weapons.qc .\QC/weapons.qc
--- ..\v106qc/weapons.qc	Mon Jul 21 23:06:22 1997
+++ .\QC/weapons.qc	Fri Oct 24 21:37:44 1997
@@ -22,6 +22,8 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+
+	CacheExtraStuff();									/// Lord Smagol
 };
 
 float() crandom =
@@ -39,6 +41,9 @@
 	local	vector	source;
 	local	vector	org;
 
+	if (self.solid == SOLID_NOT)								/// Battle
+		return;										/// Battle
+
 	makevectors (self.v_angle);
 	source = self.origin + '0 0 16';
 	traceline (source, source + v_forward*64, FALSE, self);
@@ -49,9 +54,14 @@
 
 	if (trace_ent.takedamage)
 	{
+		sound(self, CHAN_WEAPON, "shambler/smack.wav", 1, ATTN_NORM);	/// Lord Smagol
 		trace_ent.axhitme = 1;
 		SpawnBlood (org, '0 0 0', 20);
-		T_Damage (trace_ent, self, self, 20);
+		parm16 = IT_AXE;									/// Killing Weapon
+		if (On(BALANCE))									/// Weapon Balance
+			T_Damage (trace_ent, self, self, 40);				/// Weapon Balance
+		else											/// Weapon Balance
+			T_Damage (trace_ent, self, self, 20);
 	}
 	else
 	{	// hit wall
@@ -272,7 +282,11 @@
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
 	dir = aim (self, 100000);
-	FireBullets (6, dir, '0.04 0.04 0');
+	parm16 = IT_SHOTGUN;									/// Killing Weapon
+	if (On(BALANCE))										/// Weapon Balance
+		FireBullets (9, dir, '0.04 0.04 0');					/// Weapon Balance
+	else												/// Weapon Balance
+		FireBullets (6, dir, '0.04 0.04 0');
 };
 
 
@@ -297,7 +311,11 @@
 	
 	self.currentammo = self.ammo_shells = self.ammo_shells - 2;
 	dir = aim (self, 100000);
-	FireBullets (14, dir, '0.14 0.08 0');
+	parm16 = IT_SUPER_SHOTGUN;								/// Killing Weapon
+	if (On(BALANCE))										/// Weapon Balance
+		FireBullets (21, dir, '0.14 0.08 0');					/// Weapon Balance
+	else												/// Weapon Balance
+		FireBullets (14, dir, '0.14 0.08 0');
 };
 
 
@@ -341,6 +359,8 @@
 
 	damg = 100 + random()*20;
 	
+	parm16 = IT_ROCKET_LAUNCHER;								/// Killing Weapon
+
 	if (other.health)
 	{
 		if (other.classname == "monster_shambler")
@@ -474,13 +494,20 @@
 		return;
 	}
 
+	parm16 = IT_LIGHTNING;									/// Killing Weapon
+
 // explode if under water
 	if (self.waterlevel > 1)
 	{
 		cells = self.ammo_cells;
 		self.ammo_cells = 0;
 		W_SetCurrentAmmo ();
-		T_RadiusDamage (self, self, 35*cells, world);
+
+		if (On(DISCHARGE))								/// Discharge
+			T_RadiusDamageInWater (self, self, 35*cells, world);		/// Discharge
+		else											/// Discharge
+			T_RadiusDamage (self, self, 35*cells, world);
+
 		return;
 	}
 
@@ -516,6 +543,8 @@
 
 void() GrenadeExplode =
 {
+	self.skin = 0;										/// Bombs
+	parm16 = IT_GRENADE_LAUNCHER;								/// Killing Weapon
 	T_RadiusDamage (self, self.owner, 120, world);
 
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
@@ -629,6 +658,7 @@
 	local vector	dir;
 	local entity	old;
 	
+	parm16 = IT_SUPER_NAILGUN;								/// Killing Weapon
 	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
 	self.attack_finished = time + 0.2;
 	self.currentammo = self.ammo_nails = self.ammo_nails - 2;
@@ -691,7 +721,11 @@
 	if (other.takedamage)
 	{
 		spawn_touchblood (9);
-		T_Damage (other, self, self.owner, 9);
+		parm16 = IT_NAILGUN;								/// Killing Weapon
+		if (On(BALANCE))									/// Weapon Balance
+			T_Damage (other, self, self.owner, 18);				/// Weapon Balance
+		else											/// Weapon Balance
+			T_Damage (other, self, self.owner, 9);
 	}
 	else
 	{
@@ -731,7 +765,11 @@
 	if (other.takedamage)
 	{
 		spawn_touchblood (18);
-		T_Damage (other, self, self.owner, 18);
+		parm16 = IT_SUPER_NAILGUN;							/// Killing Weapon
+		if (On(BALANCE))									/// Weapon Balance
+			T_Damage (other, self, self.owner, 36);				/// Weapon Balance
+		else											/// Weapon Balance
+			T_Damage (other, self, self.owner, 18);
 	}
 	else
 	{
@@ -887,7 +925,7 @@
 
 	if (self.weapon == IT_AXE)
 	{
-		sound (self, CHAN_WEAPON, "weapons/ax1.wav", 1, ATTN_NORM);
+		SoundQ (self, CHAN_WEAPON, "weapons/ax1.wav", 1, ATTN_NORM);	/// Battle
 		r = random();
 		if (r < 0.25)
 			player_axe1 ();
@@ -902,12 +940,14 @@
 	else if (self.weapon == IT_SHOTGUN)
 	{
 		player_shot1 ();
+		NotCamping();									/// Camper
 		W_FireShotgun ();
 		self.attack_finished = time + 0.5;
 	}
 	else if (self.weapon == IT_SUPER_SHOTGUN)
 	{
 		player_shot1 ();
+		NotCamping();									/// Camper
 		W_FireSuperShotgun ();
 		self.attack_finished = time + 0.7;
 	}
@@ -922,12 +962,14 @@
 	else if (self.weapon == IT_GRENADE_LAUNCHER)
 	{
 		player_rocket1();
+		NotCamping();									/// Camper
 		W_FireGrenade();
 		self.attack_finished = time + 0.6;
 	}
 	else if (self.weapon == IT_ROCKET_LAUNCHER)
 	{
 		player_rocket1();
+		NotCamping();									/// Camper
 		W_FireRocket();
 		self.attack_finished = time + 0.8;
 	}
@@ -1244,6 +1286,8 @@
 	if (self.impulse == 255)
 		QuadCheat ();
 		
+	CheckExtraImpulses();									/// Lord Smagol
+
 	self.impulse = 0;
 };
 
diff -ur --new-file ..\v106qc/wizard.qc .\QC/wizard.qc
--- ..\v106qc/wizard.qc	Mon Jul 21 23:06:22 1997
+++ .\QC/wizard.qc	Fri Oct 24 21:37:44 1997
@@ -62,15 +62,18 @@
 	move_z = 0;
 
 // project the target forward in time
-	vec = vec + move * fly;
-	
+	fly = vlen(vec + move * fly) / mspeed;	// adjust for range change	/// Lord Smagol
+	fly = vlen(vec + move * fly) / mspeed;	// adjust for range change	/// Lord Smagol
+	traceline (missile.origin, missile.origin+vec+move*fly, TRUE, self);	/// Lord Smagol
+	if (trace_fraction >= 1)			// lead if will be visible	/// Lord Smagol
+		vec = vec + move * fly;
+
 	vec = normalize(vec);
 	vec = vec + accuracy*v_up*(random()- 0.5) + accuracy*v_right*(random()- 0.5);
 	
 	missile.velocity = vec * mspeed;
 
-	missile.angles = '0 0 0';
-	missile.angles_y = vectoyaw(missile.velocity);
+	missile.angles = vectoangles(missile.velocity);					/// Lord Smagol
 
 // set missile duration
 	missile.nextthink = time + 5;
@@ -203,6 +206,9 @@
 		sound (self, CHAN_WEAPON, "wizard/wattack.wav", 1, ATTN_NORM);
 		launch_spike (self.origin, vec);
 		newmis.velocity = vec*600;
+		if (Yes(SCRAGSHOT))								/// Scrag Shot
+			LaunchMissile(newmis, 600, 0);					/// Scrag Shot
+
 		newmis.owner = self.owner;
 		newmis.classname = "wizspike";
 		setmodel (newmis, "progs/w_spike.mdl");
@@ -336,22 +342,31 @@
 void()	wiz_death5	=[	$death5,		wiz_death6	] {};
 void()	wiz_death6	=[	$death6,		wiz_death7	] {};
 void()	wiz_death7	=[	$death7,		wiz_death8	] {};
-void()	wiz_death8	=[	$death8,		wiz_death8	] {};
+void()	wiz_death8	=[	$death8,		wiz_reg1	]			/// Regeneration
+{													/// Regeneration
+	RegenMonster(wiz_death8, 80);								/// Regeneration
+};													/// Regeneration
+void()	wiz_reg1	=[	$death8,	wiz_reg2	] {};				/// Regeneration
+void()	wiz_reg2	=[	$death7,	wiz_reg3	] {};				/// Regeneration
+void()	wiz_reg3	=[	$death6,	wiz_reg4	] {};				/// Regeneration
+void()	wiz_reg4	=[	$death5,	wiz_reg5	] {};				/// Regeneration
+void()	wiz_reg5	=[	$death4,	wiz_reg6	] {};				/// Regeneration
+void()	wiz_reg6	=[	$death3,	wiz_reg7	] {};				/// Regeneration
+void()	wiz_reg7	=[	$death2,	wiz_reg8	] {};				/// Regeneration
+void()	wiz_reg8	=[	$death1,	wiz_run1	] {};				/// Regeneration
 
 void() wiz_die =
 {
 // check for gib
 	if (self.health < -40)
 	{
-		sound (self, CHAN_VOICE, "player/udeath.wav", 1, ATTN_NORM);
-		ThrowHead ("progs/h_wizard.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
-		ThrowGib ("progs/gib2.mdl", self.health);
+		GibMonster ("progs/h_wizard.mdl");						/// Lord Smagol
 		return;
 	}
 
 	wiz_death1 ();
+
+	SetupMonsterRegen();									/// Lord Smagol
 };
 
 
@@ -374,7 +389,7 @@
 */
 void() monster_wizard =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch)							/// Monsters
 	{
 		remove(self);
 		return;
diff -ur --new-file ..\v106qc/zombie.qc .\QC/zombie.qc
--- ..\v106qc/zombie.qc	Mon Jul 21 23:06:24 1997
+++ .\QC/zombie.qc	Fri Oct 24 21:37:44 1997
@@ -176,12 +176,16 @@
 	
 // set missile speed	
 
-	makevectors (self.angles);
-
-	missile.velocity = normalize(self.enemy.origin - org);
-	missile.velocity = missile.velocity * 600;
-	missile.velocity_z = 200;
+	if (Yes(ZOMBIESHOT))									/// Zombie Shot
+		missile.velocity = Ballistic(org, self.enemy.origin, '0 600 200');/// Zombie Shot
+	else												/// Zombie Shot
+	{
+		makevectors (self.angles);
 
+		missile.velocity = normalize(self.enemy.origin - org);
+		missile.velocity = missile.velocity * 600;
+		missile.velocity_z = 200;
+	}
 	missile.avelocity = '3000 1000 2000';
 
 	missile.touch = ZombieGrenadeTouch;
@@ -469,7 +473,7 @@
 */
 void() monster_zombie =
 {
-	if (deathmatch)
+	if (NoMonster() && deathmatch && !(self.spawnflags & SPAWN_CRUCIFIED))	/// Monsters
 	{
 		remove(self);
 		return;
@@ -507,6 +511,8 @@
 
 	if (self.spawnflags & SPAWN_CRUCIFIED)
 	{
+		self.takedamage = DAMAGE_AIM;							/// Crucified
+		self.inpain = 2;									/// Crucified
 		self.movetype = MOVETYPE_NONE;
 		zombie_cruc1 ();
 	}
