#ifndef HASH_H
#define HASH_H

#include "qcc.h"

struct hash_element {
        struct hash_element *next;
        def_t *def;
};

struct prhash_element {
        struct prhash_element *next;
        opcode_t *op;
};

extern int hashinitdone;

extern struct hash_element *htable[4007];
extern struct prhash_element *prhtable[199];
extern void inithash();
#ifndef INLINE
extern int hash(char *);
extern int prhash(char *);
#endif

#ifdef INLINE
inline static int
hash(char *string)
{
        int index=0;
        int count=0;

        for(count=0; string[count]!='\0' && count<20; count++) {
                index = (index << 1) + (string[count] << 1);
        }

        return index % 4007;
}

inline static int
prhash(char *string)
{
        int index=0;
        int count=0;

        for(count=0; string[count]!='\0' && count<20; count++) {
                index = (index << 1) + (string[count] << 1);
        }

        return index % 199;
}
#endif

#endif
