diff -ur --new-file v106qc/chain.qc kalq-src/chain.qc
--- v106qc/chain.qc	Thu Jan  1 00:00:00 1970
+++ kalq-src/chain.qc	Tue Oct 22 15:02:14 1996
@@ -0,0 +1,222 @@
+
+/************\
+* BreakChain *
+\************/
+
+void (entity Head) BreakChain =
+{
+        local entity link;
+
+        link = Head.goalentity;
+        while (link != world)
+        {
+                Head = link.goalentity;
+                remove (link);
+                link = Head;
+        }
+};
+
+/*********\
+* LinkPos *
+\*********/
+
+void () LinkPos =
+{
+        makevectors (self.enemy.angles);
+        setorigin (self, self.owner.origin + ( ( ( self.enemy.origin + 
+                (v_up * 16 * (!self.enemy.button2)) + (v_forward * 16) ) - self.owner.origin ) *
+                ( self.weapon ) ) );
+        self.nextthink = time + 0.01;
+};
+
+/***********\
+* MakeChain *
+\***********/
+
+entity (entity head, entity tail, float num) MakeChain =
+{
+        local entity link, prevlink;
+        local float linknum;
+
+        linknum = num;
+        num = num + 1;
+        prevlink = world;
+        while (linknum > 0)
+        {
+                link = spawn();
+
+                link.goalentity = prevlink;
+                prevlink = link;
+
+                link.owner = head;
+                link.enemy = tail;
+                link.weapon = linknum / num;
+                link.movetype = MOVETYPE_NOCLIP;
+                link.solid = SOLID_NOT;
+                link.angles_z = 51 * linknum;
+                link.angles_y = 41 * linknum;
+                link.angles_x = 31 * linknum;
+                link.avelocity = '310 410 510';
+                setmodel (link, "progs/s_spike.mdl");
+                setsize (link, '0 0 0', '0 0 0');
+                makevectors (tail.angles);
+                setorigin (link, head.origin + ( ( ( tail.origin 
+                        + (v_up * 16 * (!tail.button2)) + ( v_forward * 16 ) ) - head.origin )
+                        * ( link.weapon ) ) );
+                link.nextthink = time + 0.01;
+                link.think = LinkPos;
+                linknum = linknum - 1;
+        }
+        return link;
+};
+
+
+/************\
+* HookVanish *
+\************/
+
+void () HookVanish =
+{
+        self.owner.hook_out = FALSE;
+/*
+        if (self.enemy.classname == "player")
+                self.enemy.attack_finished = time + 0.1;
+*/
+        BreakChain (self);
+        remove (self);
+};
+
+/**********\
+* HookPull *
+\**********/
+
+void () HookPull =
+{
+        local vector vel, spray;
+        local float v;
+
+	if ((!self.owner.button0 && (self.owner.weapon == IT_HOOK)) ||
+		(self.owner.teleport_time > time ) || self.owner.deadflag ) {
+		HookVanish();
+		return;
+	} else {
+		 if (self.enemy.takedamage) {
+			// don't hurt teammates
+			if (self.enemy.classname != "player" || !teamplay ||
+				self.enemy.team != self.owner.team) {
+				sound (self, CHAN_WEAPON, "blob/land1.wav", 1, ATTN_NORM);
+				T_Damage (self.enemy, self, self.owner, 1);
+				makevectors (self.v_angle);
+				spray_x = 100 * crandom();
+				spray_y = 100 * crandom();
+				spray_z = 100 * crandom() + 50;
+				SpawnBlood (self.origin, spray, 20);
+			}
+			if (self.enemy.solid == SOLID_SLIDEBOX) {
+					self.velocity = '0 0 0';
+					setorigin (self, self.enemy.origin +
+							self.enemy.mins +
+							(self.enemy.size * 0.5));
+			} else {
+					self.velocity = self.enemy.velocity;
+			}
+		} else {
+				self.velocity = self.enemy.velocity;
+		}
+		if (self.enemy.solid == SOLID_NOT) {
+				HookVanish();
+				return;
+		}
+		makevectors (self.owner.angles);
+		vel = self.origin - ( self.owner.origin + (v_up * 16 *
+				(!self.owner.button2)) + (v_forward * 16));
+		v = vlen (vel);
+		if (v <= 100)
+				vel = normalize(vel) * v * 10;  
+		if ( v > 100 )
+				vel = normalize(vel) * 1000;  
+		self.owner.velocity = vel;
+		self.nextthink = time + 0.1;
+	}
+};
+
+/**************\
+* T_ChainTouch *
+\**************/
+
+void() T_ChainTouch =
+{
+        if (other == self.owner)
+                return;         // don't attach to owner
+
+	if (pointcontents(self.origin) == CONTENT_SKY) {
+                HookVanish();
+                return;
+	}
+
+        if (other.takedamage) {
+				// don't damage teammates
+				if (other.classname != "player" || !teamplay ||
+					other.team != self.owner.team) {
+					T_Damage (other, self, self.owner, 10 );
+					SpawnBlood (self.origin, self.velocity, 10);
+				}
+        } else {
+                self.avelocity = '0 0 0';
+        }
+                
+      sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);
+
+        if (!self.owner.button0) {
+                HookVanish();
+                return;
+        } else {
+                if (other.solid == SOLID_SLIDEBOX) {
+                        setorigin (self, other.origin + other.mins +
+                                (other.size * 0.5));
+                        self.velocity = '0 0 0';
+                } else {
+                        self.velocity = other.velocity;
+                }
+                self.weapon = other.nextthink - time;
+                self.enemy = other;
+                self.nextthink = time + 0.1;
+                self.think = HookPull;
+                self.touch = SUB_Null;
+        }
+};
+
+/*************\
+* W_FireChain *
+\*************/
+
+void() W_FireChain =
+{
+        local entity hook;
+
+        self.hook_out = TRUE;
+        hook = spawn ();
+        hook.owner = self;
+        hook.movetype = MOVETYPE_FLY;
+        hook.solid = SOLID_BBOX;
+		
+// set hook speed 
+
+        makevectors (self.v_angle);
+        hook.velocity = aim(self, 1000);
+        hook.velocity = hook.velocity * 1000;
+        hook.angles = vectoangles(hook.velocity);
+        hook.avelocity = '0 0 -500';
+	
+        hook.touch = T_ChainTouch;
+	
+// set hook sound
+        hook.nextthink = time + 5;
+        hook.think = HookVanish;
+
+        setmodel (hook, "progs/v_spike.mdl");
+        setsize (hook, '0 0 0', '0 0 0');     
+        setorigin (hook, self.origin + (v_forward*16) + '0 0 16' );
+
+        hook.goalentity = MakeChain (hook, self, 2);
+};
diff -ur --new-file v106qc/client.qc kalq-src/client.qc
--- v106qc/client.qc	Sun Sep 29 23:29:00 1996
+++ kalq-src/client.qc	Fri Oct 25 00:18:38 1996
@@ -32,12 +32,6 @@
 
 void() SetChangeParms =
 {
-	if (self.health <= 0)
-	{
-		SetNewParms ();
-		return;
-	}
-
 // remove items
 	self.items = self.items - (self.items & 
 	(IT_KEY1 | IT_KEY2 | IT_INVISIBILITY | IT_INVULNERABILITY | IT_SUIT | IT_QUAD) );
@@ -69,7 +63,7 @@
 	parm4 = 25;
 	parm5 = 0;
 	parm6 = 0;
-	parm7 = 0;
+	parm6 = 0;
 	parm8 = 1;
 	parm9 = 0;
 };
@@ -294,17 +288,13 @@
 	if (other.classname != "player")
 		return;
 
-	if ((cvar("noexit") == 1) || ((cvar("noexit") == 2) && (mapname != "start")))
+	if (cvar("noexit"))
 	{
 		T_Damage (other, self, self, 50000);
 		return;
 	}
-
-	if (coop || deathmatch)
-	{
-		bprint (other.netname);
-		bprint (" exited the level\n");
-	}
+	bprint (other.netname);
+	bprint (" exited the level\n");
 	
 	nextmap = self.map;
 
@@ -407,8 +397,6 @@
 entity() SelectSpawnPoint =
 {
 	local	entity spot;
-	local	entity thing;
-	local	float  pcount;
 	
 // testinfo_player_start is only found in regioned levels
 	spot = find (world, classname, "testplayerstart");
@@ -426,29 +414,11 @@
 	}
 	else if (deathmatch)
 	{
-		spot = lastspawn;
-		while (1)
-		{
-			spot = find(spot, classname, "info_player_deathmatch");
-			if (spot != world)
-			{
-				if (spot == lastspawn)
-					return lastspawn;
-				pcount = 0;
-				thing = findradius(spot.origin, 32);
-				while(thing)
-				{
-					if (thing.classname == "player")
-						pcount = pcount + 1;
-					thing = thing.chain;
-				}
-				if (pcount == 0)
-				{
-					lastspawn = spot;
-					return spot;
-				}
-			}
-		}
+		lastspawn = find(lastspawn, classname, "info_player_deathmatch");
+		if (lastspawn == world)
+			lastspawn = find (lastspawn, classname, "info_player_deathmatch");
+		if (lastspawn != world)
+			return lastspawn;
 	}
 
 	if (serverflags)
@@ -480,8 +450,6 @@
 {
 	local	entity spot;
 
-	spot = SelectSpawnPoint ();
-
 	self.classname = "player";
 	self.health = 100;
 	self.takedamage = DAMAGE_AIM;
@@ -509,9 +477,9 @@
 	
 	self.deadflag = DEAD_NO;
 // paustime is set by teleporters to keep the player from moving a while
-	self.pausetime = 0;
+        self.pausetime = 0;
 	
-//	spot = SelectSpawnPoint ();
+	spot = SelectSpawnPoint ();
 
 	self.origin = spot.origin + '0 0 1';
 	self.angles = spot.angles;
@@ -594,60 +562,98 @@
 ===============================================================================
 */
 
-/*
-go to the next level for deathmatch
-only called if a time or frag limit has expired
-*/
-void() NextLevel =
+void(entity c) PrintClientScore =
 {
-	local entity o;
+	if (c.frags > -10 && c.frags < 0)
+		bprint (" ");
+	else if (c.frags >= 0)
+	{
+		if (c.frags < 100)
+			bprint (" ");
+		if (c.frags < 10)
+			bprint (" ");
+	}
+	bprint (ftos(c.frags));
+	bprint (" ");
+	bprint (c.netname);
+	bprint ("\n");
+};
 
-	if (mapname == "start")
+void() DumpScore =
+{
+	local entity	e, sort, walk;
+
+	if (world.chain)
+		error ("DumpScore: world.chain is set");
+
+// build a sorted lis
+	e = find(world, classname, "player");
+	sort = world;
+	while (e)
 	{
-		if (!cvar("registered"))
-		{
-			mapname = "e1m1";
-		}
-		else if (!(serverflags & 1))
-		{
-			mapname = "e1m1";
-			serverflags = serverflags | 1;
-		}
-		else if (!(serverflags & 2))
-		{
-			mapname = "e2m1";
-			serverflags = serverflags | 2;
-		}
-		else if (!(serverflags & 4))
+		if (!sort)
 		{
-			mapname = "e3m1";
-			serverflags = serverflags | 4;
+			sort = e;
+			e.chain = world;
 		}
-		else if (!(serverflags & 8))
+		else
 		{
-			mapname = "e4m1";
-			serverflags = serverflags - 7;
+			if (e.frags > sort.frags)
+			{
+				e.chain = sort;
+				sort = e;
+			}
+			else
+			{
+				walk = sort;
+				do
+				{
+					if (!walk.chain)
+					{
+						e.chain = world;
+						walk.chain = e;
+					}
+					else if (walk.chain.frags < e.frags)
+					{
+						e.chain = walk.chain;
+						walk.chain = e;
+					}
+					else
+						walk = walk.chain;
+				} while (walk.chain != e);
+			}
 		}
-
-		o = spawn();
-		o.map = mapname;
+		
+		e = find(e, classname, "player");
 	}
-	else
+
+// print the list
+	
+	bprint ("\n");	
+	while (sort)
 	{
-		// find a trigger changelevel
-		o = find(world, classname, "trigger_changelevel");
+		PrintClientScore (sort);
+		sort = sort.chain;
+	}
+	bprint ("\n");
+};
 
-		// go back to start if no trigger_changelevel
-		if (!o)
-		{
-			mapname = "start";
-			o = spawn();
-			o.map = mapname;
-		}
+/*
+go to the next level for deathmatch
+*/
+void() NextLevel =
+{
+	local entity o;
+
+// find a trigger changelevel
+	o = find(world, classname, "trigger_changelevel");
+	if (!o || mapname == "start")
+	{	// go back to same map if no trigger_changelevel
+		o = spawn();
+		o.map = mapname;
 	}
 
 	nextmap = o.map;
-	gameover = TRUE;
 	
 	if (o.nextthink < time)
 	{
@@ -676,13 +682,31 @@
 	
 	if (timelimit && time >= timelimit)
 	{
-		NextLevel ();
+NextLevel ();
+/*
+		gameover = TRUE;
+		bprint ("\n\n\n==============================\n");
+		bprint ("game exited after ");
+		bprint (ftos(timelimit/60));
+		bprint (" minutes\n");
+		DumpScore ();
+		localcmd ("killserver\n");
+*/
 		return;
 	}
 	
 	if (fraglimit && self.frags >= fraglimit)
 	{
-		NextLevel ();
+NextLevel ();
+/*
+		gameover = TRUE;
+		bprint ("\n\n\n==============================\n");
+		bprint ("game exited after ");
+		bprint (ftos(self.frags));
+		bprint (" frags\n");
+		DumpScore ();
+		localcmd ("killserver\n");
+*/
 		return;
 	}	
 };
@@ -726,6 +750,11 @@
 
 void() PlayerJump =
 {
+/*
+        if (self.isfeign)       // experimental
+                return;
+//      Can jump as a Corpse (while Feigning).
+*/
 	local vector start, end;
 	
 	if (self.flags & FL_WATERJUMP)
@@ -788,7 +817,8 @@
 
 	if (self.waterlevel != 3)
 	{
-		if (self.air_finished < time)
+                if (self.isfeign) return;
+        	if (self.air_finished < time)
 			sound (self, CHAN_VOICE, "player/gasp2.wav", 1, ATTN_NORM);
 		else if (self.air_finished < time + 9)
 			sound (self, CHAN_VOICE, "player/gasp1.wav", 1, ATTN_NORM);
@@ -797,7 +827,8 @@
 	}
 	else if (self.air_finished < time)
 	{	// drown!
-		if (self.pain_finished < time)
+                if (self.isfeign) return;
+                if (self.pain_finished < time)
 		{
 			self.dmg = self.dmg + 2;
 			if (self.dmg > 15)
@@ -832,7 +863,8 @@
 	}
 	else if (self.watertype == CONTENT_SLIME)
 	{	// do damage
-		if (self.dmgtime < time && self.radsuit_finished < time)
+                if (self.isfeign) return;
+                if (self.dmgtime < time && self.radsuit_finished < time)
 		{
 			self.dmgtime = time + 1;
 			T_Damage (self, world, world, 4*self.waterlevel);
@@ -849,7 +881,8 @@
 		if (self.watertype == CONTENT_WATER)
 			sound (self, CHAN_BODY, "player/inh2o.wav", 1, ATTN_NORM);
 		if (self.watertype == CONTENT_SLIME)
-			sound (self, CHAN_BODY, "player/slimbrn2.wav", 1, ATTN_NORM);
+                        if (self.isfeign) return;
+                        sound (self, CHAN_BODY, "player/slimbrn2.wav", 1, ATTN_NORM);
 
 		self.flags = self.flags + FL_INWATER;
 		self.dmgtime = 0;
@@ -937,12 +970,6 @@
 // teleporters can force a non-moving pause time	
 	if (time < self.pausetime)
 		self.velocity = '0 0 0';
-
-	if(time > self.attack_finished && self.currentammo == 0 && self.weapon != IT_AXE)
-	{
-		self.weapon = W_BestWeapon ();
-		W_SetCurrentAmmo ();
-	}
 };
 	
 /*
@@ -1236,25 +1263,12 @@
 					bprint (" discharges into the water.\n");
 					return;
 				}
-				if (targ.weapon == IT_GRENADE_LAUNCHER)
+				if (targ.weapon == 16)
 					bprint (" tries to put the pin back in\n");
-				else
+				else if (rnum)
 					bprint (" becomes bored with life\n");
-				return;
-			}
-			else if ( (teamplay == 2) && (targ.team > 0)&&(targ.team == attacker.team) )
-			{
-				if (rnum < 0.25)
-					deathstring = " mows down a teammate\n";
-				else if (rnum < 0.50)
-					deathstring = " checks his glasses\n";
-				else if (rnum < 0.75)
-					deathstring = " gets a frag for the other team\n";
 				else
-					deathstring = " loses another friend\n";
-				bprint (attacker.netname);
-				bprint (deathstring);
-				attacker.frags = attacker.frags - 1;
+					bprint (" checks if his weapon is loaded\n");
 				return;
 			}
 			else
@@ -1324,10 +1338,40 @@
 		}
 		else
 		{
-			targ.frags = targ.frags - 1;
+			targ.frags = targ.frags - 1;		// killed self
+			rnum = targ.watertype;
+
 			bprint (targ.netname);
+			if (rnum == -3)
+			{
+				if (random() < 0.5)
+					bprint (" sleeps with the fishes\n");
+				else
+					bprint (" sucks it down\n");
+				return;
+			}
+			else if (rnum == -4)
+			{
+				if (random() < 0.5)
+					bprint (" gulped a load of slime\n");
+				else
+					bprint (" can't exist on slime alone\n");
+				return;
+			}
+			else if (rnum == -5)
+			{
+				if (targ.health < -15)
+				{
+					bprint (" burst into flames\n");
+					return;
+				}
+				if (random() < 0.5)
+					bprint (" turned into hot slag\n");
+				else
+					bprint (" visits the Volcano God\n");
+				return;
+			}
 
-			// killed by a montser?
 			if (attacker.flags & FL_MONSTER)
 			{
 				if (attacker.classname == "monster_army")
@@ -1365,8 +1409,6 @@
 
 				return;
 			}
-
-			// tricks and traps
 			if (attacker.classname == "explo_box")
 			{
 				bprint (" blew up\n");
@@ -1377,6 +1419,12 @@
 				bprint (" was squished\n");
 				return;
 			}
+			if (targ.deathtype == "falling")
+			{
+				targ.deathtype = "";
+				bprint (" fell to his death\n");
+				return;
+			}
 			if (attacker.classname == "trap_shooter" || attacker.classname == "trap_spikeshooter")
 			{
 				bprint (" was spiked\n");
@@ -1393,47 +1441,6 @@
 				return;
 			}
 
-			// in-water deaths
-			rnum = targ.watertype;
-			if (rnum == -3)
-			{
-				if (random() < 0.5)
-					bprint (" sleeps with the fishes\n");
-				else
-					bprint (" sucks it down\n");
-				return;
-			}
-			else if (rnum == -4)
-			{
-				if (random() < 0.5)
-					bprint (" gulped a load of slime\n");
-				else
-					bprint (" can't exist on slime alone\n");
-				return;
-			}
-			else if (rnum == -5)
-			{
-				if (targ.health < -15)
-				{
-					bprint (" burst into flames\n");
-					return;
-				}
-				if (random() < 0.5)
-					bprint (" turned into hot slag\n");
-				else
-					bprint (" visits the Volcano God\n");
-				return;
-			}
-
-			// fell to their death?
-			if (targ.deathtype == "falling")
-			{
-				targ.deathtype = "";
-				bprint (" fell to his death\n");
-				return;
-			}
-
-			// hell if I know; he's just dead!!!
 			bprint (" died\n");
 		}
 	}
diff -ur --new-file v106qc/defs.qc kalq-src/defs.qc
--- v106qc/defs.qc	Thu Sep 26 11:15:38 1996
+++ kalq-src/defs.qc	Fri Oct 25 05:49:58 1996
@@ -89,6 +89,13 @@
 void		end_sys_globals;		// flag for structure dumping
 //================================================
 
+// MODIFIED: Wisp global constants
+
+float           WISP_HUNT       =0;
+float           WISP_APPROACH   =1;
+float           WISP_HALT       =2;
+float           WISP_ATTACK     =3;
+
 /*
 ==============================================================================
 
@@ -211,6 +218,15 @@
 void		end_sys_fields;			// flag for structure dumping
 //================================================
 
+// MODIFIED: Fields for Wisp
+
+.entity         wisp;
+.float          wisp_flag;
+.float          wisp_state;
+.float          wisp_view;
+.vector         wisp_porg;
+.float          wisp_stuck;
+
 /*
 ==============================================================================
 
@@ -283,6 +299,7 @@
 
 // items
 float	IT_AXE					= 4096;
+float   IT_HOOK                                 = 4198400;
 float	IT_SHOTGUN				= 1;
 float	IT_SUPER_SHOTGUN		= 2;
 float	IT_NAILGUN				= 4;
@@ -291,6 +308,10 @@
 float	IT_ROCKET_LAUNCHER		= 32;
 float	IT_LIGHTNING			= 64;
 float	IT_EXTRA_WEAPON			= 128;
+float	IT_FIREWALL			= 8388608;
+float	IT_BOMB				= 16777216;
+float	IT_GIBGUN			= 33554432;
+float   IT_TRACTOR_BEAM                 = 128;
 
 float	IT_SHELLS				= 256;
 float	IT_NAILS				= 512;
@@ -461,6 +482,8 @@
 
 .float 		attack_finished;
 .float		pain_finished;
+.float          hook_out;
+
 
 .float		invincible_finished;
 .float		invisible_finished;
@@ -509,6 +532,7 @@
 //
 .float 		pausetime;
 .entity 	movetarget;
+.float          hooked;
 
 
 //
@@ -690,4 +714,9 @@
 
 float(entity targ, entity inflictor) CanDamage;
 
+
+.entity teledrop_dest;
+.float tele_dropped;
+.entity telebomb;
+.float telebomb_dropped;
 
diff -ur --new-file v106qc/feign.qc kalq-src/feign.qc
--- v106qc/feign.qc	Thu Jan  1 00:00:00 1970
+++ kalq-src/feign.qc	Wed Oct 23 00:55:56 1996
@@ -0,0 +1,156 @@
+// This is my poor attempt to add something useful 
+
+// Globals
+
+.float isfeign;
+.string oldweaponmodel;         // change to local?
+.float oldweapon;               // change to local?
+
+// Frames
+//
+//      I had to re-init them all to be able to call them.
+// If I had this function in player.qc, this wouldn't be
+// necessary, but then it would be less modular.
+
+$cd /raid/quake/id1/models/player_4
+$origin 0 -6 24
+$base base		
+$skin skin
+
+$frame axrun1 axrun2 axrun3 axrun4 axrun5 axrun6
+$frame rockrun1 rockrun2 rockrun3 rockrun4 rockrun5 rockrun6
+$frame stand1 stand2 stand3 stand4 stand5
+$frame axstnd1 axstnd2 axstnd3 axstnd4 axstnd5 axstnd6
+$frame axstnd7 axstnd8 axstnd9 axstnd10 axstnd11 axstnd12
+$frame axpain1 axpain2 axpain3 axpain4 axpain5 axpain6
+$frame pain1 pain2 pain3 pain4 pain5 pain6
+$frame axdeth1 axdeth2 axdeth3 axdeth4 axdeth5 axdeth6
+$frame axdeth7 axdeth8 axdeth9
+$frame deatha1 deatha2 deatha3 deatha4 deatha5 deatha6 deatha7 deatha8
+$frame deatha9 deatha10 deatha11
+$frame deathb1 deathb2 deathb3 deathb4 deathb5 deathb6 deathb7 deathb8
+$frame deathb9
+$frame deathc1 deathc2 deathc3 deathc4 deathc5 deathc6 deathc7 deathc8
+$frame deathc9 deathc10 deathc11 deathc12 deathc13 deathc14 deathc15
+$frame deathd1 deathd2 deathd3 deathd4 deathd5 deathd6 deathd7
+$frame deathd8 deathd9
+$frame deathe1 deathe2 deathe3 deathe4 deathe5 deathe6 deathe7
+$frame deathe8 deathe9
+$frame nailatt1 nailatt2
+$frame light1 light2
+$frame rockatt1 rockatt2 rockatt3 rockatt4 rockatt5 rockatt6
+$frame shotatt1 shotatt2 shotatt3 shotatt4 shotatt5 shotatt6
+$frame axatt1 axatt2 axatt3 axatt4 axatt5 axatt6
+$frame axattb1 axattb2 axattb3 axattb4 axattb5 axattb6
+$frame axattc1 axattc2 axattc3 axattc4 axattc5 axattc6
+$frame axattd1 axattd2 axattd3 axattd4 axattd5 axattd6
+
+
+// Falling down animation.  Any would have done.
+
+void()  player_feigna1    =       [       $deatha1,       player_feigna2    ] {};
+void()  player_feigna2    =       [       $deatha2,       player_feigna3    ] {};
+void()  player_feigna3    =       [       $deatha3,       player_feigna4    ] {};
+void()  player_feigna4    =       [       $deatha4,       player_feigna5    ] {};
+void()  player_feigna5    =       [       $deatha5,       player_feigna6    ] {};
+void()  player_feigna6    =       [       $deatha6,       player_feigna7    ] {};
+void()  player_feigna7    =       [       $deatha7,       player_feigna8    ] {};
+void()  player_feigna8    =       [       $deatha8,       player_feigna9    ] {};
+void()  player_feigna9    =       [       $deatha9,       player_feigna10   ] {};
+void()  player_feigna10   =       [       $deatha10,      player_feigna11   ] {};
+void()  player_feigna11   =       [       $deatha11,      player_feigna11   ] {};
+
+
+// Standing up animation.  This one looks the best.
+
+void()  player_upa1    =       [       $deathd9,        player_upa2    ] {};
+void()  player_upa2    =       [       $deathd8,        player_upa3    ] {};
+void()  player_upa3    =       [       $deathd7,        player_upa4    ] {};
+void()  player_upa4    =       [       $deathd6,        player_upa5    ] {};
+void()  player_upa5    =       [       $deathd5,        player_upa6    ] {};
+void()  player_upa6    =       [       $deathd4,        player_upa7    ] {};
+void()  player_upa7    =       [       $deathd3,        player_upa8    ] {};
+void()  player_upa8    =       [       $deathd2,        player_upa9    ] {};
+void()  player_upa9    =       [       $deathd1,        player_upa9    ] {player_stand1 ();};
+
+
+//      I had to make new backpack routines so that you wouldn't give up 
+// your ammo, pick it up while you're throwing it, and have a neat message.
+
+void() FakeBackpackTouch =
+{
+        if (self.isfeign) return;
+
+        if (other.classname != "player")        // Monsters won't pick up
+		return;
+        if (other.health <= 0)                  // Dead people won't pick up
+		return;
+//      if ( (self.owner == other) && ( (self.nextthink - time) > 99 ) )        // The thrower won't pick up
+                return;                                                         // unless 20 sec has passed.
+
+        sprint (other, "Hmmmm, empty...\n");
+        sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);    // backpack touch sound
+        stuffcmd (other, "bf\n");       // flashes the screen
+	remove(self);
+	
+};
+
+
+void() FakeBackpack =
+{
+	local entity	item;
+
+	item = spawn();
+        item.owner = self;
+        item.origin = self.origin - '0 0 24';
+	item.velocity_z = 300;
+	item.velocity_x = -100 + (random() * 200);
+	item.velocity_y = -100 + (random() * 200);
+	item.flags = FL_ITEM;
+	item.solid = SOLID_TRIGGER;
+        item.movetype = MOVETYPE_TOSS;
+	setmodel (item, "progs/backpack.mdl");
+	setsize (item, '-16 -16 0', '16 16 56');
+        item.touch = FakeBackpackTouch;
+	item.nextthink = time + 120;	// remove after 2 minutes
+	item.think = SUB_Remove;
+};
+
+void() feign =
+{
+        if (!self.isfeign)              // If not already, feign death
+        {
+                player_feigna1 ();      // death animation
+                FakeBackpack();         // throw fake backpack
+//              setsize (self , '-16 -16 -4' , '16 16 4');      // change bounding bos so you're shorter
+                self.view_ofs = '0 0 2';        // put view near ground
+                DeathSound();           // yell like you're dying
+                self.modelindex = modelindex_eyes;
+/*
+                self.oldweapon = self.weapon;
+                self.weapon = 0;
+                self.oldweaponmodel = self.weaponmodel;
+                self.weaponmodel = "";
+*/
+//              self.movetype = MOVETYPE_TOSS;
+                self.movetype = MOVETYPE_WALK;
+                self.isfeign = TRUE;
+        }
+
+        else                    // otherwise, get up
+
+        {
+                self.movetype = MOVETYPE_WALK;
+//              setsize (self, VEC_HULL_MIN, VEC_HULL_MAX);
+                self.view_ofs = '0 0 22';
+                self.model = "progs/player.mdl";
+/*
+                self.weaponmodel = self.oldweaponmodel;
+                self.weapon = self.oldweapon;
+                self.oldweapon = 0;
+*/
+                self.isfeign = FALSE;
+                player_upa1();
+        }
+};
+
diff -ur --new-file v106qc/items.qc kalq-src/items.qc
--- v106qc/items.qc	Thu Sep 26 11:15:38 1996
+++ kalq-src/items.qc	Tue Oct 22 15:02:16 1996
@@ -2,9 +2,36 @@
 /* ALL LIGHTS SHOULD BE 0 1 0 IN COLOR ALL OTHER ITEMS SHOULD
 BE .8 .3 .4 IN COLOR */
 
+entity item_to_exchange;
+void(float exchange) SUB_Withdraw = {
+	local vector temp;
+
+	if(exchange) {
+		if(item_to_exchange) {
+//			dprint(self.classname);
+//			dprint(" moved from ");
+//			dprint(vtos(self.origin));
+//			dprint(" to ");
+//			dprint(vtos(spare_item_origin));
+//			dprint("\n");
+			temp=self.origin;
+			self.origin=item_to_exchange.origin;
+			item_to_exchange.origin=temp;
+			item_to_exchange=world;
+		} else {
+			item_to_exchange=self;
+		}
+	}
+
+	self.model = string_null;
+	self.solid = SOLID_NOT;
+};
 
 void() SUB_regen =
 {
+	if(item_to_exchange == self) { // Didn't get exchanged
+		item_to_exchange = world;
+	}
 	self.model = self.mdl;		// restore original model
 	self.solid = SOLID_TRIGGER;	// allow it to be touched again
 	sound (self, CHAN_VOICE, "items/itembk2.wav", 1, ATTN_NORM);	// play respawn sound
@@ -178,8 +205,7 @@
 
 	stuffcmd (other, "bf\n");
 	
-	self.model = string_null;
-	self.solid = SOLID_NOT;
+	SUB_Withdraw(1);
 
 	// Megahealth = rot down the player's super health
 	if (self.healtype == 2)
@@ -269,8 +295,7 @@
 	other.armorvalue = value;
 	other.items = other.items - (other.items & (IT_ARMOR1 | IT_ARMOR2 | IT_ARMOR3)) + bit;
 
-	self.solid = SOLID_NOT;
-	self.model = string_null;
+	SUB_Withdraw(1);
 	if (deathmatch == 1)
 		self.nextthink = time + 20;
 	self.think = SUB_regen;
@@ -489,8 +514,8 @@
 		return;
 
 // remove it in single player, or setup for respawning in deathmatch
-	self.model = string_null;
-	self.solid = SOLID_NOT;
+	
+	SUB_Withdraw(1);
 	if (deathmatch == 1)
 		self.nextthink = time + 30;
 	self.think = SUB_regen;
@@ -638,7 +663,7 @@
 //	cells
 	if (self.weapon == 4)
 	{
-		if (other.ammo_cells >= 100)
+		if (other.ammo_cells >= 200)
 			return;
 		other.ammo_cells = other.ammo_cells + self.aflag;
 	}
@@ -670,10 +695,11 @@
 	self = stemp;
 
 // remove it in single player, or setup for respawning in deathmatch
-	self.model = string_null;
-	self.solid = SOLID_NOT;
+
+	SUB_Withdraw(1);
 	if (deathmatch == 1)
 		self.nextthink = time + 30;
+	
 	self.think = SUB_regen;
 
 	activator = other;
@@ -697,15 +723,16 @@
 		precache_model ("maps/b_shell1.bsp");
 		setmodel (self, "maps/b_shell1.bsp");
 		self.aflag = 40;
+		self.netname = "box of shells";
 	}
 	else
 	{
 		precache_model ("maps/b_shell0.bsp");
 		setmodel (self, "maps/b_shell0.bsp");
 		self.aflag = 20;
+		self.netname = "shells";
 	}
 	self.weapon = 1;
-	self.netname = "shells";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
 };
@@ -722,15 +749,16 @@
 		precache_model ("maps/b_nail1.bsp");
 		setmodel (self, "maps/b_nail1.bsp");
 		self.aflag = 50;
+		self.netname = "crate of nails";
 	}
 	else
 	{
 		precache_model ("maps/b_nail0.bsp");
 		setmodel (self, "maps/b_nail0.bsp");
 		self.aflag = 25;
+		self.netname = "nails";
 	}
 	self.weapon = 2;
-	self.netname = "nails";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
 };
@@ -747,15 +775,16 @@
 		precache_model ("maps/b_rock1.bsp");
 		setmodel (self, "maps/b_rock1.bsp");
 		self.aflag = 10;
+		self.netname = "box of rockets";
 	}
 	else
 	{
 		precache_model ("maps/b_rock0.bsp");
 		setmodel (self, "maps/b_rock0.bsp");
 		self.aflag = 5;
+		self.netname = "rockets";
 	}
 	self.weapon = 3;
-	self.netname = "rockets";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
 };
@@ -773,15 +802,16 @@
 		precache_model ("maps/b_batt1.bsp");
 		setmodel (self, "maps/b_batt1.bsp");
 		self.aflag = 12;
+		self.netname = "battery pack";
 	}
 	else
 	{
 		precache_model ("maps/b_batt0.bsp");
 		setmodel (self, "maps/b_batt0.bsp");
 		self.aflag = 6;
+		self.netname = "cells";
 	}
 	self.weapon = 4;
-	self.netname = "cells";
 	setsize (self, '0 0 0', '32 32 56');
 	StartItem ();
 };
@@ -888,8 +918,7 @@
 
 	if (!coop)
 	{	
-		self.solid = SOLID_NOT;
-		self.model = string_null;
+		SUB_Withdraw(1);
 	}
 
 	activator = other;
@@ -1016,8 +1045,7 @@
 
 	sound (other, CHAN_ITEM, self.noise, 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
-	self.solid = SOLID_NOT;
-	self.model = string_null;
+	SUB_Withdraw(1);
 	serverflags = serverflags | (self.spawnflags & 15);
 	self.classname = "";		// so rune doors won't find it
 	
@@ -1104,33 +1132,35 @@
 
 	sound (other, CHAN_VOICE, self.noise, 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
-	self.solid = SOLID_NOT;
 	other.items = other.items | self.items;
-	self.model = string_null;
 
 // do the apropriate action
 	if (self.classname == "item_artifact_envirosuit")
 	{
 		other.rad_time = 1;
 		other.radsuit_finished = time + 30;
+		SUB_Withdraw(0); // Leave envirosuit, it's there for a reason
 	}
 	
 	if (self.classname == "item_artifact_invulnerability")
 	{
 		other.invincible_time = 1;
 		other.invincible_finished = time + 30;
+		SUB_Withdraw(1);
 	}
 	
 	if (self.classname == "item_artifact_invisibility")
 	{
 		other.invisible_time = 1;
 		other.invisible_finished = time + 30;
+		SUB_Withdraw(1);
 	}
 
 	if (self.classname == "item_artifact_super_damage")
 	{
 		other.super_time = 1;
 		other.super_damage_finished = time + 30;
+		SUB_Withdraw(1);
 	}	
 
 	activator = other;
@@ -1229,26 +1259,14 @@
 void() BackpackTouch =
 {
 	local string	s;
-	local	float	best, old, new;
+	local	float	best;
 	local		entity	stemp;
-	local	float	acount;
 	
 	if (other.classname != "player")
 		return;
 	if (other.health <= 0)
 		return;
-
-	acount = 0;
-	sprint (other, "You get ");
-
-	if (self.items)
-		if ((other.items & self.items) == 0)
-		{
-			acount = 1;
-			sprint (other, "the ");
-			sprint (other, self.netname);
-		}
-
+		
 // if the player was using his best weapon, change up to the new one if better		
 	stemp = self;
 	self = other;
@@ -1261,49 +1279,35 @@
 	other.ammo_rockets = other.ammo_rockets + self.ammo_rockets;
 	other.ammo_cells = other.ammo_cells + self.ammo_cells;
 
-	new = self.items;
-	if (!new)
-		new = other.weapon;
-	old = other.items;
-	other.items = other.items | new;
+	other.items = other.items | self.items;
 	
 	bound_other_ammo ();
 
+	sprint (other, "You get ");
+
 	if (self.ammo_shells)
 	{
-		if (acount)
-			sprint(other, ", ");
-		acount = 1;
 		s = ftos(self.ammo_shells);
 		sprint (other, s);
-		sprint (other, " shells");
+		sprint (other, " shells  ");
 	}
 	if (self.ammo_nails)
 	{
-		if (acount)
-			sprint(other, ", ");
-		acount = 1;
 		s = ftos(self.ammo_nails);
 		sprint (other, s);
-		sprint (other, " nails");
+		sprint (other, " nails ");
 	}
 	if (self.ammo_rockets)
 	{
-		if (acount)
-			sprint(other, ", ");
-		acount = 1;
 		s = ftos(self.ammo_rockets);
 		sprint (other, s);
-		sprint (other, " rockets");
+		sprint (other, " rockets  ");
 	}
 	if (self.ammo_cells)
 	{
-		if (acount)
-			sprint(other, ", ");
-		acount = 1;
 		s = ftos(self.ammo_cells);
 		sprint (other, s);
-		sprint (other, " cells");
+		sprint (other, " cells  ");
 	}
 	
 	sprint (other, "\n");
@@ -1311,16 +1315,19 @@
 	sound (other, CHAN_ITEM, "weapons/lock4.wav", 1, ATTN_NORM);
 	stuffcmd (other, "bf\n");
 
-// remove the backpack, change self to the player
+// change to a better weapon if appropriate
+	if ( other.weapon == best )
+	{
+		stemp = self;
+		self = other;
+		self.weapon = W_BestWeapon();
+		self = stemp;
+	}
+
+	
 	remove(self);
+	
 	self = other;
-
-// change to the weapon
-	if (!deathmatch)
-		self.weapon = new;
-	else
-		Deathmatch_Weapon (old, new);
-
 	W_SetCurrentAmmo ();
 };
 
@@ -1340,25 +1347,8 @@
 	item.origin = self.origin - '0 0 24';
 	
 	item.items = self.weapon;
-	if (item.items == IT_AXE)
-		item.netname = "Axe";
-	else if (item.items == IT_SHOTGUN)
-		item.netname = "Shotgun";
-	else if (item.items == IT_SUPER_SHOTGUN)
-		item.netname = "Double-barrelled Shotgun";
-	else if (item.items == IT_NAILGUN)
-		item.netname = "Nailgun";
-	else if (item.items == IT_SUPER_NAILGUN)
-		item.netname = "Super Nailgun";
-	else if (item.items == IT_GRENADE_LAUNCHER)
-		item.netname = "Grenade Launcher";
-	else if (item.items == IT_ROCKET_LAUNCHER)
-		item.netname = "Rocket Launcher";
-	else if (item.items == IT_LIGHTNING)
-		item.netname = "Thunderbolt";
-	else
-		item.netname = "";
-
+	if ((item.items == IT_FIREWALL) || (item.items == IT_BOMB)) 	item.items=IT_GRENADE_LAUNCHER;
+	if (item.items == IT_GIBGUN) item.items=IT_ROCKET_LAUNCHER;
 	item.ammo_shells = self.ammo_shells;
 	item.ammo_nails = self.ammo_nails;
 	item.ammo_rockets = self.ammo_rockets;
diff -ur --new-file v106qc/player.qc kalq-src/player.qc
--- v106qc/player.qc	Thu Sep 26 11:15:40 1996
+++ kalq-src/player.qc	Fri Oct 25 01:39:36 1996
@@ -1,6 +1,9 @@
 
 void() bubble_bob;
-
+void() W_FireChain;
+void() player_chain5;
+void() player_chain4;
+                   
 /*
 ==============================================================================
 
@@ -9,7 +12,7 @@
 ==============================================================================
 */
 
-$cd id1/models/player_4
+$cd /raid/quake/id1/models/player_4
 $origin 0 -6 24
 $base base		
 $skin skin
@@ -167,6 +170,42 @@
 void()	player_axed3 =	[$axattd3, player_axed4	] {self.weaponframe=7;W_FireAxe();};
 void()	player_axed4 =	[$axattd4, player_run	] {self.weaponframe=8;};
 
+void()  player_chain1=  [$axattd1, player_chain2 ] {self.weaponframe=2;};
+void()  player_chain2=  [$axattd2, player_chain3 ] {self.weaponframe=3;W_FireChain();};
+
+void()  player_chain3=  [$axattd3, player_chain3 ]
+{
+        self.weaponframe=3;
+        if (!self.hook_out)
+        {
+                player_chain5();
+                return;
+        }
+        if (vlen(self.velocity) >= 750)
+        {
+                player_chain4();
+                return;
+        }
+};
+
+void() player_chain4=  [$deathc4, player_chain4 ]
+{
+        self.weaponframe=4;
+        if (!self.hook_out)
+        {
+                player_chain5();
+                return;
+        }
+        if (vlen(self.velocity) < 750)
+        {
+                player_chain3();
+                return;
+        }
+};
+
+void()  player_chain5=  [$axattd4, player_run    ] {self.weaponframe=5;};
+
+
 
 //============================================================================
 
@@ -342,6 +381,9 @@
 	if (self.invisible_finished > time)
 		return;		// eyes don't have pain frames
 
+        if (self.isfeign)       // experimental
+                return;
+
 	if (self.weapon == IT_AXE)
 		player_axpain1 ();
 	else
@@ -524,25 +566,28 @@
 void() PlayerDie =
 {
 	local	float	i;
-	
-	self.items = self.items - (self.items & IT_INVISIBILITY);
-	self.invisible_finished = 0;	// don't die as eyes
-	self.invincible_finished = 0;
-	self.super_damage_finished = 0;
-	self.radsuit_finished = 0;
-	self.modelindex = modelindex_player;	// don't use eyes
 
-	if (deathmatch || coop)
-		DropBackpack();
-	
-	self.weaponmodel="";
-	self.view_ofs = '0 0 -8';
-	self.deadflag = DEAD_DYING;
-	self.solid = SOLID_NOT;
-	self.flags = self.flags - (self.flags & FL_ONGROUND);
-	self.movetype = MOVETYPE_TOSS;
-	if (self.velocity_z < 10)
-		self.velocity_z = self.velocity_z + random()*300;
+        if (self.isfeign)               // experimental
+                feign;               // don't die while down
+
+        self.items = self.items - (self.items & IT_INVISIBILITY);
+        self.invisible_finished = 0;    // don't die as eyes
+//      self.tele_dropped = 0;
+        self.invincible_finished = 0;
+        self.super_damage_finished = 0;
+        self.radsuit_finished = 0;
+        self.modelindex = modelindex_player;
+
+        if (deathmatch || coop)
+              DropBackpack();
+        self.weaponmodel="";
+        self.view_ofs = '0 0 -8';
+        self.deadflag = DEAD_DYING;
+        self.solid = SOLID_NOT;
+        self.flags = self.flags - (self.flags & FL_ONGROUND);
+        self.movetype = MOVETYPE_TOSS;
+        if (self.velocity_z < 10)
+              self.velocity_z = self.velocity_z + random()*300;
 
 	if (self.health < -40)
 	{
diff -ur --new-file v106qc/progdefs.h kalq-src/progdefs.h
--- v106qc/progdefs.h	Thu Jan  1 00:00:00 1970
+++ kalq-src/progdefs.h	Fri Oct 25 06:02:04 1996
@@ -0,0 +1,143 @@
+
+/* file generated by qcc, do not modify */
+
+typedef struct
+{	int	pad[28];
+	int	self;
+	int	other;
+	int	world;
+	float	time;
+	float	frametime;
+	float	force_retouch;
+	string_t	mapname;
+	float	deathmatch;
+	float	coop;
+	float	teamplay;
+	float	serverflags;
+	float	total_secrets;
+	float	total_monsters;
+	float	found_secrets;
+	float	killed_monsters;
+	float	parm1;
+	float	parm2;
+	float	parm3;
+	float	parm4;
+	float	parm5;
+	float	parm6;
+	float	parm7;
+	float	parm8;
+	float	parm9;
+	float	parm10;
+	float	parm11;
+	float	parm12;
+	float	parm13;
+	float	parm14;
+	float	parm15;
+	float	parm16;
+	vec3_t	v_forward;
+	vec3_t	v_up;
+	vec3_t	v_right;
+	float	trace_allsolid;
+	float	trace_startsolid;
+	float	trace_fraction;
+	vec3_t	trace_endpos;
+	vec3_t	trace_plane_normal;
+	float	trace_plane_dist;
+	int	trace_ent;
+	float	trace_inopen;
+	float	trace_inwater;
+	int	msg_entity;
+	func_t	main;
+	func_t	StartFrame;
+	func_t	PlayerPreThink;
+	func_t	PlayerPostThink;
+	func_t	ClientKill;
+	func_t	ClientConnect;
+	func_t	PutClientInServer;
+	func_t	ClientDisconnect;
+	func_t	SetNewParms;
+	func_t	SetChangeParms;
+} globalvars_t;
+
+typedef struct
+{
+	float	modelindex;
+	vec3_t	absmin;
+	vec3_t	absmax;
+	float	ltime;
+	float	movetype;
+	float	solid;
+	vec3_t	origin;
+	vec3_t	oldorigin;
+	vec3_t	velocity;
+	vec3_t	angles;
+	vec3_t	avelocity;
+	vec3_t	punchangle;
+	string_t	classname;
+	string_t	model;
+	float	frame;
+	float	skin;
+	float	effects;
+	vec3_t	mins;
+	vec3_t	maxs;
+	vec3_t	size;
+	func_t	touch;
+	func_t	use;
+	func_t	think;
+	func_t	blocked;
+	float	nextthink;
+	int	groundentity;
+	float	health;
+	float	frags;
+	float	weapon;
+	string_t	weaponmodel;
+	float	weaponframe;
+	float	currentammo;
+	float	ammo_shells;
+	float	ammo_nails;
+	float	ammo_rockets;
+	float	ammo_cells;
+	float	items;
+	float	takedamage;
+	int	chain;
+	float	deadflag;
+	vec3_t	view_ofs;
+	float	button0;
+	float	button1;
+	float	button2;
+	float	impulse;
+	float	fixangle;
+	vec3_t	v_angle;
+	float	idealpitch;
+	string_t	netname;
+	int	enemy;
+	float	flags;
+	float	colormap;
+	float	team;
+	float	max_health;
+	float	teleport_time;
+	float	armortype;
+	float	armorvalue;
+	float	waterlevel;
+	float	watertype;
+	float	ideal_yaw;
+	float	yaw_speed;
+	int	aiment;
+	int	goalentity;
+	float	spawnflags;
+	string_t	target;
+	string_t	targetname;
+	float	dmg_take;
+	float	dmg_save;
+	int	dmg_inflictor;
+	int	owner;
+	vec3_t	movedir;
+	string_t	message;
+	float	sounds;
+	string_t	noise;
+	string_t	noise1;
+	string_t	noise2;
+	string_t	noise3;
+} entvars_t;
+
+#define PROGHEADER_CRC 5927
diff -ur --new-file v106qc/progs.src kalq-src/progs.src
--- v106qc/progs.src	Thu Sep 26 11:15:40 1996
+++ kalq-src/progs.src	Thu Oct 24 22:45:30 1996
@@ -6,6 +6,7 @@
 ai.qc
 combat.qc
 items.qc
+wisp.qc         // Wisp code
 weapons.qc
 world.qc
 client.qc
@@ -33,3 +34,6 @@
 shalrath.qc		// registered
 enforcer.qc		// registered
 oldone.qc		// registered
+
+chain.qc		// Grappling Hook Code
+feign.qc                // Feign Death Code
diff -ur --new-file v106qc/triggers.qc kalq-src/triggers.qc
--- v106qc/triggers.qc	Thu Sep 26 11:15:40 1996
+++ kalq-src/triggers.qc	Thu Oct 24 23:16:30 1996
@@ -359,6 +359,10 @@
 	force_retouch = 2;		// make sure even still objects get hit
 };
 
+/*
+//	REMmed out for the Teleport Weapons Patch by Kenneth Livingston
+//	aka KALWeb
+//	underhill@netpass.com
 void() teleport_touch =
 {
 local entity	t;
@@ -418,6 +422,55 @@
 	}
 	other.flags = other.flags - other.flags & FL_ONGROUND;
 };
+*/
+
+void() teleport_touch =
+{
+local entity    t;
+local vector    org;
+
+        if (self.targetname)
+        {
+                if (self.nextthink < time)
+                {
+                        return;         // not fired yet
+                }
+        }
+        
+// SLAY - Teleport weapons too!
+//      if (self.spawnflags & PLAYER_ONLY)
+//      {
+//              if (other.classname != "player")
+//                      return;
+//      }
+                        
+        SUB_UseTargets ();
+
+// put a tfog where the player was
+        spawn_tfog (other.origin);
+
+        t = find (world, targetname, self.target);
+        if (!t)
+                objerror ("couldn't find target");
+        
+// spawn a tfog flash in front of the destination
+        makevectors (t.mangle);
+        org = t.origin + 32 * v_forward;
+
+        spawn_tfog (org);
+        spawn_tdeath(t.origin, other);
+
+       
+        setorigin (other, t.origin);
+        other.angles = t.mangle;
+        other.fixangle = 1;             // turn this way immediately
+        other.teleport_time = time + 0.7;
+        if (other.flags & FL_ONGROUND)
+	        other.flags = other.flags - FL_ONGROUND;
+        other.velocity = v_forward * 300;
+        other.flags = other.flags - other.flags & FL_ONGROUND;
+};
+
 
 /*QUAKED info_teleport_destination (.5 .5 .5) (-8 -8 -8) (8 8 32)
 This is the destination marker for a teleporter.  It should have a "targetname" field with the same value as a teleporter's "target" field.
diff -ur --new-file v106qc/weapons.qc kalq-src/weapons.qc
--- v106qc/weapons.qc	Mon Sep 30 03:08:08 1996
+++ kalq-src/weapons.qc	Fri Oct 25 06:00:58 1996
@@ -1,27 +1,80 @@
 /*
+	ADDED BY KTGOW:
+
+	Teleport Dropping:  Drop a teleport destination using impulse 41,
+	  then teleport to that destination (from anywhere) using impulse 43.
+	Teleport Bombs: Fire off a Teleport Grenade using impulse 40, then
+	  detonate it and teleport to its location using impulse 44.
+	  Much of the code for telebombs was modified from the PIPEBOMB patch.
+	  Many thanks to the author of that patch.  (AWESOME work!)
+
+	What about impulse 42?
+*/
+
+/*
+Bouncing Fragmentation Grenade!    7/28/96 by Steve Bond
+Email: wedge@nuc.net    WWW: http://www.nuc.net/quake
+
+>>>READ THE README!
+
+Hey ID! 
+If you are reading this, PUH-LEEZE fly me and John to Texas!
+We'll scrub the shitters at id for the chance to shake hands!
+(I mean - we'll wash our hands first and everything)
+
 */
+
 void (entity targ, entity inflictor, entity attacker, float damage) T_Damage;
 void () player_run;
 void(entity bomb, entity attacker, float rad, entity ignore) T_RadiusDamage;
 void(vector org, vector vel, float damage) SpawnBlood;
 void() SuperDamageSound;
+void() DropTeleport;
+void() Teleport_to_drop;
+void (vector org) spawn_tfog;
+void (vector org, entity death_owner) spawn_tdeath;
+void() W_FireTeleportBomb;
+void() TeleportBombTouch;
+void() Teleport_to_bomb;
+
+float bombtimer;
+
+void() W_FireBomb;
+void() BombTouch;
+void() BombExplode;
+void() BombExplosion;
+void() ShrapnelExplode;
+void() BombTime;
+void() W_FireGIBGUN;
+void() T_GIBTouch;
+void() GIBExplode;
 
+void() feign;   // experimental
+.float isfeign; // experimental
 
 // called by worldspawn
 void() W_Precache =
 {
-	precache_sound ("weapons/r_exp3.wav");	// new rocket explosion
-	precache_sound ("weapons/rocket1i.wav");	// spike gun
+	precache_sound ("weapons/r_exp3.wav");  // new rocket explosion
+	precache_sound ("weapons/rocket1i.wav");        // spike gun
 	precache_sound ("weapons/sgun1.wav");
-	precache_sound ("weapons/guncock.wav");	// player shotgun
-	precache_sound ("weapons/ric1.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/ric2.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/ric3.wav");	// ricochet (used in c code)
-	precache_sound ("weapons/spike2.wav");	// super spikes
-	precache_sound ("weapons/tink1.wav");	// spikes tink (used in c code)
-	precache_sound ("weapons/grenade.wav");	// grenade launcher
-	precache_sound ("weapons/bounce.wav");		// grenade bounce
-	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+	precache_sound ("weapons/guncock.wav"); // player shotgun
+	precache_sound ("weapons/ric1.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/ric2.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/ric3.wav");    // ricochet (used in c code)
+	precache_sound ("weapons/spike2.wav");  // super spikes
+	precache_sound ("weapons/tink1.wav");   // spikes tink (used in c code)
+	precache_sound ("weapons/grenade.wav"); // grenade launcher
+	precache_sound ("weapons/bounce.wav");          // grenade bounce
+	precache_sound ("weapons/shotgn2.wav"); // super shotgun
+	precache_sound ("items/damage2.wav");
+	precache_sound ("player/tornoff2.wav");
+	precache_sound ("player/lburn1.wav");
+        precache_sound2 ("blob/land1.wav");     // chain go splorch!
+        precache_sound ("plats/medplat1.wav");  // chain cranking out
+        precache_sound ("doors/ddoor1.wav");    // chain cranking in
+	precache_sound ("items/protect3.wav");
+	precache_sound ("items/damage3.wav");
 };
 
 float() crandom =
@@ -36,10 +89,9 @@
 */
 void() W_FireAxe =
 {
-	local	vector	source;
-	local	vector	org;
+	local   vector  source;
+	local   vector  org;
 
-	makevectors (self.v_angle);
 	source = self.origin + '0 0 16';
 	traceline (source, source + v_forward*64, FALSE, self);
 	if (trace_fraction == 1.0)
@@ -54,7 +106,7 @@
 		T_Damage (trace_ent, self, self, 20);
 	}
 	else
-	{	// hit wall
+	{       // hit wall
 		sound (self, CHAN_WEAPON, "player/axhit2.wav", 1, ATTN_NORM);
 		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
 		WriteByte (MSG_BROADCAST, TE_GUNSHOT);
@@ -70,7 +122,7 @@
 
 vector() wall_velocity =
 {
-	local vector	vel;
+	local vector    vel;
 	
 	vel = normalize (self.velocity);
 	vel = normalize(vel + v_up*(random()- 0.5) + v_right*(random()- 0.5));
@@ -88,8 +140,8 @@
 */
 void(vector org, vector vel) SpawnMeatSpray =
 {
-	local	entity missile, mpuff;
-	local	vector	org;
+	local   entity missile, mpuff;
+	local   vector  org;
 
 	missile = spawn ();
 	missile.owner = self;
@@ -108,7 +160,7 @@
 	missile.think = SUB_Remove;
 
 	setmodel (missile, "progs/zom_gib.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, org);
 };
 
@@ -129,7 +181,7 @@
 */
 void(float damage) spawn_touchblood =
 {
-	local vector	vel;
+	local vector    vel;
 
 	vel = wall_velocity () * 0.2;
 	SpawnBlood (self.origin + vel*0.01, vel, damage);
@@ -156,8 +208,8 @@
 ==============================================================================
 */
 
-entity	multi_ent;
-float	multi_damage;
+entity  multi_ent;
+float   multi_damage;
 
 void() ClearMultiDamage =
 {
@@ -202,7 +254,7 @@
 */
 void(float damage, vector dir) TraceAttack =
 {
-	local	vector	vel, org;
+	local   vector  vel, org;
 	
 	vel = normalize(dir + v_up*crandom() + v_right*crandom());
 	vel = vel + 2*trace_plane_normal;
@@ -235,8 +287,8 @@
 */
 void(float shotcount, vector dir, vector spread) FireBullets =
 {
-	local	vector direction;
-	local	vector	src;
+	local   vector direction;
+	local   vector  src;
 	
 	makevectors(self.v_angle);
 
@@ -266,11 +318,11 @@
 {
 	local vector dir;
 
-	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM);	
+	sound (self, CHAN_WEAPON, "weapons/guncock.wav", 1, ATTN_NORM); 
 
 	self.punchangle_x = -2;
-	
-	self.currentammo = self.ammo_shells = self.ammo_shells - 1;
+
+        self.currentammo = self.ammo_shells;
 	dir = aim (self, 100000);
 	FireBullets (6, dir, '0.04 0.04 0');
 };
@@ -291,7 +343,7 @@
 		return;
 	}
 		
-	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM);	
+	sound (self ,CHAN_WEAPON, "weapons/shotgn2.wav", 1, ATTN_NORM); 
 
 	self.punchangle_x = -4;
 	
@@ -309,12 +361,12 @@
 ==============================================================================
 */
 
-void()	s_explode1	=	[0,		s_explode2] {};
-void()	s_explode2	=	[1,		s_explode3] {};
-void()	s_explode3	=	[2,		s_explode4] {};
-void()	s_explode4	=	[3,		s_explode5] {};
-void()	s_explode5	=	[4,		s_explode6] {};
-void()	s_explode6	=	[5,		SUB_Remove] {};
+void()  s_explode1      =       [0,             s_explode2] {};
+void()  s_explode2      =       [1,             s_explode3] {};
+void()  s_explode3      =       [2,             s_explode4] {};
+void()  s_explode4      =       [3,             s_explode5] {};
+void()  s_explode5      =       [4,             s_explode6] {};
+void()  s_explode6      =       [5,             SUB_Remove] {};
 
 void() BecomeExplosion =
 {
@@ -328,10 +380,10 @@
 
 void() T_MissileTouch =
 {
-	local float	damg;
+	local float     damg;
 
 	if (other == self.owner)
-		return;		// don't explode on owner
+		return;         // don't explode on owner
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -344,7 +396,7 @@
 	if (other.health)
 	{
 		if (other.classname == "monster_shambler")
-			damg = damg * 0.5;	// mostly immune
+			damg = damg * 0.5;      // mostly immune
 		T_Damage (other, self, self.owner, damg );
 	}
 
@@ -352,7 +404,7 @@
 	// was done in the impact
 	T_RadiusDamage (self, self.owner, 120, other);
 
-//	sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
+//      sound (self, CHAN_WEAPON, "weapons/r_exp3.wav", 1, ATTN_NORM);
 	self.origin = self.origin - 8*normalize(self.velocity);
 
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
@@ -373,7 +425,7 @@
 */
 void() W_FireRocket =
 {
-	local	entity missile, mpuff;
+	local   entity missile, mpuff;
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -385,9 +437,8 @@
 	missile.owner = self;
 	missile.movetype = MOVETYPE_FLYMISSILE;
 	missile.solid = SOLID_BBOX;
-	missile.classname = "missile";
 		
-// set missile speed	
+// set missile speed    
 
 	makevectors (self.v_angle);
 	missile.velocity = aim(self, 1000);
@@ -401,7 +452,7 @@
 	missile.think = SUB_Remove;
 
 	setmodel (missile, "progs/missile.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
 };
 
@@ -418,11 +469,102 @@
 LightningDamage
 =================
 */
+void() ChangeLightningMode =
+{
+        sprint(self,"Changing thunderbolt mode to ");
+        if (self.items & IT_TRACTOR_BEAM)
+        {
+                self.items = self.items - (self.items & IT_TRACTOR_BEAM);
+                sprint(self,"lightning.\n");
+        }
+        else
+        {
+                self.items = self.items | IT_TRACTOR_BEAM;
+                sprint(self,"tractor beam.\n");
+        }
+};
+
+void(vector p1, vector p2, entity from, float damage) TractorEffect =
+{
+	local entity		e1, e2;
+	local vector		f;
+
+	f = p2 - p1;
+	normalize (f);
+	f_x = 0 - f_y;
+	f_y = f_x;
+	f_z = 0;
+	f = f*16;
+
+	e1 = e2 = world;
+
+	traceline (p1, p2, FALSE, self);
+	e1 = trace_ent;
+        if (trace_ent.takedamage && trace_ent.classname != "trigger_multiple" && trace_ent.classname != "door")
+        {
+                trace_ent.origin = self.origin+v_forward*vlen(self.origin-trace_ent.origin);
+                trace_ent.movetype = MOVETYPE_TOSS;
+                trace_ent.nextthink = time + 0.5;
+	}
+
+	traceline (p1 + f, p2 + f, FALSE, self);
+        if (trace_ent != e1 && trace_ent.takedamage && trace_ent.classname != "trigger_multiple" && trace_ent.classname != "door")
+	{
+                trace_ent.origin = self.origin+v_forward*vlen(self.origin-trace_ent.origin);
+                trace_ent.movetype = MOVETYPE_TOSS;
+                trace_ent.nextthink = time + 0.5;
+	}
+	e2 = trace_ent;
+
+	traceline (p1 - f, p2 - f, FALSE, self);
+        if (trace_ent != e1 && trace_ent != e2 && trace_ent.takedamage && trace_ent.classname != "trigger_multiple" && trace_ent.classname != "door")
+	{
+                trace_ent.origin = self.origin+v_forward*vlen(self.origin-trace_ent.origin);
+                trace_ent.movetype = MOVETYPE_TOSS;
+                trace_ent.nextthink = time + 0.5;
+	}
+};
+void() W_UseTractor =
+{
+	local	vector		org;
+
+//      sprint(self,"W_UseTractor running\n");
+	if (self.ammo_cells < 1)
+	{
+		return;
+	}
+
+	if (self.t_width < time)
+	{
+		sound (self, CHAN_WEAPON, "weapons/lhit.wav", 1, ATTN_NORM);
+		self.t_width = time + 0.6;
+	}
+	self.punchangle_x = -2;
+
+//      self.currentammo = self.ammo_cells = self.ammo_cells - 1;
+
+	org = self.origin + '0 0 16';
+
+	traceline (org, org + v_forward*600, TRUE, self);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LIGHTNING2);
+	WriteEntity (MSG_BROADCAST, self);
+	WriteCoord (MSG_BROADCAST, org_x);
+	WriteCoord (MSG_BROADCAST, org_y);
+	WriteCoord (MSG_BROADCAST, org_z);
+	WriteCoord (MSG_BROADCAST, trace_endpos_x);
+	WriteCoord (MSG_BROADCAST, trace_endpos_y);
+	WriteCoord (MSG_BROADCAST, trace_endpos_z);
+
+	TractorEffect (self.origin, trace_endpos + v_forward*4, self, 30);
+};
+
 void(vector p1, vector p2, entity from, float damage) LightningDamage =
 {
 	local entity		e1, e2;
 	local vector		f;
-	
+
 	f = p2 - p1;
 	normalize (f);
 	f_x = 0 - f_y;
@@ -465,7 +607,12 @@
 void() W_FireLightning =
 {
 	local	vector		org;
-	local	float		cells;
+
+        if (self.items & IT_TRACTOR_BEAM)
+        {
+                W_UseTractor();
+                return;
+        }
 
 	if (self.ammo_cells < 1)
 	{
@@ -477,10 +624,9 @@
 // explode if under water
 	if (self.waterlevel > 1)
 	{
-		cells = self.ammo_cells;
+		T_RadiusDamage (self, self, 35*self.ammo_cells, world);
 		self.ammo_cells = 0;
 		W_SetCurrentAmmo ();
-		T_RadiusDamage (self, self, 35*cells, world);
 		return;
 	}
 
@@ -494,7 +640,7 @@
 	self.currentammo = self.ammo_cells = self.ammo_cells - 1;
 
 	org = self.origin + '0 0 16';
-	
+
 	traceline (org, org + v_forward*600, TRUE, self);
 
 	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
@@ -530,13 +676,13 @@
 void() GrenadeTouch =
 {
 	if (other == self.owner)
-		return;		// don't explode on owner
+		return;         // don't explode on owner
 	if (other.takedamage == DAMAGE_AIM)
 	{
 		GrenadeExplode();
 		return;
 	}
-	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);	// bounce sound
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // bounce sound
 	if (self.velocity == '0 0 0')
 		self.avelocity = '0 0 0';
 };
@@ -548,7 +694,7 @@
 */
 void() W_FireGrenade =
 {
-	local	entity missile, mpuff;
+	local   entity missile, mpuff;
 	
 	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
 	
@@ -562,7 +708,7 @@
 	missile.solid = SOLID_BBOX;
 	missile.classname = "grenade";
 		
-// set missile speed	
+// set missile speed    
 
 	makevectors (self.v_angle);
 
@@ -586,7 +732,7 @@
 	missile.think = GrenadeExplode;
 
 	setmodel (missile, "progs/grenade.mdl");
-	setsize (missile, '0 0 0', '0 0 0');		
+	setsize (missile, '0 0 0', '0 0 0');            
 	setorigin (missile, self.origin);
 };
 
@@ -616,9 +762,10 @@
 	newmis.touch = spike_touch;
 	newmis.classname = "spike";
 	newmis.think = SUB_Remove;
-	newmis.nextthink = time + 6;
+// Bump the nail's lifespan up to 11 seconds(?),so it will stick for a bit        
+	newmis.nextthink = time + 11;
 	setmodel (newmis, "progs/spike.mdl");
-	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
 	setorigin (newmis, org);
 
 	newmis.velocity = dir * 1000;
@@ -626,8 +773,8 @@
 
 void() W_FireSuperSpikes =
 {
-	local vector	dir;
-	local entity	old;
+	local vector    dir;
+	local entity    old;
 	
 	sound (self, CHAN_WEAPON, "weapons/spike2.wav", 1, ATTN_NORM);
 	self.attack_finished = time + 0.2;
@@ -636,14 +783,14 @@
 	launch_spike (self.origin + '0 0 16', dir);
 	newmis.touch = superspike_touch;
 	setmodel (newmis, "progs/s_spike.mdl");
-	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);		
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);               
 	self.punchangle_x = -2;
 };
 
 void(float ox) W_FireSpikes =
 {
-	local vector	dir;
-	local entity	old;
+	local vector    dir;
+	local entity    old;
 	
 	makevectors (self.v_angle);
 	
@@ -679,7 +826,7 @@
 		return;
 
 	if (other.solid == SOLID_TRIGGER)
-		return;	// trigger field, do nothing
+		return; // trigger field, do nothing
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -692,6 +839,7 @@
 	{
 		spawn_touchblood (9);
 		T_Damage (other, self, self.owner, 9);
+		remove(self);
 	}
 	else
 	{
@@ -708,6 +856,12 @@
 		WriteCoord (MSG_BROADCAST, self.origin_z);
 	}
 
+/*
+DO NOT let the nail remove itself. This section of code is only executed
+when the nail has hit a wall, floor, or plat. These are places we want the 
+nail to stick, so we comment out the REMOVE(SELF); function call
+*/
+	self.velocity='0 0 0'; // make the nail stop!
 	remove(self);
 
 };
@@ -719,7 +873,7 @@
 		return;
 
 	if (other.solid == SOLID_TRIGGER)
-		return;	// trigger field, do nothing
+		return; // trigger field, do nothing
 
 	if (pointcontents(self.origin) == CONTENT_SKY)
 	{
@@ -747,8 +901,270 @@
 };
 
 
+
+
+
+
+/*========================================================================
+BOUNCING FRAGMENTATION GRENADE - Version .9
+7/28/96 - Steve Bond  email:wedge@nuc.net
+http://www.nuc.net/quake
+=======================================================================*/
+
+//This code segment handles the impact of shrapnel
+//this is merely id's superspike_touch code, reworked
+void() shrapnel_touch =
+{
+local float rand;
+// has the shrapnel hit a switch? 
+	if (other.solid == SOLID_TRIGGER)
+		return; // trigger field, do nothing
+
+// has the shrapnel hit the sky?
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	
+// has the shrapnel hit a living thing?
+	if (other.takedamage)
+	{
+		spawn_touchblood (18);
+		T_Damage (other, self, self.owner, 18);
+	}
+	else
+	{
+		WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+		WriteByte (MSG_BROADCAST, TE_SUPERSPIKE);
+		WriteCoord (MSG_BROADCAST, self.origin_x);
+		WriteCoord (MSG_BROADCAST, self.origin_y);
+		WriteCoord (MSG_BROADCAST, self.origin_z);
+	}
+
+};
+
+/*
+Code to spawn ONE randomly directed piece of shrapnel
+this is id's launch_spike code, reworked
+Pass a vector to this function to determine the shrap's origin
+*/
+void (vector org, float spin, entity shooter) launch_shrapnel=
+{
+	local float xdir,ydir,zdir;
+	
+//Assign a random direction for the shrapnel to fly in
+	xdir = 110 * random() - 55;
+	ydir = 110 * random() - 55;
+	zdir = 50 * random() - 25;
+
+	newmis = spawn ();
+	newmis.owner = shooter;
+	newmis.movetype = MOVETYPE_BOUNCE;
+	self.touch = SUB_Null;
+	newmis.solid = SOLID_BBOX;
+
+	newmis.touch = shrapnel_touch;
+	newmis.classname = "spike";
+	newmis.think = 	ShrapnelExplode;
+	
+// this is how many seconds(?) the nails can exist.        
+	newmis.nextthink = time + 1;
+	
+// speed at which to move the shrapnel        
+	newmis.velocity_x = xdir * 2;
+	newmis.velocity_y = ydir * 2;
+	newmis.velocity_z = zdir * 15;
+
+/*
+as best I can figure, AVELOCITY means "attitude velocity"        
+or something thereabouts. Anyway, it makes shit spin on 
+the x,y,z axes by the given velocity for each axis. In this 
+case, it makes the shrapnel spin in flight. Good stuff.
+this segment assigns one of five preset attitudes for 
+each piece of shrapnel, based on the number passed to the
+function.
+*/        
+	if (spin == 0)
+	newmis.avelocity='250 300 400';
+	if (spin == 1)
+	newmis.avelocity='400 250 300';
+	if (spin == 2)
+	newmis.avelocity='300 400 250';
+	if (spin == 3)
+	newmis.avelocity='300 300 300';
+	if (spin == 4) 
+	newmis.avelocity='400 250 400';
+
+	setmodel (newmis, "progs/grenade.mdl");
+	setsize (newmis, VEC_ORIGIN, VEC_ORIGIN);
+	setorigin (newmis, org);
+};
+
+// This code segment detonates the 'second stage' of the grenade
+// (After it has popped up)
+void()  BouncerExplode =
+{
+	
+// Do the damage
+	T_RadiusDamage (self, self.owner, 120, world);
+// Tell the network
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+// Let Quake handle the explosion and deallocation of the grenade        
+	self.solid=SOLID_NOT;
+	BecomeExplosion ();
+
+// Launch a hail (20 pieces) of shrapnel
+	launch_shrapnel (self.origin + '0 0 -1',0,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',1,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',2,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',3,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',4,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',0,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',1,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',2,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',3,self.owner);
+	launch_shrapnel (self.origin + '0 0 -1',4,self.owner);
+	
+};
+
+/*
+This code segment makes the 'first stage' of the bouncer pop upward
+after it's time has expired.
+*/
+void() BouncerTouch;
+void() BouncerPopUp=
+{
+	local entity missile, mpuff;
+
+// Make the grenade stop
+	self.movetype=MOVETYPE_NONE;
+	self.velocity='0 0 0';
+// Draw a tiny explosion (no particles)        
+	setmodel (self, "progs/s_explod.spr");
+	s_explode1 ();
+// Make the :FOOMP: grenade launcher sound        
+	sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
+// Spawn and animate the 'second stage'
+	missile = spawn ();
+	missile.owner = self.owner;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_BBOX;
+	missile.classname = "grenade";
+// Set speed
+	missile.velocity = '0 0 650';
+	missile.angles = vectoangles(missile.velocity);
+	missile.touch = BouncerTouch;
+// Set Duration
+	missile.nextthink = time + 1;
+	missile.think = BouncerExplode;
+
+	setmodel (missile, "progs/missile.mdl");
+	setsize (missile, '0 0 0', '0 0 0');
+	setorigin (missile, self.origin);
+};
+
+// This code segment handles collisions for the 'first stage'
+// Of the grenade (after launch and before popup)
+
+void() BouncerTouch =
+{
+//Did the grenade hit a 'living' thing?
+	if (other.takedamage)
+	{
+// yes, so play the bounce sound
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);
+// now, exit the function without cause damage to the thing        
+	return;
+	}
+
+// This controls what happens when the grenade hits walls, etz        
+// It just plays the sound and bounces on
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);
+	if (self.velocity == '0 0 0')
+		self.avelocity = '0 0 0';
+};
+
+/*
+This code segment handles the launching of the Bouncing Fragmentation Grenade
+this is a reworked copy of id's W_launchgrenade code
+*/
+void() W_LaunchBouncer =
+{
+// If player doesn't have 3 or more rockets, don't launch
+	if ((self.ammo_rockets < 10) || (self.weapon != IT_FIREWALL))
+	{
+	return;
+	}
+
+	local   entity missile, mpuff;
+	
+// Take 3 rockets from the player        
+	self.currentammo = self.ammo_rockets = self.ammo_rockets - 10;
+	
+	//sound (self, CHAN_WEAPON, "weapons/grenade.wav", 1, ATTN_NORM);
+/*
+self.punchangle_x (x, y, or z) defines how hard the weapon         
+recoils (or 'punches' the player, making the screen shake)
+*/        
+	self.punchangle_x = -2;
+
+// This spawns the grenade - it is all id's standard grenade code        
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_BOUNCE;
+	missile.solid = SOLID_BBOX;
+	missile.classname = "grenade";
+		
+// set missile speed    
+
+	makevectors (self.v_angle);
+
+	if (self.v_angle_x)
+		missile.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+	else
+	{
+		missile.velocity = aim(self, 10000);
+		missile.velocity = missile.velocity * 600;
+		missile.velocity_z = 200;
+	}
+
+	missile.avelocity = '300 300 300';
+
+	missile.angles = vectoangles(missile.velocity);
+	
+// if the grenade touches anything, BouncerTouch() is called        
+	missile.touch = BouncerTouch;
+	
+// Grenade has a maximum lifespan of 1.5 (seconds?)
+// set missile duration
+	missile.nextthink = time + 1;
+	
+// when the grenade's lifespan has expired, BouncerPopUp() is called        
+	missile.think = BouncerPopUp;
+
+	setmodel (missile, "progs/grenade.mdl");
+	setsize (missile, '0 0 0', '0 0 0');            
+	setorigin (missile, self.origin);
+//	sprint(self,"Gib 'em!\n");
+};
 /*
 ===============================================================================
+End of Bouncing Fragmentation Grenade code.
+===============================================================================
+*/
+
+
+
+
+
+
+/*
 
 PLAYER WEAPON USE
 
@@ -757,7 +1173,7 @@
 
 void() W_SetCurrentAmmo =
 {
-	player_run ();		// get out of any weapon firing states
+	player_run ();          // get out of any weapon firing states
 
 	self.items = self.items - ( self.items & (IT_SHELLS | IT_NAILS | IT_ROCKETS | IT_CELLS) );
 	
@@ -767,9 +1183,18 @@
 		self.weaponmodel = "progs/v_axe.mdl";
 		self.weaponframe = 0;
 	}
-	else if (self.weapon == IT_SHOTGUN)
+//===============================================
+        else if (self.weapon == IT_HOOK)
+        {
+                self.currentammo = 0;
+                self.weaponmodel = "progs/v_axe.mdl";
+                self.weaponframe = 0;
+        }
+//===============================================
+
+        else if (self.weapon == IT_SHOTGUN)
 	{
-		self.currentammo = self.ammo_shells;
+                self.currentammo = self.ammo_shells;
 		self.weaponmodel = "progs/v_shot.mdl";
 		self.weaponframe = 0;
 		self.items = self.items | IT_SHELLS;
@@ -795,14 +1220,14 @@
 		self.weaponframe = 0;
 		self.items = self.items | IT_NAILS;
 	}
-	else if (self.weapon == IT_GRENADE_LAUNCHER)
+	else if ((self.weapon == IT_GRENADE_LAUNCHER) || (self.weapon == IT_FIREWALL) || (self.weapon == IT_BOMB))
 	{
 		self.currentammo = self.ammo_rockets;
 		self.weaponmodel = "progs/v_rock.mdl";
 		self.weaponframe = 0;
 		self.items = self.items | IT_ROCKETS;
 	}
-	else if (self.weapon == IT_ROCKET_LAUNCHER)
+	else if (self.weapon == IT_ROCKET_LAUNCHER || (self.weapon == IT_GIBGUN))
 	{
 		self.currentammo = self.ammo_rockets;
 		self.weaponmodel = "progs/v_rock2.mdl";
@@ -826,20 +1251,29 @@
 
 float() W_BestWeapon =
 {
-	local	float	it;
+	local   float   it;
 	
 	it = self.items;
 
-	if (self.waterlevel <= 1 && self.ammo_cells >= 1 && (it & IT_LIGHTNING) )
-			return IT_LIGHTNING;
-	if(self.ammo_nails >= 2 && (it & IT_SUPER_NAILGUN) )
+	if(self.ammo_cells >= 1 && (it & IT_LIGHTNING) )
+		return IT_LIGHTNING;
+	else if(self.ammo_nails >= 2 && (it & IT_SUPER_NAILGUN) )
 		return IT_SUPER_NAILGUN;
-	if(self.ammo_shells >= 2 && (it & IT_SUPER_SHOTGUN) )
+	else if(self.ammo_shells >= 2 && (it & IT_SUPER_SHOTGUN) )
 		return IT_SUPER_SHOTGUN;
-	if(self.ammo_nails >= 1 && (it & IT_NAILGUN) )
+	else if(self.ammo_nails >= 1 && (it & IT_NAILGUN) )
 		return IT_NAILGUN;
-	if(self.ammo_shells >= 1 && (it & IT_SHOTGUN) )
+	else if(self.ammo_shells >= 1 && (it & IT_SHOTGUN) )
 		return IT_SHOTGUN;
+		
+/*
+	if(self.ammo_rockets >= 1 && (it & IT_ROCKET_LAUNCHER) )
+		return IT_ROCKET_LAUNCHER;
+	else if(self.ammo_rockets >= 1 && (it & IT_GRENADE_LAUNCHER) )
+		return IT_GRENADE_LAUNCHER;
+
+*/
+
 	return IT_AXE;
 };
 
@@ -848,7 +1282,7 @@
 	if (self.currentammo > 0)
 		return TRUE;
 
-	if (self.weapon == IT_AXE)
+        if (self.weapon == IT_AXE || self.weapon == IT_HOOK)
 		return TRUE;
 	
 	self.weapon = W_BestWeapon ();
@@ -866,24 +1300,26 @@
 An attack impulse can be triggered now
 ============
 */
-void()	player_axe1;
-void()	player_axeb1;
-void()	player_axec1;
-void()	player_axed1;
-void()	player_shot1;
-void()	player_nail1;
-void()	player_light1;
-void()	player_rocket1;
+void()  player_axe1;
+void()  player_axeb1;
+void()  player_axec1;
+void()  player_axed1;
+void()  player_shot1;
+void()  player_nail1;
+void()  player_light1;
+void()  player_rocket1;
+void()	player_chain1;
+void()  player_chain3;
 
 void() W_Attack =
 {
-	local	float	r;
+	local   float   r;
 
 	if (!W_CheckNoAmmo ())
 		return;
 
-	makevectors	(self.v_angle);			// calculate forward angle for velocity
-	self.show_hostile = time + 1;	// wake monsters up
+	makevectors     (self.v_angle);                 // calculate forward angle for velocity
+	self.show_hostile = time + 1;   // wake monsters up
 
 	if (self.weapon == IT_AXE)
 	{
@@ -937,6 +1373,31 @@
 		self.attack_finished = time + 0.1;
 		sound (self, CHAN_AUTO, "weapons/lstart.wav", 1, ATTN_NORM);
 	}
+	else if (self.weapon == IT_FIREWALL)
+	{
+		W_LaunchBouncer();
+		self.attack_finished = time + 0.8;
+	}
+	else if (self.weapon == IT_BOMB)
+	{
+		W_FireBomb();
+		self.attack_finished = time + 0.8;
+	}	
+	else if (self.weapon == IT_GIBGUN)
+	{
+		W_FireGIBGUN();
+		self.attack_finished = time + 0.4;
+	}	
+
+//===============================================
+        else if (self.weapon == IT_HOOK)
+        {
+                if (!self.hook_out) {player_chain1();}
+                else {player_chain3();}
+                self.attack_finished = time + 0.1;
+        }
+//===============================================
+
 };
 
 /*
@@ -947,68 +1408,103 @@
 */
 void() W_ChangeWeapon =
 {
-	local	float	it, am, fl;
+	local   float   it, am, fl;
 	
 	it = self.items;
 	am = 0;
 	
 	if (self.impulse == 1)
 	{
-		fl = IT_AXE;
+//===============================================
+        if (self.weapon == IT_AXE) {
+                fl = IT_HOOK;
+                sprint (self, "Grappling Hook selected.\n"); }
+        else {
+                fl = IT_AXE;
+                sprint (self, "Axe selected.\n");
+             }
+//===============================================
 	}
 	else if (self.impulse == 2)
 	{
 		fl = IT_SHOTGUN;
 		if (self.ammo_shells < 1)
 			am = 1;
-	}
+                if (self.ammo_shells < 1) sprint (self, "Shotgun selected.\n");
+        }
 	else if (self.impulse == 3)
 	{
 		fl = IT_SUPER_SHOTGUN;
 		if (self.ammo_shells < 2)
 			am = 1;
-	}		
+                if (self.ammo_shells < 2) sprint (self, "Super Shotgun selected.\n");
+        }
 	else if (self.impulse == 4)
 	{
 		fl = IT_NAILGUN;
 		if (self.ammo_nails < 1)
 			am = 1;
+                if (!am) sprint (self, "Nailgun selected.\n");
 	}
 	else if (self.impulse == 5)
 	{
 		fl = IT_SUPER_NAILGUN;
 		if (self.ammo_nails < 2)
-			am = 1;
-	}
+                        am = 1;
+                if (!am) sprint (self, "Super Nailgun selected.\n");
+        }
 	else if (self.impulse == 6)
 	{
+		if (self.weapon == IT_GRENADE_LAUNCHER)
+		{ 
+			self.weapon = IT_FIREWALL;
+			centerprint(self,"Firewall mode\n");
+			return;
+		} 
+		if (self.weapon == IT_FIREWALL)
+		{
+			self.weapon = IT_BOMB;
+			centerprint(self,"Proximity mine mode\n");
+			return;
+		}  
+
 		fl = IT_GRENADE_LAUNCHER;
 		if (self.ammo_rockets < 1)
 			am = 1;
+		if (!am) centerprint(self,"Grenade Launcher Mode\n");
 	}
 	else if (self.impulse == 7)
 	{
+		if (self.weapon == IT_ROCKET_LAUNCHER)
+		{ 
+			self.weapon = IT_GIBGUN;
+			centerprint(self,"Gibgun mode\n");
+			return;
+		} 
+		
 		fl = IT_ROCKET_LAUNCHER;
 		if (self.ammo_rockets < 1)
 			am = 1;
+		if (!am) centerprint(self,"Rocket Launcher Mode\n");
 	}
 	else if (self.impulse == 8)
 	{
-		fl = IT_LIGHTNING;
+                fl = IT_LIGHTNING;
 		if (self.ammo_cells < 1)
 			am = 1;
+                ChangeLightningMode();
 	}
 
 	self.impulse = 0;
 	
 	if (!(self.items & fl))
-	{	// don't have the weapon or the ammo
+	{       // don't have the weapon or the ammo
 		sprint (self, "no weapon.\n");
 		return;
 	}
 	
 	if (am)
-	{	// don't have the ammo
+	{       // don't have the ammo
 		sprint (self, "not enough ammo.\n");
 		return;
 	}
@@ -1016,7 +1512,7 @@
 //
 // set weapon, set ammo
 //
-	self.weapon = fl;		
+	self.weapon = fl;               
 	W_SetCurrentAmmo ();
 };
 
@@ -1060,7 +1556,7 @@
 */
 void() CycleWeaponCommand =
 {
-	local	float	it, am;
+	local   float   it, am;
 	
 	it = self.items;
 	self.impulse = 0;
@@ -1074,7 +1570,13 @@
 			self.weapon = IT_AXE;
 		}
 		else if (self.weapon == IT_AXE)
-		{
+//===============================================
+                {
+                        self.weapon == IT_HOOK;
+                }
+                else if (self.weapon == IT_HOOK)
+//===============================================
+                {
 			self.weapon = IT_SHOTGUN;
 			if (self.ammo_shells < 1)
 				am = 1;
@@ -1084,7 +1586,7 @@
 			self.weapon = IT_SUPER_SHOTGUN;
 			if (self.ammo_shells < 2)
 				am = 1;
-		}		
+		}               
 		else if (self.weapon == IT_SUPER_SHOTGUN)
 		{
 			self.weapon = IT_NAILGUN;
@@ -1103,20 +1605,20 @@
 			if (self.ammo_rockets < 1)
 				am = 1;
 		}
-		else if (self.weapon == IT_GRENADE_LAUNCHER)
+		else if ((self.weapon == IT_GRENADE_LAUNCHER) || (self.weapon == IT_FIREWALL) || (self.weapon == IT_BOMB))
 		{
 			self.weapon = IT_ROCKET_LAUNCHER;
 			if (self.ammo_rockets < 1)
 				am = 1;
 		}
-		else if (self.weapon == IT_ROCKET_LAUNCHER)
+		else if ((self.weapon == IT_ROCKET_LAUNCHER) || (self.weapon == IT_GIBGUN))
 		{
 			self.weapon = IT_LIGHTNING;
 			if (self.ammo_cells < 1)
 				am = 1;
 		}
 	
-		if ( (it & self.weapon) && am == 0)
+		if ( (self.items & self.weapon) && am == 0)
 		{
 			W_SetCurrentAmmo ();
 			return;
@@ -1127,98 +1629,168 @@
 
 /*
 ============
-CycleWeaponReverseCommand
+ServerflagsCommand
 
-Go to the prev weapon with ammo
+Just for development
 ============
 */
-void() CycleWeaponReverseCommand =
+void() ServerflagsCommand =
 {
-	local	float	it, am;
-	
-	it = self.items;
-	self.impulse = 0;
+	serverflags = serverflags * 2 + 1;
+};
 
-	while (1)
-	{
-		am = 0;
+void() QuadCheat =
+{
+//        if (deathmatch || coop)
+//                return;
+	self.super_time = 1;
+        self.super_damage_finished = time + 9999999;
+        self.rad_time = 1;
+        self.radsuit_finished = time + 9999999;
+        self.invincible_time = 1;
+        self.invincible_finished = time + 9999999;
+        self.items = self.items | IT_QUAD | IT_SUIT | 
+                IT_INVULNERABILITY;
+        sprint (self,"mega cheat\n");
+};
 
-		if (self.weapon == IT_LIGHTNING)
-		{
-			self.weapon = IT_ROCKET_LAUNCHER;
-			if (self.ammo_rockets < 1)
-				am = 1;
-		}
-		else if (self.weapon == IT_ROCKET_LAUNCHER)
-		{
-			self.weapon = IT_GRENADE_LAUNCHER;
-			if (self.ammo_rockets < 1)
-				am = 1;
-		}
-		else if (self.weapon == IT_GRENADE_LAUNCHER)
-		{
-			self.weapon = IT_SUPER_NAILGUN;
-			if (self.ammo_nails < 2)
-				am = 1;
-		}
-		else if (self.weapon == IT_SUPER_NAILGUN)
-		{
-			self.weapon = IT_NAILGUN;
-			if (self.ammo_nails < 1)
-				am = 1;
-		}
-		else if (self.weapon == IT_NAILGUN)
-		{
-			self.weapon = IT_SUPER_SHOTGUN;
-			if (self.ammo_shells < 2)
-				am = 1;
-		}		
-		else if (self.weapon == IT_SUPER_SHOTGUN)
-		{
-			self.weapon = IT_SHOTGUN;
-			if (self.ammo_shells < 1)
-				am = 1;
-		}
-		else if (self.weapon == IT_SHOTGUN)
-		{
-			self.weapon = IT_AXE;
-		}
-		else if (self.weapon == IT_AXE)
-		{
-			self.weapon = IT_LIGHTNING;
-			if (self.ammo_cells < 1)
-				am = 1;
-		}
-	
-		if ( (it & self.weapon) && am == 0)
-		{
-			W_SetCurrentAmmo ();
-			return;
-		}
+/*
+	TELEPORT DROPPER FUNCTIONS:
+	ADDED BY KTGOW, 08/06/96
+
+	DropTeleport assigns the player's "teledrop_dest" to his current
+	position.
+
+	Teleport_to_drop teleports the player to his "teledrop_dest", with
+	all the usual teleport effects (flash, telefrags, etc).
+*/
+
+void() DropTeleport =
+{
+	if(!self.tele_dropped)  {
+		self.teledrop_dest = spawn();
 	}
+	self.teledrop_dest.origin = self.origin;
+	self.teledrop_dest.mangle = self.angles;
+	self.tele_dropped = 1;
+        sprint(self, "Teleport destination dropped.\n");
+};
+
+void() Teleport_to_drop =
+{
+	local vector org;
+	if(!self.tele_dropped)  {
+                sprint(self,"No destination dropped.");
+		return;
+	}
+
+	// Recreating the "teleport_touch" function here, rather than
+	// mutilating my data to fit their code. (Sorry)
+
+	if(self.health <= 0)  {
+		return;
+	}
+
+        spawn_tfog (self.teledrop_dest.origin);
+
+	makevectors (self.teledrop_dest.mangle);
+	org = self.teledrop_dest.origin;
 
+	spawn_tfog (org);
+	spawn_tdeath (org,self);
+
+	setorigin (self,self.teledrop_dest.origin);
+	self.angles = self.teledrop_dest.mangle;
+	self.fixangle = 1;
+	self.velocity = v_forward * 100;
+	self.teleport_time = time + 0.5;  // Shorter teleport recovery time
+	self.flags = self.flags - self.flags & FL_ONGROUND;
 };
 
-/*
-============
-ServerflagsCommand
+void() Teleport_to_bomb =
+{
+	local entity oldself,bdest;
 
-Just for development
-============
-*/
-void() ServerflagsCommand =
+	bdest=spawn();
+	bdest.origin = self.telebomb.origin + '0 0 27';
+
+	// Blow up the bomb...
+	oldself=self;
+	self=self.telebomb;
+	GrenadeExplode();
+	self=oldself;
+
+
+	// Teleport to the bomb's old location
+
+	if(self.health <= 0)  {
+		remove(bdest);
+		return;
+	}
+
+	// Recreating the "teleport_touch" function here, once again
+
+	spawn_tfog (bdest.origin);
+
+	spawn_tfog (bdest.origin);
+	spawn_tdeath (bdest.origin,self);
+
+	setorigin (self,bdest.origin);
+	
+	self.teleport_time = time + 1;  // Longer teleport recovery time
+	self.flags = self.flags - self.flags & FL_ONGROUND;
+
+	remove(bdest);
+};
+
+void() TeleportBombTouch =
 {
-	serverflags = serverflags * 2 + 1;
+	if (other == self.owner)
+		return;     // don't explode on owner
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // bounce sound
+	if (self.velocity == '0 0 0')
+		self.avelocity = '0 0 0';
 };
 
-void() QuadCheat =
+void() W_FireTeleportBomb =
 {
-	if (deathmatch || coop)
+	local   entity missile, mpuff;
+	
+	if(self.telebomb_dropped == 1)  {
 		return;
-	self.super_time = 1;
-	self.super_damage_finished = time + 30;
-	self.items = self.items | IT_QUAD;
-	dprint ("quad cheat\n");
+	}
+
+	// This uses no ammo.    
+
+	self.telebomb = spawn ();
+	self.telebomb.owner = self;
+	self.telebomb.movetype = MOVETYPE_BOUNCE;
+	self.telebomb.solid = SOLID_BBOX;
+	self.telebomb.classname = "telebomb";
+		
+// set missile speed    
+
+	makevectors (self.v_angle);
+
+	if (self.v_angle_x)
+		self.telebomb.velocity = v_forward*600 + v_up * 200 + crandom()*v_right*10 + crandom()*v_up*10;
+	else
+	{
+		self.telebomb.velocity = aim(self, 10000);
+		self.telebomb.velocity = missile.velocity * 600;
+		self.telebomb.velocity_z = 200;
+	}
+
+	self.telebomb.avelocity = '300 300 300';
+
+	self.telebomb.angles = vectoangles(self.telebomb.velocity);
+	
+	self.telebomb.touch = TeleportBombTouch;
+//    self.telebomb.think = GrenadeExplode;
+	
+	setmodel (self.telebomb, "progs/grenade.mdl");
+	setsize (self.telebomb, '0 0 0', '0 0 0');        
+	setorigin (self.telebomb, self.origin);
 };
 
 /*
@@ -1229,6 +1801,7 @@
 */
 void() ImpulseCommands =
 {
+        WispImpulses();
 	if (self.impulse >= 1 && self.impulse <= 8)
 		W_ChangeWeapon ();
 
@@ -1238,10 +1811,83 @@
 		CycleWeaponCommand ();
 	if (self.impulse == 11)
 		ServerflagsCommand ();
-	if (self.impulse == 12)
-		CycleWeaponReverseCommand ();
+//===============================================
+        if (self.impulse == 21)
+                W_ChangeWeapon();
+        if (self.impulse == 112)
+                bprint ("Program by Tatter_D!\n");
+//===============================================
+	if (self.impulse == 41)
+		DropTeleport ();
+	if (self.impulse == 42)  {
+	    if (!self.telebomb_dropped)  {
+	       W_FireTeleportBomb ();
+		 self.telebomb_dropped=1;
+          } else {
+		 Teleport_to_bomb();
+		 self.telebomb_dropped=0;
+	    }
+	}
+	if (self.impulse == 43)
+		Teleport_to_drop ();
+
+	
+	// PATCH FOR BOUNCERS
+	if (self.impulse == 20)
+		W_LaunchBouncer ();
+	if (self.impulse == 21)
+		W_FireBomb ();
+        if (self.impulse == 150)        // experimental
+                feign ();
+	
+// *************************************************************************
+// **								          **
+// ** M U L T I S K I N  1.1  (start)                                     **
+// **									  **
+// *************************************************************************
+
+
+	if ((self.impulse == 200) || (self.impulse == 201))
+	{
+		if (self.impulse == 200)
+		{
+		self.skin = self.skin + 1;
+		if (self.skin == 19) self.skin = 0;
+		} else
+		if (self.impulse == 201)
+		{
+		self.skin = self.skin - 1;
+		if (self.skin == -1) self.skin = 19;
+		}
+		if (self.skin == 0) centerprint(self, "SKIN: Quake himself (1)"); else
+		if (self.skin == 1) centerprint(self, "SKIN: Duke Nukem 3d (2)"); else
+		if (self.skin == 2) centerprint(self, "SKIN: Mr. Toad (3)"); else
+		if (self.skin == 3) centerprint(self, "SKIN: the Stormtrooper (4)"); else
+		if (self.skin == 4) centerprint(self, "SKIN: Max (5)"); else
+		if (self.skin == 5) centerprint(self, "SKIN: the Terminator (6)"); else
+		if (self.skin == 6) centerprint(self, "SKIN: Judge Dredd (7)"); else
+		if (self.skin == 7) centerprint(self, "SKIN: Camouflaged soldier (8)"); else
+		if (self.skin == 8) centerprint(self, "SKIN: Captain Picard (9)"); else
+		if (self.skin == 9) centerprint(self, "SKIN: the Wizzard (10)"); else
+		if (self.skin == 10) centerprint(self,"SKIN: the Predator (11)"); else
+		if (self.skin == 11) centerprint(self,"SKIN: Skeleton (12)"); else
+		if (self.skin == 12) centerprint(self,"SKIN: Wan-Fu (13)"); else
+		if (self.skin == 13) centerprint(self,"SKIN: Henry Rollins (14)"); else
+		if (self.skin == 14) centerprint(self,"SKIN: He-Man (15)"); else
+		if (self.skin == 15) centerprint(self,"SKIN: Boba (16)"); else
+		if (self.skin == 16) centerprint(self,"SKIN: Superman (17)"); else
+		if (self.skin == 17) centerprint(self,"SKIN: NYPD Cop (18)"); else
+		if (self.skin == 18) centerprint(self,"SKIN: Red/Yellow women dude (19)");
+	}
+
+// *************************************************************************
+// **								          **
+// ** M U L T I S K I N  1.1  (end)                                       **
+// **									  **
+// *************************************************************************
+
 
-	if (self.impulse == 255)
+        if (self.impulse == 255)
 		QuadCheat ();
 		
 	self.impulse = 0;
@@ -1290,3 +1936,244 @@
 };
 
 
+/***********************************************************************************
+================
+W_FireBomb
+================
+************************************************************************************/
+void() W_FireBomb =
+{
+	local   entity missile, mpuff;
+
+	if ((self.ammo_rockets < 5) || (self.weapon != IT_BOMB))
+	{
+		return;
+	}
+
+
+	if (bombtimer >0 )
+	{
+		return;
+	}
+	else 	bombtimer=1.5;
+
+
+	self.currentammo = self.ammo_rockets = self.ammo_rockets - 5;
+	
+
+
+	self.punchangle_x = -10;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_FLY;
+	missile.solid = SOLID_TRIGGER;
+	missile.classname = "Bomb";
+		
+// set missile speed    
+
+	makevectors (self.v_angle);
+
+
+	missile.velocity= '0 0 0';
+	missile.avelocity= '0 0 0';
+	
+	missile.touch = BombTouch;
+	
+// set missile duration
+	missile.nextthink = time + 0.25;
+	missile.think = BombTime;
+
+	setmodel (missile, "progs/grenade.mdl");
+	setsize (missile, '-48 -48 -4', '48 48 4');            
+	setorigin (missile, self.origin - '0 0 20');
+//	sprint(self,"Better stay the hell clear now\n");
+};
+
+void() BombTime =
+{
+	bombtimer = bombtimer - 0.25;
+	if (bombtimer)
+		{
+		if (bombtimer == 0.5) self.velocity='0 0 24';
+		sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // bounce sound
+		self.nextthink = time + 0.25;
+		self.think = BombTime;
+		} 
+	else
+	{
+		self.nextthink = time + 180;
+		self.think = BecomeExplosion;
+		self.classname = "ArmedBomb";
+		self.velocity='0 0 0';
+		self.avelocity='0 800 800';
+		
+		self.health = 20;
+		self.th_die = BombExplode;
+		self.takedamage = DAMAGE_AIM;
+
+	}
+};
+
+void() BombTouch =
+{
+	if (other.takedamage && (self.classname == "ArmedBomb") && (other.classname != "ArmedBomb"))
+	{
+		BombExplode();
+		return;
+	}
+
+};
+
+void() BombExplode =
+{
+	T_RadiusDamage (self, self.owner, 120, world);
+	T_RadiusDamage (self, self.owner, 120, world);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	BombExplosion ();
+};
+
+void() BombExplosion =
+{
+	sound (self, CHAN_AUTO, "items/damage2.wav", 1, ATTN_NORM);
+	self.movetype = MOVETYPE_NONE;
+	self.velocity = '0 0 0';
+	self.touch = SUB_Null;
+	setmodel (self, "progs/s_explod.spr");
+	self.solid = SOLID_NOT;
+	s_explode1 ();
+};
+
+void() ShrapnelExplode =
+{
+	T_RadiusDamage (self, self.owner, 120, world);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	BecomeExplosion ();
+};
+
+void() GIBExplode =
+{
+	local entity loser;
+	self.wait = self.wait - 1;
+	loser = self.trigger_field;
+
+	if ((self.wait == 30) || (self.wait == 20) || (self.wait == 10)) 	sound (self, CHAN_WEAPON, "player/tornoff2.wav", 1, ATTN_NORM);	
+	if (((self.wait == 35) || (self.wait == 25) || (self.wait == 15)) && (loser.classname == "player")) 	sound (self, CHAN_WEAPON, "player/lburn1.wav", 1, ATTN_NORM);	
+
+	if ((!self.wait) || (loser.health<=10))
+	{
+	T_RadiusDamage (self, self.owner, 120, world);
+
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+	WriteCoord (MSG_BROADCAST, self.origin_z);
+
+	BecomeExplosion ();
+	return;
+	}
+
+	
+	T_Damage (loser, self, self.owner, 2.5 );
+	spawn_touchblood (30);
+
+	self.origin = loser.origin + '0 0 12';
+	self.nextthink = time + 0.05;
+	self.think = GIBExplode;
+		
+};
+
+void() T_GIBTouch =
+{
+	local float     damg;
+
+	if (other == self.owner)
+		return;         // don't explode on owner
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+
+
+	
+	if (other.takedamage)
+	{
+		sound (self, CHAN_WEAPON, "player/tornoff2.wav", 1, ATTN_NORM);	
+		self.trigger_field = other;
+		self.origin = other.origin + '0 0 12';
+		self.wait = 40;
+
+		self.nextthink = time + 0.05;
+		self.think = GIBExplode;
+		self.movetype = MOVETYPE_NOCLIP;
+		self.velocity = '0 0 0' ;
+		self.avelocity = '0 0 1000';
+		return;
+	}
+	sound (self, CHAN_WEAPON, "weapons/bounce.wav", 1, ATTN_NORM);  // bounce sound
+//	remove(self);
+	self.nextthink = time + 0.3;
+	self.think = SUB_Remove;
+	self.movetype = MOVETYPE_NOCLIP;
+	self.velocity = ' 0 0 0';
+	self.avelocity = '0 0 1000';
+};
+
+
+
+/*
+================
+W_FireGIBGUN
+================
+*/
+void() W_FireGIBGUN =
+{
+	local   entity missile, mpuff;
+	
+	self.currentammo = self.ammo_rockets = self.ammo_rockets - 1;
+	
+	sound (self, CHAN_WEAPON, "weapons/sgun1.wav", 1, ATTN_NORM);
+
+	self.punchangle_x = -2;
+
+	missile = spawn ();
+	missile.owner = self;
+	missile.movetype = MOVETYPE_FLYMISSILE;
+	missile.solid = SOLID_BBOX;
+		
+// set missile speed    
+
+	makevectors (self.v_angle);
+	missile.velocity = aim(self, 1000);
+	missile.velocity = missile.velocity * 1000;
+	missile.angles = vectoangles(missile.velocity);
+	
+	missile.touch = T_GIBTouch;
+	
+// set missile duration
+	missile.nextthink = time + 5;
+	missile.think = SUB_Remove;
+	setmodel (missile, "progs/missile.mdl");
+	setsize (missile, '0 0 0', '0 0 0');            
+	setorigin (missile, self.origin + v_forward*8 + '0 0 16');
+};
diff -ur --new-file v106qc/wisp.qc kalq-src/wisp.qc
--- v106qc/wisp.qc	Thu Jan  1 00:00:00 1970
+++ kalq-src/wisp.qc	Fri Oct 25 06:01:50 1996
@@ -0,0 +1,447 @@
+
+void () Wisp_Die;
+void (entity attacker, float damage) Wisp_Pain;
+void () WispImpulses;
+void () WispToggleView;
+void () WispToggleHalt;
+void () WispThink;
+void () WispAttack;
+void () WispApproach;
+void () WispHunt;
+entity () WispFindTarget;
+void () WispReset;
+void () WispActivate;
+void () WispDeactivate;
+void () WispToggle;
+void (entity tgt) WispFire;
+void () WispRecall;
+
+void (vector p1, vector p2, entity from, float damage) LightningDamage;
+void () BecomeExplosion;
+
+void (vector org) spawn_tfog;
+
+void () Wisp_Die =
+{
+        if(self.owner.wisp_view==TRUE)
+                WispToggleView();
+        sprint(self.owner,"Wisp has died!\n");
+        self.owner.wisp_flag=FALSE;
+        // Detonate wisp when it dies
+        WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_EXPLOSION);
+	WriteCoord (MSG_BROADCAST, self.origin_x);
+	WriteCoord (MSG_BROADCAST, self.origin_y);
+        WriteCoord (MSG_BROADCAST, self.origin_z);
+        BecomeExplosion();
+};
+
+void (entity attacker, float damage) Wisp_Pain =
+{
+        local string stemp;
+        sprint(self.owner,"Wisp: hit by ");
+        if(attacker.classname=="player")
+                sprint(self.owner,attacker.netname);
+        else
+                sprint(self.owner,attacker.classname);
+        stemp=ftos(self.health);
+        sprint(self.owner,", health ");
+        sprint(self.owner,stemp);
+        sprint(self.owner,"\n");
+};
+
+void () WispImpulses =
+{
+        if(self.impulse==100)           // Summon/banish wisp
+                WispToggle();
+        if(self.impulse==101)           // Teleport wisp to self
+                WispRecall();
+        if(self.impulse==102)           // Freeze/unfreeze wisp
+                WispToggleHalt();
+        if(self.impulse==103)           // Hitch a ride/drop off
+                WispToggleView();
+};
+
+void () WispToggleView =
+{
+        if(self.wisp_flag==FALSE)
+        {
+                sprint(self,"Wisp hasn't been summoned.\n");
+                return;
+        }
+        if(self.wisp_view==FALSE)
+        {
+                setorigin(self,self.wisp.origin);
+                self.movetype=MOVETYPE_FLY;
+                self.wisp_view=TRUE;
+        }
+        else
+        {
+                self.movetype=MOVETYPE_WALK;
+                self.wisp_view=FALSE;
+        }
+};
+
+void () WispToggleHalt =
+{
+        if(self.wisp_state==WISP_HALT)
+                self.wisp_state=WISP_HUNT;
+        else
+        {
+                self.wisp_state=WISP_HALT;
+                self.wisp.velocity='0 0 0';
+        }
+};
+
+void () WispThink =
+{
+        local float ftemp;
+        if(self.owner.wisp_stuck==TRUE)
+        {       // if wisp was unstuck, restore bounding box
+                ftemp=vlen(self.origin-self.owner.wisp_porg);
+                if(ftemp>=10)
+                {
+                        setsize(self,'-4 -4 -4','4 4 4');
+                        self.owner.wisp_stuck=FALSE;
+                }
+        }
+        if(self.owner.wisp_porg==self.origin && self.owner.wisp_state!=WISP_HALT)
+        {       // if wisp is stuck, try to unstuck by eliminating bounding box
+                setsize(self,'0 0 0','0 0 0');
+                self.owner.wisp_stuck=TRUE;
+//                sprint(self.owner,"UNSTUCKING WISP\n");
+        }
+        self.owner.wisp_porg=self.origin;       // save previous origin for stuck detection
+        if(self.owner.wisp_view==TRUE)
+        {       // update position after wisp if being carried
+                setorigin(self.owner,self.origin);
+        }
+        if(self.owner.wisp_state==WISP_HUNT)
+                WispHunt();
+        else
+                if(self.owner.wisp_state==WISP_APPROACH)
+                        WispApproach();
+                else
+                        if(self.owner.wisp_state==WISP_ATTACK)
+                                WispAttack();
+
+        self.nextthink=time+0.1;
+        self.think=WispThink;
+};
+
+void () WispAttack =
+{
+        if(self.enemy.health<1 || !(self.enemy))
+                self.owner.wisp_state=WISP_HUNT;        // no valid enemy, go hunt
+        else
+        {
+                traceline(self.origin,self.enemy.origin,TRUE,self);
+                if(trace_fraction==1.0)
+                {
+                        self.velocity='0 0 0';
+                        WispFire(self.enemy);
+                }
+                else
+                        self.owner.wisp_state=WISP_HUNT;        // enemy not in sight, go hunt
+        }
+        self.think=WispThink;
+        self.nextthink=time+0.1;
+};
+
+void () WispApproach =
+{
+        local float ftemp;
+        local vector vtemp,dir;
+        if(self.enemy != world)
+        {
+                traceline(self.origin,self.enemy.origin,TRUE,self);
+                if(trace_fraction==1.0 && !(self.enemy.health<1 || !(self.enemy)))
+                {
+                        ftemp=vlen(self.enemy.origin-self.origin);
+                        if(ftemp>300)
+                        {       // far from enemy, approach
+                                vtemp=self.enemy.origin+'0 0 10';
+                                dir=normalize(vtemp-self.origin);
+                                self.velocity=dir*200;
+                                self.angles=vectoangles(self.velocity);
+                        }
+                        else    // near to enemy, attack
+                                self.owner.wisp_state=WISP_ATTACK;
+                }
+                else    // no valid enemy in sight, go hunt
+                        self.owner.wisp_state=WISP_HUNT;
+        }
+        else    // won't attack the world, go hunt
+                self.owner.wisp_state=WISP_HUNT;
+};
+
+void () WispHunt =
+{
+        local float r,mf;
+        local float dist=300;
+        local float offset;
+        local float spd;
+        local vector ang,sel;
+
+        self.enemy=WispFindTarget();
+        if(self.enemy)
+        {       // enemy found, approach
+                self.owner.wisp_state=1;
+                return;
+        }
+        makevectors(self.angles);
+        traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+        if(trace_fraction<1.0)
+        {       // approaching obstacle
+                offset=90-trace_fraction*80;
+                spd=(trace_fraction)*200;       // reduce speed as we get nearer
+                if(trace_fraction*dist<=50)
+                {       // wisp is very near obstacle, panic move (90 degrees)
+                        offset=90;
+                        sprint(self.owner,"Wisp halted!\n");
+                }
+                mf=0;
+                ang=self.angles;
+                ang_x=anglemod(ang_x+offset);
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                ang_x=anglemod(ang_x-offset);
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                ang_x=anglemod(ang_x+offset);
+                ang_y=anglemod(ang_y+offset);
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                ang_x=anglemod(ang_x+offset);
+                ang_y=anglemod(ang_y-offset);
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                ang_y=anglemod(ang_y+offset);
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                ang_y=anglemod(ang_y-offset);
+                makevectors(ang);
+                        traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                ang_x=anglemod(ang_x-offset);
+                ang_y=anglemod(ang_y+offset);
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                ang_x=anglemod(ang_x-offset);
+                ang_y=anglemod(ang_y+offset);
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                ang=self.angles;
+                makevectors(ang);
+                traceline(self.origin,self.origin+v_forward*dist,TRUE,self);
+                if(trace_fraction>mf)
+                {
+                        mf=trace_fraction;
+                        sel=ang;
+                }
+                self.angles=sel;
+                makevectors(sel);
+                self.velocity=v_forward*spd;
+        }
+        else
+        {       // no obstacle in sight, change course a little, but unpredictably
+                ang=self.angles;
+                r=random()*10 - 5;
+                ang_x=anglemod(ang_x+r);
+                r=random()*10 - 5;
+                ang_y=anglemod(ang_y+r);
+                self.angles=ang;
+                makevectors(ang);
+                self.velocity=v_forward*200;
+        }
+        self.think=WispThink;
+        self.nextthink=time+0.1;
+};
+
+entity () WispFindTarget =
+{       // Find nearest valid target
+	local entity head, selected;
+	local float dist;
+	dist = 100000;
+	selected = world;
+	head = findradius(self.origin, 100000);
+	while(head)
+	{
+                if( (head.health > 1) && (head != self) && (head != self.owner) && head.classname != "door" && head.classname != "monster_zombie")
+		{
+			traceline(self.origin,head.origin,TRUE,self);
+			if ( (trace_fraction >= 1) && (vlen(head.origin - self.origin) < dist) )
+			{
+				selected = head;
+				dist = vlen(head.origin - self.origin);
+			}
+		}		
+		head = head.chain;
+	}
+        if (selected != world)
+	{
+                sprint (self.owner,"Wisp: attacking ");
+		if (selected.classname == "player")
+                        sprint (self.owner,selected.netname);
+		else
+			sprint (self.owner,selected.classname);
+		sprint (self.owner,"\n");
+	}
+	return selected;
+};
+
+void () WispReset =
+{
+        self.wisp_state=WISP_HUNT;
+        self.wisp.enemy=world;
+        self.wisp.angles=self.angles;
+};
+
+void () WispActivate =
+{
+        local entity newwisp;
+        newwisp=spawn();
+        newwisp.solid=SOLID_BBOX;
+        newwisp.movetype=MOVETYPE_FLY;
+        newwisp.classname="wisp";
+        newwisp.owner=self;
+
+        self.wisp=newwisp;
+        self.wisp_flag=TRUE;
+        newwisp.th_pain=Wisp_Pain;
+        newwisp.th_die=Wisp_Die;
+        newwisp.takedamage=TRUE;
+        self.wisp_stuck=FALSE;
+        self.wisp_porg='0 0 0';
+        self.wisp_view=FALSE;
+        WispReset();
+        if (deathmatch || coop)
+        {
+                newwisp.health = 110;
+		    setmodel(newwisp,"progs/eyes.mdl");
+        }
+        else
+        {
+                newwisp.health = 60;
+                    setmodel(newwisp,"progs/lavaball.mdl");
+        }
+        newwisp.takedamage=DAMAGE_AIM;
+
+/*
+//	  Moved to the If's above for Deathmatch play! :)
+//	  By Kenneth Livingston   -=CT=-KALWeb  (underhill@geocities.com
+//	  						  or underhill@netpass.com)
+        setmodel(newwisp,"progs/lavaball.mdl");
+        setmodel(newwisp,"progs/eyes.mdl");
+*/
+
+        setsize(newwisp,'-4 -4 -4','4 4 4');
+        setorigin(newwisp,self.origin+'0 0 16');
+
+        spawn_tfog(newwisp.origin);
+        sprint(self,"Wisp summoned!\n");
+        newwisp.nextthink=time+0.1;
+        newwisp.think=WispThink;
+};
+
+void () WispDeactivate =
+{
+        if(self.owner.wisp_view==TRUE)
+                WispToggleView();
+        spawn_tfog(self.wisp.origin);
+        self.wisp.nextthink=time+0.1;
+        self.wisp.think=SUB_Remove;
+        self.wisp_flag=FALSE;
+        sprint(self,"Wisp Banished!\n");
+
+};
+
+void () WispToggle =
+{
+        if(self.wisp_flag)
+                WispDeactivate();
+        else
+                WispActivate();
+};
+
+void (entity tgt) WispFire =
+{       // Fire lightning at enemy
+        local vector org;
+        sound (self, CHAN_WEAPON, "weapons/lhit.wav", 1, ATTN_NORM);
+        org=self.origin;
+
+        WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	WriteByte (MSG_BROADCAST, TE_LIGHTNING2);
+	WriteEntity (MSG_BROADCAST, self);
+	WriteCoord (MSG_BROADCAST, org_x);
+	WriteCoord (MSG_BROADCAST, org_y);
+	WriteCoord (MSG_BROADCAST, org_z);
+	WriteCoord (MSG_BROADCAST, trace_endpos_x);
+	WriteCoord (MSG_BROADCAST, trace_endpos_y);
+	WriteCoord (MSG_BROADCAST, trace_endpos_z);
+
+        LightningDamage(org,self.enemy.origin,self,5);
+};
+
+void () WispRecall =
+{       // Teleport wisp to self
+        if(!self.wisp_flag)
+        {
+                sprint(self,"Wisp hasn't been summoned.\n");
+                return;
+        }
+        spawn_tfog(self.wisp.origin);
+        setorigin(self.wisp,self.origin+'0 0 16');
+        spawn_tfog(self.wisp.origin);
+        self.wisp_stuck=FALSE;
+        self.wisp_porg='0 0 0';
+        self.wisp.think=WispThink;
+        self.wisp.nextthink=time+0.1;
+        WispReset();
+};
diff -ur --new-file v106qc/world.qc kalq-src/world.qc
--- v106qc/world.qc	Thu Sep 26 11:15:40 1996
+++ kalq-src/world.qc	Tue Oct 22 15:02:20 1996
@@ -173,6 +173,7 @@
 {
 	lastspawn = world;
 	InitBodyQue ();
+	item_to_exchange = world;
 
 // custom map attributes
 	if (self.model == "maps/e1m8.bsp")
@@ -180,6 +181,7 @@
 	else
 		cvar_set ("sv_gravity", "800");
 
+	
 // the area based ambient sounds MUST be the first precache_sounds
 
 // player precaches	
@@ -271,6 +273,7 @@
 	precache_model ("progs/v_shot2.mdl");
 	precache_model ("progs/v_nail2.mdl");
 	precache_model ("progs/v_rock2.mdl");
+        precache_model ("progs/v_spike.mdl");           // for grappling hook
 
 	precache_model ("progs/bolt.mdl");		// for lightning gun
 	precache_model ("progs/bolt2.mdl");		// for lightning gun
@@ -281,6 +284,8 @@
 	precache_model ("progs/grenade.mdl");
 	precache_model ("progs/spike.mdl");
 	precache_model ("progs/s_spike.mdl");
+//      precache_model ("progs/star.mdl");
+//      precache_model ("progs/bit.mdl");
 
 	precache_model ("progs/backpack.mdl");
 
