#ifndef QSLIST_H
#define QSLIST_H

#define DEFAULT_Q2_PORT		27910

#define MAX_SERVERS			2048

#ifdef _WIN32
#include <sys/timeb.h>
#include <winsock.h>
int gettimeofday(struct timeval *now, void *tz);
#else
#include <sys/time.h>
#include <unistd.h>
#endif

#include "sock.h"

#define MAX_STRING		128

#define MAX_PING		9999

typedef enum {
	S_INIT,		/* not yet opened */
	S_ADDROK,	/* address already resolved */
	S_OPEN,		/* socket opened */
	S_UP,		/* sent query, got response */
	S_DOWN,		/* sent query, got no response */
	S_UNKNOWN,	/* unknown */
} sstatus_t;

typedef struct serverinfo_t{ /* FIXME */
	int sd;
	struct sockaddr_in sockaddr;
	char host[MAX_STRING];
	int port;
	struct timeval qtime;	/* last query time */
	sstatus_t status;
	int closed;
	int numquery;

	int pingtotal, pingmax, pingmin;
	int nping;

	int ping;
	char hostname[MAX_STRING], map[MAX_STRING], version[MAX_STRING];
	char game[MAX_STRING], protocol[MAX_STRING];
	int numplayers, maxplayers;
	int timelimit, fraglimit;
	int dmflags;
} serverinfo_t;

extern int verbose;
int ServerSendQuery();
int ServerOpen();
int ServerClose();
int ServerGetInfo();
long int timediff(struct timeval *t1, struct timeval *t2);

#endif
