#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "qslist.h"
#include "sock.h"
#include "sockio.h"

char q2_request[] = { 
	'\xff', '\xff', '\xff', '\xff',
	's', 't', 'a', 't', 
	'u', 's', '\n', '\0',
	'\0', '\0', '\0', '\0',
	'\0', '\0', '\0', '\0',
};

char q2_request2[]  = {
	'\xff', '\xff', '\xff', '\xff',
	'i', 'n', 'f', 'o',
	' ', '3', '0', '\0',	/* 30 = version 3.10 */
};

extern int qtimeout, qretries, qretrydelay;
extern int numactive;
extern int numup, numdown, numunknown;

int ServerClose(si, st)
serverinfo_t *si;
sstatus_t st;
{
	int savelist = numactive;

	if (verbose > 0) printf("%s, %d=Close[open=%d]\n", si->host, si->port, numactive-1);

	if (si->closed) return(0);

	switch (st){
		case S_UP:
			if (si->status != S_UP && si->status != S_DOWN) ++numup;
			si->status = S_UP;
			break;
		default:
			if (si->ping != -1){
				if (si->status != S_UP && si->status != S_DOWN) ++numup;
				si->status = S_UP;
			}
			else {
				if (si->status != S_UP && si->status != S_DOWN) ++numdown;
				si->status = S_DOWN;
			}
			break;
	}

	if (savelist && numactive == 0){
		extern char sourcefile[];
		extern char savelist[];
		extern int saveserverlist();
		extern struct timeval starttime;
		extern struct timeval endtime;
		extern long totalquerytime;

		gettimeofday(&endtime, NULL);
		totalquerytime = timediff(&starttime, &endtime);

		if (!strcmp(savelist, "yes")) saveserverlist(sourcefile);
	}

	si->closed = 1;
	--numactive;

	SockClose(si->sd);
	return(0);
}

int ServerOpen(si)
serverinfo_t *si;
{

	if (si->status == S_INIT || si->status == S_ADDROK){
		++numactive;
		if (verbose > 0) printf("%s, %d, UDP=OPEN[open=%d]...\n", si->host, si->port, numactive);
		if (si->status == S_ADDROK)
			si->sd = SockOpen(si->host, si->port, SOCK_DGRAM, &si->sockaddr);
		else
			si->sd = SockOpen(si->host, si->port, SOCK_DGRAM, NULL);

		if (si->sd != INVALID_SOCKET){
			extern struct sockaddr_in insock; /* from sock.c, inited in SockOpen */
			si->status = S_OPEN;
			si->numquery = 0;
			memcpy(&si->sockaddr, &insock, sizeof(insock));
		}
		else {
			ServerClose(si, S_DOWN);
		}
	}
	return(0);
}

long int timediff(struct timeval *t1, struct timeval *t2)
{
	unsigned long int us1, us2, diff;

	us1 = (t1->tv_sec * 1000) +(t1->tv_usec / 1000);
	us2 = (t2->tv_sec * 1000) +(t2->tv_usec / 1000);


	if (us1 < us2)
		diff = us2 -us1;
	else
		diff = us1 -us2;

/*
	printf("sec1=%d,usec1=%d, sec2=%d,usec2=%d\n",
		t1->tv_sec, t1->tv_usec, t2->tv_sec, t2->tv_usec);

	printf("TIME: %d s, %d us, %d s, %d us = %d\n",
	t1->tv_sec, t1->tv_usec,
	t2->tv_sec, t2->tv_usec, diff);
*/

	return(diff);
}

#ifdef _WIN32
int gettimeofday(struct timeval *now, void *tz)
{
    struct timeb tb;

    ftime(&tb);
    now->tv_sec= tb.time;
    now->tv_usec= (unsigned int)tb.millitm * 1000;

	return(0);
}
#endif

int ServerSendQuery(si)
serverinfo_t *si;
{
	int stat = 0;
	struct timeval now;

	if (si->status == S_OPEN){
		gettimeofday(&now, NULL);
		if (si->numquery == 0 || (timediff(&(si->qtime), &now) > (qtimeout*1000))){
			if ((si->numquery == 0) || (si->numquery < qretries && (timediff(&(si->qtime), &now) > (qretrydelay*1000)))){
				++(si->numquery);
				if (verbose > 1) printf("ServerWrite(%s, %d, %d)...", si->host, si->port, si->numquery);
				gettimeofday(&si->qtime, NULL);
				if (strlen(si->map) == 0)
					stat = SockWrite(si->sd,
						(char *) &q2_request, sizeof(q2_request));
				else{
					if (strlen(si->protocol) == 2){
						q2_request2[9] = si->protocol[0];
						q2_request2[10] = si->protocol[1];
					}
					stat = SockWrite(si->sd,
						(char *) &q2_request2, sizeof(q2_request2));
				}

				if (verbose > 1) printf("stat=[%d]\n", stat);
				if (stat < 0){
					ServerClose(si, S_DOWN);
					return(1);
				}
			}
			else if (si->numquery >= qretries){
				/* timed out */
				stat = 1;
				ServerClose(si, S_DOWN);
			}
		}
	}

	return(stat);
}

typedef struct {
	char varname[MAX_STRING];
	char value[MAX_STRING];
} qvar;

#define MAX_QVARS			1024

qvar qvarlist[MAX_QVARS];

/*
 * var-value in  "\varname1\value1\varname2\value2\varnameN\valueN" "\n"
 */
qvar *getqvar(qv, s)
qvar *qv;
char *s;
{
	char *vname, *vval;
	char ts;

	if (s && s[0] == '\\'){
		s++;
		vname = s;
				

		s = strchr(vname, '\\');

		if (!s) return(NULL);
		*s = '\0';

		s++ ;
		vval = s;
		s = strchr(vval, '\\');
		if (!s){ /* end of variable list? */
			s = strchr(vval, '\n');
			if (!s) return(NULL);
		}
		ts = *s;
		*s = '\0';

		if (qv != NULL){
			if (qv->varname != NULL) strcpy(qv->varname, vname);

			if (qv->value != NULL) strcpy(qv->value, vval);

			*s = ts;

			return(qv);
		}
	}
	return(NULL);
}


int parseinfo(si, buf)
serverinfo_t *si;
char *buf;
{
	int j = strlen(buf) -1;

	/* parse backwards, server hostname may have spaces */
	/* remove white spaces */
	/* get maxplayers */
	while (j>=0 && isspace(buf[j])) j--;
	buf[j+1] = 0;
	while (j>=0 && isdigit(buf[j])) j--;
	si->maxplayers = atoi(buf+j+1);

	/* get numplayers */
	while (j>=0 && !isdigit(buf[j])) j--;
	buf[j+1] = 0;
	while (j>=0 && isdigit(buf[j])) j--;
	si->numplayers = atoi(buf+j+1);

	/* get mapname */
	while (j>=0 && isspace(buf[j])) j--;
	buf[j+1] = 0;
	while (j>=0 && isalnum(buf[j])) j--;
	strcpy(si->map, buf+j+1);

	/* get hostname */
	// no need to get hostname

	return(0);
}


int ServerParseInfo(si, buf)
serverinfo_t *si;
char *buf;
{
	int nvars = 0;
	char *s;

	if (strstr(buf, "info\n") == buf){
		if (!strstr(buf, "wrong version")) parseinfo(si, buf);
		return(0);
	}
	s = strchr(buf, '\\');
	while (getqvar(&qvarlist[nvars], s)){
		if (verbose) printf("var(%s) = [%s]\n", qvarlist[nvars].varname, qvarlist[nvars].value);
		if (!strcmp(qvarlist[nvars].varname, "hostname")){
			strcpy(si->hostname, qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "map")){
			strcpy(si->map, qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "mapname")){
			strcpy(si->map, qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "version")){
			strcpy(si->version, qvarlist[nvars].value);
			si->version[4] = 0; /* FIXME: assumes verison is of format "n.mm ???" */
		}
		if (!strcmp(qvarlist[nvars].varname, "game")){
			strcpy(si->game, qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "protocol")){
			strcpy(si->protocol, qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "timelimit")){
			si->timelimit = atoi(qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "fraglimit")){
			si->fraglimit = atoi(qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "dmflags")){
			si->dmflags = atoi(qvarlist[nvars].value);
		}
		if (!strcmp(qvarlist[nvars].varname, "maxclients")){
			si->maxplayers = atoi(qvarlist[nvars].value);
		}
		s += strlen(qvarlist[nvars].varname) + strlen(qvarlist[nvars].value) +1 +1;

		nvars++;
	}
	return(nvars);
}

int ServerPrintInfo(si)
serverinfo_t *si;
{
	if (si->port == DEFAULT_Q2_PORT)
		printf("%20s       ", si->host);
	else
		printf("%20s:%d ", si->host, si->port);
	printf("%30s ", si->hostname);
	printf("%8s ", si->map);
	printf("%3d ", si->maxplayers);
	printf("%5d/%d\n", si->ping, si->numquery);
	return(1);
}

int ServerGetInfo(si)
serverinfo_t *si;
{
	char buf[SOCKREAD_MAX];
	int n;
	struct timeval now;
	int curping;

	if (((n=SockRead(si->sd, (char *) &buf, SOCKREAD_MAX)) > 0)
		&& buf[0] == '\xff' && buf[1] == '\xff' && buf[2] == '\xff' && buf[3] == '\xff'
		){

		gettimeofday(&now, NULL);
		curping = (int) timediff(&(si->qtime), &now);
		si->pingtotal += curping;
		++(si->nping);
		si->ping = si->pingtotal / si->nping;
		if (curping > si->pingmax) si->pingmax = curping;
		if (curping < si->pingmin) si->pingmin = curping;

		/* make sure it's null terminated */
		buf[n] = 0;

		n = ServerParseInfo(si, buf+4);
		ServerPrintInfo(si);
		ServerClose(si, S_UP);
	}
	else {
		ServerClose(si, S_DOWN);
	}

	return(n);
}


