#include "sock.h"
#include "sockio.h"



int sock_timeout_usec = 100;   /* timeout in milliseconds */
int sock_timeout_sec = 0;      /* timeout in seconds */



int SockReadLine(sd, buff, max)
int sd;
char *buff;
int max;
{

	int n = 0;
	char buf2[1024];
	int ok = 1;

	while (ok && n < max){
		if (NBSockRead(sd, buf2, 1) < 1) return(-1);
		if (buf2[0] == '\n') ok = 0;
		buff[n++] = buf2[0];
	}
	buff[n] = '\0';
	return(n);
}


int SockWriteLine(sd, buff)
int sd;
char *buff;
{
	int n;

	if ((n = NBSockWrite(sd, buff, strlen(buff)) < (int)strlen(buff))) return(-1);
	return(n);
}



/* Non-blocking socket read */
#ifdef __TURBOC__
int NBSockReadLine(sd, buff, max)
tcp_Socket *sd;
char *buff;
int max;
{
    int nread;
	if (sock_dataready(sd)) {
		nread = SockReadLine(sd, buff, max);
		if (nread != -1) buff[nread] = '\0';
		return(nread);
	}
	return(0);
}
#else

int NBSockReadLine(sd, buff, max)
int sd;
char *buff;
int max;
{
	struct timeval tv;
	fd_set rfds, trfds;
	int maxfd;
	int nread;

	FD_ZERO(&rfds);
	FD_SET(sd, &rfds);
	maxfd = sd +1;
	tv.tv_sec = sock_timeout_sec; /* blocks for secs */
	tv.tv_usec = sock_timeout_usec;
	trfds = rfds;
	if (select(maxfd, &trfds, NULL, NULL, &tv) == SOCKET_ERROR)
		perror("select:");

	if (FD_ISSET(sd, &trfds)){
		nread = SockReadLine(sd, buff, max);
		if (nread != -1) buff[nread] = '\0';
		return(nread);
	}
	return(0);
}

#endif

int NBSockWrite(sd, buff, len)
int sd;
char *buff;
int len;
{
	struct timeval tv;
	fd_set rfds, trfds;
	int maxfd;
	int nwrite;

	FD_ZERO(&rfds);
	FD_SET(sd, &rfds);
	maxfd = sd +1;
	tv.tv_sec = sock_timeout_sec;
	tv.tv_usec = sock_timeout_usec;
	trfds = rfds;

	if (select(maxfd, NULL, &trfds, NULL, &tv) == SOCKET_ERROR)
		perror("select:");

	if (FD_ISSET(sd, &trfds)){
		nwrite = SockWrite(sd, buff, len);
		return(nwrite);
	}

	return(0);
}


int NBSockRead(sd, buff, n)
int sd;
char *buff;
int n;
{
	int nb, where = 0;
	struct timeval tv;
	fd_set rfds, trfds;
	int maxfd;

	do{
		FD_ZERO(&rfds);
		FD_SET(sd, &rfds);
		maxfd = sd +1;
		tv.tv_sec = sock_timeout_sec;
		tv.tv_usec = sock_timeout_usec;
		trfds = rfds;

		if (select(maxfd, NULL, &trfds, NULL, &tv) == SOCKET_ERROR)
			perror("select:");

		if (FD_ISSET(sd, &trfds)){
			if ((nb=recv(sd, &(buff[where]), n-where, 0)) == SOCKET_ERROR){
	           	perror("Sock_Read: read failed");
				return(-1);
			}
		}
		else nb = 0;

		where += nb;
	} while(n-where > 0 && nb > 0 && n < SOCKREAD_MAX);

	return(where);
}

