#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include "qslist.h"
#include "sock.h"
#include "sockio.h"
#include "config.h"

/*#define MAIN */

#define DEFAULT_SOURCEFILE	"slist.dat"
#define DEFAULT_SOURCEURL	"http://204.182.161.21/q2servers/q2gamespy.txt"
/*
#define DEFAULT_SOURCEURL	"http://asp.planetquake.com/q2servers/q2gamespy.txt"
*/

char configfile[1024] = "slist.ini";
char source[1024] = "file";
char sourcefile[1024] = DEFAULT_SOURCEFILE;
char sourceurl[1024] = DEFAULT_SOURCEURL;
char savelist[1024] = "yes";
char saveonly[1024] = "all";
char autostart[1024] = "yes";

int started = 0;
int configread = 0;

#ifdef _WIN32
#include <winsock.h>
#endif

//#define DEBUG	1

#ifdef DEBUG
int verbose = DEBUG;
#else
int verbose = 0;
#endif

int qtimeout = 8;		/* query timeout in seconds */
int qretries = 1;		/* number of query retries */
int qretrydelay = 10;	/* number of seconds before retrying */

int maxactive = 8;
int curpage = 0;
int maxpage = 8;
int numpages = 0;
int listactive = 0;
int maxbookmark = 8;
int curitem = 0;

char *slist[MAX_SERVERS];
int numservers=0;

int numqueried;
int numactive;
int numup, numdown, numunknown;

serverinfo_t sinfo[MAX_SERVERS];
//serverinfo_t sorted[MAX_SERVERS];
int sorted[MAX_SERVERS];

Config slistcfg[] = {
	{ "source", "STR", source, "file", "", "Address List Source" },
	{ "sourcefile", "STR", sourcefile, DEFAULT_SOURCEFILE, "", "Local Address List File" },
	{ "sourceurl", "STR", sourceurl, DEFAULT_SOURCEURL, "", "URL of Address List Source" },
	{ "numbookmarks", "INT", &maxbookmark, 0, "", "Number of bookmark entries to save" },
	{ "savelist", "STR", savelist, "yes", "", "Save serverlist on exit?" },
	{ "saveonly", "STR", saveonly, "all", "", "What to save" },
	{ "autostart", "STR", autostart, "yes", "", "Start queries on startup?" },
};
#define NUMINI	(sizeof(slistcfg)/sizeof(Config))


int readfromfile();
int readfromhttp();


char statline[2048];
int statusline(char *format, ...)
{
        va_list         argptr;

        va_start (argptr, format);
        vsprintf (statline, format,argptr);
        va_end (argptr);

	printf("%s\n", statline);
        return(0);
}


int setrfds(rfds)
fd_set *rfds;
{
	int i;
	int maxfd = 0;
	
	FD_ZERO(rfds);
	for (i=0; i < numservers; i++){
		if (sinfo[i].status == S_OPEN && sinfo[i].numquery > 0){
			FD_SET(sinfo[i].sd, rfds);
			if (sinfo[i].sd > maxfd) maxfd = sinfo[i].sd;
		}
	}
	return(maxfd);
}

#ifndef MAIN
#include "../g_local.h"
#else
typedef void edict_t;
#endif

char entry[1024], str[2048];

int readfromfile(fname)
char *fname;
{
	FILE *fp;
	char line[80];

	fp = fopen(fname, "r");
	if (fp == NULL){ return(0); }

	while (fgets(line, 80, fp) != NULL){
		while (isspace(line[strlen(line)-1])){
			line[strlen(line)-1] = 0;
		}
		slist[numservers] = (char *)malloc(strlen(line)+1);
		strcpy(slist[numservers], line);
		++numservers;
	}

	fclose(fp);
	return(numservers);
}

/*
int scompare(s1, s2)
serverinfo_t *s1, *s2;
{
	if (s1->status == S_UP && s2->status == S_UP){
		if (s1->ping < s2->ping) return(-1);
		if (s1->ping > s2->ping) return(1);
		return(0);
	}
	if (s1->status == S_UP) return(-1);
	if (s2->status == S_UP) return(1);
	if (s1->status == S_OPEN) return(-1);
	if (s2->status == S_OPEN) return(1);

	return(0);
}
*/

int scompare(s1, s2)
int *s1, *s2;
{
	int i1 = *s1, i2 = *s2;
	if (sinfo[i1].status == S_UP && sinfo[i2].status == S_UP){
		if (sinfo[i1].ping < sinfo[i2].ping) return(-1);
		if (sinfo[i1].ping > sinfo[i2].ping) return(1);
		return(0);
	}
	if (sinfo[i1].status == S_UP) return(-1);
	if (sinfo[i2].status == S_UP) return(1);
	if (sinfo[i1].status == S_OPEN) return(-1);
	if (sinfo[i2].status == S_OPEN) return(1);

	return(0);
}

char *fmtstr(pg)
int pg;
{
	int i;
	static char str[2048];
	static int loopi=0;
	char entry[1024];
	char statusstr[64];
	int numping = 0;
	char statchars[] = {'-', '\\', '|', '/', };
	int stati;
	char serverport[1024];

	str[0] = 0;

	/* sort entries */
	for (i=0; i<numservers; i++){
		//memcpy(&sorted[i], &sinfo[i], sizeof(serverinfo_t));
		sorted[i] = i;
	}

	//qsort(sorted, numservers, sizeof(serverinfo_t), scompare);
	qsort(sorted, numservers, sizeof(int), scompare);

#ifndef MAIN
	for (i=0; i<maxbookmark; i++){
		sprintf(entry, "adr%d", i);
		if (sinfo[sorted[i]].port == DEFAULT_Q2_PORT)
			sprintf(serverport, "%s", sinfo[sorted[i]].host);
		else
			sprintf(serverport, "%s:%d", sinfo[sorted[i]].host,
				sinfo[sorted[i]].port);
		//gi.cvar_set(entry, sorted[i].host);
		gi.cvar_set(entry, serverport);
	}
#endif

	numping = numqueried - numactive;

	if (numservers > 0) numpages = ((numservers-1)/maxpage) +1;
	else numpages = 0;

	if (numping<numservers){
		stati = ++loopi % 4;
		sprintf(entry, "xv 8 yv 1 string2 \"qslist 0.99a %3d%% %d/%d %d%c up=%d dn=%d\" ", 
			(int)((numping*1.0/numservers) * 100), 
			numping, numservers, numactive, statchars[stati], numup, numdown);
	}
	else {
		sprintf(entry, "xv 8 yv 1 string2 \"qslist 0.99a up=%d/%d pg %d/%d\" ", 
			numup, numservers, curpage+1, numpages);
	}
	if (strlen(str)+strlen(entry) < 1024) strcat(str, entry);	


	curpage = curitem/maxpage;
	for (i=pg*maxpage; i<pg*maxpage +maxpage && i < numservers; i++){
		int y;

		y = 12 + (i%maxpage) * 21;
		//switch (sorted[i].status){
		switch (sinfo[sorted[i]].status){
			case S_INIT: sprintf(statusstr, " ----"); break; 
			case S_ADDROK: sprintf(statusstr, " ===="); break;
			case S_OPEN: sprintf(statusstr, " ++++"); break;
			//case S_UP: sprintf(statusstr, "%5d", sorted[i].ping); break;
			case S_UP: sprintf(statusstr, "%5d", sinfo[sorted[i]].ping); break;
			case S_DOWN: sprintf(statusstr, " DOWN"); break;	
			default: sprintf(statusstr, "????"); break;
		}

		//if (sorted[i].port == DEFAULT_Q2_PORT){
		if (sinfo[sorted[i]].port == DEFAULT_Q2_PORT){
			//sprintf(serverport, "%s", sorted[i].host);
			sprintf(serverport, "%s", sinfo[sorted[i]].host);
		}
		else {
			//sprintf(serverport, "%s:%d", sorted[i].host, sorted[i].port);
			sprintf(serverport, "%s:%d", sinfo[sorted[i]].host, sinfo[sorted[i]].port);
		}

		//sprintf(entry, "xv 2 yv %d string2 \"%3d %s %s %s\" ", 
		//	y, i+1, statusstr, sorted[i].version, serverport);
		sprintf(entry, "xv 2 yv %d string2 \"%c%3d %s %2d/%2d %s\" ", 
			y, i==curitem? '>':' ', i+1, statusstr,
			/*
			sinfo[sorted[i]].version,
			*/
			sinfo[sorted[i]].numplayers,
			sinfo[sorted[i]].maxplayers,
			serverport
			);
		
		if (strlen(str)+strlen(entry) < 1024) strcat(str, entry);
		
		//sprintf(entry, "xv 2 yv %d string2 \"%9s %s\" ", 
		//	y+9, sorted[i].map, sorted[i].hostname);
		sprintf(entry, "xv 2 yv %d string \"%10s %s\" ", 
			y+9, sinfo[sorted[i]].map, sinfo[sorted[i]].hostname);
		if (strlen(str)+strlen(entry) < 1024) strcat(str, entry);

		if (i==curitem && sinfo[sorted[i]].status == S_UP){
			y = 12 + (maxpage) * 21 + 2 + 9;
			sprintf(entry, "xv 8 yv %d string \"ver:%s prot:%s %s%s\" ",
			y,
			sinfo[sorted[i]].version,
			sinfo[sorted[i]].protocol,
			strlen(sinfo[sorted[i]].game)>0? "game:":"",
			sinfo[sorted[i]].game
			);
			if (strlen(str)+strlen(entry) < 1024) strcat(str, entry);


			sprintf(entry, "xv 8 yv %d string \"time:%d frag:%d dmflags:%s\" ",
			y+9,
			sinfo[sorted[i]].timelimit,
			sinfo[sorted[i]].fraglimit,
			sinfo[sorted[i]].dmflags

			);
			if (strlen(str)+strlen(entry) < 1024) strcat(str, entry);
		}
	}

	/* print the status line */
	//sprintf(entry, "xv 8 yv 10 string2 \"%s\" ", statline);
	//if (strlen(str)+strlen(entry) < 1024) strcat(str, entry);	

	return(str);
}


int displaylist(ent, pg)
edict_t *ent;
int pg;
{
	char *s;
	
	s = fmtstr(pg);

#ifndef MAIN
	ent->client->showscores = true;
	ent->client->showinventory = false;

	gi.WriteByte (svc_layout);
	gi.WriteString (s);
	gi.unicast (ent, false);
#endif

	return(0);
}

int qslistloop(ent)
edict_t *ent;
{
	int listupdated = 0;
	int stat = 0;
	int i;
	int maxfd;
	fd_set rfds, efds;
	struct timeval tv;

	if (!configread){
		if (readconfig(configfile, "", slistcfg, NUMINI) == -1){
			printf("Cannot open configfile[%s]... using defaults.\n", configfile);
		}
		configread = 1;
	}

	if (!started && strstr(autostart, "yes")){
		started = 1;
		qslist(ent);
		return(0);
	}

	if (numactive > 0){

		tv.tv_usec = 5;
		tv.tv_sec = 0;

		/* read replies*/
		maxfd = setrfds(&rfds);
		efds = rfds;
		stat = select(maxfd, &rfds, NULL, &efds, &tv);
		if (stat > 0){ /* */
			if (verbose > 3) printf("select > 0\n");
			for (i=0; i<numservers; i++){
				if (verbose > 2) printf("server=%s\n", sinfo[i].host);
/*
				if (FD_ISSET(sinfo[i].sd, &efds)){
					ServerClose(&sinfo[i], S_DOWN);
				}
*/
				if (sinfo[i].status == S_OPEN && FD_ISSET(sinfo[i].sd, &rfds)){
					ServerGetInfo(&sinfo[i]);
				}
			}
		}


		/* timeout: send query to all open servers */
		if (stat == 0){
			for (i=0; i < numservers; i++){
				listupdated += ServerSendQuery(&sinfo[i]);
			}
		}

		if (stat > 0 || listupdated){
			displaylist(ent, curpage);
			listupdated = 0;
		}

	};

	/* open other servers if possible */
	while ((numactive < maxactive) && (numqueried < numservers)){
		ServerOpen(&sinfo[numqueried]);
		ServerSendQuery(&sinfo[numqueried]);
		numqueried++;
		listupdated = 1;
	}

	if (listupdated || listactive){
		displaylist(ent, curpage);
		listupdated = 0;
	}

	return(0);
}



#ifdef MAIN
int main(argc, argv)
int argc;
char *argv[];
#else
int qslist(ent)
edict_t *ent;
#endif
{
#ifdef MAIN
#ifdef _WIN32
    WORD version =  MAKEWORD(1, 1);  /* winsock version 1.1 */
    WSADATA wsadata;
	int rc;
#endif
#endif

	int i;


#ifdef MAIN
#ifdef _WIN32

    rc = WSAStartup(version, &wsadata);
    if(rc) {
        printf("Error Initializing Winsock: %d\n", rc);
        exit;
    }

#ifdef DEBUG
    printf("Windows Sockets: %-40s\n", wsadata.szDescription);
    printf("System status:   %-40s\n", wsadata.szSystemStatus);
    printf("Winsock version: %04x\n", wsadata.wVersion);
    printf("Max Sockets:     %d\n", wsadata.iMaxSockets);
    printf("Max Datagram:    %d\n", wsadata.iMaxUdpDg);
#endif

#endif
#endif

	if (readconfig(configfile, "", slistcfg, NUMINI) == -1){
		printf("Cannot open configfile[%s]... using defaults.\n", configfile);
	}
	configread = 1;

	for (i=0; i< NUMINI; i++){
		printvar(&slistcfg[i]);
	}

	while (numservers > 0){
		free(slist[--numservers]);
	}
	numup = numdown = numunknown = 0;
	numactive = 0;
	numqueried = 0;

	curpage = 0;
	curitem = 0;
	listactive = 1;

	if (strstr(source, "file")){
		statusline("reading file [%s]...", sourcefile);
		readfromfile(sourcefile);
		statusline("");
	}
	if (strstr(source, "http")){
		statusline("getting url [%s]...", sourceurl);
		readfromhttp(sourceurl);
		statusline("");
	}

	//remove duplicates: not yet finished
	//qsort(slist, numservers, sizeof(char *), strcmp);
	//for (i=1; i<numservers; i++){
	//	if (!strcmp(slist[i],slist[i-1])){
	//		strcpy(slist[i-1], "");
	//	}
	//}

	for (i=0; i < numservers; i++){
		char *s;
		char stmp[1024];
		if (verbose > 2) printf("slist[%d]=[%s]\n", i, slist[i]);

		sprintf(stmp, "%s:%d", sinfo[i].host, sinfo[i].port);
		if (strcmp(stmp, slist[i])){
			/* changed, use new sockaddr */
			sinfo[i].status = S_INIT;
		}
		else sinfo[i].status = S_ADDROK;

		strncpy(sinfo[i].host, slist[i], MAX_STRING);

		if ((s = strchr(sinfo[i].host, ':')) != NULL){
			*s = '\0';
			s++;
			sinfo[i].port = atoi(s);
		}
		else sinfo[i].port = DEFAULT_Q2_PORT;

		strcpy(sinfo[i].map, "");
		strcpy(sinfo[i].hostname, "");
		strcpy(sinfo[i].version, "");
		sinfo[i].numplayers = 0;
		sinfo[i].maxplayers = 0;
		sinfo[i].ping = -1;
		sinfo[i].infocomplete = 0;
	}

	if (verbose) printf("querying %d servers...\n", numservers);

#ifdef MAIN
	while (numqueried < numservers){
		qslistloop(NULL);
	}
#else
	qslistloop(ent);
#endif

/*
	printf("LIST\n");
	for (i=0; i<numservers; i++){
		if (sinfo[i].status == S_UP){
			printf("%20s:%d %30s %8s %5d\n",
				sinfo[i].host, sinfo[i].port, sinfo[i].hostname, sinfo[i].map, sinfo[i].ping);
		}
	}
*/

#ifdef MAIN
#ifdef _WIN32
    WSACleanup();
#endif
#endif

	return(0);
}

void stuffcmd(ent, cmd)
edict_t *ent;
char *cmd;
{
#ifndef svc_stuffcmd
#define svc_stuffcmd	11
#endif
#ifndef MAIN
	gi.WriteByte(svc_stuffcmd);
	gi.WriteString(cmd);
	gi.unicast(ent, true);
#endif
}


int saveserverlist(fname)
char *fname;
{
	int i;
	FILE *fp;
	char serverport[1024];

	fp = fopen(fname, "w");
	if (!fp) return(0);
	for (i=0; i<numservers; i++){
		if (sinfo[sorted[i]].port == DEFAULT_Q2_PORT)
			sprintf(serverport, "%s", sinfo[sorted[i]].host);
		else
			sprintf(serverport, "%s:%d", sinfo[sorted[i]].host,
				sinfo[sorted[i]].port);

		if (strstr(saveonly, "up")){
			if (sinfo[sorted[i]].status == S_UP)
				fprintf(fp, "%s\n", serverport);
		}
		else
			fprintf(fp, "%s\n", serverport);
	}
	fclose(fp);
	return(numservers);
}

void Cmd_Slist_f(ent)
edict_t *ent;
{
	int i;
	char command[2048];
	/*
	Com_sprintf(entry, sizeof(entry), "xv 64 yv 64 picn tag1 ");
	if (strlen(str)+strlen(entry) < 1024) strcat(str, entry);
	*/

#ifndef MAIN
	if (numservers > 0) numpages = ((numservers-1)/maxpage) +1;
	else numpages = 0;
	if (gi.argc() > 1){
		i = 1;
		//for (i=1; i< gi.argc(); i++){
			if (!strcmp(gi.argv(i), "page")){
				if (i+1 < gi.argc()){
					if (strstr(gi.argv(i+1), "prev")){
						if (curpage > 0) --curpage;
					}
					else if (strstr(gi.argv(i+1), "next")){
						if (curpage < numpages-1) ++curpage;
					}
					else {
						curpage = atoi(gi.argv(i+1));
					}
					curitem = curpage * maxpage;

					i++;
					listactive = 1;
					displaylist(ent, curpage);
				}
			}
			else if (!strcmp(gi.argv(i), "close")){
				listactive = 0;
				ent->client->showscores = false;
			}
			else if (!strcmp(gi.argv(i), "item")){
				if (i+1 < gi.argc()){
					if (strstr(gi.argv(i+1), "prev")){
						if (curitem > 0) --curitem;
					}
					else if (strstr(gi.argv(i+1), "next")){
						if (curitem < numservers-1) ++curitem;
					}
					else {
						curitem = atoi(gi.argv(i+1));
					}
					displaylist(ent, curpage);
				}
			}
			else if (!strcmp(gi.argv(i), "connect")){
				printf("connecting to %s:%d...\n",
					sinfo[sorted[curitem]].host,
					sinfo[sorted[curitem]].port);
				sprintf(command, "connect %s:%d\n", 
					sinfo[sorted[curitem]].host,
					sinfo[sorted[curitem]].port);
				stuffcmd(command);
			}
			else if (!strcmp(gi.argv(i), "save")){
				if (i+1 < gi.argc())
					saveserverlist(gi.argv(i+1));
				else
					saveserverlist(sourcefile);
			}
			//else {
				/* try to get cvars at cmdline */
				//configline(gi.args(), slistcfg, NUMINI);
			//}
		//}
	}
	else qslist(ent);
#endif

}


