#include <stdio.h>
#include <ctype.h>
#include "sockio.h"
#include "qslist.h"

/*
	versy simple http get
	does not handle redirects!
*/

int parseurl();

int readfromhttp(url)
char *url;
{
	char hostname[2048], path[2048];
	char request[2048];
	int port;
	int sd;
	char line[SOCKREAD_MAX];
	int nread, indoc;
	extern char *slist[];
	extern int numservers, verbose;

	if (parseurl(url, hostname, path, &port) == -1) return(-1);

	if (verbose) fprintf(stderr, "CONNECT %s:%d\n", hostname, port);
	sd = SockOpen(hostname, port, SOCK_STREAM, NULL);
	if (sd == INVALID_SOCKET){
		if (verbose) printf("Invalid socket.\n");
		 return(-1);
	}

	if (verbose) fprintf(stderr, "GET %s HTTP/1.0\n", path);
	sprintf(request, "GET %s HTTP/1.0\n\n", path);
	SockWriteLine(sd, request);

	indoc = 0;
	while ((nread = SockReadLine(sd, line, SOCKREAD_MAX)) > 0
			&& numservers < MAX_SERVERS){

		line[nread] = 0;
		/* remove white spaces */
		while (isspace(line[strlen(line)-1])){
			line[strlen(line)-1] = 0;
		}

		if (indoc && strlen(line) > 2){
			if (verbose) printf("%d [%s] (%d)\n", numservers, line, nread);
			slist[numservers] = (char *)malloc(strlen(line)+1);
			strcpy(slist[numservers], line);
			++numservers;
		}
		else {
			/* still in header lines */
			/* start of document? */
			if (strlen(line) == 0) indoc = 1;
		}
	}

	return(numservers);
}


int parseurl(xurl, hostname, path, port)
char *xurl;
char *hostname;
char *path;
int *port;
{
	char httpstr[] = "http://";
	char url[2048];
	char *s, *p;

	strcpy(hostname, "");
	strcpy(path, "/");
	*port = 80;

	strcpy(url, xurl);
	if ((s=strstr(url, httpstr)) == NULL){
		return(-1);
	}
	p = url+strlen(httpstr);

	/* search for port number if present */
	if ((s=strstr(p, ":")) == NULL){
		/* "http://hostname/path" format */
	
		if ((s=strstr(p, "/")) == NULL){
			/* "http://hostname.com" format */
			strcpy(hostname, p);
		}
		else {
			/* "http://hostname.com/path" format */
			*s = 0;
			strcpy(hostname, p);
			*s = '/';
			strcpy(path, s);
		}
	}
	else {
		/* "http://hostname:port/path" format */

		/* get hostname part */
		*s = 0;
		strcpy(hostname, p);
		p = s+1;

		/* get port part */
		if ((s=strstr(p, "/")) == NULL){
			/* "http://hostname.com:port" format */
			*port = atoi(p);
		}
		else {
			/* "http://hostname.com:port/path" format*/
			*s = 0;
			*port = atoi(p);
			*s = '/';
			strcpy(path, s);
		}
	}
	return(0);
}


#ifdef TEST
int main()
{
	char *reply;

/*	reply = geturl("http://asp.planetquake.com/q2servers/q2gamespy.txt");
*/
	reply = geturl("http://erika/");
	printf("%s\n", reply);
}
#endif
