/***************************************************************************
 *
 *                                Quake Admin v3.0
 *			Created By: MHacker (mhacker@HToC.com)
 *
 **************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../include/qadmin.h"

static Admin *adminlist = NULL;
static User *userlist = NULL;

void load_userfile(char *ufile)
{
   char line[100];
   char *host[100];
   char *temp;
   Admin *adminlist = NULL;
   Admin *u = NULL;
   int x = 0;
   FILE *fp;
   fp = fopen(ufile, "r");
   if (!fp) {
	log(LOGFILE, "--- Error: Cannot open userfile!\n");
	exit(1);
   }
   while (!feof(fp)) {
	fgets(line, 80, fp);
	if(feof(fp))
	   break;
	strip_newline(line);
	if (match(line, "=\t")) {
	printf("%s\n", line);
        return;
	}
        if (line[0] == ';') {
           if((strstr(line, "$C")) && (!u_encrypt)) {
              fprintf(stderr, "\nAttempted to Load an encrypted userfile with encrypted passwords turned off.\n");
              fprintf(stderr, "Exiting...\n");
	      exit(1);
	   }
           if((strstr(line, "$U")) && (u_encrypt)) {
              fprintf(stderr, "\nAttempted to Load an uncrypted userfile with encryption turned on.\n");
              fprintf(stderr, "Encrypting as I load...\n");
	      sleep(1);
              cryptpwds = 1;
           }
        }
	if (line[0] == '*') {
	   x = 0;
	   temp = strtok(line, "*\t");
	   u = newadmin(temp);
        } else if (line[0] == '=') {
	   temp = strtok(line, "=\t");
           if (cryptpwds)
	      temp = cryptit(temp);
	   strcpy(u->password, temp);
        } else if (line[0] == '+') {
	   temp = strtok(line, "+\t");
	   u->level = atoi(temp);
        } else if (line[0] == '-') {
	   temp = strtok(line, "-\t");
	   temp = strtok(temp, ", ");
           u->host[x] = sstrdup(temp);
	   x++;
	   if (temp = strtok(NULL, ", ")) {
             u->host[x] = sstrdup(temp);
	     x++;
	   }
	   if (temp = strtok(NULL, ", ")) {
             u->host[x] = sstrdup(temp);
	     x++;
	   }
	   u->hosts = x;
	}
   }
   fclose(fp);
   if (cryptpwds) {
      save_userfile(); 
      cryptpwds = 0;
   }
}

int valid(char *nick, char *host) {
   int x;
   Admin *user;
   user = findadmin(nick);
   x = 0;
   while (x < user->hosts) {
      if (match(user->host[x], host)) {
	return 1;
      }
      x++;
   }
   return 0;
}
       
   
Admin *newadmin(const char *nick)
{
   Admin *user;

   user = scalloc(sizeof(Admin), 1);
   if (!nick)
      nick = "";
   strncpy(user->nick, nick, 10);
   user->next = adminlist;
   if (adminlist)
      adminlist->prev = user;
   adminlist = user;
   return user;
}

void *scalloc(long elsize, long els)
{
   void *buf = calloc(elsize, els);
   return buf;
}

Admin *findadmin(char *nick)
{
   Admin *user = adminlist;
   while (user && !match(user->nick, nick))
	user = user->next;
   return user;
}

void del_admin(Admin *admin)
{
   free(admin->host);
   free(admin->password);

   if (admin->prev)
      admin->prev->next = admin->next;
   else
      adminlist = admin->next;

   if (admin->next)
      admin->next->prev = admin->prev;

   free(admin);
}

int checkpass(char *string, char *pass) {
   char *cpass;
   char salt[3];
   char plaintext[100];
   bzero(plaintext, sizeof(plaintext));
   sprintf(plaintext, "%s", string);
   salt[0] = plaintext[0];
   salt[1] = plaintext[1];
   salt[2] = 0;
   cpass = crypt(pass, salt);
   if (strcmp(cpass, string))
      return 0;
   else
      return 1;
}

void save_userfile()
{
   FILE *fp;
   int x;
   Admin *user = adminlist;
   fp = fopen(userfile, "w");
   if (!fp) {
      log(LOGFILE, "[%s] *** Error Writing Userfile - %s\n", strerror(errno));
      fclose(fp);
      return;
   }
   if (u_encrypt)
      fprintf(fp, ";$C Userfile for Quake Administration v%s (c) 1998 HToC\n", VERSION);
   else
      fprintf(fp, ";$U Userfile for Quake Administration v%s (c) 1998 HToC\n", VERSION);
   fprintf(fp, "; Last saved on %s\n", date());
   fprintf(fp, "; Do *NOT* Modify this file if you don't know what your doing.\n");

   while (user) {
      x = 0;
      fprintf(fp, "\n");
      fprintf(fp, "*\t%s\n", user->nick);
      fprintf(fp, "=\t%s\n", user->password);
      fprintf(fp, "+\t%d\n", user->level);
      if (user->hosts == 1)
         fprintf(fp, "-\t%s\n", user->host[0]);
      else if (user->hosts == 2)
         fprintf(fp, "-\t%s, %s\n", user->host[0], user->host[1]);
      else if (user->hosts == 3)
         fprintf(fp, "-\t%s, %s, %s\n", user->host[0], user->host[1], user->host[2]);
      else if (user->hosts == 4) {
         fprintf(fp, "-\t%s, %s, %s\n", user->host[0], user->host[1], user->host[2]);
         fprintf(fp, "-\t%s\n", user->host[3]);
      } else if (user->hosts == 5) {
         fprintf(fp, "-\t%s, %s, %s\n", user->host[0], user->host[1], user->host[2]);
         fprintf(fp, "-\t%s, %s\n", user->host[3], user->host[4]);
      } else if (user->hosts > 5) {
         fprintf(fp, "-\t%s, %s, %s\n", user->host[0], user->host[1], user->host[2]);
         fprintf(fp, "-\t%s, %s, %s\n", user->host[3], user->host[4], user->host[5]);
      }
      user = user->next;
   }
   fclose(fp);
}

User *newuser(char *nick) {
   User *user;

   user = scalloc(sizeof(User), 1);
   if (!nick)
      nick = "";
   strncpy(user->nick, nick, 10);
   user->next = userlist;
   if (userlist)
      userlist->prev = user;
   userlist = user;
   return user;
}

void free_admin() {
   Admin *admin = adminlist;
   while (admin) {
      free(admin->host);
      free(admin->password);
      free(admin);
      admin = admin->next;
   }
   adminlist = NULL;
}

User *finduser(char *nick) {
   User *user = userlist;
   while (user && !match(user->nick, nick))
      user = user->next;
   return user;
}
