/***************************************************************************
 *
 *                                Quake Admin v3.0
 *			Created By: MHacker (mhacker@HToC.com)
 *
 **************************************************************************/

#include <stdio.h>
#include <strings.h>
#include "../include/qadmin.h"

#define isvalid(c) (((c) >= 'A' && (c) <= '~') || isdigit(c))

char *date() {
   struct tm *time_now;
   time_t secs_now;
   tzset();
   time(&secs_now);
   time_now = localtime(&secs_now);
   strftime(strbuff, 30, "%b %m %I:%M:%S", time_now);
   return strbuff;
}

void *sstrdup(const char *s) {
   char *t = strdup(s);
   if (!t)
      raise(SIGUSR1);
   return t;
}

int Stricmp(s1, s2)
char *s1, *s2;
{
   int diff;

   while (!(diff = toupper(*s1) - toupper(*s2)) && *s1)
      s1++, s2++;

   return diff;
}

int do_name(char *nick) {
   char *ch;
   if (*nick == '-' || isdigit(*nick))
      return 0;

   for (ch = nick; *ch && (ch - nick) < 15; ch++)
      if (!isvalid(*ch) || isspace(*ch)) 
         break;

   *ch = '\0';
   return (ch - nick);

}

void center(char *text, int fd, int line) {
   int x, i;
   char test[2048];
   i = strlen(text);
   i = i / 2;
   x = 40 - i;
   
   sprintf(test, "[%d;%dH%s\n", line, x, text);
   writeln2(fd, test);
}

void center2(char *text, int line) {
   int x, i;
   char test[2048];
   i = strlen(text);
   i = i / 2;
   x = 40 - i;
   
   printf("[%d;%dH%s\n", line, x, text);
}

int match(char *m,char *y){
   char *x;
   char *wildx,*wildy;
   char quote,wildcard;
   if(!*m)
      if(*y)
         return 0;
   wildcard = 0;
   x = m;
   wildx = x;
   wildy = y;
   for(;;){
      if(*x){
         if(*x == '*'){
            for(x++;*x == '*';x++);
            wildx = x;
            wildy = y;
            wildcard++;
         }
         if(*x)
            if(!*y)
               return 0;
      } else {
         if(!*y)
            return 1;
         for(x--;((x > m) && (*x == '?'));x--);
         if((*x == '*') && (x > m))
            if(x[-1] != '\\')
               return 1;
         if(!wildcard)
            return 0;
         x = wildx;
         y = ++wildy;
      }
      if(*x == '\\'){
         x++;
         quote = 1;
      } else
         quote = 0;
      if((tolower(*x) == tolower(*y)) || (*x == '?') || (quote)){
         if(*x)
            x++;
         if(*y)
            y++;
      } else {
         if(!wildcard)
            return 0;
         x = wildx;
         y = ++wildy;
      }
   }
}

void strip_newline(char *string) {
   char *ptr;
   if(ptr = strchr(string, '\n')) *ptr = '\0';
   if(ptr = strchr(string, '\r')) *ptr = '\0';
}
