#include "common.h"

void printPacket(unsigned char *mybuf, int len) { 
  int i;

      for (i=0;i<((len) > 48 ? 48 : len) ;i++) { 
	printf(" %x (%c) ", mybuf[i], isalnum(mybuf[i]) ? mybuf[i] : '?');
      }
      if (len<=48) { printf("E"); } else printf("....");
      printf("\n");
}

int sendHello(int fd, char *msg, unsigned long host, int port) {
  int ret;
  struct sockaddr_in to;

  to.sin_family = AF_INET; 
  to.sin_port = FLIP_PORT(port); 
  to.sin_addr.s_addr = host;
  
  ret = sendto(fd, msg, strlen(msg), 0 ,(struct sockaddr *)&to, sizeof(to));
  if (ret < 0) {
    fprintf(stderr, "Attempting to send %s to %x (port %d)\n", msg, host, port);
    perror("Can't send hello");
  }
  return ret;
}

int sendPacket(int fd, unsigned char *msg, int len, unsigned long host, int port) {
  int ret;
  struct sockaddr_in to;

  to.sin_family = AF_INET;
  to.sin_port = FLIP_PORT(port);
  to.sin_addr.s_addr = host;

  ret = sendto(fd, msg, len, 0 ,(struct sockaddr *)&to, sizeof(to));
  if (ret < 0) {
    fprintf(stderr, "Attempting to send %s to %x (port %d)\n", msg, host, port);
    perror("Can't send hello");
  }
  return ret;
}

void *rcvPacket(int fd, int *len, unsigned long *from, int *port, unsigned char **buf) {
  int ret,l;
  struct sockaddr_in s;
  char *b;

  s.sin_family = AF_INET;
  s.sin_addr.s_addr = 0;
  s.sin_port = 0;

  if ((*buf)==NULL) { 
    (*buf) = malloc(MAX_PACKET_SZ+256);
    printf("malloc %x\n", (*buf));
    if (!(*buf)) { 
      fprintf(stderr, "Can't allocate packet buffer of %d\n", MAX_PACKET_SZ);
      exit(2);
    }
    b = (*buf);
     (*buf)=&b[256];
  }
  
  l = sizeof(struct sockaddr_in);
  ret = recvfrom(fd, (*buf), MAX_PACKET_SZ,  0, (struct sockaddr *)&s, &l);
  if (ret < 0 && !(errno==EINTR) && !(errno==EAGAIN)) {
    (*len) = 0;
    return NULL;
  }
  
  if (ret < 0) { 
    (*len) = 0;
    return NULL;
  }

  /* printf("Flibble %x (%d)\n", (s.sin_addr.s_addr), (s.sin_port)); */

  (*len) = ret;
  (*from) = s.sin_addr.s_addr;
  (*port) = FLIP_PORT(s.sin_port);
  return (*buf);
}
  
  

int getQuakeSocket(int port) {
  int fd;
  int ret;
  struct sockaddr_in addr;

  fd = socket(AF_INET, SOCK_DGRAM, 0);
  if (fd < 0) {
    perror("Can't get datagram socket");
  }
  
  fcntl(fd, F_SETFL, O_NONBLOCK); 

  addr.sin_family = AF_INET;
  addr.sin_port = FLIP_PORT(port);
  addr.sin_addr.s_addr = 0;

  ret = bind(fd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in));
  if (ret < 0) {
    perror("Can't bind() datagram socket");
    exit(1);
  }

  return fd;
}

unsigned long primaryIP(unsigned char *nam) {
  struct hostent *h;

  h = gethostbyname(nam);
  if (h->h_name && h->h_addrtype == AF_INET) {
    /* Addresses are always 4 bytes, so.. */
    unsigned long addrh = *((unsigned long *)(h->h_addr));
    return addrh;
  } else {
    fprintf(stderr, "Help ! Invalid address for %s\n", nam);
    exit(1);
  }

}

/* End */
