/* Quake II proxy */
/* This is the server side. It opens a server socket, and accepts connections from the
   list of machines in its connection list.

   When it gets a packet, it maps the incoming address to its outgoing address, and sends
the packet on its way.
*/

#include "common.h"

int fd, ret, fd2, r2, udpinfd;
unsigned long bin = 0;

void intrhandler(int x) {
  printf("Your game cost %d bytes (%d K, %d Mbyte), or %f p at 2p/Mbyte\n",
	 bin, (bin>>10), (bin>>20), ((float)bin/(1024.0*512.0)));
  close(fd); close(fd2); close(udpinfd);
  exit(0);
}

int main(int argn, char *args[]) {
  int pfrom, pto;
  unsigned long hfrom, hto;
  unsigned char *mybuf = NULL;
  struct timeval t1, t2, torig, tnew;

  if (argn != 5) {
    printf("Syntax: %s [listen port] [fwd port] [source ip] [target ip]\n", args[0]);
    exit(1);
  }
  
 
signal(SIGINT, intrhandler);
 /* Right. Open and accept() .. */
  {
    unsigned long bout = 0;
    unsigned long cur_delay = DELAY;
    unsigned long total, busy, waitrd = 0, waitwr = 0;
    int ret, r2;
    unsigned long bfwp;
    struct sockaddr_in addr;
    struct sockaddr_in them;
    int tl;
    int udpfd;
    unsigned char buf[1024];
    unsigned char pckt[4*MAX_PACKET_SZ + 256];
    unsigned int pptr = 0;
    int i;
    unsigned int state = 0;
    fd_set rfds, wfds;
    int maxfd;

    pfrom = atoi(args[1]);
    pto = atoi(args[2]);
    
    hfrom = primaryIP(args[3]);
    hto = primaryIP(args[4]);

    fd = socket(AF_INET, SOCK_STREAM, 0);
    if (fd < 0) {
      perror("Can't create TCP socket");
    }

    printf("Binding port %d (accepting from %x (%s))...\n", pfrom, hfrom, args[3]);

    addr.sin_family = AF_INET;
    addr.sin_port = htons(pfrom);
    addr.sin_addr.s_addr = 0;

    ret = bind(fd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in));
    if (ret < 0) {
      perror("Can't bind() TCP");
      exit(1);
    }

    ret = listen(fd, 1);
    
    printf("Listening for connections...\n");
    
    fd2 = accept(fd, (struct sockaddr *)&them, &tl);

    
    printf("Got connection from %x (port %d). Forwarding UDP...\n", ntohl(them.sin_addr.s_addr), 
	   them.sin_port);

    
    ret = read(fd2, &buf, 4);
    printf("ret = %d\n", ret);
    bfwp = htonl((*((unsigned long *)buf)));
    
    fcntl(fd2, F_SETFL, O_NONBLOCK);
    
    printf("Opening back-connection on UDP %d ..\n", bfwp+TGT_OFFSET);
    udpfd = getQuakeSocket(bfwp+TGT_OFFSET);

    total = 0; busy = 0; bout = 0; bin = 0;
    gettimeofday(&torig, NULL);
    maxfd = ((fd2 > udpfd) ? fd2 : udpfd)+1;

    while (1) {
      unsigned char *b2;
      int l, done;
      unsigned long q;
      unsigned int w;
      float ratio;

#ifdef OLD_THROTTLE
      ratio = ((float)busy)/((float)total);
      if (total > 65535) { total -=65535; busy -= (int)(65535.0*ratio); }
      if (ratio < 0.1) { cur_delay = cur_delay * 2; }
      if (ratio > 0.3) { cur_delay = cur_delay/2; }
      if (cur_delay < 100) { cur_delay = 100; }
      if (cur_delay > DELAY) { cur_delay = DELAY; }
#endif

      if (bout > 16384) {
	float ks;

	gettimeofday(&tnew, NULL);
	
	ks = (float)bout/(1024.0*(((float)tnew.tv_sec-(float)torig.tv_sec)+
				  ((float)tnew.tv_usec-(float)torig.tv_usec)/1000000.0));
	printf("%f k/s (%d bytes, %d k total)\n", ks,bin, bin>>10);
	bout =0;
	torig = tnew;
      }

#ifdef OLD_THROTTLE
#ifdef STATS
      if ((total%256)==0) {
	printf("%d/%d -> %d\n", busy, total, cur_delay);
      } 
#endif
#endif
      /* usleep(50);   */
      FD_ZERO(&rfds);
      FD_ZERO(&wfds);
      FD_SET(fd2, &rfds); FD_SET(fd2, &wfds);
      FD_SET(udpfd, &rfds); FD_SET(udpfd, &wfds);
      ret = select(maxfd, &rfds, NULL, NULL, NULL);
      if (ret < 0) {
	perror("Exception in select()");
	intrhandler(0);
      }

      total+=2;

#ifdef TIMING
      gettimeofday(&t2, NULL);
      printf("Diff0 = %d\n", (t2.tv_sec-t1.tv_sec)*1000000 + (t2.tv_usec-t1.tv_usec));
#endif     

#ifdef TIMING
      gettimeofday(&t2, NULL);
      printf("Diff2 = %d\n", (t2.tv_sec-t1.tv_sec)*1000000 + (t2.tv_usec-t1.tv_usec));
#endif
      if (FD_ISSET(fd2, &rfds)) { 
	ret = read(fd2, &pckt[pptr], MAX_PACKET_SZ*4-pptr);
#ifdef TIMING 
	gettimeofday(&t1, NULL);
#endif      

#ifdef DEBUG
	printf("Read %d bytes from TCP\n", ret);
#endif
	if (ret == 0) {
	  printf("Other side closed TCP connection. Bye.\n");
	  close(fd2); close(fd); close(udpfd);
	  exit(0);
	}
	if (ret < 0 && (errno != EAGAIN) && (errno != EINTR)) {
	  perror("Can't read() from TCP socket");
	  close(fd2); close(fd); close(udpfd);
	  exit(1);
	}
	if (ret > 0) {
	  pptr += ret;
	  
	  
	  if (pptr > 4*MAX_PACKET_SZ) { 
	    fprintf(stderr, "Help ! Packet overflow - %d\n", pptr);
	    exit(2);
	  }
	}
	
	if (pptr > 4) {  busy++; }
	
	while (pptr > 4 && 1) { 
	  unsigned int sz = ntohl(*((unsigned long *)&pckt[0]));
	  int tt = 0;
	  
	  
#ifdef DEBUG
	  printf("ret = %d\n", ret);
#endif
	  if (pptr > 4 && (pptr-4) >= sz) {
	    // We've got a full packet. output it.
	    if (tt < 3) { 
	      r2 = sendPacket(udpfd, &pckt[4], sz, hto, pto);
	      if (r2 < 0) {
		perror("Can't forward packet to UDP");
	      }
	      bout += sz; bin+=sz;
#ifdef DEBUG
	      printPacket(pckt+4, sz);
	      printf("Forwarded packet from TCP stream (%d %d)...\n",pptr, sz);
#endif
	    } 
	    tt++;
	    if (pptr > (4+sz)) {  
	      memmove(&pckt[0], &pckt[4+sz], pptr-(sz));
	    }
	    pptr-=(4+sz);
	  }
	}
      }
#ifdef TIMING
      gettimeofday(&t2, NULL);
      printf("Diff3 = %d\n", (t2.tv_sec-t1.tv_sec)*1000000 + (t2.tv_usec-t1.tv_usec));
#endif


      if (FD_ISSET(udpfd, &rfds)) { 
	b2 = rcvPacket(udpfd, &tl, &q, &w, &mybuf);
	if (b2 && !waitwr) { 
	  if (q==hto && w==pto) {
	    /* Fine. Forward it */
	    busy++;
	    b2 -= 4;
	    (*(unsigned long *)(b2)) = htonl(tl);
	    done = 0;
	    if (1) { 
	      while (done < (tl+4)) {
		ret = write(fd2, &b2[done], tl+4-done);
#ifdef TIMING
		gettimeofday(&t2, NULL);
		printf("Diff1 = %d\n", (t2.tv_sec-t1.tv_sec)*1000000 + (t2.tv_usec-t1.tv_usec));
#endif
		if (ret < 0) {
		  if (!(errno==EAGAIN || errno==EINTR)) {
		    perror("Can't write packet to TCP");
		    exit(2);
		  }
		} else { done+= ret; }
	      }
	      waitwr = 1;
	    }

#ifdef DEBUG
	    printPacket(buf, tl+4);
	    printf("Forwarded packet to TCP stream (%d)...\n", tl);
#endif
	  } else {
	  printf("Won't forward packet from %x (port %d)\n", q, w);
	  }
	}
      }
      waitwr = 0;
      
    }
  }
  return 0; 
}
