#ifndef __UTILS_H
#define __UTILS_H

#include "header.h"

ipv4_addr_t host_to_ipaddr(char *nam);
int port_from_text(char *txt);
int number_from_text(char *txt, int lvl);

#define matchACL(e, addr, port) (((e.allowed&e.mask)==(e.mask&addr) && (port>=e.pstart && port<=e.pend)) ? !e.deny : e.deny)
#define timeval_before(a,b) (a.tv_sec < b.tv_sec || (a.tv_sec==b.tv_sec && a.tv_usec <= b.tv_usec))
#define timeval_after(a,b) (a.tv_sec > b.tv_sec || (a.tv_sec == b.tv_sec && a.tv_usec >= b.tv_usec))
#define timeval_add(a,b,c) a.tv_usec = b.tv_usec+c.tv_usec; \
 a.tv_sec = b.tv_sec + c.tv_sec + (a.tv_usec/1000000); \
 a.tv_usec %= 1000000;
#define timeval_addus(a,c) a.tv_usec += c; a.tv_sec += a.tv_usec/1000000; a.tv_usec %= 1000000;
#define timeval_adds(a,c) a.tv_sec += c;
#define timeval_sub(a,b) a.tv_sec -= b.tv_sec; a.tv_usec -= b.tv_usec; \
 if (a.tv_usec < 0) { a.tv_sec--; a.tv_usec += 1000000; }
#define timeval_halve(a) a.tv_sec = a.tv_sec>>1; a.tv_usec = a.tv_usec>>1;

#define SEND_TOP_PCKT \
if (IQ.occ >0 && timeval_after(tout, IQ.entries[0]->due_in)) {\
 server_route_t *rt = IQ.entries[0];\
 sendto(rt->fd_destination, rt->pckt_in, rt->pckt_in_len, 0,\
   (struct sockaddr *)&rt->destination, sizeof(struct sockaddr_in));\
 rt->pckt_in_len=0;i++;\
 { int k;\
 for (k=0;k<IQ.occ-1;k++) { IQ.entries[k] = IQ.entries[k+1]; } IQ.occ--;\
 }\
}

#endif
