#include "header.h"

/* Flibble. If lvl = 0 ,warn(), if lvl = 1 fatal() */
int number_from_text(char *txt, int lvl) { 
  int ret;
  char *endptr;
  
  if (txt == NULL) {
    if (lvl) {
      fatal(0, "No text whilst reading number");
    } else {
      warn(0, "No text whilst reading number");
      return 0;
    }
  }
  
  ret = strtol(txt, &endptr, 0);
  if (endptr == NULL) {
    if (lvl) {
      fatal(0, "Invalid number %s", txt);
      return 0;
    } else {
      warn(0, "Invalid number %s", txt);
      return 0;
    }
  } else {
    return ret;
  }
}

/* Return -1 on error. */
int port_from_text(char *txt) {
  char *endptr;
  int ret;

  if (txt==NULL) { return -1; }
  
  ret = strtol(txt, &endptr, 0);
  if (endptr == NULL) {
    return -1;
  } else {
    return ret;
  }
}

/* Returns 0 if no name for host, 1 if security problem. */
ipv4_addr_t host_to_ipaddr(char *nam) {
  /* Look up one way ... */
  struct hostent *h1;
  struct hostent *h2;
  ipv4_addr_t addr;
#if DO_REVERSE_LOOKUP
  ipv4_addr_t had;
  char **p;
  char knam[256];
 char **abuffers, **aptr;
  int n_abuffers, cnt, i;
#endif
 int ret;
  struct in_addr inp;

  /* Is this a dotted quad ? */
#ifdef HAVE_INET_ATON
  ret = inet_aton(nam, &inp);
  if (ret) { 
    return inp.s_addr;
  }
#else
  ret = inet_addr(nam);
  if (ret != -1) {
    inp.s_addr = ret;
    return inp.s_addr;
  }
#endif

  h1 = gethostbyname(nam);
  
  if (h1==NULL) {
    return 0;
  }
 
  if (!h1 || !h1->h_name || h1->h_addrtype != AF_INET || !h1->h_addr) {
    return 0;
  }

  addr = *((unsigned long *)(h1->h_addr));
  inp.s_addr = addr;

#if DO_REVERSE_LOOKUP
  snprintf(knam, 255, "%s", h1->h_name); 
  /*printf("knam is %s\n", knam);*/

  {
    aptr = h1->h_aliases;

    n_abuffers=0;cnt = 0;

    while (*aptr) { aptr++; n_abuffers++; }
    
    abuffers = malloc(sizeof(char *)*n_abuffers);
    if (!abuffers) {
      fatal(0, "Can't allocate %d bytes for name resolution buffers", 
	    sizeof(char *)*n_abuffers);
    }
    aptr = h1->h_aliases;
    while (*aptr) {
      //printf("Abuffer %s\n", *aptr);
      abuffers[cnt++] = strdup(*aptr);
      aptr++;
    }
  }
 
  had = ntohl(addr);
  cnt = 0;


  /*
snprintf(buf, 128, "%d.%d.%d.%d",had&0xff, (had>>8)&0xff, (had>>16)&0xff, (had>>24)&0xff);
  */
  /* Now look up the other .. */
  h2 = gethostbyaddr((char *)&inp,  sizeof(struct in_addr), AF_INET);
  /* Check the list of names .. */
  if (!h2 || !h2->h_name) { return 1; }
  if (!strcmp(h2->h_name, knam)) { 
    cnt =1;
  }
  //  printf("Name %s\n", h2->h_name);
  if (!cnt) { 
    for (i =0;i<n_abuffers;i++) {
      if (!strcmp(h2->h_name, abuffers[i])) {
	cnt =1; break;
      }
    }
  }
  p = h2->h_aliases;
  while (*p) {
    // printf("Alias %s\n", *p);
    if (!strcmp(knam, *p)) {
      cnt = 1; break;
    }
    for (i=0;i<n_abuffers;i++) {
      if (!strcmp(*p, abuffers[i])) { 
	cnt = 1; break;
      }
    }
    p++;
  }
  for (i=0;i<n_abuffers;i++) { if (abuffers[i] != NULL) { free(abuffers[i]); } }
  free(abuffers);
  
  if (cnt) { 
    return addr;
  } else {
    return 1;
  }
#else
  /* Just check there is a reverse DNS record .. */
  h2 = gethostbyaddr((char *)&inp,  sizeof(struct in_addr), AF_INET);
  if (!h2 || !h2->h_name) { return 1; } 
  return addr;
#endif
}


/* The end */
