/* tcp.h */

#ifndef __TCP_H
#define __TCP_H

typedef struct tcp_conn_struct {
  char wbuffer[TCP_PACKET_BUF_SIZ];
  int top; /* The top of the buffer */
  int firstFree; /* The first free element */
  int nextToWrite; /* The next element to write */
  char rbuffer[TCP_PACKET_BUF_SIZ];
  int rptr;
  
  struct sockaddr_in  local;
  struct sockaddr_in  remote;
  int fd;
} tcp_conn_t;

tcp_conn_t *build_conn_from_fd(int fd);
tcp_conn_t *accept_on(tcp_conn_t *svr);
void tcp_write_buffer(tcp_conn_t *conn);
void tcp_read_buffer(tcp_conn_t *conn);
tcp_conn_t *connect_to_svr_socket(ipv4_addr_t server, ipv4_port_t svrport);
tcp_conn_t *create_svr_socket(ipv4_port_t port);

int tcp_blocking_read(int fd, char *buf, int len);
int tcp_blocking_write(int fd, char *buf, int len);


#endif
