.\" (c) Richard Watts 1998 <Richard.Watts@cl.cam.ac.uk>
.TH RQ2PS 8 LOCAL
.UC 6
.SH NAME
rq2ps \- Quake II proxy server
.SH SYNOPSIS
.hy 0
.na
.BR rq2ps " [\|" \c
--no-mlock\c
\&\|] [\|\c
--no-rt\c
\&\|] [\|\c
--use-mlock\c
\&\|] [\|\c
--use-rt\c
\&\|] [\|\c
--log-all-packets\c
\&\|] [\|\c
--test-only \c
\&\|] [\|\c
--do-fork
\&\|] [\|\c
--no-fork
\&\|] [\|\c
--from-inetd
\&\|] [\|\c
-f \c
.I config_file
\&\|] [\|\c
-p \c
.I portno
\&\|] [\|\c
-v
\&\|] [\|\c
--help\c
\&\|] [\|\c
--version
\&\|]
.ad b
.hy 1
.SH DESCRIPTION
.I rq2ps
is a program which sits on a machine outside your firewall. When started,
it reads its configuration file and opens a TCP server port. It waits for
a copy of \c
.I rq2pc \c
to connect to this port. \c
.I rq2ps \c
then sends its configuration to \c
.I rq2pc \c
which begins proxying UDP packets from Quake II clients to the TCP 
connection.\c
.I rq2ps \c
does the same, proxying the packets from the TCP connection to Quake II
servers.
.PP
You can use these programs to proxy Quake II servers across UDP-blocking
firewalls, optionally implementing access controls (JANET sites may want
to restrict access to UK Quake servers, for example). You can also perform
origin-level redirects, so clients on different machines get redirected
to different servers, and delayed redirects: packets are delayed for a
certain period at \c
.I rq2ps \c
, so players playing via a fast connection can play with the same ping as
LAN players.
.PP
If running as root, and if your system supports it,
.I rq2ps \c
and \c
.I rq2pc \c
can lock their pages into memory and put themselves into the real-time
scheduling class. This gives increased performance, but ties up some real,
physical memory (c. 1Mbyte for each) and allows bugs in the programs to
kill your machine (though measures have been taken to ensure that they 
don't).
.PP
.I rq2ps \c
can be run in three modes: as a non-forking server which accepts a single
client connection, and dies when it is broken, as a forking server, which
forks whenever a client connection is recieved, can cope with multiple 
clients and with clients dying, and from inetd (though this is untested).
.PP
Neither \c
.I rq2ps \c
nor
.I rq2pc \c
have been designed to run setuid root, and neither should be run in this
fashion.
.PP
See the \c
.I rq2proxy user guide \c
which came with your copy of rq2proxy for details on how to configure and
use these programs.
.SH OPTIONS
Options given on the command line override any that are given in the
configuration file.
.PP
.TP
.B --do-fork
fork every time a client connects. This allows the handling of multiple
clients, and allows clients to be restarted when they die, but makes
debugging difficult.
.TP
.B -f config_file \c
Use this configuration file.
.TP
.B --from-inetd \c
Run from inetd: treat standard input as a connection to a client.
.B --help \c
Display help information.
.TP
.B --log-all-packets \c
Log the passage of all packets to stdout.
.TP
.B --no-fork
don't fork when a client connects: the server must be restarted manually
whenever a client dies, and will only handle one client, but debugging
is easier.
.TP
.B --no-mlock \c
Don't try to lock all pages in memory on startup.
.TP
.B --no-rt \c
Don't try to put yourself into the real-time scheduling class on startup.
.TP
.B -p port \c
Listen on this port.
.TP
.B --test-only \c
Just print out the configuration: don't actually start the server. Usually
used to test configurations prior to putting them into service.
.TP
.B --use-mlock \c
Try to lock all pages in memory on startup.
.TP
.B --use-rt \c
Try to put yourself in the real-time scheduling class on startup.
.TP
.B --version \c
Display version information.
.SH "KNOWN BUGS"
None yet.
.SH "SEE ALSO"
rq2pc(8), 'The rq2proxy user guide'
.SH COPYING
Copyright (c) Richard Watts <Richard.Watts@cl.cam.ac.uk> 1998
.PP
You can copy this manual page under the terms of the LGPL or the
Artistic Licence, at your option.
