/* rt_default.c */

#include "header.h"
#ifdef _POSIX_MEMLOCK
#include <sys/mman.h>
#endif
#ifdef _POSIX_PRIORITY_SCHEDULING
#include <sched.h>
#endif

extern int verbose, use_rt;

void unlock_and_unset_scheduler(int mlock, int rt) {
#ifdef _POSIX_MEMLOCK
#ifdef HAVE_MLOCKALL
  munlockall();
#endif
#endif
}


void lock_and_set_scheduler(int ml, int rt, int is_server) {
  int ret;

  if (ml) {
#ifdef _POSIX_MEMLOCK
#ifdef HAVE_MLOCKALL
    ret = mlockall(MCL_FUTURE);
    if (ret) {
      warn(1, "Can't mlockall()");
    } else {
      if (verbose) {
	info(0, "Locked pages into memory");
      }
    }
#else
    warn(0, "Can't mlockall() on platform " TARGET ".\n");
#endif
#else
    warn(0, "Can't mlockall() on platform " TARGET ".\n");
#endif
  }
  if (rt) {
#ifdef _POSIX_PRIORITY_SCHEDULING
#ifdef HAVE_RTSCHED 
   {
      pid_t me;
      struct sched_param p;
      
      me = getpid();
      
      p.sched_priority = (is_server ? RT_PRIORITY_SERVER : RT_PRIORITY_CLIENT);
      ret = sched_setscheduler(me, SCHED_FIFO, &p);
      if (ret) {
	use_rt = 0;
	warn(1, "Couldn't set FIFO scheduler");
      } else {
	if (verbose) {
	  info(0, "Set scheduling class to SCHED_FIFO");
	}
      }
    }
#else
    warn(0, "Can't set real-time scheduling on platform " TARGET ".\n");
#endif
#else
    warn(0, "Can't set real-time scheduling on platform " TARGET ".\n");
#endif 
  }
}

/* s'all */

