/* reap.c */

#include "header.h"


static RETSIGTYPE sigchld_handler(int c);

static RETSIGTYPE sigchld_handler(int c) {
  reap_dead_children();
}

/* This code should be signal-handler-safe. */
void reap_dead_children(void) {
  int st, ret;

  do {
    ret = waitpid(-1, &st, WNOHANG);
    if (ret <= 0) break;
  } while (WIFEXITED(st));

}

/* This code has the nasty job of trying to persuade the system to send SIGCHLD rather
   than simply leaving zombies lying around. We can then handle the SIGCHLD with a waitpid().
*/

void reap_children_as_they_die(void) {
  struct sigaction act, pact;
  int ret;

  act.sa_handler = sigchld_handler;
  sigemptyset(&act.sa_mask);
  act.sa_flags = SA_NOCLDSTOP;
  /*  act.sa_restorer = NULL; */

  ret = sigaction(SIGCHLD, &act, &pact);
  if (ret) {
    fatal(1, "Can't register reaping signal handler");
  }

}

/* The end */
