/* Parser for rqproxy2's configuration file */

%{
#include "header.h"

void yyerror(char *s);
int yylex(void);

char *svr_static_cookie;
ipv4_port_t svr_static_client_port;
int svr_static_flags;
int test_only = 0, log_all_packets = 0, do_fork = DEFAULT_DO_FORK, verbose = 0;
int from_inetd = 0, use_mlock = 0, use_rt = 0;

extern int yyl_line_no;
 
/*
#define YYDEBUG 1
yydebug = 1;
*/
  %}

%union {
  acl_ht_entry_t acl;
  server_conf_elem_t svconf;
  ipv4_addr_t ipaddr;
  ipv4_port_t ipport;
  int num;
  int ald; /* 0 - allow, 1 - deny. */
  char *txt;
  struct timeval tv;
  struct {
    struct timeval delay_in;
    struct timeval delay_out;
  } d;
 }

%token <txt> NAME
%token ALLOW
%token DENY
%token NETMASK
%token REDIRECT
%token PORT
%token FROM
%token TO
%token PROXY
%token ON
%token FOR
%token CLIENT
%token COOKIE
%token ACL
%token DELAY
%token LISTEN
%token OPTION
%token <txt> NUMBER
%token <txt> TEXT
%type <tv> delayn
%type <num> intno onoff
%type <acl> acl aclentry
%type <svconf> redirect redirectx redirecty
%type <ipaddr> address maskexpr
%type <num> portport portfrom portto portno
%type <ald> direction
%type <d> delay


%%
file: /* Empty */
 | file directive
;

directive: option { /* Nothing */ }
| ACL acl { route_acl_table.entries[route_acl_table.occ++] = $2; } 
 | redirect      { route_config_table.entries[route_config_table.occ++] = $1; }
| ON address redirect { $3.client_is = $2; 
   route_config_table.entries[route_config_table.occ++] = $3;
}
| CLIENT acl { client_acl_table.entries[client_acl_table.occ++] = $2; 
                        svr_static_flags |= SVR_FLAGS_GOT_CLIENT; }
| LISTEN portno { svr_static_client_port = $2; svr_static_flags |= SVR_FLAGS_GOT_PORT; }
| COOKIE TEXT { svr_static_cookie = strdup($2); svr_static_flags |= SVR_FLAGS_GOT_COOKIE; }
;

option: OPTION TEXT onoff {  
  if (!strcmp($2, "log_all_packets")) {
    if (!(svr_static_flags&SVR_FLAGS_OPTIONS_LOG)) {
    log_all_packets = $3;
    }
    goto end_option;
  }
  if (!strcmp($2, "use_mlock")) {
    if (!(svr_static_flags&SVR_FLAGS_OPTIONS_MLOCK)) {
      use_mlock = $3;
    }
    goto end_option;
  }
  if (!strcmp($2, "use_rt")) {
    if (!(svr_static_flags&SVR_FLAGS_OPTIONS_RT)) {
      use_rt = $3;
    }
    goto end_option;
  }		
  if (!strcmp($2, "do_fork")) {
    if (!(svr_static_flags&SVR_FLAGS_OPTIONS_NOFORK)) {
      do_fork = $3; if ($3) { from_inetd = 0; }
    }
    goto end_option;
  }
  if (!strcmp($2, "from_inetd")) {
    if (!(svr_static_flags&SVR_FLAGS_OPTIONS_INETD)) {
      from_inetd = $3; if ($3) { do_fork = 0; }
    }
    goto end_option;
  }
  if (!strcmp($2, "test")) {
    if (!(svr_static_flags&SVR_FLAGS_OPTIONS_TEST)) { 
      test_only = $3;
    }
    goto end_option;
  }
  if (!strcmp($2, "verbose")) {
    if (!(svr_static_flags&SVR_FLAGS_OPTIONS_VERBOSE)) {
      verbose = $3;
    }
  goto end_option;
  }
  YYERROR;
 end_option:
}
;

redirect: redirecty { $$ = $1; $$.delay_in.tv_sec = 0; $$.delay_in.tv_usec = 0; 
 $$.delay_out.tv_sec = 0; $$.delay_out.tv_usec = 0; 
}
| redirecty DELAY delay { $$ = $1; $$.delay_in = $3.delay_in; $$.delay_out = $3.delay_out }
;

redirecty: redirectx { $$ = $1; $$.u.assocacl = NULL; }
|  redirectx acl { $$ = $1; $$.u.assocacl = malloc(sizeof(acl_ht_entry_t));
 if ($$.u.assocacl == NULL) { fatal(0, "Can't allocate space for server ACL entry"); }
 *($$.u.assocacl) = $2;
}
|  redirectx FOR aclentry { $$ = $1; $$.u.assocacl = malloc(sizeof(acl_ht_entry_t));
 if ($$.u.assocacl == NULL) { fatal(0, "Can't allocate space for server ACL entry"); }
 *($$.u.assocacl) = $3;
}
;

redirectx: REDIRECT address portport TO address portport { 
                        $$.client_is = $2;
			$$.client_name = $2;
                        $$.client_port = $3;
                        $$.svr_ip = $5;
                        $$.svr_port = $6;
}
;

delay: delayn {  timeval_halve($1); 
                            $$.delay_in = $1; $$.delay_out = $1; }
| delayn '+' delayn { $$.delay_in = $1; $$.delay_out = $3; }
; 

delayn: intno { $$.tv_sec = $1/1000; $$.tv_usec = ($1*1000)%1000000; }
| intno TEXT { 
  if (!strcmp($2, "s")) { 
    $$.tv_usec = 0; $$.tv_sec = $1; 
  } else {
    if (!strcmp($2, "us")) {
      $$.tv_usec = $1%1000000; $$.tv_sec = $1/1000000;
    } else {
      if (!strcmp($2, "ms")) { 
	$$.tv_sec = $1/1000; $$.tv_usec = ($1*1000)%1000000;
      } else {
	YYERROR;
      }
    }
  }
}
;

portport: PORT portno { $$ = $2; }
| ':' portno { $$ = $2; }
| portno { $$ = $1; }
;

acl: direction aclentry { $$ = $2; $$.deny = $1; }
;

aclentry: address maskexpr portfrom portto { 
                                            $$.deny = 0; 
                                             $$.allowed = $1;
                                             $$.mask = $2;
                                             $$.pstart = $3; $$.pend = $4; }
| address maskexpr PORT portno {
  $$.deny = 0; 
  $$.allowed = $1;
  $$.mask = $2;
  $$.pstart = $4;  $$.pend = $4; 
}
| address maskexpr {
  $$.deny = 0; 
  $$.allowed = $1;
  $$.mask = $2;
  $$.pstart = 0;  $$.pend = 65535;
  }
;

maskexpr:  /* Nothing */ { $$ = 0xffffffff; }
| NETMASK address { $$ = $2; }
| '/' address { $$ = $2; }
;

intno: NUMBER { $$ = number_from_text($1, 1); }
;

portno: NUMBER {  $$ = port_from_text($1); 
 if ($$ == -1) {
   fatal(0, "Invalid port number %s\n", $1);
 } else {
   $$ = htons($$);
 }
}
;

portfrom:  FROM portno { $$ = $2; }
 | ':' portno { $$ = $2; }
| portno { $$ = $1; }
;

portto:  TO portno { $$ =$2; }
 | '-' portno { $$ = $2; }
;

onoff: TEXT { 
    if (!strcasecmp($1, "on") || !strcasecmp($1, "true") || !strcasecmp($1, "yes")) {
     $$ = 1; 
    } else {
      if (!strcasecmp($1, "off") || !strcasecmp($1, "false") || !strcasecmp($1, "no")) {
	$$=0;
      } else {
	YYERROR;
      }
    }
  }
| ON { $$ = 1; }
;

direction: ALLOW { $$ = 0; } 
| DENY { $$ = 1; }
;
address: NAME { $$ = host_to_ipaddr($1);
switch ($$) { 
case 0: fatal(0, "Can't find IP address for host %s at line %d\n", $1, yyl_line_no); break;
 case 1: fatal(0, "Can't do reverse lookup match for %s at line %d- DNS spoofing ?\n", $1,
	       yyl_line_no); break; 
 default: /* Nothing */ 
}
} 
| NUMBER { $$ = host_to_ipaddr($1); switch ($$) { 
case 0: fatal(0, "Can't find IP address for host %s at line %d \n", $1, yyl_line_no); break;
 case 1: fatal(0, "Can't do reverse lookup match for %s at line %d - DNS spoofing ?\n", $1,
	       yyl_line_no); break; 
 default: /* Nothing */ 
}}
;


%%



void yyerror(char *s) {
  warn(0, "Problem with cfg parse: %s at line %d", s, yyl_line_no);
}
