/* my_funcs.c */

#include "header.h"

#ifndef HAVE_STRDUP
char *strdup(const char *in) {
  int k = strlen(in);
  char *out = malloc((k+4)*sizeof(char));
  if (!out) {
    fatal(0, "Can't allocate %d + 4 bytes for new string",
	  k);
  }
  
  memcpy(out, in, k+1);
  return out;
}
#endif

#if 0
#if ((SIZEOF_UNSIGNED_LONG != 4) || 
     (SIZEOF_LONG != 4) ||
     (SIZEOF_INT != 4)) 
#error "sizeof(ulong) == sizeof(long) == sizeof(int) does not hold: remove this error directive if you really want to continue."
#endif
#endif

#ifndef HAVE_USLEEP
#ifdef HAVE_NANOSLEEP
     int usleep(int us) {
       int ret;
       struct timespec ts, tq;

       ts.tv_sec = (us/1000000);
       ts.tv_nsec = ((long)us*1000)%1000000000;
       ret = nanosleep(&ts, &tq);
       return ret;       
     }
#else
#error "Need either nanosleep() or usleep()"
#endif
#endif

#ifndef USE_VSPRINTF
#ifndef HAVE_VSNPRINTF
#error "You don't have vsnprintf(): if you're desperate (and mad) pass --enable-vsprintf to configure"
#endif
#endif

#ifdef USE_VSPRINTF
#ifdef HAVE_VSPRINTF
int vsnprintf(char *sbuf, size_t len, const char *fmt, va_list args) {
  int r;

  r = vsprintf(sbuf, fmt, args);
   return r;
}
#else
#error "I need to have vsprintf() to use vsprintf()"
#endif
#endif

#ifndef HAVE_STRTOL
#ifndef HAVE_ATOI
#error "Need either strtol() or atoi()."
#else
long strtol(const char *nptr, char **endptr, int base) {
  int i;

  i = atoi(nptr);
  if (i==-1) {
    *endptr = NULL; 
  } else {
    *endptr = nptr;
  }
  return i;
}
#endif
#endif
