/* scanner for the q2proxy configuration file */

%{
#include "header.h"
#include "y.tab.h" 

int yyl_line_no = 1;
%}

%option noyywrap

DNSC [a-zA-Z0-9|\-:']
DIGIT [0-9]


%%

^\#(.*) { /* comment */ }

(\ \-\ ) { return '-'; }

\"{DIGIT}+\" { yylval.txt = yytext; yylval.txt = strdup(yytext); 
	yylval.txt[strlen(yylval.txt)-1] = 0; yylval.txt++; 
	return NUMBER; }
\"{DNSC}+(\.{DNSC}+)*\" {  yylval.txt = strdup(yytext); /* MEMORY LEAK */
	 yylval.txt[strlen(yylval.txt)-1] = 0; yylval.txt++;  return NAME; }

global { return ACL; }
deny { return DENY; }
allow { return ALLOW; }

netmask { return NETMASK; }

redirect { return REDIRECT; }
port { return PORT; }
from { return FROM; }
to { return TO; }
proxy { return PROXY; }
for { return FOR; }
client { return CLIENT; }
cookie { return COOKIE; }
delay {return DELAY; }
listen { return LISTEN; }
set { return OPTION; }
option { return OPTION; }
on { return ON; }

[A-Za-z]([A-Za-z0-9_|\-\$])* { yylval.txt = strdup(yytext); return TEXT; }

{DIGIT}{1,3}\.{DIGIT}{1,3}\.{DIGIT}{1,3}\.{DIGIT}{1,3} { yylval.txt = yytext; return NAME; }

{DIGIT}+ {yylval.txt = yytext; return NUMBER; }

{DNSC}+(\.{DNSC}+)* { yylval.txt = yytext; return NAME; }

\n { yyl_line_no++; }

[ \r\t] { /* Nothing */ }


. { return yytext[0]; }

%%

#if 0 
int main(void) {
	yyin = stdin;
	yylex();
	return 0;
}
#endif



