#ifndef __HELPTEXT_H
#define __HELPTEXT_H

#include "header.h"

#ifdef DEFAULT_USE_MLOCk
#define M_USE "yes"
#else
#define M_USE "no"
#endif

#ifdef DEFAULT_USE_RT
#define R_SVR "yes"
#define R_CLNT "yes"
#else
#define R_SVR "no"
#define R_CLNT "no"
#endif

#define SERVER_HELP_TEXT \
"rqpserver version " VERSION  " built for " TARGET " on " __DATE__ " at " __TIME__ ".\n"\
"DEFAULT_USE_RT ? " R_SVR " DEFAULT_USE_MLOCK ? " M_USE ".\n"\
"(c) Richard Watts <Richard.Watts@cl.cam.ac.uk> 1998.\n"\
"LGPL or Artistic licence at your option.\n"\
"See " SUPPORT_URL ". Options are:\n\n"\
"--version           Gives version number.\n"\
"--help              This help text.\n"\
"--test-only         Print the contents of the config file and exit.\n"\
"--log-all-packets   Log all packets as they pass through the server.\n"\
"--do-fork           Fork children to handle each client.\n"\
"--no-fork           Handle one child yourself then exit.\n"\
"--from-inetd        Run from inetd. Implies --no-fork.\n"\
"-f config_file      Use config_file as the config file rather than\n"\
"                     " DEFAULT_CONFIG_FILE ".\n"\
"-v                  Be verbose.\n"\
"-p port             Use this port.\n"\
"--use-mlock         Attempt to lock pages into memory.\n"\
"--use-rt            Try to use the real time scheduler.\n"\
"--no-mlock          Don't attempt to lock pages into memory.\n"\
"--no-rt             Don't attempt to use the real time scheduler.\n\n"\
"Command line options take precedence over options set in the\n"\
"configuration file.\n"\
"Local support for this program is provided by " SUPPORT_LOCAL ".\n\n"


#define CLIENT_HELP_TEXT \
"rqpclient version " VERSION  " built for " TARGET " on " __DATE__ " at " __TIME__ ".\n"\
"DEFAULT_USE_RT ? " R_CLNT " DEFAULT_USE_MLOCK ? " M_USE ".\n"\
"(c) Richard Watts <Richard.Watts@cl.cam.ac.uk> 1998.\n"\
"LGPL or Artistic licence at your option.\n"\
"Syntax: client <[options]> [server IP] [server port] [cookie]\n"\
"See " SUPPORT_URL ". Options are:\n\n"\
"--version           Gives version number.\n"\
"--help              This help text.\n"\
"--log-all-packets   Log packets as they pass through the client.\n"\
"-v                  Be verbose.\n"\
"--use-mlock         Attempt to lock pages into memory.\n"\
"--use-rt            Try to use the real time scheduler.\n"\
"--no-mlock          Don't attempt to lock pages into memory.\n"\
"--no-rt             Don't attempt to use the real time scheduler.\n\n"\
"Local support for this program is provided by " SUPPORT_LOCAL ".\n\n"

#endif
