/* ft.c */
/* Handles the initial file transfers when the client opens a socket to the server. */
/* When a client opens a connection to the server, the first thing it sends is a cookie, and it
 * gets back (count, list of acls) (count, list of proxies) */

#include "header.h"


int ft_client_handle_server_connect(tcp_conn_t *conn, char *cookie, int fn) {
  unsigned int len, a;
  
  if (tcp_blocking_write(conn->fd, cookie, strlen(cookie))) {
    warn(1, "Can't write cookie");
    return -1;
  }

  if (tcp_blocking_read(conn->fd, (char *)&len, 4)) {
    warn(1, "Can't read ACL length");
    return -2;
  }
  len = ntohl(len);
  a = len/sizeof(acl_ht_entry_t);
  route_acl_table.occ = a;
  
  if (a >= route_acl_table.length) {
    warn(0, "Incoming ACL table too big (%d > %d)", a, route_acl_table.length);
    return -2;
  }
  
  if (tcp_blocking_read(conn->fd, (char *)(&route_acl_table.entries[0]),
			len)) {
    warn(1, "Can't read ACL table");
    return -3;
  }
  
  if (tcp_blocking_read(conn->fd, (char *)&len, 4)) {
    warn(1, "Can't read proxy length");
    return -2;
  }
  len = ntohl(len);
  a = len/sizeof(server_conf_elem_t);
  route_config_table.occ = a;

  if (a >= route_config_table.length) {
    warn(0, "Incoming proxy table too big (%d > %d)", a, route_config_table.length);
    return -2;
  }
  
  if (tcp_blocking_read(conn->fd, (char *)(&route_config_table.entries[0]),
			len)) {
    warn(1, "Can't read proxy table");
    return -3;
  }
    
  fn = htonl(fn);
  if (tcp_blocking_write(conn->fd, (char *)&fn, 4)) {
    warn(1, "Can't write function code");
    return -4;
  }

  if (tcp_blocking_read(conn->fd, (char *)&fn, 4)) {
    warn(1, "Can't read function code response");
    return -5;
  }
  fn = ntohl(fn);

  return fn;
}

int ft_server_handle_client_connect(tcp_conn_t *conn, char *cookie) {
  int cptr = 0;
  char b[4];
  int ret;
  int clnt_fn_code, x;

  while (1) {
    ret = read(conn->fd, b, 1);
    if (ret==1) {
      if (b[0] != cookie[cptr]) {
	warn(0, "Client does not have the right cookie");
	return -1;
      }
      cptr++;
      if (!cookie[cptr]) break;
    } else {
      if (ret < 0 && errno != EAGAIN && errno != EINTR) {
	warn(1, "Can't read from connection: client closed prematurely ?");
	return -2;
      }
    }
  }
  
  /* Great. Now transmit the ACL stuff and the mapping stuff. It's all in nbo already.. */
  *((unsigned int *)b) = htonl(route_acl_table.occ * sizeof(acl_ht_entry_t));
  if (tcp_blocking_write(conn->fd, b, 4)) {
    warn(1, "Can't write ACL length");
    return -3;
  }
  if (tcp_blocking_write(conn->fd, (char *)(&route_acl_table.entries[0]), 
			 route_acl_table.occ * sizeof(acl_ht_entry_t))) {
    warn(1, "Can't write ACL table");
    return -3;
  }
  
  *((unsigned int *)b) = htonl(route_config_table.occ * sizeof(server_conf_elem_t));
  if (tcp_blocking_write(conn->fd, b, 4)) {
    warn(1, "Can't write proxy length");
    return -3;
  }
  if (tcp_blocking_write(conn->fd, (char *)(&route_config_table.entries[0]), 
			 route_config_table.occ * sizeof(server_conf_elem_t))) {
    warn(1, "Can't write proxy table");
    return -3;
  }

  /* Grab the client's function code (currently ignored), and return 0 */
  if (tcp_blocking_read(conn->fd, (char *)&clnt_fn_code, 4)) {
    warn(1, "Can't read client function code");
    return -4;
  }

  x=0;
  if (tcp_blocking_write(conn->fd, (char *)&x, 4)) {
    return -4;
  }

  return clnt_fn_code;
}
