/* debug.c */

#include "header.h"

void dump_acls(acl_ht_entry_t *arr, int sz) {
  int i;

  for (i=0;i<sz;i++) {
    printf("ACL %d, deny ? %d addr = %lx, mask = %lx, from %d to %d\n", i, arr[i].deny,
	   (unsigned long)ntohl(arr[i].allowed),
	   (unsigned long)ntohl(arr[i].mask), ntohs(arr[i].pstart), ntohs(arr[i].pend));
  }
}

void dump_redirs(server_conf_elem_t *entries, int sz, int do_acls) {
  int i;

  for (i=0;i<sz;i++) {
    printf("Redirect %d, client %lx, port %d -> server %lx, port %d delay i (%ld,%ld) o (%ld,%ld)\n", i, 
	   (unsigned long) ntohl(entries[i].client_name), ntohs(entries[i].client_port),
	   (unsigned long)ntohl(entries[i].svr_ip), ntohs(entries[i].svr_port),
	   entries[i].delay_in.tv_sec, entries[i].delay_in.tv_usec,
	   entries[i].delay_out.tv_sec, entries[i].delay_out.tv_usec);
    if (do_acls && entries[i].u.assocacl) { 
      acl_ht_entry_t *a = entries[i].u.assocacl;

      printf("->   with ACL  %d, deny %d addr = %lx, mask = %lx, from %d to %d\n", i, a->deny,
	   (unsigned long)ntohl(a->allowed),
	   (unsigned long)ntohl(a->mask), ntohs(a->pstart), ntohs(a->pend));
    }
  }
}

/* End */
