/* client.c */

#include "header.h"
#include "helptext.h"
#ifdef _POSIX_PRIORITY_SCHEDULING
#include <sched.h>
#endif

extern int log_all_packets, verbose, use_mlock, use_rt;

int main(int argn, char *args[]) {
  ipv4_addr_t svr_ip;
  int port_nbo;
  char *cookie;
  tcp_conn_t *tconn;
  fd_set udpfds;
  int biggest_udpfd = 0, biggest_fd;
  char *pnam = args[0];
  int ret;
  int bf=-1, b0,b1;

#ifdef HAVE_SYSLOG
  openlog(LOG_IDENT_CLNT, 0, LOG_FACILITY);
#endif

  FD_ZERO(&udpfds);

  log_all_packets = 0;use_mlock = DEFAULT_USE_MLOCK; 
  use_rt = DEFAULT_USE_RT; verbose = 0;

  argn--;args++;
  while (argn > 0) { 
    if (!strcmp(*args, "--no-mlock")) {
      use_mlock = 0;
      goto end_arg_loop;
    }
    if (!strcmp(*args, "--no-rt")) {
      use_rt = 0;
      goto end_arg_loop;
    }
    if (!strcmp(*args, "--use-mlock")) {
      use_mlock = 1;
      goto end_arg_loop;
    }
    if (!strcmp(*args, "--use-rt")) {
      use_rt = 1;
      goto end_arg_loop;
    }
    if ( !strcmp(*args, "--log-all-packets")) {
      log_all_packets = 1;
      goto end_arg_loop;
    }
    if (!strcmp(*args, "--help")) {
      printf(CLIENT_HELP_TEXT);
      exit(0);
    }
    if (!strcmp(*args, "--version")) {
      printf("rqpclient version " VERSION " built for " TARGET " on " __DATE__ " at " __TIME__ ".\n");
      printf("Do %s --help for help.\n", pnam);
      exit(0);
    }
    if (!strcmp(*args, "-v")) {
      verbose++;
      goto end_arg_loop;
    }
    break;
  end_arg_loop:
    argn--;args++;
  }

  if (argn != 3) {
    fprintf(stderr, "Syntax: %s <[options]> [server IP] [server port] [cookie]\n", pnam);
    exit(1);
  }

  route_init();

  cookie = args[2];
  svr_ip = host_to_ipaddr(args[0]);
  switch (svr_ip) {
  case 0 : fatal(0, "No such host %s", args[0]); break;
  case 1: fatal(0, "Host %s des not successfully reverse resolve", args[0]); break;
  default: /* Nothing */
  }

  port_nbo = htons(atoi(args[1]));
  
  printf("Attempting to connect to %s (%lx), port %d...\n", args[0], 
	 (unsigned long)ntohl(svr_ip), ntohs(port_nbo));
  tconn = connect_to_svr_socket(svr_ip, port_nbo);
  if (tconn == NULL) {
    fatal(1, "Can't connect to server");
  }
  printf("Connection successful. Authenticating and downloading ACLs and proxy options..\n");
  ret = ft_client_handle_server_connect(tconn, cookie, CLIENT_FN_CODE_PROXY);

  if (ret < 0) {
    fatal(0, "Can't do auth and download (code %d): connection rejected by server ?", ret);
  }
  if (ret > 0) {
    fatal(0, "Unexpected function code reply from server: %d\n", ret);
  }
  printf("Connection successful. Creating listening sockets ...\n");
  {
    int i;
    char hostn[512];
    int ret;
    struct hostent *h;
    unsigned long **hx;
    int applicable = 0;
    struct sockaddr_in ic;

    i = sizeof(struct sockaddr_in);
    ret = getsockname(tconn->fd, (struct sockaddr *)&ic, &i);    
    if (ret < 0) {
      fatal(1, "Can't get local socket name");
    }

    ret = gethostname(hostn, 511);
    if (ret < 0) {
      fatal(1, "Can't get hostname");
    }

    h = gethostbyname(hostn);
    if (h == NULL) {
      fatal(1, "Can't get IP addresses");
    }
    
    for (i=0;i<route_config_table.occ;i++) {
      /* Does this CT thingy apply to me ? */
      hx = ((unsigned long **)h->h_addr_list);
      
      route_config_table.entries[i].applies = 0;
      if (ic.sin_addr.s_addr == route_config_table.entries[i].client_is) {
	applicable++; route_config_table.entries[i].applies = 1; 
      } else {      
	while (hx && *hx) {
	  /* printf("HX %lx\n", ntohl(**hx)); */
	  if ((**hx)==route_config_table.entries[i].client_is) {
	    applicable++;route_config_table.entries[i].applies = 1; break;
	  }
	  hx++;
	}
      }
    }

    if (applicable == 0) {
      fatal(0, "Configuration says I have no ports to proxy");
    }
  }
  {
    int i,j;
    int noc;
    
    /* Shuffle up the routing table .. */
    noc = 0;
    for (i=0;i<route_config_table.occ;i++) {
      if (route_config_table.entries[i].applies) {
	if (noc) {
	  route_config_table.entries[i-noc] = route_config_table.entries[i];
	}
      } else noc++;
    }
    route_config_table.occ -= noc;

    if (route_config_table.occ == 0) {
      fatal(0, "Problem compacting routing table - contact maintainer.");
    }

  if (verbose) {
      info(0, "Compacted routing table to %d entries", route_config_table.occ);
    }
  

    for (i=0;i<route_config_table.occ;i++) {
      for (j=i+1;j<route_config_table.occ;j++) {
	if (route_config_table.entries[i].client_port == 
	    route_config_table.entries[j].client_port) {
	  route_config_table.entries[j].applies = 2;
	}
      }
    }
    
    
    if (verbose) {
      info(0, "Creating fd hash table");
    }

    for (i=0;i<route_config_table.occ;i++) {
      switch (route_config_table.entries[i].applies) {
      case 1: {
	/* First of this port */
	int fd, ret;
	struct sockaddr_in saddr;
	int hash;

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (fd < 0) {
	  fatal(1, "Can't create socket");
	}
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = INADDR_ANY;
	saddr.sin_port = route_config_table.entries[i].client_port;
	
	ret = bind(fd, (struct sockaddr *)&saddr, sizeof(struct sockaddr_in));
	if (ret < 0) {
	  fatal(1, "Can't bind() client socket to port %d", ntohs(saddr.sin_port));
	}
	
	if (client_fdtable.occ >= client_fdtable.length) {
	  fatal(1, "FD Table overflow: increase TABLE_CLNT_FD_SZ.");
	}

	/* fds are always +ve */
	hash = fd%client_fdtable.length;
	while (1) {
	  if (!client_fdtable.entries[hash].used) {
	    client_fdtable.entries[hash].client_fd = fd;
	    route_config_table.entries[i].u.client_fd = fd;
	    client_fdtable.entries[hash].origin = &route_config_table.entries[i];
	    client_fdtable.entries[hash].clnt_port = route_config_table.entries[i].client_port;
	    client_fdtable.entries[hash].clnt_name = route_config_table.entries[i].client_name;
	    client_fdtable.occ ++;
	    client_fdtable.entries[hash].used = 1;
	    printf("Opened file descriptor %d to proxy port %d, client %lx (to server %lx, %d)\n",
		   fd, 
		   htons(route_config_table.entries[i].client_port),
		   (unsigned long)htonl(route_config_table.entries[i].client_name),
		   (unsigned long)htonl(route_config_table.entries[i].svr_ip),
		   htons(route_config_table.entries[i].svr_port));
	    FD_SET(fd, &udpfds);
	    if (fd > biggest_udpfd) { biggest_udpfd = fd; }
	    break;
	  }
	  hash = hash +1;
	  hash = hash%client_fdtable.length;
	}
	break;
      }
      case 2:
	/* An fdtable entry exists. We don't care - the server does origin-based routing */
	break;
      default: 
	/* Not applicable */
      }
    }
  }
    if (verbose > 0) { 
      dump_acls(route_acl_table.entries, route_acl_table.occ);
      dump_redirs(route_config_table.entries, route_config_table.occ, 0);
    }


    
  if (tconn->fd > biggest_udpfd) { 
    biggest_fd = tconn->fd;
  } else {
    biggest_fd = biggest_udpfd;
  }
  
  lock_and_set_scheduler(use_mlock, use_rt, 0);

  /* OK. Now the main loop .. */
  while (1) {
    fd_set rset, wset, xset;
    int i, bad = 0;
    int ret, cur_fd;
    char udp_buffer[UDP_BUFFER_SIZE];

  back_to_select:
    FD_ZERO(&xset); FD_ZERO(&wset);
    memcpy(&rset, &udpfds, sizeof(fd_set));
    /* memcpy(&wset, &udpfds, sizeof(fd_set)); */
    /*memcpy(&xset, &udpfds, sizeof(fd_set));*/
    
    FD_SET(tconn->fd, &rset);
    if (tconn->nextToWrite < tconn->firstFree) { FD_SET(tconn->fd, &wset); }
    
#ifdef _POSIX_PRIORITY_SCHEDULING
#ifdef HAVE_RTSCHED 
   if (use_rt) { 
      sched_yield();
    }
#endif
#endif
    ret = select(biggest_fd+1, &rset, &wset, &xset, NULL);
    if (ret < 0) {
      if (bad >= SELECT_BOMBS_HOWMANY) {
		warn(1, "Select() bombed out 8 times in a row. Sleeping ..");
	usleep(SELECT_BOMBS_USLEEP_FOR);
	/* bad=0; */
      }
      if (errno != EINTR && errno != EAGAIN) { 
	warn(1, "Help ! Select() exited.");
      }
      bad++;
      goto back_to_select;
    }

    bad = 0;
    
    if (FD_ISSET(tconn->fd, &wset)) {
      tcp_write_buffer(tconn);
    }
 
    /* Do the reads first. */
    bf =-bf;
    if (bf >0) {
      b0=0;b1=biggest_fd+1;
    } else {
      b0=biggest_fd;b1=-1;
    }
    for (cur_fd=b0; cur_fd != b1; cur_fd += bf) { 
      if (FD_ISSET(cur_fd, &rset)) {
	if (cur_fd==tconn->fd) {
	  /* TCP ready for reading. */
	  tcp_read_buffer(tconn);
	  {
	    unsigned long len;
	    unsigned long *rbuf = ((unsigned long *)(tconn->rbuffer));

	    len = ntohl(rbuf[0]);
	    while (len < tconn->rptr) {
	      /* There's a whole packet here. Read and dispatch it */
	      struct sockaddr_in toaddr;

	      toaddr.sin_family = AF_INET;
	      toaddr.sin_addr.s_addr = rbuf[1];
	      toaddr.sin_port = rbuf[4];

	      if (log_all_packets) {
		printf("Packet from TCP to %lx, %d (fd %d, fport %ld, length %ld, rp %d)\n",
		       (unsigned long)ntohl(toaddr.sin_addr.s_addr), 
		       ntohs(toaddr.sin_port), cur_fd, 
		       ntohs(rbuf[3]), len, tconn->rptr);
	      }
	      
	      /* This is a linear search: it shouldn't be - we should build a hash table as 
	       * we do for incoming packets */
	      for (i=0;i<route_config_table.occ;i++) {
		if (route_config_table.entries[i].applies &&
		    route_config_table.entries[i].client_port == rbuf[3]) {
		  /* That's the one */
		  /* printf("Sending to fd %d\n", route_config_table.entries[i].client_fd);
		  for (j=0;j<len-16;j++) {
		    printf("%x (%c) .. ", tconn->rbuffer[20+j], tconn->rbuffer[20+j]);
		  }
		  printf("\n");
		  */
		  ret = sendto(route_config_table.entries[i].u.client_fd,
			       &(tconn->rbuffer[20]), 
			       len-16, 0, (struct sockaddr *)&toaddr, 
			       sizeof(struct sockaddr_in));
		  if (ret < 0) {
		    warn(1, "Can't send packet to %x, %d", ntohl(rbuf[1]), ntohs(rbuf[4]));
		  }
		  break;
		}
	      }
	      memcpy(&tconn->rbuffer, &tconn->rbuffer[len+4], tconn->rptr-(len+4));
	      tconn->rptr -= len+4;
	      len = ntohl(rbuf[0]);
	    }
	  }
	} else {
	  /* This is a UDP packet ready for reading. Read it and write back to the TCP write
	     buffer */
	  int hash = cur_fd;
	  struct sockaddr_in saddr;
	  int ret, sl;
	  
	  ret = sizeof(struct sockaddr_in);
	  sl = recvfrom(cur_fd, &udp_buffer[20], UDP_BUFFER_SIZE-20, 0, 
			 (struct sockaddr *)&saddr, &ret);
	  if (sl <0) {
	    warn(1, "Can't recvfrom()");
	  }
	  
	  if (sl==0) {
	    warn(1, "Recieved zero-length packet ??!");
	  }
	  /*  Do we have space to write ? */
	  if (sl > 0 && tconn->top - tconn->firstFree >= sl+20) { 
	    
	    /* Check ACLs */
	    ret = 0;
	    for (i=0;i<route_acl_table.occ;i++) {
	      if ((saddr.sin_addr.s_addr & route_acl_table.entries[i].mask) == 
		  (route_acl_table.entries[i].allowed & route_acl_table.entries[i].mask)) {
		if (saddr.sin_port >= route_acl_table.entries[i].pstart &&
		    saddr.sin_port <= route_acl_table.entries[i].pend) {
	      	  ret = !route_acl_table.entries[i].deny;
		  break;
		}
	      }
	    }
	    if (ret) {	    
	      if (log_all_packets) {
		printf("Packet from %lx, %d to fd %d, length %d\n",
		       (unsigned long)ntohl(saddr.sin_addr.s_addr), 
		       ntohs(saddr.sin_port),
		     cur_fd, sl);
	      }
	      
	      while (1) {
		hash = hash % client_fdtable.length;
		
		if (!client_fdtable.entries[hash].used) {
		  warn(0, "Help ! Can't find fd %d in fd table (got to %d)", cur_fd, hash);
		  break;
		}
		
		if (client_fdtable.entries[hash].client_fd == cur_fd) {
		  unsigned long *b0 = (unsigned long *)udp_buffer;
		  /* A-ha */
		  
		  b0[0] = htonl(16+sl);
		  b0[1] = saddr.sin_addr.s_addr;
		  b0[2] = client_fdtable.entries[hash].clnt_name;
		  b0[3] = client_fdtable.entries[hash].clnt_port;
		  /* printf("Sending packet to server with c = %lx, %d",
			 ntohl(b0[2]), ntohs(b0[3]));
		  */
		  b0[4]  = saddr.sin_port;
		  memcpy(&tconn->wbuffer[tconn->firstFree], udp_buffer, sl+20);
		  tconn->firstFree += sl+20;
		  break;
		}
		hash = hash + 1;
		hash = hash%client_fdtable.length;
	      }
	    } else {
	      warn(0, "Tossing packet from %s, %d: no access",
		   inet_ntoa(saddr.sin_addr), ntohs(saddr.sin_port));
	    }
	  } else {
	    /* Toss the packet */
	    if (sl > 0) { 
	      warn(0, "Tossing packet from %lx, %d: no space in TCP stream", 
		   ntohl(saddr.sin_addr.s_addr), ntohs(saddr.sin_port));
	    }
	  }
	}
      }
    }
 
 }
  return 0;
}
  
  
