#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>
#include "imglib.h"

Display *display;
Window window;
XImage *ximage;
byte *dithered_image;
GC gc;
int x_width, x_height;
byte pixel[260];

/* ------------------------------------------------------------------------- */
int x11_open_window(char *dname, int tx, int ty, int width, int height, char *title)
{
XSizeHints hint;
unsigned int fg, bg;
XVisualInfo vinfo;
int screen;
XEvent xev;
char dummy;

		/* Open X display */
	if((display = XOpenDisplay(dname)) == NULL)
		{
		printf("Error opening display: `%s'.\n", (dname == NULL ? "$DISPLAY" : dname));
		exit(0);
		}

		/* Find the default screen */
	screen = DefaultScreen(display);

		/* Fill in hint structure */
	hint.x = tx;
	hint.y = ty;
	hint.width = x_width = width;
	hint.height = x_height = height;
	hint.flags = PPosition | PSize;
  
		/* Get some colors */
	bg = WhitePixel(display, screen);
	fg = BlackPixel(display, screen);
  
		/* Make the window */
	if(!XMatchVisualInfo(display, screen, 8, PseudoColor, &vinfo))
		{
      if(!XMatchVisualInfo(display, screen, 8, GrayScale, &vinfo))
			{
			printf("An 8 bit display is required.\n");
			exit(0);
			}
		}

	window = XCreateSimpleWindow(display, DefaultRootWindow(display),
		hint.x, hint.y, hint.width, hint.height, 4, fg, bg);

	XSelectInput(display, window, StructureNotifyMask);

		/* Tell other applications about this window */
	XSetStandardProperties(display, window, title, title, None, NULL,0, &hint);

		/* Map window. */
	XMapWindow(display, window);

		/* Wait for map. */
	do
		{
		XNextEvent(display, &xev);
		}
	while(xev.type != MapNotify || xev.xmap.event != window);

	XSelectInput(display, window, ButtonPressMask | KeyPressMask | ExposureMask);
	XMapRaised(display, window);

	ximage = XCreateImage(display, None, 8, ZPixmap, 0, &dummy, width,
		height, 8, 0);

	if(!(dithered_image = (byte *)malloc(width * height)))
		{
      printf("Error allocating dither image.\n");
		return(0);
		}

	gc = DefaultGC(display, screen);
	return(1);
}


/* ----------------------------------------------------------------------- */
void x11_window_colours(byte *r_cmap, byte *g_cmap, byte *b_cmap)
{
unsigned int pos;
unsigned long tmp_pixel;
int private, screen;
XColor xcolor;
Colormap cmap;
XWindowAttributes xwa;

	screen = DefaultScreen(display);
	cmap = DefaultColormap(display, screen);
	private = 0;

	for(pos = 0; pos < 256; pos++)
		{
			/* X11 colors are 16 bit */
		xcolor.red   = r_cmap[pos] << 8;
		xcolor.green = g_cmap[pos] << 8;
		xcolor.blue  = b_cmap[pos] << 8;

		if(XAllocColor(display, cmap, &xcolor) != 0) pixel[pos] = xcolor.pixel;
		else
			{
				/* allocation failed, have to use a private colormap */
			if(private)
				{
				printf("Couldn't allocate private colormap");
				exit(0);
				}

			private = 1;
			printf("Using private colormap (%d colors were available).\n", pos);

				/* Free colors. */
			while(--pos != 0)
				{
				tmp_pixel = pixel[pos]; /* because XFreeColors expects unsigned long */
				XFreeColors(display, cmap, &tmp_pixel, 1, 0);
				}

				/* pos is now 0: restarts outer loop.  Create private colormap */
			XGetWindowAttributes(display, window, &xwa);
			cmap = XCreateColormap(display, window, xwa.visual, AllocNone);
			XSetWindowColormap(display, window, cmap);
			}
		}

#ifndef NO_INSTALL_CMAP
	XInstallColormap(display, cmap);
#endif
	XSync(display, 0);
}


/* ----------------------------------------------------------------------- */
void x11_close_window(void)
{
	/*XDestroyImage(win->ximage);*/
	XDestroyWindow(display, window);
	XFlush(display);
}


/* ----------------------------------------------------------------------- */
void x11_wait_mouse(void)
{
XEvent event;

	while(1)
		{
		XNextEvent(display, &event);
		if(event.type == ButtonPress && event.xbutton.button == Button1) return;
		if(event.type == Expose)
			XPutImage(display, window, gc, ximage, 0, 0, 0, 0, x_width, x_height);
		}
}


/* ----------------------------------------------------------------------- */
void x11_display_image(byte *p)
{
int pos;

	for(pos = 0; pos < x_width * x_height; pos++)
		dithered_image[pos] = pixel[p[pos]];

	ximage->data = (char *)dithered_image;
	XPutImage(display, window, gc, ximage, 0, 0, 0, 0, x_width, x_height);
}


/* ------------------------------------------------------------------------- */
void main(int argc, char **argv)
{
pic_info *pinfo;
int frame = 0;

	if(argc < 2)
		{
		printf("xcinplay : written by Tim Ferguson, 1998.\n\n");
		printf("xcinplay <.cin file>\n");
		return;
		}

	if((pinfo = open_idcin(argv[1])) == NULL)
		{
		printf("Error opening file `%s'\n", argv[1]);
		return;
		}

	if(!x11_open_window(NULL, 50, 50, pinfo->width, pinfo->height, "xcinplay"))
		{
		printf("Error opening window.\n");
		return;
		}
	x11_window_colours(pinfo->r_cmap, pinfo->g_cmap, pinfo->b_cmap);

	while(read_idcin_frame(pinfo))
		{
		if(pinfo->colour_update)
			x11_window_colours(pinfo->r_cmap, pinfo->g_cmap, pinfo->b_cmap);

		x11_display_image(pinfo->pic);

		printf(" Frame: %d\r", frame++);
		fflush(stdout);
		}

	printf("\n");
	close_idcin(pinfo);
	x11_wait_mouse();
	x11_close_window();
}

