#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include "imglib.h"


/* -------------------------------------------------------------------------- */
void set_pic_dimensions(pic_info *pinfo, int width, int height, int colour_format)
{
	pinfo->colour_format = colour_format;
	pinfo->width = width;
	pinfo->height = height;

	if(colour_format == C_Y || colour_format == C_LOOKUP)
		pinfo->chroma_width = pinfo->chroma_height = 0;
	else if(colour_format == C_RGB)
		{
		pinfo->chroma_width = width;
		pinfo->chroma_height = height;
		}
	else
		{
		pinfo->chroma_width = (colour_format == C_YUV444) ? width : width >> 1;
		pinfo->chroma_height = (colour_format != C_YUV420) ? height : height >> 1;
		}
}


/* -------------------------------------------------------------------------- */
pic_info *create_pic(int width, int height, int colour_format)
{
pic_info *pinfo;

	if((pinfo = calloc(sizeof(pic_info), 1)) == NULL) return(NULL);
	pinfo->type = T_NONE;
	pinfo->pic_a = pinfo->pic_b = pinfo->pic_c = NULL;
	pinfo->int_data = NULL;
	pinfo->colour_update = 0;

	if(width == -1 || height == -1 || colour_format == -1) return(pinfo);

	set_pic_dimensions(pinfo, width, height, colour_format);
	pinfo->frames = -1;
	pinfo->frame_num = 0;
	pinfo->num_colour = -1;

	if((pinfo->pic_a = (byte *)calloc(pinfo->width * pinfo->height, 1)) == NULL) return(NULL);
	if(pinfo->chroma_width > 0)
		{
		if((pinfo->pic_b = (byte *)calloc(pinfo->chroma_width * pinfo->chroma_height, 1)) == NULL) return(NULL);
		if((pinfo->pic_c = (byte *)calloc(pinfo->chroma_width * pinfo->chroma_height, 1)) == NULL) return(NULL);
		}

	return(pinfo);
}


/* -------------------------------------------------------------------------- */
void free_pic(pic_info *pinfo)
{
	if(pinfo == NULL) return;
	if(pinfo->pic_a) free(pinfo->pic_a);
	if(pinfo->pic_b) free(pinfo->pic_b);
	if(pinfo->pic_c) free(pinfo->pic_c);
	free(pinfo);
}


/* --------------------------------------------------------------------------
 */
unsigned int stm_read_lsb_word(FILE *fp)
{
unsigned int ret;

	ret  = ((fgetc(fp)) & 0xff);
	ret |= ((fgetc(fp)) & 0xff) << 8;
	return(ret);
}


/* --------------------------------------------------------------------------
 */
unsigned int stm_read_msb_word(FILE *fp)
{
unsigned int ret;

	ret  = ((fgetc(fp)) & 0xff) << 8;
	ret |= ((fgetc(fp)) & 0xff);
	return(ret);
}


/* --------------------------------------------------------------------------
 */
unsigned long stm_read_lsb_long(FILE *fp)
{
unsigned long ret;

	ret  = ((fgetc(fp)) & 0xff);
	ret |= ((fgetc(fp)) & 0xff) << 8;
	ret |= ((fgetc(fp)) & 0xff) << 16;
	ret |= ((fgetc(fp)) & 0xff) << 24;
	return(ret);
}


/* --------------------------------------------------------------------------
 */
unsigned long stm_read_msb_long(FILE *fp)
{
unsigned long ret;

	ret  = ((fgetc(fp)) & 0xff) << 24;
	ret |= ((fgetc(fp)) & 0xff) << 16;
	ret |= ((fgetc(fp)) & 0xff) << 8;
	ret |= ((fgetc(fp)) & 0xff);
	return(ret);
}


/* --------------------------------------------------------------------------
 */
void stm_write_lsb_word(FILE *fp, unsigned int val)
{
	putc(val & 0xff, fp);
	putc((val & 0xff00) >> 8, fp);
}


/* --------------------------------------------------------------------------
 */
void stm_write_msb_word(FILE *fp, unsigned int val)
{
	putc((val & 0xff00) >> 8, fp);
	putc(val & 0xff, fp);
}


/* --------------------------------------------------------------------------
 */
void stm_write_lsb_long(FILE *fp, unsigned long val)
{
	putc(val & 0xff, fp);
	putc((val & 0xff00) >> 8, fp);
	putc((val & 0xff0000) >> 16, fp);
	putc((val & 0xff000000) >> 24, fp);
}


/* --------------------------------------------------------------------------
 */
void stm_write_msb_long(FILE *fp, unsigned long val)
{
	putc((val & 0xff000000) >> 24, fp);
	putc((val & 0xff0000) >> 16, fp);
	putc((val & 0xff00) >> 8, fp);
	putc(val & 0xff, fp);
}


