/* ------------------------------------------------------------------------ */
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* ------------------------------------------------------------------------ */
#ifndef TRUE
#	define TRUE	1
#	define FALSE	0
#endif

typedef unsigned char byte;
typedef unsigned int word;

/* ------------------------------------------------------------------------ */
	/* chroma_format */
#define C_UNKNOWN		0
#define C_RGB			1
#define C_YUV444		2
#define C_YUV422		3
#define C_YUV411		4
#define C_YUV420		5
#define C_Y				6
#define C_LOOKUP		7

	/* file types */
#define T_NONE			0
#define T_PICTURE		1		/* general picture */
#define T_UVCG			2		/* uvcg video format */
#define T_SEQUENCE	3		/* picture sequence */
#define T_RAWSEQ		4		/* raw sequence */
#define T_MPEG_VID	5		/* MPEG video sequence */
#define T_GIF_ANIM	6		/* Animated gif sequence */
#define T_ABEKUS_SEQ	7		/* Abekus sequence */
#define T_PALETTE		8		/* Palette file */
#define T_GP			9		/* GP sequence */
#define T_AVI			10		/* AVI sequence */
#define T_IDCIN		11		/* Id cinema sequence */

#define r_pic	pic_a
#define g_pic	pic_b
#define b_pic	pic_c

#define y_pic	pic_a
#define u_pic	pic_b
#define v_pic	pic_c

#define pic	pic_a

typedef struct {
	word type;				/* type of picture, palette or sequence */
	word colour_format;	/* type of colour mode */
	int width, height;	/* width and height of picture */
	int frames;				/* number of frames in sequence */
	int frame_num;			/* current frame number */
	int chroma_width, chroma_height;	/* chroma width and height for u &  v*/
	int num_colour;		/* number of colours */
	byte r_cmap[300], g_cmap[300], b_cmap[300];		/* rgb colour map */
	byte *pic_a, *pic_b, *pic_c;	/* up to 3 component colour bitmap y, rgb, yuv*/
	byte pen_a, pen_b, pen_c;
	byte colour_update;	/* colour palette changed */
	void *int_data;		/* internal data store for image sequences */
} pic_info;


/* ------------------------------------------------------------------------ */
	/* util.c */
void set_pic_dimensions(pic_info *pinfo, int width, int height, int colour_format);
pic_info *create_pic(int width, int height, int colour_format);
void free_pic(pic_info *pinfo);
unsigned int stm_read_lsb_word(FILE *fp);
unsigned int stm_read_msb_word(FILE *fp);
unsigned long stm_read_lsb_long(FILE *fp);
unsigned long stm_read_msb_long(FILE *fp);
void stm_write_lsb_word(FILE *fp, unsigned int val);
void stm_write_msb_word(FILE *fp, unsigned int val);
void stm_write_lsb_long(FILE *fp, unsigned long val);
void stm_write_msb_long(FILE *fp, unsigned long val);

	/* idcin.c */
pic_info *open_idcin(char *fname);
int read_idcin_frame(pic_info *pinfo);
int create_idcin(char *fname);
int write_idcin_frame(pic_info *pinfo, int pass);
void close_idcin(pic_info *pinfo);

