/* Name		: getflags.c                                            *
 *									*
 * Description	: Takes user inputed dmflags and displays which         *
 * 		  individual flags are set in Quake2 deathmatch. 	*
 *									*
 * Version	: 1.2      	       			         	*
 *									*
 * Notes	: The maximum number of flag slots is determined by     *
 * MAX_FLAGS.  Then the numerical value of each flag (1, 2, 4, 8,       *
 * 16, 32, 64, 128, 256, 512, etc.) is figured and stored into it's     *
 * corresponding element of flag_array[].  The highest possible combi-  *
 * nation (the value you get when you add all the individual flags'     *
 * values up, giving you an "all flags on" game) is then figured by the *
 * determine_highest_flag() function and used in various places in the  *
 * program.                                                             *
 *									*
 *    The user is asked to input the dmflags value for the game, conti- *
 * nuing to ask until a value from 1 to determine_highest_flag()'s value*
 * is entered; or 0, which ends the program.  The value is stored in A  *
 * (printed in comments as a capital letter to avoid confusion).  If    *
 * determine_highest_flag()'s value is entered, every element of flag_  *
 * list_array[] is assigned TRUE and the program goes on to print a     *
 * description of the flags that are set.  Otherwise, a loop is started *
 * that sets flag_array[] at it's highest element, and compares it to A *
 * to see if A is equal to or greater than it.  If so, the same element *
 * (that flag_array[] is currently at) of flag_list_array[] is assigned *
 * TRUE, and the value of flag_array[]'s current element is subtracted  *
 * from A, the difference of which is reassigned to A.  The current     *
 * working element of flag_array[] is decremented by 1 and the loop con-*
 * tinues until all elements of flag_array[] have been checked against  *
 * A's current value.  If the current working element of flag_array[] is*
 * not less than or equal to A, the current working element of flag_    *
 * list_array[] (which is the same as that of flag_array[]) is assigned *
 * FALSE. Flag_array[]'s element is decremented and the loop continues  *
 * without doing anything to A.		              		 	*
 *    Once every element of flag_list_array[] is assigned either TRUE or*
 * FALSE, each individual element of flag_list_array[] is checked to see*
 * whether it's TRUE or FALSE.  If TRUE, the appropriate description    *
 * for the element's corresponding DM flag is printed (e.g - weapons    *
 * stay, etc.).                                                         *
 *    The program continues to ask the user for DM flags until a value  *
 * of 0 is entered.							*
 *									*
 *   (Note that flag 65536 will end up stored in an array somewhere,    *
 * but I don't think that it does anything in the game.  So if it's en- *
 * tered as a dmflag (or is figured as one by the program), it'll re-   *
 * turn a description of "I don't think 65536 is a valid flag!".  I     *
 * could've easily left that comment out, but someone might try to en-  *
 * ter that as a value and I didn't want them to think it was a bug     *
 * when they didn't get a description back (and I didn't want to bother *
 * with recoding to not accept that value during data entry, anyway)!   *
 * This shouldn't pose a problem since I doubt a server would have flag *
 * 65536 set on, anyway.)						*
 *									*
 *    To add more deathmatch flags (if any more are added to the game), *
 * the '20' in '#define MAX_FLAGS 20' must be raised to reflect the new *
 * limit of flags, and the appropriate descriptions for each new flag   *
 * must be added at the end of main(), checking it's corresponding ele- *
 * ment in flag_list_array[] for TRUEness.                              *
 *    However, if more flags are added to the game later on, and the    *
 * code was changed to add the extra flags, care should be taken if     *
 * there are any "gaps" between the current highest flag and the begin- *
 * ning of the new additions (such as between 32768 and 131072).  	*
 *                                                                      *
 *    Various statements have been left in, but commented out.  These   *
 * were used for testing the program in it's initial stages and are no  *
 * longer necessary.  They were left in for possible future use, if     *
 * needed, so they wouldn't have to be rethunk and recoded, just uncomm-*
 * ented!  Here's what they do:		 	                        *
 *   The first one prints the values of each flag stored in flag_array[]*
 * to make sure that each flag got assigned the appropriate number.     *
 *    The second one prints the TRUEness or FALSEness of each element   *
 * in flag_list_array[] to make sure the math that determined which     *
 * flags were on or off was done correctly.                             *
 *    The last one makes sure that the function determine_highest_flag()*
 * did, indeed, determine the highest possible flag correctly, as it    *
 * printed the highest possible flag's value.                           *
 *                                                                      *
 * Known bugs	: So far, none noticed.  However if a fraction or float-*
 * ing point value is entered by the user, the numbers after the decimal*
 * point will be left off and only the whole number value will be acc-  *
 * epted; and a negative zero (-0) will be considered the same as zero  *
 * (and end the program).  Also, if characters are entered instead of   *
 * a number, it'll run on nonstop!					*/

 #include <stdio.h>

/* Symbolic constants.  To be used to assign which flags are on	*
 * or off in flag_list_array[].				        */

#define TRUE 1
#define FALSE 0

/* Sets maximum number of flags.	*/

#define MAX_FLAGS 20

/* Function prototype which determines what the highest possible	*
 * flags setting value could be (i.e.- "all flags on").		 	*/

unsigned long determine_highest_flag (unsigned long);

/* Arrays.						    	*
 * flag_array[] stores all the flag's numbers.			*
 * flag_list_array[] stores a value of TRUE or FALSE in it's    *
 * elements (which correspond with the flag numbers in flag_    *
 * array[]'s elements).  This array is what tells which of the  *
 * flags are off or on.						*/

unsigned long flag_array [MAX_FLAGS];
unsigned long flag_list_array [MAX_FLAGS];

/* Variable assignments.					*
 * A is the user's inputed dmflags for the game.  B is used for *
 * a counter in various loops.  C is used to hold the value of  *
 * each flag to be assigned to it's appropriate element of flag_*
 * array[].							*/

unsigned long a=1, b, c=1;

main()
{
	/* Stores dmflag numbers in flag_array[].	*/

	for (b = 0; b < MAX_FLAGS; b++, c = c * 2) 
		flag_array[b] = c;                 

     /* TEST ONLY - Prints dmflag numbers stored in flag_array[].	*
      *					                	    	*
      *	for (b = 0; b < MAX_FLAGS; b++)                             	*
      *		printf("\nElement %lu is:\t%lu", b, flag_array[b]); 	*/

/* WHILE - loop keeps running the program until user enters 0 for	*
 * dmflags to quit.						  	*/

while (a != FALSE)
{
	/* DO - WHILE loop gets dmflags and prevents user from	*
	 * entering a negative number or a number higher than  	*
	 * the highest possible dmflag combination.            	*/

	do                                
	{                                 
		printf("\nEnter DM Flags (1 - %lu, 0 to quit): ", determine_highest_flag (MAX_FLAGS));
		scanf("%lu", &a);         
	}while ((a > determine_highest_flag(MAX_FLAGS)) || (a < 0));      
       
	/* If dmflags are highest possible (as per determine_highest_flag()),*
	 * every element in flag_list_array[] is assigned value of TRUE.     */

	if ( a == determine_highest_flag (MAX_FLAGS) )  
		for ( b = 0; b < MAX_FLAGS; b++ )  
			flag_list_array[b] = TRUE; 
						   
	else
	{
		/* If dmflags are 0, every element in flag_list_array[] *
		 * is assigned value of FALSE.  That's been commented   *
		 * out and now a value of 0 ends the program.           */

		if ( a == 0 )      
		{
		   /*	for ( b = 0; b < MAX_FLAGS; b++ )     *
		    *		flag_list_array [b] = FALSE;  */

				return 0;
		}
		else  
		{     
			/* DOES THE MATH!  If A is greater than or equal to *
			 * value in current working element of flag_array[] *
			 * ( as per counter), the same element of           *
			 * flag_list_array[] is assigned TRUE.  Then A      *
			 * subtracts flag_array's[] current element value   *
			 * from A and reassigns the difference to A.        */

			for ( b = MAX_FLAGS; b > 0; b--) 
			{
				if ( a >= flag_array [b-1] )
				{
					flag_list_array [b-1] = TRUE;
					a = ( a - flag_array [b-1] );
				}

				else              
				{       
					/* If A is not greater than or      *
					 * equal to current element of flag_*
					 * array[], the appropriate element *
					 * of flag_list_array[] is FALSE.   *
					 * (A is NOT reassigned--very impor-*
					 * tant!)			    */
          
					flag_list_array [b-1] = FALSE;
				}
		   	}
		}  
	}

     /* TEST ONLY - Prints each element's value of                      *
      *		    flag_list_array[] (0 or 1).				*
      *	puts(" ");							*
      *									*
      *	for ( b = 0; b < MAX_FLAGS; b++ )   				*
      *		printf("Flag %lu is:\t%lu\n", b+1, flag_list_array [b]);*/

	/* Prints the descriptions of flags that are set TRUE. */

	puts(" ");

	if (flag_list_array[0] == TRUE)
		puts("No health.");

	if (flag_list_array[1] == TRUE)
		puts("No powerups.");

	if (flag_list_array[2] == TRUE)
		puts("Weapons stay.");

	if (flag_list_array[3] == TRUE)
		puts("No falling damage.");

	if (flag_list_array[4] == TRUE)
		puts("Instant powerups.");

	if (flag_list_array[5] == TRUE)
		puts("Same map.");

	if (flag_list_array[6] == TRUE)
		puts("Teams by skin.");

	if (flag_list_array[7] == TRUE)
		puts("Teams by model.");

	if (flag_list_array[8] == TRUE)
		puts("No friendly fire.");

	if (flag_list_array[9] == TRUE)
		puts("Spawn farthest.");

	if (flag_list_array[10] == TRUE)
		puts("Force respawn.");

	if (flag_list_array[11] == TRUE)
		puts("No armour.");

	if (flag_list_array[12] == TRUE)
		puts("Allow exit.");

	if (flag_list_array[13] == TRUE)
		puts("Infinite ammo.");

	if (flag_list_array[14] == TRUE)
		puts("Quad drop.");

	if (flag_list_array[15] == TRUE)
		puts("Fixed FOV.");

	if (flag_list_array[16] == TRUE)
		puts("I don't think 65536 is a valid flag!");

	if (flag_list_array[17] == TRUE)
		puts("CTF - Forced join.");

	if (flag_list_array[18] == TRUE)
		puts("CTF - Armour protected from friendly fire.");

	if (flag_list_array[19] == TRUE)
		puts("CTF - No tech powerups.");

	/* Reassigns A as TRUE (not zero) so the program will  *
	 * continue to ask user for flags until they enter 0.  */

	a = TRUE;

}
	return 0;

}

/* Function to determine the highest possible flag number, used to prevent  *
 * user from entering too high of a value in initial data entry and to be   *
 * used to determine if flags were, indeed, the highest possible, and thus  *
 * assign ALL slots of flag_list_array[] as TRUE, instead of having to do   *
 * the math to assign a value to each element of flag_list_array[].   	    */

unsigned long determine_highest_flag (unsigned long a)
{
	unsigned long b=0, c;

	for ( c = 0; c < a; c++)
		b = ( b + flag_array[c] );

     /* TEST ONLY - Prints the highest possible flag combination.	*
      *						      			*
      *	printf("\nHighest flag = %lu", b);	      			*/

	return (b);
}
