
//
// Hexen 2 game definition file (.fgd) PART 3 of 3
// version 0.91
//
// written by autolycus / autolycus@planetquake.com
// email me with improvements and suggestions
//

@Main = 
[
	Name: "Hexen 2"
	Palette: "hexen2.pal"
	DefaultClass: "func_door"
]

//
// worldspawn
//

@SolidClass = worldspawn : "World entity"
[
	message(string) : "Level name"
	worldtype(choices) : "Ambience" : 0 =
	[
		0 : "castle"
		1 : "egypt"
		2 : "meso"
		3 : "roman"
	]
	sounds(integer) : "CD track to play" : 1
]

//
// base marker definitions
//

@baseclass = Appearflags [
	spawnflags(Flags) =
	[
		256 : "Not in Easy" : 0
		512 : "Not in Normal" : 0
		1024 : "Not in Hard" : 0
		2048 : "Not in Deathmatch" : 0
	]
]

@baseclass = Targetname [ targetname(target_source) : "Name" ]
@baseclass = Target [ target(target_destination) : "Target" ]

//
// player starts, deathmatch, coop, teleport
//

@baseclass base(Appearflags) size(-16 -16 -32, 16 16 32) 
	color(0 255 0) = PlayerClass []

@PointClass base(PlayerClass, Targetname) = info_player_start : "Player 1 start" []
@PointClass base(PlayerClass, Targetname) = info_player_start2 : "Player 1 start" []
@PointClass base(PlayerClass) = info_player_deathmatch : "Player deathmatch start" []
@PointClass base(PlayerClass) = info_player_coop : "Player cooperative start" []
@PointClass base(PlayerClass, Targetname) = info_teleport_destination : "Teleport destination" []

@PointClass base(Appearflags) size(-16 -16 0, 16 16 56) = paladin_dead : "Dead paladin" []

@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = path_corner : "Monster and Train path"
[
	spawnflags(Flags) =
	[
		1 : "Synch" : 0
	]
	target(string) : "Next path_corner"
	speed(integer) : "Speed"
	angles(string) : "Rotation angle (x y z)"
	anglespeed(integer) : "Rotation speed"
]

@SolidClass base(Appearflags, Targetname) = plaque : "Readable plaque"
[
	spawnflags(Flags) =
	[
		1 : "invisible" : 0
		2 : "deactivated" : 0
	]
	message(integer) : "String index #"
	noise1(string) : "Noise (dir/sound.wav)"
]

@PointClass base(Appearflags, Target) size(-8 -8 0, 8 8 32) = player_sheep : "Sheep"
[
	spawnflags(Flags) =
	[
		1 : "stationary" : 0
		2 : "stuck" : 0
		4 : "jump" : 0
		8 : "play dead" : 0
		16 : "dormant" : 0
		32 : "no drop" : 0
	]
]

@PointClass base(Appearflags, Target) size(-8 -8 -8, 8 8 16) = puzzle_piece : "Puzzle piece"
[
	spawnflags(Flags) =
	[
		1 : "spawn" : 0
		2 : "floating" : 0
		4 : "auto get" : 0
	]
	puzzle_id(integer) : "Puzzle id"
	netname(string) : "Name of piece"
]

@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) = puzzle_static_piece : "Static puzzle piece"
[
	puzzle_id(string) : "Name of puzzle"
	lifespan(integer) : "Lifespan"
]

@PointClass base(Appearflags, Targetname) size(-55 -55 -24, 55 55 100) = rider_death : "Death!"
[
	spawnflags(Flags) =
	[
		1 : "trigger wait" : 0
	]
	map(string) : "Next map after killing"
	target(string) : "Start spot on next map"	
]
@PointClass base(rider_death) = rider_famine : "Famine!" []
@PointClass base(rider_death) = rider_pestilence : "Pestilence!" []
@PointClass base(rider_death) size(-50 -50 -24, 50 50 100) = rider_war : "War!" []

@SolidClass base(Appearflags, Targetname) = rider_quake : "Rider quake" []
@PointClass base(Appearflags) = rider_quake_center : "Quake center" []

@SolidClass base(Appearflags) = rider_trigger_multiple : "Trigger multiple"
[
	rt_chance(integer) : "Chance of triggering (0 - 1)" : 1
]

@SolidClass base(rider_trigger_multiple) = rider_trigger_once : "Trigger once" []

// This is where I started drinking Corona

@PointClass base(Appearflags, Target) size(-8 -8 -44, 8 8 20) = Ring_Flight : "Ring o' flight"
[
	spawnflags(Flags) =
	[
		1 : "floating" : 0
	]
]
@PointClass base(Ring_Flight) = Ring_Regeneration : "Ring o' regeneration" []
@PointClass base(Ring_Flight) = Ring_Turning : "Ring o' turning" []
@PointClass base(Ring_Flight) = Ring_WaterBreathing : "Ring o' water breathing" []

@SolidClass base(Appearflags) = ropebridge_link : "rope bridge"
[
	spawnflags(Flags) =
	[
		1 : "start" : 0
	]
	target(string) : "Next link"
]
@PointClass base(Appearflags) = sound_ambient : "Ambient sound"
[
	soundtype(choices) : "Sound" : 4 =
	[
		1 : "windmill"
		2 : "sewer water sound"
		3 : "dripping water, no echo"
		4 : "subtle sky/wind"
		5 : "crickets / night sounds"
		6 : "birds"
		7 : "raven caw"
		8 : "rocks falling"
		9 : "lava bubble"
		10 : "water gurgle"
		11 : "metal"
		12 : "pounding"
		13 : "moans and screams"
		14 : "creaking"
		15 : "chain rattling"
	]
]

@PointClass base(Appearflags, Targetname) size(-10 -10 -8, 10 10 8) = sound_maker : "Triggerable sound"
[
	soundtype(choices) : "Sound" : 1 =
	[
		1 : "bell ringing"
		2 : "organ music"
		3 : "tomb sound"
	]
]

@PointClass base(Appearflags) size(-48 -48 -16, 48 48 16) = sprite_backgrnd_1 : "Sprite background #1" []
@PointClass base(sprite_backgrnd_1) = sprite_backgrnd_2 : "Sprite background #2" []
@PointClass base(Appearflags) size(-16 -16 -10, 16 16 10) = sprite_moss1 : "Moss" []
@PointClass base(Appearflags) size(-32 -32 -95, 32 32 90) = sprite_tree1 : "Tree" []
@PointClass base(sprite_tree1) = sprite_tree2 : "Tree" []
@PointClass base(Appearflags) size(-32 -32 -10, 32 32 10) = sprite_treetop : "Tree top" []

@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = target_null : "Null target for camera" []

@PointClass base(Appearflags) size(-13 -13 -14, 13 13 22) = trap_boulder : "Boulder" []
@PointClass base(Appearflags) size(0 0 0, 16 16 16) = trap_death_fireball : "Fireball"
[
	wait(string) : "Time between firings" : "0.5"
	dmg(integer) : "Damage" : 10
]
@PointClass base(Appearflags, Targetname, Target) size(0 0 0, 16 16 16) = trap_fireball : "Triggerable fireball"
[
	spawnflags(Flags) =
	[
		1 : "trigger only" : 0
	]
	wait(string) : "Time between firings" : "0.5"
	dmg(integer) : "Damage" : 10
]
@PointClass base(Appearflags, Target) size(-8 -8 -8, 8 8 8) = trap_lightning : "Lightning"
[
	spawnflags(Flags) =
	[
		1 : "track" : 0
		2 : "once" : 0
	]
	noise(choices) : "Sounds" : 2 =
	[
		1 : "no sound"
		2 : "lightning"
	]
	wait(integer) : "Time between shots"
	aflag(integer) : "Radius limiter"
	dmg(integer) : "Damage"
]
@PointClass base(Appearflags) size(-8 -8 -8, 8 8 8) = trap_shooter : "Shooter"
[
	spawnflags(Flags) =
	[
		1 : "super spike" : 0
		2 : "laser" : 0
	]
	wait(integer) : "Time between shots" : 1
	nextthink(integer) : "Delay before start"
]
@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = trap_spikeshooter_spray : "Shooter"
[
	wait(integer) : "Time between shots" : 1
	nextthink(integer) : "Delay before start"
]
@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = trap_spikeshooter : "Shooter"
[
	spawnflags(Flags) =
	[
		1 : "super spike" : 0
		2 : "laser" : 0
	]
	wait(integer) : "Time between shots" : 1
	nextthink(integer) : "Delay before start"
]

//
// triggers
//

@BaseClass base(Appearflags, Targetname, Target) = Trigger 
[
	killtarget(string) : "KillTarget"
	netname(string) : "Netname"
	aflag(integer) : "order"
	wait(integer) : "Wait"
	health(integer) : "Health"
	delay(string) : "Delay before trigger"
	message(string) : "Message"
]

@SolidClass base(Trigger) = trigger_activate : "Activate"
[
	spawnflags(Flags) =
	[
		1 : "once" : 0
		2 : "relay" : 0
		8 : "deactivated" : 0
	]
]
@SolidClass base(Trigger) = trigger_attack : "Trigger on weapon fire" []
@SolidClass base(Trigger) = trigger_changelevel : "Changes level"
[
	spawnflags(Flags) =
	[
		1 : "no intermission" : 0
		2 : "end of unit" : 0
		4 : "end of episode" : 0
	]
	map(string) : "Map name"
]
@SolidClass base(Trigger) = trigger_check : "Check"
[
	netname(string) : "Check name"
]
@SolidClass base(Trigger) = trigger_combination_assign : "Combination assign"
[
	spawnflags(Flags) =
	[
		1 : "no touch" : 0
		2 : "monster touch" : 0
		4 : "push touch" : 0
		8 : "deactivated" : 0
		16 : "remove puzzle" : 0
		32 : "no puzzle" : 0
		64 : "light start low" : 0
	]
	mangle(string) : "Mangle (x y z)"
]
@SolidClass base(Trigger) = trigger_control : "Ballista control" []
@SolidClass base(Appearflags, Targetname, Trigger) = trigger_counter : "Counter"
[
	spawnflags(Flags) =
	[
		1 : "no message" : 0
		2 : "ordered" : 0
		4 : "always return" : 0
		8 : "deactivated" : 0
	]
        count(integer) : "number of triggers - 1"
        mangle(string) : "Mangle (x1 x2 x3)"
]
@SolidClass base(Trigger) = trigger_counter_reset : "Counter reset"
[
	spawnflags(Flags) =
	[
		1 : "no touch" : 0
		2 : "monster touch" : 0
		4 : "push touch" : 0
		8 : "deactivated" : 0
		16 : "remove puzzle" : 0
		32 : "no puzzle" : 0
		64 : "light toggle" : 0
		128 : "light start low" : 0
	]
]
@SolidClass base(Trigger) = trigger_crosslevel : "Cross level trigger"
[
	spawnflags(Flags) =
	[
                1 : "trigger 1" : 0
                2 : "trigger 2" : 0
                4 : "trigger 3" : 0
                8 : "trigger 4" : 0
                16 : "trigger 5" : 0
                32 : "trigger 6" : 0
                64 : "trigger 7" : 0
                128 : "trigger 8" : 0
	]
]
@SolidClass base(trigger_crosslevel) = trigger_crosslevel_target : "Crosslevel trigger target" []
@SolidClass base(trigger_activate) = trigger_deactivate : "Deactivate" []
@SolidClass base(Appearflags, Targetname) = trigger_deathtouch : "Removes whatever it touches"
[
	th_die(integer) : "Death type"
]
@SolidClass base(Appearflags, Targetname) = trigger_fan_blow : "Blows player away from func_rotating" []
// argh, still not a togglable trigger_hurt...do i have to *point out* how useful that would be???
@SolidClass base(Appearflags) = trigger_hurt : "Hurt brush" [ dmg(integer) : "Damage" : 5 ]
@PointClass base(Trigger) size(-8 -8 -8, 8 8 8) = trigger_interval : "Interval trigger?" []
@SolidClass base(Appearflags) = trigger_magicfield : "magic field (does this exist???)" []
@SolidClass base(Appearflags, Targetname, Target) = trigger_message_transfer : "Target transferer" 
[
	message(string) : "Message"
]
@SolidClass base(Appearflags) = trigger_monsterjump : "Monster jumper"
[
	speed(integer) : "Speed forward" : 200
	height(integer) : "Speed upwards" : 200
]
@SolidClass base(Trigger) = trigger_multiple : "Multiple trigger"
[
	spawnflags(Flags) =
	[
		1 : "no touch" : 0
		2 : "monster touch" : 0
		4 : "push touch" : 0
		8 : "deactivated" : 0
		16 : "remove puzzle" : 0
		32 : "no puzzle" : 0
		64 : "light toggle" : 0
		128 : "light start low" : 0
	]
	soundtype(choices) : "Sounds" : 0 =
	[
		0 : "no sound"
		1 : "secret"
		2 : "beep beep"
		3 : "large switch"
	]
	puzzle_piece_1(integer) : "Puzzle Piece 1"
	puzzle_piece_2(integer) : "Puzzle Piece 2"
	puzzle_piece_3(integer) : "Puzzle Piece 3"
	puzzle_piece_4(integer) : "Puzzle Piece 4"	
	no_puzzle_msg(string) : "Puzzle message"
]
@SolidClass base(Appearflags) = trigger_no_friction : "Removes friction" []
@SolidClass base(trigger_multiple) = trigger_once : "Single trigger"
[
	style(integer) : "Light toggle style (33 - 63)"
	lightvalue1(integer) : "Low light value" : 0
	lightvalue2(integer) : "High light value" : 11
	fadespeed(string) : "Fade speed" : "0.5"
]
// just realized there is no point to trigger_onlyregistered in user created maps...
@SolidClass base(Trigger) = trigger_onlyregistered : "Registered trigger" []
@SolidClass base(Appearflags, Targetname) = trigger_push : "Push"
[
	spawnflags(Flags) =
	[
		1 : "push once" : 0
	]
	speed(integer) : "Speed of push"
]
@SolidClass base(Appearflags, Targetname, Target) = trigger_quake : "Quake! er...Earthquake!"
[
	spawnflags(Flags) =
	[
		1 : "do damage" : 0
		2 : "multiple" : 0
	]
	items(integer) : "Radius of quake"
	dmg(integer) : "Damage" : 5
	lifespan(integer) : "Duration" : 2
	wait(integer) : "Delay before quake" : 1
]
@SolidClass base(Appearflags) = trigger_reflect : "Missile reflector" 
[
	spawnflags(Flags) =
	[
		1 : "activate" : 0
	]
]
@PointClass base(Trigger) size(-8 -8 -8, 8 8 8) = trigger_relay : "Relay" []
@SolidClass base(Appearflags) = trigger_secret : "Secret trigger"
[
	soundtype(choices) : "Sounds" : 1 =
	[
		1 : "secret"
		2 : "beep beep"
	]
	message(string) : "Message"
]
@SolidClass base(Appearflags, Targetname) = trigger_setskill : "Set skill level"
[
        message(choices) : "Skill level" : 1 =
	[
		0 : "Easy"
		1 : "Medium"
		2 : "Hard"
		3 : "Nightmare!"
	]
]
@SolidClass base(Appearflags, Targetname, Target) = trigger_teleport : "Trigger teleport"
[
	spawnflags(flags) = 
	[ 
		1 : "player only" : 0 
		2 : "silent" : 0
		4 : "activate" : 0
	]
]
@SolidClass base(Appearflags) = trigger_teleport_newmap : "Trigger teleport to new map"
[
	target(string) : "New map name"
]

@PointClass base(Appearflags) = viewthing : "Debugging only, do not use" []
@SolidClass base(Appearflags) = weather_dust : "Dusty area" [ color(integer) : "Color" : 101 ]
@PointClass base(Appearflags, Targetname) = weather_lightning_end : "End of lightning bolt" []
@PointClass base(Appearflags, Targetname, Target) = weather_lightning_start : "Beginning of lighting"
[
	spawnflags(Flags) =
	[
		1 : "start off" : 0
		2 : "thunder sound" : 0
	]
	noise(choices) : "Sounds" : 2 =
	[
		1 : "no sound"
		2 : "lightning"
	]
	wait(choices) : "Time between strikes" : -1 =
	[
		-1 : "triggerable"
	]
	lifespan(integer) : "Duration"
]
@SolidClass base(Appearflags) = weather_rain : "Rain area"
[
	spawnflags(Flags) =
	[
		1 : "fall straight" : 0
		2 : "no splat" : 0
	]
	color(integer) : "Base color" : 414
	counter(integer) : "Density" : 300
	wait(string) : "Frequency" : "0.1"
	soundtype(choices) : "Sounds" : 1 =
	[
		0 : "rain"
		1 : "drip"
	]
]
@PointClass base(Appearflags, Targetname) size(-8 -8 -8, 8 8 8) = weather_sunbeam_end : "End of sunbeam" []
@PointClass base(Appearflags, Targetname, Target) = weather_sunbeam_start : "Start of sunbeam"
[
	spawnflags(Flags) =
	[
		1 : "start off" : 0
	]
	noise(choices) : "Sounds" : 2 =
	[
		1 : "no sound"
		2 : "lightning"
	]
	wait(choices) : "Time between strikes" : -1 =
	[
		-1 : "triggerable"
	]
	lifespan(integer) : "Duration"
]
@PointClass base(Appearflags, Target) size(-8 -8 -44, 8 8 20) = wp_weapon2 : "Weapon 2" 
[
	spawnflags(Flags) =
	[
		1 : "floating" : 0
	]
]
@PointClass base(wp_weapon2) = wp_weapon3 : "Weapon 3" []
@PointClass base(wp_weapon2) = wp_weapon4_head : "Weapon 4 head" []
@PointClass base(wp_weapon2) = wp_weapon4_staff : "Weapon 4 staff" []
