unit quake;
{
  pour rajouter des options :
    Dans Form1,
      ajouter le widget (Check box, editbox)
      callback onClick -> flag0Click

    Dans Quake.pas,
      ajouter la variable dans TQuakeGame
      dans SaveInfo, ajouter l'criture dans le fichier d'ini
      dans LoadInfo, ajouter la lecture dans le fichier d'ini
      dans CreateDmFlags, ajouter l'afectation de la structure TQuakeGame et
        la concatenation sur la ligne de commande.

    Dans Form3,
      ajouter le widget pour la langue, (editbox)
      dans bLoadClick, ajouer la ligne de chargement dans le fichier d'ini
      dans bSaveClick, ajouter la sauvegarde dans le fichier d'ini
      dans affecterLangage, ajouter l'affectation du caption de la form1
}
interface
uses windows, stdctrls, inifiles, sysutils;
type
  TQuakeGame = record
    dmflags : DWORD;
    path : string;
    game : string;
    exec : string;
    fragLimit : word;
    timeLimit : word;
    maxClient : word;
    playerName : string;
    IP         : string;
    dedi : boolean;
    dm   : boolean;
    coop : boolean;
    cheats : boolean;

  end;
type
  TFlags = record
    name : string;
    value : DWORD;
    checkbox : TCheckBox;
  end;

const
  MAXDMNUM = 31;
  KEY_SUPR = 46;
  KEY_ENTER = 13;
  KEY_ESCAPE = 27;
var
  DMFlags : array[0..MAXDMNUM] of TFlags;
  DMNum   : byte;
  MODIF   : boolean; // pour savoir si le fichier a ete modif, et sauvegarder en quittant
  MODIFYFLAG : shortint;
procedure SaveInfo(filename : string);
procedure LoadInfo(filename : string);
procedure DeleteFlags(f : byte);
function  CreateDMFlags : DWORD;
function  CreateCommandLine(var g : TQuakeGame) : string;
function getPathFromFile(p : string) : string;
implementation
uses unit1;

procedure SaveInfo(filename : string);
var
  ini : TIniFile;
  i : byte;
begin
    ini := TInifile.Create(filename);
 with form1 do
 begin
    ini.WriteString('GAME', 'Path', ePath.Text);
    ini.WriteString('GAME', 'Game', eGame.Text);
    ini.WriteString('GAME', 'Exec', eExec.Text);
    ini.WriteBool('GAME', 'Dedicated', cbDedi.Checked);
    ini.WriteBool('GAME', 'DeathMatch', cbDM.Checked);
    ini.WriteBool('GAME', 'Coop', cbCoop.Checked);
    ini.WriteString('GAME', 'FragLimit', eFragLimit.Text);
    ini.WriteString('GAME', 'TimeLimit', eTimeLimit.Text);
    ini.WriteString('GAME', 'MaxClients', eMaxClients.Text);
    ini.WriteString('GAME', 'PlayerName', ePlayerName.Text);
    ini.WriteString('GAME', 'IPServer', eIP.Text);
    ini.WriteBool('GAME', 'Cheats', cbCheats.Checked);
    for i := 0 to MAXDMNUM do
    // Sauvegarde des flags
    begin
      ini.WriteString('DMFLAGS', 'FlagName'+IntToStr(i), DMflags[i].name);
      ini.WriteInteger('DMFLAGS', 'FlagValue'+IntToStr(i), DMFLags[i].value);
      ini.Writebool('DMFLAGS', 'FlagChecked'+IntToStr(i), DMFlags[i].CheckBox.Checked);
    end;
 end;
 Form1.Caption := 'Q2L : ' + filename;
end;

procedure LoadInfo(filename:string);
var
  ini : TIniFile;
  i : byte;
begin
  ini := TIniFile.Create(filename);
  with form1 do
  begin
  ePath.Text := ini.ReadString('GAME', 'Path', '');
  eGame.Text := ini.ReadString('GAME', 'Game', '');
  eExec.Text := ini.ReadString('GAME', 'Exec', '');
  cbDedi.Checked := ini.ReadBool('GAME', 'Dedicated', false);
  cbDM.Checked := ini.ReadBool('GAME', 'DeathMatch', false);
  cbCoop.Checked := ini.ReadBool('GAME', 'Coop', false);
  eFragLimit.Text := ini.ReadString('GAME', 'FragLimit', '0');
  eTimeLimit.Text := ini.ReadString('GAME', 'TimeLimit', '0');
  eMaxClients.Text :=ini.ReadString('GAME', 'MaxClients', '0');
  ePlayerName.Text := ini.ReadString('GAME', 'PlayerName', '');
  eIP.Text := ini.ReadString('GAME', 'IPServer', '');
  cbCheats.Checked := ini.ReadBool('GAME', 'Cheats', false);
  for i := 0 to MAXDMNUM do
  begin
    DMFlags[i].name := ini.ReadString('DMFLAGS', 'FlagName'+intToStr(i), '');
    DMFlags[i].Value := ini.ReadInteger('DMFLAGS', 'FlagValue'+intToStr(i), 0);
    DMFlags[i].CheckBox.Checked := ini.ReadBool('DMFLAGS', 'FlagChecked'+IntToStr(i), false);
  end;
  DMnum := 0;
  for i := 0 to MAXDMNUM do
  begin
    if (DMFlags[i].name <> '') then
      inc(DMnum);
  end;
  end;
  Form1.Caption := 'Q2L : ' + filename;
  MODIF := false;
end;



procedure DeleteFlags(f : byte);
var
  i: byte;
begin
  DMFlags[f].name := '';
  DMFlags[f].value := -1;
  for i := f + 1 to MAXDMNUM do
  begin
    DMFlags[i-1].name := DMFlags[i].name;
    DMFlags[i-1].value := DMFlags[i].value;
    DMFlags[i-1].CheckBox.Checked :=DMFlags[i].CheckBox.Checked;
  end;
  dec(DMnum);
  MODIF := true;
end;

function getPathFromFile(p : string) : string;
var i : byte;
begin
  while (length(p) > 1) do
  begin
    if p[length(p)] = '\' then
      break
    else
      setlength(p, length(p) - 1);
  end;
  getPathFromFile := p;

end;

function  CreateDMFlags : DWORD;
var
  res : DWORD;
  i : byte;
begin
  res := 0;
  for i:=0 to DMNum do
  begin
    if DMFLags[i].Checkbox.Checked = true then res := res + DMFlags[i].Value;
  end;
  CreateDMFlags := res;
end;
function  CreateCommandLine(var g : TQuakeGame) : string;
var
  res : string;
begin
  res := '';
  with form1 do
  begin
  game.path := ePath.Text;
  game.game := eGame.Text;
  game.exec := eExec.Text;
  game.fragLimit := strToIntDef(eFragLimit.Text, 0);
  game.timeLimit := strToIntDef(eTimeLimit.Text, 0);
  game.maxClient := strToIntDef(eMaxClients.Text, 0);
  game.PlayerName := ePlayerName.Text;
  game.IP := eIP.Text;
  game.dedi := cbDedi.Checked;
  game.dm   := cbDM.Checked;
  game.dmflags := CreateDMFlags;
  game.coop := cbCoop.Checked;
  game.Cheats := cbCheats.Checked;
  end;

  with g do
  begin
//    if length(path)<>0 then res := res + path+' ';
    if length(game)<>0 then res := res + '+set game '+game+' ';
    if dm = true then res := res + '+set deathmatch 1 ';
    if coop = true then res := res + '+set coop 1 ';
    if dedi = true then res := res + '+set dedicated 1 ';
    if dmflags<>0 then res := res + '+set dmflags '+intToStr(dmflags) + ' ';
    if fragLimit<>0 then res := res + '+set fraglimit '+intToStr(fragLimit) + ' ';
    if TimeLimit<>0 then res := res + '+set timelimit '+intToStr(timeLimit) + ' ';
    if MaxClient<>0 then res := res + '+set maxclients '+intToStr(maxClient) + ' ';
    if playerName<>'' then res := res + '+set playername '+playerName+' ';
    if ip<>'' then res := res + '+connect ' + ip;
    if cheats = true then res := res + '+set cheats 1 ';
    if length(exec)<>0 then res := res + '+exec '+exec+' ';
  end;
  CreateCommandLine := res;
end;

end.
