diff -urN --exclude=*.$$$ c:\q2\game/g_cmds.c ./g_cmds.c
--- c:\q2\game/g_cmds.c	Tue Nov 25 05:31:16 1997
+++ ./g_cmds.c	Fri Dec 19 09:44:32 1997
@@ -588,6 +588,32 @@
 
 /*
 =================
+Cmd_Homing_f
+CCH: whole new command for adjusting homing missile state
+=================
+*/
+void Cmd_Homing_f (edict_t *ent)
+{
+	int		i;
+
+	i = atoi (gi.argv(1));
+
+	switch (i)
+	{
+	case 0:
+		gi.cprintf (ent, PRINT_HIGH, "Homing missiles off\n");
+		ent->client->pers.homing_state = 0;
+		break;
+	case 1:
+	default:
+		gi.cprintf (ent, PRINT_HIGH, "HOMING MISSILES ON\n");
+		ent->client->pers.homing_state = 1;
+		break;
+	}
+}
+
+/*
+=================
 ClientCommand
 =================
 */
@@ -633,6 +659,11 @@
 		Cmd_PutAway_f (ent);
 	else if (Q_stricmp (cmd, "wave") == 0)
 		Cmd_Wave_f (ent);
+
+	// CCH: new 'homing' command
+	else if (Q_stricmp (cmd, "homing") == 0)
+		Cmd_Homing_f (ent);
+
 	else if (Q_stricmp (cmd, "gameversion") == 0)
 	{
 		gi.cprintf (ent, PRINT_HIGH, "%s : %s\n", GAMEVERSION, __DATE__);
diff -urN --exclude=*.$$$ c:\q2\game/g_local.h ./g_local.h
--- c:\q2\game/g_local.h	Wed Nov 26 03:08:42 1997
+++ ./g_local.h	Fri Dec 19 09:44:32 1997
@@ -739,6 +739,10 @@
 	int			max_slugs;
 
 	gitem_t		*weapon;
+
+	// CCH: new persistant data
+	qboolean	homing_state;	// are homing missiles activated
+
 } client_persistant_t;
 
 // client data that staus across deathmatch respawns
diff -urN --exclude=*.$$$ c:\q2\game/g_weapon.c ./g_weapon.c
--- c:\q2\game/g_weapon.c	Fri Nov 28 19:39:30 1997
+++ ./g_weapon.c	Fri Dec 19 16:46:58 1997
@@ -552,6 +552,53 @@
 	G_FreeEdict (ent);
 }
 
+// CCH: New think function for homing missiles
+static void homing_think (edict_t *ent)
+{
+	edict_t	*target = NULL;
+	edict_t *blip = NULL;
+	vec3_t	targetdir, blipdir;
+	vec_t	speed;
+
+	while ((blip = findradius(blip, ent->s.origin, 1000)) != NULL)
+	{
+		if (!(blip->svflags & SVF_MONSTER) && !blip->client)
+			continue;
+		if (blip == ent->owner)
+			continue;
+		if (!blip->takedamage)
+			continue;
+		if (blip->health <= 0)
+			continue;
+		if (!visible(ent, blip))
+			continue;
+		if (!infront(ent, blip))
+			continue;
+		VectorSubtract(blip->s.origin, ent->s.origin, blipdir);
+		blipdir[2] += 16;
+		if ((target == NULL) || (VectorLength(blipdir) < VectorLength(targetdir)))
+		{
+			target = blip;
+			VectorCopy(blipdir, targetdir);
+		}
+	}
+		
+	if (target != NULL)
+	{
+		// target acquired, nudge our direction toward it
+		VectorNormalize(targetdir);
+		VectorScale(targetdir, 0.2, targetdir);
+		VectorAdd(targetdir, ent->movedir, targetdir);
+		VectorNormalize(targetdir);
+		VectorCopy(targetdir, ent->movedir);
+		vectoangles(targetdir, ent->s.angles);
+		speed = VectorLength(ent->velocity);
+		VectorScale(targetdir, speed, ent->velocity);
+	}
+
+	ent->nextthink = level.time + .1;
+}
+
 void fire_rocket (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage)
 {
 	edict_t	*rocket;
@@ -570,8 +617,26 @@
 	rocket->s.modelindex = gi.modelindex ("models/objects/rocket/tris.md2");
 	rocket->owner = self;
 	rocket->touch = rocket_touch;
-	rocket->nextthink = level.time + 8000/speed;
-	rocket->think = G_FreeEdict;
+
+	// CCH: see if this is a player and if they have homing on
+	if (self->client && self->client->pers.homing_state)
+	{
+		// CCH: if they have 5 cells, start homing, otherwise normal rocket think
+		if (self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] >= 5)
+		{
+			self->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= 5;
+			rocket->nextthink = level.time + .1;
+			rocket->think = homing_think;
+		} else {
+			gi.cprintf(self, PRINT_HIGH, "No cells for homing missile.\n");
+			rocket->nextthink = level.time + 8000/speed;
+			rocket->think = G_FreeEdict;
+		}
+	} else {
+		rocket->nextthink = level.time + 8000/speed;
+		rocket->think = G_FreeEdict;
+	}
+
 	rocket->dmg = damage;
 	rocket->radius_dmg = radius_damage;
 	rocket->dmg_radius = damage_radius;
diff -urN --exclude=*.$$$ c:\q2\game/p_client.c ./p_client.c
--- c:\q2\game/p_client.c	Wed Nov 26 03:10:10 1997
+++ ./p_client.c	Fri Dec 19 09:44:32 1997
@@ -254,6 +254,9 @@
 	client->pers.max_grenades	= 50;
 	client->pers.max_cells		= 200;
 	client->pers.max_slugs		= 50;
+
+	// CCH: initialize homing_state to off
+	client->pers.homing_state	= 0;
 }
 
 
