diff -urN --exclude=*.$$$ e:\q2\game/g_weapon.c ./g_weapon.c
--- e:\q2\game/g_weapon.c	Fri Nov 28 19:39:30 1997
+++ ./g_weapon.c	Sat Dec 20 19:01:02 1997
@@ -421,6 +421,14 @@
 	Grenade_Explode (ent);
 }
 
+// CCH: When a grenade 'dies', it blows up next frame
+static void Grenade_Die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
+{
+	self->takedamage = DAMAGE_NO;
+	self->nextthink = level.time + .1;
+	self->think = Grenade_Explode;
+}
+
 void fire_grenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
 {
 	edict_t	*grenade;
@@ -451,6 +459,15 @@
 	grenade->dmg_radius = damage_radius;
 	grenade->classname = "grenade";
 
+	// CCH: a few more attributes to let the grenade 'die'
+	VectorSet(grenade->mins, -3, -3, 0);
+	VectorSet(grenade->maxs, 3, 3, 6);
+	grenade->mass = 2;
+	grenade->health = 10;
+	grenade->die = Grenade_Die;
+	grenade->takedamage = DAMAGE_YES;
+	grenade->monsterinfo.aiflags = AI_NOSTEP;
+
 	gi.linkentity (grenade);
 }
 
@@ -486,6 +503,15 @@
 	grenade->spawnflags = 1;
 	grenade->s.sound = gi.soundindex("weapons/hgrenc1b.wav");
 
+	// CCH: a few more attributes to let the grenade 'die'
+	VectorSet(grenade->mins, -3, -3, 0);
+	VectorSet(grenade->maxs, 3, 3, 6);
+	grenade->mass = 2;
+	grenade->health = 10;
+	grenade->die = Grenade_Die;
+	grenade->takedamage = DAMAGE_YES;
+	grenade->monsterinfo.aiflags = AI_NOSTEP;
+
 	if (timer <= 0.0)
 		Grenade_Explode (grenade);
 	else
@@ -552,6 +578,38 @@
 	G_FreeEdict (ent);
 }
 
+// CCH: Explode rocket without touching anything
+static void Rocket_Explode (edict_t *ent)
+{
+	vec3_t		origin;
+
+	if (ent->owner->client)
+		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);
+
+	// calculate position for the explosion entity
+	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);
+
+	T_RadiusDamage(ent, ent->owner, ent->radius_dmg, NULL, ent->dmg_radius);
+
+	gi.WriteByte (svc_temp_entity);
+	if (ent->waterlevel)
+		gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
+	else
+		gi.WriteByte (TE_ROCKET_EXPLOSION);
+	gi.WritePosition (origin);
+	gi.multicast (ent->s.origin, MULTICAST_PVS);
+
+	G_FreeEdict (ent);
+}
+
+// CCH: When a rocket 'dies', it blows up next frame
+static void Rocket_Die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
+{
+	self->takedamage = DAMAGE_NO;
+	self->nextthink = level.time + .1;
+	self->think = Rocket_Explode;
+}
+
 void fire_rocket (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage)
 {
 	edict_t	*rocket;
@@ -576,6 +634,15 @@
 	rocket->radius_dmg = radius_damage;
 	rocket->dmg_radius = damage_radius;
 	rocket->s.sound = gi.soundindex ("weapons/rockfly.wav");
+
+	// CCH: a few more attributes to let the rocket 'die'
+	VectorSet(rocket->mins, -10, -3, 0);
+	VectorSet(rocket->maxs, 10, 3, 6);
+	rocket->mass = 2;
+	rocket->health = 10;
+	rocket->die = Rocket_Die;
+	rocket->takedamage = DAMAGE_YES;
+	rocket->monsterinfo.aiflags = AI_NOSTEP;
 
 	if (self->client)
 		check_dodge (self, rocket->s.origin, dir, speed);
