diff -urN --exclude=*.$$$ e:\q2\game/g_cmds.c ./g_cmds.c
--- e:\q2\game/g_cmds.c	Tue Nov 25 05:31:16 1997
+++ ./g_cmds.c	Fri Dec 19 23:45:10 1997
@@ -588,6 +588,26 @@
 
 /*
 =================
+Cmd_DetPipes_f
+CCH: new function to detonate all detpipes within 1000 units
+=================
+*/
+void Cmd_DetPipes_f (edict_t *ent)
+{
+	edict_t	*blip = NULL;
+
+	while ((blip = findradius(blip, ent->s.origin, 1000)) != NULL)
+	{
+		if (!strcmp(blip->classname, "detpipe") && blip->owner == ent)
+		{
+			blip->think = Grenade_Explode;
+			blip->nextthink = level.time + .1;
+		}
+	}
+}
+
+/*
+=================
 ClientCommand
 =================
 */
@@ -633,6 +653,11 @@
 		Cmd_PutAway_f (ent);
 	else if (Q_stricmp (cmd, "wave") == 0)
 		Cmd_Wave_f (ent);
+
+	// CCH: new detpipes command
+	else if (Q_stricmp (cmd, "detpipes") == 0)
+		Cmd_DetPipes_f (ent);
+
 	else if (Q_stricmp (cmd, "gameversion") == 0)
 	{
 		gi.cprintf (ent, PRINT_HIGH, "%s : %s\n", GAMEVERSION, __DATE__);
diff -urN --exclude=*.$$$ e:\q2\game/g_local.h ./g_local.h
--- e:\q2\game/g_local.h	Wed Nov 26 03:08:42 1997
+++ ./g_local.h	Fri Dec 19 23:14:16 1997
@@ -629,6 +629,7 @@
 void fire_bullet (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread);
 void fire_shotgun (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count);
 void fire_blaster (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, int effect);
+void Grenade_Explode (edict_t *ent);
 void fire_grenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
 void fire_grenade2 (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
 void fire_rocket (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage);
diff -urN --exclude=*.$$$ e:\q2\game/g_weapon.c ./g_weapon.c
--- e:\q2\game/g_weapon.c	Fri Nov 28 19:39:30 1997
+++ ./g_weapon.c	Fri Dec 19 23:14:16 1997
@@ -359,7 +359,7 @@
 fire_grenade
 =================
 */
-static void Grenade_Explode (edict_t *ent)
+void Grenade_Explode (edict_t *ent)
 {
 	vec3_t		origin;
 
@@ -445,11 +445,11 @@
 	grenade->s.modelindex = gi.modelindex ("models/objects/grenade/tris.md2");
 	grenade->owner = self;
 	grenade->touch = Grenade_Touch;
-	grenade->nextthink = level.time + timer;
+	grenade->nextthink = level.time + 60;
 	grenade->think = Grenade_Explode;
 	grenade->dmg = damage;
 	grenade->dmg_radius = damage_radius;
-	grenade->classname = "grenade";
+	grenade->classname = "detpipe";
 
 	gi.linkentity (grenade);
 }
@@ -478,11 +478,11 @@
 	grenade->s.modelindex = gi.modelindex ("models/objects/grenade2/tris.md2");
 	grenade->owner = self;
 	grenade->touch = Grenade_Touch;
-	grenade->nextthink = level.time + timer;
+	grenade->nextthink = level.time + 60;
 	grenade->think = Grenade_Explode;
 	grenade->dmg = damage;
 	grenade->dmg_radius = damage_radius;
-	grenade->classname = "grenade";
+	grenade->classname = "detpipe";
 	grenade->spawnflags = 1;
 	grenade->s.sound = gi.soundindex("weapons/hgrenc1b.wav");
 
