diff -urN --exclude=*.$$$ c:\q2\game/g_cmds.c ./g_cmds.c
--- c:\q2\game/g_cmds.c	Tue Nov 25 05:31:16 1997
+++ ./g_cmds.c	Wed Dec 31 10:42:16 1997
@@ -588,6 +588,45 @@
 
 /*
 =================
+Cmd_Airstrike_f
+CCH: new function to call in airstrikes
+=================
+*/
+void Cmd_Airstrike_f (edict_t *ent)
+{
+	vec3_t	start;
+	vec3_t	forward;
+	vec3_t	end;
+	trace_t	tr;
+
+	// make sure an airstrike hasn't already been called
+	if ( ent->client->airstrike_called )
+	{
+		gi.cprintf(ent, PRINT_HIGH, "The airstrike is already on its way.\n");
+		return;
+	}
+
+	// make sure we're pointed at the sky
+	VectorCopy(ent->s.origin, start);
+	start[2] += ent->viewheight;
+	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
+	VectorMA(start, 8192, forward, end);
+	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
+	if ( tr.surface && !(tr.surface->flags & SURF_SKY) )
+	{
+		gi.cprintf(ent, PRINT_HIGH, "Airstrikes have to come through the sky!\n");
+		return;
+	}
+
+	// set up for the airstrike
+	VectorCopy(tr.endpos, ent->client->airstrike_entry);
+	ent->client->airstrike_called = 1;
+	ent->client->airstrike_time = level.time + 30;
+	gi.cprintf(ent, PRINT_HIGH, "Airstrike en route, ETA 30 seconds. Light up target.\n");
+}
+
+/*
+=================
 ClientCommand
 =================
 */
@@ -633,6 +672,11 @@
 		Cmd_PutAway_f (ent);
 	else if (Q_stricmp (cmd, "wave") == 0)
 		Cmd_Wave_f (ent);
+
+	// CCH: new command for calling airstrikes
+	else if (Q_stricmp (cmd, "airstrike") == 0)
+		Cmd_Airstrike_f (ent);
+	
 	else if (Q_stricmp (cmd, "gameversion") == 0)
 	{
 		gi.cprintf (ent, PRINT_HIGH, "%s : %s\n", GAMEVERSION, __DATE__);
diff -urN --exclude=*.$$$ c:\q2\game/g_local.h ./g_local.h
--- c:\q2\game/g_local.h	Wed Nov 26 03:08:42 1997
+++ ./g_local.h	Wed Dec 31 10:42:16 1997
@@ -519,6 +519,10 @@
 void ChangeWeapon (edict_t *ent);
 void SpawnItem (edict_t *ent, gitem_t *item);
 void Think_Weapon (edict_t *ent);
+
+// CCH: new prototype for function called when airstrike arrives
+void Think_Airstrike (edict_t *ent);
+
 int ArmorIndex (edict_t *ent);
 int PowerArmorType (edict_t *ent);
 gitem_t	*GetItemByIndex (int index);
@@ -825,6 +829,12 @@
 	float		pickup_msg_time;
 
 	float		respawn_time;		// can respawn when time > this
+
+	// CCH: new variables for airstrikes
+	qboolean	airstrike_called;
+	vec3_t		airstrike_entry;
+	float		airstrike_time;
+
 } gclient_t;
 
 
diff -urN --exclude=*.$$$ c:\q2\game/game.h ./game.h
--- c:\q2\game/game.h	Thu Nov 20 23:22:14 1997
+++ ./game.h	Wed Dec 31 10:42:16 1997
@@ -1,7 +1,7 @@
 
 // game.h -- game dll information visible to server
 
-#define	GAME_API_VERSION	1
+#define	GAME_API_VERSION	2
 
 // edict->svflags
 
diff -urN --exclude=*.$$$ c:\q2\game/p_client.c ./p_client.c
--- c:\q2\game/p_client.c	Wed Nov 26 03:10:10 1997
+++ ./p_client.c	Wed Dec 31 10:42:16 1997
@@ -216,6 +216,9 @@
 		}
 	}
 
+	// CCH: Call off the airstrike
+	self->client->airstrike_called = 0;
+
 // FIXME once we have death frames
 //	self->deadflag = DEAD_DYING;
 	self->deadflag = DEAD_DEAD;
@@ -1074,6 +1077,12 @@
 		}
 	}
 
+	// CCH: Check to see if an airstrike has arrived
+	if ( client->airstrike_called && level.time > client->airstrike_time )
+	{
+		client->airstrike_called = 0;
+		Think_Airstrike (ent);
+	}
 
 }
 
diff -urN --exclude=*.$$$ c:\q2\game/p_weapon.c ./p_weapon.c
--- c:\q2\game/p_weapon.c	Thu Nov 27 01:05:20 1997
+++ ./p_weapon.c	Wed Dec 31 10:47:40 1997
@@ -244,6 +244,44 @@
 	}
 }
 
+/*
+=================
+Think_Airstrike
+CCH: This will bring the airstrike ordinance into existence in the game
+Called by ClientThink
+=================
+*/
+void Think_Airstrike (edict_t *ent)
+{
+	vec3_t	start;
+	vec3_t	forward;
+	vec3_t	end;
+	vec3_t	targetdir;
+	trace_t	tr;
+
+	// find the target point
+	VectorCopy(ent->s.origin, start);
+	start[2] += ent->viewheight;
+	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
+	VectorMA(start, 8192, forward, end);
+	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
+
+	// find the direction from the entry point to the target
+	VectorSubtract(tr.endpos, ent->client->airstrike_entry, targetdir);
+	VectorNormalize(targetdir);
+	VectorAdd(ent->client->airstrike_entry, targetdir, start);
+
+	// check to make sure we're not materializing in a solid
+	if ( gi.pointcontents(start) == CONTENTS_SOLID )
+	{
+		gi.cprintf(ent, PRINT_HIGH, "Airstrike intercepted en route.\n");
+		return;
+	}
+
+	// fire away!
+	fire_rocket(ent, start, targetdir, 600, 550, 600, 600);
+	gi.cprintf(ent, PRINT_HIGH, "Airstrike has arrived.\n");
+}
 
 /*
 ================
