// g_mds.c

#include "g_local.h"
#include "g_mds.h"

void copyright_msg (void)
{
	gi.bprintf(PRINT_HIGH, "              MDS(Quake2) Patch V1.00                \n");
	gi.bprintf(PRINT_HIGH, "              by James 'furn' Furness                \n");
	gi.bprintf(PRINT_HIGH, "            <James@furness1.demon.co.uk>             \n");
	gi.bprintf(PRINT_HIGH, "     http://www.furness1.demon.co.uk/quake/mds/      \n");
	gi.bprintf(PRINT_HIGH, "                                                     \n");
	gi.bprintf(PRINT_HIGH, " This File (mds.c) is copyright (c)1997 James Furness\n");
	gi.bprintf(PRINT_HIGH, "                                                     \n");
	gi.bprintf(PRINT_HIGH, "   Please read the license agreement in mds_q2.txt   \n");
	gi.bprintf(PRINT_HIGH, "               before using this patch.              \n");
	gi.bprintf(PRINT_HIGH, "                                                     \n");
	gi.bprintf(PRINT_HIGH, "For the latest version of this patch, please visit:  \n");
	gi.bprintf(PRINT_HIGH, " http://www.furness1.demon.co.uk/quake/mds/          \n");
    gi.bprintf(PRINT_HIGH, "                                                     \n");
	gi.bprintf(PRINT_HIGH, "For the Quake I version of this patch, please visit: \n");
	gi.bprintf(PRINT_HIGH, " http://www.furness1.demon.co.uk/quake/mds           \n");
	gi.bprintf(PRINT_HIGH, "                                   /q1_redirect.html \n");
	gi.bprintf(PRINT_HIGH, "                                                     \n");
	gi.bprintf(PRINT_HIGH, "       -- James Furness <James@furness1.demon.co.uk> \n");
}

static int	sound_fire;
static int	sound_pre_fire;
static int	sound_powerup;
static int	sound_spark1;
static int	sound_spark2;
static int	sound_spark3;
static int	sound_pwrdown;
static int	sound_pwrup;

/*
================
mds_die

Death Explosion
================
*/
extern void barrel_explode (edict_t *self);
void mds_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	char tempstr[80];

	self->takedamage = DAMAGE_NO;

	if (!self->fixed) {
		whereis(self, self->activator, tempstr, sizeof(tempstr));
		gi.cprintf(self->activator, PRINT_HIGH, "MDS (%s) : MDS defense compromised\n", tempstr);
	}

	gi.sound (self, CHAN_VOICE, sound_fire, 0, ATTN_NORM, 0);  // Shut up!
	gi.sound (self, CHAN_WEAPON, sound_fire, 0, ATTN_NORM, 0); // Shut up!

	barrel_explode (self);
}

/*
================
mds_pain

Shutdown if massive pain, e.t.c
================
*/
void mds_pain (edict_t *self, edict_t *other, float kick, int damage)
{
	int		r;
	vec3_t	laserOrigin, vecUp;

	self->nextthink = level.time + 20;

	r = rand() % 3;
	if (r == 0)
		gi.positioned_sound (self->s.origin, self, CHAN_WEAPON, sound_spark1, 1, ATTN_NORM, 0);
	else if (r  == 1)
		gi.positioned_sound (self->s.origin, self, CHAN_WEAPON, sound_spark2, 1, ATTN_NORM, 0);
	else
		gi.positioned_sound (self->s.origin, self, CHAN_WEAPON, sound_spark3, 1, ATTN_NORM, 0);

	VectorCopy (self->s.origin, laserOrigin);
	laserOrigin[2] += 46.0;

	VectorClear (vecUp);
	vecUp[2] = 90.0;

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_LASER_SPARKS);
	gi.WriteByte (16);
	gi.WritePosition (laserOrigin);
	gi.WriteDir (vecUp);
	gi.WriteByte (self->s.skinnum);
	gi.multicast (laserOrigin, MULTICAST_PVS);
	
	if (damage < (self->max_health * 0.05)) 
	{
		self->nextthink = level.time + FRAMETIME;
	}
	else if (damage < (self->max_health * 0.15)) 
	{
		self->nextthink = level.time + (FRAMETIME * 2);
	}
	else if (damage < (self->max_health * 0.25)) 
	{
		self->think = mds_pain_decharge;
		self->nextthink = level.time + FRAMETIME;
	}
	else
	{
		self->think = mds_pain_decharge;
		self->nextthink = level.time + FRAMETIME;
	}
}

void mds_pain_decharge (edict_t *self)
{
	gi.positioned_sound (self->s.origin, self, CHAN_VOICE, sound_pwrdown, 1, ATTN_NORM, 0);

	self->think = mds_pain_recharge;
	if (self->health > (self->max_health * 0.5))
		self->nextthink = level.time + 1;
	else
		self->nextthink = level.time + 2;
}

void mds_pain_recharge (edict_t *self)
{
	gi.positioned_sound (self->s.origin, self, CHAN_VOICE, sound_pwrup, 1, ATTN_NORM, 0);

	self->nextthink = level.time + 1;
	if (self->enemy != NULL) {
		if (self->enemy->mdslock = self)
			self->think = mds_fire;
		else
			self->think = mds_SearchForMissile;
	} else {
		self->think = mds_SearchForMissile;
	}
	self->nextthink = level.time + 1;
}

/*
================
mds_target_explode

Explodes dummy missile
================
*/
void slowRocket (vec3_t velocity, float scale)
{
	velocity[0] = velocity[0]*scale;
	velocity[1] = velocity[1]*scale;
}

void mds_rocket_orientate (edict_t *self)
// The object's propulsion has been knocked out, so
// plummet earthwards
{
	self->nextthink = level.time + (FRAMETIME * 2);

	if ((rand() % 5) == 0) // 20% chance of MDS having another stab
		self->think = mds_target_explode;
	else
		self->think = mds_rocket_orientate;

	slowRocket (self->velocity, 0.90); // speed -= 10%
	vectoangles (self->velocity, self->s.angles);
}

void mds_target_explode (edict_t *self)
{
	vec3_t	origin, laserOrigin;
	int		n;

	VectorCopy (self->mdslock->s.origin, laserOrigin);
	laserOrigin[2] += 46.0;
	// <BFG (again)>:
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BFG_LASER);
	gi.WritePosition (self->s.origin); // Other way round so both above and below water see something
	gi.WritePosition (laserOrigin);
	gi.multicast (self->s.origin, MULTICAST_PVS);
	// </BFG>

	// Anything with a movetype >=MOVETYPE_FLYMISSILE that creates slave entities 
	// must be entered here, for example the BFG and it's lasers. Those basing a 
	// patch on this take note!

	if (strcmp(self->mds_ex_classname, "rocket") == 0)
	{
		// How about a MDS that can knock out a rocket's
		// propulsion systems only, causing it to plunge earthward...
		if ((rand() % 4) == 0) // 25% chance of propulsion damage
		{
			self->movetype = MOVETYPE_TOSS;
			self->s.effects = EF_GRENADE;
			self->s.renderfx = RF_GLOW;

			self->nextthink = level.time + FRAMETIME;
			self->think = mds_rocket_orientate;

			slowRocket (self->velocity, 0.8); // speed -= 20%
			self->s.sound = NULL;
			gi.positioned_sound (self->s.origin, self, CHAN_WEAPON, gi.soundindex ("world/airhiss2.wav"), 1, ATTN_NORM, 0);

			vectoangles (self->velocity, self->s.angles);
			return;
		}
	}
	// else if (strcmp(self->mds_ex_classname, "Other entity...

	if (!deathmatch->value)
	{
		for(n=rand() % 3; n>=0; n--)
			ThrowDebris (self, "models/objects/debris2/tris.md2", 2, self->s.origin);
	}

	T_RadiusDamage(self, NULL, 40, NULL, 80, MOD_MDS_EXPLOSION);

	VectorMA (self->s.origin, -0.02, self->velocity, origin);
	gi.WriteByte (svc_temp_entity);

	// --- Explosion Realism, do correct explostion, else rocket explosion ---
	if (strcmp(self->mds_ex_classname, "bfg blast") == 0)
	{
		gi.WriteByte (TE_BFG_EXPLOSION);
	}
	else
	{
		if (self->waterlevel)
		{
			gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
		} else {
			gi.WriteByte (TE_ROCKET_EXPLOSION);
		}
	}
	gi.WritePosition (origin);
	gi.multicast (self->s.origin, MULTICAST_PVS);
	G_FreeEdict (self);
}

/*
================
mds_fire

Zap and explode missile
================
*/
//extern void target_laser_start (edict_t *self)
void mds_fire (edict_t *self)
{
	vec3_t	point, dir, start, end, vec, laserOrigin;
	edict_t *ignore;
	trace_t	tr;
	float	dist, range;
	char	tempstr[80];

	// Check target is still in range
	dist = 1000;

	VectorSubtract (self->enemy->s.origin, self->s.origin, vec);
	range = VectorLength (vec);

	if (self->MDS_AMMO_CELLS < 1) {
		if (!self->fixed) {
			if (!self->ammomsg) // Don't speak more than once
			{
				whereis(self, self->activator, tempstr, sizeof(tempstr));
				gi.cprintf(self->activator, PRINT_HIGH, "MDS (%s) : No Ammo!\n", tempstr);
				self->ammomsg = true;
			}
		}
		self->nextthink = level.time + FRAMETIME;
		self->think = mds_SearchForMissile;
		return;
	}

	if (!visible(self, self->enemy)) {
		self->nextthink = level.time + FRAMETIME;
		self->think = mds_SearchForMissile;
		return;
	}

	if (self->enemy->mdslock != self) { // Someone else has laid claim to this
		self->nextthink = level.time + FRAMETIME;
		self->think = mds_SearchForMissile;
		return;
	}

	self->enemy->mds_ex_classname = self->enemy->classname;
	self->enemy->classname = "mds target explosion";

	// --- Fire Lasers ---
	VectorMA (self->enemy->absmin, 0.5, self->enemy->size, point);

	VectorSubtract (point, self->s.origin, dir);
	VectorNormalize (dir);

	ignore = self;
	VectorCopy (self->s.origin, start);
	VectorMA (start, 2048, dir, end);
	while(1) // Check for entities in the way of our shot
	{
		tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);

		if (!tr.ent)
			break;

		// hurt it if we can
		if ((tr.ent->takedamage) && !(tr.ent->flags & FL_IMMUNE_LASER) && (tr.ent != self->owner))
			T_Damage (tr.ent, self, self->owner, dir, tr.endpos, vec3_origin, 5, 1, DAMAGE_ENERGY, MOD_MDS_LASER);

		// if we hit something that's not a monster or player we're done
		if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
		{
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_LASER_SPARKS);
			gi.WriteByte (4);
			gi.WritePosition (tr.endpos);
			gi.WriteDir (tr.plane.normal);
			gi.WriteByte (self->s.skinnum);
			gi.multicast (tr.endpos, MULTICAST_PVS);
			break;
		}

		ignore = tr.ent;
		VectorCopy (tr.endpos, start);
	}

	VectorCopy (self->s.origin, laserOrigin);
	laserOrigin[2] += 46.0;

	// Either BFG laser or railtrail...hard to choose between them, choose one and 
	// comment the other out...personally, I chose both :) Actually, a laser
	// with a rail wrapped around it looks quite good.
	// <RailTrail>:
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_RAILTRAIL);
	gi.WritePosition (laserOrigin);
	gi.WritePosition (self->enemy->s.origin);
	gi.multicast (laserOrigin, MULTICAST_PHS);
	// </RailTrail>
	// <BFG>:
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BFG_LASER);
	gi.WritePosition (laserOrigin);
	gi.WritePosition (self->enemy->s.origin);
	gi.multicast (laserOrigin, MULTICAST_PHS);
	gi.positioned_sound (self->s.origin, self, CHAN_WEAPON, sound_fire, 1, ATTN_NORM, 0); // Noise
	// </BFG>

	self->enemy->nextthink = level.time + FRAMETIME; // Take over enemy and force it to explode
	self->enemy->think = mds_target_explode;

	if (!self->infinite)	// If I have finite ammo, 
	{
		self->MDS_AMMO_CELLS--; // get rid of some!
	}

	self->enemy = NULL;
	self->nextthink = level.time + FRAMETIME;
	self->think = mds_SearchForMissile;
}

/*
================
mds_SearchForMissile

Find and fire!
================
*/
void mds_SearchForMissile (edict_t *self)
{
	float	dist, range;
	edict_t	*ent;
	vec3_t	vec;
	char	tempstr[80];

	self->s.effects &= ~(EF_COLOR_SHELL|EF_POWERSCREEN);
	self->s.renderfx &= ~(RF_SHELL_RED|RF_SHELL_GREEN|RF_SHELL_BLUE);

	if (self->MDS_AMMO_CELLS <= 0)
	{
		if (!self->fixed) {
			if (!self->ammomsg) // Don't speak more than once
			{
				whereis(self, self->activator, tempstr, sizeof(tempstr));
				gi.cprintf(self->activator, PRINT_HIGH, "MDS (%s) : No Ammo!\n", tempstr);
				self->ammomsg = true;
			}
		}
		return;
	}

	// Find the closest target within the current view of the player
	dist = 1000;
	self->enemy = world;
	ent = NULL;

	while ((ent = findradius(ent, self->s.origin, dist)) != NULL)
	{
		if(ent == self)
			continue;
		if(strcmp(ent->classname, "mds target explosion") == 0)
			continue;
		if(strcmp(ent->classname, "mds laser") == 0)
			continue;
		if(!visible(self, ent))
			continue;

		if(ent->movetype >= MOVETYPE_FLYMISSILE) {
			self->enemy = ent;
			break;
		}
	}

	// Target found
	if (self->enemy != world)
	{
		VectorSubtract (self->enemy->s.origin, self->s.origin, vec);
		range = VectorLength (vec);

		if (self->enemy->mdsfound)
		{
			if (self->enemy->mdsdist < range)	// Am I further away?
			{
				self->enemy = world;			// I am...sod this
				self->nextthink = level.time + FRAMETIME;
				self->think = mds_SearchForMissile;
				return;
			}
		}

		// I'm closer, let's lock on

		if (!self->enemy->mdsfound)
			self->enemy->mdsfound = true;

		gi.positioned_sound (self->s.origin, self, CHAN_VOICE, sound_pre_fire, 1, ATTN_NORM, 0);
		self->enemy->mdslock = self; // Lay claim to this
		self->enemy->mdsdist = range;
		// Removed - looks stupid
		//self->s.effects |= EF_COLOR_SHELL;
		//self->s.renderfx |= RF_SHELL_RED;
		self->nextthink = level.time + FRAMETIME;
		self->think = mds_fire;
	}
	else
	{
		self->nextthink = level.time + FRAMETIME;
		self->think = mds_SearchForMissile;
	}
}

/*
================
mds_powerup

Go online
================
*/
void mds_powerup (edict_t *self)
{
	gi.positioned_sound (self->s.origin, self, CHAN_VOICE, sound_powerup, 1, ATTN_NORM, 0);   

	self->nextthink = level.time + 2;
	self->think = mds_powerup2;
}

/*
================
mds_powerup2

Go online
================
*/
void mds_powerup2 (edict_t *self)
{
	gi.positioned_sound (self->s.origin, self, CHAN_VOICE, sound_pre_fire, 1, ATTN_NORM, 0);   

	self->nextthink = level.time + 1.45;
	self->think = mds_powerup3;
}

/*
================
mds_powerup3

Go online
================
*/
void mds_powerup3 (edict_t *self)
{
	char tempstr[80];

  	if (!self->fixed) {
		whereis(self, self->activator, tempstr, sizeof(tempstr));
		gi.cprintf(self->activator, PRINT_HIGH, "MDS (%s) : MDS online\n", tempstr);
	}
	gi.linkentity (self);
	self->nextthink = level.time + FRAMETIME;
	self->think = mds_SearchForMissile;
}

/*
================
dropmds

Throw MDS from player (DROPMDS)
================
*/
extern void barrel_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void dropmds (edict_t *self)
{
	vec3_t	forward, right, offset;
	edict_t *newmds;
	trace_t trace;
	int		speed = 400;
	int		ammo_idx;
	
	ammo_idx = ITEM_INDEX(FindItem("Cells"));

	if ( self->client->pers.inventory[ammo_idx] < 40 )
	{
		gi.cprintf(self, PRINT_HIGH, "You need 40 cells to drop a MDS\n");
		gi.positioned_sound (self->s.origin, self, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
		return;
	}

	//FIXME: Copy traceline function from Quake I version to check proximity to walls

	newmds = G_Spawn();

	newmds->activator = self; // 'activator' instead of 'owner' to keep MDS solid to everything.
	newmds->owner = NULL; // Solidify. And hope that the player's not standing in the same location.
	newmds->takedamage = DAMAGE_YES;
	newmds->movetype = MOVETYPE_STEP;
	newmds->solid = SOLID_BBOX;
	newmds->classname = "mds";
	newmds->health = 300;
	newmds->max_health = newmds->health;
	newmds->die = mds_die;
	newmds->pain = mds_pain;
	newmds->touch = barrel_touch;
	newmds->clipmask = MASK_PLAYERSOLID | CONTENTS_MONSTERCLIP;
	newmds->MDS_AMMO_CELLS = 30;
	newmds->fixed = false;
	newmds->ammomsg = false;
	newmds->infinite = false;
	newmds->mass = 800; // Don't let it be pushed around easily
	newmds->s.renderfx = RF_GLOW;

	newmds->s.modelindex = gi.modelindex ("models/weapons/g_mds/tris.md2");
	newmds->s.skinnum = 0;
	VectorSet (newmds->mins, -42, -42, 0);
	VectorSet (newmds->maxs, 42, 42, 63);
	VectorSet (newmds->size, 84, 84, 63);
	
	VectorCopy (newmds->s.origin, newmds->absmin);
	VectorCopy (newmds->s.origin, newmds->absmax);
    VectorAdd  (newmds->size,newmds->absmax,newmds->absmax);

	AngleVectors (self->client->v_angle, forward, right, NULL);
	VectorSet(offset, 24, 0, -20);
	G_ProjectSource (self->s.origin, offset, forward, right, newmds->s.origin);
	trace = gi.trace (self->s.origin, newmds->mins, newmds->maxs,
		newmds->s.origin, self, CONTENTS_SOLID);
	VectorCopy (trace.endpos, newmds->s.origin);

	VectorScale (forward, 100, newmds->velocity);
	newmds->velocity[2] = 300;

	newmds->s.event = EV_PLAYER_TELEPORT;	// Come on, what are we trying to pull? Something
											// taller and twice the mass of the player? From
											// a backpack? Let's make like we just beamed in.

	// Drop - FIXME: Toss, not drop
/*	AngleVectors (self->client->v_angle, forward, right, NULL);
	VectorSet(offset, 50, 0, -16);
	G_ProjectSource (self->s.origin, offset, forward, right, newmds->s.origin);
	trace = gi.trace (self->s.origin, NULL, NULL, newmds->s.origin, self, CONTENTS_SOLID);
	if (trace.allsolid)
	{
		gi.cprintf(self, PRINT_HIGH, "You are too close to a wall\n");
		G_FreeEdict (newmds);
		return;
	}
	VectorCopy (trace.endpos, newmds->s.origin);*/

	sound_fire			= gi.soundindex ("weapons/mdsfire.wav");
	sound_pre_fire		= gi.soundindex ("weapons/mdschrg.wav");	
	sound_powerup		= gi.soundindex ("weapons/mdspwrup.wav");
	sound_spark1		= gi.soundindex ("world/spark1.wav");
	sound_spark2		= gi.soundindex ("world/spark3.wav");
	sound_spark3		= gi.soundindex ("world/spark5.wav");
	sound_pwrup			= gi.soundindex ("misc/power1.wav");
	sound_pwrdown		= gi.soundindex ("world/fuseout.wav");

	self->client->pers.inventory[ammo_idx] -= 40;

	// Look for missile
	newmds->nextthink = level.time + FRAMETIME;
	newmds->think = mds_powerup;

	gi.linkentity (newmds);
}

/*QUAKED misc_mds (? ? ?) (-38 -38 -4) (38 38 85)
*/ //FIXME: DISABLED until I get a level editor so I can test this (Hurry up shareware worldcraft!)
   //       (Note to myself)	- Add to g_spawn.c
/*
void misc_mds (edict_t *self)
{
	newmds->activator = NULL; // None
	newmds->owner = NULL; // None
	newmds->takedamage = DAMAGE_YES;
	newmds->movetype = MOVETYPE_STEP;
	newmds->solid = SOLID_BBOX;
	newmds->classname = "mds";
	newmds->max_health = newmds->health;
	newmds->die = mds_die;
	newmds->pain = mds_pain;
	newmds->touch = barrel_touch;
	newmds->clipmask = MASK_PLAYERSOLID | CONTENTS_MONSTERCLIP;
	newmds->fixed = true;
	newmds->ammomsg = false;
	newmds->mass = 800; // Don't let it be pushed around easily
	newmds->s.renderfx = RF_GLOW;

	if (self->ammo == -1) {
		self->MDS_AMMO_CELLS = 50;
		self->infinite = true;
	} else {
		if (self->ammo > 0) {
			self->MDS_AMMO_CELLS = self.ammo;
			self->infinite = false;
		} else {
			self->MDS_AMMO_CELLS = 50;
			self->infinite = true;
		}
	}

	if (self->health = -1) {
		self->health = 5;
		self->takedamage = DAMAGE_NO;
	} else {
		if (self->health > 0) {
			self->takedamage = DAMAGE_YES;
		} else {
			self->health = 300;
			self->takedamage = DAMAGE_YES;
		}
	}
		
	// Look for missile
	newmds->nextthink = level.time + FRAMETIME;
	newmds->think = mds_powerup;

	newmds->s.modelindex = gi.modelindex ("models/weapons/g_mds/tris.md2");
	VectorSet (newmds->mins, -42, -42, 0);
	VectorSet (newmds->maxs, 42, 42, 63);
	VectorSet (newmds->size, 84, 84, 63);
	
	VectorCopy (newmds->s.origin, newmds->absmin);
	VectorCopy (newmds->s.origin, newmds->absmax);
    VectorAdd  (newmds->size,newmds->absmax,newmds->absmax);

	sound_fire			= gi.soundindex ("weapons/mdsfire.wav");
	sound_pre_fire		= gi.soundindex ("weapons/mdschrg.wav");	
	sound_powerup		= gi.soundindex ("weapons/mdspwrup.wav");
	sound_spark1		= gi.soundindex ("world/spark1.wav");
	sound_spark2		= gi.soundindex ("world/spark3.wav");
	sound_spark3		= gi.soundindex ("world/spark5.wav");
	sound_pwrup			= gi.soundindex ("misc/power1.wav");
	sound_pwrdown		= gi.soundindex ("world/fuseout.wav");

	gi.linkentity (self);
}*/

/*
================
whereis

Print location of checkpos from msg - used to tell you which 
of your MDSes just ran out of ammo/blew up.
================
*/
void whereis (edict_t *checkpos, edict_t *msg, char *outputstring, size_t outputlength)
{
	float tempfloat;
	vec3_t tempvect;
	vec3_t tempangs;

	VectorSubtract (checkpos->s.origin, msg->s.origin, tempvect);
	if (tempvect[2] < 0)
		tempfloat = -tempvect[2];
	else
		tempfloat = tempvect[2];
	Com_sprintf (outputstring, outputlength, "%i", tempfloat);
	strcat (outputstring, " metres ");

	if (tempvect[2] > 0) {
		strcat (outputstring, "above");
	} else {
		if (tempvect[2] < 0) {
			strcat (outputstring, "below");
		}
	}

	vectoangles (tempvect, tempangs);
	tempfloat = anglemod(tempangs[YAW]);

	if ((tempfloat <= 45) && (tempfloat >= 315))
	{
		strcat (outputstring, " and ahead");
	}
	else if ((tempfloat > 45) && (tempfloat < 135))
	{
		strcat (outputstring, " and to your left");
	}
	else if ((tempfloat >= 135) && (tempfloat <= 225))
	{
		strcat (outputstring, " and behind");
	}
	else if ((tempfloat > 225) && (tempfloat < 315))
	{
		strcat (outputstring, " and to your right");
	}
}


/*
================
mds_printhelp

Print help message
================
*/
void mds_printhelp (edict_t *self)
{
	gi.cprintf(self, PRINT_HIGH, "\n\n\nMDS Help\n=== ====\n  To fire an MDS, Type 'firemds'\n  at the console.\n\nYou may find it useful to bind this\nto a key by entering the following:\n  bind [KEY] \"firemds\"\nreplacing [KEY] with the desired key\n");
	return;
}
