#include "g_local.h"

edict_t *ent_by_name (char *target)
{
	int i;
	edict_t *targ=NULL;

	for (i=0;;i++)
	{
		if (i > globals.num_edicts)
			return (NULL);
		
		targ = G_Find (targ, FOFS(classname), "player");
		
		if (strcmp(targ->client->pers.netname, target) == 0)
			return (targ);
	}
}

int team_by_num (int team_num)
{
	int i;

	for (i=0;;i++)
	{
		if (i > level.num_teams)
			return 0;
		if (level.teams[i].team_num == team_num)
			return i;
	}
}

int team_by_name (char teamname[32])
{
	int i;

	for (i=0;;i++)
	{
		if (i > level.num_teams)
			return 0;
		if (strcmp(level.teams[i].teamname, teamname) == 0)
			return i;
	}
}

void create_team (edict_t *ent, int max_players, char teamname[32])
{	
	int i;

	if (level.num_teams <= 0)
		level.num_teams = 1;
	else
		level.num_teams++;
	
	for (i=1;;i++)
	{
		if (level.teams[i].team_num == 0)
			break;
	}

	if (max_players <= 0)
		level.teams[i].max_players = 16;
	else
		level.teams[i].max_players = max_players;
	
	level.teams[i].cur_players = 0;
	level.teams[i].team_num = i;
	sprintf(level.teams[i].teamname, "%s", teamname);

	gi.bprintf (PRINT_HIGH, "%s created team %s\n", ent->client->pers.netname, level.teams[i].teamname);
	
	ent->client->pers.team.team_num = level.teams[i].team_num;
	ent->client->pers.team.leader = true;
	ent->client->resp.score = 0;

	level.teams[i].cur_players++;
	level.teams[i].member[level.teams[i].cur_players] = ent->client;
	respawn (ent);
}

void join_team (edict_t *ent, int max_players, char teamname[32])
{	
	ent->client->pers.team.leader = false;
	ent->client->pers.team.prizm = false;

	if (team_by_name(teamname) == 0)
	{
		if (level.num_teams == 32)
		{
			gi.cprintf (ent, PRINT_HIGH, "There are too many teams created\n");
			return;
		}
		else
			create_team (ent, max_players, teamname);
	}
	else if (level.teams[team_by_name(teamname)].cur_players == level.teams[team_by_name(teamname)].max_players)
	{
		gi.cprintf (ent, PRINT_HIGH, "Team %s is full, choose another team\n", level.teams[team_by_name(teamname)].teamname);
		return;
	}
	else
	{
		ent->client->pers.team.team_num = level.teams[team_by_name(teamname)].team_num;
		ent->client->resp.score = 0;
		level.teams[team_by_num(ent->client->pers.team.team_num)].cur_players++;
		level.teams[team_by_num(ent->client->pers.team.team_num)].member[level.teams[team_by_num(ent->client->pers.team.team_num)].cur_players] = ent->client;
		gi.bprintf (PRINT_HIGH, "%s joined team %s\n",ent->client->pers.netname, teamname);
		respawn (ent);
	}
}

void part_team (edict_t *ent)
{
	int i;
	team_t team;

	if (ent->client->pers.team.team_num == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "You're not on a team!\n");
		return;
	}

	team = level.teams[team_by_num(ent->client->pers.team.team_num)];

	ent->client->pers.team.prizm = false;

	gi.bprintf (PRINT_HIGH, "%s left team %s\n",ent->client->pers.netname, team.teamname);
	if (team.cur_players - 1 == 0)
	{
		gi.bprintf (PRINT_HIGH, "Team %s is no more\n", team.teamname);		
		
		level.teams[team_by_num(ent->client->pers.team.team_num)].cur_players--;
		level.teams[team_by_num(ent->client->pers.team.team_num)] = level.teams[0];

		level.num_teams--;
		ent->client->pers.team.leader = false;
		ent->client->pers.team.team_num = 0;
		
		
		ent->solid = SOLID_NOT;
		ent->s.modelindex = 0;
		gi.linkentity (ent);

		return;
	}

	for (i=1;;i++)
	{
		if (strcmp(team.member[i]->pers.netname, ent->client->pers.netname) == 0)
		{
			if (ent->client->pers.team.leader == true)
			{
				level.teams[team_by_num(ent->client->pers.team.team_num)].member[i+1]->pers.team.leader = true;
				gi.bprintf (PRINT_HIGH, "%s is the new leader of team %s!\n", level.teams[team_by_num(ent->client->pers.team.team_num)].member[i+1]->pers.netname, team.teamname);
			}
			level.teams[team_by_num(ent->client->pers.team.team_num)].member[i] = team.member[0];
			
			if (i != team.cur_players)
			{
				level.teams[team_by_num(ent->client->pers.team.team_num)].member[i] = team.member[team.cur_players];
				level.teams[team_by_num(ent->client->pers.team.team_num)].member[team.cur_players] = team.member[0];
			}

			ent->client->pers.team.leader = false;
			level.teams[team_by_num(ent->client->pers.team.team_num)].cur_players--;
			ent->client->pers.team.team_num = 0;
		
			ent->solid = SOLID_NOT;
			ent->s.modelindex = 0;
			gi.linkentity (ent);

			return;
		}
	}
}
			
void teaminfo (char teamname[32], edict_t *ent)
{
	team_t team;
	int i;

	if (team_by_name(teamname) == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "Couldn't find team %s\n", teamname);
		return;
	}
	else team = level.teams[team_by_name(teamname)];

	gi.cprintf (ent, PRINT_HIGH, "Teamname: %s\n", team.teamname);
	gi.cprintf (ent, PRINT_HIGH, "Current players: %i\n", team.cur_players);
	gi.cprintf (ent, PRINT_HIGH, "Max players: %i\n", team.max_players);
	i=1;
	while (i<=team.cur_players)
	{
		if (team.member[i]->pers.team.leader == true)
			break;
		i++;
	}
	gi.cprintf (ent, PRINT_HIGH, "Leader: %s\n",team.member[i]->pers.netname);
	gi.cprintf (ent, PRINT_HIGH, "Members:\n");
	i=1;
	while (i<=team.cur_players)
	{
		gi.cprintf (ent, PRINT_HIGH, "%s - %d\n", team.member[i]->pers.netname, team.member[i]->resp.score);
		i++;
	}
}

void list_teams (edict_t *ent)
{
	int i;

	if (level.num_teams == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "There are no teams\n");
		return;
	}

	for (i=1;i<=level.num_teams;i++)
		gi.cprintf (ent, PRINT_HIGH, "%s\n", level.teams[i].teamname);
}

void kick_member (edict_t *ent, char target[16])
{
	int i;
	team_t team;
	edict_t *targ;

	if (target[0] == '\0')
	{
		gi.cprintf (ent, PRINT_HIGH, "Invalid parameters\n");
		return;
	}

	if (ent->client->pers.team.leader == false)
	{
		gi.cprintf (ent, PRINT_HIGH, "You have to be the team leader to kick\n");
		return;
	}
	
	if (strcmp(target, ent->client->pers.netname) == 0)
	{
		gi.cprintf (ent, PRINT_HIGH, "You can't kick yourself!\n");
		return;
	}

	team = level.teams[team_by_num(ent->client->pers.team.team_num)];

	for (i=1;;i++)
	{
		if (i > team.cur_players)
		{
			gi.cprintf (ent, PRINT_HIGH, "%s isn't on your team\n", target);
			return;
		}

		if (strcmp(team.member[i]->pers.netname, target) == 0)
			break;
	}
	
	targ = ent_by_name (team.member[i]->pers.netname);

	part_team (targ);
}
