diff -urN --exclude=*.$$$ e:\q2\game/g_local.h ./g_local.h
--- e:\q2\game/g_local.h	Wed Nov 26 03:08:42 1997
+++ ./g_local.h	Mon Dec 22 19:16:44 1997
@@ -462,6 +462,8 @@
 extern	cvar_t	*sv_cheats;
 extern	cvar_t	*maxclients;
 
+// CCH: New console variable
+extern	cvar_t	*coopexit;
 
 #define world	(&g_edicts[0])
 
diff -urN --exclude=*.$$$ e:\q2\game/g_main.c ./g_main.c
--- e:\q2\game/g_main.c	Wed Nov 26 23:31:16 1997
+++ ./g_main.c	Mon Dec 22 19:16:44 1997
@@ -44,6 +44,9 @@
 
 cvar_t	*sv_cheats;
 
+// CCH: New console variable
+cvar_t	*coopexit;
+
 void SpawnEntities (char *mapname, char *entities, char *spawnpoint);
 void ClientThink (edict_t *ent, usercmd_t *cmd);
 qboolean ClientConnect (edict_t *ent, char *userinfo, qboolean loadgame);
diff -urN --exclude=*.$$$ e:\q2\game/g_save.c ./g_save.c
--- e:\q2\game/g_save.c	Tue Nov 25 00:21:52 1997
+++ ./g_save.c	Mon Dec 22 19:16:44 1997
@@ -162,6 +162,9 @@
 	bob_pitch = gi.cvar ("bob_pitch", "0.002", 0);
 	bob_roll = gi.cvar ("bob_roll", "0.002", 0);
 
+	// CCH: New console variable
+	coopexit = gi.cvar("coopexit", "0", CVAR_SERVERINFO|CVAR_LATCH);
+
 	// items
 	InitItems ();
 
diff -urN --exclude=*.$$$ e:\q2\game/g_target.c ./g_target.c
--- e:\q2\game/g_target.c	Wed Nov 26 21:17:02 1997
+++ ./g_target.c	Mon Dec 22 20:41:56 1997
@@ -244,8 +244,29 @@
 */
 void use_target_changelevel (edict_t *self, edict_t *other, edict_t *activator)
 {
+	// CCH: A few local variables for coopexit
+	float	radius;
+	edict_t	*ent = NULL;
+	int		i;
+	vec3_t	v;
+
 	if (level.intermissiontime)
 		return;		// allready activated
+
+	// CCH: If coopexit is on, only exit when all players are at exit
+	if (coopexit->value)
+	{
+		radius = level.players * 100;
+		for (i=0 ; i<maxclients->value ; i++)
+		{
+			ent = g_edicts + 1 + i;
+			if (!ent->inuse || !ent->client)
+				continue;
+			VectorSubtract(activator->s.origin, ent->s.origin, v);
+			if (VectorLength(v) > radius)
+				return;
+		}
+	}
 
 	// if noexit, do a ton of damage to other
 	if (deathmatch->value && noexit->value && other != world)
diff -urN --exclude=*.$$$ e:\q2\game/p_client.c ./p_client.c
--- e:\q2\game/p_client.c	Wed Nov 26 03:10:10 1997
+++ ./p_client.c	Mon Dec 22 19:16:44 1997
@@ -735,6 +735,9 @@
 {
 	int		i;
 
+	// CCH: moved from ClientConnect() to here
+	level.players++;
+
 	if (deathmatch->value)
 	{
 		ClientBeginDeathmatch (ent);
@@ -855,7 +858,6 @@
 	if (game.maxclients > 1)
 		gi.dprintf ("%s connected\n", ent->client->pers.netname);
 
-	level.players++;
 	return true;
 }
 
