// m_monster.c	-- monster spawns

#include "g_local.h"

void SP_monster_berserk			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_gladiator		(edict_t *self) {G_FreeEdict (self);}
void SP_monster_gunner			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_infantry		(edict_t *self) {G_FreeEdict (self);}
void SP_monster_soldier_light	(edict_t *self) {G_FreeEdict (self);}
void SP_monster_soldier			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_soldier_ss		(edict_t *self) {G_FreeEdict (self);}
void SP_monster_tank			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_medic			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_flipper			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_chick			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_parasite		(edict_t *self) {G_FreeEdict (self);}
void SP_monster_flyer			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_brain			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_floater			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_hover			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_mutant			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_supertank		(edict_t *self) {G_FreeEdict (self);}
void SP_monster_boss2			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_jorg			(edict_t *self) {G_FreeEdict (self);}
void SP_monster_boss3_stand		(edict_t *self) {G_FreeEdict (self);}
void SP_monster_commander_body	(edict_t *self) {G_FreeEdict (self);}
void SP_misc_actor				(edict_t *self) {G_FreeEdict (self);}
void SP_target_actor			(edict_t *self) {G_FreeEdict (self);}
void SP_misc_insane				(edict_t *self) {G_FreeEdict (self);}

// g_turret.c		-- turret spawns
void SP_turret_breach			(edict_t *self)	{G_FreeEdict (self);}
void SP_turret_base				(edict_t *self)	{G_FreeEdict (self);}
void SP_turret_driver			(edict_t *self)	{G_FreeEdict (self);}

// g_misc.c			-- misc spawns
void SP_point_combat			(edict_t *self)	{G_FreeEdict (self);}
void SP_viewthing				(edict_t *self)	{G_FreeEdict (self);}
void SP_info_null				(edict_t *self)	{G_FreeEdict (self);}
void SP_info_notnull			(edict_t *self)	{G_FreeEdict (self);}
void SP_light					(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_easterchick		(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_eastertank			(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_easterchick2		(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_deadsoldier		(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_explobox			(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_viper				(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_bigviper			(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_viper_bomb			(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_strogg_ship		(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_satellite_dish		(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_gib_arm			(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_gib_leg			(edict_t *self)	{G_FreeEdict (self);}
void SP_misc_gib_head			(edict_t *self)	{G_FreeEdict (self);}

// g_target.c		-- target spawns
void SP_target_help				(edict_t *self)	{G_FreeEdict (self);}
void SP_target_secret			(edict_t *self)	{G_FreeEdict (self);}
void SP_target_goal				(edict_t *self)	{G_FreeEdict (self);}
void SP_target_spawner			(edict_t *self)	{G_FreeEdict (self);}
void SP_target_lightramp		(edict_t *self)	{G_FreeEdict (self);}

// p_client.c		-- coop spawn spots
static void SP_FixCoopSpots		(edict_t *self)	{G_FreeEdict (self);}
static void SP_CreateCoopSpots	(edict_t *self)	{G_FreeEdict (self);}
void SP_info_player_coop		(edict_t *self)	{G_FreeEdict (self);}



// =========================================================================
//  g_monster.c
// =========================================================================

void M_CheckGround (edict_t *ent)
{
	vec3_t		point;
	trace_t		trace;

	if (ent->flags & (FL_SWIM|FL_FLY))
		return;

	if (ent->velocity[2] > 100)
	{
		ent->groundentity = NULL;
		return;
	}

// if the hull point one-quarter unit down is solid the entity is on ground
	point[0] = ent->s.origin[0];
	point[1] = ent->s.origin[1];
	point[2] = ent->s.origin[2] - 0.25;

	trace = gi.trace (ent->s.origin, ent->mins, ent->maxs, point, ent, MASK_MONSTERSOLID);

	// check steepness
	if ( trace.plane.normal[2] < 0.7 && !trace.startsolid)
	{
		ent->groundentity = NULL;
		return;
	}

//	ent->groundentity = trace.ent;
//	ent->groundentity_linkcount = trace.ent->linkcount;
//	if (!trace.startsolid && !trace.allsolid)
//		VectorCopy (trace.endpos, ent->s.origin);
	if (!trace.startsolid && !trace.allsolid)
	{
		VectorCopy (trace.endpos, ent->s.origin);
		ent->groundentity = trace.ent;
		ent->groundentity_linkcount = trace.ent->linkcount;
		ent->velocity[2] = 0;
	}
}
