/**********************************************************
Quake2 Cluster Project
An addition and modification of iD Software's Quake2 shared 
library sources which enable Quake2 servers running this 
library to interconnect other servers which speak the 
protocol developed under the Quake2 Cluster Project.
Copyright (c) 1998 Justin Randall and Todd Bliss

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be 
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more 
details. You should have received a copy of the GNU General 
Public License along with this program; if not, write to 
the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, 
Boston, MA  02111-1307, USA.
**********************************************************/

/**********************************************************
*	$Log: udp.c,v $
*	Revision 1.2  1998/01/26 23:49:59  logic
*	Autolog commenting added to original source files.
*
*	Found bugs but not yet fixed:
*	Windows95 system resources are consumed over a period of time.
*	Links die after a period of time ( > 12 hours)
*
**********************************************************/

/* 
 * udp.c
 * udp library
 *
 */

#include <winsock.h>
#include "udp.h"




void SendMSG(char *pcRemoteAddr, int iPort, unsigned char *pcPacket, long lPacketLen) {
	SOCKET sock;
	struct sockaddr_in saLocal, saRemote;
	int err, i, iflag;
	unsigned long junk;
	struct hostent *pheDestination;
	unsigned char ucBuf[MAX_MSGLEN];

	WORD wVersionRequested;
	WSADATA wsaData;
	
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	if(WSAGetLastError() == WSANOTINITIALISED) {
		/* Need to start winsock services
		Gawd I hate Windows */
		wVersionRequested = MAKEWORD(1,1);
		err = WSAStartup(wVersionRequested, &wsaData);
		if(err == 0) {
			sock = socket(AF_INET, SOCK_DGRAM, 0);
		} else {
			closesocket(sock);
			return;
		}
	}

	saLocal.sin_family = AF_INET;
	saLocal.sin_addr.s_addr = htonl(INADDR_ANY);
	saLocal.sin_port = htons(0);

	err = bind(sock, (struct sockaddr *)&saLocal, sizeof(saLocal));
	if(err == 0) {
		
	} else {
		closesocket(sock);
		return;
	}

	/* Have to populate the saRemote sockaddr_in structure with a 
	 * valid address
	 */

	iflag = 0;
	for(i=0;i < (int)strlen(pcRemoteAddr); i++) {
		err = pcRemoteAddr[i];
		if(isalpha(err)) {
			iflag = 1;
		}
	}
	if(iflag == 1) {
		pheDestination = gethostbyname(pcRemoteAddr);
		if(pheDestination == NULL) {
			
		} else {
			memcpy(&saRemote.sin_addr, pheDestination->h_addr, pheDestination->h_length);
		}	
	} else {
		junk = inet_addr(pcRemoteAddr);
		if(junk == -1) {
			closesocket(sock);
			return;
		} else
			memcpy(&saRemote.sin_addr.s_addr, &junk, 4);
	}
		
	
	saRemote.sin_family = AF_INET;
	saRemote.sin_port = htons((short)iPort);
	memcpy(&ucBuf, pcPacket, lPacketLen + 1);
	err = sendto(sock, ucBuf, lPacketLen + 1, 0, (struct sockaddr *)&saRemote, sizeof(struct sockaddr_in));

	closesocket(sock);
	return;
}

SOCKET soListen(short iPort) {
	SOCKET sock;
	struct sockaddr_in saLocal;
	int err;
	WORD wVersionRequested;
	WSADATA wsaData;
	


	sock = socket(AF_INET, SOCK_DGRAM, 0);
	err = WSAGetLastError();
	if(err == WSANOTINITIALISED) {
		/* Need to start winsock services
		Gawd I hate Windows */
		
		wVersionRequested = MAKEWORD(1,1);
		err = WSAStartup(wVersionRequested, &wsaData);
		if(err == 0) {
			
			sock = socket(AF_INET, SOCK_DGRAM, 0);
		} else {
			
			return(-1);
		}
	} else if (err == WSAEADDRINUSE) {
		// already someone on this box listening on that addr
		return -2;
	}	
	
    saLocal.sin_family = AF_INET;
    saLocal.sin_addr.s_addr = htonl(INADDR_ANY);
    saLocal.sin_port = htons(iPort);

	err = bind(sock, (struct sockaddr *)&saLocal, sizeof(struct sockaddr_in));
	if(err != 0) {
		sock = -1;
	}
    return sock;    
}

int GetMSG(SOCKET sock, RecvMSG *rmIncoming) {
	int err, iSize, i;
	struct sockaddr_in saRemote;
	// RecvMSG rmIncoming;
	// unsigned char cBuffer[MAX_MSGLEN];



	for(i=0;i<MAX_MSGLEN;i++) {
		rmIncoming->cData[i] = '\0';
	}
	
	iSize = sizeof(struct sockaddr_in);	
	err = -1;
	
	err = recvfrom(sock, rmIncoming->cData, MAX_MSGLEN, 0, (struct sockaddr *)&saRemote, &iSize);
	//err = recvfrom(sock, cBuffer, MAX_MSGLEN, 0, (struct sockaddr *)&saRemote, &iSize);
	if(err)
		err--;
	rmIncoming->saRemote = saRemote;
	rmIncoming->lDataLen = (long)err;
	return 0;
}

