/* tab setting: 4
 * o_string.c
 *
 * 15 december 1997	jet@poboxes.com
 */

#include <stdio.h>
#include "g_local.h"
//#include "o_ini.h"
#include "o_string.h"
#include "iv_ini.h"

/*
 * Global variables
 */

string_t os;
config_t oc;

/*
 * Local functions
 */

qboolean o_boolean (char *file, char *section, char *key, qboolean def);
char *unescape (const char *string);

/*
 * Global functions
 */

/* o_initstring
 *
 * precache all the strings from the configuation file 'orange.ini'
 */

void o_initstring (char *file) {
//	char *file = "coop.ini";
	char *frag = "Frag";
	char *qfrag = "Quad Frag";
	char *dfrag = "%s was killed by %s\n";
	char *top = "Suicide";
	char *ftop = "Female Suicide";
	char *qtop = "Quad Suicide";
	char *fqtop = "Female Quad Suicide";
	char *dtop = "%s killed self.\n";
	char *environment = "Environment";
	char *fenvironment = "Female Environment";
	char *monsters = "Monsters";
	char *mfrag = "%s was killed by a monster\n";
	char *denv = "%s died.\n";

	ini_initialise();
	os.welcome = unescape (ini_key_value (file, "Main", "welcome", "welcome %s\n"));

	os.d_blaster		= strdup (ini_key_value (file, frag, "blaster", dfrag));
	os.d_shotgun		= strdup (ini_key_value (file, frag, "shotgun", dfrag));
	os.d_supershotgun	= strdup (ini_key_value (file, frag, "super shotgun", dfrag));
	os.d_machinegun		= strdup (ini_key_value (file, frag, "machine gun", dfrag));
	os.d_grenade		= strdup (ini_key_value (file, frag, "grenade", dfrag));
	os.d_rocket			= strdup (ini_key_value (file, frag, "rocket", dfrag));
	os.d_chaingun		= strdup (ini_key_value (file, frag, "chaingun", dfrag));
	os.d_railgun		= strdup (ini_key_value (file, frag, "railgun", dfrag));
	os.d_hyperblaster	= strdup (ini_key_value (file, frag, "hyperblaster", dfrag));
	os.d_bfg			= strdup (ini_key_value (file, frag, "bfg", dfrag));

	os.qd_blaster		= strdup (ini_key_value (file, qfrag, "blaster", os.d_blaster));
	os.qd_shotgun		= strdup (ini_key_value (file, qfrag, "shotgun", os.d_shotgun));
	os.qd_supershotgun	= strdup (ini_key_value (file, qfrag, "super shotgun", os.d_supershotgun));
	os.qd_machinegun	= strdup (ini_key_value (file, qfrag, "machine gun", os.d_machinegun));
	os.qd_grenade		= strdup (ini_key_value (file, qfrag, "grenade", os.d_grenade));
	os.qd_rocket		= strdup (ini_key_value (file, qfrag, "rocket", os.d_rocket));
	os.qd_chaingun		= strdup (ini_key_value (file, qfrag, "chaingun", os.d_chaingun));
	os.qd_railgun		= strdup (ini_key_value (file, qfrag, "railgun", os.d_railgun));
	os.qd_hyperblaster	= strdup (ini_key_value (file, qfrag, "hyperblaster", os.d_hyperblaster));
	os.qd_bfg			= strdup (ini_key_value (file, qfrag, "bfg", os.d_bfg));

	os.s_grenade		= strdup (ini_key_value (file, top, "grenade", dtop));
	os.s_rocket			= strdup (ini_key_value (file, top, "rocket", dtop));
	os.s_bfg			= strdup (ini_key_value (file, top, "bfg", dtop));

	os.fs_grenade		= strdup (ini_key_value (file, ftop, "grenade", os.s_grenade));
	os.fs_rocket		= strdup (ini_key_value (file, ftop, "rocket", os.s_rocket));
	os.fs_bfg			= strdup (ini_key_value (file, ftop, "bfg", os.s_bfg));

	os.qs_grenade		= strdup (ini_key_value (file, qtop, "grenade", os.s_grenade));
	os.qs_rocket		= strdup (ini_key_value (file, qtop, "rocket", os.s_rocket));
	os.qs_bfg			= strdup (ini_key_value (file, qtop, "bfg", os.s_bfg));

	os.fqs_grenade		= strdup (ini_key_value (file, fqtop, "grenade", os.fs_grenade));
	os.fqs_rocket		= strdup (ini_key_value (file, fqtop, "rocket", os.fs_rocket));
	os.fqs_bfg			= strdup (ini_key_value (file, fqtop, "bfg", os.fs_bfg));

//	os.qs_grenade		= strdup (os.qs_grenade);
//	os.qs_rocket		= strdup (os.qs_rocket);
//	os.qd_bfg			= strdup (os.qs_bfg);

	os.e_lava			= strdup (ini_key_value (file, environment, "lava", denv));
	os.e_slime			= strdup (ini_key_value (file, environment, "slime", denv));
	os.e_water			= strdup (ini_key_value (file, environment, "water", denv));
	os.e_fall			= strdup (ini_key_value (file, environment, "fall", denv));
	os.te_explosion		= strdup (ini_key_value (file, environment, "explosion", denv));
	os.te_blaster		= strdup (ini_key_value (file, environment, "blaster", denv));
	os.te_laser			= strdup (ini_key_value (file, environment, "laser", denv));

	os.fe_lava			= strdup (ini_key_value (file, fenvironment, "lava", os.e_lava));
	os.fe_slime			= strdup (ini_key_value (file, fenvironment, "slime", os.e_slime));
	os.fe_water			= strdup (ini_key_value (file, fenvironment, "water", os.e_water));
	os.fe_fall			= strdup (ini_key_value (file, fenvironment, "fall", os.e_fall));
	os.fte_explosion	= strdup (ini_key_value (file, fenvironment, "explosion", os.te_explosion));
	os.fte_blaster		= strdup (ini_key_value (file, fenvironment, "blaster", os.te_blaster));
	os.fte_laser		= strdup (ini_key_value (file, fenvironment, "laser", os.te_laser));

	os.m_tank			= strdup (ini_key_value (file, monsters, "tank", mfrag));
	os.m_supertank		= strdup (ini_key_value (file, monsters, "supertank", mfrag));
	os.m_soldier		= strdup (ini_key_value (file, monsters, "soldier", mfrag));
	os.m_parasite		= strdup (ini_key_value (file, monsters, "parasite", mfrag));
	os.m_mutant			= strdup (ini_key_value (file, monsters, "mutant", mfrag));
	os.m_medic			= strdup (ini_key_value (file, monsters, "medic", mfrag));
	os.m_infantry		= strdup (ini_key_value (file, monsters, "infantry", mfrag));
	os.m_hover			= strdup (ini_key_value (file, monsters, "hover", mfrag));
	os.m_gunner			= strdup (ini_key_value (file, monsters, "gunner", mfrag));
	os.m_gladiator		= strdup (ini_key_value (file, monsters, "gladiator", mfrag));
	os.m_flyer			= strdup (ini_key_value (file, monsters, "flyer", mfrag));
	os.m_float			= strdup (ini_key_value (file, monsters, "float", mfrag));
	os.m_flipper		= strdup (ini_key_value (file, monsters, "flipper", mfrag));
	os.m_chick			= strdup (ini_key_value (file, monsters, "chick", mfrag));
	os.m_brain			= strdup (ini_key_value (file, monsters, "brain", mfrag));
	os.m_berserk		= strdup (ini_key_value (file, monsters, "berserk", mfrag));
	os.m_actor			= strdup (ini_key_value (file, monsters, "actor", mfrag));


	ini_closedown();

	gi.dprintf (os.welcome);
}

/* o_initconfig
 *
 * set the configuration from config file
 */

void o_initconfig (char *file) {
//	char *file = "coop.ini";
	char *section = "Main";

	ini_initialise();

	oc.motd	= o_boolean (file, section, "motd", false);
	gi.dprintf("motd: %s\n", (oc.motd) ? "enabled" : "disabled");

	oc.centerprint = o_boolean (file, section, "centerprint", false);
	gi.dprintf("centerprint: %s\n", (oc.centerprint) ? "enabled" : "disabled");

	oc.turrets = o_boolean (file, section, "turrets", false);
	gi.dprintf("turrets: %s\n", (oc.turrets) ? "enabled" : "disabled");

	ini_closedown();
}

/* o_boolean
 *
 * converts a config file key true|false into a qboolean
 */

qboolean o_boolean (char *file, char *section, char *key, qboolean def) {
	char *tmp = ini_key_value (file, section, key, (def) ? "true" : "false");
	return (!strncmp (tmp, "true", 4));
}

/* unescape
 *
 * remove escape characters from string
 */

char *unescape( const char *string ) {
	int i, len, actual;
	char *buffer;

	if ( string == (const char *)NULL ) return (char *)NULL;
	i = actual = 0; len = strlen (string) + 1;
	buffer = (char *)malloc (len * sizeof( char ) );
	while ( i < len ) {
		if ( string[i] == '\\' ) {
			if ( i+1 < len ) {
				if (string[i+1] == 'n') {
					buffer[actual++] = '\n';
					i += 2;
					continue;
				}
			}
		}
		buffer[actual++] = string[i++];
	}
	if ( actual != len ) realloc( buffer, actual + 1 );
	return buffer;
}


/* end of file */
