#include "g_local.h"
#include "o_string.h"
#include "iv_ini.h"

// New Vars
cvar_t	*coop;
cvar_t	*deathmatch2;
//cvar_t	*item_respawn;
cvar_t	*grappling_hook;
cvar_t	*clusterserver;
cvar_t	*inven_persist;
cvar_t	*monsterplayers;
cvar_t	*teamplay;
cvar_t	*coopexit;
cvar_t	*scanner;
cvar_t	*fullscore;
// End New Vars

void COOP_vars(void)
{
	// New lached Vars
	coop = gi.cvar("coop", "0", CVAR_SERVERINFO|CVAR_LATCH);
	deathmatch2 = gi.cvar("deathmatch2", "0", CVAR_SERVERINFO|CVAR_LATCH);
	clusterserver = gi.cvar("clusterserver", "0", CVAR_NOSET);
	fullscore = gi.cvar("fullscore", "1", CVAR_SERVERINFO|CVAR_LATCH);

	// New change anytime vars
	grappling_hook = gi.cvar("grappling_hook", "1", CVAR_SERVERINFO);
//	item_respawn = gi.cvar("item_respawn", "0", CVAR_SERVERINFO);
	inven_persist = gi.cvar ("inven_persist", "0", CVAR_SERVERINFO);
	monsterplayers = gi.cvar ("monsterplayers", "0", 0);
	teamplay = gi.cvar ("teamplay", "0", CVAR_SERVERINFO);
	coopexit = gi.cvar("coopexit", "0", CVAR_SERVERINFO);
	scanner = gi.cvar("scanner", "1", CVAR_SERVERINFO);

	// No need for a pointer to these since they are accessed by userinfo

	gi.cvar ("team", "", CVAR_USERINFO | CVAR_ARCHIVE);
	gi.cvar ("centerfire", "1", CVAR_USERINFO | CVAR_ARCHIVE);
	gi.cvar ("gun_x", "1", CVAR_USERINFO | CVAR_ARCHIVE);
	gi.cvar ("gun_y", "1", CVAR_USERINFO | CVAR_ARCHIVE);
	gi.cvar ("gun_z", "1", CVAR_USERINFO | CVAR_ARCHIVE);
}

void COOP_ClientUserinfoChanged(edict_t *ent, char *userinfo)
{
	char	*s;

	s = Info_ValueForKey (userinfo, "centerfire");
	ent->client->pers.centerfire = atoi(s);

	s = Info_ValueForKey (userinfo, "gun_x");
	ent->client->pers.gun_x = atoi(s);

	s = Info_ValueForKey (userinfo, "gun_y");
	ent->client->pers.gun_y = atoi(s);

	s = Info_ValueForKey (userinfo, "gun_z");
	ent->client->pers.gun_z = atoi(s);

	s = Info_ValueForKey (userinfo, "team");
	if(strlen(s))
	{
		strncpy(ent->client->pers.teamname, s, 16);
	}

	// FIX FOV -- Not updating properly otherwise
	ent->client->ps.fov = atoi(Info_ValueForKey(userinfo, "fov"));
	if (ent->client->ps.fov < 1)
	ent->client->ps.fov = 90;
	else if (ent->client->ps.fov > 160)
	ent->client->ps.fov = 160;

	CheckOnPlayer(ent);

}

void COOP_Init(void)
{
	char file[128];
	char *filename = "coop.ini";
	cvar_t *gamedir;

	gamedir = gi.cvar("gamedir", NULL, 0);

	if(gamedir != NULL)
	{
		sprintf(file, "%s/%s", gamedir->string, filename);
	}
	else
		strcpy(file, filename);

	o_initstring(file);

	gi.dprintf("====COOP Init====\n");
	o_initconfig(file);

	COOP_print_cfg();

}

void COOP_print_cfg(void)
{
	if( !(gi.cvar ("developer", NULL, 0))->value )
		return;

	gi.dprintf("============ COOP Debug Settings ==============\n");
        gi.dprintf("MOTD: %d  Centerprint: %d  Turrets: %d\n",
				oc.motd, oc.centerprint, oc.turrets);
        gi.dprintf("\n\ Configured Death Messages: \n");
	gi.dprintf("Suicide Messages:\n");
	gi.dprintf("%s\n%s\n%s\n---\n", os.s_grenade, os.s_rocket, os.s_bfg);
	gi.dprintf("Female Suicide Messages:\n");
	gi.dprintf("%s\n%s\n%s\n---\n", os.fs_grenade, os.fs_rocket, os.fs_bfg);
	gi.dprintf("Quad Suicide Messages:\n");
	gi.dprintf("%s\n%s\n%s\n---\n", os.qs_grenade, os.qs_rocket, os.qs_bfg);
	gi.dprintf("Female Quad Suicide:\n");
	gi.dprintf("%s\n%s\n%s\n---\n", os.fqs_grenade, os.fqs_rocket, os.fqs_bfg);

	gi.dprintf("Death Messages:\n");
	gi.dprintf("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n---\n",
		os.d_blaster, os.d_shotgun, os.d_supershotgun, os.d_machinegun,
		os.d_grenade, os.d_rocket, os.d_chaingun, os.d_railgun,
		os.d_hyperblaster, os.d_bfg);
	gi.dprintf("Quad Death Messages:\n");
	gi.dprintf("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n---\n",
		os.qd_blaster, os.qd_shotgun, os.qd_supershotgun, os.qd_machinegun,
		os.qd_grenade, os.qd_rocket, os.qd_chaingun, os.qd_railgun,
		os.qd_hyperblaster, os.qd_bfg);

	gi.dprintf("Environmental Death Messages:\n");
	gi.dprintf("%s\n%s\n%s\n%s\n%s\n%s\n%s\n---\n", os.e_lava, os.e_slime, os.e_water, os.e_fall, os.te_explosion, os.te_blaster, os.te_laser);
	gi.dprintf("Female Environmental Death Messages:\n");
	gi.dprintf("%s\n%s\n%s\n%s\n%s\n%s\n%s\n---\n", os.fe_lava, os.fe_slime, os.fe_water, os.fe_fall, os.fte_explosion, os.fte_blaster, os.fte_laser);

	gi.dprintf("Monster Death Messages:\n");
	gi.dprintf("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n---\n",
		os.m_tank, os.m_supertank, os.m_soldier, os.m_parasite, os.m_mutant, os.m_medic,
		os.m_infantry, os.m_hover,  os.m_gunner, os.m_gladiator, os.m_flyer, os.m_float,
		os.m_flipper, os.m_chick, os.m_brain, os.m_berserk, os.m_actor);

	gi.dprintf("======================= End Coop config ===================\n");
}

void cmd_COOP_help_f(edict_t *ent);

int COOP_cmds(char *cmd, edict_t *ent)
{
	int retval=0;

	if (Q_stricmp (cmd, "hook") == 0)
	{
		if(grappling_hook->value)
	  		Cmd_Hook_f (ent);
		retval = 1;
	}
	else if (Q_stricmp (cmd, "zoom") == 0)
	{
	       int zoomtype=atoi(gi.argv(1));
	       if (zoomtype==0)
	       {
	               ent->client->ps.fov = 90;
	       }
	       else if (zoomtype==1)
	       {
	              if (ent->client->ps.fov == 90) ent->client->ps.fov = 40;
	              else if (ent->client->ps.fov == 40) ent->client->ps.fov = 20;
	              else if (ent->client->ps.fov == 20) ent->client->ps.fov = 10;
	              else ent->client->ps.fov = 90;
	       }
		retval = 1;
	}
	else if (Q_stricmp (cmd, "scanner") == 0)
	{
		Toggle_Scanner (ent);
		retval = 1;
	}
	else if (Q_stricmp (cmd, "aliases") == 0)
	{
		COOP_Alias(ent);
		retval = 1;
	}
	else if (Q_stricmp (cmd, "COOP_help") == 0)
	{
		cmd_COOP_help_f(ent);
		retval = 1;
	}

	return(retval);
}

void COOP_Alias(edict_t *ent)
{
	if(!ent->client->aliased)
	{
		gi.cprintf(ent, PRINT_HIGH, "Binding Aliases\n");
		stuffcmd (ent, "alias +hook \"cmd hook action; wait; cmd hook shrink\"\n");
		stuffcmd (ent, "alias -hook \"cmd hook stop\"\n");

		stuffcmd (ent, "alias +shrink \"cmd hook shrink\"\n");
		stuffcmd (ent, "alias -shrink \"cmd hook stop\"\n");

		stuffcmd (ent, "alias +grow \"cmd hook grow\"\n");
		stuffcmd (ent, "alias -grow \"cmd hook stop\"\n");

		stuffcmd (ent, "alias zoom_in \"cmd zoom 1\"\n");
		stuffcmd (ent, "alias zoom_out \"cmd zoom 0\"\n");
		ent->client->aliased=true;
	}
}

void COOP_MOTD(edict_t *ent)
{
	if (oc.motd)
   	{
		if (oc.centerprint)
	   		gi.centerprintf (ent, os.welcome );
	    else
	   		gi.cprintf (ent, PRINT_HIGH, os.welcome, ent->client->pers.netname);
	}
}

void COOP_ClientRules(void)
{
	char *line="--------------------------------------\n";
	char *enabled="enabled";
	char *disabled="disabled";
	cvar_t *dedicated;

	dedicated = gi.cvar("dedicated", NULL, 0);

	if(!dedicated->value && clusterserver->value)
	{
		gi.dprintf("Error: Cannot use clusterserver without dedicated.\n");
		gi.cvar_forceset("clusterserver", "0");
	}
	
	if(dedicated->value && clusterserver->value)
	{
		gi.cvar_forceset("coopexit","0");
	}

	if(deathmatch->value)
	{
		gi.dprintf("Multiplayer Game Started\n");
		if(!coop->value && !deathmatch2->value)
		{
			gi.dprintf(line);
			gi.dprintf("** No Mode set.  Starting Coop mode **\n");
			gi.dprintf(line);
			gi.cvar_forceset("coop", "1");
		}
		else
			gi.dprintf(line);

				gi.dprintf("Coop Mode: %s\n", (coop->value)? enabled:disabled);
		gi.dprintf("Deathmatch Mode: %s\n\n", (deathmatch2->value)? enabled:disabled);

		gi.dprintf("-------------------------\n");

	}
}

void cmd_COOP_help_f(edict_t *ent)
{
	char *enabled="enabled";
	char *disabled="disabled";

	gi.cprintf(ent, PRINT_HIGH, "========== COOP Settings ============\n");
	gi.cprintf(ent, PRINT_HIGH, "Cluster Server: %s\n", (clusterserver->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "Coop Game: %s\n", (coop->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "DeathMatch Game: %s\n", (deathmatch2->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "-------------------------------------\n\n");

	gi.cprintf(ent, PRINT_HIGH, "Coop Exit: %s\n", (coopexit->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "Allow Exit: %s\n", ((int)dmflags->value & DF_NO_EXIT)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "Grappling Hook: %s\n", (grappling_hook->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "Scanner: %s\n", (scanner->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "Inventory Persist: %s\n", (inven_persist->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "Full Score: %s\n", (fullscore->value)? enabled:disabled);
	gi.cprintf(ent, PRINT_HIGH, "======================================\n");
}

edict_t *SelectAlternateCoopSpawnPoint(void)
{
	edict_t	*spot = NULL;
	edict_t *spot1 = NULL;
	int		selection=0, count=0;

	spot1=NULL;
	//  Look for the single player start
	while ((spot1 = G_Find (spot1, FOFS(classname), "info_player_start")) != NULL)
	{
		if (!game.spawnpoint[0] && !spot1->targetname)
			break;

		if (!game.spawnpoint[0] || !spot1->targetname)
			continue;

		if (Q_stricmp(game.spawnpoint, spot1->targetname) == 0)
			break;
	}

	if(!spot1)
	{
		return NULL;
	}
	else
	{
		// If we found one, let's look for nearby coop spots.
		spot=NULL;
		while ((spot = findradius (spot ,spot1->s.origin, COOP_RANGE)) != NULL)
		{
			if((Q_stricmp(spot->classname, "info_player_coop")) != 0 )
				continue;
			count++;
		}

		if(!count)
		{
			return NULL;
		}

		count--;
		selection = rand() % count;
		selection++;

		count=0;
		spot=NULL;

		while((spot = findradius (spot, spot1->s.origin, COOP_RANGE)) != NULL)
		{
			if((Q_stricmp(spot->classname, "info_player_coop")) != 0 )
				continue;
			count++;

			if(count == selection)
			{
				break;
			}
		}
	}

	return spot;
}

edict_t *SelectRandomCoopSpawnPoint(void)
{
	edict_t	*spot=NULL;
	int		selection=0, count=0;

	while((spot = G_Find (spot, FOFS(classname), "info_player_coop")) != NULL)
	{
		count++;
	}

	if(!count)
	{
		gi.dprintf("Error: Could not find Coop Spawn point\n");
		return NULL;
	}

	selection = rand() % count;

	while((spot = G_Find (spot, FOFS(classname), "info_player_coop")) != NULL)
	{
		count++;
		if(count==selection)
			break;
	}

	return spot;
}

edict_t *COOP_SelectSpawnPoint(void)
{
	edict_t	*spot = NULL;
	edict_t	*spot1 = NULL;
	int		selection=0, count=0;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_coop")) != NULL)
	{

		if (!game.spawnpoint[0] && !spot->targetname)
			count++;

		if (!game.spawnpoint[0] || !spot->targetname)
			continue;

		if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
			count++;
	}
	if(!count)
		return NULL;

	selection = rand() % count;
	count=0;
	spot=NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_coop")) != NULL && count != selection)
	{

		if (!game.spawnpoint[0] && !spot->targetname)
		{
			count++;
			if(count==selection)
				break;
		}

		if (!game.spawnpoint[0] || !spot->targetname)
			continue;

		if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
		{
			count++;
			if(count==selection)
				break;
		}
	}
	return spot;
}


#ifndef cluster
/**********************************************************
	ValidateAdmin(edict_t *)

	This function checks if the client is an adminstrator.
	It looks at the client's password variable, and matches
	it against the servers admin_password variable. Returns
	1 if they match, 0 if they don't.

	Example:
	if(ValidateAdmin(client)) {
	  // Doing Admin stuff
	}
**********************************************************/
int ValidateAdmin(edict_t *admin) {
	char c_password[32] = {"\0"};
	cvar_t *admin_password;
	char s_password[32] = {"\0"};
	int retval;

	retval = 0;
	if(gi.cvar("admin_password", NULL, 0) == NULL) {
		gi.cvar_set("admin_password", "logic");
	}
	admin_password = gi.cvar("admin_password", NULL, 0);
	strcpy(s_password, admin_password->string);
	sprintf(c_password, "%s\0", admin->client->pers.password);
	if(strlen(c_password) && c_password != NULL) {
		if(stricmp(c_password, s_password) == 0) {
				retval = 1;
		}
	}
	return retval;
}

#endif
